#include "../dat/DAT_IGOR_DATA.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iomanip>

class MEM_igo_sco3_evis {
private:
   std::vector<std::string> o_Xh;       //column headers
   std::vector<std::string> o_XYalp;    //amino acid and orientation
public:
   MEM_igo_sco3_evis(int z):
      o_Xh((z+1)*3, "  "),
      o_XYalp((z+1)*256, "  ")
   {
   }
   std::string& Xh(int i,int j){
      return o_Xh.at( (i+1)*3 +j);  }
   std::string& XYalp(int i,int j){
      return o_XYalp.at( (i+1)*256 +(j+128));  }
};

void Igor_Model::IGO_SCO3_EVIS(const DAT_IGOR_DATA& igor_data,
                               Output_Streams& out,
                               int iM8,int iY8,
                               int lX,int uX,int lY,int uY){
//
//
// visualize sheet
//
   MEM_igo_sco3_evis vv(pU8);
//
   out.FILE3<<"   h   \n";
   out.FILE3<< std::fixed<< std::setprecision( 3);
   out.FILE3<<std::setw( 7)<<h<<'\n';
   for(int iZ8= 0;iZ8<pU8;iZ8++){
      int iX=Z8[iZ8].R0[ 0].X;
      int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
      int iG7=M8[iM8].S8[iS8].G7;
      int mR0=G7[iG7].mR0;
      int nR0=G7[iG7].nR0;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int jR0=(iR0-mR0);
         char a1=igor_data.L1[ R0[iR0].L1].a1;
         int iY=Z8[iZ8].R0[jR0].Y;
         if( Z8[iZ8].R0[jR0].sgnx== 1 ){
            vv.XYalp(iX,iY)=std::string("")+a1+'=';
         }else{
            vv.XYalp(iX,iY)=std::string("")+a1+' ';
            if( iX==lX ){
               vv.XYalp(iX- 1,iY)=" =";
            }
         }
      }
      char a1=( iS8<10 )? ' ': '1';
      char a0=char('0'+(iS8%10));
      vv.Xh(iX, 0)=std::string("")+a1+a0;
      if( Z8[iZ8].R0[ 0].sgny== 1 ){
         vv.Xh(iX, 2)="__";
      }else{
         vv.Xh(iX, 1)="__";
      }
   }
   out.FILE3<<"SHEET CONFIG\n";
   for(int iX=(lX- 1);iX<=uX;iX++){
      out.FILE3<<vv.Xh(iX, 0);
   }
   out.FILE3<<'\n';
   for(int iX=(lX- 1);iX<=uX;iX++){
      out.FILE3<<vv.Xh(iX, 1);
   }
   out.FILE3<<'\n';
   for(int iY=uY;iY>=lY;iY--){
      for(int iX=(lX- 1);iX<=uX;iX++){
         out.FILE3<<vv.XYalp(iX,iY);
      }
      out.FILE3<<'\n';
   }
   for(int iX=(lX- 1);iX<=uX;iX++){
      out.FILE3<<vv.Xh(iX, 2);
   }
   out.FILE3<<'\n';
   return;
}
