#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_igo_sco3_epen {
public:
   std::vector<bool> o_XYsub;   //occupied position of sheet
public:
   MEM_igo_sco3_epen():
      o_XYsub(14*64, false)
   {
   }
   void XYsub(int i,int j,bool a){
      o_XYsub[ (i+1)*64 +(j+32)]=a;  }
   bool XYsub(int i,int j){
      return o_XYsub[ (i+1)*64 +(j+32)];  }
};

Coordinates Igor_Model::IGO_SCO3_EPEN(const DAT_PHYSICS_CONSTS& physics_consts,
                                      const DAT_IGOR_DATA& igor_data,
                                      Output_Streams& out,
                                      int iM8,int iY8,
                                      std::vector<char>& o_Z8A,
                                      std::vector<char>& o_Z8B,
                                      std::vector<int>& o_XZ8){
   MEM_igo_sco3_epen vv;
   double eu( 0.00),ed( 0.00);
//
//
// penalize edge strand extensions
//
   int n=0;
   {
      int jZ8=o_XZ8[ 1];
      int jS8=U8[pU8].Y8[iY8].Z8[jZ8].S8;
      int jG7=M8[iM8].S8[jS8].G7;
      int iZ8=o_XZ8[ 0];
      int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
      int iG7=M8[iM8].S8[iS8].G7;
      int j=o_Z8B[jZ8];
      int iR0(-1),jR0(-1);
      if( j<0 ){
         j=-j;
         j=((j/2)-32);
         jR0=( j                        );
         iR0=( j-G7[jG7].nR0+G7[jG7].mR0);
      }else{
         j=((j/2)-32);
         iR0=( j                        );
         jR0=( j+G7[jG7].nR0-G7[jG7].mR0);
      }
      if( iR0< 0 )iR0= 0;
      if( jR0>(G7[iG7].nR0-G7[iG7].mR0) )jR0=(G7[iG7].nR0-G7[iG7].mR0);
      n+=( (G7[iG7].nR0-G7[iG7].mR0) -(jR0-iR0));
   }
   {
      int jZ8=o_XZ8[pU8- 2];
      int jS8=U8[pU8].Y8[iY8].Z8[jZ8].S8;
      int jG7=M8[iM8].S8[jS8].G7;
      int iZ8=o_XZ8[pU8- 1];
      int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
      int iG7=M8[iM8].S8[iS8].G7;
      int j=o_Z8A[jZ8];
      int iR0(-1),jR0(-1);
      if( j<0 ){
         j=-j;
         j=((j/2)-32);
         jR0=( j                        );
         iR0=( j-G7[jG7].nR0+G7[jG7].mR0);
      }else{
         j=((j/2)-32);
         iR0=( j                        );
         jR0=( j+G7[jG7].nR0-G7[jG7].mR0);
      }
      if( iR0< 0 )iR0= 0;
      if( jR0>(G7[iG7].nR0-G7[iG7].mR0) )jR0=(G7[iG7].nR0-G7[iG7].mR0);
      n+=( (G7[iG7].nR0-G7[iG7].mR0) -(jR0-iR0));
   }
   double epen0= (-1.25)*double( n);
//
//
// penalize deviation of observed slope from calculated slope
//
   double epen1= ( 0.00);
   double the= ( 0.00);
   if( pU8> 2 ){
      double w= ( 1.00e-4);
      double x= (0.00);
      double y= (0.00);
      for(int iZ8= 0;iZ8<pU8;iZ8++){
         int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
         int iG7=M8[iM8].S8[iS8].G7;
         int mR0=G7[iG7].mR0;
         int nR0=G7[iG7].nR0;
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int jR0=(iR0-mR0);
            int iL1=R0[iR0].L1;
            w+=(1.00);
            double xi= (5.)*double( Z8[iZ8].R0[jR0].X);
            double yi= (3.)*double( Z8[iZ8].R0[jR0].Y);
            x+=xi;
            y+=yi;
         }
      }
      x/=w;
      y/=w;
//
      double xx= (0.00);
      double xy= (0.00);
      for(int iZ8= 0;iZ8<pU8;iZ8++){
         int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
         int iG7=M8[iM8].S8[iS8].G7;
         int mR0=G7[iG7].mR0;
         int nR0=G7[iG7].nR0;
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int jR0=(iR0-mR0);
            double xi=( (5.)*double( Z8[iZ8].R0[jR0].X) -x);
            double yi=( (3.)*double( Z8[iZ8].R0[jR0].Y) -y);
            xx+=xi*xi;
            xy+=xi*yi;
         }
      }
//
      double d= std::sqrt( xx*xx +xy*xy);
      if( d>( 1.00e-6) ){
         double Cthe= (xx/d);
         double Sthe= (xy/d);
         the= std::atan2(Sthe,Cthe);
         the*=(8.)/physics_consts.PI;
         d=( the +h);
         epen1=-w*( .50)*d*d;
      }
   }
//
//
// penalize full chgs interior to boundary of sheet face
//
   for(int iZ8= 0;iZ8<pU8;iZ8++){
      int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
      int iG7=M8[iM8].S8[iS8].G7;
      int mR0=G7[iG7].mR0;
      int nR0=G7[iG7].nR0;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int jR0=(iR0-mR0);
         int iX=Z8[iZ8].R0[jR0].X;
         int iY=Z8[iZ8].R0[jR0].Y;
         vv.XYsub(iX,iY, true);
      }
   }
   int nu( 0),nd( 0);
   for(int iZ8= 0;iZ8<pU8;iZ8++){
      int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
      int iG7=M8[iM8].S8[iS8].G7;
      int mR0=G7[iG7].mR0;
      int nR0=G7[iG7].nR0;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int jR0=(iR0-mR0);
         int iX=Z8[iZ8].R0[jR0].X;
         int iY=Z8[iZ8].R0[jR0].Y;
         bool EDGE=( vv.XYsub(iX- 1,iY   )&&
                     vv.XYsub(iX+ 1,iY   )&&
                     vv.XYsub(iX   ,iY- 1)&&
                     vv.XYsub(iX   ,iY+ 1) )? false:  true;
         int iL1=R0[iR0].L1;
         int ihphob=igor_data.L1[iL1].hphob;
         int idoc=igor_data.L1[iL1].doc;
         bool FULLCHG=( ihphob==-2 );
         bool POLAR=( ihphob==-1 );
         bool HPHOB=( idoc> 0 );
         if( Z8[iZ8].R0[jR0].sgnx*
             Z8[iZ8].R0[jR0].sgny== 1 ){
            if( EDGE ){
               if( HPHOB )nu+=idoc;
            }else{
               if( FULLCHG ){
                  eu-=( 2.50);
                  nu+=ihphob;
               }else if( POLAR ){
                  eu-=( 1.25);
                  nu+=ihphob;
               }else{
                  nu+=idoc;
               }
            }
         }else{
            if( EDGE ){
               if( HPHOB )nd+=idoc;
            }else{
               if( FULLCHG ){
                  ed-=( 2.50);
                  nd+=ihphob;
               }else if( POLAR ){
                  eu-=( 1.25);
                  nd+=ihphob;
               }else{
                  nd+=idoc;
               }
            }
         }
      }
   }
   eu+= ( .32)*double( nu);
   ed+= ( .32)*double( nd);
//
//
// penalize sheet inconsistency with chain twist
//
   for(int iX= 0;iX<(pU8- 1);iX++){
      int iZ8=o_XZ8[iX];
      int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
      int iG7=M8[iM8].S8[iS8].G7;
      for(int jX=(iX+ 1);jX<pU8;jX++){
         int jZ8=o_XZ8[jX];
         int jS8=U8[pU8].Y8[iY8].Z8[jZ8].S8;
         int jG7=M8[iM8].S8[jS8].G7;
//
//
// select for triple of consecutive strands ehe, eeh, or hee
//
         bool EHE(false),EEH(false),HEE(false);
         int jEHE( 1),jEEH( 1),jHEE( 1);
         if      ( jG7==(iG7+ 4) ){
            if( G7[iG7+ 2].C70==1 ){ //(i_j)
               EHE=true;
               jEHE=Z8[iZ8].R0[ 0].sgny;
            }
         }else if( jG7==(iG7+ 2) ){ //(ij_)(_ij)
            if( (iG7+ 4)<oG7 ){
               if( G7[iG7+ 4].C70==1 ){
                  EEH=true;
                  jEEH=-Z8[jZ8].R0[ 0].sgny;
               }
            }
            if( (iG7- 2)>=0 ){
               if( G7[iG7- 2].C70==1 ){
                  HEE=true;
                  jHEE=-Z8[iZ8].R0[ 0].sgny;
               }
            }
         }else if( jG7==(iG7- 2) ){ //(ji_)(_ji)
            if( (iG7+ 2)<oG7 ){
               if( G7[iG7+ 2].C70==1 ){
                  EEH=true;
                  jEEH=Z8[iZ8].R0[ 0].sgny;
               }
            }
            if( (iG7- 4)>=0 ){
               if( G7[iG7- 4].C70==1 ){
                  HEE=true;
                  jHEE=Z8[jZ8].R0[ 0].sgny;
               }
            }
         }else if( jG7==(iG7- 4) ){ //(j_i)
            if( G7[iG7- 2].C70==1 ){
               EHE=true;
               jEHE=-Z8[iZ8].R0[ 0].sgny;
            }
         }
//
//
// add energy of chain twist for up and down faces
//
         if( EHE ){
// out.FILE3<<" EHE"
//          <<" sgn="<<std::setw( 2)<<jEHE
//          <<" (iX,jX)="<<std::setw( 2)<<iX
//                       <<std::setw( 2)<<jX
//          <<" (iG7,jG7)="<<std::setw( 2)<<iG7
//                         <<std::setw( 2)<<jG7;
            if      ( jEHE==-1 ){
               eu-=( 2.50);
               ed+=( 2.50);
// out.FILE3<<" eu="<<std::setw( 7)<<(-2.50)
//          <<" ed="<<std::setw( 7)<<( 2.50)<<'\n';
            }else if( jEHE== 1 ){
               eu+=( 2.50);
               ed-=( 2.50);
// out.FILE3<<" eu="<<std::setw( 7)<<( 2.50)
//          <<" ed="<<std::setw( 7)<<(-2.50)<<'\n';
            }
         }
         if( EEH ){ //no selection for up-right-H or up-down-H
// out.FILE3<<" EEH"
//          <<" sgn="<<std::setw( 2)<<jEEH
//          <<" (iX,jX)="<<std::setw( 2)<<iX
//                       <<std::setw( 2)<<jX
//          <<" (iG7,jG7)="<<std::setw( 2)<<iG7
//                         <<std::setw( 2)<<jG7;
            if      ( jEEH==-1 ){
// out.FILE3<<" eu="<<std::setw( 7)<<(-0.00)
//          <<" ed="<<std::setw( 7)<<( 0.00)<<'\n';
               eu-=( 0.00);
               ed+=( 0.00);
            }else if( jEEH== 1 ){
// out.FILE3<<" eu="<<std::setw( 7)<<( 0.00)
//          <<" ed="<<std::setw( 7)<<(-0.00)<<'\n';
               eu+=( 0.00);
               ed-=( 0.00);
            }
         }
         if( HEE ){
// out.FILE3<<" HEE"
//          <<" sgn="<<std::setw( 2)<<jHEE
//          <<" (iX,jX)="<<std::setw( 2)<<iX
//                       <<std::setw( 2)<<jX
//          <<" (iG7,jG7)="<<std::setw( 2)<<iG7
//                         <<std::setw( 2)<<jG7;
            if      ( jHEE==-1 ){
// out.FILE3<<" eu="<<std::setw( 7)<<(-2.50)
//          <<" ed="<<std::setw( 7)<<( 2.50)<<'\n';
               eu-=( 2.50);
               ed+=( 2.50);
            }else if( jHEE== 1 ){
// out.FILE3<<" eu="<<std::setw( 7)<<( 2.50)
//          <<" ed="<<std::setw( 7)<<(-2.50)<<'\n';
               eu+=( 2.50);
               ed-=( 2.50);
            }
         }
      }
   }
   double epen2= (( eu>ed )? eu: ed);
//
//
// diagnostic output
//
// out.FILE3<<std::fixed<<std::setprecision( 2);
// out.FILE3<<" edge strand extensions="<<std::setw( 1)<<n
//          <<" epen0="<<std::setw( 7)<<epen0<<'\n';
// out.FILE3<<" the="<<std::setw( 7)<<((  90.00)*the)
//          <<'['<<std::setw( 7)<<the<<']'
//          <<" h="<<std::setw( 7)<<h
//          <<" epen1="<<std::setw( 7)<<epen1<<'\n';
// out.FILE3<<" nu="<<std::setw( 2)<<nu
//          <<" nd="<<std::setw( 2)<<nd<<'\n';
// out.FILE3<<" eu="<<std::setw( 7)<<eu
//          <<" ed="<<std::setw( 7)<<ed
//          <<" epen2="<<std::setw( 7)<<epen2<<'\n';
// out.FILE3<<" epen="<<std::setw( 7)<<( epen0 +epen1 +epen2)<<'\n';
//
//
//
//
   Coordinates epen;
   epen(0)=( epen0 +epen1 +epen2);
   epen(1)= eu;
   epen(2)= ed;
   return epen;
}
