#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_igo_sco3_epck {
private:
   std::vector<int> o_O1hp;             //most hydrophob patch for twist
   std::vector<int> o_O1P3;             //pattern
   std::vector<int> o_O1R0;             //start of enclosing res subset
   std::vector<int> o_O1alt;            //alt surf over patch
   int oR0;                             //
   std::vector<bool> o_O1R0sub;         //included in patch for twist
   std::vector<char> o_XYlnk;           //amino acids populating dock config
   std::vector<Coordinates> o_Z8u;      //start res for strand of sheet
   std::vector<Coordinates> o_Z8v;      //end res
   std::vector<Coordinates> o_K4u;      //start res for elem of bod
   std::vector<Coordinates> o_K4v;      //end res
public:
   int oW4;                             //number
   std::vector<Igor_Model::tW4> W4;     //hydrophob patches on bods
   MEM_igo_sco3_epck(int o,int r,int z):
      o_O1hp(o, -9),
      o_O1P3(o, -1),
      o_O1R0(o, -1),
      o_O1alt(o, -1),
      oR0(r),
      o_O1R0sub(o*r, false),
      o_XYlnk(9*8, ' '),
      o_Z8u(z),
      o_Z8v(z),
      o_K4u(12),
      o_K4v(12)
   {
   }
   int& O1hp(int i){
      return o_O1hp.at( i);  }
   int& O1P3(int i){
      return o_O1P3.at( i);  }
   int& O1R0(int i){
      return o_O1R0.at( i);  }
   int& O1alt(int i){
      return o_O1alt.at( i);  }
   void O1R0sub(int i,int j,bool a){
      o_O1R0sub[ i*oR0 +j]=a;  }
   bool O1R0sub(int i,int j){
      return o_O1R0sub[ i*oR0 +j];  }
   char& XYlnk(int i,int j){
      return o_XYlnk.at( i*8 +j);  }
   Coordinates& Z8u(int i){
      return o_Z8u.at( i);  }
   Coordinates& Z8v(int i){
      return o_Z8v.at( i);  }
   Coordinates& K4u(int i){
      return o_K4u.at( i);  }
   Coordinates& K4v(int i){
      return o_K4v.at( i);  }
};

int Igor_Model::IGO_SCO3_EPCK(const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_IGOR_DATA& igor_data,
                              Output_Streams& out,
                              int iM8,int iY8,
                              int lX,int uX,int lY,int uY,
                              int lYup,int sgn){
   MEM_igo_sco3_epck vv(  8,oR0,pU8);
   bool FULLSHEET=( pU8==M8[iM8].oS8 );
//
//
// for each twist, find optimal hydrophobic patches
//
   vv.oW4=0;
   for(int iTER=0;iTER<4;iTER++){
      int iXmin=lX;
      int iYmin=lYup;
      for(int iO1= 4;iO1< 8;iO1++){
         int oP3=igor_data.O1[iO1].oP3;
         for(int iP3= 0;iP3<oP3;iP3++){
            int oR4=igor_data.O1[iO1].P3[iP3].oR4;
            int pX=((oR4- 1)/5);
            int pY=((oR4- 1)%5)*2;
            int iXmax=(uX-pX);
            int iYmax=(uY-pY);
            for(int iX=iXmin;iX<=iXmax;iX++){
               for(int iY=iYmin;iY<=iYmax;iY+=2){
                  int ihp=0;
                  int ialt=0;
                  int nJ4=0;
                  int n=0;
                  for(int iZ8= 0;iZ8<pU8;iZ8++){
                     int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
                     int iG7=M8[iM8].S8[iS8].G7;
                     int mR0=G7[iG7].mR0;
                     int nR0=G7[iG7].nR0;
                     for(int iR0=mR0;iR0<=nR0;iR0++){
                        int jR0=(iR0-mR0);
                        if( Z8[iZ8].R0[jR0].sgnx
                           *Z8[iZ8].R0[jR0].sgny==sgn ){
                           int gX=Z8[iZ8].R0[jR0].X*sgn;
                           int gY=Z8[iZ8].R0[jR0].Y;
                           if( gX<iX )continue;
                           if( gX>(iX+pX) )continue;
                           if( gY<iY )continue;
                           if( gY>(iY+pY) )continue;
                           int i=(gX-iX);
                           int j=((gY-iY)/2);
                           int iR4=( i*5 +j);
                           int iJ4=igor_data.O1[iO1].P3[iP3].R4J4[iR4];
                           if( iJ4>-1 ){
                              int iL1=R0[iR0].L1;
                              ihp+=igor_data.L1[iL1].doc;
                              i=igor_data.L1[iL1].alt;
                              if( i<0 )i=0;
                              j=(iJ4*2);
                              ialt+=(i<<j);
                              nJ4++;
                              if( vv.O1R0sub(iO1,iR0) )n++;
                           }
                        }
                     }
                  }
                  if( nJ4<igor_data.O1[iO1].P3[iP3].oJ4 )continue;
                  if( n>(igor_data.O1[iO1].P3[iP3].oJ4-2) )continue;
                  if( ihp>vv.O1hp(iO1) ){
                     vv.O1hp(iO1)=ihp;
                     vv.O1P3(iO1)=iP3;
                     vv.O1R0(iO1)=( (iX-lX)*(uY-lY+ 1) +(iY-lY));
                     vv.O1alt(iO1)=ialt;
                  }
               }
            }
         }
//       if( NATIVE&&FULLSHEET ){
//          out.FILE3<<" iO1="<<std::setw( 1)<<iO1
//                   <<" hp=" <<std::setw( 2)<<vv.O1hp(iO1)
//                   <<" iP3="<<std::setw( 2)<<vv.O1P3(iO1)
//                   <<" iR0="<<std::setw( 2)<<vv.O1R0(iO1)
//                   <<" iL=" <<std::setw( 7)<<vv.O1alt(iO1)<<'\n';
//       }
         if( vv.O1hp(iO1)< 5 )continue;
//
         int iP3=vv.O1P3(iO1);
         int ialt=vv.O1alt(iO1);
         int oJ4=igor_data.O1[iO1].P3[iP3].oJ4;
         int iL=0;
         int fac=1;
         for(int i=0;i<oJ4;i++){
            iL+=(ialt% 4)*fac;
            ialt>>=2;
            fac*=3;
         }
//
         vv.W4.push_back( tW4());
         vv.W4[vv.oW4].N=iTER+(1-sgn)*2;
         vv.W4[vv.oW4].J4.resize(oJ4);
         vv.W4[vv.oW4].oJ4=oJ4;
         vv.W4[vv.oW4].K4.resize(pU8);
         vv.W4[vv.oW4].oK4=pU8;
         int oR4=igor_data.O1[iO1].P3[iP3].oR4;
         int pX=((oR4- 1)/5);
         int pY=((oR4- 1)%5)*2;
         int iX=( lX +(vv.O1R0(iO1)/(uY-lY+ 1)));
         int iY=( lY +(vv.O1R0(iO1)%(uY-lY+ 1)));
         for(int iZ8= 0;iZ8<pU8;iZ8++){
            int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
            int iG7=M8[iM8].S8[iS8].G7;
            int mR0=G7[iG7].mR0;
            int nR0=G7[iG7].nR0;
            for(int iR0=mR0;iR0<=nR0;iR0++){
               int jR0=(iR0-mR0);
               if( Z8[iZ8].R0[jR0].sgnx
                  *Z8[iZ8].R0[jR0].sgny==sgn ){
                  int gX=Z8[iZ8].R0[jR0].X*sgn;
                  int gY=Z8[iZ8].R0[jR0].Y;
                  if( gX<iX )continue;
                  if( gX>(iX+pX) )continue;
                  if( gY<iY )continue;
                  if( gY>(iY+pY) )continue;
                  int i=(gX-iX);
                  int j=((gY-iY)/2);
                  int iR4=( i*5 +j);
                  int iJ4=igor_data.O1[iO1].P3[iP3].R4J4[iR4];
                  if( iJ4>-1 ){
                     vv.W4[vv.oW4].J4[iJ4].R0=iR0;
                     vv.W4[vv.oW4].J4[iJ4].a1=igor_data.L1[ R0[iR0].L1].a1;
                     vv.O1R0sub(iO1,iR0,true);
                  }
               }
            }
            vv.W4[vv.oW4].K4[iZ8].G7=iG7;
            vv.W4[vv.oW4].K4[iZ8].X=(Z8[iZ8].R0[ 0].X*sgn-lX);
            vv.W4[vv.oW4].K4[iZ8].Y=(Z8[iZ8].R0[ 0].Y-lY);
            vv.W4[vv.oW4].K4[iZ8].sgnx=Z8[iZ8].R0[ 0].sgnx*sgn;
            vv.W4[vv.oW4].K4[iZ8].sgny=Z8[iZ8].R0[ 0].sgny;
         }
         vv.W4[vv.oW4].O1=iO1;
         vv.W4[vv.oW4].hp=vv.O1hp(iO1);
         vv.W4[vv.oW4].P3=vv.O1P3(iO1);
         vv.W4[vv.oW4].R0=vv.O1R0(iO1);
         vv.W4[vv.oW4].L=iL;
         vv.W4[vv.oW4].h= h*double( sgn);
         vv.W4[vv.oW4].PAR=PARALLEL;
         vv.W4[vv.oW4].oX=(uX-lX+ 1);
         vv.W4[vv.oW4].oY=(uY-lY+ 1);
         vv.oW4++;
//
         vv.O1hp(iO1)=-9;
         vv.O1P3(iO1)=-1;
         vv.O1R0(iO1)=-1;
         vv.O1alt(iO1)=-1;
      }
   }
//
//
// pack energy with patches on helicies and previously accumulated sheets
//
   int epck=0;
   for(int iW4= 0;iW4<vv.oW4;iW4++){
      int iO1=vv.W4[iW4].O1;
      int iP3=vv.W4[iW4].P3;
      int m=vv.W4[iW4].oJ4;
      int iL=vv.W4[iW4].L;
//
      for(int jW4= 0;jW4<oW4;jW4++){
         int jO1=W4[jW4].O1;
         if( !igor_data.O1O1b(iO1,jO1) )continue;
         int jP3=W4[jW4].P3;
         int n=W4[jW4].oJ4;
         int jL=W4[jW4].L;
//
         int iLL=igor_data.J4J4LL(m,n);
         if( iLL==-1 )continue;
         for(int iD=0;iD<2;iD++){
            int iC8min=igor_data.LL[iLL].DC8a[iD];
            int iC8max=(iC8min+igor_data.LL[iLL].DcC8[iD]);
            for(int iC8=iC8min;iC8<iC8max;iC8++){
               int ipck=(igor_data.C8[iC8].LLe(iL,jL)-64);
//
//             if( NATIVE&&FULLSHEET ){
//                out.FILE3<<" iO1="<<std::setw( 1)<<iO1
//                         <<" iP3="<<std::setw( 2)<<iP3
//                         <<" iJ4="<<std::setw( 1)<<m
//                         <<" jW4="<<std::setw( 2)<<jW4
//                         <<" jO1="<<std::setw( 1)<<jO1
//                         <<" jP3="<<std::setw( 2)<<jP3
//                         <<" jJ4="<<std::setw( 1)<<n
//                         <<" iD="<<std::setw( 1)<<iD
//                         <<" iC8="<<std::setw( 2)<<iC8
//                         <<" ipck="<<std::setw( 3)<<ipck<<'\n';
//                for(int i=0;i<9;i++){
//                   for(int j=0;j<8;j++){
//                      vv.XYlnk(i,j)=' ';
//                   }
//                }
//                int imin=8;
//                int imax=0;
//                int jmin=7;
//                int jmax=0;
//                for(int iJ4=0;iJ4<m;iJ4++){
//                   int i=igor_data.C8[iC8].N2[ 0].J4[iJ4].X;
//                   int j=igor_data.C8[iC8].N2[ 0].J4[iJ4].Y;
//                   vv.XYlnk(i,j)=vv.W4[iW4].J4[iJ4].a1;
//                   if( i<imin )imin=i;
//                   if( i>imax )imax=i;
//                   if( j<jmin )jmin=j;
//                   if( j>jmax )jmax=j;
//                }
//                for(int jJ4=0;jJ4<n;jJ4++){
//                   int i=igor_data.C8[iC8].N2[ 1].J4[jJ4].X;
//                   int j=igor_data.C8[iC8].N2[ 1].J4[jJ4].Y;
//                   vv.XYlnk(i,j)=W4[jW4].J4[jJ4].a1;
//                   if( i<imin )imin=i;
//                   if( i>imax )imax=i;
//                   if( j<jmin )jmin=j;
//                   if( j>jmax )jmax=j;
//                }
//                for(int j=jmax;j>=jmin;j--){
//                   for(int i=imin;i<=imax;i++){
//                      out.FILE3<<vv.XYlnk(i,j);
//                   }
//                   out.FILE3<<'\n';
//                }
//             }
//
               if( ipck<(epck-1) )continue;
//
//
// angle, range=[   0, 180), to z axis of sheet from z axis of packed bod
//
               double bet=( igor_data.O1[iO1].P3[iP3].bet
                           +igor_data.O1[jO1].P3[jP3].bet)
                         +( igor_data.C8[iC8].N2[ 0].the
                           -igor_data.C8[iC8].N2[ 1].the);
               bet-=(floor( bet/physics_consts.PI)*physics_consts.PI);
               if      ( bet<(( .01)*physics_consts.PI) ){
                  bet= (( .01)*physics_consts.PI);
               }else if( bet>(( .99)*physics_consts.PI) ){
                  bet= (( .99)*physics_consts.PI);
               }
               double Cbet= std::cos( bet);
               double Sbet= std::sin( bet);
//
//
// angle, range=none, to z axis of sheet and bod 2 from z axis of pack config
//
               double nu1=( igor_data.C8[iC8].N2[ 0].the
                           +igor_data.O1[iO1].P3[iP3].bet
                           -( .50)*physics_consts.PI);
               double Cnu1= std::cos( nu1);
               double Snu1= std::sin( nu1);
               double nu2=( igor_data.C8[iC8].N2[ 1].the
                           -igor_data.O1[jO1].P3[jP3].bet
                           -( .50)*physics_consts.PI);
               double Cnu2= std::cos( nu2);
               double Snu2= std::sin( nu2);
//
//
// displacement of patch 2 wrt 1 in local coord systems of bods 1 and 2
//
               double y1=( Cnu1*igor_data.C8[iC8].dy
                          +Snu1*igor_data.C8[iC8].dz)*( .50);
               double z1=(-Snu1*igor_data.C8[iC8].dy
                          +Cnu1*igor_data.C8[iC8].dz)*( .50);
               double y2=(-Cnu2*igor_data.C8[iC8].dy
                          -Snu2*igor_data.C8[iC8].dz)*( .50);
               double z2=(-Snu2*igor_data.C8[iC8].dy
                          +Cnu2*igor_data.C8[iC8].dz)*( .50);
//
//
// angle, range=[   0, 180), of pattern axis to sheet axis
//
//       h            e
// 0[  25,  25] 4[  40,  59]
// 1[ 137, 137] 5[ 140, 157]
// 2[-102,  78] 6[  73, 121]
// 3[ -20,   4] 7[   0, 168]
//
               double omi= igor_data.O1[iO1].P3[iP3].bet;
               omi-=(floor( omi/physics_consts.PI)*physics_consts.PI);
               if      ( omi<(( .01)*physics_consts.PI) ){
                  omi= (( .01)*physics_consts.PI);
               }else if( omi>(( .99)*physics_consts.PI) ){
                  omi= (( .99)*physics_consts.PI);
               }
               double Comi= std::cos( omi);
               double Somi= std::sin( omi);
//
//
// filter for productive pack
//
               double del=( omi -bet);
               if      ( bet<( omi -( .50)*physics_consts.PI) ){
                  omi-=physics_consts.PI;
                  del=( bet -omi);
               }else if( bet>( omi +( .50)*physics_consts.PI) ){ //left twist
                  continue;
               }else if( bet<( omi +( .05)*physics_consts.PI) ){
               }else if( bet>( omi +( .45)*physics_consts.PI) ){
               }else{ //left twist
                  continue;
               }
               double Cdel= std::cos( del);
               double Sdel= std::sin( del);
//
//
// sheet twist
//
               double R= ( 8.75);
               if( PARALLEL )R+=( 2.00);
               if( jO1> 3 )R+=( 2.00);
               double alp= ( 5.00)*Sdel/(R*Somi);
               double d= ( 5.00)*Cdel/Somi;
               if( d< ( .25) )continue;
//
//
// endpoints of sheet strands
//
               int iX=(vv.W4[iW4].R0/vv.W4[iW4].oY)+lX;
               int iY=(vv.W4[iW4].R0%vv.W4[iW4].oY)+lY;
               for(int iZ8= 0;iZ8<pU8;iZ8++){
                  int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
                  int iG7=M8[iM8].S8[iS8].G7;
                  double i= double( Z8[iZ8].R0[ 0].X*sgn-iX)
                           +igor_data.O1[iO1].P3[iP3].dy/(5.)
                           -y1/(5.);
                  double z= double( Z8[iZ8].R0[ 0].Y-iY)*(3.)
                           +igor_data.O1[iO1].P3[iP3].dz
                           -z1
                           +i*( R*alp -(5.)*Cbet)/Sbet;
                  double Cialp= std::cos( i*alp);
                  double Sialp= std::sin( i*alp);
                  double dR0= double( G7[iG7].nR0 -G7[iG7].mR0)*(3.);
//
//
// position and direction of strand contact to packed bod cylinder
//
                  Coordinates t,c;
                  t(0)=( -igor_data.O1[iO1].P3[iP3].dx +R*( (1.) -Cialp));
                  t(1)=( i*d*Sbet +R*Cbet*Sialp);
                  t(2)=( i*d*Cbet -R*Sbet*Sialp);
                  c(0)= -Sbet*Sialp;
                  c(1)=( Cbet*Sbet*( (1.) -Cialp));
                  c(2)=( Cbet*Cbet +Sbet*Sbet*Cialp);
//
//
// endpoints of strand in sheet local system
//
                  Coordinates u,v;
                  u=( t +z*c);
                  v=( u +(dR0*Z8[iZ8].R0[ 0].sgny)*c);
//
//
// rotation to pack config
//
                  vv.Z8u(iZ8)=igor_data.O1[iO1].P3[iP3].C8[iC8].N2[ 0].r*u;
                  vv.Z8v(iZ8)=igor_data.O1[iO1].P3[iP3].C8[iC8].N2[ 0].r*v;
               }
//
//
// endpoints of packed bod elements
//
               if( jO1< 4 ){
                  int iG7=W4[jW4].K4[ 0].G7;
                  double gam=( igor_data.O1[jO1].P3[jP3].gam
                              +y2/(4.278));
                  double delz=( igor_data.O1[jO1].P3[jP3].dz
                               +z2);
                  double delx= igor_data.O1[jO1].P3[jP3].dx;
                  double dR0= double( G7[iG7].mR0-W4[jW4].R0);
                  double eta=( gam +dR0*physics_consts.PI/(1.80));
                  double Ceta= std::cos( eta);
                  double Seta= std::sin( eta);
                  Coordinates u,v;
                  u(0)=(-delx +(2.278)*Ceta);
                  u(1)= (2.278)*Seta;
                  u(2)=( delz +dR0*(1.50));
                  dR0= double( G7[iG7].nR0-W4[jW4].R0);
                  eta=( gam +dR0*physics_consts.PI/(1.80));
                  Ceta= std::cos( eta);
                  Seta= std::sin( eta);
                  v(0)=(-delx +(2.278)*Ceta);
                  v(1)= (2.278)*Seta;
                  v(2)=( delz +dR0*(1.50));
                  vv.K4u( 0)=igor_data.O1[jO1].P3[jP3].C8[iC8].N2[ 1].r*u;
                  vv.K4v( 0)=igor_data.O1[jO1].P3[jP3].C8[iC8].N2[ 1].r*v;
               }else{
//
//
// angle, range=[   0, 180), of pattern axis to sheet axis
//
                  omi= igor_data.O1[jO1].P3[jP3].bet;
                  omi-=(floor( omi/physics_consts.PI)*physics_consts.PI);
                  if      ( omi<(( .01)*physics_consts.PI) ){
                     omi= (( .01)*physics_consts.PI);
                  }else if( omi>(( .99)*physics_consts.PI) ){
                     omi= (( .99)*physics_consts.PI);
                  }
                  Comi= std::cos( omi);
                  Somi= std::sin( omi);
//
//
// filter for productive pack
//
                  del=( omi -bet);
                  if      ( bet<( omi -( .50)*physics_consts.PI) ){
                     omi-=physics_consts.PI;
                     del=( bet -omi);
                  }else if( bet>( omi +( .50)*physics_consts.PI) ){ //left twist
                     continue;
                  }else if( bet<( omi +( .05)*physics_consts.PI) ){
                  }else if( bet>( omi +( .45)*physics_consts.PI) ){
                  }else{ //left twist
                     continue;
                  }
                  Cdel= std::cos( del);
                  Sdel= std::sin( del);
//
//
// sheet twist
//
                  R= (10.75);
                  if( W4[jW4].PAR )R+=( 2.00);
                  alp= ( 5.00)*Sdel/(R*Somi);
                  d= ( 5.00)*Cdel/Somi;
                  if( d< ( .25) )continue;
//
//
// endpoints of sheet strands
//
                  iX=(W4[jW4].R0/W4[jW4].oY);
                  iY=(W4[jW4].R0%W4[jW4].oY);
                  int oK4=W4[jW4].oK4;
                  for(int jK4= 0;jK4<oK4;jK4++){
                     int iG7=W4[jW4].K4[jK4].G7;
                     double i= double( W4[jW4].K4[jK4].X-iX)
                              +igor_data.O1[jO1].P3[jP3].dy/(5.)
                              +y2/(5.);
                     double z= double( W4[jW4].K4[jK4].Y-iY)*(3.)
                              +igor_data.O1[jO1].P3[jP3].dz
                              +z2
                              +i*( R*alp -(5.)*Cbet)/Sbet;
                     double Cialp= std::cos( i*alp);
                     double Sialp= std::sin( i*alp);
                     double dR0= double( G7[iG7].nR0 -G7[iG7].mR0)*(3.);
//
//
// position and direction of strand contact to packed bod cylinder
//
                     Coordinates t,c;
                     t(0)=( -igor_data.O1[jO1].P3[jP3].dx +R*( (1.) -Cialp));
                     t(1)=( i*d*Sbet +R*Cbet*Sialp);
                     t(2)=( i*d*Cbet -R*Sbet*Sialp);
                     c(0)= -Sbet*Sialp;
                     c(1)=( Cbet*Sbet*( (1.) -Cialp));
                     c(2)=( Cbet*Cbet +Sbet*Sbet*Cialp);
//
//
// endpoints of strand in sheet local system
//
                     Coordinates u,v;
                     u=( t +z*c);
                     v=( u +(dR0*W4[jW4].K4[jK4].sgny)*c);
//
//
// rotation to pack config
//
                     vv.K4u(jK4)=igor_data.O1[jO1].P3[jP3].C8[iC8].N2[ 1].r*u;
                     vv.K4v(jK4)=igor_data.O1[jO1].P3[jP3].C8[iC8].N2[ 1].r*v;
                  }
               }
//
//
// chain connectivity constraint
//
               bool CONSISTENT=true;
               int oK4=W4[jW4].oK4;
               for(int iZ8= 0;iZ8<pU8&&( CONSISTENT);iZ8++){
                  int iS8=U8[pU8].Y8[iY8].Z8[iZ8].S8;
                  int iG7=M8[iM8].S8[iS8].G7;
                  for(int jK4= 0;jK4<oK4&&( CONSISTENT);jK4++){
                     int jG7=W4[jW4].K4[jK4].G7;
                     double d( 0.00),s( 0.00);
                     if      ( jG7>(iG7+ 2) ){
                        continue;
                     }else if( jG7<(iG7- 2) ){
                        continue;
                     }else if( jG7>(iG7   ) ){
                        d= double( G7[jG7].mR0-G7[iG7].nR0)*(3.10) +(2.10);
                        s=( vv.K4u(jK4) -vv.Z8v(iZ8)).r();
                     }else{
                        d= double( G7[iG7].mR0-G7[jG7].nR0)*(3.10) +(2.10);
                        s=( vv.Z8u(iZ8) -vv.K4v(jK4)).r();
                     }
//                   if( NATIVE&&FULLSHEET ){
//                      out.FILE3<<std::fixed<<std::setprecision( 3);
//                      out.FILE3<<" iG7="<<std::setw( 3)<<iG7
//                               <<" jG7="<<std::setw( 3)<<jG7
//                               <<" d="<<std::setw( 7)<<d
//                               <<" s="<<std::setw( 7)<<s<<'\n';
//                   }
                     if( d<s ){
                        CONSISTENT=false;
                     }else{
                        ipck+=int( (-1.00) +( 4.00)*( d -s)/d);
                     }
                  }
               }
               if( !CONSISTENT )continue;
//
               if( ipck>epck ){
                  epck=ipck;
//                if( NATIVE&&FULLSHEET ){
//                   out.FILE3<<"HIT:"
//                            <<" iO1="<<std::setw( 1)<<iO1
//                            <<" iP3="<<std::setw( 2)<<iP3
//                            <<" iJ4="<<std::setw( 1)<<m
//                            <<" iW4="<<std::setw( 2)<<jW4
//                            <<" jO1="<<std::setw( 1)<<jO1
//                            <<" jP3="<<std::setw( 2)<<jP3
//                            <<" jJ4="<<std::setw( 1)<<n
//                            <<" iD="<<std::setw( 1)<<iD
//                            <<" iC8="<<std::setw( 2)<<iC8
//                            <<" ipck="<<std::setw( 3)<<ipck<<'\n';
//                }
               }
//
            }
         }
      }
   }
   return epck;
}
