#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <cstdlib>
#include <iomanip>
#include <cmath>

bool Igor_Model::IGO_SCO3_EDOC(Output_Streams& out,
                               int pZ8,int lZ8,int lX,int lY){
//
//
// chain connectivity constraint
//
   int jR0=(Z8[pZ8].oR0- 1);
   if( (pU8< 5)||(std::abs( h)<( .15)) ){
      int gapy=std::abs( Z8[lZ8].R0[ 0].Y
                        -Z8[pZ8].R0[jR0].Y
                        +1);
      int gapx=( 1*(pU8- 1) +3);
      if( Z8[lZ8].R0[ 0].sgny==Z8[pZ8].R0[ 0].sgny ){
         gapx+=2;
      }
      if( mcha<(gapx+gapy) ){
         return true;
      }
//
   }else{
      double R= (8.75)/( std::abs( h)*(2.00) +(1.00e-3));
      if( PARALLEL )R*=(1.35);
      double dz= (1.)/std::sqrt( (2.));
      double dthe= dz/R;
//
      Coordinates u;
      double x= double( Z8[pZ8].R0[jR0].X-lX)*(5.);
      double y= double( Z8[pZ8].R0[jR0].Y-lY)*(3.);
      double z=( h>=(0.00) )? ( x +y)*dz: (-x +y)*dz;
      double the=( h>=(0.00) )? (-x +y)*dthe: ( x +y)*dthe;
      double Cthe= std::cos( the);
      double Sthe= std::sin( the);
      u(0)= R*Cthe;
      u(1)= R*Sthe;
      u(2)= z;
//
      Coordinates v;
      x= double( Z8[lZ8].R0[ 0].X-lX)*(5.);
      y= double( Z8[lZ8].R0[ 0].Y-lY)*(3.);
      z=( h>=(0.00) )? ( x +y)*dz: (-x +y)*dz;
      the=( h>=(0.00) )? (-x +y)*dthe: ( x +y)*dthe;
      Cthe= std::cos( the);
      Sthe= std::sin( the);
      v(0)= R*Cthe;
      v(1)= R*Sthe;
      v(2)= z;
//
      double d= double( mcha)*(2.70) +(1.70);
      double s=( v -u).r();
      if( NATIVE ){
         out.FILE3<<std::fixed<<std::setprecision( 3);
         out.FILE3<<" pZ8="<<std::setw( 1)<<pZ8
                  <<" lZ8="<<std::setw( 1)<<lZ8
                  <<" d="<<std::setw( 7)<<d
                  <<" s="<<std::setw( 7)<<s<<'\n';
      }
      if( d<s ){
         return true;
      }
//
   }
   return false;
}
