#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>

class MEM_igo_sco3_e2 {
public:
   std::vector<int> o_Z8E8;     //region of proto elem
   std::vector<int> o_Z8F8;     //bounds of proto elem
   std::vector<char> o_Z8X;     //x position in sheet
   std::vector<float> o_Z8e;    //energy of alignment resolved wrt strand
   std::vector<char> o_Z8A;     //alignment wrt following x
   std::vector<char> o_Z8B;     //alignment wrt previous x
   std::vector<int> o_XZ8;      //inverse map of Z8X
   std::vector<bool> o_XYsub;   //occupied position of sheet
   std::vector<int> o_Z8Z8;     //map of subset of strands to current set
   std::vector<int> o_Z8S8;     //map of subset to full set
   std::vector<int> o_Z8sub;    //map of current -subset to full set
public:
   MEM_igo_sco3_e2(int z):
      o_Z8E8(z),
      o_Z8F8(z),
      o_Z8X(z),
      o_Z8e(z),
      o_Z8A(z),
      o_Z8B(z),
      o_XZ8(z),
      o_XYsub(14*64, false),
      o_Z8Z8(z),
      o_Z8S8(z),
      o_Z8sub(z)
   {
   }
   int& Z8E8(int i){
      return o_Z8E8.at( i);  }
   int& Z8F8(int i){
      return o_Z8F8.at( i);  }
   char& Z8X(int i){
      return o_Z8X.at( i);  }
   float& Z8e(int i){
      return o_Z8e.at( i);  }
   char& Z8A(int i){
      return o_Z8A.at( i);  }
   char& Z8B(int i){
      return o_Z8B.at( i);  }
   int& XZ8(int i){
      return o_XZ8.at( i);  }
   void XYsub(int i,int j,bool a){
      o_XYsub[ (i+1)*64 +(j+32)]=a;  }
   bool XYsub(int i,int j){
      return o_XYsub[ (i+1)*64 +(j+32)];  }
   int& Z8Z8(int i){
      return o_Z8Z8.at( i);  }
   int& Z8S8(int i){
      return o_Z8S8.at( i);  }
   int& Z8sub(int i){
      return o_Z8sub.at( i);  }
};

bool Igor_Model::IGO_SCO3_E2(const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_ARRAY_CONSTS& array_consts,
                             const DAT_IGOR_DATA& igor_data,
                             Output_Streams& out,
                             int iM8){
//
//
// for each oZ-bod subsystem
//
   if( NATIVE ){
      out.FILE3<<std::setw( 2)<<pU8<<"-BOD CONFIGS\n";
   }
   MEM_igo_sco3_e2 vv(pU8);
   oI6=U8[pU8].oY8;
   I6.clear();
   I6.resize(oI6);
   int jI6=-1;
   int qU8=(pU8- 1);
   bool EMPTY=true;
   oY8=U8[qU8].oY8;
   for(int iY8= 0;iY8<(oY8- 1);iY8++){
      for(int jY8=(iY8+ 1);jY8<oY8;jY8++){
         int n=0;
         for(int iZ8= 0;iZ8<qU8;iZ8++){
            for(int jZ8= 0;jZ8<qU8;jZ8++){
               if( U8[qU8].Y8[jY8].Z8[jZ8].S8==
                   U8[qU8].Y8[iY8].Z8[iZ8].S8 )n++;
            }
         }
         if( n<(qU8- 1) )continue;
         int pZ8=-1;
         for(int iZ8= 0;iZ8<qU8;iZ8++){
            bool MATCH=false;
            for(int jZ8= 0;jZ8<qU8&&(!MATCH);jZ8++){
               if( U8[qU8].Y8[jY8].Z8[jZ8].S8==
                   U8[qU8].Y8[iY8].Z8[iZ8].S8 )MATCH=true;
            }
            if( !MATCH ){
               pZ8=iZ8;
               break;
            }
         }
         if( pZ8<(qU8- 1) )continue;
         jI6++;
//
//       out.FILE3<<"GROUP OF "
//                <<std::setw( 2)<<qU8
//                <<"-BOD SUBSYSTEMS=(";
//       for(int jZ8= 0;jZ8<pU8;jZ8++){
//          out.FILE3<<std::setw( 4)<<U8[pU8].Y8[jI6].Z8[jZ8].Y8
//                   <<(( jZ8<qU8 )? ',': ')');
//          }
//       }
//       out.FILE3<<'\n';
//
//
// restore from backup
//
         bool ADDRESSABLE=true;
         int ii=0;
         for(int iZ8= 0;iZ8<pU8&&( ADDRESSABLE);iZ8++){
            int iS8=U8[pU8].Y8[jI6].Z8[iZ8].S8;
            int iG7=M8[iM8].S8[iS8].G7;
            int iR0=G7[iG7].mR0;
            int jR0=G7[iG7].nR0;
            int ief=R0R0ef(iR0,jR0);
            if( ief>-1 ){
               vv.Z8E8(iZ8)=(ief/oF8);
               vv.Z8F8(iZ8)=(ief%oF8);
               if( iZ8> 0 ){
                  if( vv.Z8E8(iZ8   )>vv.Z8E8(iZ8- 1) ){
                     ii+=( vv.Z8F8(iZ8)<<(nF8*vv.Z8E8(iZ8)));
                  }else{
                     ADDRESSABLE=false;
                  }
               }else{
                  ii+=( vv.Z8F8(iZ8)<<(nF8*vv.Z8E8(iZ8)));
               }
            }else{
               ADDRESSABLE=false;
            }
         }
         if( ADDRESSABLE ){
            int pQ8=E8F8Q8(ii);
            if( pQ8>-1 ){
               I6[jI6]=Q8[pQ8];
               continue;
            }
         }
//
//
// for each pair from group of contained (pU- 1)-bod subsystems
//
         int oD8=0;
         for(int aZ8= 0;aZ8<(pU8- 1);aZ8++){
            int aY8=U8[pU8].Y8[jI6].Z8[aZ8].Y8;
            int oaD8=Y8[aY8].oD8;
            if( oaD8== 0 )continue;
            for(int bZ8=(aZ8+ 1);bZ8<pU8;bZ8++){
               int bY8=U8[pU8].Y8[jI6].Z8[bZ8].Y8;
               int obD8=Y8[bY8].oD8;
               if( obD8== 0 )continue;
//
               int pZ8=(pU8- 1-bZ8);
               int lZ8=(pU8- 1-aZ8);
//
//
// chain connectivity constraint
//
               int pS8=U8[pU8].Y8[jI6].Z8[pZ8].S8;
               int pG7=M8[iM8].S8[pS8].G7;
               int lS8=U8[pU8].Y8[jI6].Z8[lZ8].S8;
               int lG7=M8[iM8].S8[lS8].G7;
               mcha=(G7[lG7].mR0-G7[pG7].nR0- 1);
               bool EHE(false),EEH(false),HEE(false);
               if      ( lG7==(pG7+ 4) ){
                  if( G7[pG7+ 2].C70==1 )EHE=true;
               }else if( lG7==(pG7+ 2) ){
                  if( (pG7+ 4)<oG7 ){
                     if( G7[pG7+ 4].C70==1 )EEH=true;
                  }
                  if( (pG7- 2)>=0 ){
                     if( G7[pG7- 2].C70==1 )HEE=true;
                  }
                  if( (mcha<15)&&(pU8< 5) )continue;
               }
//
//
// disulfide crosslink constraint
//
               bool LONGSSLNK=false;
               int pR0min=G7[pG7].mR0;
               int pR0max=G7[pG7].nR0;
               int lR0min=G7[lG7].mR0;
               int lR0max=G7[lG7].nR0;
               for(int pR0=pR0min;pR0<=pR0max;pR0++){
                  int qR0=R0[pR0].lnk;
                  if( qR0>-1 ){
                     if( (qR0>=lR0min)&&(qR0<=lR0max) )LONGSSLNK=true;
                  }
               }
               if( LONGSSLNK )continue;
//
//
// merge configs, disallow inconsistency
//
               int nD8=0;
               for(int aD8= 0;aD8<oaD8;aD8++){
                  int aX=Y8[aY8].D8[aD8].Z8[pZ8   ].X;
                  if( (aX!= 0)&&(aX!=(qU8- 1)) )continue;
                  for(int bD8= 0;bD8<obD8;bD8++){
                     int bX=Y8[bY8].D8[bD8].Z8[lZ8- 1].X;
                     if( (bX!= 0)&&(bX!=(qU8- 1)) )continue;
//
                     bool CONSISTENT=true;
                     double e= (0.00);
                     if      ( (aX== 0)&&(bX== 0) ){
                        int iZ8=-1;
                        int jZ8=-1;
                        for(int gZ8= 0;gZ8<pU8&&( CONSISTENT);gZ8++){
                           if      ( gZ8==(pZ8  ) ){
                              iZ8++;
                              vv.Z8X(gZ8)= 0;
                              vv.Z8A(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].A;
                              vv.Z8B(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].B;
                              vv.Z8e(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].e;
                           }else if( gZ8==(lZ8  ) ){
                              jZ8++;
                              vv.Z8X(gZ8)=(pU8- 1);
                              vv.Z8A(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].B;
                              vv.Z8B(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].A;
                              vv.Z8e(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].e;
                           }else{
                              iZ8++;
                              jZ8++;
                              int iX=Y8[aY8].D8[aD8].Z8[iZ8].X;
                              int jX=(qU8-Y8[bY8].D8[bD8].Z8[jZ8].X);
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 continue;
                              }
                              if( iX> 1 ){
                                 int iB=Y8[aY8].D8[aD8].Z8[iZ8].B;
                                 int jB=Y8[bY8].D8[bD8].Z8[jZ8].A;
                                 if( jB!=iB ){
                                    CONSISTENT=false;
                                    continue;
                                 }
                              }
                              if( pU8== 3 ){
                                 int iN=Y8[aY8].D8[aD8].Z8[iZ8].A;
                                 int jN=Y8[bY8].D8[bD8].Z8[jZ8].A;
                                 if( jN==iN ){
                                    CONSISTENT=false;
                                    continue;
                                 }
                              }
                              vv.Z8X(gZ8)=iX;
                              vv.Z8A(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].B;
                              vv.Z8B(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].B;
                              vv.Z8e(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].e;
                              if( pU8== 3 ){
                                 vv.Z8e(gZ8)+=Y8[bY8].D8[bD8].Z8[jZ8].e;
                                 int gS8=U8[pU8].Y8[jI6].Z8[gZ8].S8;
                                 int gG7=M8[iM8].S8[gS8].G7;
                                 int gR0min=G7[gG7].mR0;
                                 int gR0max=G7[gG7].nR0;
                                 int iR0(-1),jR0(-1);
                                 char j=Y8[aY8].D8[aD8].Z8[iZ8].B;
                                 if( j<0 ){
                                    j=-j;
                                    j=((j/2)-32);
                                    jR0=( j                        );
                                    iR0=( j-G7[pG7].nR0+G7[pG7].mR0);
                                 }else{
                                    j=((j/2)-32);
                                    iR0=(-j                        );
                                    jR0=(-j+G7[pG7].nR0-G7[pG7].mR0);
                                 }
                                 if( iR0< 0 )iR0= 0;
                                 if( jR0>(G7[gG7].nR0-G7[gG7].mR0) )
                                     jR0=(G7[gG7].nR0-G7[gG7].mR0);
                                 int kR0(-1),lR0(-1);
                                 j=Y8[bY8].D8[bD8].Z8[jZ8].B;
                                 if( j<0 ){
                                    j=-j;
                                    j=((j/2)-32);
                                    lR0=( j                        );
                                    kR0=( j-G7[lG7].nR0+G7[lG7].mR0);
                                 }else{
                                    j=((j/2)-32);
                                    kR0=(-j                        );
                                    lR0=(-j+G7[lG7].nR0-G7[lG7].mR0);
                                 }
                                 if( kR0< 0 )kR0= 0;
                                 if( lR0>(G7[gG7].nR0-G7[gG7].mR0) )
                                     lR0=(G7[gG7].nR0-G7[gG7].mR0);
                                 for(int gR0=gR0min;gR0<=gR0max;gR0++){
                                    int gL1=R0[gR0].L1;
                                    vv.Z8e(gZ8)-=igor_data.L1[gL1].edge;
                                    int pR0=(gR0-gR0min);
                                    bool PEDGE=((pR0<iR0)||(pR0>jR0));
                                    bool LEDGE=((pR0<kR0)||(pR0>lR0));
                                    if      ( ( PEDGE)&&( LEDGE) ){
                                       vv.Z8e(gZ8)-=( igor_data.L1[gL1].edge
                                                     +(2.50));
                                    }else if( (!PEDGE)&&(!LEDGE) ){
                                       vv.Z8e(gZ8)+=( igor_data.L1[gL1].cent
                                                     -igor_data.L1[gL1].edge);
                                    }else{
                                       vv.Z8e(gZ8)-=( .20);
                                    }
                                 }
                              }else if( iX==(pU8- 2) ){
                                 vv.Z8e(gZ8)= Y8[bY8].D8[bD8].Z8[jZ8].e;
                              }
                           }
                           e+=vv.Z8e(gZ8);
                        }
//
                     }else if( (aX== 0)&&(bX==(qU8- 1)) ){
                        int iZ8=-1;
                        int jZ8=-1;
                        for(int gZ8= 0;gZ8<pU8&&( CONSISTENT);gZ8++){
                           if      ( gZ8==(pZ8  ) ){
                              iZ8++;
                              vv.Z8X(gZ8)= 0;
                              vv.Z8A(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].A;
                              vv.Z8B(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].B;
                              vv.Z8e(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].e;
                           }else if( gZ8==(lZ8  ) ){
                              jZ8++;
                              vv.Z8X(gZ8)=(pU8- 1);
                              vv.Z8A(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].A;
                              vv.Z8B(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].B;
                              vv.Z8e(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].e;
                           }else{
                              iZ8++;
                              jZ8++;
                              int iX=Y8[aY8].D8[aD8].Z8[iZ8].X;
                              int jX=Y8[bY8].D8[bD8].Z8[jZ8].X+ 1;
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 continue;
                              }
                              if( iX> 1 ){
                                 int iB=Y8[aY8].D8[aD8].Z8[iZ8].B;
                                 int jB=Y8[bY8].D8[bD8].Z8[jZ8].B;
                                 if( jB!=iB ){
                                    CONSISTENT=false;
                                    continue;
                                 }
                              }
                              if( pU8== 3 ){
                                 int iN=Y8[aY8].D8[aD8].Z8[iZ8].A;
                                 int jN=Y8[bY8].D8[bD8].Z8[jZ8].B;
                                 if( jN==iN ){
                                    CONSISTENT=false;
                                    continue;
                                 }
                              }
                              vv.Z8X(gZ8)=iX;
                              vv.Z8A(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].A;
                              vv.Z8B(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].B;
                              vv.Z8e(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].e;
                              if( pU8== 3 ){
                                 vv.Z8e(gZ8)+=Y8[bY8].D8[bD8].Z8[jZ8].e;
                                 int gS8=U8[pU8].Y8[jI6].Z8[gZ8].S8;
                                 int gG7=M8[iM8].S8[gS8].G7;
                                 int gR0min=G7[gG7].mR0;
                                 int gR0max=G7[gG7].nR0;
                                 int iR0(-1),jR0(-1);
                                 char j=Y8[aY8].D8[aD8].Z8[iZ8].B;
                                 if( j<0 ){
                                    j=-j;
                                    j=((j/2)-32);
                                    jR0=( j                        );
                                    iR0=( j-G7[pG7].nR0+G7[pG7].mR0);
                                 }else{
                                    j=((j/2)-32);
                                    iR0=(-j                        );
                                    jR0=(-j+G7[pG7].nR0-G7[pG7].mR0);
                                 }
                                 if( iR0< 0 )iR0= 0;
                                 if( jR0>(G7[gG7].nR0-G7[gG7].mR0) )
                                     jR0=(G7[gG7].nR0-G7[gG7].mR0);
                                 int kR0(-1),lR0(-1);
                                 j=Y8[bY8].D8[bD8].Z8[jZ8].A;
                                 if( j<0 ){
                                    j=-j;
                                    j=((j/2)-32);
                                    lR0=( j                        );
                                    kR0=( j-G7[lG7].nR0+G7[lG7].mR0);
                                 }else{
                                    j=((j/2)-32);
                                    kR0=(-j                        );
                                    lR0=(-j+G7[lG7].nR0-G7[lG7].mR0);
                                 }
                                 if( kR0< 0 )kR0= 0;
                                 if( lR0>(G7[gG7].nR0-G7[gG7].mR0) )
                                     lR0=(G7[gG7].nR0-G7[gG7].mR0);
                                 for(int gR0=gR0min;gR0<=gR0max;gR0++){
                                    int gL1=R0[gR0].L1;
                                    vv.Z8e(gZ8)-=igor_data.L1[gL1].edge;
                                    int pR0=(gR0-gR0min);
                                    bool PEDGE=((pR0<iR0)||(pR0>jR0));
                                    bool LEDGE=((pR0<kR0)||(pR0>lR0));
                                    if      ( ( PEDGE)&&( LEDGE) ){
                                       vv.Z8e(gZ8)-=( igor_data.L1[gL1].edge
                                                     +(2.50));
                                    }else if( (!PEDGE)&&(!LEDGE) ){
                                       vv.Z8e(gZ8)+=( igor_data.L1[gL1].cent
                                                     -igor_data.L1[gL1].edge);
                                    }else{
                                       vv.Z8e(gZ8)-=( .20);
                                    }
                                 }
                              }else if( iX==(pU8- 2) ){
                                 vv.Z8e(gZ8)= Y8[bY8].D8[bD8].Z8[jZ8].e;
                              }
                           }
                           e+=vv.Z8e(gZ8);
                        }
//
                     }else if( (aX==(qU8- 1))&&(bX== 0) ){
                        int iZ8=-1;
                        int jZ8=-1;
                        for(int gZ8= 0;gZ8<pU8&&( CONSISTENT);gZ8++){
                           if      ( gZ8==(pZ8  ) ){
                              iZ8++;
                              vv.Z8X(gZ8)=(pU8- 1);
                              vv.Z8A(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].A;
                              vv.Z8B(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].B;
                              vv.Z8e(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].e;
                           }else if( gZ8==(lZ8  ) ){
                              jZ8++;
                              vv.Z8X(gZ8)= 0;
                              vv.Z8A(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].A;
                              vv.Z8B(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].B;
                              vv.Z8e(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].e;
                           }else{
                              iZ8++;
                              jZ8++;
                              int jX=Y8[bY8].D8[bD8].Z8[jZ8].X;
                              int iX=Y8[aY8].D8[aD8].Z8[iZ8].X+ 1;
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 continue;
                              }
                              if( jX> 1 ){
                                 int jB=Y8[bY8].D8[bD8].Z8[jZ8].B;
                                 int iB=Y8[aY8].D8[aD8].Z8[iZ8].B;
                                 if( jB!=iB ){
                                    CONSISTENT=false;
                                    continue;
                                 }
                              }
                              if( pU8== 3 ){
                                 int jN=Y8[bY8].D8[bD8].Z8[jZ8].A;
                                 int iN=Y8[aY8].D8[aD8].Z8[iZ8].B;
                                 if( jN==iN ){
                                    CONSISTENT=false;
                                    continue;
                                 }
                              }
                              vv.Z8X(gZ8)=jX;
                              vv.Z8A(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].A;
                              vv.Z8B(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].B;
                              vv.Z8e(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].e;
                              if( pU8== 3 ){
                                 vv.Z8e(gZ8)+=Y8[aY8].D8[aD8].Z8[iZ8].e;
                                 int gS8=U8[pU8].Y8[jI6].Z8[gZ8].S8;
                                 int gG7=M8[iM8].S8[gS8].G7;
                                 int gR0min=G7[gG7].mR0;
                                 int gR0max=G7[gG7].nR0;
                                 int iR0(-1),jR0(-1);
                                 char j=Y8[aY8].D8[aD8].Z8[iZ8].A;
                                 if( j<0 ){
                                    j=-j;
                                    j=((j/2)-32);
                                    jR0=( j                        );
                                    iR0=( j-G7[pG7].nR0+G7[pG7].mR0);
                                 }else{
                                    j=((j/2)-32);
                                    iR0=(-j                        );
                                    jR0=(-j+G7[pG7].nR0-G7[pG7].mR0);
                                 }
                                 if( iR0< 0 )iR0= 0;
                                 if( jR0>(G7[gG7].nR0-G7[gG7].mR0) )
                                     jR0=(G7[gG7].nR0-G7[gG7].mR0);
                                 int kR0(-1),lR0(-1);
                                 j=Y8[bY8].D8[bD8].Z8[jZ8].B;
                                 if( j<0 ){
                                    j=-j;
                                    j=((j/2)-32);
                                    lR0=( j                        );
                                    kR0=( j-G7[lG7].nR0+G7[lG7].mR0);
                                 }else{
                                    j=((j/2)-32);
                                    kR0=(-j                        );
                                    lR0=(-j+G7[lG7].nR0-G7[lG7].mR0);
                                 }
                                 if( kR0< 0 )kR0= 0;
                                 if( lR0>(G7[gG7].nR0-G7[gG7].mR0) )
                                     lR0=(G7[gG7].nR0-G7[gG7].mR0);
                                 for(int gR0=gR0min;gR0<=gR0max;gR0++){
                                    int gL1=R0[gR0].L1;
                                    vv.Z8e(gZ8)-=igor_data.L1[gL1].edge;
                                    int pR0=(gR0-gR0min);
                                    bool PEDGE=((pR0<iR0)||(pR0>jR0));
                                    bool LEDGE=((pR0<kR0)||(pR0>lR0));
                                    if      ( ( PEDGE)&&( LEDGE) ){
                                       vv.Z8e(gZ8)-=( igor_data.L1[gL1].edge
                                                     +(2.50));
                                    }else if( (!PEDGE)&&(!LEDGE) ){
                                       vv.Z8e(gZ8)+=( igor_data.L1[gL1].cent
                                                     -igor_data.L1[gL1].edge);
                                    }else{
                                       vv.Z8e(gZ8)-=( .20);
                                    }
                                 }
                              }else if( jX==(pU8- 2) ){
                                 vv.Z8e(gZ8)= Y8[aY8].D8[aD8].Z8[iZ8].e;
                              }
                           }
                           e+=vv.Z8e(gZ8);
                        }
//
                     }else if( (aX==(qU8- 1))&&(bX==(qU8- 1)) ){
                        int iZ8=-1;
                        int jZ8=-1;
                        for(int gZ8= 0;gZ8<pU8&&( CONSISTENT);gZ8++){
                           if      ( gZ8==(pZ8  ) ){
                              iZ8++;
                              vv.Z8X(gZ8)= 0;
                              vv.Z8A(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].B;
                              vv.Z8B(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].A;
                              vv.Z8e(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].e;
                           }else if( gZ8==(lZ8  ) ){
                              jZ8++;
                              vv.Z8X(gZ8)=(pU8- 1);
                              vv.Z8A(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].A;
                              vv.Z8B(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].B;
                              vv.Z8e(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].e;
                           }else{
                              iZ8++;
                              jZ8++;
                              int iX=(qU8- 1-Y8[aY8].D8[aD8].Z8[iZ8].X);
                              int jX=Y8[bY8].D8[bD8].Z8[jZ8].X+ 1;
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 continue;
                              }
                              if( iX> 1 ){
                                 int iB=Y8[aY8].D8[aD8].Z8[iZ8].A;
                                 int jB=Y8[bY8].D8[bD8].Z8[jZ8].B;
                                 if( jB!=iB ){
                                    CONSISTENT=false;
                                    continue;
                                 }
                              }
                              if( pU8== 3 ){
                                 int iN=Y8[aY8].D8[aD8].Z8[iZ8].B;
                                 int jN=Y8[bY8].D8[bD8].Z8[jZ8].B;
                                 if( jN==iN ){
                                    CONSISTENT=false;
                                    continue;
                                 }
                              }
                              vv.Z8X(gZ8)=iX;
                              vv.Z8A(gZ8)=Y8[bY8].D8[bD8].Z8[jZ8].A;
                              vv.Z8B(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].A;
                              vv.Z8e(gZ8)=Y8[aY8].D8[aD8].Z8[iZ8].e;
                              if( pU8== 3 ){
                                 vv.Z8e(gZ8)+=Y8[bY8].D8[bD8].Z8[jZ8].e;
                                 int gS8=U8[pU8].Y8[jI6].Z8[gZ8].S8;
                                 int gG7=M8[iM8].S8[gS8].G7;
                                 int gR0min=G7[gG7].mR0;
                                 int gR0max=G7[gG7].nR0;
                                 int iR0(-1),jR0(-1);
                                 char j=Y8[aY8].D8[aD8].Z8[iZ8].A;
                                 if( j<0 ){
                                    j=-j;
                                    j=((j/2)-32);
                                    jR0=( j                        );
                                    iR0=( j-G7[pG7].nR0+G7[pG7].mR0);
                                 }else{
                                    j=((j/2)-32);
                                    iR0=(-j                        );
                                    jR0=(-j+G7[pG7].nR0-G7[pG7].mR0);
                                 }
                                 if( iR0< 0 )iR0= 0;
                                 if( jR0>(G7[gG7].nR0-G7[gG7].mR0) )
                                     jR0=(G7[gG7].nR0-G7[gG7].mR0);
                                 int kR0(-1),lR0(-1);
                                 j=Y8[bY8].D8[bD8].Z8[jZ8].A;
                                 if( j<0 ){
                                    j=-j;
                                    j=((j/2)-32);
                                    lR0=( j                        );
                                    kR0=( j-G7[lG7].nR0+G7[lG7].mR0);
                                 }else{
                                    j=((j/2)-32);
                                    kR0=(-j                        );
                                    lR0=(-j+G7[lG7].nR0-G7[lG7].mR0);
                                 }
                                 if( kR0< 0 )kR0= 0;
                                 if( lR0>(G7[gG7].nR0-G7[gG7].mR0) )
                                     lR0=(G7[gG7].nR0-G7[gG7].mR0);
                                 for(int gR0=gR0min;gR0<=gR0max;gR0++){
                                    int gL1=R0[gR0].L1;
                                    vv.Z8e(gZ8)-=igor_data.L1[gL1].edge;
                                    int pR0=(gR0-gR0min);
                                    bool PEDGE=((pR0<iR0)||(pR0>jR0));
                                    bool LEDGE=((pR0<kR0)||(pR0>lR0));
                                    if      ( ( PEDGE)&&( LEDGE) ){
                                       vv.Z8e(gZ8)-=( igor_data.L1[gL1].edge
                                                     +(2.50));
                                    }else if( (!PEDGE)&&(!LEDGE) ){
                                       vv.Z8e(gZ8)+=( igor_data.L1[gL1].cent
                                                     -igor_data.L1[gL1].edge);
                                    }else{
                                       vv.Z8e(gZ8)-=( .20);
                                    }
                                 }
                              }else if( iX==(pU8- 2) ){
                                 vv.Z8e(gZ8)= Y8[bY8].D8[bD8].Z8[jZ8].e;
                              }
                           }
                           e+=vv.Z8e(gZ8);
                        }
//
                     }
                     if( !CONSISTENT )continue;
//
                     for(int gZ8= 0;gZ8<pU8;gZ8++){
                        vv.XZ8(vv.Z8X(gZ8))=gZ8;
                     }
//
//
// alt sheet config
//
                     Z8.clear();
                     Z8.resize(pU8);
                     PARALLEL=false;
                     int jY=0;
                     int sgny= 1;
                     for(int gX= 0;gX<pU8;gX++){
                        int gZ8=vv.XZ8(gX);
                        int gS8=U8[pU8].Y8[jI6].Z8[gZ8].S8;
                        int gG7=M8[iM8].S8[gS8].G7;
                        int gR0min=G7[gG7].mR0;
                        int gR0max=G7[gG7].nR0;
                        char j=vv.Z8B(gZ8);
                        if( j>=0 ){
                           jY+=sgny*((j/2)-32);
                           if( gX> 0 )PARALLEL=true;
                        }else{
                           j=-j;
                           jY+=sgny*((j/2)-32);
                           sgny=-sgny;
                        }
                        int sgnx=(j%2);
                        Z8[gZ8].oR0=(gR0max-gR0min+ 1);
                        Z8[gZ8].R0.resize(Z8[gZ8].oR0);
                        for(int gR0=gR0min;gR0<=gR0max;gR0++){
                           int jR0=(gR0-gR0min);
                           int gY=( jY +jR0*sgny);
                           Z8[gZ8].R0[jR0].X=gX;
                           Z8[gZ8].R0[jR0].Y=gY;
                           Z8[gZ8].R0[jR0].sgnx=( 1-2*((jR0+sgnx)% 2));
                           Z8[gZ8].R0[jR0].sgny=sgny;
                           vv.XYsub(gX,gY, true);
                        }
                     }
//
//
// EHE strands should be parallel
//
                     if( EHE ){
                        if( Z8[lZ8].R0[ 0].sgny!=Z8[pZ8].R0[ 0].sgny ){
                           continue;
                        }
                     }
//
//
// conditions for inclusion of sheet faces
//
                     int lX( 99),uX(-99),lY( 99),uY(-99);
                     int lYup( 99),lYdown( 99);
                     int nu( 0),nd( 0);
                     for(int gZ8= 0;gZ8<pU8;gZ8++){
                        int gS8=U8[pU8].Y8[jI6].Z8[gZ8].S8;
                        int gG7=M8[iM8].S8[gS8].G7;
                        int gR0min=G7[gG7].mR0;
                        int gR0max=G7[gG7].nR0;
                        for(int gR0=gR0min;gR0<=gR0max;gR0++){
                           int jR0=(gR0-gR0min);
                           int gX=Z8[gZ8].R0[jR0].X;
                           int gY=Z8[gZ8].R0[jR0].Y;
                           if( gX<lX )lX=gX;
                           if( gX>uX )uX=gX;
                           if( gY<lY )lY=gY;
                           if( gY>uY )uY=gY;
                           bool EDGE=( vv.XYsub(gX- 1,gY   )&&
                                       vv.XYsub(gX+ 1,gY   )&&
                                       vv.XYsub(gX   ,gY- 1)&&
                                       vv.XYsub(gX   ,gY+ 1) )? false:  true;
                           int gL1=R0[gR0].L1;
                           int ihphob=igor_data.L1[gL1].hphob;
                           int idoc=igor_data.L1[gL1].doc;
                           if( Z8[gZ8].R0[jR0].sgnx*
                               Z8[gZ8].R0[jR0].sgny== 1 ){
                              if( gY<lYup )lYup=gY;
                              if( EDGE ){
                                 if( idoc> 0 )nu+=idoc;
                              }else{
                                 if( ihphob< 0 ){
                                    nu+=ihphob;
                                 }else{
                                    nu+=idoc;
                                 }
                              }
                           }else{
                              if( gY<lYdown )lYdown=gY;
                              if( EDGE ){
                                 if( idoc> 0 )nd+=idoc;
                              }else{
                                 if( ihphob< 0 ){
                                    nd+=ihphob;
                                 }else{
                                    nd+=idoc;
                                 }
                              }
                           }
                        }
                     }
                     if( (nu<0)||(nd<0) ){
                        int j=( nu<nd )? nu: nd;
                        nu-=j;
                        nd-=j;
                     }
                     h= double(nu-nd)/( double(nu+nd) +(1.00e-5));
//
//
// reinitialize sheet subset
//
                     for(int gZ8= 0;gZ8<pU8;gZ8++){
                        int gS8=U8[pU8].Y8[jI6].Z8[gZ8].S8;
                        int gG7=M8[iM8].S8[gS8].G7;
                        int gR0min=G7[gG7].mR0;
                        int gR0max=G7[gG7].nR0;
                        for(int gR0=gR0min;gR0<=gR0max;gR0++){
                           int jR0=(gR0-gR0min);
                           int gX=Z8[gZ8].R0[jR0].X;
                           int gY=Z8[gZ8].R0[jR0].Y;
                           vv.XYsub(gX,gY, false);
                        }
                     }
//
//
// add contribution of chain twist to energy of sheet config
//
                     int sgn=( Z8[lZ8].R0[ 0].X>Z8[pZ8].R0[ 0].X )? 1:-1;
                     sgn*=Z8[pZ8].R0[ 0].sgny;
                     if( EHE ){
                        if      ( h>( .25) ){
                           if      ( sgn==-1 ){
                              e-=( 4.00);
                           }else if( sgn== 1 ){
                              e+=( 0.00);
                           }
                        }else if( h<(-.25) ){
                           if      ( sgn==-1 ){
                              e+=( 0.00);
                           }else if( sgn== 1 ){
                              e-=( 4.00);
                           }
                        }
                     }
                     if( EEH ){ //no selection for up-right-H or up-down-H
                        if      ( h>( .25) ){
                           if      ( sgn==-1 ){
                              e-=( 0.00);
                           }else if( sgn== 1 ){
                              e+=( 0.00);
                           }
                        }else if( h<(-.25) ){
                           if      ( sgn==-1 ){
                              e+=( 0.00);
                           }else if( sgn== 1 ){
                              e-=( 0.00);
                           }
                        }
                     }
                     if( HEE ){
                        if      ( h>( .25) ){
                           if      ( sgn==-1 ){
                              e+=( 0.00);
                           }else if( sgn== 1 ){
                              e-=( 4.00);
                           }
                        }else if( h<(-.25) ){
                           if      ( sgn==-1 ){
                              e-=( 4.00);
                           }else if( sgn== 1 ){
                              e+=( 0.00);
                           }
                        }
                     }
//
//
// visualize sheet
//
//                   if( NATIVE ){
//                      IGO_SCO3_EVIS(igor_data,out,iM8,jI6,
//                                    lX,uX,lY,uY);
//                   }
//
//
// chain connectivity constraint
//
                     if( IGO_SCO3_EDOC(out,
                                       pZ8,lZ8,lX,lY)
                         )continue;
//
// penalties for edge strand extensions, deviation from calc slope,
//  consistency with chain twist
//
                     double eu( 0.00),ed( 0.00);
                     if( pU8==M8[iM8].oS8 ){
                        Coordinates epen=
                          IGO_SCO3_EPEN(physics_consts,igor_data,
                                        out,
                                        iM8,jI6,
                                        vv.o_Z8A,vv.o_Z8B,vv.o_XZ8);
                        e+=epen(0);
                        eu= epen(1);
                        ed= epen(2);
                     }
//
//
// pack to previous helicies
//
                     double ew= (0.00);
                     if( oW4== 0 ){
                        if( pU8> 4 ){
                           if      ( h>( .275) ){
                              ew= ( .35)*double( nu);
                           }else if( h<(-.275) ){
                              ew= ( .35)*double( nd);
                           }
                        }
                     }else{
//
//
// up face
//
                        int pcku=0;
                        if( h>(-.375) ){
                           if( EHE&&(sgn==-1) ){
                           }else{
                              pcku=IGO_SCO3_EPCK(physics_consts,igor_data,out,
                                                 iM8,jI6,
                                                 lX,uX,lY,uY,
                                                 lYup, 1);
                           }
                        }
//
//
// down face
//
                        int pckd=0;
                        if( h<( .375) ){
                           if( EHE&&(sgn== 1) ){
                           }else{
                              pckd=IGO_SCO3_EPCK(physics_consts,igor_data,out,
                                                 iM8,jI6,
                                                 -uX,-lX,lY,uY,
                                                 lYdown,-1);
                           }
                        }
                        if( ( eu +( .40)*double( pcku))>
                            ( ed +( .40)*double( pckd)) ){
                           ew= ( .40)*double( pcku);
                        }else{
                           ew= ( .40)*double( pckd);
                        }
                     }
                     e+=ew;
//
//
// acceptance of sheet config
//
                     if( e<(-2.00) )continue;
                     nD8++;
                     if( oD8<2048 ){
                        I6[jI6].D8.push_back( tY8::tY8D8());
                        oD8++;
                        I6[jI6].D8[oD8- 1].Z8.resize(pU8);
                     }else{
                        if( e<=I6[jI6].D8[oD8- 1].e[ 0] )continue;
                     }
                     I6[jI6].D8[oD8- 1].e[ 0]= e;
                     I6[jI6].D8[oD8- 1].e[ 1]=( e -ew);
                     I6[jI6].D8[oD8- 1].e[ 2]= ew;
                     for(int gZ8= 0;gZ8<pU8;gZ8++){
                        I6[jI6].D8[oD8- 1].Z8[gZ8].X=vv.Z8X(gZ8);
                        I6[jI6].D8[oD8- 1].Z8[gZ8].e= vv.Z8e(gZ8);
                        I6[jI6].D8[oD8- 1].Z8[gZ8].A=vv.Z8A(gZ8);
                        I6[jI6].D8[oD8- 1].Z8[gZ8].B=vv.Z8B(gZ8);
                     }
//
//
// maintain order
//
                     for(int jD8=(oD8- 1);jD8> 0;jD8--){
                        if( I6[jI6].D8[jD8   ].e[ 0]<=
                            I6[jI6].D8[jD8- 1].e[ 0] )break;
                        I6[jI6].D8[jD8   ].swap(
                        I6[jI6].D8[jD8- 1]);
                     }
                  }
               }
//
//             out.FILE3<<"PAIR OF SUBSETS=(";
//             for(int jZ8= 0;jZ8<qU8;jZ8++){
//                out.FILE3<<std::setw( 2)<<U8[qU8].Y8[aY8].Z8[jZ8].S8
//                         <<(( jZ8<(qU8- 1) )? ',': ')');
//             }
//             out.FILE3<<'(';
//             for(int jZ8= 0;jZ8<qU8;jZ8++){
//                out.FILE3<<std::setw( 2)<<U8[qU8].Y8[bY8].Z8[jZ8].S8
//                         <<(( jZ8<(qU8- 1) )? ',': ')');
//             }
//             out.FILE3<<" PASS="<<std::setw( 7)<<nD8<<'\n';
//
//
//
//
            }
         }
         I6[jI6].oD8=oD8;
         I6[jI6].oZ8=pU8;
         if( oD8== 0 )continue;
//
//
// diagnostic output
//
         if( NATIVE ){
            out.FILE3<<"UNION SUBSYSTEM=(";
            for(int jZ8= 0;jZ8<pU8;jZ8++){
               out.FILE3<<std::setw( 2)<<U8[pU8].Y8[jI6].Z8[jZ8].S8
                        <<(( jZ8<(pU8- 1) )? ',': ')');
            }
            out.FILE3<<'\n';
            out.FILE3<<"  Y8""  oD8\n";
            out.FILE3<<std::setw( 4)<<jI6
                     <<std::setw( 5)<<oD8<<'\n';
            out.FILE3<<" iD8   e      eg     epck"
                       "  Z  X B  A N   e   \n";
//          if( oD8> 8 )oD8= 8;
            for(int jD8= 0;jD8<oD8;jD8++){
               for(int jZ8= 0;jZ8<pU8;jZ8++){
                  int j=I6[jI6].D8[jD8].Z8[jZ8].B;
                  int iB=0;
                  if( j<0 ){
                     iB=1;
                     j=-j;
                  }
                  int iN=(j%2);
                  int iA=(j/2)-32;
                  out.FILE3<<std::setprecision( 3);
                  if( jZ8== 0 ){
                     out.FILE3<<std::setw( 4)<<jD8;
                     for(int i=0;i<3;i++){
                        out.FILE3<<std::setw( 7)<<I6[jI6].D8[jD8].e[ i];
                     }
                  }else{
                     out.FILE3<<"                         ";
                  }
                  out.FILE3<<std::setw( 3)<<jZ8
                           <<std::setw( 3)<<int(I6[jI6].D8[jD8].Z8[jZ8].X)
                           <<std::setw( 2)<<iB
                           <<std::setw( 3)<<iA
                           <<std::setw( 2)<<iN
                           <<std::setw( 7)<<I6[jI6].D8[jD8].Z8[jZ8].e<<'\n';
               }
            }
         }
//
//
// backup
//
         if( ADDRESSABLE ){
            E8F8Q8(ii)=oQ8;
            Q8.push_back( tQ8());
            Q8[oQ8]=I6[jI6];
            oQ8++;
         }
      }
   }
//
//
// transfer Y8 from I6 to enable recursion
//
   Y8.clear();
   Y8.resize(oI6);
   for(int jI6= 0;jI6<oI6;jI6++){
      Y8[jI6]=I6[jI6];
   }
//
//
// partial config backup
//
   oY8=U8[pU8].oY8;
   for(int iY8= 0;iY8<oY8;iY8++){
      if( Y8[iY8].oD8>0 ){
         U8[pU8].Y8[iY8]=Y8[iY8].D8[ 0];
      }else{
         for(int i=0;i<3;i++){
            U8[pU8].Y8[iY8].e[ i]= (0.00);
         }
      }
   }
//
//
// factorization
//
   if( NATIVE ){
      out.FILE3<<"FACTORIZATION\n";
   }
   int oS8=M8[iM8].oS8;
   for(int pY8= 0;pY8<oY8;pY8++){
      if( !U8[pU8].Y8[pY8].STABLE )continue;
      double zde( 0.00);
      int aU8(-1),aY8(-1),bU8(-1),bY8(-1);
      for(int iU8= 2;iU8<=(pU8/2);iU8++){
         int jU8=(pU8-iU8);
         int iZ8= 0;
         vv.Z8Z8(iZ8)=-1;
         while( true ){
            vv.Z8Z8(iZ8)++;
            if( vv.Z8Z8(iZ8)>(jU8+iZ8) ){
               if( iZ8== 0 ){
                  break;
               }else{
                  iZ8--;
                  continue;
               }
//
            }else{
               vv.Z8S8(iZ8)=U8[pU8].Y8[pY8].Z8[vv.Z8Z8(iZ8)].S8;
               if( iZ8==(iU8- 1) ){
//
//
// indexes of iU and jU-bod subsystems
//
                  int iY8=(U8[iU8].oY8- 1);
                  int jY8=(U8[jU8].oY8- 1);
                  for(int jZ8= 0;jZ8<pU8;jZ8++){
                     vv.Z8sub(jZ8)=U8[pU8].Y8[pY8].Z8[jZ8].S8;
                  }
                  for(int jZ8= 0;jZ8<iU8;jZ8++){
                     vv.Z8sub(vv.Z8Z8(jZ8))=-1;
                     int n=(oS8- 1-vv.Z8S8(jZ8));
                     int i=(iU8-jZ8);
                     if( i>n )continue;
                     iY8-=( array_consts.FAC[n  ]/
                           (array_consts.FAC[n-i]*array_consts.FAC[i  ])
                            );
                  }
                  if( !U8[iU8].Y8[iY8].STABLE )continue;
                  int jZ8=-1;
                  for(int kZ8= 0;kZ8<pU8;kZ8++){
                     if( vv.Z8sub(kZ8)==-1 )continue;
                     jZ8++;
                     int n=(oS8- 1-vv.Z8sub(kZ8));
                     int i=(jU8-jZ8);
                     if( i>n )continue;
                     jY8-=( array_consts.FAC[n  ]/
                           (array_consts.FAC[n-i]*array_consts.FAC[i  ])
                            );
                  }
                  if( !U8[jU8].Y8[jY8].STABLE )continue;
//
//
// chain connectivity constraint
//
                  int iS8min=U8[iU8].Y8[iY8].Z8[ 0].S8;
                  int iS8max=U8[iU8].Y8[iY8].Z8[iU8- 1].S8;
                  int jS8min=U8[jU8].Y8[jY8].Z8[ 0].S8;
                  int jS8max=U8[jU8].Y8[jY8].Z8[jU8- 1].S8;
                  if( ((iS8max-iS8min)>iU8)&&
                      ((jS8max-jS8min)>jU8) )continue;
//
//
// maintain optimal partition
//
                  double de=( U8[iU8].Y8[iY8].e[ 0]
                             +U8[jU8].Y8[jY8].e[ 0]
                             -U8[pU8].Y8[pY8].e[ 0]
                             -( 2.00));
                  if( de>zde ){
                     zde= de;
                     aU8=iU8;
                     aY8=iY8;
                     bU8=jU8;
                     bY8=jY8;
                  }
               }else{
                  iZ8++;
                  vv.Z8Z8(iZ8   )=vv.Z8Z8(iZ8- 1);
               }
//
            }
         }
      }
//
//
// diagnostic output
//
      if( aU8>-1 ){
         U8[pU8].Y8[pY8].STABLE=false;
         Y8[pY8].oD8=0;
         U8[aU8].Y8[aY8].FACTOR=true;
         U8[bU8].Y8[bY8].FACTOR=true;
         if( NATIVE ){
            out.FILE3<<std::fixed<<std::setprecision( 3);
            out.FILE3<<'(';
            for(int jZ8= 0;jZ8<pU8;jZ8++){
               out.FILE3<<std::setw( 2)<<U8[pU8].Y8[pY8].Z8[jZ8].S8
                        <<(( jZ8<(pU8- 1) )? ',': ')');
            }
            out.FILE3<<std::setw( 7)<<U8[pU8].Y8[pY8].e[ 0]<<"->(";
            for(int jZ8= 0;jZ8<aU8;jZ8++){
               out.FILE3<<std::setw( 2)<<U8[aU8].Y8[aY8].Z8[jZ8].S8
                        <<(( jZ8<(aU8- 1) )? ',': ')');
            }
            out.FILE3<<std::setw( 7)<<U8[aU8].Y8[aY8].e[ 0]<<'(';
            for(int jZ8= 0;jZ8<bU8;jZ8++){
               out.FILE3<<std::setw( 2)<<U8[bU8].Y8[bY8].Z8[jZ8].S8
                        <<(( jZ8<(bU8- 1) )? ',': ')');
            }
            out.FILE3<<std::setw( 7)<<U8[bU8].Y8[bY8].e[ 0]<<'\n';
         }
      }else{
         EMPTY=false;
      }
   }
   return EMPTY;
}
