#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>

class MEM_igo_sco3_e1 {
private:
   std::vector<int> o_Z8E8;     //region of proto elem
   std::vector<int> o_Z8F8;     //bounds of proto elem
   std::vector<int> o_S8X;      //x position in sheet
   std::vector<int> o_S8D;      //y displacement of strand block wrt 0
   std::vector<int> o_S8B;      //orientation { 0=up, 1=down}
   std::vector<int> o_XS8;      //map of x position to strand
   std::vector<char> o_Z8X;     //x position in sheet
   std::vector<float> o_Z8e;    //energy of alignment resolved wrt strand
public:
   std::vector<char> o_Z8A;     //alignment wrt following x
   std::vector<char> o_Z8B;     //alignment wrt previous x
   std::vector<int> o_XZ8;      //inverse map of Z8X
   MEM_igo_sco3_e1(int z,int s):
      o_Z8E8(z),
      o_Z8F8(z),
      o_S8X(s),
      o_S8D(s),
      o_S8B(s),
      o_XS8(z+1),
      o_Z8X(z),
      o_Z8e(z),
      o_Z8A(z),
      o_Z8B(z),
      o_XZ8(z)
   {
   }
   int& Z8E8(int i){
      return o_Z8E8.at( i);  }
   int& Z8F8(int i){
      return o_Z8F8.at( i);  }
   int& S8X(int i){
      return o_S8X.at( i);  }
   int& S8D(int i){
      return o_S8D.at( i);  }
   int& S8B(int i){
      return o_S8B.at( i);  }
   int& XS8(int i){
      return o_XS8.at( i+1);  }
   char& Z8X(int i){
      return o_Z8X.at( i);  }
   float& Z8e(int i){
      return o_Z8e.at( i);  }
   char& Z8A(int i){
      return o_Z8A.at( i);  }
   char& Z8B(int i){
      return o_Z8B.at( i);  }
   int& XZ8(int i){
      return o_XZ8.at( i);  }
};

bool Igor_Model::IGO_SCO3_E1(const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_IGOR_DATA& igor_data,
                             Output_Streams& out,
                             int iM8){
//
//
// for each 2-bod subsystem
//
   if( NATIVE ){
      out.FILE3<<std::setw( 2)<< 2<<"-BOD CONFIGS\n";
   }
   int oS8=M8[iM8].oS8;
   MEM_igo_sco3_e1 vv( 2,oS8);
   oY8=U8[ 2].oY8;
   Y8.clear();
   Y8.resize(oY8);
   bool EMPTY=true;
   for(int iY8= 0;iY8<oY8;iY8++){
      Y8[iY8].oZ8=2;
//
//
// restore from backup
//
      bool ADDRESSABLE=true;
      int ii=0;
      for(int iZ8= 0;iZ8< 2&&( ADDRESSABLE);iZ8++){
         int iS8=U8[ 2].Y8[iY8].Z8[iZ8].S8;
         int iG7=M8[iM8].S8[iS8].G7;
         int iR0=G7[iG7].mR0;
         int jR0=G7[iG7].nR0;
         int ief=R0R0ef(iR0,jR0);
         if( ief>-1 ){
            vv.Z8E8(iZ8)=(ief/oF8);
            vv.Z8F8(iZ8)=(ief%oF8);
            if( iZ8> 0 ){
               if( vv.Z8E8(iZ8   )>vv.Z8E8(iZ8- 1) ){
                  ii+=( vv.Z8F8(iZ8)<<(nF8*vv.Z8E8(iZ8)));
               }else{
                  ADDRESSABLE=false;
               }
            }else{
               ii+=( vv.Z8F8(iZ8)<<(nF8*vv.Z8E8(iZ8)));
            }
         }else{
            ADDRESSABLE=false;
         }
      }
      if( ADDRESSABLE ){
         int pQ8=E8F8Q8(ii);
         if( pQ8>-1 ){
            Y8[iY8]=Q8[pQ8];
            continue;
         }
      }
//
//
//
//
      int iS8=U8[ 2].Y8[iY8].Z8[ 0].S8;
      int jS8=U8[ 2].Y8[iY8].Z8[ 1].S8;
      if( NATIVE ){
         out.FILE3<<"PAIR OF STRANDS=("
                  <<std::setw( 2)<<iS8<<','
                  <<std::setw( 2)<<jS8<<")\n";
      }
      int iG7=M8[iM8].S8[iS8].G7;
      int jG7=M8[iM8].S8[jS8].G7;
      bool EHE(false),EEH(false),HEE(false);
      bool EE(false);
      if      ( jG7==(iG7+ 4) ){
         if( G7[iG7+ 2].C70==1 )EHE=true;
      }else if( jG7==(iG7+ 2) ){
         EE=true;
         if( (iG7+ 4)<oG7 ){
            if( G7[iG7+ 4].C70==1 )EEH=true;
         }
         if( (iG7- 2)>=0 ){
            if( G7[iG7- 2].C70==1 )HEE=true;
         }
      }
//
//
// chain connectivity constraint
//
      int m=(G7[jG7].mR0-G7[iG7].nR0- 1);
      int n=(G7[iG7].nR0-G7[iG7].mR0+ 6);
      int jBmin=( (m<n)||EE )? 1: 0;
      int jBmax=( EHE )? 0: 1;
//
//
// orientations plus alignments of strand j wrt strand i
//
      int oD8=0;
      vv.S8X(iS8)=0;
      vv.XS8( 0)=iS8;
      vv.S8D(iS8)=0;
      vv.S8B(iS8)=0;
      for(int jX=-1;jX<= 1;jX+=2){
         int pX=( jX==-1 )?-1: 0;
         vv.S8X(jS8)=jX;
         vv.XS8(jX)=jS8;
         for(int jB=jBmin;jB<=jBmax;jB++){
            vv.S8B(jS8)=jB;
            int jDmin=(-G7[jG7].nR0+G7[jG7].mR0+ 1);
            if( jDmin<-32 )jDmin=-32;
            int jDmax=( G7[iG7].nR0-G7[iG7].mR0- 1);
            if( jDmax> 32 )jDmax= 32;
            if( jB== 1 ){
               int o=((G7[iG7].nR0-G7[iG7].mR0)
                     -(G7[jG7].nR0-G7[jG7].mR0));
               if( jDmin<(o-m+2) )jDmin=(o-m+2);
               if( jDmax>(o+m-2) )jDmax=(o+m-2);
            }else{
               int o=(G7[iG7].nR0-G7[iG7].mR0);
               if( jDmin<(o-m+5) )jDmin=(o-m+5);
            }
            for(int jD=jDmin;jD<=jDmax;jD++){
               vv.S8D(jS8)=jD;
//
//
// pair contact energies, statistical and hydrophobic
//
               double eg= (0.00);
               double eh= (0.00);
               if( EHE ){
                  eg-=(  .80);
               }
               bool LONGSSLNK=false;
               int pS8=vv.XS8(pX);
               int pG7=M8[iM8].S8[pS8].G7;
               int pR0min=G7[pG7].mR0;
               int pR0max=G7[pG7].nR0;
               int pD=vv.S8D(pS8);
               int pB=vv.S8B(pS8);
               int lS8=vv.XS8(pX+ 1);
               int lG7=M8[iM8].S8[lS8].G7;
               int lR0min=G7[lG7].mR0;
               int lR0max=G7[lG7].nR0;
               int lD=vv.S8D(lS8);
               int lB=vv.S8B(lS8);
               for(int pR0=pR0min;pR0<=pR0max;pR0++){
                  int pY=( pB==0 )? (pD+pR0-pR0min): (pD+pR0max-pR0);
//                    pY=( lB==0 )? (lD+lR0-lR0min): (lD+lR0max-lR0);
                  int lR0=( lB==0 )? ( pY-lD+lR0min): (-pY+lD+lR0max);
                  int pL1=R0[pR0].L1;
                  bool HBLINK=(((pY+32+pB)% 2)==0);
                  if( ((lR0   )>=lR0min)&&
                      ((lR0   )<=lR0max) ){
                     int lL1=R0[lR0   ].L1;
                     if( lB==pB ){
                        eg+=igor_data.L1L1eib(pL1,lL1) +( .72);
                     }else{
                        if( HBLINK ){
                           eg+=igor_data.L1L1eia(pL1,lL1) +( .60);
                        }else{
                           eg+=igor_data.L1L1eic(pL1,lL1) +( .52);
                        }
                     }
                     eh+=igor_data.L1L1hp(pL1,lL1);
                  }
                  if( ((lR0+ 2)>=lR0min)&&
                      ((lR0+ 2)<=lR0max) ){
                     int lL1=R0[lR0+ 2].L1;
                     if( lB==pB ){
                        if( HBLINK ){
                           eg+=igor_data.L1L1ejb(pL1,lL1);      //r inc
                        }else{
                           eg+=igor_data.L1L1ekb(pL1,lL1);      //r dec
                        }
                     }else{
                        if( HBLINK ){
                           eg+=igor_data.L1L1eja(pL1,lL1);      //r dec
                        }else{
                           eg+=igor_data.L1L1ejc(pL1,lL1);      //r inc
                        }
                     }
                     eh+=igor_data.L1L1hp(pL1,lL1);
                  }
                  if( ((lR0- 2)>=lR0min)&&
                      ((lR0- 2)<=lR0max) ){
                     int lL1=R0[lR0- 2].L1;
                     if( lB==pB ){
                        if( HBLINK ){
                           eg+=igor_data.L1L1ekb(pL1,lL1);      //r dec
                        }else{
                           eg+=igor_data.L1L1ejb(pL1,lL1);      //r inc
                        }
                     }else{
                        if( HBLINK ){
                           eg+=igor_data.L1L1eka(pL1,lL1);      //r inc
                        }else{
                           eg+=igor_data.L1L1ekc(pL1,lL1);      //r dec
                        }
                     }
                     eh+=igor_data.L1L1hp(pL1,lL1);
                  }
                  int qR0=R0[pR0].lnk;
                  if( qR0>-1 ){
                     if( (qR0>=lR0min)&&(qR0<=lR0max)&&
                         (qR0!=lR0) )LONGSSLNK=true;
                  }
               }
               if( LONGSSLNK )continue;
               if( ( eg +eh)<(-1.00) )continue;
//
//
// statistical edge/center energy
//
               double ep= (0.00);
               for(int pR0=pR0min;pR0<=pR0max;pR0++){
                  int pL1=R0[pR0].L1;
                  ep+=igor_data.L1[pL1].edge;
               }
               double el= (0.00);
               for(int lR0=lR0min;lR0<=lR0max;lR0++){
                  int lL1=R0[lR0].L1;
                  el+=igor_data.L1[lL1].edge;
               }
//
//
// compact sheet config
//
               if      ( jX==-1 ){
                  vv.Z8X( 0)=1;
                  vv.Z8X( 1)=0;
                  if      ( jB==0 ){
                     vv.Z8B( 0)=( (-jD+32)*2 +0);
                     vv.Z8B( 1)=( 32*2 +((jD+32)% 2));
                     vv.Z8A( 0)=( 32*2 +1);
                     vv.Z8A( 1)=( ( jD+32)*2 +((jD+32+ 1)% 2));
                  }else if( jB==1 ){
                     int jR0=(G7[jG7].nR0-G7[jG7].mR0);
                     vv.Z8B( 0)=-( (jD+jR0+32)*2 +0);
                     vv.Z8B( 1)=( 32*2 +((jD+jR0+32+ 1)% 2));
                     vv.Z8A( 0)=( 32*2 +1);
                     vv.Z8A( 1)=-( (jD+jR0+32)*2 +((jD+jR0+32)% 2));
                  }
               }else if( jX== 1 ){
                  vv.Z8X( 0)=0;
                  vv.Z8X( 1)=1;
                  if      ( jB==0 ){
                     vv.Z8B( 0)=( 32*2 +0);
                     vv.Z8B( 1)=( ( jD+32)*2 +((jD+32)% 2));
                     vv.Z8A( 0)=( (-jD+32)*2 +1);
                     vv.Z8A( 1)=( 32*2 +((jD+32+ 1)% 2));
                  }else if( jB==1 ){
                     int jR0=(G7[jG7].nR0-G7[jG7].mR0);
                     vv.Z8B( 0)=( 32*2 +0);
                     vv.Z8B( 1)=-( (jD+jR0+32)*2 +((jD+jR0+32+ 1)% 2));
                     vv.Z8A( 0)=-( (jD+jR0+32)*2 +1);
                     vv.Z8A( 1)=( 32*2 +((jD+jR0+32)% 2));
                  }
               }
               vv.XZ8(vv.Z8X( 0))= 0;
               vv.XZ8(vv.Z8X( 1))= 1;
//
//
// alt sheet config
//
               Z8.clear();
               Z8.resize( 2);
               PARALLEL=false;
               int jY=0;
               int sgny= 1;
               for(int gX= 0;gX< 2;gX++){
                  int gZ8=vv.XZ8(gX);
                  int gS8=U8[ 2].Y8[iY8].Z8[gZ8].S8;
                  int gG7=M8[iM8].S8[gS8].G7;
                  int gR0min=G7[gG7].mR0;
                  int gR0max=G7[gG7].nR0;
                  char j=vv.Z8B(gZ8);
                  if( j>=0 ){
                     jY+=sgny*((j/2)-32);
                     if( gX> 0 )PARALLEL=true;
                  }else{
                     j=-j;
                     jY+=sgny*((j/2)-32);
                     sgny=-sgny;
                  }
                  int sgnx=(j%2);
                  Z8[gZ8].oR0=(gR0max-gR0min+ 1);
                  Z8[gZ8].R0.resize(Z8[gZ8].oR0);
                  for(int gR0=gR0min;gR0<=gR0max;gR0++){
                     int jR0=(gR0-gR0min);
                     Z8[gZ8].R0[jR0].X=gX;
                     Z8[gZ8].R0[jR0].Y=( jY +jR0*sgny);
                     Z8[gZ8].R0[jR0].sgnx=( 1-2*((jR0+sgnx)% 2));
                     Z8[gZ8].R0[jR0].sgny=sgny;
                  }
               }
//
//
// conditions for inclusion of sheet faces
//
               int lX( 99),uX(-99),lY( 99),uY(-99);
               int lYup( 99),lYdown( 99);
               int nu( 0),nd( 0);
               for(int gZ8= 0;gZ8< 2;gZ8++){
                  int gS8=U8[ 2].Y8[iY8].Z8[gZ8].S8;
                  int gG7=M8[iM8].S8[gS8].G7;
                  int gR0min=G7[gG7].mR0;
                  int gR0max=G7[gG7].nR0;
                  for(int gR0=gR0min;gR0<=gR0max;gR0++){
                     int jR0=(gR0-gR0min);
                     int gX=Z8[gZ8].R0[jR0].X;
                     int gY=Z8[gZ8].R0[jR0].Y;
                     if( gX<lX )lX=gX;
                     if( gX>uX )uX=gX;
                     if( gY<lY )lY=gY;
                     if( gY>uY )uY=gY;
                     int gL1=R0[gR0].L1;
                     int idoc=igor_data.L1[gL1].doc;
                     if( Z8[gZ8].R0[jR0].sgnx*
                         Z8[gZ8].R0[jR0].sgny== 1 ){
                        if( gY<lYup )lYup=gY;
                        if( idoc> 0 )nu+=idoc;
                     }else{
                        if( gY<lYdown )lYdown=gY;
                        if( idoc> 0 )nd+=idoc;
                     }
                  }
               }
               if( (nu<0)||(nd<0) ){
                  int j=( nu<nd )? nu: nd;
                  nu-=j;
                  nd-=j;
               }
               h= double(nu-nd)/( double(nu+nd) +(1.00e-5));
//
//
// add contribution of chain twist to pair contact energy
//
               if( EHE ){
                  if      ( h>( .35) ){
                     if      ( jX==-1 ){
                        eg-=( 4.00);
                     }else if( jX== 1 ){
                        eg+=( 0.00);
                     }
                  }else if( h<(-.35) ){
                     if      ( jX==-1 ){
                        eg+=( 0.00);
                     }else if( jX== 1 ){
                        eg-=( 4.00);
                     }
                  }
               }
               if( EEH ){ //no selection for up-right-H or up-down-H
                  if      ( h>( .35) ){
                     if      ( jX==-1 ){
                        eg-=( 0.00);
                     }else if( jX== 1 ){
                        eg+=( 0.00);
                     }
                  }else if( h<(-.35) ){
                     if      ( jX==-1 ){
                        eg+=( 0.00);
                     }else if( jX== 1 ){
                        eg-=( 0.00);
                     }
                  }
               }
               if( HEE ){
                  if      ( h>( .35) ){
                     if      ( jX==-1 ){
                        eg+=( 0.00);
                     }else if( jX== 1 ){
                        eg-=( 4.00);
                     }
                  }else if( h<(-.35) ){
                     if      ( jX==-1 ){
                        eg-=( 4.00);
                     }else if( jX== 1 ){
                        eg+=( 0.00);
                     }
                  }
               }
//
//
// energy of alignment resolved wrt strand
//
               if      ( jX==-1 ){
                  vv.Z8e( 0)=( ( .50)*eg +( .50)*eh +el);
                  vv.Z8e( 1)=( ( .50)*eg +( .50)*eh +ep);
               }else if( jX== 1 ){
                  vv.Z8e( 0)=( ( .50)*eg +( .50)*eh +ep);
                  vv.Z8e( 1)=( ( .50)*eg +( .50)*eh +el);
               }
//
// penalties for edge strand extensions, deviation from calc slope,
//  consistency with chain twist
//
               double eu( 0.00),ed( 0.00);
               if( pU8==oS8 ){
                  Coordinates epen=IGO_SCO3_EPEN(physics_consts,igor_data,
                                    out,
                                    iM8,iY8,
                                    vv.o_Z8A,vv.o_Z8B,vv.o_XZ8);
                  eg+=epen(0);
                  eu= epen(1);
                  ed= epen(2);
               }
//
//
// pack to previous helicies
//
               double ew= (0.00);
               if( oW4== 0 ){
               }else{
//
//
// up face
//
                  int pcku=0;
                  if( h>(-.375) ){
                     if( EHE&&(jX==-1) ){
                     }else{
                        pcku=IGO_SCO3_EPCK(physics_consts,igor_data,out,
                                           iM8,iY8,
                                           lX,uX,lY,uY,
                                           lYup, 1);
                     }
                  }
//
//
// down face
//
                  int pckd=0;
                  if( h<( .375) ){
                     if( EHE&&(jX== 1) ){
                     }else{
                        pckd=IGO_SCO3_EPCK(physics_consts,igor_data,out,
                                           iM8,iY8,
                                           -uX,-lX,lY,uY,
                                           lYdown,-1);
                     }
                  }
                  if( ( eu +( .40)*double( pcku))>
                      ( ed +( .40)*double( pckd)) ){
                     ew= ( .40)*double( pcku);
                  }else{
                     ew= ( .40)*double( pckd);
                  }
               }
//
//
// characterization of strand alignment forward and backward
//
               double e=( eg +eh +ep +el +ew);
               if( oD8<2048 ){
                  Y8[iY8].D8.push_back( tY8::tY8D8());
                  oD8++;
                  Y8[iY8].D8[oD8- 1].Z8.resize( 2);
               }else{
                  if( e<=Y8[iY8].D8[oD8- 1].e[ 0] )continue;
               }
               Y8[iY8].D8[oD8- 1].e[ 0]= e;
               Y8[iY8].D8[oD8- 1].e[ 1]=( e -ew);
               Y8[iY8].D8[oD8- 1].e[ 2]= ew;
               Y8[iY8].D8[oD8- 1].e[ 3]= eg;
               Y8[iY8].D8[oD8- 1].e[ 4]= eh;
               Y8[iY8].D8[oD8- 1].e[ 5]=( ep +el);
               for(int iZ8= 0;iZ8< 2;iZ8++){
                  Y8[iY8].D8[oD8- 1].Z8[iZ8].X=vv.Z8X(iZ8);
                  Y8[iY8].D8[oD8- 1].Z8[iZ8].e= vv.Z8e(iZ8);
                  Y8[iY8].D8[oD8- 1].Z8[iZ8].B=vv.Z8B(iZ8);
                  Y8[iY8].D8[oD8- 1].Z8[iZ8].A=vv.Z8A(iZ8);
               }
//
//
// maintain order
//
               for(int iD8=(oD8- 1);iD8> 0;iD8--){
                  if( Y8[iY8].D8[iD8   ].e[ 0]<=
                      Y8[iY8].D8[iD8- 1].e[ 0] )break;
                  Y8[iY8].D8[iD8   ].swap(
                  Y8[iY8].D8[iD8- 1]);
               }
            }
         }
      }
      Y8[iY8].oD8=oD8;
//
//
// diagnostic output
//
      if( NATIVE ){
         out.FILE3<<"  Y8""  oD8\n";
         out.FILE3<<std::setw( 4)<<iY8
                  <<std::setw( 5)<<oD8<<'\n';
         out.FILE3<<"  D8   e      epck   eg     eh     ep  "
                    "  Z  X B  A N   e   \n";
         out.FILE3<<std::fixed<<std::setprecision( 3);
//       if( oD8> 8 )oD8= 8;
         for(int iD8= 0;iD8<oD8;iD8++){
            for(int iZ8= 0;iZ8< 2;iZ8++){
               char j=Y8[iY8].D8[iD8].Z8[iZ8].B;
               int iB=0;
               if( j<0 ){
                  iB=1;
                  j=-j;
               }
               int iN=(j%2);
               int iA=(j/2)-32;
               if( iZ8== 0 ){
                  out.FILE3<<std::setw( 4)<<iD8
                           <<std::setw( 7)<<Y8[iY8].D8[iD8].e[ 0];
                  for(int i=2;i<6;i++){
                     out.FILE3<<std::setw( 7)<<Y8[iY8].D8[iD8].e[ i];
                  }
               }else{
                  out.FILE3<<"                                       ";
               }
               out.FILE3<<std::setw( 3)<<iZ8
                        <<std::setw( 3)<<int(Y8[iY8].D8[iD8].Z8[iZ8].X)
                        <<std::setw( 2)<<iB
                        <<std::setw( 3)<<iA
                        <<std::setw( 2)<<iN
                        <<std::setw( 7)<<Y8[iY8].D8[iD8].Z8[iZ8].e<<'\n';
            }
         }
      }
//
//
// backup
//
      if( ADDRESSABLE ){
         E8F8Q8(ii)=oQ8;
         Q8.push_back( tQ8());
         Q8[oQ8]=Y8[iY8];
         oQ8++;
      }
   }
//
//
// partial config backup
//
   for(int iY8= 0;iY8<oY8;iY8++){
      if( Y8[iY8].oD8>0 ){
         U8[ 2].Y8[iY8]=Y8[iY8].D8[ 0];
         EMPTY=false;
      }else{
         for(int i=0;i<3;i++){
            U8[ 2].Y8[iY8].e[ i]= (0.00);
         }
      }
   }
   return EMPTY;
}
