#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>

class MEM_igo_sco3_e {
private:
   std::vector<int> o_Z8Y8;     //group of n (n-1)-strand subsystems
   std::vector<int> o_Z8S8;     //map of position in subsystem to strand
   std::vector<bool> o_S8sub;   //subset of strands
public:
   MEM_igo_sco3_e(int s):
      o_Z8Y8(s),
      o_Z8S8(s),
      o_S8sub(s, false)
   {
   }
   int& Z8Y8(int i){
      return o_Z8Y8.at( i);  }
   int& Z8S8(int i){
      return o_Z8S8.at( i);  }
   void S8sub(int i,bool a){
      o_S8sub[ i]=a;  }
   bool S8sub(int i){
      return o_S8sub[ i];  }
};

void Igor_Model::IGO_SCO3_E(const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_ARRAY_CONSTS& array_consts,
                            const DAT_IGOR_DATA& igor_data,
                            Output_Streams& out,
                            int iM8){
//
//
// pairs of strands
//
   int oS8=M8[iM8].oS8;
   oU8=(oS8+ 1);
   U8.clear();
   U8.resize(oU8);
   pU8=2;
   oY8=oS8*(oS8- 1)/2;
   U8[pU8].Y8.resize(oY8);
   int iY8=0;
   for(int iS8= 0;iS8<(oS8- 1);iS8++){
      for(int jS8=(iS8+ 1);jS8<oS8;jS8++){
         U8[pU8].Y8[iY8].Z8.resize( 2);
         U8[pU8].Y8[iY8].Z8[ 0].S8=iS8;
         U8[pU8].Y8[iY8].Z8[ 1].S8=jS8;
         U8[pU8].Y8[iY8].STABLE=false;
         U8[pU8].Y8[iY8].FACTOR=false;
         iY8++;
      }
   }
   U8[pU8].oY8=iY8;
//
//
// lattice 2-strand energies
//
   bool EMPTY=IGO_SCO3_E1(physics_consts,igor_data,out,iM8);
   if( EMPTY ){
      oU8=0;
      oT8=0;
      return;
   }
//
//
// recursive growth of subsystems from (pU-1)-strand to pU-strand
//
   MEM_igo_sco3_e vv(oS8);
   for(int iU8= 3;iU8<oU8;iU8++){
      pU8=iU8;
      int qU8=(pU8- 1);
      int jI6=0;
      int iZ8=0;
      vv.Z8Y8(iZ8)=-1;
      while( true ){
         vv.Z8Y8(iZ8)++;
         if( vv.Z8Y8(iZ8)>(U8[qU8].oY8-pU8+iZ8) ){
            if( iZ8== 0 ){
               break;
            }else{
               iZ8--;
               continue;
            }
//
         }else{
            if      ( iZ8== 1 ){
               int n=0;
               for(int aZ8= 0;aZ8<qU8;aZ8++){
                  for(int bZ8= 0;bZ8<qU8;bZ8++){
                     if( U8[qU8].Y8[vv.Z8Y8( 1)].Z8[bZ8].S8==
                         U8[qU8].Y8[vv.Z8Y8( 0)].Z8[aZ8].S8 )n++;
                  }
               }
               if( n<(qU8- 1) )continue;
               int pZ8=-1;
               for(int aZ8= 0;aZ8<qU8;aZ8++){
                  bool MATCH=false;
                  for(int bZ8= 0;bZ8<qU8&&(!MATCH);bZ8++){
                     if( U8[qU8].Y8[vv.Z8Y8( 1)].Z8[bZ8].S8==
                         U8[qU8].Y8[vv.Z8Y8( 0)].Z8[aZ8].S8 )MATCH=true;
                  }
                  if( !MATCH ){
                     pZ8=aZ8;
                     break;
                  }
               }
               if( pZ8<(qU8- 1) )continue;
               U8[pU8].Y8.push_back( tU8::tU8Y8());
               for(int aZ8= 0;aZ8<qU8;aZ8++){
                  vv.Z8S8(aZ8)=U8[qU8].Y8[vv.Z8Y8( 0)].Z8[aZ8].S8;
               }
               vv.Z8S8(qU8)=U8[qU8].Y8[vv.Z8Y8( 1)].Z8[qU8- 1].S8;
//             {
//                out.FILE3<<"PAIR OF SUBSYSTEMS=("
//                         <<std::setw( 4)<<vv.Z8Y8( 0)<<','
//                         <<std::setw( 4)<<vv.Z8Y8( 1)<<")\n";
//                out.FILE3<<"SUBSET OF ELEMENTS=("
//                for(int jZ8= 0;jZ8<pU8;jZ8++){
//                   out.FILE3<<std::setw( 2)<<vv.Z8S8(jZ8)
//                            <<(( jZ8<qU8 )? ',': ')');
//                }
//                out.FILE3<<'\n';
//             }
            }else if( iZ8> 1 ){
               bool INGROUP=true;
               for(int aZ8= 0;aZ8<qU8&&( INGROUP);aZ8++){
                  bool MATCH=false;
                  for(int jZ8= 0;jZ8<pU8&&(!MATCH);jZ8++){
                     if( vv.Z8S8(jZ8)==
                         U8[qU8].Y8[vv.Z8Y8(iZ8)].Z8[aZ8].S8 )MATCH=true;
                  }
                  if( !MATCH )INGROUP=false;
               }
               if( !INGROUP )continue;
            }
            if( iZ8==(pU8- 1) ){
//             {
//                out.FILE3<<"SEQUENCE OF "
//                         <<std::setw( 2)<<qU8
//                         <<"-BOD SUBSYSTEMS=(";
//                for(int jZ8= 0;jZ8<pU8;jZ8++){
//                   out.FILE3<<std::setw( 4)<<vv.Z8Y8(jZ8)
//                            <<(( jZ8<qU8 )? ',': ')');
//                }
//                out.FILE3<<'\n';
//             }
               U8[pU8].Y8[jI6].Z8.resize(pU8);
               for(int jZ8= 0;jZ8<pU8;jZ8++){
                  U8[pU8].Y8[jI6].Z8[jZ8].S8=vv.Z8S8(jZ8);
                  U8[pU8].Y8[jI6].Z8[jZ8].Y8=vv.Z8Y8(jZ8);
               }
               U8[pU8].Y8[jI6].STABLE=false;
               U8[pU8].Y8[jI6].FACTOR=false;
               jI6++;
            }else{
               iZ8++;
               vv.Z8Y8(iZ8)=vv.Z8Y8(iZ8- 1);
            }
//
         }
      }
      U8[pU8].oY8=jI6;
//
//
// lattice oU-strand energies
//
      EMPTY=IGO_SCO3_E2(physics_consts,array_consts,igor_data,out,iM8);
//
//
// condition for continued recursion
//
      if( EMPTY ){
         pU8--;
         break;
      }
   }
//
//
// a full sheet config is optimal
//
   oY8=U8[pU8].oY8;
   for(int iY8= 0;iY8<oY8;iY8++){
      if( U8[pU8].Y8[iY8].STABLE ){
         U8[pU8].Y8[iY8].FACTOR=true;
      }
   }
//
//
// remove non-factor sub configs
//
   for(int iU8= 2;iU8<pU8;iU8++){
      oY8=U8[iU8].oY8;
      for(int iY8= 0;iY8<oY8;iY8++){
         if( !U8[iU8].Y8[iY8].FACTOR ){
            U8[iU8].Y8[iY8].STABLE=false;
         }
      }
   }
//
//
// order factor sub configs
//
   T8.clear();
   oT8=0;
   for(int iU8=pU8;iU8>=2;iU8--){
      oY8=U8[iU8].oY8;
      for(int iY8= 0;iY8<oY8;iY8++){
         if( !U8[iU8].Y8[iY8].STABLE )continue;
         T8.push_back( tT8());
         T8[oT8].U8=iU8;
         T8[oT8].Y8=iY8;
         for(int i=0;i<3;i++){
            T8[oT8].e[ i]= U8[iU8].Y8[iY8].e[ i];
         }
         oT8++;
      }
   }
   for(int jT8max=(oT8-1);jT8max> 0;jT8max--){
      bool ORDERED=true;
      double e1= T8[ 0].e[ 0];
      for(int jT8= 1;jT8<=jT8max;jT8++){
         double e2= T8[jT8].e[ 0];
         if( e2>e1 ){
            T8[jT8  ].swap(
            T8[jT8-1]);
            ORDERED=false;
         }else{
            e1=e2;
         }
      }
      if( ORDERED )break;
   }
//
//
// optimize partition
//
   double e= (0.00);
   for(int iT8= 0;iT8<oT8;iT8++){
      int iU8=T8[iT8].U8;
      int iY8=T8[iT8].Y8;
      bool DISJOINT=true;
      for(int iZ8= 0;iZ8<iU8&&( DISJOINT);iZ8++){
         int iS8=U8[iU8].Y8[iY8].Z8[iZ8].S8;
         if( vv.S8sub(iS8) )DISJOINT=false;
      }
      if( DISJOINT ){
         for(int iZ8= 0;iZ8<iU8;iZ8++){
            int iS8=U8[iU8].Y8[iY8].Z8[iZ8].S8;
            vv.S8sub(iS8,true);
         }
         e+=U8[iU8].Y8[iY8].e[ 1];
         T8[iT8].sub=true;
      }else{
         T8[iT8].sub=false;
      }
   }
//
//
// func value, formation of bods +packing of bods
//
   SCORE3+=e;
//
//
// diagnostic output
//
   if( NATIVE ){
      out.FILE3<<"SHEET OPTIMIZATION\n";
      out.FILE3<<"oS8\n";
      out.FILE3<<std::setw( 3)<<oS8<<'\n';
      out.FILE3<<U8;
      out.FILE3<<T8;
      out.FILE3<<"ENERGY OF SHEET FORMATION\n";
      out.FILE3<<std::setprecision( 3);
      out.FILE3<<std::setw( 7)<<e<<'\n';
   }
   return;
}
