#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <cmath>

class MEM_igo_sco3 {
private:
   std::vector<int> o_O1hp;     //most hydrophob patch for twist
   std::vector<int> o_O1P3;     //pattern
   std::vector<int> o_O1R0;     //start of enclosing res subset
   std::vector<int> o_O1alt;    //alt surf over patch
   int oR0;                     //
   std::vector<bool> o_O1R0sub; //included in patch for twist
   std::vector<int> o_G7M8;     //partition of strands to isolated subsets
   std::vector<bool> o_XYsub;   //occupied position of sheet
public:
   std::vector<int> o_XZ8;      //inverse map of Z8X
   MEM_igo_sco3(int o,int r,int g):
      o_O1hp(o),
      o_O1P3(o),
      o_O1R0(o),
      o_O1alt(o),
      oR0(r),
      o_O1R0sub(o*r, false),
      o_G7M8(g+1,-1),
      o_XYsub(14*64, false)
   {
   }
   int& O1hp(int i){
      return o_O1hp.at( i);  }
   int& O1P3(int i){
      return o_O1P3.at( i);  }
   int& O1R0(int i){
      return o_O1R0.at( i);  }
   int& O1alt(int i){
      return o_O1alt.at( i);  }
   void O1R0sub(int i,int j,bool a){
      o_O1R0sub[ i*oR0 +j]=a;  }
   bool O1R0sub(int i,int j){
      return o_O1R0sub[ i*oR0 +j];  }
   int& G7M8(int i){
      return o_G7M8.at( i+1);  }
   int& XZ8(int i){
      return o_XZ8.at( i);  }
   void XYsub(int i,int j,bool a){
      o_XYsub[ (i+1)*64 +(j+32)]=a;  }
   bool XYsub(int i,int j){
      return o_XYsub[ (i+1)*64 +(j+32)];  }
};

void Igor_Model::IGO_SCO3(const DAT_PHYSICS_CONSTS& physics_consts,
                          const DAT_ARRAY_CONSTS& array_consts,
                          const DAT_IGOR_DATA& igor_data,
                          Output_Streams& out){
//
//
//
//
   MEM_igo_sco3 vv(  8,oR0,oG7);
   SCORE3= (0.00);
   W4.clear();
   oW4=0;
//
//
// iterate over helix and extended elements
//
   for(int iG7= 0;iG7<oG7;iG7++){
      int iC7=G7[iG7].C70;
      if      ( iC7==1 ){
         int iR0min=G7[iG7].mR0;
//
//
// intra-helix energy
//
         int iR0max=(G7[iG7].nR0- 1);
         for(int iR0=iR0min;iR0<=iR0max;iR0++){
            int jR0=(iR0+ 1);
            int iL1=R0[iR0].L1;
            int jL1=R0[jR0].L1;
            SCORE3+=igor_data.L1L1h1(iL1,jL1);
            if( (igor_data.L1[iL1].doc> 0)&&
                (igor_data.L1[jL1].doc> 0) ){
               SCORE3+=igor_data.L1L1hp(iL1,jL1);
            }
         }
         iR0max=(G7[iG7].nR0- 3);
         for(int iR0=iR0min;iR0<=iR0max;iR0++){
            int jR0=(iR0+ 3);
            int iL1=R0[iR0].L1;
            int jL1=R0[jR0].L1;
            SCORE3+=igor_data.L1L1h3(iL1,jL1);
            if( (igor_data.L1[iL1].doc> 0)&&
                (igor_data.L1[jL1].doc> 0) ){
               SCORE3+=igor_data.L1L1hp(iL1,jL1);
            }
         }
         iR0max=(G7[iG7].nR0- 4);
         for(int iR0=iR0min;iR0<=iR0max;iR0++){
            int jR0=(iR0+ 4);
            int iL1=R0[iR0].L1;
            int jL1=R0[jR0].L1;
            SCORE3+=igor_data.L1L1h4(iL1,jL1);
            if( (igor_data.L1[iL1].doc> 0)&&
                (igor_data.L1[jL1].doc> 0) ){
               SCORE3+=igor_data.L1L1hp(iL1,jL1);
            }
            SCORE3+=( .60);
         }
//
//
// find optimal hydrophobic patch for each twist
//
         for(int iO1= 0;iO1< 4;iO1++){
            vv.O1hp(iO1)=-99;
            vv.O1P3(iO1)=-1;
            vv.O1R0(iO1)=-1;
            vv.O1alt(iO1)=-1;
            int oP3=igor_data.O1[iO1].oP3;
            for(int iP3= 0;iP3<oP3;iP3++){
               int oR4=igor_data.O1[iO1].P3[iP3].oR4;
               iR0max=(G7[iG7].nR0+ 1-oR4);
               for(int iR0=iR0min;iR0<=iR0max;iR0++){
                  int ihp=0;
                  int ialt=0;
                  for(int jR4= 0;jR4<oR4;jR4++){
                     int iJ4=igor_data.O1[iO1].P3[iP3].R4J4[jR4];
                     if( iJ4>-1 ){
                        int iL1=R0[iR0+jR4].L1;
                        ihp+=igor_data.L1[iL1].doc;
                        int i=igor_data.L1[iL1].alt;
                        if( i<0 )i=0;
                        if( (iO1== 2)&&(iJ4== 1)&&
                            (igor_data.L1[iL1].a3=="GLY") ){
                           ihp+=3;
                           i=2;
                        }
                        if( (iO1== 3)&&(iP3== 0)&&
                            ( (iJ4== 2)||(iJ4== 3)||(iJ4== 4) )&&
                            (igor_data.L1[iL1].a3=="TRP") ){
                           i=2;
                        }
                        int j=(iJ4*2);
                        ialt+=(i<<j);
                     }
                  }
                  if( (iO1== 3)&&(iP3== 0) ){
                     int i=( igor_data.L1[R0[iR0   ].L1].alt
                            +igor_data.L1[R0[iR0+ 7].L1].alt
                            +igor_data.L1[R0[iR0+14].L1].alt);
                     int j=( igor_data.L1[R0[iR0   ].L1].doc
                            +igor_data.L1[R0[iR0+ 7].L1].doc
                            +igor_data.L1[R0[iR0+14].L1].doc);
                     if( i== 6 ){
                        ihp+=3;
                     }else if( j>= 7 ){
                        ihp+=2;
                     }
                  }
                  if( ihp>vv.O1hp(iO1) ){
                     vv.O1hp(iO1)=ihp;
                     vv.O1P3(iO1)=iP3;
                     vv.O1R0(iO1)=iR0;
                     vv.O1alt(iO1)=ialt;
                  }
               }
            }
         }
//
//
// accumulate hydrophobic patches on helicies
//
         iR0max=G7[iG7].nR0;
//
         for(int iO1= 0;iO1< 4;iO1++){
            if( vv.O1hp(iO1)< 5 )continue;
            W4.push_back( tW4());
            int iR0=vv.O1R0(iO1);
            int iP3=vv.O1P3(iO1);
            int oJ4=igor_data.O1[iO1].P3[iP3].oJ4;
            W4[oW4].oJ4=oJ4;
            W4[oW4].J4.resize(oJ4);
            int oR4=igor_data.O1[iO1].P3[iP3].oR4;
            for(int jR4= 0;jR4<oR4;jR4++){
               int iJ4=igor_data.O1[iO1].P3[iP3].R4J4[jR4];
               if( iJ4==-1 )continue;
               W4[oW4].J4[iJ4].R0=(iR0+jR4);
               W4[oW4].J4[iJ4].a1=igor_data.L1[ R0[iR0+jR4].L1].a1;
               vv.O1R0sub(iO1,iR0+jR4,true);
            }
            W4[oW4].O1=iO1;
            W4[oW4].hp=vv.O1hp(iO1);
            W4[oW4].P3=vv.O1P3(iO1);
            W4[oW4].R0=vv.O1R0(iO1);
            int ialt=vv.O1alt(iO1);
            int iL=0;
            int fac=1;
            for(int iJ4= 0;iJ4<oJ4;iJ4++){
               iL+=(ialt% 4)*fac;
               ialt>>=2;
               fac*=3;
            }
            W4[oW4].L=iL;
            W4[oW4].N=0;
            W4[oW4].oK4= 1;
            W4[oW4].K4.push_back( tW4::tW4K4());
            W4[oW4].K4[ 0].G7=iG7;
            W4[oW4].pen=0;
            for(int iJ4= 0;iJ4<oJ4;iJ4++){
               if( W4[oW4].J4[iJ4].a1=='T' ){
                  W4[oW4].pen-=3;
               }
            }
            oW4++;
         }
//
//
// for each twist, find 2nd, 3rd, ... disjoint hydrophobic patches
//
         for(int iTER=0;iTER<4;iTER++){
//
            for(int iO1= 0;iO1< 4;iO1++){
               vv.O1hp(iO1)=-99;
               vv.O1P3(iO1)=-1;
               vv.O1R0(iO1)=-1;
               vv.O1alt(iO1)=-1;
               int oP3=igor_data.O1[iO1].oP3;
               for(int iP3= 0;iP3<oP3;iP3++){
                  int oR4=igor_data.O1[iO1].P3[iP3].oR4;
                  iR0max=(G7[iG7].nR0+ 1-oR4);
                  int m=(igor_data.O1[iO1].P3[iP3].oJ4-2);
                  for(int iR0=iR0min;iR0<=iR0max;iR0++){
//
                     bool OVERLAP=false;
                     int n=0;
                     for(int jR4= 0;jR4<oR4&&(!OVERLAP);jR4++){
                        int iJ4=igor_data.O1[iO1].P3[iP3].R4J4[jR4];
                        if( iJ4>-1 ){
                           if( vv.O1R0sub(iO1,iR0+jR4) ){
                              n++;
                              if( n>m )OVERLAP=true;
                           }
                        }
                     }
                     if( OVERLAP )continue;
//
                     int ihp=0;
                     int ialt=0;
                     for(int jR4= 0;jR4<oR4;jR4++){
                        int iJ4=igor_data.O1[iO1].P3[iP3].R4J4[jR4];
                        if( iJ4>-1 ){
                           int iL1=R0[iR0+jR4].L1;
                           ihp+=igor_data.L1[iL1].doc;
                           int i=igor_data.L1[iL1].alt;
                           if( i<0 )i=0;
                           if( (iO1== 2)&&(iJ4== 1)&&
                               (igor_data.L1[iL1].a3=="GLY") ){
                              ihp+=3;
                              i=2;
                           }
                           if( (iO1== 3)&&(iP3== 0)&&
                               ( (iJ4== 3)||(iJ4== 4)||(iJ4== 5) )&&
                               (igor_data.L1[iL1].a3=="TRP") ){
                              i=2;
                           }
                           int j=(iJ4*2);
                           ialt+=(i<<j);
                        }
                     }
                     if( (iO1== 3)&&(iP3== 0) ){
                        int i=( igor_data.L1[R0[iR0   ].L1].alt
                               +igor_data.L1[R0[iR0+ 7].L1].alt
                               +igor_data.L1[R0[iR0+14].L1].alt);
                        int j=( igor_data.L1[R0[iR0   ].L1].doc
                               +igor_data.L1[R0[iR0+ 7].L1].doc
                               +igor_data.L1[R0[iR0+14].L1].doc);
                        if( i== 6 ){
                           ihp+=3;
                        }else if( j>= 7 ){
                           ihp+=2;
                        }
                     }
                     if( ihp>vv.O1hp(iO1) ){
                        vv.O1hp(iO1)=ihp;
                        vv.O1P3(iO1)=iP3;
                        vv.O1R0(iO1)=iR0;
                        vv.O1alt(iO1)=ialt;
                     }
                  }
               }
            }
//
            for(int iO1= 0;iO1< 4;iO1++){
               if( vv.O1hp(iO1)< 4 )continue;
               W4.push_back( tW4());
               int iR0=vv.O1R0(iO1);
               int iP3=vv.O1P3(iO1);
               int oJ4=igor_data.O1[iO1].P3[iP3].oJ4;
               W4[oW4].oJ4=oJ4;
               W4[oW4].J4.resize(oJ4);
               int oR4=igor_data.O1[iO1].P3[iP3].oR4;
               for(int jR4= 0;jR4<oR4;jR4++){
                  int iJ4=igor_data.O1[iO1].P3[iP3].R4J4[jR4];
                  if( iJ4==-1 )continue;
                  W4[oW4].J4[iJ4].R0=(iR0+jR4);
                  W4[oW4].J4[iJ4].a1=igor_data.L1[ R0[iR0+jR4].L1].a1;
                  vv.O1R0sub(iO1,iR0+jR4,true);
               }
               W4[oW4].O1=iO1;
               W4[oW4].hp=vv.O1hp(iO1);
               W4[oW4].P3=vv.O1P3(iO1);
               W4[oW4].R0=vv.O1R0(iO1);
               int ialt=vv.O1alt(iO1);
               int iL=0;
               int fac=1;
               for(int iJ4= 0;iJ4<oJ4;iJ4++){
                  iL+=(ialt% 4)*fac;
                  ialt>>=2;
                  fac*=3;
               }
               W4[oW4].L=iL;
               W4[oW4].N=(1+iTER);
               W4[oW4].oK4= 1;
               W4[oW4].K4.push_back( tW4::tW4K4());
               W4[oW4].K4[ 0].G7=iG7;
               W4[oW4].pen=0;
               for(int iJ4= 0;iJ4<oJ4;iJ4++){
                  if( W4[oW4].J4[iJ4].a1=='T' ){
                     W4[oW4].pen-=3;
                  }
               }
               oW4++;
            }
//
         }
//
         iR0max=G7[iG7].nR0;
         for(int iR0=iR0min;iR0<=iR0max;iR0++){
            int jR0=R0[iR0].lnk;
            if( jR0==-1 )continue;
            if( (jR0<iR0min)||(jR0>iR0max) )continue;
            SCORE3-=( 6.40);
         }
//
      }else if( iC7==2 ){
//
//
// intra-strand energy
//
         int iR0min=G7[iG7].mR0;
         int iR0max=(G7[iG7].nR0- 2);
         for(int iR0=iR0min;iR0<=iR0max;iR0++){
            int jR0=(iR0+ 2);
            int iL1=R0[iR0].L1;
            int jL1=R0[jR0].L1;
            SCORE3+=igor_data.L1L1e2(iL1,jL1);
            if( (igor_data.L1[iL1].doc> 0)&&
                (igor_data.L1[jL1].doc> 0) ){
               SCORE3+=igor_data.L1L1hp(iL1,jL1);
            }
         }
//
         iR0max=G7[iG7].nR0;
         for(int iR0=iR0min;iR0<=iR0max;iR0++){
            int jR0=R0[iR0].lnk;
            if( jR0==-1 )continue;
            if( (jR0<iR0min)||(jR0>iR0max) )continue;
            SCORE3-=(12.80);
         }
//
      }else if( iC7==3 ){
      }
   }
//
//
// partition set of strands into isolated subsets
//
   int oS8=0;
   for(int iG7= 0;iG7<oG7;iG7++){
      if( (G7[iG7].nR0-G7[iG7].mR0)== 0 )continue;
      int iC7=G7[iG7].C70;
      if      ( iC7==1 ){
      }else if( iC7==2 ){
         oS8++;
      }else if( iC7==3 ){
      }
   }
//
   M8.clear();
   if( oS8<=12 ){
      oM8= 0;
      M8.push_back( tM8());
      M8[oM8].oS8=oS8;
      M8[oM8].S8.resize(oS8);
      int iS8= 0;
      for(int iG7= 0;iG7<oG7;iG7++){
         if( (G7[iG7].nR0-G7[iG7].mR0)== 0 )continue;
         int iC7=G7[iG7].C70;
         if      ( iC7==1 ){
         }else if( iC7==2 ){
            M8[oM8].S8[iS8++].G7=iG7;
         }else if( iC7==3 ){
         }
      }
      oM8++;
//
   }else{
      oM8= 1;
      int jG7(-1),kG7(-1),lG7(-1);
      vv.G7M8(-1)= 0;
      for(int iG7= 0;iG7<oG7;iG7++){
         if( (G7[iG7].nR0-G7[iG7].mR0)== 0 )continue;
         int iC7=G7[iG7].C70;
         if      ( iC7==1 ){
         }else if( iC7==2 ){
            vv.G7M8(iG7)=vv.G7M8(jG7);
            if( kG7>-1 ){
               if( ((G7[iG7].mR0-G7[jG7].nR0)<
                    (G7[jG7].nR0-G7[jG7].mR0+ 6))&&
                   ((G7[jG7].mR0-G7[kG7].nR0)<
                    (G7[kG7].nR0-G7[kG7].mR0+ 6)) ){
                  if( (G7[jG7].nR0-G7[jG7].mR0)<
                      (G7[iG7].nR0-G7[iG7].mR0) ){
                     if      ( (G7[kG7].nR0-G7[kG7].mR0)>
                               (G7[jG7].nR0-G7[jG7].mR0) ){
                        if( (G7[kG7].nR0-G7[kG7].mR0)>=
                            (G7[iG7].nR0-G7[iG7].mR0) ){
                           vv.G7M8(iG7)++;
                        }else{
                           vv.G7M8(jG7)++;
                           vv.G7M8(iG7)++;
                        }
                        oM8++;
                     }else if( (G7[kG7].nR0-G7[kG7].mR0)==
                               (G7[jG7].nR0-G7[jG7].mR0) ){
                        if( lG7>-1 ){
                           if( (G7[kG7].mR0-G7[lG7].nR0)<
                               (G7[lG7].nR0-G7[lG7].mR0+ 6) ){
                              if( (G7[lG7].nR0-G7[lG7].mR0)>
                                  (G7[kG7].nR0-G7[kG7].mR0) ){
                                 vv.G7M8(jG7)++;
                                 vv.G7M8(iG7)++;
                                 oM8++;
                              }
                           }
                        }
                     }
                  }
               }
            }
            lG7=kG7;
            kG7=jG7;
            jG7=iG7;
         }else if( iC7==3 ){
         }
      }
      M8.resize(oM8);
      for(int iM8= 0;iM8<oM8;iM8++){
         int iS8= 0;
         for(int iG7= 0;iG7<oG7;iG7++){
            if( (G7[iG7].nR0-G7[iG7].mR0)== 0 )continue;
            int iC7=G7[iG7].C70;
            if      ( iC7==1 ){
            }else if( iC7==2 ){
               if( vv.G7M8(iG7)==iM8 ){
                  M8[iM8].S8.push_back( tM8::tM8S8());
                  M8[iM8].S8[iS8++].G7=iG7;
               }
            }else if( iC7==3 ){
            }
         }
         M8[iM8].oS8=iS8;
      }
//
   }
//
//
// optimize sheet configuration
//
   V8.clear();
   oV8=0;
   if( oS8> 1 ){
      for(int iM8= 0;iM8<oM8;iM8++){
         IGO_SCO3_E(physics_consts,array_consts,igor_data,out,iM8);
//
//
// accumulate sheets
//
         for(int iT8= 0;iT8<oT8;iT8++){
            if( !T8[iT8].sub )continue;
            int iU8=T8[iT8].U8;
            int iY8=T8[iT8].Y8;
//
//
// alt sheet config
//
            vv.o_XZ8.clear();
            vv.o_XZ8.resize(iU8);
            for(int iZ8= 0;iZ8<iU8;iZ8++){
               vv.XZ8(U8[iU8].Y8[iY8].Z8[iZ8].X)=iZ8;
            }
//
            Z8.clear();
            Z8.resize(iU8);
            PARALLEL=false;
            int jY=0;
            int sgny= 1;
            for(int gX= 0;gX<iU8;gX++){
               int gZ8=vv.XZ8(gX);
               int gS8=U8[iU8].Y8[iY8].Z8[gZ8].S8;
               int gG7=M8[iM8].S8[gS8].G7;
               int gR0min=G7[gG7].mR0;
               int gR0max=G7[gG7].nR0;
               int j=U8[iU8].Y8[iY8].Z8[gZ8].B;
               if( j>=0 ){
                  jY+=sgny*((j/2)-32);
                  if( gX> 0 )PARALLEL=true;
               }else{
                  j=-j;
                  jY+=sgny*((j/2)-32);
                  sgny=-sgny;
               }
               int sgnx=(j%2);
               Z8[gZ8].oR0=(gR0max-gR0min+ 1);
               Z8[gZ8].R0.resize(Z8[gZ8].oR0);
               for(int gR0=gR0min;gR0<=gR0max;gR0++){
                  int jR0=(gR0-gR0min);
                  int gY=( jY +jR0*sgny);
                  Z8[gZ8].R0[jR0].X=gX;
                  Z8[gZ8].R0[jR0].Y=gY;
                  Z8[gZ8].R0[jR0].sgnx=( 1-2*((jR0+sgnx)% 2));
                  Z8[gZ8].R0[jR0].sgny=sgny;
                  vv.XYsub(gX,gY, true);
               }
            }
//
//
// conditions for inclusion of sheet faces
//
            int lX( 99),uX(-99),lY( 99),uY(-99);
            int lYup( 99),lYdown( 99);
            int nu( 0),nd( 0);
            int upen( 0),dpen( 0);
            for(int gZ8= 0;gZ8<iU8;gZ8++){
               int gS8=U8[iU8].Y8[iY8].Z8[gZ8].S8;
               int gG7=M8[iM8].S8[gS8].G7;
               int gR0min=G7[gG7].mR0;
               int gR0max=G7[gG7].nR0;
               for(int gR0=gR0min;gR0<=gR0max;gR0++){
                  int jR0=(gR0-gR0min);
                  int gX=Z8[gZ8].R0[jR0].X;
                  int gY=Z8[gZ8].R0[jR0].Y;
                  if( gX<lX )lX=gX;
                  if( gX>uX )uX=gX;
                  if( gY<lY )lY=gY;
                  if( gY>uY )uY=gY;
                  bool EDGE=( vv.XYsub(gX- 1,gY   )&&
                              vv.XYsub(gX+ 1,gY   )&&
                              vv.XYsub(gX   ,gY- 1)&&
                              vv.XYsub(gX   ,gY+ 1) )? false:  true;
                  int gL1=R0[gR0].L1;
                  int ihphob=igor_data.L1[gL1].hphob;
                  int idoc=igor_data.L1[gL1].doc;
                  if( Z8[gZ8].R0[jR0].sgnx*
                      Z8[gZ8].R0[jR0].sgny== 1 ){
                     if( gY<lYup )lYup=gY;
                     if( EDGE ){
                        if( idoc> 0 )nu+=idoc;
                     }else{
                        if( ihphob< 0 ){
                           nu+=ihphob;
                        }else{
                           nu+=idoc;
                        }
                        char a1=igor_data.L1[gL1].a1;
                        if( (a1=='W')||(a1=='Y') ){
                           upen-=4;
                        }
                     }
                  }else{
                     if( gY<lYdown )lYdown=gY;
                     if( EDGE ){
                        if( idoc> 0 )nd+=idoc;
                     }else{
                        if( ihphob< 0 ){
                           nd+=ihphob;
                        }else{
                           nd+=idoc;
                        }
                        char a1=igor_data.L1[gL1].a1;
                        if( (a1=='W')||(a1=='Y') ){
                           dpen-=4;
                        }
                     }
                  }
               }
            }
            if( (nu<0)||(nd<0) ){
               int j=( nu<nd )? nu: nd;
               nu-=j;
               nd-=j;
            }
            h= double(nu-nd)/( double(nu+nd) +(1.00e-5));
//
//
// reinitialize sheet subset
//
            for(int gZ8= 0;gZ8<iU8;gZ8++){
               int gS8=U8[iU8].Y8[iY8].Z8[gZ8].S8;
               int gG7=M8[iM8].S8[gS8].G7;
               int gR0min=G7[gG7].mR0;
               int gR0max=G7[gG7].nR0;
               for(int gR0=gR0min;gR0<=gR0max;gR0++){
                  int jR0=(gR0-gR0min);
                  int gX=Z8[gZ8].R0[jR0].X;
                  int gY=Z8[gZ8].R0[jR0].Y;
                  vv.XYsub(gX,gY, false);
               }
            }
//
//
// visualize sheet
//
            IGO_SCO3_OPTV(igor_data,out,
                          iM8,iU8,iY8,
                          lX,uX,lY,uY);
            oV8++;
//
//
// up face
//
            if( h>(-.375) ){
               IGO_SCO3_OPTW(igor_data,
                             iM8,iU8,iY8,
                             lX,uX,lY,uY,
                             lYup, 1,upen);
            }
//
//
// down face
//
            if( h<( .375) ){
               IGO_SCO3_OPTW(igor_data,
                             iM8,iU8,iY8,
                             -uX,-lX,lY,uY,
                             lYdown,-1,dpen);
            }
//
         }
      }
   }
//
//
// pack hydrophobic patches
//
   M9.clear();
   M9.push_back( tM9());
   oM9=1;
   int jG7=-1;
   int oS9=-1;
   for(int iW4= 0;iW4<oW4;iW4++){
      int iG7=W4[iW4].K4[ 0].G7;
      if( iG7==jG7 ){
         M9[ 0].S9[oS9].B4.push_back( tM9::tM9S9::tM9S9B4());
         M9[ 0].S9[oS9].B4[M9[ 0].S9[oS9].oB4++].W4=iW4;
      }else{
         jG7=iG7;
         oS9++;
         M9[ 0].S9.push_back( tM9::tM9S9());
         M9[ 0].S9[oS9].B4.push_back( tM9::tM9S9::tM9S9B4());
         M9[ 0].S9[oS9].oB4=1;
         M9[ 0].S9[oS9].B4[ 0].W4=iW4;
         int oK4=W4[iW4].oK4;
         M9[ 0].S9[oS9].K4.resize(oK4);
         M9[ 0].S9[oS9].oK4=oK4;
         for(int iK4= 0;iK4<oK4;iK4++){
            M9[ 0].S9[oS9].K4[iK4].G7=W4[iW4].K4[iK4].G7;
            M9[ 0].S9[oS9].K4[iK4].X=W4[iW4].K4[iK4].X;
            M9[ 0].S9[oS9].K4[iK4].Y=W4[iW4].K4[iK4].Y;
            M9[ 0].S9[oS9].K4[iK4].sgnx=W4[iW4].K4[iK4].sgnx;
            M9[ 0].S9[oS9].K4[iK4].sgny=W4[iW4].K4[iK4].sgny;
         }
      }
   }
   M9[ 0].oS9=++oS9;
   if      ( oS9> 1 ){
      IGO_SCO3_W(physics_consts,array_consts,igor_data,out);
//
   }else if( oS9== 1 ){
      double Fp= (0.00);
      int oK4=M9[ 0].S9[ 0].oK4;
      if( (oK4> 1)&&(oK4==oS8) ){
         Fp= U8[oS8].Y8[ 0].e[ 2];
      }
//
//
// 1-bod config
//
      U9.clear();
      U9.resize( 2);
      oU9=2;
      pU9=1;
      U9[pU9].oY9=1;
      U9[pU9].Y9.push_back( tU9::tU9Y9());
      U9[pU9].Y9[ 0].Z9.push_back( tU9::tU9Y9::tU9Y9Z9());
      U9[pU9].Y9[ 0].Z9[ 0].S9=0;
      U9[pU9].Y9[ 0].e[ 1]= Fp;
      U9[pU9].Y9[ 0].STABLE=true;
      U9[pU9].Y9[ 0].FACTOR=true;
      U9[pU9].Y9[ 0].Z9[ 0].X=0;
      U9[pU9].Y9[ 0].Z9[ 0].e= (0.00);
      U9[pU9].Y9[ 0].Z9[ 0].A=0;
      U9[pU9].Y9[ 0].Z9[ 0].B=0;
      U9[pU9].Y9[ 0].Z9[ 0].K4.resize(oK4);
      U9[pU9].Y9[ 0].Z9[ 0].oK4=oK4;
//
//
// element endpoints of monomer
//
      Z9.clear();
      Z9.resize( 1);
      Z9[ 0].K4.resize(oK4);
      Z9[ 0].oK4=oK4;
      int oB4=M9[ 0].S9[ 0].oB4;
      int iW4=-1;
      int hp=-9;
      for(int jB4= 0;jB4<oB4;jB4++){
         int jW4=M9[ 0].S9[ 0].B4[jB4].W4;
         if( W4[jW4].hp> hp ){
            iW4=jW4;
            hp= W4[jW4].hp;
         }
      }
      int iO1=W4[iW4].O1;
      int iP3=W4[iW4].P3;
      Z9[ 0].t(1)=( 0.00);
      Z9[ 0].t(2)=( 0.00);
      Z9[ 0].c.zero();
      if( oK4==1 ){
         Z9[ 0].K4[ 0].G7=W4[iW4].K4[ 0].G7;
         Z9[ 0].K4[ 0].X=W4[iW4].K4[ 0].X;
         Z9[ 0].K4[ 0].Y=W4[iW4].K4[ 0].Y;
         Z9[ 0].K4[ 0].sgnx=W4[iW4].K4[ 0].sgnx;
         Z9[ 0].K4[ 0].sgny=W4[iW4].K4[ 0].sgny;
         int iG7=W4[iW4].K4[ 0].G7;
         Z9[ 0].t(0)=-igor_data.O1[iO1].P3[iP3].dx;
         double R= (2.278);
         double dthe= physics_consts.PI/(1.80);
         double dz= (1.50);
         double dR0= double( G7[iG7].mR0-W4[iW4].R0);
         double the=( igor_data.O1[iO1].P3[iP3].gam +dR0*dthe);
         double Cthe= std::cos( the);
         double Sthe= std::sin( the);
         double z=( igor_data.O1[iO1].P3[iP3].dz +dR0*dz);
         Z9[ 0].K4[ 0].u(0)= R*Cthe +Z9[ 0].t(0);
         Z9[ 0].K4[ 0].u(1)= R*Sthe;
         Z9[ 0].K4[ 0].u(2)= z;
         Rotation_Matrix rot;
         rot.identity();
         rot(0,0)= Cthe;
         rot(1,0)= Sthe;
         rot(0,1)=-Sthe;
         rot(1,1)= Cthe;
         Coordinates trans=Z9[ 0].t;
         trans(2)-=z;
         dR0= double( G7[iG7].nR0-W4[iW4].R0);
         the=( igor_data.O1[iO1].P3[iP3].gam +dR0*dthe);
         Cthe= std::cos( the);
         Sthe= std::sin( the);
         z=( igor_data.O1[iO1].P3[iP3].dz +dR0*dz);
         Z9[ 0].K4[ 0].v(0)= R*Cthe +Z9[ 0].t(0);
         Z9[ 0].K4[ 0].v(1)= R*Sthe;
         Z9[ 0].K4[ 0].v(2)= z;
         Z9[ 0].K4[ 0].r=rot;
//
      }else{
         double R= (8.75)/( W4[iW4].h*(2.00) +(1.00e-3));
         if( W4[iW4].PAR )R*=( 1.35);
         Z9[ 0].t(0)=( R -igor_data.O1[iO1].P3[iP3].dx);
         Z9[ 0].c(0,0)= ( .50)*physics_consts.PI;
         Z9[ 0].c(1,0)= ( .25)*physics_consts.PI;
         Z9[ 0].c(2,0)= (-.50)*physics_consts.PI;
         Coordinates trans=Z9[ 0].t;
         Rotation_Matrix rot;
         rot.identity();
         double f= (1.)/std::sqrt( (2.));
         rot(1,1)= f;
         rot(2,1)=-f;
         rot(1,2)= f;
         rot(2,2)= f;
         for(int iK4= 0;iK4<oK4;iK4++){
            Z9[ 0].K4[iK4].G7=W4[iW4].K4[iK4].G7;
            Z9[ 0].K4[iK4].X=W4[iW4].K4[iK4].X;
            Z9[ 0].K4[iK4].Y=W4[iW4].K4[iK4].Y;
            Z9[ 0].K4[iK4].sgnx=W4[iW4].K4[iK4].sgnx;
            Z9[ 0].K4[iK4].sgny=W4[iW4].K4[iK4].sgny;
            int iG7=W4[iW4].K4[iK4].G7;
            Coordinates u,v;
            double dthe= f/R;
            double dz= f;
            int iX=(W4[iW4].R0/W4[iW4].oY);
            int iY=(W4[iW4].R0%W4[iW4].oY);
            double i= double( W4[iW4].K4[iK4].X-iX)*(5.)
                     +igor_data.O1[iO1].P3[iP3].dy;
            double j= double( W4[iW4].K4[iK4].Y-iY)*(3.)
                     +igor_data.O1[iO1].P3[iP3].dz;
            double the=( physics_consts.PI +(-i +j)*dthe);
            double Cthe= std::cos( the);
            double Sthe= std::sin( the);
            double z= ( i +j)*dz;
            u(0)= R*Cthe;
            u(1)= R*Sthe;
            u(2)= z;
            Rotation_Matrix T;
            T.identity();
            T(0,0)= Cthe;
            T(1,0)= Sthe;
            T(0,1)=-Sthe;
            T(1,1)= Cthe;
            double dR= double( G7[iG7].nR0-G7[iG7].mR0);
            j+=dR*(3.)*W4[iW4].K4[iK4].sgny;
            the=( physics_consts.PI +(-i +j)*dthe);
            Cthe= std::cos( the);
            Sthe= std::sin( the);
            z= ( i +j)*dz;
            v(0)= R*Cthe;
            v(1)= R*Sthe;
            v(2)= z;
            Z9[ 0].K4[iK4].u=( trans +rot*u);
            Z9[ 0].K4[iK4].v=( trans +rot*v);
            Z9[ 0].K4[iK4].r=rot*T;
         }
//
      }
      for(int iK4= 0;iK4<oK4;iK4++){
         U9[pU9].Y9[ 0].Z9[ 0].K4[iK4].G7=Z9[ 0].K4[iK4].G7;
         U9[pU9].Y9[ 0].Z9[ 0].K4[iK4].X=Z9[ 0].K4[iK4].X;
         U9[pU9].Y9[ 0].Z9[ 0].K4[iK4].Y=Z9[ 0].K4[iK4].Y;
         U9[pU9].Y9[ 0].Z9[ 0].K4[iK4].sgnx=Z9[ 0].K4[iK4].sgnx;
         U9[pU9].Y9[ 0].Z9[ 0].K4[iK4].sgny=Z9[ 0].K4[iK4].sgny;
         U9[pU9].Y9[ 0].Z9[ 0].K4[iK4].u=Z9[ 0].K4[iK4].u;
         U9[pU9].Y9[ 0].Z9[ 0].K4[iK4].v=Z9[ 0].K4[iK4].v;
         U9[pU9].Y9[ 0].Z9[ 0].K4[iK4].r=Z9[ 0].K4[iK4].r;
      }
      U9[pU9].Y9[ 0].Z9[ 0].t=Z9[ 0].t;
      U9[pU9].Y9[ 0].Z9[ 0].c=Z9[ 0].c;
//
//
// calc Fh and Fm of full config
//
      double Fh= (0.00);
      double Fm= (0.00);
      IGO_SCO3_WOLP(physics_consts,out,-1,-1);
      IGO_SCO3_WPOL(physics_consts,igor_data,out,
                    Fm,Fh);
      SCORE3b=( ( .35)*Fp +( .65)*Fh);
      SCORE3c= Fm;
      U9[pU9].Y9[ 0].e[ 0]=( ( .35)*Fp +( .65)*Fh +Fm);
      U9[pU9].Y9[ 0].e[ 2]= Fh;
      U9[pU9].Y9[ 0].e[ 3]= Fm;
//
//
// element endpoints of monomer
//
      oT9=1;
      T9.resize(oT9);
      for(int i=0;i<4;i++){
         T9[ 0].e[ i]= U9[pU9].Y9[ 0].e[ i];
      }
      T9[ 0].U9=pU9;
      T9[ 0].Y9=0;
      T9[ 0].sub=true;
//
   }else if( oS9== 0 ){
      SCORE3b= (0.00);
      SCORE3c= (0.00);
      oU9=0;
      oT9=0;
//
   }
   SCORE3*=alp3;
   SCORE3b*=alp3b;
   SCORE3c*=alp3c;
   return;
}
