#include "../dat/DAT_IGOR_DATA.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Igor_Model::IGO_SCO1(const DAT_IGOR_DATA& igor_data,
                          Output_Streams& out){
   int oC7=igor_data.oC7;
//
//
// range of update
//
   int iG7min(-1),iG7max(-1);
   if( NEWGRP ){
      iG7min= 0;
      iG7max=(oG7-1);
   }else{
      iG7min=mG7grp;
      iG7max=( (nG7grp+ 5)<oG7 )? (nG7grp+ 5): (oG7- 1);
   }
//
//
// element ising model probabilities
//
   for(int iG7=iG7min;iG7<=iG7max;iG7++){
      for(int aC7= 1;aC7<oC7;aC7++){
         G7C7p(iG7,aC7)=
           std::exp( G7C7e(iG7,aC7));
      }
      for(int aC7= 1;aC7<oC7;aC7++){
         G7C7p(iG7,aC7)=
           std::sqrt( G7C7p(iG7,aC7));
      }
   }
   if( NEWGRP ){
      iG7min++;
   }else{
      if( iG7min< 1 )iG7min= 1;
      if( iG7max<(oG7-1) )iG7max++;
   }
   for(int iG7=iG7min;iG7<=iG7max;iG7++){
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            G7C7C7p(iG7,bC7,aC7)=
  std::exp( G7C7C7e(iG7,bC7,aC7));
         }
      }
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            G7C7C7p(iG7,bC7,aC7)*=
              (G7C7p(iG7-1,bC7)
              *G7C7p(iG7  ,aC7));
            G7C7C7p(iG7,bC7,aC7)=
 std::sqrt( G7C7C7p(iG7,bC7,aC7));
         }
      }
   }
   if( NEWGRP ){
      iG7min++;
   }else{
      if( iG7min< 2 )iG7min= 2;
      if( iG7max<(oG7-1) )iG7max++;
   }
   for(int iG7=iG7min;iG7<=iG7max;iG7++){
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               G7C7C7C7p(iG7,cC7,bC7,aC7)=
     std::exp( G7C7C7C7e(iG7,cC7,bC7,aC7));
            }
         }
      }
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               G7C7C7C7p(iG7,cC7,bC7,aC7)*=
                 (G7C7C7p(iG7-1,cC7,bC7)
                 *G7C7C7p(iG7  ,bC7,aC7));
                G7C7C7C7p(iG7,cC7,bC7,aC7)=
     std::sqrt( G7C7C7C7p(iG7,cC7,bC7,aC7));
            }
         }
      }
   }
   if( NEWGRP ){
      iG7min++;
   }else{
      if( iG7min< 3 )iG7min= 3;
      if( iG7max<(oG7-1) )iG7max++;
   }
   for(int iG7=iG7min;iG7<=iG7max;iG7++){
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  G7C7C7C7C7p(iG7,dC7,cC7,bC7,aC7)=
        std::exp( G7C7C7C7C7e(iG7,dC7,cC7,bC7,aC7));
               }
            }
         }
      }
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  G7C7C7C7C7p(iG7,dC7,cC7,bC7,aC7)*=
                    (G7C7C7C7p(iG7-1,dC7,cC7,bC7)
                    *G7C7C7C7p(iG7  ,cC7,bC7,aC7));
                  G7C7C7C7C7p(iG7,dC7,cC7,bC7,aC7)=
       std::sqrt( G7C7C7C7C7p(iG7,dC7,cC7,bC7,aC7));
               }
            }
         }
      }
   }
   if( NEWGRP ){
      iG7min++;
   }else{
      if( iG7min< 4 )iG7min= 4;
      if( iG7max<(oG7-1) )iG7max++;
   }
   for(int iG7=iG7min;iG7<=iG7max;iG7++){
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int eC7= 1;eC7<oC7;eC7++){
                     G7C7C7C7C7C7p(iG7,eC7,dC7,cC7,bC7,aC7)=
           std::exp( G7C7C7C7C7C7e(iG7,eC7,dC7,cC7,bC7,aC7));
                  }
               }
            }
         }
      }
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int eC7= 1;eC7<oC7;eC7++){
                     G7C7C7C7C7C7p(iG7,eC7,dC7,cC7,bC7,aC7)*=
                       (G7C7C7C7C7p(iG7-1,eC7,dC7,cC7,bC7)
                       *G7C7C7C7C7p(iG7  ,dC7,cC7,bC7,aC7));
                     G7C7C7C7C7C7p(iG7,eC7,dC7,cC7,bC7,aC7)=
          std::sqrt( G7C7C7C7C7C7p(iG7,eC7,dC7,cC7,bC7,aC7));
                  }
               }
            }
         }
      }
   }
   if( NEWGRP ){
      iG7min++;
   }else{
      if( iG7min< 5 )iG7min= 5;
      if( iG7max<(oG7-1) )iG7max++;
   }
   for(int iG7=iG7min;iG7<=iG7max;iG7++){
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int eC7= 1;eC7<oC7;eC7++){
                     for(int fC7= 1;fC7<oC7;fC7++){
                        G7C7C7C7C7C7C7p(iG7,fC7,eC7,dC7,cC7,bC7,aC7)=
              std::exp( G7C7C7C7C7C7C7e(iG7,fC7,eC7,dC7,cC7,bC7,aC7));
                     }
                  }
               }
            }
         }
      }
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int eC7= 1;eC7<oC7;eC7++){
                     for(int fC7= 1;fC7<oC7;fC7++){
                        G7C7C7C7C7C7C7p(iG7,fC7,eC7,dC7,cC7,bC7,aC7)*=
                          (G7C7C7C7C7C7p(iG7-1,fC7,eC7,dC7,cC7,bC7)
                          *G7C7C7C7C7C7p(iG7  ,eC7,dC7,cC7,bC7,aC7));
                     }
                  }
               }
            }
         }
      }
   }
//
//
// load ising model
//
   if( NEWGRP ){
      iG7min= 0;
      iG7max=(oG7+ 4);
   }else{
      iG7min=mG7grp;
      iG7max=( (nG7grp+10)<(oG7+ 5) )? (nG7grp+10): (oG7+ 4);
   }
   for(int iG7=iG7min;iG7<=iG7max;iG7++){
      if      ( (iG7== 0) ){
         for(int aC7= 1;aC7<oC7;aC7++){
            G7C7C7C7C7C7C7a(iG7, 0, 0, 0, 0, 0,aC7)=
                                     G7C7p(iG7,aC7);
         }
      }else if( (iG7== 1)&&(iG7<oG7) ){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int aC7= 1;aC7<oC7;aC7++){
               G7C7C7C7C7C7C7a(iG7, 0, 0, 0, 0,bC7,aC7)=
                                   G7C7C7p(iG7,bC7,aC7);
            }
         }
      }else if( (iG7== 2)&&(iG7<oG7) ){
         for(int cC7= 1;cC7<oC7;cC7++){
            for(int bC7= 1;bC7<oC7;bC7++){
               for(int aC7= 1;aC7<oC7;aC7++){
                  G7C7C7C7C7C7C7a(iG7, 0, 0, 0,cC7,bC7,aC7)=
                                 G7C7C7C7p(iG7,cC7,bC7,aC7);
               }
            }
         }
      }else if( (iG7== 3)&&(iG7<oG7) ){
         for(int dC7= 1;dC7<oC7;dC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int bC7= 1;bC7<oC7;bC7++){
                  for(int aC7= 1;aC7<oC7;aC7++){
                     G7C7C7C7C7C7C7a(iG7, 0, 0,dC7,cC7,bC7,aC7)=
                               G7C7C7C7C7p(iG7,dC7,cC7,bC7,aC7);
                  }
               }
            }
         }
      }else if( (iG7== 4)&&(iG7<oG7) ){
         for(int eC7= 1;eC7<oC7;eC7++){
            for(int dC7= 1;dC7<oC7;dC7++){
               for(int cC7= 1;cC7<oC7;cC7++){
                  for(int bC7= 1;bC7<oC7;bC7++){
                     for(int aC7= 1;aC7<oC7;aC7++){
                        G7C7C7C7C7C7C7a(iG7, 0,eC7,dC7,cC7,bC7,aC7)=
                             G7C7C7C7C7C7p(iG7,eC7,dC7,cC7,bC7,aC7);
                     }
                  }
               }
            }
         }
      }else if( (iG7<oG7) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int cC7= 1;cC7<oC7;cC7++){
                     for(int bC7= 1;bC7<oC7;bC7++){
                        for(int aC7= 1;aC7<oC7;aC7++){
                           G7C7C7C7C7C7C7a(iG7,fC7,eC7,dC7,cC7,bC7,aC7)=
                           G7C7C7C7C7C7C7p(iG7,fC7,eC7,dC7,cC7,bC7,aC7);
                        }
                     }
                  }
               }
            }
         }
      }else if( (iG7==oG7)&&(oG7> 4) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int cC7= 1;cC7<oC7;cC7++){
                     for(int bC7= 1;bC7<oC7;bC7++){
                        G7C7C7C7C7C7C7a(iG7,fC7,eC7,dC7,cC7,bC7, 0)=
                          G7C7C7C7C7C7p(oG7-1,fC7,eC7,dC7,cC7,bC7);
                     }
                  }
               }
            }
         }
      }else if( (iG7==(oG7+1))&&(oG7> 3) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int cC7= 1;cC7<oC7;cC7++){
                     G7C7C7C7C7C7C7a(iG7,fC7,eC7,dC7,cC7, 0, 0)=
                         G7C7C7C7C7p(oG7-1,fC7,eC7,dC7,cC7);
                  }
               }
            }
         }
      }else if( (iG7==(oG7+2))&&(oG7> 2) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  G7C7C7C7C7C7C7a(iG7,fC7,eC7,dC7, 0, 0, 0)=
                        G7C7C7C7p(oG7-1,fC7,eC7,dC7);
               }
            }
         }
      }else if( (iG7==(oG7+3))&&(oG7> 1) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               G7C7C7C7C7C7C7a(iG7,fC7,eC7, 0, 0, 0, 0)=
                       G7C7C7p(oG7-1,fC7,eC7);
            }
         }
      }else if( (iG7==(oG7+4)) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            G7C7C7C7C7C7C7a(iG7,fC7, 0, 0, 0, 0, 0)=
                      G7C7p(oG7-1,fC7);
         }
      }else{
         for(int fC7= 0;fC7<oC7;fC7++){
            for(int eC7= 0;eC7<oC7;eC7++){
               for(int dC7= 0;dC7<oC7;dC7++){
                  for(int cC7= 0;cC7<oC7;cC7++){
                     for(int bC7= 0;bC7<oC7;bC7++){
                        for(int aC7= 0;aC7<oC7;aC7++){
                           G7C7C7C7C7C7C7a(iG7,fC7,eC7,dC7,cC7,bC7,aC7)= (1.00);
                        }
                     }
                  }
               }
            }
         }
      }
   }
//
//
// bounds of path
//
   if( NEWGRP ){
      for(int iG7=-5;iG7< 0;iG7++){
         G7mC7(iG7)= 0;
         G7nC7(iG7)= 1;
      }
      for(int iG7= 0;iG7<oG7;iG7++){
         G7mC7(iG7)= 1;
         G7nC7(iG7)=oC7;
      }
      for(int iG7=oG7;iG7<(oG7+5);iG7++){
         G7mC7(iG7)= 0;
         G7nC7(iG7)= 1;
      }
   }
//
//
// partial sums of partition func, backward and forward
//
   if( NEWGRP ){
      G7C7C7C7C7C7z(oG7+4, 0, 0, 0, 0, 0)= (1.00);
      iG7max=(oG7+3);
   }else{
      iG7max=( (nG7grp+ 9)<(oG7+ 4) )? (nG7grp+ 9): (oG7+ 3);
   }
   for(int iG7=iG7max;iG7>(-2   );iG7--){
      int fC7min=G7mC7(iG7-4);
      int fC7max=G7nC7(iG7-4);
      int eC7min=G7mC7(iG7-3);
      int eC7max=G7nC7(iG7-3);
      int dC7min=G7mC7(iG7-2);
      int dC7max=G7nC7(iG7-2);
      int cC7min=G7mC7(iG7-1);
      int cC7max=G7nC7(iG7-1);
      int bC7min=G7mC7(iG7  );
      int bC7max=G7nC7(iG7  );
      int aC7min=G7mC7(iG7+1);
      int aC7max=G7nC7(iG7+1);
      for(int fC7=fC7min;fC7<fC7max;fC7++){
         for(int eC7=eC7min;eC7<eC7max;eC7++){
            for(int dC7=dC7min;dC7<dC7max;dC7++){
               for(int cC7=cC7min;cC7<cC7max;cC7++){
                  for(int bC7=bC7min;bC7<bC7max;bC7++){
                     G7C7C7C7C7C7z(iG7  ,fC7,eC7,dC7,cC7,bC7)= (0.00);
                     for(int aC7=aC7min;aC7<aC7max;aC7++){
                        G7C7C7C7C7C7z(iG7  ,fC7,eC7,dC7,cC7,bC7)+=
                      G7C7C7C7C7C7C7a(iG7+1,fC7,eC7,dC7,cC7,bC7,aC7)
                           *G7C7C7C7C7C7z(iG7+1,eC7,dC7,cC7,bC7,aC7);
                     }
                  }
               }
            }
         }
      }
   }
   double z= G7C7C7C7C7C7z(-1  , 0, 0, 0, 0, 0);
   g1= std::log( z);
   if( NEWGRP ){
      G7C7C7C7C7C7q(-1  , 0, 0, 0, 0, 0)= (1.00);
      iG7min=( 0   );
   }else{
      iG7min=mG7grp;
   }
   for(int iG7=iG7min;iG7<(oG7+5);iG7++){
      int fC7min=G7mC7(iG7-5);
      int fC7max=G7nC7(iG7-5);
      int eC7min=G7mC7(iG7-4);
      int eC7max=G7nC7(iG7-4);
      int dC7min=G7mC7(iG7-3);
      int dC7max=G7nC7(iG7-3);
      int cC7min=G7mC7(iG7-2);
      int cC7max=G7nC7(iG7-2);
      int bC7min=G7mC7(iG7-1);
      int bC7max=G7nC7(iG7-1);
      int aC7min=G7mC7(iG7  );
      int aC7max=G7nC7(iG7  );
      for(int eC7=eC7min;eC7<eC7max;eC7++){
         for(int dC7=dC7min;dC7<dC7max;dC7++){
            for(int cC7=cC7min;cC7<cC7max;cC7++){
               for(int bC7=bC7min;bC7<bC7max;bC7++){
                  for(int aC7=aC7min;aC7<aC7max;aC7++){
                     G7C7C7C7C7C7q(iG7  ,eC7,dC7,cC7,bC7,aC7)= (0.00);
                     for(int fC7=fC7min;fC7<fC7max;fC7++){
                        G7C7C7C7C7C7q(iG7  ,eC7,dC7,cC7,bC7,aC7)+=
                  G7C7C7C7C7C7C7a(iG7  ,fC7,eC7,dC7,cC7,bC7,aC7)
                   *G7C7C7C7C7C7q(iG7-1,fC7,eC7,dC7,cC7,bC7);
                     }
                  }
               }
            }
         }
      }
   }
//
//
// element probabilities
//
   for(int iG7= 0;iG7<oG7;iG7++){
      int eC7min=G7mC7(iG7-4);
      int eC7max=G7nC7(iG7-4);
      int dC7min=G7mC7(iG7-3);
      int dC7max=G7nC7(iG7-3);
      int cC7min=G7mC7(iG7-2);
      int cC7max=G7nC7(iG7-2);
      int bC7min=G7mC7(iG7-1);
      int bC7max=G7nC7(iG7-1);
      double zz= (0.00);
      for(int iC7= 1;iC7<oC7;iC7++){
         C7p(iC7)= (0.00);
         for(int eC7=eC7min;eC7<eC7max;eC7++){
            for(int dC7=dC7min;dC7<dC7max;dC7++){
               for(int cC7=cC7min;cC7<cC7max;cC7++){
                  for(int bC7=bC7min;bC7<bC7max;bC7++){
                     C7p(iC7)+=(G7C7C7C7C7C7z(iG7  ,eC7,dC7,cC7,bC7,iC7)
                               *G7C7C7C7C7C7q(iG7  ,eC7,dC7,cC7,bC7,iC7));
                  }
               }
            }
         }
         zz+=C7p(iC7);
      }
      for(int iC7= 1;iC7<oC7;iC7++){
         C7p(iC7)/=zz;
         if( C7p(iC7)<(1.00e-20) )C7p(iC7)= (1.00e-20);
      }
      double pmax= (0.00);
      for(int iC7= 1;iC7<oC7;iC7++){
         G7[iG7].C7p0(iC7)= C7p(iC7);
         G7[iG7].C7e0(iC7)= std::log( C7p(iC7)/igor_data.C7[iC7].p0);
         if( C7p(iC7)>pmax ){
            pmax= C7p(iC7);
            G7[iG7].C70=iC7;
         }
      }
   }
//
//
// disallow consecutive elem states
//
   for(int iG7= 1;iG7<oG7;iG7++){
      int iC7=G7[iG7   ].C70;
      int jC7=G7[iG7- 1].C70;
      if      ( iC7==1 ){
         if      ( jC7==1 ){
            g1-=( 20.00);
         }else if( jC7==2 ){
            g1-=( 12.00);
         }else if( jC7==3 ){
         }
      }else if( iC7==2 ){
         if      ( jC7==1 ){
            g1-=( 12.00);
         }else if( jC7==2 ){
            g1-=( 20.00);
         }else if( jC7==3 ){
         }
      }else if( iC7==3 ){
         if      ( jC7==1 ){
         }else if( jC7==2 ){
         }else if( jC7==3 ){
            g1-=( 20.00);
         }
      }
   }
//
//
// entropy
//
   double s=-std::log( z);
   for(int iG7=( 0  );iG7<(oG7+ 5);iG7++){
      int fC7min=G7mC7(iG7-5);
      int fC7max=G7nC7(iG7-5);
      int eC7min=G7mC7(iG7-4);
      int eC7max=G7nC7(iG7-4);
      int dC7min=G7mC7(iG7-3);
      int dC7max=G7nC7(iG7-3);
      int cC7min=G7mC7(iG7-2);
      int cC7max=G7nC7(iG7-2);
      int bC7min=G7mC7(iG7-1);
      int bC7max=G7nC7(iG7-1);
      int aC7min=G7mC7(iG7  );
      int aC7max=G7nC7(iG7  );
      for(int fC7=fC7min;fC7<fC7max;fC7++){
         for(int eC7=eC7min;eC7<eC7max;eC7++){
            for(int dC7=dC7min;dC7<dC7max;dC7++){
               for(int cC7=cC7min;cC7<cC7max;cC7++){
                  for(int bC7=bC7min;bC7<bC7max;bC7++){
                     for(int aC7=aC7min;aC7<aC7max;aC7++){
                        s+=(G7C7C7C7C7C7z(iG7  ,eC7,dC7,cC7,bC7,aC7)
                     *G7C7C7C7C7C7C7a(iG7  ,fC7,eC7,dC7,cC7,bC7,aC7)
                       *G7C7C7C7C7C7q(iG7-1,fC7,eC7,dC7,cC7,bC7)/z)
           *std::log( G7C7C7C7C7C7C7a(iG7  ,fC7,eC7,dC7,cC7,bC7,aC7));
                     }
                  }
               }
            }
         }
      }
   }
   s1=-s;
//
//
// enthalpy, alt entropy
//
   SCORE1=(( g1 -s1) -( g0 -s0));
   SCORE1*=alp1;
   SCORE1b= (0.00);
   SCORE1b*=alp1b;
//
//
// diagnostic output
//
   if( out.VERBOSE&&false ){
      out.FILE3<< std::fixed;
      out.FILE3<<"Free Energy and Entropy\n";
      out.FILE3<<"    G   ""    S   \n";
      out.FILE3<< std::setprecision( 2)
               << std::setw( 8)<<g1
               << std::setw( 8)<<s1<<'\n';
   }
   return;
}
