#include "../dat/DAT_IGOR_DATA.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Igor_Model::IGO_RPROB(const DAT_IGOR_DATA& igor_data,
                           Output_Streams& out){
   int oC7=igor_data.oC7;
   g0= (0.00);
//
//
// set residue probabilities
//
   for(int iR0= 0;iR0<oR0;iR0++){
      double z= (0.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         R0C7p(iR0,aC7)=
           std::exp( R0C7e(iR0,aC7));
         z+=R0C7p(iR0,aC7);
      }
      z/=(  3.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         R0C7p(iR0,aC7)/=z;
         R0C7p(iR0,aC7)=
           std::sqrt( R0C7p(iR0,aC7));
      }
      g0+=std::log( z);
   }
   for(int iR0= 1;iR0<oR0;iR0++){
      double z= (0.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            R0C7C7p(iR0,bC7,aC7)=
  std::exp( R0C7C7e(iR0,bC7,aC7));
            z+=R0C7C7p(iR0,bC7,aC7);
         }
      }
      z/=(  9.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            R0C7C7p(iR0,bC7,aC7)/=z;
            R0C7C7p(iR0,bC7,aC7)*=
              (R0C7p(iR0-1,bC7)
              *R0C7p(iR0  ,aC7));
            R0C7C7p(iR0,bC7,aC7)=
 std::sqrt( R0C7C7p(iR0,bC7,aC7));
         }
      }
      g0+=std::log( z);
   }
   for(int iR0= 2;iR0<oR0;iR0++){
      double z= (0.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               R0C7C7C7p(iR0,cC7,bC7,aC7)=
     std::exp( R0C7C7C7e(iR0,cC7,bC7,aC7));
               z+=R0C7C7C7p(iR0,cC7,bC7,aC7);
            }
         }
      }
      z/=( 27.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               R0C7C7C7p(iR0,cC7,bC7,aC7)/=z;
               R0C7C7C7p(iR0,cC7,bC7,aC7)*=
                 (R0C7C7p(iR0-1,cC7,bC7)
                 *R0C7C7p(iR0  ,bC7,aC7));
               R0C7C7C7p(iR0,cC7,bC7,aC7)=
    std::sqrt( R0C7C7C7p(iR0,cC7,bC7,aC7));
            }
         }
      }
      g0+=std::log( z);
   }
   for(int iR0= 3;iR0<oR0;iR0++){
      double z= (0.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  R0C7C7C7C7p(iR0,dC7,cC7,bC7,aC7)=
        std::exp( R0C7C7C7C7e(iR0,dC7,cC7,bC7,aC7));
                  z+=R0C7C7C7C7p(iR0,dC7,cC7,bC7,aC7);
               }
            }
         }
      }
      z/=( 81.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  R0C7C7C7C7p(iR0,dC7,cC7,bC7,aC7)/=z;
                  R0C7C7C7C7p(iR0,dC7,cC7,bC7,aC7)*=
                    (R0C7C7C7p(iR0-1,dC7,cC7,bC7)
                    *R0C7C7C7p(iR0  ,cC7,bC7,aC7));
                  R0C7C7C7C7p(iR0,dC7,cC7,bC7,aC7)=
       std::sqrt( R0C7C7C7C7p(iR0,dC7,cC7,bC7,aC7));
               }
            }
         }
      }
      g0+=std::log( z);
   }
   for(int iR0= 4;iR0<oR0;iR0++){
      double z= (0.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int eC7= 1;eC7<oC7;eC7++){
                     R0C7C7C7C7C7p(iR0,eC7,dC7,cC7,bC7,aC7)=
           std::exp( R0C7C7C7C7C7e(iR0,eC7,dC7,cC7,bC7,aC7));
                     z+=R0C7C7C7C7C7p(iR0,eC7,dC7,cC7,bC7,aC7);
                  }
               }
            }
         }
      }
      z/=(243.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int eC7= 1;eC7<oC7;eC7++){
                     R0C7C7C7C7C7p(iR0,eC7,dC7,cC7,bC7,aC7)/=z;
                     R0C7C7C7C7C7p(iR0,eC7,dC7,cC7,bC7,aC7)*=
                       (R0C7C7C7C7p(iR0-1,eC7,dC7,cC7,bC7)
                       *R0C7C7C7C7p(iR0  ,dC7,cC7,bC7,aC7));
                     R0C7C7C7C7C7p(iR0,eC7,dC7,cC7,bC7,aC7)=
          std::sqrt( R0C7C7C7C7C7p(iR0,eC7,dC7,cC7,bC7,aC7));
                  }
               }
            }
         }
      }
      g0+=std::log( z);
   }
   for(int iR0= 5;iR0<oR0;iR0++){
      double z= (0.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int eC7= 1;eC7<oC7;eC7++){
                     for(int fC7= 1;fC7<oC7;fC7++){
                        R0C7C7C7C7C7C7p(iR0,fC7,eC7,dC7,cC7,bC7,aC7)=
              std::exp( R0C7C7C7C7C7C7e(iR0,fC7,eC7,dC7,cC7,
                                                        bC7,aC7));
                        z+=R0C7C7C7C7C7C7p(iR0,fC7,eC7,dC7,cC7,bC7,aC7);
                     }
                  }
               }
            }
         }
      }
      z/=(729.00);
      for(int aC7= 1;aC7<oC7;aC7++){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int eC7= 1;eC7<oC7;eC7++){
                     for(int fC7= 1;fC7<oC7;fC7++){
                        R0C7C7C7C7C7C7p(iR0,fC7,eC7,dC7,cC7,bC7,aC7)/=z;
                        R0C7C7C7C7C7C7p(iR0,fC7,eC7,dC7,cC7,bC7,aC7)*=
                          (R0C7C7C7C7C7p(iR0-1,fC7,eC7,dC7,cC7,bC7)
                          *R0C7C7C7C7C7p(iR0  ,eC7,dC7,cC7,bC7,aC7));
                     }
                  }
               }
            }
         }
      }
      g0+=std::log( z);
   }
//
//
// load ising model
//
   for(int iR0= 0;iR0<(oR0+6);iR0++){
      if      ( (iR0== 0) ){
         for(int aC7= 1;aC7<oC7;aC7++){
            R0C7C7C7C7C7C7a(iR0, 0, 0, 0, 0, 0,aC7)=
                                     R0C7p(iR0,aC7);
         }
      }else if( (iR0== 1)&&(iR0<oR0) ){
         for(int bC7= 1;bC7<oC7;bC7++){
            for(int aC7= 1;aC7<oC7;aC7++){
               R0C7C7C7C7C7C7a(iR0, 0, 0, 0, 0,bC7,aC7)=
                                   R0C7C7p(iR0,bC7,aC7);
            }
         }
      }else if( (iR0== 2)&&(iR0<oR0) ){
         for(int cC7= 1;cC7<oC7;cC7++){
            for(int bC7= 1;bC7<oC7;bC7++){
               for(int aC7= 1;aC7<oC7;aC7++){
                  R0C7C7C7C7C7C7a(iR0, 0, 0, 0,cC7,bC7,aC7)=
                                 R0C7C7C7p(iR0,cC7,bC7,aC7);
               }
            }
         }
      }else if( (iR0== 3)&&(iR0<oR0) ){
         for(int dC7= 1;dC7<oC7;dC7++){
            for(int cC7= 1;cC7<oC7;cC7++){
               for(int bC7= 1;bC7<oC7;bC7++){
                  for(int aC7= 1;aC7<oC7;aC7++){
                     R0C7C7C7C7C7C7a(iR0, 0, 0,dC7,cC7,bC7,aC7)=
                               R0C7C7C7C7p(iR0,dC7,cC7,bC7,aC7);
                  }
               }
            }
         }
      }else if( (iR0== 4)&&(iR0<oR0) ){
         for(int eC7= 1;eC7<oC7;eC7++){
            for(int dC7= 1;dC7<oC7;dC7++){
               for(int cC7= 1;cC7<oC7;cC7++){
                  for(int bC7= 1;bC7<oC7;bC7++){
                     for(int aC7= 1;aC7<oC7;aC7++){
                        R0C7C7C7C7C7C7a(iR0, 0,eC7,dC7,cC7,bC7,aC7)=
                             R0C7C7C7C7C7p(iR0,eC7,dC7,cC7,bC7,aC7);
                     }
                  }
               }
            }
         }
      }else if( (iR0<oR0) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int cC7= 1;cC7<oC7;cC7++){
                     for(int bC7= 1;bC7<oC7;bC7++){
                        for(int aC7= 1;aC7<oC7;aC7++){
                           R0C7C7C7C7C7C7a(iR0,fC7,eC7,dC7,cC7,bC7,aC7)=
                           R0C7C7C7C7C7C7p(iR0,fC7,eC7,dC7,cC7,bC7,aC7);
                        }
                     }
                  }
               }
            }
         }
      }else if( (iR0==oR0)&&(oR0> 4) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int cC7= 1;cC7<oC7;cC7++){
                     for(int bC7= 1;bC7<oC7;bC7++){
                        R0C7C7C7C7C7C7a(iR0,fC7,eC7,dC7,cC7,bC7, 0)=
                        R0C7C7C7C7C7p(oR0-1,fC7,eC7,dC7,cC7,bC7);
                     }
                  }
               }
            }
         }
      }else if( (iR0==oR0) ){
      }else if( (iR0==(oR0+1))&&(oR0> 3) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  for(int cC7= 1;cC7<oC7;cC7++){
                     R0C7C7C7C7C7C7a(iR0,fC7,eC7,dC7,cC7, 0, 0)=
                       R0C7C7C7C7p(oR0-1,fC7,eC7,dC7,cC7);
                  }
               }
            }
         }
      }else if( (iR0==(oR0+1)) ){
      }else if( (iR0==(oR0+2))&&(oR0> 2) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               for(int dC7= 1;dC7<oC7;dC7++){
                  R0C7C7C7C7C7C7a(iR0,fC7,eC7,dC7, 0, 0, 0)=
                      R0C7C7C7p(oR0-1,fC7,eC7,dC7);
               }
            }
         }
      }else if( (iR0==(oR0+2)) ){
      }else if( (iR0==(oR0+3))&&(oR0> 1) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            for(int eC7= 1;eC7<oC7;eC7++){
               R0C7C7C7C7C7C7a(iR0,fC7,eC7, 0, 0, 0, 0)=
                     R0C7C7p(oR0-1,fC7,eC7);
            }
         }
      }else if( (iR0==(oR0+3)) ){
      }else if( (iR0==(oR0+4)) ){
         for(int fC7= 1;fC7<oC7;fC7++){
            R0C7C7C7C7C7C7a(iR0,fC7, 0, 0, 0, 0, 0)=
                    R0C7p(oR0-1,fC7);
         }
      }
   }
//
//
// set bounds of path
//
   for(int iR0=-5;iR0< 0;iR0++){
      R0mC7(iR0)= 0;
      R0nC7(iR0)= 1;
   }
   for(int iR0= 0;iR0<oR0;iR0++){
      R0mC7(iR0)= 1;
      R0nC7(iR0)=oC7;
   }
   for(int iR0=oR0;iR0<(oR0+5);iR0++){
      R0mC7(iR0)= 0;
      R0nC7(iR0)= 1;
   }
//
//
// partial sums of partition func, backward and forward
//
   double s= g0;
   R0C7C7C7C7C7z(oR0+4, 0, 0, 0, 0, 0)= (1.00);
   for(int iR0=(oR0+3);iR0>(-2   );iR0--){
      int fC7min=R0mC7(iR0-4);
      int fC7max=R0nC7(iR0-4);
      int eC7min=R0mC7(iR0-3);
      int eC7max=R0nC7(iR0-3);
      int dC7min=R0mC7(iR0-2);
      int dC7max=R0nC7(iR0-2);
      int cC7min=R0mC7(iR0-1);
      int cC7max=R0nC7(iR0-1);
      int bC7min=R0mC7(iR0  );
      int bC7max=R0nC7(iR0  );
      int aC7min=R0mC7(iR0+1);
      int aC7max=R0nC7(iR0+1);
      double z= (0.00);
      for(int fC7=fC7min;fC7<fC7max;fC7++){
         for(int eC7=eC7min;eC7<eC7max;eC7++){
            for(int dC7=dC7min;dC7<dC7max;dC7++){
               for(int cC7=cC7min;cC7<cC7max;cC7++){
                  for(int bC7=bC7min;bC7<bC7max;bC7++){
                     R0C7C7C7C7C7z(iR0  ,fC7,eC7,dC7,cC7,bC7)= (0.00);
                     for(int aC7=aC7min;aC7<aC7max;aC7++){
                        R0C7C7C7C7C7z(iR0  ,fC7,eC7,dC7,cC7,bC7)+=
                      R0C7C7C7C7C7C7a(iR0+1,fC7,eC7,dC7,cC7,bC7,aC7)
                           *R0C7C7C7C7C7z(iR0+1,eC7,dC7,cC7,bC7,aC7);
                     }
                     z+=R0C7C7C7C7C7z(iR0  ,fC7,eC7,dC7,cC7,bC7);
                  }
               }
            }
         }
      }
      for(int fC7=fC7min;fC7<fC7max;fC7++){
         for(int eC7=eC7min;eC7<eC7max;eC7++){
            for(int dC7=dC7min;dC7<dC7max;dC7++){
               for(int cC7=cC7min;cC7<cC7max;cC7++){
                  for(int bC7=bC7min;bC7<bC7max;bC7++){
                     R0C7C7C7C7C7z(iR0  ,fC7,eC7,dC7,cC7,bC7)/=z;
                  }
               }
            }
         }
      }
      g0+=std::log( z);
   }
   R0C7C7C7C7C7q(-1  , 0, 0, 0, 0, 0)= (1.00);
   for(int iR0=( 0   );iR0<(oR0+5);iR0++){
      int fC7min=R0mC7(iR0-5);
      int fC7max=R0nC7(iR0-5);
      int eC7min=R0mC7(iR0-4);
      int eC7max=R0nC7(iR0-4);
      int dC7min=R0mC7(iR0-3);
      int dC7max=R0nC7(iR0-3);
      int cC7min=R0mC7(iR0-2);
      int cC7max=R0nC7(iR0-2);
      int bC7min=R0mC7(iR0-1);
      int bC7max=R0nC7(iR0-1);
      int aC7min=R0mC7(iR0  );
      int aC7max=R0nC7(iR0  );
      double z= (0.00);
      for(int eC7=eC7min;eC7<eC7max;eC7++){
         for(int dC7=dC7min;dC7<dC7max;dC7++){
            for(int cC7=cC7min;cC7<cC7max;cC7++){
               for(int bC7=bC7min;bC7<bC7max;bC7++){
                  for(int aC7=aC7min;aC7<aC7max;aC7++){
                     R0C7C7C7C7C7q(iR0  ,eC7,dC7,cC7,bC7,aC7)= (0.00);
                     for(int fC7=fC7min;fC7<fC7max;fC7++){
                        R0C7C7C7C7C7q(iR0  ,eC7,dC7,cC7,bC7,aC7)+=
                  R0C7C7C7C7C7C7a(iR0  ,fC7,eC7,dC7,cC7,bC7,aC7)
                   *R0C7C7C7C7C7q(iR0-1,fC7,eC7,dC7,cC7,bC7);
                     }
                     z+=R0C7C7C7C7C7q(iR0  ,eC7,dC7,cC7,bC7,aC7);
                  }
               }
            }
         }
      }
      for(int eC7=eC7min;eC7<eC7max;eC7++){
         for(int dC7=dC7min;dC7<dC7max;dC7++){
            for(int cC7=cC7min;cC7<cC7max;cC7++){
               for(int bC7=bC7min;bC7<bC7max;bC7++){
                  for(int aC7=aC7min;aC7<aC7max;aC7++){
                     R0C7C7C7C7C7q(iR0  ,eC7,dC7,cC7,bC7,aC7)/=z;
                  }
               }
            }
         }
      }
   }
//
//
// residue probabilities
//
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int iC7= 1;iC7<oC7;iC7++){
         C7p(iC7)=( 1.00e-12);
      }
      int eC7min=R0mC7(iR0-4);
      int eC7max=R0nC7(iR0-4);
      int dC7min=R0mC7(iR0-3);
      int dC7max=R0nC7(iR0-3);
      int cC7min=R0mC7(iR0-2);
      int cC7max=R0nC7(iR0-2);
      int bC7min=R0mC7(iR0-1);
      int bC7max=R0nC7(iR0-1);
      int aC7min=R0mC7(iR0  );
      int aC7max=R0nC7(iR0  );
      double z= (0.00);
      for(int aC7=aC7min;aC7<aC7max;aC7++){
         C7p(aC7)= (0.00);
         for(int eC7=eC7min;eC7<eC7max;eC7++){
            for(int dC7=dC7min;dC7<dC7max;dC7++){
               for(int cC7=cC7min;cC7<cC7max;cC7++){
                  for(int bC7=bC7min;bC7<bC7max;bC7++){
                     C7p(aC7)+=
                      (R0C7C7C7C7C7z(iR0  ,eC7,dC7,cC7,bC7,aC7)
                      *R0C7C7C7C7C7q(iR0  ,eC7,dC7,cC7,bC7,aC7));
                  }
               }
            }
         }
         z+=C7p(aC7);
      }
      for(int iC7= 1;iC7<oC7;iC7++){
         C7p(iC7)/=z;
      }
      z= (0.00);
      for(int iC7= 1;iC7<oC7;iC7++){
         R0[iR0].C7p0(iC7)= C7p(iC7);
         R0[iR0].C7e0(iC7)= std::log( C7p(iC7)/igor_data.C7[iC7].p0);
         if( R0[iR0].C7p0(iC7)>z ){
            z= R0[iR0].C7p0(iC7);
            R0[iR0].C70=iC7;
         }
      }
   }
//
//
// entropy
//
   s-=g0;
   for(int iR0=( 0   );iR0<(oR0+5);iR0++){
      double t= (0.00);
      double z= (0.00);
      int fC7min=R0mC7(iR0-5);
      int fC7max=R0nC7(iR0-5);
      int eC7min=R0mC7(iR0-4);
      int eC7max=R0nC7(iR0-4);
      int dC7min=R0mC7(iR0-3);
      int dC7max=R0nC7(iR0-3);
      int cC7min=R0mC7(iR0-2);
      int cC7max=R0nC7(iR0-2);
      int bC7min=R0mC7(iR0-1);
      int bC7max=R0nC7(iR0-1);
      int aC7min=R0mC7(iR0  );
      int aC7max=R0nC7(iR0  );
      for(int fC7=fC7min;fC7<fC7max;fC7++){
         for(int eC7=eC7min;eC7<eC7max;eC7++){
            for(int dC7=dC7min;dC7<dC7max;dC7++){
               for(int cC7=cC7min;cC7<cC7max;cC7++){
                  for(int bC7=bC7min;bC7<bC7max;bC7++){
                     for(int aC7=aC7min;aC7<aC7max;aC7++){
                        double p=
                          (R0C7C7C7C7C7C7a(iR0  ,fC7,eC7,dC7,cC7,bC7,aC7)
                                *R0C7C7C7C7C7z(iR0  ,eC7,dC7,cC7,bC7,aC7)
                            *R0C7C7C7C7C7q(iR0-1,fC7,eC7,dC7,cC7,bC7));
                        double a=
                          R0C7C7C7C7C7C7a(iR0  ,fC7,eC7,dC7,cC7,bC7,aC7);
                        t+=p*std::log( a);
                        z+=p;
                     }
                  }
               }
            }
         }
      }
      s+=(t/z);
   }
   s0=-s;
//
//
// diagnostic output
//
   if( out.VERBOSE ){
      out.FILE3<< std::fixed;
      out.FILE3<<"________\n";
      out.FILE3<<"CALCULATE RESIDUE ISING MODEL RESIDUE PROBABILITIES\n";
      out.FILE3<<"Residue Sequence\n";
      for(int iR0= 0;iR0<oR0;iR0++){
         out.FILE3<<igor_data.L1[R0[iR0].L1].a1;
         if( ((iR0+1)%80==0)||(iR0==(oR0-1)) ){
            out.FILE3<<'\n';
         }
      }
      out.FILE3<<"Predicted State\n";
      for(int iR0= 0;iR0<oR0;iR0++){
         out.FILE3<<igor_data.C7[R0[iR0].C70].a1;
         if( ((iR0+1)%80==0)||(iR0==(oR0-1)) ){
            out.FILE3<<'\n';
         }
      }
//    out.FILE3<<"Free Energy and Entropy\n";
//    out.FILE3<<"    G   ""    S   "<<'\n';
//    out.FILE3<< std::setprecision( 2)
//             << std::setw( 8)<<g0
//             << std::setw( 8)<<s0<<'\n';
      out.FILE3<<"  R0 "" aa ""  "
                 " (H,E,C) probability "" "
                 "    (H,E,C) energy   "<<'\n';
      for(int iR0= 0;iR0<oR0;iR0++){
         out.FILE3<< std::setw( 4)<<iR0<<' '
                  <<igor_data.L1[ R0[iR0].L1].a3<<' '
                  <<igor_data.C7[R0[iR0].C70].a1<<' '
                  << std::setprecision( 4);
         for(int iC7= 1;iC7<oC7;iC7++){
            out.FILE3<< std::setw( 7)<<R0[iR0].C7p0(iC7);
         }
         out.FILE3<<' '<< std::setprecision( 2);
         for(int iC7= 1;iC7<oC7;iC7++){
            out.FILE3<< std::setw( 7)<<R0[iR0].C7e0(iC7);
         }
         out.FILE3<<'\n';
      }
   }
   return;
}
