#include "../dat/DAT_IGOR_DATA.hh"
#include "../igo/Igor_Model.hh"

void Igor_Model::IGO_RLOAD(const DAT_IGOR_DATA& igor_data){
   int oC7=igor_data.oC7;
//
//
// load residue ising model with residue impulses
//
   int nR0=(oR0- 1);
   for(int iR0= 0;iR0<oR0;iR0++){
//
//
// add residue impulses associated with 3-body patterns in sequence
//
      for(int iH7=-4;iH7< 2;iH7++){
         int iP7=0;
         if      ( ((iR0+iH7)< 0)||((iR0+iH7)> nR0) ){
            continue;
         }else if( ((iR0+iH7)==0)||((iR0+iH7)==nR0) ){
         }else{
            iP7=R0[iR0+iH7].P7;
         }
         for(int jH7=(iH7+ 1);jH7< 3;jH7++){
            int jP7=0;
            if      ( ((iR0+jH7)< 0)||((iR0+jH7)> nR0) ){
               continue;
            }else if( ((iR0+jH7)==0)||((iR0+jH7)==nR0) ){
            }else{
               jP7=R0[iR0+jH7].P7;
            }
            for(int kH7=(jH7+ 1);kH7< 4;kH7++){
               int kP7=0;
               if      ( ((iR0+kH7)< 0)||((iR0+kH7)> nR0) ){
                  continue;
               }else if( ((iR0+kH7)==0)||((iR0+kH7)==nR0) ){
               }else{
                  kP7=R0[iR0+kH7].P7;
               }
               if( igor_data.H7H7H7o(iH7,jH7,kH7)< 0 )continue;
               int iH8=( 1 +273 +8208 +igor_data.H7H7H7i(iH7,jH7,kH7)*343
                        +iP7*49 +jP7*7 +kP7);
               IGO_RLOAD_1(igor_data,iR0,iH8);
            }
         }
      }
//
//
// add residue impulses associated with 2-body patterns in sequence
//
      for(int iH7=-4;iH7< 3;iH7++){
         int iO7=0;
         if      ( ((iR0+iH7)< 0)||((iR0+iH7)> nR0) ){
            continue;
         }else if( ((iR0+iH7)==0)||((iR0+iH7)==nR0) ){
         }else{
            iO7=R0[iR0+iH7].O7;
         }
         for(int jH7=(iH7+ 1);jH7< 4;jH7++){
            int jO7=0;
            if      ( ((iR0+jH7)< 0)||((iR0+jH7)> nR0) ){
               continue;
            }else if( ((iR0+jH7)==0)||((iR0+jH7)==nR0) ){
            }else{
               jO7=R0[iR0+jH7].O7;
            }
            if( igor_data.H7H7o(iH7,jH7)< 0 )continue;
            int iH8=( 1 +273 +igor_data.H7H7i(iH7,jH7)*144
                     +iO7*12 +jO7);
            IGO_RLOAD_1(igor_data,iR0,iH8);
         }
      }
//
//
// add residue impulses associated with 1-body patterns in sequence
//
      for(int iH7=-4;iH7< 4;iH7++){
         int iL1=0;
         if      ( ((iR0+iH7)< 0)||((iR0+iH7)> nR0) ){
            continue;
         }else if( ((iR0+iH7)==0)||((iR0+iH7)==nR0) ){
         }else{
            iL1=R0[iR0+iH7].L1;
         }
         if( igor_data.H7o(iH7)< 0 )continue;
         int iH8=( 1 +igor_data.H7i(iH7)*21
                  +iL1);
         IGO_RLOAD_1(igor_data,iR0,iH8);
      }
//
//
// add residue impulses associated with 0-body pattern
//
      int iH8=( 0);
      IGO_RLOAD_1(igor_data,iR0,iH8);
   }
//
//
// add ipulses for transiton from coil to terminal residues
//
   R0C7e( 0, 1)+=( -2.312);
   R0C7e( 0, 2)+=( -1.309);
   R0C7e( 0, 3)+=(  0.500);
   R0C7e(oR0- 1, 1)+=( -2.419);
   R0C7e(oR0- 1, 2)+=( -1.451);
   R0C7e(oR0- 1, 3)+=(  0.500);
   return;
}
