#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Config_Merge.hh"
#include "../igo/Target_Surf.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Config_Merge::IGO_LOQ_WRT(const DAT_PHYSICS_CONSTS& physics_consts,
                               Output_Streams& out,
                               const Target_Surf& enq){

// out.FILE3<<" steps remaining="<< std::setw( 3)<<nM2
//          <<" steps taken="<< std::setw( 3)<<iM2
//          <<" endstate="<< std::setw( 1)<<ENDSTATE<<'\n';
   int n=iM2;
   double f= (1.00)/std::sqrt( enq.oU2);

// if( n>0 ){
//    out.FILE3<<"  i"
//             <<"    "<<" k1"
//             <<" k2"
//             <<" k3"
//             <<"    "<<" k4"
//             <<" k5\n";
//    for(int i=0;i<n;i++){
//       int m=M2[i].k2;
//       out.FILE3<< std::setw( 3)<<i<<"    "
//                << std::setw( 3)<<M2[i].k1
//                << std::setw( 3)<<M2[i].k2
//                << std::setw( 3)<<M2[i].k3<<"  ";
//       for(int j=0;j<m;j++){
//          out.FILE3<<"  "
//                   << std::setw( 3)<<M2[i].k4[j]
//                   << std::setw( 3)<<M2[i].k5[j];
//       }
//       out.FILE3<<'\n';
//    }
// }

   if( n>0 ){
      for(int i=0;i<n;i++){
         M2[i].z= f*std::sqrt( M2[i].z);
         M2[i].bet= f*M2[i].bet;
         M2[i].s0= f*std::sqrt( M2[i].s0);
         int m=M2[i].k2;
         for(int j=0;j<m;j++){
            M2[i].s1[j]= f*std::sqrt( M2[i].s1[j]);
         }
         M2[i].s2= f*std::sqrt( M2[i].s2);
      }
   }
   M2[n].z= f*std::sqrt( M2[n].z);

   out.FILE3<< std::scientific;
   if( out.VERBOSE ){
      out.FILE3<<"  i"
               <<"        F   "
               <<"       z   "
               <<"       b   "
               <<"    lam2   "
               <<"      s2   "
               <<"    delF   \n";
      if( n>0 ){
         for(int i=0;i<n;i++){
            out.FILE3<< std::setw( 3)<<i
                     << std::setprecision(5)
                     << std::setw(12)<<M2[i].tot
                     << std::setprecision(4)
                     << std::setw(11)<<M2[i].z
                     << std::setw(11)<<M2[i].bet
                     << std::setw(11)<<M2[i].lam2
                     << std::setw(11)<<M2[i].s2
                     << std::setprecision(5)
                     << std::setw(12)<<( M2[i].tot +M2[i].delF)<<'\n';
         }
      }
      out.FILE3<< std::setw( 3)<<n
               << std::setprecision(5)<< std::setw(12)<<M2[n].tot
               << std::setprecision(4)<< std::setw(11)<<M2[n].z<<'\n';
   }

// if( n>0 ){
//    out.FILE3<< std::scientific<< std::setprecision(4);
//    out.FILE3<<"  i"
//             <<"    lam0   "
//             <<"      s0   \n";
//    for(int i=0;i<n;i++){
//       out.FILE3<< std::setw( 3)<<i
//                << std::setw(11)<<M2[i].lam0
//                << std::setw(11)<<M2[i].s0<<'\n';
//    }
// }

// if( n>0 ){
//    out.FILE3<< std::scientific<< std::setprecision(4);
//    out.FILE3<<"  i"
//             <<"    lam1   "
//             <<"      s1   "<<'\n';
//    for(int i=0;i<n;i++){
//       out.FILE3<< std::setw( 3)<<i;
//       int m=M2[i].k2;
//       for(int j=0;j<m;j++){
//          out.FILE3<< std::setw(11)<<M2[i].lam1[j]
//                   << std::setw(11)<<M2[i].s1[j];
//       }
//       out.FILE3<<'\n';
//    }
// }

   if( out.VERBOSE ){
      out.FILE3<< std::fixed<< std::setprecision(2);
      out.FILE3<<"      F  "
               <<"     Fa  "
               <<"     Fb  "
               <<"     Fc  "
               <<"     Fd  "
               <<"     Fe  "
               <<"     Ff  "
               <<"     Fg  \n";
      out.FILE3<< std::setw( 9)<<enq.TOT
               << std::setw( 9)<<enq.Fa
               << std::setw( 9)<<enq.Fb
               << std::setw( 9)<<enq.Fc
               << std::setw( 9)<<enq.Fd
               << std::setw( 9)<<enq.Fe
               << std::setw( 9)<<enq.Ff
               << std::setw( 9)<<enq.Fg<<'\n';
   }

   return;
}
