#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Config_Merge.hh"
#include "../igo/Igor_Model.hh"
#include "../igo/Target_Surf.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../str/Output_Streams.hh"

int Config_Merge::IGO_LOQ(const DAT_PHYSICS_CONSTS& physics_consts,
                          Output_Streams& out,
                          Target_Surf& enq,
                          std::vector<Igor_Model::tG7>& G7,
                          std::vector<Igor_Model::tZ9>& Z9,
                          int COMPONENT){
//
//
// lagrange multiplier
//
   int oU2=enq.oU2;
   Lagrange_Multiplier lag(oU2);
   lag.bU2=(oU2-1);
   lag.aU2= 0;
//
//
// optimization traj
//
   int ck1,ck2,ck3,ck4,ck5;             //loop counters
   for(iM2=0;;iM2++){
      enq.IGO_ENQ(physics_consts,out,G7,Z9,COMPONENT);
      IGO_LOQ_BACKUP(lag,enq);
      M2[iM2].tot= lag.TOT;
      double zz= lag.gradient();
      M2[iM2].z= zz;
      if( nM2==0 ){
         return ENDSTATE=0;
      }
      if( zz<EPS1 ){
         return ENDSTATE=0;
      }
      if( (iM2> 0)&&(M2[iM2-1].bet<=BMIN) ){
         return ENDSTATE=0;
      }
//
//
// target step length
//
      double beta1=IGO_LOQ_TARGETBETA();
//
//
// inital lamda st (A+lamda*I) is positive definite
//
      for(ck1=(iM2> 0)? 6: 3;ck1>0;ck1--){
         IGO_LOQ_INITLAMDA(lag,ck1,beta1);
         lag.diagonal();
         bool pd=lag.lower();
         if( pd )break;
      }
      if( ck1==0 ){
         return ENDSTATE=1;
      }
      M2[iM2].k1=(iM2> 0)? (6-ck1): (3-ck1);
      lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
      lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
      double dxx= (0.00);
      double xx=lag.length(dxx);
      M2[iM2].s0= xx;
      M2[iM2].ds0= dxx;
//
//
// decrease lamda st step length > beta1
//
      int k2=0;
      for(ck2=4;ck2>0;ck2--){
         if( xx>(beta1*beta1*( (1.00) -EPS2)) )break;
         if( lag.lamda<=(0.00) )break;

         M2[iM2].k4[k2]=100;
         for(ck4=10;ck4>0;ck4--){
            for(int ii=0;ii<10;ii++){
               lag.step(lag.o_U2x,lag.lamda,lag.o_U2x);
            }
            lag.normalize();
         }

         double dlamda= lag.lamdastep(beta1);
         M2[iM2].lam1[k2]= lag.lamda;

         for(ck5=30;ck5>0;ck5--){
            lag.diagonal();
            bool pd=lag.lower();
            if( pd )break;
            lag.lamda+=dlamda;
            M2[iM2].lam1[k2]= lag.lamda;
            dlamda*=(2.00);
         }
         if( ck5==0 ){
            return ENDSTATE=3;
         }

         M2[iM2].k5[k2]=(30-ck5);
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
         xx=lag.length(dxx);
         M2[iM2].s1[k2]= xx;
         M2[iM2].ds1[k2]= dxx;
         k2++;
      }
      M2[iM2].k2=(4-ck2);
//
//
// increase lamda st step length == beta1
//
      for(ck3=32;ck3>0;ck3--){
         if( xx<=(beta1*beta1*( (1.00) +EPS2)) )break;
         lag.lamdastep(beta1,xx,dxx);
         lag.diagonal();
         bool pd=lag.lower();
         if( !pd ){
            return ENDSTATE=4;
         }
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
         xx=lag.length(dxx);
      }
      M2[iM2].k3=(32-ck3);

      IGO_LOQ_UPDATE(lag,enq);
      M2[iM2].lam2= lag.lamda;
      M2[iM2].s2= xx;
      M2[iM2].ds2= dxx;
      M2[iM2].delF= lag.deltaf();

      nM2--;
   }
}
