#include "../dat/DAT_IGOR_DATA.hh"
#include "../igo/Igor_Model.hh"

void Igor_Model::IGO_GLOADB(const DAT_IGOR_DATA& igor_data){
   int oC7=igor_data.oC7;
//
//
// load element ising model with element impulses
//
   int iG7max(-1),iG7min(-1);
   if( NEWGRP ){
      iG7max=(oG7-1);
      iG7min= 0;
   }else{
      iG7max=( (nG7grp+ 5)<oG7 )? (nG7grp+ 5): (oG7-1);
      iG7min=(mG7grp  );
   }
   for(int iG7= iG7min;iG7<=iG7max;iG7++){
      for(int aC7= 1;aC7<oC7;aC7++){
         G7C7d(iG7,aC7)= (0.00);
         for(int bC7= 1;bC7<oC7;bC7++){
            G7C7C7d(iG7,aC7,bC7)= (0.00);
            for(int cC7= 1;cC7<oC7;cC7++){
               G7C7C7C7d(iG7,aC7,bC7,cC7)= (0.00);
               for(int dC7= 1;dC7<oC7;dC7++){
                  G7C7C7C7C7d(iG7,aC7,bC7,cC7,dC7)= (0.00);
                  for(int eC7= 1;eC7<oC7;eC7++){
                     G7C7C7C7C7C7d(iG7,aC7,bC7,cC7,dC7,eC7)= (0.00);
                     for(int fC7= 1;fC7<oC7;fC7++){
                        G7C7C7C7C7C7C7d(iG7,aC7,bC7,cC7,dC7,eC7,fC7)= (0.00);
                     }
                  }
               }
            }
         }
      }
   }
   for(int iG7=iG7min;iG7<=iG7max;iG7++){
//
//
// add element impulses associated with 3-body patterns in sequence
//
      for(int iH7=-5;iH7<=-2;iH7++){
         if( (iG7+iH7)< 0 )continue;
         int iW7=G7[iG7+iH7].W7;
         for(int jH7=(iH7+1);jH7<=-1;jH7++){
            int jW7=G7[iG7+jH7].W7;
            for(int kH7=(jH7+1);kH7<= 0;kH7++){
               int kW7=G7[iG7+kH7].W7;
               int iH8=( 1 +273 +8208 +igor_data.H7H7H7i(iH7,jH7,kH7)*343
                        +iW7*49 +jW7*7 +kW7);
               IGO_GLOADB_1(igor_data,iG7,iH8);
            }
         }
      }
//
//
// add element impulses associated with 2-body patterns in sequence
//
      for(int iH7=-5;iH7<=-1;iH7++){
         if( (iG7+iH7)< 0 )continue;
         int iV7=G7[iG7+iH7].V7;
         for(int jH7=(iH7+1);jH7<= 0;jH7++){
            int jV7=G7[iG7+jH7].V7;
            int iH8=( 1 +273 +igor_data.H7H7i(iH7,jH7)*144
                     +iV7*12 +jV7);
            IGO_GLOADB_1(igor_data,iG7,iH8);
         }
      }
//
//
// add element impulses associated with 1-body patterns in sequence
//
      for(int iH7=-5;iH7<= 0;iH7++){
         if( (iG7+iH7)< 0 )continue;
         int iT7=G7[iG7+iH7].T7;
         int iH8=( 1 +igor_data.H7i(iH7)*21
                  +iT7);
         IGO_GLOADB_1(igor_data,iG7,iH8);
      }
//
//
// add element impulses associated with 0-body pattern
//
      int iH8=( 0);
      IGO_GLOADB_1(igor_data,iG7,iH8);
   }
   return;
}
