#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <cstdlib>
#include <iomanip>
#include <cmath>

void Igor_Model::IGO_GFILT(const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_IGOR_DATA& igor_data,
                           Output_Streams& out){
   int oC7=igor_data.oC7;
//
//
// set element filters
//
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0=iR0;jR0<oR0;jR0++){
         short i=R0R0v(iR0,jR0);
         short j=(i>>5)&7;
         short k=(i>>8)&7;
         int n=(jR0-iR0+ 1);
         R0R0v(iR0,jR0)=0;
//
//
// add element type to filter
//
         double m0( 0.00),m1( 0.00),m2c( 0.00),m2s( 0.00);
         double z= (0.00);
         for(int pR0=iR0;pR0<=jR0;pR0++){
            double hphob= double( igor_data.L1[ R0[pR0].L1].hphob);
            m0+=hphob;
            double the1= z*physics_consts.PI;
            m1+=(hphob*std::cos( the1));
            double the2= z*(2.00)*physics_consts.PI/(3.60);
            m2c+=(hphob*std::cos( the2));
            m2s+=(hphob*std::sin( the2));
            z++;
         }
         m0/=z;
         m1/=z;
         m2c/=z;
         m2s/=z;
         m1= std::abs( m1);
         double m2= std::sqrt( m2c*m2c +m2s*m2s);
         int iT7=-1;
         if      ( (n>=10)         &&(m2>( .45)) ){
            iT7=16;
         }else if( (n>= 7)&&(n<= 9)&&(m2>( .75)) ){
            iT7=15;
         }else if( (n>= 5)&&(n<= 6)&&(m2>(1.05)) ){
            iT7=14;
         }else if( (n>=11)         &&(m1>( .80)) ){
            iT7=13;
         }else if( (n>= 5)&&(n<=10)&&(m1>( .70)) ){
            iT7=12;
         }else if( (n>= 3)&&(n<= 4)&&(m1>( .60)) ){
            iT7=11;
         }else if( (n>=11)         &&(m0<(-.25)) ){
            iT7=10;
         }else if( (n>= 5)&&(n<=10)&&(m0<(-.35)) ){
            iT7= 9;
         }else if( (n>= 3)&&(n<= 4)&&(m0<(-.45)) ){
            iT7= 8;
         }else if( (n>=11)         &&(m0>( .55)) ){
            iT7= 7;
         }else if( (n>= 5)&&(n<=10)&&(m0>( .65)) ){
            iT7= 6;
         }else if( (n>= 3)&&(n<= 4)&&(m0>( .75)) ){
            iT7= 5;
         }else if( (n>=11)                       ){
            iT7= 4;
         }else if( (n>= 5)&&(n<=10)              ){
            iT7= 3;
         }else if( (n>= 2)&&(n<= 4)              ){
            iT7= 2;
         }else if( (n>= 1)&&(n<= 1)              ){
            iT7= 1;
         }
         R0R0v(iR0,jR0)+=iT7;
//
//
// elem length inconsistent with residue ising model
//
         for(int iC7= 1;iC7<oC7;iC7++){
            C7e(iC7)= (0.00);
         }
         for(int pR0=iR0;pR0<=jR0;pR0++){
            for(int iC7= 1;iC7<oC7;iC7++){
               C7e(iC7)+=std::log( R0[pR0].C7p0(iC7) +(1.e-32));
            }
         }
         for(int iC7= 1;iC7<oC7;iC7++){
            C7e(iC7)/=double(n);
            C7p(iC7)= std::exp( C7e(iC7));
            if( C7p(iC7)<(.0001) )C7p(iC7)= (.0001);
            if( C7p(iC7)>(.9999) )C7p(iC7)= (.9999);
         }
         double pmax= C7p( 1);
         int jC7=1;
         for(int iC7= 2;iC7<oC7;iC7++){
            if( C7p(iC7)>pmax ){
               pmax= C7p(iC7);
               jC7=iC7;
            }
         }
         i=0;
         int jR7=( n>32 )? 32: n;
         int jB8=int( (10.00)*pmax);
         if( igor_data.R7B8v(jR7,jB8)==1 )i+=2;
         int pB8=( iFOLD==0 )? 7: 8;
         if( (jB8> 7)&&(jR7<25) ){
            if( iR0> 0 ){
               double p= R0[iR0-1].C7p0(jC7);
               if( p>(.9999) )p= (.9999);
               int iB8=int( (10.00)*p);
               if( iB8>pB8 )i+=1;
            }
            if( jR0<(oR0-1) ){
               double p= R0[jR0+1].C7p0(jC7);
               if( p>(.9999) )p= (.9999);
               int iB8=int( (10.00)*p);
               if( iB8>pB8 )i+=4;
            }
         }
         i&=j;
         R0R0v(iR0,jR0)+=(i<<5);
//
//
// elem (type,length) inconsistent with residue ising model
//
         i=0;
         int iU7=igor_data.T7R7U7(iT7,jR7);
         for(int iC7= 1;iC7<oC7;iC7++){
            jB8=int( (10.00)*C7p(iC7));
            if( ((iR0== 0)||(jR0==(oR0-1)))&&(jR7<12) ){
            }else{
               if( igor_data.U7C7B8v1(iU7,iC7,jB8)==1 )i|=2;
               if( iR0> 0 ){
                  double p= R0[iR0-1].C7p0(iC7);
                  if( p>(.9999) )p= (.9999);
                  int iB8=int( (10.00)*p);
                  if( igor_data.U7C7B8v0(iU7,iC7,iB8)==1 )i|=1;
               }
               if( jR0<(oR0-1) ){
                  double p= R0[jR0+1].C7p0(iC7);
                  if( p>(.9999) )p= (.9999);
                  int iB8=int( (10.00)*p);
                  if( igor_data.U7C7B8v2(iU7,iC7,iB8)==1 )i|=4;
               }
            }
         }
         i&=k;
         if( iFOLD==0 ){
            R0R0v(iR0,jR0)+=(i<<8);
         }
      }
   }
//
//
// patch elem filters
//
   for(int iR0=25;iR0<oR0;iR0++){
      for(int jR0=iR0;jR0<(oR0-26);jR0++){
         int n=(jR0-iR0+ 1);
         if( n> 7 )continue;
         if( ((R0R0v(iR0-25,iR0- 1)&2016)==0)&&
             ((R0R0v(jR0+ 1,jR0+25)&2016)==0)){
            short i=R0R0v(iR0,jR0);
            int iT7=(i&(  31));
            R0R0v(iR0,jR0)=iT7;
         }
      }
   }
//
//
// count elem filters
//
   int aN( 0),bN( 0),cN( 0),dN( 0),eN( 0);
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0=iR0;jR0<oR0;jR0++){
         short i=R0R0v(iR0,jR0);
         short j=(i>>5)&7;
         short k=(i>>8)&7;
         if( (i&2016)==0 )aN++; //passed
         if( (j&2)> 0 )bN++;    //low prob of any state
         if( (j&5)> 0 )cN++;    //high prob for extension of elem
         if( (k&2)> 0 )dN++;    //(type,size,state,prob) filter
         if( (k&5)> 0 )eN++;    //(type,size,boundary res state,prob) filter
      }
   }
//
//
// diagnostic output
//
   if( out.VERBOSE ){
      out.FILE3<<"________\n";
      out.FILE3<<"EXCLUDE TARGET ELEMENTS INCOMPATIBLE WITH RESIDUE ISING "
                 "MODEL\n";
      out.FILE3<< std::setw( 7)<<aN
               <<" passed\n";
      out.FILE3<< std::setw( 7)<<bN
               <<" low prob of any state\n";
      out.FILE3<< std::setw( 7)<<cN
               <<" high prob for extension of elem\n";
      out.FILE3<< std::setw( 7)<<dN
               <<" excluded by (type,size,state,prob) filter\n";
      out.FILE3<< std::setw( 7)<<eN
               <<" excluded by (type,size,boundary res state,prob) filter\n";
   }
   return;
}
