#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../igo/Target_Surf.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

void Target_Surf::IGO_ENQ(const DAT_PHYSICS_CONSTS& physics_consts,
                          Output_Streams& out,
                          std::vector<Igor_Model::tG7>& G7,
                          std::vector<Igor_Model::tZ9>& Z9,
                          int COMPONENT){
//
//
// initiate energy surface
//
   TOT= (0.00);
   for(int iU2= 0;iU2<oU2;iU2++){
      U2g(iU2)= (0.00);
   }
   for(int iU2= 0;iU2<oU2;iU2++){
      for(int jU2= 0;jU2<oU2;jU2++){
         U2U2a(iU2,jU2)= (0.00);
      }
   }
   Fa= (0.00);
   Fb= (0.00);
   Fc= (0.00);
   Fd= (0.00);
   Fe= (0.00);
   Ff= (0.00);
   Fg= (0.00);
//
//
// position and local axes, 1st and 2nd partial derivs
// iD={ 0: iX-->(iX- 1), 1: iX-->(iX+ 1)}
//
   for(int iX= 0;iX<oX;iX++){
      int iU2=XU2(iX);
      for(int iD=0;iD<2;iD++){
//
         double alp= U2chi(iU2+3);
         double bet= U2chi(iU2+4);
         double gam= U2chi(iU2+5);
         if( iD==1 ){
            gam+=Xdgam(iX);
         }
         double Calp= std::cos( alp);
         double Salp= std::sin( alp);
         double Cbet= std::cos( bet);
         double Sbet= std::sin( bet);
         double Cgam= std::cos( gam);
         double Sgam= std::sin( gam);
//
         XDx(iX,iD)(0)= Calp*Cbet*Cgam -Salp*Sgam;
         XDx(iX,iD)(1)= Salp*Cbet*Cgam +Calp*Sgam;
         XDx(iX,iD)(2)=-Sbet*Cgam;
//
         XDdx(iX,iD, 0)(0)=-Salp*Cbet*Cgam -Calp*Sgam;
         XDdx(iX,iD, 0)(1)= Calp*Cbet*Cgam -Salp*Sgam;
         XDdx(iX,iD, 0)(2)= (0.00);
         XDdx(iX,iD, 1)(0)=-Calp*Sbet*Cgam;
         XDdx(iX,iD, 1)(1)=-Salp*Sbet*Cgam;
         XDdx(iX,iD, 1)(2)=-Cbet*Cgam;
         XDdx(iX,iD, 2)(0)=-Calp*Cbet*Sgam -Salp*Cgam;
         XDdx(iX,iD, 2)(1)=-Salp*Cbet*Sgam +Calp*Cgam;
         XDdx(iX,iD, 2)(2)= Sbet*Sgam;
//
         XDddx(iX,iD, 0,0)(0)=-Calp*Cbet*Cgam +Salp*Sgam;
         XDddx(iX,iD, 0,0)(1)=-Salp*Cbet*Cgam -Calp*Sgam;
         XDddx(iX,iD, 0,0)(2)= (0.00);
         XDddx(iX,iD, 0,1)(0)= Salp*Sbet*Cgam;
         XDddx(iX,iD, 0,1)(1)=-Calp*Sbet*Cgam;
         XDddx(iX,iD, 0,1)(2)= (0.00);
         XDddx(iX,iD, 0,2)(0)= Salp*Cbet*Sgam -Calp*Cgam;
         XDddx(iX,iD, 0,2)(1)=-Calp*Cbet*Sgam -Salp*Cgam;
         XDddx(iX,iD, 0,2)(2)= (0.00);
         XDddx(iX,iD, 1,0)(0)= Salp*Sbet*Cgam;
         XDddx(iX,iD, 1,0)(1)=-Calp*Sbet*Cgam;
         XDddx(iX,iD, 1,0)(2)= (0.00);
         XDddx(iX,iD, 1,1)(0)=-Calp*Cbet*Cgam;
         XDddx(iX,iD, 1,1)(1)=-Salp*Cbet*Cgam;
         XDddx(iX,iD, 1,1)(2)= Sbet*Cgam;
         XDddx(iX,iD, 1,2)(0)= Calp*Sbet*Sgam;
         XDddx(iX,iD, 1,2)(1)= Salp*Sbet*Sgam;
         XDddx(iX,iD, 1,2)(2)= Cbet*Sgam;
         XDddx(iX,iD, 2,0)(0)= Salp*Cbet*Sgam -Calp*Cgam;
         XDddx(iX,iD, 2,0)(1)=-Calp*Cbet*Sgam -Salp*Cgam;
         XDddx(iX,iD, 2,0)(2)= (0.00);
         XDddx(iX,iD, 2,1)(0)= Calp*Sbet*Sgam;
         XDddx(iX,iD, 2,1)(1)= Salp*Sbet*Sgam;
         XDddx(iX,iD, 2,1)(2)= Cbet*Sgam;
         XDddx(iX,iD, 2,2)(0)=-Calp*Cbet*Cgam +Salp*Sgam;
         XDddx(iX,iD, 2,2)(1)=-Salp*Cbet*Cgam -Calp*Sgam;
         XDddx(iX,iD, 2,2)(2)= Sbet*Cgam;
//
         XDy(iX,iD)(0)=-Calp*Cbet*Sgam -Salp*Cgam;
         XDy(iX,iD)(1)=-Salp*Cbet*Sgam +Calp*Cgam;
         XDy(iX,iD)(2)= Sbet*Sgam;
//
         XDdy(iX,iD, 0)(0)= Salp*Cbet*Sgam -Calp*Cgam;
         XDdy(iX,iD, 0)(1)=-Calp*Cbet*Sgam -Salp*Cgam;
         XDdy(iX,iD, 0)(2)= (0.00);
         XDdy(iX,iD, 1)(0)= Calp*Sbet*Sgam;
         XDdy(iX,iD, 1)(1)= Salp*Sbet*Sgam;
         XDdy(iX,iD, 1)(2)= Cbet*Sgam;
         XDdy(iX,iD, 2)(0)=-Calp*Cbet*Cgam +Salp*Sgam;
         XDdy(iX,iD, 2)(1)=-Salp*Cbet*Cgam -Calp*Sgam;
         XDdy(iX,iD, 2)(2)= Sbet*Cgam;
//
         XDddy(iX,iD, 0,0)(0)= Calp*Cbet*Sgam +Salp*Cgam;
         XDddy(iX,iD, 0,0)(1)= Salp*Cbet*Sgam -Calp*Cgam;
         XDddy(iX,iD, 0,0)(2)= (0.00);
         XDddy(iX,iD, 0,1)(0)=-Salp*Sbet*Sgam;
         XDddy(iX,iD, 0,1)(1)= Calp*Sbet*Sgam;
         XDddy(iX,iD, 0,1)(2)= (0.00);
         XDddy(iX,iD, 0,2)(0)= Salp*Cbet*Cgam +Calp*Sgam;
         XDddy(iX,iD, 0,2)(1)=-Calp*Cbet*Cgam +Salp*Sgam;
         XDddy(iX,iD, 0,2)(2)= (0.00);
         XDddy(iX,iD, 1,0)(0)=-Salp*Sbet*Sgam;
         XDddy(iX,iD, 1,0)(1)= Calp*Sbet*Sgam;
         XDddy(iX,iD, 1,0)(2)= (0.00);
         XDddy(iX,iD, 1,1)(0)= Calp*Cbet*Sgam;
         XDddy(iX,iD, 1,1)(1)= Salp*Cbet*Sgam;
         XDddy(iX,iD, 1,1)(2)=-Sbet*Sgam;
         XDddy(iX,iD, 1,2)(0)= Calp*Sbet*Cgam;
         XDddy(iX,iD, 1,2)(1)= Salp*Sbet*Cgam;
         XDddy(iX,iD, 1,2)(2)= Cbet*Cgam;
         XDddy(iX,iD, 2,0)(0)= Salp*Cbet*Cgam +Calp*Sgam;
         XDddy(iX,iD, 2,0)(1)=-Calp*Cbet*Cgam +Salp*Sgam;
         XDddy(iX,iD, 2,0)(2)= (0.00);
         XDddy(iX,iD, 2,1)(0)= Calp*Sbet*Cgam;
         XDddy(iX,iD, 2,1)(1)= Salp*Sbet*Cgam;
         XDddy(iX,iD, 2,1)(2)= Cbet*Cgam;
         XDddy(iX,iD, 2,2)(0)= Calp*Cbet*Sgam +Salp*Cgam;
         XDddy(iX,iD, 2,2)(1)= Salp*Cbet*Sgam -Calp*Cgam;
         XDddy(iX,iD, 2,2)(2)=-Sbet*Sgam;
//
         XDz(iX,iD)(0)= Calp*Sbet;
         XDz(iX,iD)(1)= Salp*Sbet;
         XDz(iX,iD)(2)= Cbet;
//
         XDdz(iX,iD, 0)(0)=-Salp*Sbet;
         XDdz(iX,iD, 0)(1)= Calp*Sbet;
         XDdz(iX,iD, 0)(2)= (0.00);
         XDdz(iX,iD, 1)(0)= Calp*Cbet;
         XDdz(iX,iD, 1)(1)= Salp*Cbet;
         XDdz(iX,iD, 1)(2)=-Sbet;
         XDdz(iX,iD, 2)(0)= (0.00);
         XDdz(iX,iD, 2)(1)= (0.00);
         XDdz(iX,iD, 2)(2)= (0.00);
//
         XDddz(iX,iD, 0,0)(0)=-Calp*Sbet;
         XDddz(iX,iD, 0,0)(1)=-Salp*Sbet;
         XDddz(iX,iD, 0,0)(2)= (0.00);
         XDddz(iX,iD, 0,1)(0)=-Salp*Cbet;
         XDddz(iX,iD, 0,1)(1)= Calp*Cbet;
         XDddz(iX,iD, 0,1)(2)= (0.00);
         XDddz(iX,iD, 0,2)(0)= (0.00);
         XDddz(iX,iD, 0,2)(1)= (0.00);
         XDddz(iX,iD, 0,2)(2)= (0.00);
         XDddz(iX,iD, 1,0)(0)=-Salp*Cbet;
         XDddz(iX,iD, 1,0)(1)= Calp*Cbet;
         XDddz(iX,iD, 1,0)(2)= (0.00);
         XDddz(iX,iD, 1,1)(0)=-Calp*Sbet;
         XDddz(iX,iD, 1,1)(1)=-Salp*Sbet;
         XDddz(iX,iD, 1,1)(2)=-Cbet;
         XDddz(iX,iD, 1,2)(0)= (0.00);
         XDddz(iX,iD, 1,2)(1)= (0.00);
         XDddz(iX,iD, 1,2)(2)= (0.00);
         XDddz(iX,iD, 2,0)(0)= (0.00);
         XDddz(iX,iD, 2,0)(1)= (0.00);
         XDddz(iX,iD, 2,0)(2)= (0.00);
         XDddz(iX,iD, 2,1)(0)= (0.00);
         XDddz(iX,iD, 2,1)(1)= (0.00);
         XDddz(iX,iD, 2,1)(2)= (0.00);
         XDddz(iX,iD, 2,2)(0)= (0.00);
         XDddz(iX,iD, 2,2)(1)= (0.00);
         XDddz(iX,iD, 2,2)(2)= (0.00);
//
         XDt(iX,iD)(0)= U2chi(iU2  );
         XDt(iX,iD)(1)= U2chi(iU2+1);
         XDt(iX,iD)(2)= U2chi(iU2+2);
         if( iD==1 ){
            XDt(iX,iD)+=( Xdy(iX)*XDy(iX,iD)
                         +Xdz(iX)*XDz(iX,iD));
            for(int i=0;i<3;i++){
               XDdt(iX,iD, i)=( Xdy(iX)*XDdy(iX,iD, i)
                               +Xdz(iX)*XDdz(iX,iD, i));
               for(int j=0;j<3;j++){
                  XDddt(iX,iD, i,j)=( Xdy(iX)*XDddy(iX,iD, i,j)
                                     +Xdz(iX)*XDddz(iX,iD, i,j));
               }
            }
         }
//
      }
   }
//
//
// measure of deformation from lattice pack
//
   for(int iX= 0;iX<(oX- 1);iX++){
      int iD=1;
      int iU2=XU2(iX);
      int jX=(iX+ 1);
      int jD=0;
      int jU2=XU2(jX);
//
//
// Fa, constrain [xi*xj=-1]
//
      if( (COMPONENT==0)||(COMPONENT==1) ){
         double w= ( 5.00e+1);
         Fa+=w*( ( 1.00) +dot(XDx(iX,iD),XDx(jX,jD)));
         for(int i=0;i<3;i++){
            U2g(iU2+3+i)+=w*dot(XDdx(iX,iD, i),XDx(jX,jD));
            U2g(jU2+3+i)+=w*dot(XDx(iX,iD),XDdx(jX,jD, i));
            for(int j=i;j<3;j++){
               U2U2a(iU2+3+i,iU2+3+j)+=w*dot(XDddx(iX,iD, i,j),XDx(jX,jD));
               U2U2a(jU2+3+i,jU2+3+j)+=w*dot(XDx(iX,iD),XDddx(jX,jD, i,j));
            }
            for(int j=0;j<3;j++){
               U2U2a(iU2+3+i,jU2+3+j)+=w*dot(XDdx(iX,iD, i),XDdx(jX,jD, j));
            }
         }
      }
//
//
// distance, 1st and 2nd partial derivs
//
      Coordinates d=( XDt(iX,iD) -XDt(jX,jD));
      double r= d.r();
      if( r<( 1.00e-4) )r=( 1.00e-4);
      double z= (1.00)/r;
      double zz= z*z;
      double zzz= zz*z;
      Coordinates n=z*d;
//
      dr( 0)= n(0);
      dr( 1)= n(1);
      dr( 2)= n(2);
//
      ddr( 0,0)= z*( (1.00) -n(0)*n(0));
      ddr( 1,0)= z*(        -n(1)*n(0));
      ddr( 2,0)= z*(        -n(2)*n(0));
      ddr( 0,1)= z*(        -n(0)*n(1));
      ddr( 1,1)= z*( (1.00) -n(1)*n(1));
      ddr( 2,1)= z*(        -n(2)*n(1));
      ddr( 0,2)= z*(        -n(0)*n(2));
      ddr( 1,2)= z*(        -n(1)*n(2));
      ddr( 2,2)= z*( (1.00) -n(2)*n(2));
//
      for(int i=0;i<3;i++){
         dr( 3+i)= z*dot(d,XDdt(iX,iD, i));
         for(int j=0;j<3;j++){
            ddr( j,3+i)=( z*XDdt(iX,iD, i)(j)
                         -zz*dr( 3+i)*d(j));
            ddr(3+i, j)= ddr( j,3+i),
            ddr( 3+i,3+j)=( z*dot(d,XDddt(iX,iD, i,j))
                           +z*dot(XDdt(iX,iD, j),XDdt(iX,iD, i))
                           -zz*dr( 3+i)*dot(d,XDdt(iX,iD, j)));
         }
      }
//
//
// normal along displacement, 1st and 2nd partial derivs
//
      dn( 0)(0)= z*( (1.00) -n(0)*n(0));
      dn( 0)(1)= z*(        -n(0)*n(1));
      dn( 0)(2)= z*(        -n(0)*n(2));
      dn( 1)(0)= z*(        -n(1)*n(0));
      dn( 1)(1)= z*( (1.00) -n(1)*n(1));
      dn( 1)(2)= z*(        -n(1)*n(2));
      dn( 2)(0)= z*(        -n(2)*n(0));
      dn( 2)(1)= z*(        -n(2)*n(1));
      dn( 2)(2)= z*( (1.00) -n(2)*n(2));
//
      ddn( 0,0)(0)= zz*( -n(0) -n(0) -n(0) +(3.)*n(0)*n(0)*n(0));
      ddn( 0,0)(1)= zz*(             -n(1) +(3.)*n(0)*n(0)*n(1));
      ddn( 0,0)(2)= zz*(             -n(2) +(3.)*n(0)*n(0)*n(2));
      ddn( 1,0)(0)= zz*(       -n(1)       +(3.)*n(1)*n(0)*n(0));
      ddn( 1,0)(1)= zz*( -n(0)             +(3.)*n(1)*n(0)*n(1));
      ddn( 1,0)(2)= zz*(                    (3.)*n(1)*n(0)*n(2));
      ddn( 2,0)(0)= zz*(       -n(2)       +(3.)*n(2)*n(0)*n(0));
      ddn( 2,0)(1)= zz*(                    (3.)*n(2)*n(0)*n(1));
      ddn( 2,0)(2)= zz*( -n(0)             +(3.)*n(2)*n(0)*n(2));
      ddn( 0,1)(0)= zz*( -n(1)             +(3.)*n(0)*n(1)*n(0));
      ddn( 0,1)(1)= zz*(       -n(0)       +(3.)*n(0)*n(1)*n(1));
      ddn( 0,1)(2)= zz*(                    (3.)*n(0)*n(1)*n(2));
      ddn( 1,1)(0)= zz*(             -n(0) +(3.)*n(1)*n(1)*n(0));
      ddn( 1,1)(1)= zz*( -n(1) -n(1) -n(1) +(3.)*n(1)*n(1)*n(1));
      ddn( 1,1)(2)= zz*(             -n(2) +(3.)*n(1)*n(1)*n(2));
      ddn( 2,1)(0)= zz*(                    (3.)*n(2)*n(1)*n(0));
      ddn( 2,1)(1)= zz*(       -n(2)       +(3.)*n(2)*n(1)*n(1));
      ddn( 2,1)(2)= zz*( -n(1)             +(3.)*n(2)*n(1)*n(2));
      ddn( 0,2)(0)= zz*( -n(2)             +(3.)*n(0)*n(2)*n(0));
      ddn( 0,2)(1)= zz*(                    (3.)*n(0)*n(2)*n(1));
      ddn( 0,2)(2)= zz*(       -n(0)       +(3.)*n(0)*n(2)*n(2));
      ddn( 1,2)(0)= zz*(                    (3.)*n(1)*n(2)*n(0));
      ddn( 1,2)(1)= zz*( -n(2)             +(3.)*n(1)*n(2)*n(1));
      ddn( 1,2)(2)= zz*(       -n(1)       +(3.)*n(1)*n(2)*n(2));
      ddn( 2,2)(0)= zz*(             -n(0) +(3.)*n(2)*n(2)*n(0));
      ddn( 2,2)(1)= zz*(             -n(1) +(3.)*n(2)*n(2)*n(1));
      ddn( 2,2)(2)= zz*( -n(2) -n(2) -n(2) +(3.)*n(2)*n(2)*n(2));
//
      for(int i=0;i<3;i++){
         dn( 3+i)=( z*XDdt(iX,iD, i)
                   -zz*dr( 3+i)*d);
         for(int j=0;j<3;j++){
            ddn( j,3+i)=(-zz*dr( j)*XDdt(iX,iD, i)
                         -zz*ddr( j,3+i)*d
                         +(2.)*zzz*dr( 3+i)*dr( j)*d);
            ddn( j,3+i)(j)-=zz*dr( 3+i);
            ddn(3+i, j)=ddn( j,3+i);
            ddn( 3+i,3+j)=( z*XDddt(iX,iD, i,j)
                           -zz*dr( 3+j)*XDdt(iX,iD, i)
                           -zz*dr( 3+i)*XDdt(iX,iD, j)
                           -zz*ddr( 3+i,3+j)*d
                           +(2.)*zzz*dr( 3+i)*dr( 3+j)*d);
         }
      }
//
//
// Fb, constrain [xi*(ti-tj)=-1][xj*(tj-ti)=-1]
//
      if( (COMPONENT==0)||(COMPONENT==2) ){
         double w= ( 5.00e+1);
         Fb+=w*( ( 1.00) +dot(XDx(iX,iD), n));
         for(int i=0;i<3;i++){
            U2g(iU2+3+i)+=w*( dot(XDdx(iX,iD, i), n)
                             +dot(XDx(iX,iD), dn( 3+i)));
            U2g(iU2  +i)+=w*dot(XDx(iX,iD), dn( i));
            U2g(jU2  +i)+=w*dot(XDx(iX,iD),-dn( i));
            for(int j=i;j<3;j++){
               U2U2a(iU2+3+i,iU2+3+j)+=w*( dot(XDddx(iX,iD, i,j), n)
                                          +dot(XDdx(iX,iD, i), dn( 3+j))
                                          +dot(XDdx(iX,iD, j), dn( 3+i))
                                          +dot(XDx(iX,iD), ddn( 3+i,3+j)));
               U2U2a(iU2  +i,iU2  +j)+=w*dot(XDx(iX,iD), ddn( i,j));
               U2U2a(jU2  +i,jU2  +j)+=w*dot(XDx(iX,iD), ddn( i,j));
            }
            for(int j=0;j<3;j++){
               U2U2a(iU2  +j,iU2+3+i)+=w*( dot(XDdx(iX,iD, i), dn( j))
                                          +dot(XDx(iX,iD), ddn( j,3+i)));
               U2U2a(iU2+3+i,jU2  +j)+=w*( dot(XDdx(iX,iD, i),-dn( j))
                                          +dot(XDx(iX,iD),-ddn( j,3+i)));
               U2U2a(iU2  +i,jU2  +j)+=w*dot(XDx(iX,iD),-ddn( i,j));
            }
         }
         Fb+=w*( ( 1.00) +dot(XDx(jX,jD),-n));
         for(int i=0;i<3;i++){
            U2g(jU2+3+i)+=w*dot(XDdx(jX,jD, i),-n);
            U2g(iU2+3+i)+=w*dot(XDx(jX,jD),-dn( 3+i));
            U2g(jU2  +i)+=w*dot(XDx(jX,jD), dn( i));
            U2g(iU2  +i)+=w*dot(XDx(jX,jD),-dn( i));
            for(int j=i;j<3;j++){
               U2U2a(iU2+3+i,iU2+3+j)+=w*dot(XDx(jX,jD),-ddn( 3+i,3+j));
               U2U2a(jU2+3+i,jU2+3+j)+=w*dot(XDddx(jX,jD, i,j),-n);
               U2U2a(iU2  +i,iU2  +j)+=w*dot(XDx(jX,jD),-ddn( i,j));
               U2U2a(jU2  +i,jU2  +j)+=w*dot(XDx(jX,jD),-ddn( i,j));
            }
            for(int j=0;j<3;j++){
               U2U2a(iU2+3+i,jU2+3+j)+=w*dot(XDdx(jX,jD, j),-dn( 3+i));
               U2U2a(iU2  +j,iU2+3+i)+=w*dot(XDx(jX,jD),-ddn( j,3+i));
               U2U2a(iU2+3+i,jU2  +j)+=w*dot(XDx(jX,jD), ddn( j,3+i));
               U2U2a(jU2  +j,jU2+3+i)+=w*dot(XDdx(jX,jD, i), dn( j));
               U2U2a(iU2  +j,jU2+3+i)+=w*dot(XDdx(jX,jD, i),-dn( j));
               U2U2a(iU2  +i,jU2  +j)+=w*dot(XDx(jX,jD), ddn( i,j));
            }
         }
      }
//
//
// Fc, constrain [(ti-tj).r()=(initial value)]
//
      if( (COMPONENT==0)||(COMPONENT==3) ){
         double w= ( 2.50e+0);
         double delr=( r -Xr(iX));
         Fc+=w*(delr*delr);
         for(int i=0;i<3;i++){
            U2g(iU2+3+i)+=w*(2.)*delr*dr( 3+i);
            U2g(iU2  +i)+=w*(2.)*delr*dr( i);
            U2g(jU2  +i)-=w*(2.)*delr*dr( i);
            for(int j=i;j<3;j++){
               U2U2a(iU2+3+i,iU2+3+j)+=w*(2.)*( delr*ddr( 3+i,3+j)
                                               +dr( 3+i)*dr( 3+j));
               U2U2a(iU2  +i,iU2  +j)+=w*(2.)*( delr*ddr( i,j) +dr( i)*dr( j));
               U2U2a(jU2  +i,jU2  +j)+=w*(2.)*( delr*ddr( i,j) +dr( i)*dr( j));
            }
            for(int j=0;j<3;j++){
               U2U2a(iU2  +i,iU2+3+j)+=w*(2.)*( delr*ddr( i,3+j)
                                               +dr( i)*dr( 3+j));
               U2U2a(iU2+3+i,jU2  +j)-=w*(2.)*( delr*ddr( j,3+i)
                                               +dr( 3+i)*dr( j));
               U2U2a(iU2  +i,jU2  +j)-=w*(2.)*( delr*ddr( i,j) +dr( i)*dr( j));
            }
         }
      }
//
//
// Fd, constrain [(zi*zj)=(initial value)]
//
      if( (COMPONENT==0)||(COMPONENT==4) ){
         double w= ( 5.00e-3);
         double C= dot(XDz(jX,jD),XDz(iX,iD));
         double the= std::acos( C)/physics_consts.RAD;
         double dthe=( the -Xthe(iX));
         double& y=C;
         double& x=the;
         double S= std::sqrt( (1.00) -C*C);
         if( S<( 1.00e-7) )S=( 1.00e-7);
         double dxdy= (-1.)/(S*physics_consts.RAD);
         double ddxdydy= (dxdy*y)/(S*S);
         Fd+=w*(dthe*dthe);
         for(int i=0;i<3;i++){
            U2g(iU2+3+i)+=w*(2.)*dthe*dxdy*dot(XDdz(iX,iD, i),XDz(jX,jD));
            U2g(jU2+3+i)+=w*(2.)*dthe*dxdy*dot(XDz(iX,iD),XDdz(jX,jD, i));
            for(int j=i;j<3;j++){
               U2U2a(iU2+3+i,iU2+3+j)+=w*(2.)*(
                   dthe*dxdy*dot(XDddz(iX,iD, i,j),XDz(jX,jD))
                  +dot(XDdz(iX,iD, i),XDz(jX,jD))
                  *dot(XDdz(iX,iD, j),XDz(jX,jD))
                      *( dxdy*dxdy +dthe*ddxdydy)
                                                );
               U2U2a(jU2+3+i,jU2+3+j)+=w*(2.)*(
                   dthe*dxdy*dot(XDz(iX,iD),XDddz(jX,jD, i,j))
                  +dot(XDz(iX,iD),XDdz(jX,jD, i))
                  *dot(XDz(iX,iD),XDdz(jX,jD, j))
                      *( dxdy*dxdy +dthe*ddxdydy)
                                                );
            }
            for(int j=0;j<3;j++){
               U2U2a(iU2+3+i,jU2+3+j)+=w*(2.)*(
                   dthe*dxdy*dot(XDdz(iX,iD, i),XDdz(jX,jD, j))
                  +dot(XDdz(iX,iD, i),XDz(jX,jD))
                  *dot(XDz(iX,iD),XDdz(jX,jD, j))
                      *( dxdy*dxdy +dthe*ddxdydy)
                                                );
            }
         }
      }
//
   }
//
//
// measure of z-axis overlap for noncrosslinked bod pairs
//
   if( (COMPONENT==0)||(COMPONENT==5) ){
      for(int iX= 0;iX<(oX- 2);iX++){
         int iU2=XU2(iX);
         int iD=0;
         for(int jX=(iX+ 2);jX<oX;jX++){
            int jU2=XU2(jX);
            int jD=0;
//
//
// components of target func
//
            double d= ( 8.75);
            double w= (-0.80e+0);
            double C= dot(XDz(iX,iD),XDz(jX,jD));
            double S= std::sqrt( (1.00) -C*C);
            if( S<( 1.00e-7) )S=( 1.00e-7);
            double zS= (1.00)/S;
            double zSS= zS*zS;
            double zSSS= zS*zSS;
            double zB= (1.00)/( S +( 1.00e-3));
            double zBB= zB*zB;
            double zBBB= zB*zBB;
            Coordinates t=( XDt(iX,iD) -XDt(jX,jD));
            Coordinates z= zB*cross(XDz(iX,iD),XDz(jX,jD));
//
//
// 1st and 2nd partial derivs of t wrt trans
//
            for(int i=0;i<3;i++){
               dt(   i).zero();
               dt(   i)(i)= ( 1.00);
               dt( 3+i).zero();
               dt( 3+i)(i)= (-1.00);
            }
//
//
// 1st and 2nd partial derivs of z wrt rot
//
            for(int i=0;i<3;i++){
               dz(   i)=( zB*cross(XDdz(iX,iD, i),XDz(jX,jD))
                         +zBB*C*zS*dot(XDdz(iX,iD, i),XDz(jX,jD))
                         *cross(XDz(iX,iD),XDz(jX,jD)));
               dz( 3+i)=( zB*cross(XDz(iX,iD),XDdz(jX,jD, i))
                         +zBB*C*zS*dot(XDz(iX,iD),XDdz(jX,jD, i))
                         *cross(XDz(iX,iD),XDz(jX,jD)));
               for(int j=0;j<3;j++){
                  ddz(   i,  j)=( zB*cross(XDddz(iX,iD, i,j),XDz(jX,jD))
                                 +zBB*C*zS*dot(XDdz(iX,iD, j),XDz(jX,jD))
                                 *cross(XDdz(iX,iD, i),XDz(jX,jD))
                                 +zBB*C*zS*dot(XDdz(iX,iD, i),XDz(jX,jD))
                                 *cross(XDdz(iX,iD, j),XDz(jX,jD))
                                 +zBB*C*zS*dot(XDddz(iX,iD, i,j),XDz(jX,jD))
                                 *cross(XDz(iX,iD),XDz(jX,jD))
                                 +zBB*( zS +C*C*zSSS)
                                     *dot(XDdz(iX,iD, j),XDz(jX,jD))
                                     *dot(XDdz(iX,iD, i),XDz(jX,jD))
                                 *cross(XDz(iX,iD),XDz(jX,jD))
                                 +(2.)*zBBB*C*zS*dot(XDdz(iX,iD, j),XDz(jX,jD))
                                           *C*zS*dot(XDdz(iX,iD, i),XDz(jX,jD))
                                 *cross(XDz(iX,iD),XDz(jX,jD)));
                  ddz(   i,3+j)=( zB*cross(XDdz(iX,iD, i),XDdz(jX,jD, j))
                                 +zBB*C*zS*dot(XDz(iX,iD),XDdz(jX,jD, j))
                                 *cross(XDdz(iX,iD, i),XDz(jX,jD))
                                 +zBB*C*zS*dot(XDdz(iX,iD, i),XDz(jX,jD))
                                 *cross(XDz(iX,iD),XDdz(jX,jD, j))
                                 +zBB*C*zS*dot(XDdz(iX,iD, i),XDdz(jX,jD, j))
                                 *cross(XDz(iX,iD),XDz(jX,jD))
                                 +zBB*( zS +C*C*zSSS)
                                     *dot(XDz(iX,iD),XDdz(jX,jD, j))
                                     *dot(XDdz(iX,iD, i),XDz(jX,jD))
                                 *cross(XDz(iX,iD),XDz(jX,jD))
                                 +(2.)*zBBB*C*zS*dot(XDz(iX,iD),XDdz(jX,jD, j))
                                           *C*zS*dot(XDdz(iX,iD, i),XDz(jX,jD))
                                 *cross(XDz(iX,iD),XDz(jX,jD)));
                  ddz( 3+j,  i)= ddz(   i,3+j);
                  ddz( 3+i,3+j)=( zB*cross(XDz(iX,iD),XDddz(jX,jD, i,j))
                                 +zBB*C*zS*dot(XDz(iX,iD),XDdz(jX,jD, j))
                                 *cross(XDz(iX,iD),XDdz(jX,jD, i))
                                 +zBB*C*zS*dot(XDz(iX,iD),XDdz(jX,jD, i))
                                 *cross(XDz(iX,iD),XDdz(jX,jD, j))
                                 +zBB*C*zS*dot(XDz(iX,iD),XDddz(jX,jD, i,j))
                                 *cross(XDz(iX,iD),XDz(jX,jD))
                                 +zBB*( zS +C*C*zSSS)
                                     *dot(XDz(iX,iD),XDdz(jX,jD, j))
                                     *dot(XDz(iX,iD),XDdz(jX,jD, i))
                                 *cross(XDz(iX,iD),XDz(jX,jD))
                                 +(2.)*zBBB*C*zS*dot(XDz(iX,iD),XDdz(jX,jD, j))
                                           *C*zS*dot(XDz(iX,iD),XDdz(jX,jD, i))
                                 *cross(XDz(iX,iD),XDz(jX,jD)));
               }
            }
//
//
// Fe, enforce separation for bod pair axes
//
            double x= dot(t,z);
            double sgn=( x<( 0.00) )?(-1.00):( 1.00);
            double e= std::exp( w*( sgn*x -d));
            Fe+=e;
            for(int i=0;i<3;i++){
               U2g(iU2+i)+=e*w*sgn*dot(dt(   i),z);
               U2g(jU2+i)+=e*w*sgn*dot(dt( 3+i),z);
               U2g(iU2+3+i)+=e*w*sgn*dot(t,dz(   i));
               U2g(jU2+3+i)+=e*w*sgn*dot(t,dz( 3+i));
               for(int j=i;j<3;j++){
                  U2U2a(iU2+i,iU2+j)+=e*w*dot(dt(   j),z)*w*dot(dt(   i),z);
                  U2U2a(jU2+i,jU2+j)+=e*w*dot(dt( 3+j),z)*w*dot(dt( 3+i),z);
                  U2U2a(iU2+3+i,iU2+3+j)+=(
                      e*w*sgn*dot(t,ddz(   i,  j))
                     +e*w*dot(t,dz(   j))*w*dot(t,dz(   i))
                                            );
                  U2U2a(jU2+3+i,jU2+3+j)+=(
                      e*w*sgn*dot(t,ddz( 3+i,3+j))
                     +e*w*dot(t,dz( 3+j))*w*dot(t,dz( 3+i))
                                            );
               }
               for(int j=0;j<3;j++){
                  U2U2a(iU2+i,jU2+j)+=e*w*dot(dt( 3+j),z)*w*dot(dt(   i),z);
                  U2U2a(iU2+i,iU2+3+j)+=(
                      e*w*sgn*dot(dt(   i),dz(   j))
                     +e*w*dot(t,dz(   j))*w*dot(dt(   i),z)
                                          );
                  U2U2a(jU2+i,jU2+3+j)+=(
                      e*w*sgn*dot(dt( 3+i),dz( 3+j))
                     +e*w*dot(t,dz( 3+j))*w*dot(dt( 3+i),z)
                                          );
                  U2U2a(iU2+i,jU2+3+j)+=(
                      e*w*sgn*dot(dt(   i),dz( 3+j))
                     +e*w*dot(t,dz( 3+j))*w*dot(dt(   i),z)
                                          );
                  U2U2a(iU2+3+i,jU2+j)+=(
                      e*w*sgn*dot(dt(  3+j),dz(   i))
                     +e*w*dot(dt( 3+j),z)*w*dot(t,dz(   i))
                                          );
                  U2U2a(iU2+3+i,jU2+3+j)+=(
                      e*w*sgn*dot(t,ddz(   i,3+j))
                     +e*w*dot(t,dz( 3+j))*w*dot(t,dz(   i))
                                            );
               }
            }
         }
      }
   }
//
//
// chain connectivity constraint
//
   if( (COMPONENT==0)||(COMPONENT==6) ){
      int iX= 0;
      int iZ9=XZ9(iX);
      int iD=0;
      int iU2=XU2(iX);
      int oiK4=Z9[iZ9].oK4;
      int jX=(oX- 1);
      int jZ9=XZ9(jX);
      int jD=0;
      int jU2=XU2(jX);
      int ojK4=Z9[jZ9].oK4;
//
      for(int iK4= 0;iK4<oiK4;iK4++){
         int iG7=Z9[iZ9].K4[iK4].G7;
         for(int jK4= 0;jK4<ojK4;jK4++){
            int jG7=Z9[jZ9].K4[jK4].G7;
            double o;
            double xi,yi,zi,xj,yj,zj;
            if      ( jG7==(iG7+ 2) ){
               o= double( G7[jG7].mR0-G7[iG7].nR0)*(3.10) +(2.80);
               xi= XK4v(iX,iK4)(0);
               yi= XK4v(iX,iK4)(1);
               zi= XK4v(iX,iK4)(2);
               xj= XK4u(jX,jK4)(0);
               yj= XK4u(jX,jK4)(1);
               zj= XK4u(jX,jK4)(2);
            }else if( jG7==(iG7- 2) ){
               o= double( G7[iG7].mR0-G7[jG7].nR0)*(3.10) +(2.80);
               xi= XK4u(iX,iK4)(0);
               yi= XK4u(iX,iK4)(1);
               zi= XK4u(iX,iK4)(2);
               xj= XK4v(jX,jK4)(0);
               yj= XK4v(jX,jK4)(1);
               zj= XK4v(jX,jK4)(2);
            }else{
               continue;
            }
            Coordinates v=( XDt(jX,jD)
                           +xj*XDx(jX,jD) +yj*XDy(jX,jD) +zj*XDz(jX,jD));
            Coordinates u=( XDt(iX,iD)
                           +xi*XDx(iX,iD) +yi*XDy(iX,iD) +zi*XDz(iX,iD));
            Coordinates d=( u -v);
            double r= d.r();
            if( r<( 1.00e-7) )r=( 1.00e-7);
            Ff+=( ( 1.00) +(-4.00)*( o -r)/o);
            double z= (1.00)/r;
            double zz= z*z;
            double zzz= zz*z;
//
//
// 1st and 2nd partial derivs of d wrt trans+rot
//
            for(int i=0;i<3;i++){
               dt(   i).zero();
               dt(   i)(i)= ( 1.00);
               dt( 3+i).zero();
               dt( 3+i)(i)= (-1.00);
            }
            for(int i=0;i<3;i++){
               dz(   i)=( xi*XDdx(iX,iD, i)
                         +yi*XDdy(iX,iD, i)
                         +zi*XDdz(iX,iD, i));
               dz( 3+i)=(-xj*XDdx(jX,jD, i)
                         -yj*XDdy(jX,jD, i)
                         -zj*XDdz(jX,jD, i));
               for(int j=0;j<3;j++){
                  ddz(   i,  j)=( xi*XDddx(iX,iD, i,j)
                                 +yi*XDddy(iX,iD, i,j)
                                 +zi*XDddz(iX,iD, i,j));
                  ddz( 3+i,3+j)=(-xj*XDddx(jX,jD, i,j)
                                 -yj*XDddy(jX,jD, i,j)
                                 -zj*XDddz(jX,jD, i,j));
               }
            }
//
//
// Ff, chain connectivity
//
            for(int i=0;i<3;i++){
               U2g(iU2+i)+=(( 4.00)/o)*z*dot(d,dt(   i));
               U2g(iU2+3+i)+=(( 4.00)/o)*z*dot(d,dz(   i));
               U2g(jU2+i)+=(( 4.00)/o)*z*dot(d,dt( 3+i));
               U2g(jU2+3+i)+=(( 4.00)/o)*z*dot(d,dz( 3+i));
               for(int j=i;j<3;j++){
                  U2U2a(iU2+i,iU2+j)+=(( 4.00)/o)*(
                       z*dot(dt(   j),dt(   i))
                      -zzz*dot(d,dt(   i))*dot(d,dt(   j))
                                                    );
                  U2U2a(iU2+3+i,iU2+3+j)+=(( 4.00)/o)*(
                      z*dot(d,ddz(   i,  j))
                     +z*dot(dz(   j),dz(   i))
                     -zzz*dot(d,dz(   i))*dot(d,dz(   j))
                                                        );
                  U2U2a(jU2+i,jU2+j)+=(( 4.00)/o)*(
                      z*dot(dt( 3+j),dt( 3+i))
                     -zzz*dot(d,dt( 3+i))*dot(d,dt( 3+j))
                                                    );
                  U2U2a(jU2+3+i,jU2+3+j)+=(( 4.00)/o)*(
                      z*dot(d,ddz( 3+i,3+j))
                     +z*dot(dz( 3+j),dz( 3+i))
                     -zzz*dot(d,dz( 3+i))*dot(d,dz( 3+j))
                                                        );
               }
               for(int j=0;j<3;j++){
                  U2U2a(iU2+i,iU2+3+j)+=(( 4.00)/o)*(
                      z*dot(dz(   j),dt(   i))
                     -zzz*dot(d,dt(   i))*dot(d,dz(   j))
                                                      );
                  U2U2a(iU2+i,jU2+j)+=(( 4.00)/o)*(
                      z*dot(dt( 3+j),dt(   i))
                     -zzz*dot(d,dt(   i))*dot(d,dt( 3+j))
                                                    );
                  U2U2a(iU2+i,jU2+3+j)+=(( 4.00)/o)*(
                      z*dot(dz( 3+j),dt(   i))
                     -zzz*dot(d,dt(   i))*dot(d,dz( 3+j))
                                                      );
                  U2U2a(iU2+3+i,jU2+j)+=(( 4.00)/o)*(
                      z*dot(dt( 3+j),dz(   i))
                     -zzz*dot(d,dz(   i))*dot(d,dt( 3+j))
                                                      );
                  U2U2a(iU2+3+i,jU2+3+j)+=(( 4.00)/o)*(
                      z*dot(dz( 3+j),dz(   i))
                     -zzz*dot(d,dz(   i))*dot(d,dz( 3+j))
                                                        );
                  U2U2a(jU2+i,jU2+3+j)+=(( 4.00)/o)*(
                      z*dot(dz( 3+j),dt( 3+i))
                     -zzz*dot(d,dt( 3+i))*dot(d,dz( 3+j))
                                                      );
               }
            }
         }
      }
   }
//
// iterate over
//  pairs of strands, consecutive in sequence, connecting pairs of bods
//
   if( (COMPONENT==0)||(COMPONENT==7) ){
      for(int iX= 0;iX<(oX- 1);iX++){
         int iZ9=XZ9(iX);
         int iU2=XU2(iX);
         int oiK4=Z9[iZ9].oK4;
         for(int jX=(iX+ 1);jX<oX;jX++){
            int jZ9=XZ9(jX);
            int jU2=XU2(jX);
            int ojK4=Z9[jZ9].oK4;
            for(int iK4= 0;iK4<oiK4;iK4++){
               int iG7=Z9[iZ9].K4[iK4].G7;
               for(int jK4= 0;jK4<ojK4;jK4++){
                  int jG7=Z9[jZ9].K4[jK4].G7;
                  if      ( jG7==(iG7+ 2) ){
                  }else if( jG7==(iG7- 2) ){
                  }else{
                     continue;
                  }
//
//
// Fg, prefer [(zi*zj)<0]
//
                  if( (oX== 2)||(jX>(iX+ 1)) ){
                     double sgni( 1.00),sgnj( 1.00);
                     if( oiK4> 1 ){
                        sgni= double(Z9[iZ9].K4[iK4].sgny);
                     }
                     if( ojK4> 1 ){
                        sgnj= double(Z9[jZ9].K4[jK4].sgny);
                     }
                     double f= sgni*sgnj*( .50)*physics_consts.PI;
                     double w= (  2.50);
                     double zz= dot(XDz(iX, 0),XDz(jX, 0));
                     double S= std::sin( f*zz);
                     double C= std::cos( f*zz);
                     double e= w*S;
//// out.FILE3<< std::fixed<< std::setprecision(4);
//// out.FILE3<<'#'<< std::setw( 2)<<iG7
////               << std::setw( 2)<<jG7
////               << std::setw( 8)<<e<<'\n';
                     Fg+=e;
                     for(int i=0;i<3;i++){
                        U2g(iU2+3+i)+=w*C*f*dot(XDdz(iX, 0, i),XDz(jX, 0));
                        U2g(jU2+3+i)+=w*C*f*dot(XDz(iX, 0),XDdz(jX, 0, i));
                        for(int j=i;j<3;j++){
                           U2U2a(iU2+3+i,iU2+3+j)+=w*f*(
                               C*dot(XDddz(iX, 0, i,j),XDz(jX, 0))
                              -S*f*dot(XDdz(iX, 0, i),XDz(jX, 0))
                                  *dot(XDdz(iX, 0, j),XDz(jX, 0))
                                                         );
                           U2U2a(jU2+3+i,jU2+3+j)+=w*f*(
                               C*dot(XDz(iX, 0),XDddz(jX, 0, i,j))
                              -S*f*dot(XDz(iX, 0),XDdz(jX, 0, i))
                                  *dot(XDz(iX, 0),XDdz(jX, 0, j))
                                                         );
                        }
                        for(int j=0;j<3;j++){
                           U2U2a(iU2+3+i,jU2+3+j)+=w*f*(
                               C*dot(XDdz(iX, 0, i),XDdz(jX, 0, j))
                              -S*f*dot(XDdz(iX, 0, i),XDz(jX, 0))
                                  *dot(XDz(iX, 0),XDdz(jX, 0, j))
                                                         );
                        }
                     }
                  }
//
//
// select for triple of consecutive strands ehe, eeh, or hee
//
                  bool EHE(false),EEH(false),HEE(false);
                  int jEHE( 1),jEEH( 1),jHEE( 1);
                  int aX(-1),bX(-1),aU2(-1),bU2(-1);
                  for(int pK4= 0;pK4<oiK4;pK4++){
                     if( pK4==iK4 )continue;
                     int pG7=Z9[iZ9].K4[pK4].G7;
                     if      ( pG7==(jG7+ 2) ){
                        EHE=true;
                        jEHE=( Z9[iZ9].K4[pK4].X>
                               Z9[iZ9].K4[iK4].X )? 1:-1;
                        jEHE*=Z9[iZ9].K4[iK4].sgny;
//// out.FILE3<<" EHE["<< std::setw( 2)<<iG7
////                   << std::setw( 2)<<jG7
////                   << std::setw( 2)<<pG7<<']'
////                   << std::setw( 2)<<jEHE<<'\n';
                     }else if( pG7==(jG7- 2) ){
                        EHE=true;
                        jEHE=( Z9[iZ9].K4[iK4].X>
                               Z9[iZ9].K4[pK4].X )? 1:-1;
                        jEHE*=Z9[iZ9].K4[iK4].sgny;
//// out.FILE3<<" EHE["<< std::setw( 2)<<pG7
////                   << std::setw( 2)<<jG7
////                   << std::setw( 2)<<iG7<<']'
////                   << std::setw( 2)<<jEHE<<'\n';
                     }else if( pG7==(iG7+ 2) ){
                        HEE=true;
                        jHEE=( Z9[iZ9].K4[pK4].X>
                               Z9[iZ9].K4[iK4].X )?-1: 1;
                        jHEE*=Z9[iZ9].K4[iK4].sgny;
//// out.FILE3<<" HEE["<< std::setw( 2)<<jG7
////                   << std::setw( 2)<<iG7
////                   << std::setw( 2)<<pG7<<']'
////                   << std::setw( 2)<<jHEE<<'\n';
                     }else if( pG7==(iG7- 2) ){
                        EEH=true;
                        jEEH=( Z9[iZ9].K4[iK4].X>
                               Z9[iZ9].K4[pK4].X )?-1: 1;
                        jEEH*=Z9[iZ9].K4[iK4].sgny;
//// out.FILE3<<" EEH["<< std::setw( 2)<<pG7
////                   << std::setw( 2)<<iG7
////                   << std::setw( 2)<<jG7<<']'
////                   << std::setw( 2)<<jEEH<<'\n';
                     }else{
                        continue;
                     }
                     aX=iX;
                     bX=jX;
                     aU2=iU2;
                     bU2=jU2;
                  }
                  for(int pK4= 0;pK4<ojK4;pK4++){
                     if( pK4==jK4 )continue;
                     int pG7=Z9[jZ9].K4[pK4].G7;
                     if      ( pG7==(iG7+ 2) ){
                        EHE=true;
                        jEHE=( Z9[jZ9].K4[pK4].X>
                               Z9[jZ9].K4[jK4].X )? 1:-1;
                        jEHE*=Z9[jZ9].K4[jK4].sgny;
//// out.FILE3<<" EHE["<< std::setw( 2)<<jG7
////                   << std::setw( 2)<<iG7
////                   << std::setw( 2)<<pG7<<']'
////                   << std::setw( 2)<<jEHE<<'\n';
                     }else if( pG7==(iG7- 2) ){
                        EHE=true;
                        jEHE=( Z9[jZ9].K4[jK4].X>
                               Z9[jZ9].K4[pK4].X )? 1:-1;
                        jEHE*=Z9[jZ9].K4[jK4].sgny;
//// out.FILE3<<" EHE["<< std::setw( 2)<<pG7
////                   << std::setw( 2)<<iG7
////                   << std::setw( 2)<<jG7<<']'
////                   << std::setw( 2)<<jEHE<<'\n';
                     }else if( pG7==(jG7+ 2) ){
                        HEE=true;
                        jHEE=( Z9[jZ9].K4[pK4].X>
                               Z9[jZ9].K4[jK4].X )?-1: 1;
                        jHEE*=Z9[jZ9].K4[jK4].sgny;
//// out.FILE3<<" HEE["<< std::setw( 2)<<iG7
////                   << std::setw( 2)<<jG7
////                   << std::setw( 2)<<pG7<<']'
////                   << std::setw( 2)<<jHEE<<'\n';
                     }else if( pG7==(jG7- 2) ){
                        EEH=true;
                        jEEH=( Z9[jZ9].K4[jK4].X>
                               Z9[jZ9].K4[pK4].X )?-1: 1;
                        jEEH*=Z9[jZ9].K4[jK4].sgny;
//// out.FILE3<<" EEH["<< std::setw( 2)<<pG7
////                   << std::setw( 2)<<jG7
////                   << std::setw( 2)<<iG7<<']'
////                   << std::setw( 2)<<jEEH<<'\n';
                     }else{
                        continue;
                     }
                     aX=jX;
                     bX=iX;
                     aU2=jU2;
                     bU2=iU2;
                  }
                  if( (!EHE)&&(!EEH)&&(!HEE) )continue;
//
//
// distance, 1st and 2nd partial derivs
//
                  Coordinates d=( XDt(bX, 0) -XDt(aX, 0));
                  double r= d.r();
                  if( r<( 1.00e-4) )r=( 1.00e-4);
                  double z= (1.00)/r;
                  double zz= z*z;
                  Coordinates n=z*d;
//
                  dr( 0)= n(0);
                  dr( 1)= n(1);
                  dr( 2)= n(2);
//
                  ddr( 0,0)= z*( (1.00) -n(0)*n(0));
                  ddr( 1,0)= z*(        -n(1)*n(0));
                  ddr( 2,0)= z*(        -n(2)*n(0));
                  ddr( 0,1)= z*(        -n(0)*n(1));
                  ddr( 1,1)= z*( (1.00) -n(1)*n(1));
                  ddr( 2,1)= z*(        -n(2)*n(1));
                  ddr( 0,2)= z*(        -n(0)*n(2));
                  ddr( 1,2)= z*(        -n(1)*n(2));
                  ddr( 2,2)= z*( (1.00) -n(2)*n(2));
//
//
// normal along displacement, 1st and 2nd partial derivs
//
                  dn( 0)(0)= z*( (1.00) -n(0)*n(0));
                  dn( 0)(1)= z*(        -n(0)*n(1));
                  dn( 0)(2)= z*(        -n(0)*n(2));
                  dn( 1)(0)= z*(        -n(1)*n(0));
                  dn( 1)(1)= z*( (1.00) -n(1)*n(1));
                  dn( 1)(2)= z*(        -n(1)*n(2));
                  dn( 2)(0)= z*(        -n(2)*n(0));
                  dn( 2)(1)= z*(        -n(2)*n(1));
                  dn( 2)(2)= z*( (1.00) -n(2)*n(2));
//
                  ddn( 0,0)(0)= zz*( -n(0) -n(0) -n(0) +(3.)*n(0)*n(0)*n(0));
                  ddn( 0,0)(1)= zz*(             -n(1) +(3.)*n(0)*n(0)*n(1));
                  ddn( 0,0)(2)= zz*(             -n(2) +(3.)*n(0)*n(0)*n(2));
                  ddn( 1,0)(0)= zz*(       -n(1)       +(3.)*n(1)*n(0)*n(0));
                  ddn( 1,0)(1)= zz*( -n(0)             +(3.)*n(1)*n(0)*n(1));
                  ddn( 1,0)(2)= zz*(                    (3.)*n(1)*n(0)*n(2));
                  ddn( 2,0)(0)= zz*(       -n(2)       +(3.)*n(2)*n(0)*n(0));
                  ddn( 2,0)(1)= zz*(                    (3.)*n(2)*n(0)*n(1));
                  ddn( 2,0)(2)= zz*( -n(0)             +(3.)*n(2)*n(0)*n(2));
                  ddn( 0,1)(0)= zz*( -n(1)             +(3.)*n(0)*n(1)*n(0));
                  ddn( 0,1)(1)= zz*(       -n(0)       +(3.)*n(0)*n(1)*n(1));
                  ddn( 0,1)(2)= zz*(                    (3.)*n(0)*n(1)*n(2));
                  ddn( 1,1)(0)= zz*(             -n(0) +(3.)*n(1)*n(1)*n(0));
                  ddn( 1,1)(1)= zz*( -n(1) -n(1) -n(1) +(3.)*n(1)*n(1)*n(1));
                  ddn( 1,1)(2)= zz*(             -n(2) +(3.)*n(1)*n(1)*n(2));
                  ddn( 2,1)(0)= zz*(                    (3.)*n(2)*n(1)*n(0));
                  ddn( 2,1)(1)= zz*(       -n(2)       +(3.)*n(2)*n(1)*n(1));
                  ddn( 2,1)(2)= zz*( -n(1)             +(3.)*n(2)*n(1)*n(2));
                  ddn( 0,2)(0)= zz*( -n(2)             +(3.)*n(0)*n(2)*n(0));
                  ddn( 0,2)(1)= zz*(                    (3.)*n(0)*n(2)*n(1));
                  ddn( 0,2)(2)= zz*(       -n(0)       +(3.)*n(0)*n(2)*n(2));
                  ddn( 1,2)(0)= zz*(                    (3.)*n(1)*n(2)*n(0));
                  ddn( 1,2)(1)= zz*( -n(2)             +(3.)*n(1)*n(2)*n(1));
                  ddn( 1,2)(2)= zz*(       -n(1)       +(3.)*n(1)*n(2)*n(2));
                  ddn( 2,2)(0)= zz*(             -n(0) +(3.)*n(2)*n(2)*n(0));
                  ddn( 2,2)(1)= zz*(             -n(1) +(3.)*n(2)*n(2)*n(1));
                  ddn( 2,2)(2)= zz*( -n(2) -n(2) -n(2) +(3.)*n(2)*n(2)*n(2));
//
//
// Fg, prefer [xa*(tb-ta)>0]
//
                  if( EHE ){
                     double w= (-2.50e+0)*double(jEHE);
                     double e= w*dot(XDx(aX, 0), n);
                     Fg+=e;
//// out.FILE3<<" EHE"<< std::setw( 8)<<e<<'\n';
                     for(int i=0;i<3;i++){
                        U2g(aU2+3+i)+=w*dot(XDdx(aX, 0, i), n);
                        U2g(aU2  +i)+=w*dot(XDx(aX, 0),-dn( i));
                        U2g(bU2  +i)+=w*dot(XDx(aX, 0), dn( i));
                        for(int j=i;j<3;j++){
                           U2U2a(aU2+3+i,aU2+3+j)+=w*dot(XDddx(aX, 0, i,j), n);
                           U2U2a(bU2  +i,bU2  +j)+=w*dot(XDx(aX, 0), ddn( i,j));
                           U2U2a(aU2  +i,aU2  +j)+=w*dot(XDx(aX, 0), ddn( i,j));
                        }
                        for(int j=0;j<3;j++){
                           U2U2a(aU2  +j,aU2+3+i)+=
                             w*dot(XDdx(aX, 0, i),-dn( j));
                           U2U2a(bU2  +j,aU2+3+i)+=
                             w*dot(XDdx(aX, 0, i), dn( j));
                           U2U2a(bU2  +i,aU2  +j)+=w*dot(XDx(aX, 0),-ddn( i,j));
                        }
                     }
                  }
                  if( EEH ){ //no selection for up-right-H or up-down-H
                     double w= ( 0.00e+0)*double(jEEH);
                     double e= w*dot(XDx(aX, 0), n);
                     Fg+=e;
//// out.FILE3<<" EEH"<< std::setw( 8)<<e<<'\n';
                     for(int i=0;i<3;i++){
                        U2g(aU2+3+i)+=w*dot(XDdx(aX, 0, i), n);
                        U2g(aU2  +i)+=w*dot(XDx(aX, 0),-dn( i));
                        U2g(bU2  +i)+=w*dot(XDx(aX, 0), dn( i));
                        for(int j=i;j<3;j++){
                           U2U2a(aU2+3+i,aU2+3+j)+=w*dot(XDddx(aX, 0, i,j), n);
                           U2U2a(bU2  +i,bU2  +j)+=w*dot(XDx(aX, 0), ddn( i,j));
                           U2U2a(aU2  +i,aU2  +j)+=w*dot(XDx(aX, 0), ddn( i,j));
                        }
                        for(int j=0;j<3;j++){
                           U2U2a(aU2  +j,aU2+3+i)+=
                             w*dot(XDdx(aX, 0, i),-dn( j));
                           U2U2a(bU2  +j,aU2+3+i)+=
                             w*dot(XDdx(aX, 0, i), dn( j));
                           U2U2a(bU2  +i,aU2  +j)+=w*dot(XDx(aX, 0),-ddn( i,j));
                        }
                     }
                  }
                  if( HEE ){
                     double w= (-5.00e+0)*double(jHEE);
                     double e= w*dot(XDx(aX, 0), n);
                     Fg+=e;
//// out.FILE3<<" HEE"<< std::setw( 8)<<e<<'\n';
                     for(int i=0;i<3;i++){
                        U2g(aU2+3+i)+=w*dot(XDdx(aX, 0, i), n);
                        U2g(aU2  +i)+=w*dot(XDx(aX, 0),-dn( i));
                        U2g(bU2  +i)+=w*dot(XDx(aX, 0), dn( i));
                        for(int j=i;j<3;j++){
                           U2U2a(aU2+3+i,aU2+3+j)+=w*dot(XDddx(aX, 0, i,j), n);
                           U2U2a(bU2  +i,bU2  +j)+=w*dot(XDx(aX, 0), ddn( i,j));
                           U2U2a(aU2  +i,aU2  +j)+=w*dot(XDx(aX, 0), ddn( i,j));
                        }
                        for(int j=0;j<3;j++){
                           U2U2a(aU2  +j,aU2+3+i)+=
                             w*dot(XDdx(aX, 0, i),-dn( j));
                           U2U2a(bU2  +j,aU2+3+i)+=
                             w*dot(XDdx(aX, 0, i), dn( j));
                           U2U2a(bU2  +i,aU2  +j)+=w*dot(XDx(aX, 0),-ddn( i,j));
                        }
                     }
                  }
//
               }
            }
         }
      }
   }
//
//
// measure of chain twist for triples of bods adjacent in chain
//
   if( (COMPONENT==0)||(COMPONENT==8) ){
      for(int iX= 0;iX<(oX- 2);iX++){
         int iZ9=XZ9(iX);
         int oiK4=Z9[iZ9].oK4;
         for(int jX=(iX+ 1);jX<(oX- 1);jX++){
            int jZ9=XZ9(jX);
            int ojK4=Z9[jZ9].oK4;
            for(int kX=(jX+ 1);kX<oX;kX++){
               int kZ9=XZ9(kX);
               int okK4=Z9[kZ9].oK4;
//
               int ordX[ 3];
               double sgn( 1.00);
               bool ADJACENT=false;
               for(int iK4= 0;iK4<oiK4&&(!ADJACENT);iK4++){
                  int iG7=Z9[iZ9].K4[iK4].G7;
                  for(int jK4= 0;jK4<ojK4&&(!ADJACENT);jK4++){
                     int jG7=Z9[jZ9].K4[jK4].G7;
                     for(int kK4= 0;kK4<okK4&&(!ADJACENT);kK4++){
                        int kG7=Z9[kZ9].K4[kK4].G7;
                        if      ( (jG7==(iG7+ 2))&&(kG7==(iG7+ 4)) ){
                           ADJACENT=true;
                           ordX[ 0]=iX;
                           ordX[ 1]=jX;
                           ordX[ 2]=kX;
                           if( ojK4> 1 ){
                              sgn= double(Z9[jZ9].K4[jK4].sgny);
                           }
                        }else if( (kG7==(iG7+ 2))&&(jG7==(iG7+ 4)) ){
                           ADJACENT=true;
                           ordX[ 0]=iX;
                           ordX[ 1]=kX;
                           ordX[ 2]=jX;
                           if( okK4> 1 ){
                              sgn= double(Z9[kZ9].K4[kK4].sgny);
                           }
                        }else if( (iG7==(jG7+ 2))&&(kG7==(jG7+ 4)) ){
                           ADJACENT=true;
                           ordX[ 0]=jX;
                           ordX[ 1]=iX;
                           ordX[ 2]=kX;
                           if( oiK4> 1 ){
                              sgn= double(Z9[iZ9].K4[iK4].sgny);
                           }
                        }else if( (kG7==(jG7+ 2))&&(iG7==(jG7+ 4)) ){
                           ADJACENT=true;
                           ordX[ 0]=jX;
                           ordX[ 1]=kX;
                           ordX[ 2]=iX;
                           if( okK4> 1 ){
                              sgn= double(Z9[kZ9].K4[kK4].sgny);
                           }
                        }else if( (iG7==(kG7+ 2))&&(jG7==(kG7+ 4)) ){
                           ADJACENT=true;
                           ordX[ 0]=kX;
                           ordX[ 1]=iX;
                           ordX[ 2]=jX;
                           if( oiK4> 1 ){
                              sgn= double(Z9[iZ9].K4[iK4].sgny);
                           }
                        }else if( (jG7==(kG7+ 2))&&(iG7==(kG7+ 4)) ){
                           ADJACENT=true;
                           ordX[ 0]=kX;
                           ordX[ 1]=jX;
                           ordX[ 2]=iX;
                           if( ojK4> 1 ){
                              sgn= double(Z9[jZ9].K4[jK4].sgny);
                           }
                        }
                     }
                  }
               }
               if( !ADJACENT )continue;
//
//
// normal along displacement, 1st and 2nd partial derivs
//
               Coordinates d=( XDt(ordX[ 0], 0) -XDt(ordX[ 1], 0));
               double r= d.r();
               if( r<( 1.00e-7) )r=( 1.00e-7);
               double p= (1.00)/r;
               double pp= p*p;
               Coordinates ni=p*d;
//
               dni( 0)(0)= p*( (1.00) -ni(0)*ni(0));
               dni( 0)(1)= p*(        -ni(0)*ni(1));
               dni( 0)(2)= p*(        -ni(0)*ni(2));
               dni( 1)(0)= p*(        -ni(1)*ni(0));
               dni( 1)(1)= p*( (1.00) -ni(1)*ni(1));
               dni( 1)(2)= p*(        -ni(1)*ni(2));
               dni( 2)(0)= p*(        -ni(2)*ni(0));
               dni( 2)(1)= p*(        -ni(2)*ni(1));
               dni( 2)(2)= p*( (1.00) -ni(2)*ni(2));
//
               ddni( 0,0)(0)= pp*(-ni(0)-ni(0)-ni(0) +(3.)*ni(0)*ni(0)*ni(0));
               ddni( 0,0)(1)= pp*(            -ni(1) +(3.)*ni(0)*ni(0)*ni(1));
               ddni( 0,0)(2)= pp*(            -ni(2) +(3.)*ni(0)*ni(0)*ni(2));
               ddni( 1,0)(0)= pp*(      -ni(1)       +(3.)*ni(1)*ni(0)*ni(0));
               ddni( 1,0)(1)= pp*(-ni(0)             +(3.)*ni(1)*ni(0)*ni(1));
               ddni( 1,0)(2)= pp*(                    (3.)*ni(1)*ni(0)*ni(2));
               ddni( 2,0)(0)= pp*(      -ni(2)       +(3.)*ni(2)*ni(0)*ni(0));
               ddni( 2,0)(1)= pp*(                    (3.)*ni(2)*ni(0)*ni(1));
               ddni( 2,0)(2)= pp*(-ni(0)             +(3.)*ni(2)*ni(0)*ni(2));
               ddni( 0,1)(0)= pp*(-ni(1)             +(3.)*ni(0)*ni(1)*ni(0));
               ddni( 0,1)(1)= pp*(      -ni(0)       +(3.)*ni(0)*ni(1)*ni(1));
               ddni( 0,1)(2)= pp*(                    (3.)*ni(0)*ni(1)*ni(2));
               ddni( 1,1)(0)= pp*(            -ni(0) +(3.)*ni(1)*ni(1)*ni(0));
               ddni( 1,1)(1)= pp*(-ni(1)-ni(1)-ni(1) +(3.)*ni(1)*ni(1)*ni(1));
               ddni( 1,1)(2)= pp*(            -ni(2) +(3.)*ni(1)*ni(1)*ni(2));
               ddni( 2,1)(0)= pp*(                    (3.)*ni(2)*ni(1)*ni(0));
               ddni( 2,1)(1)= pp*(      -ni(2)       +(3.)*ni(2)*ni(1)*ni(1));
               ddni( 2,1)(2)= pp*(-ni(1)             +(3.)*ni(2)*ni(1)*ni(2));
               ddni( 0,2)(0)= pp*(-ni(2)             +(3.)*ni(0)*ni(2)*ni(0));
               ddni( 0,2)(1)= pp*(                    (3.)*ni(0)*ni(2)*ni(1));
               ddni( 0,2)(2)= pp*(      -ni(0)       +(3.)*ni(0)*ni(2)*ni(2));
               ddni( 1,2)(0)= pp*(                    (3.)*ni(1)*ni(2)*ni(0));
               ddni( 1,2)(1)= pp*(-ni(2)             +(3.)*ni(1)*ni(2)*ni(1));
               ddni( 1,2)(2)= pp*(      -ni(1)       +(3.)*ni(1)*ni(2)*ni(2));
               ddni( 2,2)(0)= pp*(            -ni(0) +(3.)*ni(2)*ni(2)*ni(0));
               ddni( 2,2)(1)= pp*(            -ni(1) +(3.)*ni(2)*ni(2)*ni(1));
               ddni( 2,2)(2)= pp*(-ni(2)-ni(2)-ni(2) +(3.)*ni(2)*ni(2)*ni(2));
//
//
// normal along displacement, 1st and 2nd partial derivs
//
               d=( XDt(ordX[ 2], 0) -XDt(ordX[ 1], 0));
               r= d.r();
               if( r<( 1.00e-7) )r=( 1.00e-7);
               p= (1.00)/r;
               pp= p*p;
               Coordinates nk=p*d;
//
               dnk( 0)(0)= p*( (1.00) -nk(0)*nk(0));
               dnk( 0)(1)= p*(        -nk(0)*nk(1));
               dnk( 0)(2)= p*(        -nk(0)*nk(2));
               dnk( 1)(0)= p*(        -nk(1)*nk(0));
               dnk( 1)(1)= p*( (1.00) -nk(1)*nk(1));
               dnk( 1)(2)= p*(        -nk(1)*nk(2));
               dnk( 2)(0)= p*(        -nk(2)*nk(0));
               dnk( 2)(1)= p*(        -nk(2)*nk(1));
               dnk( 2)(2)= p*( (1.00) -nk(2)*nk(2));
//
               ddnk( 0,0)(0)= pp*(-nk(0)-nk(0)-nk(0) +(3.)*nk(0)*nk(0)*nk(0));
               ddnk( 0,0)(1)= pp*(            -nk(1) +(3.)*nk(0)*nk(0)*nk(1));
               ddnk( 0,0)(2)= pp*(            -nk(2) +(3.)*nk(0)*nk(0)*nk(2));
               ddnk( 1,0)(0)= pp*(      -nk(1)       +(3.)*nk(1)*nk(0)*nk(0));
               ddnk( 1,0)(1)= pp*(-nk(0)             +(3.)*nk(1)*nk(0)*nk(1));
               ddnk( 1,0)(2)= pp*(                    (3.)*nk(1)*nk(0)*nk(2));
               ddnk( 2,0)(0)= pp*(      -nk(2)       +(3.)*nk(2)*nk(0)*nk(0));
               ddnk( 2,0)(1)= pp*(                    (3.)*nk(2)*nk(0)*nk(1));
               ddnk( 2,0)(2)= pp*(-nk(0)             +(3.)*nk(2)*nk(0)*nk(2));
               ddnk( 0,1)(0)= pp*(-nk(1)             +(3.)*nk(0)*nk(1)*nk(0));
               ddnk( 0,1)(1)= pp*(      -nk(0)       +(3.)*nk(0)*nk(1)*nk(1));
               ddnk( 0,1)(2)= pp*(                    (3.)*nk(0)*nk(1)*nk(2));
               ddnk( 1,1)(0)= pp*(            -nk(0) +(3.)*nk(1)*nk(1)*nk(0));
               ddnk( 1,1)(1)= pp*(-nk(1)-nk(1)-nk(1) +(3.)*nk(1)*nk(1)*nk(1));
               ddnk( 1,1)(2)= pp*(            -nk(2) +(3.)*nk(1)*nk(1)*nk(2));
               ddnk( 2,1)(0)= pp*(                    (3.)*nk(2)*nk(1)*nk(0));
               ddnk( 2,1)(1)= pp*(      -nk(2)       +(3.)*nk(2)*nk(1)*nk(1));
               ddnk( 2,1)(2)= pp*(-nk(1)             +(3.)*nk(2)*nk(1)*nk(2));
               ddnk( 0,2)(0)= pp*(-nk(2)             +(3.)*nk(0)*nk(2)*nk(0));
               ddnk( 0,2)(1)= pp*(                    (3.)*nk(0)*nk(2)*nk(1));
               ddnk( 0,2)(2)= pp*(      -nk(0)       +(3.)*nk(0)*nk(2)*nk(2));
               ddnk( 1,2)(0)= pp*(                    (3.)*nk(1)*nk(2)*nk(0));
               ddnk( 1,2)(1)= pp*(-nk(2)             +(3.)*nk(1)*nk(2)*nk(1));
               ddnk( 1,2)(2)= pp*(      -nk(1)       +(3.)*nk(1)*nk(2)*nk(2));
               ddnk( 2,2)(0)= pp*(            -nk(0) +(3.)*nk(2)*nk(2)*nk(0));
               ddnk( 2,2)(1)= pp*(            -nk(1) +(3.)*nk(2)*nk(2)*nk(1));
               ddnk( 2,2)(2)= pp*(-nk(2)-nk(2)-nk(2) +(3.)*nk(2)*nk(2)*nk(2));
//
//
// normal along z-axis, 1st and 2nd partial derivs
//
               Coordinates zj=XDz(ordX[ 1], 0);
//
               for(int i=0;i<3;i++){
                  dzj( i)=XDdz(ordX[ 1], 0, i);
                  for(int j=0;j<3;j++){
                     ddzj( i,j)=XDddz(ordX[ 1], 0, i,j);
                  }
               }
//
//
// components of target func
//
               double C= dot(zj,ni);
               double S= std::sqrt( (1.00) -C*C);
               if( S<( 1.00e-7) )S=( 1.00e-7);
               double zS= (1.00)/S;
               double zSS= zS*zS;
               double zSSS= zS*zSS;
               double zB= (1.00)/( S +( 1.00e-3));
               double zBB= zB*zB;
               double zBBB= zB*zBB;
               Coordinates z= zB*cross(zj,ni);
//
//
// 1st and 2nd partial derivs of z wrt rot
//
               for(int i=0;i<3;i++){
                  dz(   i)=( zB*cross(dzj( i),ni)
                            +zBB*C*zS*dot(dzj( i),ni)
                            *cross(zj,ni));
                  dz( 3+i)=( zB*cross(zj,dni( i))
                            +zBB*C*zS*dot(zj,dni( i))
                            *cross(zj,ni));
                  for(int j=0;j<3;j++){
                     ddz(   i,  j)=( zB*cross(ddzj( i,j),ni)
                                    +zBB*C*zS*dot(dzj( j),ni)
                                    *cross(dzj( i),ni)
                                    +zBB*C*zS*dot(dzj( i),ni)
                                    *cross(dzj( j),ni)
                                    +zBB*C*zS*dot(ddzj( i,j),ni)
                                    *cross(zj,ni)
                                    +zBB*( zS +C*C*zSSS)
                                        *dot(dzj( j),ni)
                                        *dot(dzj( i),ni)
                                    *cross(zj,ni)
                                    +(2.)*zBBB*C*zS*dot(dzj( j),ni)
                                              *C*zS*dot(dzj( i),ni)
                                    *cross(zj,ni));
                     ddz(   i,3+j)=( zB*cross(dzj( i),dni( j))
                                    +zBB*C*zS*dot(zj,dni( j))
                                    *cross(dzj( i),ni)
                                    +zBB*C*zS*dot(dzj( i),ni)
                                    *cross(zj,dni( j))
                                    +zBB*C*zS*dot(dzj( i),dni( j))
                                    *cross(zj,ni)
                                    +zBB*( zS +C*C*zSSS)
                                        *dot(zj,dni( j))
                                        *dot(dzj( i),ni)
                                    *cross(zj,ni)
                                    +(2.)*zBBB*C*zS*dot(zj,dni( j))
                                              *C*zS*dot(dzj( i),ni)
                                    *cross(zj,ni));
                     ddz( 3+j,  i)= ddz(   i,3+j);
                     ddz( 3+i,3+j)=( zB*cross(zj,ddni( i,j))
                                    +zBB*C*zS*dot(zj,dni( j))
                                    *cross(zj,dni( i))
                                    +zBB*C*zS*dot(zj,dni( i))
                                    *cross(zj,dni( j))
                                    +zBB*C*zS*dot(zj,ddni( i,j))
                                    *cross(zj,ni)
                                    +zBB*( zS +C*C*zSSS)
                                        *dot(zj,dni( j))
                                        *dot(zj,dni( i))
                                    *cross(zj,ni)
                                    +(2.)*zBBB*C*zS*dot(zj,dni( j))
                                              *C*zS*dot(zj,dni( i))
                                    *cross(zj,ni));
                  }
               }
//
//
// Fg, prefer [zj*(tk-tj)x(ti-tj)<0]
//
               int iU2=XU2(ordX[ 0]);
               int jU2=XU2(ordX[ 1]);
               int kU2=XU2(ordX[ 2]);
               double f= sgn*( .50)*physics_consts.PI;
               double w= ( -5.00);
               double det= dot(nk,z);
               S= std::sin( f*det);
               C= std::cos( f*det);
               double e= w*S;
               Fg+=e;
               for(int i=0;i<3;i++){
                  U2g(iU2+i)+=w*C*f*dot(nk,dz( 3+i));
                  U2g(jU2+i)+=w*C*f*(-dot(dnk(i),z)
                                     -dot(nk,dz( 3+i)));
                  U2g(jU2+3+i)+=w*C*f*dot(nk,dz( i));
                  U2g(kU2+i)+=w*C*f*dot(dnk(i),z);
                  for(int j=i;j<3;j++){
                     U2U2a(iU2+i,iU2+j)+=w*f*(
                         C*dot(nk,ddz( 3+i,3+j))
                        -S*f*dot(nk,dz( 3+i))
                            *dot(nk,dz( 3+j))
                                               );
                     U2U2a(jU2+i,jU2+j)+=w*f*(
                         C*( dot(ddnk(i,j),z)
                            +dot(dnk(i),dz( 3+j))
                            +dot(dnk(j),dz( 3+i))
                            +dot(nk,ddz( 3+i,3+j)))
                        -S*f*( dot(dnk(i),z)
                              +dot(nk,dz( 3+i)))
                            *( dot(dnk(j),z)
                              +dot(nk,dz( 3+j)))
                                               );
                     U2U2a(jU2+3+i,jU2+3+j)+=w*f*(
                         C*dot(nk,ddz( i,j))
                        -S*f*dot(nk,dz( i))
                            *dot(nk,dz( j))
                                                   );
                     U2U2a(kU2+i,kU2+j)+=w*f*(
                         C*dot(ddnk(i,j),z)
                        -S*f*dot(dnk(i),z)
                            *dot(dnk(j),z)
                                               );
                  }
                  for(int j=0;j<3;j++){
                     U2U2a(iU2+i,jU2+j)+=w*f*(
                        -C*( dot(dnk(j),dz( 3+i))
                            +dot(nk,ddz( 3+i,3+j)))
                        +S*f*dot(nk,dz( 3+i))
                            *( dot(nk,dz( 3+j))
                              +dot(dnk(j),z))
                                               );
                     U2U2a(iU2+i,jU2+3+j)+=w*f*(
                         C*dot(nk,cross(dzj(j),dni(i)))
                        -S*f*dot(nk,dz( 3+i))
                            *dot(nk,cross(dzj(j),ni))
                                                 );
                     U2U2a(iU2+i,kU2+j)+=w*f*(
                         C*dot(dnk(j),dz( 3+i))
                        -S*f*dot(nk,dz( 3+i))
                            *dot(dnk(j),z)
                                               );
                     U2U2a(jU2+i,jU2+3+j)+=w*f*(
                         C*(-dot(dnk(i),dz( j))
                            -dot(nk,ddz( j,3+i)))
                        -S*f*(-dot(dnk(i),z)
                              -dot(nk,dz( 3+i)))
                            *dot(nk,dz( j))
                                                 );
                     U2U2a(jU2+i,kU2+j)+=w*f*(
                         C*(-dot(ddnk(i,j),z)
                            -dot(dnk(j),dz( 3+i)))
                        -S*f*(-dot(dnk(i),z)
                              -dot(nk,dz( 3+i)))
                            *dot(dnk(j),z)
                                               );
                     U2U2a(jU2+3+i,kU2+j)+=w*f*(
                         C*dot(dnk(j),dz( i))
                        -S*f*dot(nk,dz( i))
                              *dot(dnk(j),z)
                                                 );
                  }
               }
            }
         }
      }
   }
   TOT=( Fa +Fb +Fc +Fd +Fe +Ff +Fg);
   for(int iU2= 0;iU2<(oU2- 1);iU2++){
      for(int jU2=(iU2+ 1);jU2<oU2;jU2++){
         U2U2a(iU2,jU2)+=U2U2a(jU2,iU2);
         U2U2a(jU2,iU2)= (0.00);
      }
   }
//
//
// diagnostic output
//
//// std::string hrule="________________________________________"
////                   "________________________________________\n";
//// out.FILE3<<hrule;
//// out.FILE3<< std::fixed<< std::setprecision(4);
//// out.FILE3<<"    Fa        Fb        Fc        Fd    "
////            "    Fe        Ff        Fg    \n";
//// out.FILE3<<'#'<< std::setw(10)<<Fa
////          << std::setw(10)<<Fb
////          << std::setw(10)<<Fc
////          << std::setw(10)<<Fd
////          << std::setw(10)<<Fe
////          << std::setw(10)<<Ff
////          << std::setw(10)<<Fg<<'\n';
//// out.FILE3<< std::scientific<< std::setprecision( 8);
//// out.FILE3<<"TOT\n";
//// out.FILE3<< std::setw(15)<<TOT<<'\n';
//// out.FILE3<<"U2g\n";
//// for(int iU2= 0;iU2<oU2;iU2++){
////    out.FILE3<< std::setw(15)<<U2g(iU2);
////    if( ((iU2+1)%8==0)||(iU2==(oU2-1)) )out.FILE3<<'\n';
//// }
//// out.FILE3<<"U2U2a\n";
//// for(int iU2= 0;iU2<oU2;iU2++){
////    for(int jU2=iU2;jU2<oU2;jU2++){
////       out.FILE3<< std::setw(15)<<U2U2a(iU2,jU2);
////       if( ((jU2-iU2+1)%8==0)||(jU2==(oU2-1)) )out.FILE3<<'\n';
////    }
//// }
   return;
}
