#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../reg/Regularization_Target.hh"
#include "../str/Output_Streams.hh"
#include <vector>
/**/#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_igo_3traj_x {
private:
   std::vector<bool> o_G7sub;   //subset of elements
public:
   MEM_igo_3traj_x(int g):
      o_G7sub(g, false)
   {
   }
   void G7sub(int i,bool a){
      o_G7sub[ i]=a;  }
   bool G7sub(int i){
      return o_G7sub[ i];  }
};

bool Igor_Model::IGO_3TRAJ_X(const DAT_PHYSICS_CONSTS& physics_consts,
                             Output_Streams& out){
   int iU9=T9[ 0].U9;
   int iY9=T9[ 0].Y9;
   bool BETAHELIX=( M9[ 0].oS9==1 )?  true: false;
//
//
// bod ca and sc coords
//
   for(int iZ9= 0;iZ9<iU9;iZ9++){
      int oK4=U9[iU9].Y9[iY9].Z9[iZ9].oK4;
      if( oK4==1 ){
         int iG7=U9[iU9].Y9[iY9].Z9[iZ9].K4[ 0].G7;
         int mR0=G7[iG7].mR0;
         int nR0=G7[iG7].nR0;
//
         Coordinates z;
         {
            double alp= U9[iU9].Y9[iY9].Z9[iZ9].c(0,0);
            double bet= U9[iU9].Y9[iY9].Z9[iZ9].c(1,0);
            double Calp= std::cos( alp);
            double Salp= std::sin( alp);
            double Cbet= std::cos( bet);
            double Sbet= std::sin( bet);
            z(0)= Calp*Sbet;
            z(1)= Salp*Sbet;
            z(2)= Cbet;
         }
         double d= dot(( U9[iU9].Y9[iY9].Z9[iZ9].K4[ 0].u
                        -U9[iU9].Y9[iY9].Z9[iZ9].t),z);
         Coordinates trans=( U9[iU9].Y9[iY9].Z9[iZ9].t +d*z);
         Rotation_Matrix rot=U9[iU9].Y9[iY9].Z9[iZ9].K4[ 0].r;
//
         double R= (2.278);
         double dthe= physics_consts.PI/(1.80);
         double dz= (1.50);
         double dR=( 2.25);
//
         for(int iR0=mR0;iR0<=nR0;iR0++){
            double the=( double(iR0-mR0)*dthe);
            double Cthe= std::cos( the);
            double Sthe= std::sin( the);
            Coordinates a;
            a(0)= R*Cthe;
            a(1)= R*Sthe;
            a(2)= double(iR0-mR0)*dz;
            Coordinates n;
            n(0)=-dthe*R*Sthe;
            n(1)= dthe*R*Cthe;
            n(2)= dz;
            n.normalize();
            Coordinates b;
            b(0)=( R +dR)*Cthe;
            b(1)=( R +dR)*Sthe;
            b(2)= double(iR0-mR0)*dz +( .50);
            R0[iR0].xca=( trans +rot*a);
            R0[iR0].nca=rot*n;
            R0[iR0].xsc=( trans +rot*b);
            double phi=( the -( .519));
            double Cphi= std::cos( phi);
            double Sphi= std::sin( phi);
            a(0)= (1.576)*Cphi;
            a(1)= (1.576)*Sphi;
            a(2)= double(iR0-mR0)*dz -(1.164);
            R0[iR0].xn=( trans +rot*a);
            phi=( the +( .519));
            Cphi= std::cos( phi);
            Sphi= std::sin( phi);
            a(0)= (1.576)*Cphi;
            a(1)= (1.576)*Sphi;
            a(2)= double(iR0-mR0)*dz +(1.220);
            R0[iR0].xc=( trans +rot*a);
            R0[iR0].del= dR;
         }
//
      }else if( BETAHELIX ){
         for(int iK4= 0;iK4<oK4;iK4++){
            int iG7=U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].G7;
            int mR0=G7[iG7].mR0;
            int nR0=G7[iG7].nR0;
            double sgnz= double( U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].sgny);
            double sgny= double( U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].sgnx);
            double sgnx=-sgny*sgnz;
//
            Rotation_Matrix rot;
            Coordinates trans;
            double R( 0.00),dz( 0.00),dthe( 0.00);
            {
               rot=U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].r;
               Coordinates x,z;
               for(int i=0;i<3;i++){
                  x(i)= rot(i,0);
                  z(i)= rot(i,2);
               }
               Coordinates u=U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].u;
               Coordinates v=U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].v;
               Coordinates t=U9[iU9].Y9[iY9].Z9[iZ9].t;
               double d= dot(( u -t),z);
               trans=( t +d*z);
               R= dot(( u -t),x);
               dz= dot(( v -u),z);
               dz/=double(nR0-mR0);
               double Sbet= dz/(3.);
               double Cbet= sgnz*std::sqrt( (1.00) -Sbet*Sbet);
               dthe= (3.)*Cbet/R;
            }
            double Sgam= dz/(3.80);
            double SSgam= Sgam*Sgam;
            double Cgam= sgnz*std::sqrt( (1.00) -SSgam);
            double CCgam= Cgam*Cgam;
            double CSgam= Cgam*Sgam;
            double gam= std::atan2(Sgam,Cgam);
            double alp= physics_consts.RAD*(  17.771);
            double bb= R*R;
            double cc= (1.90)*Cgam*(1.90)*Cgam;
            CM(3,4)= bb;
            CM(4,3)= bb;
            CM(2,3)= cc;
            CM(3,2)= cc;
            CM(1,4)= (1.00);
            CM(4,1)= (1.00);
//
            for(int iR0=mR0;iR0<=nR0;iR0++){
               double the=( double(iR0-mR0)*dthe);
               double Cthe= std::cos( the);
               double Sthe= std::sin( the);
               Coordinates a;
               a(0)=( R +sgnx*(1.16619))*Cthe;
               a(1)=( R +sgnx*(1.16619))*Sthe;
               a(2)= double(iR0-mR0)*dz;
               Coordinates n;
               n(0)=-dthe*R*Sthe;
               n(1)= dthe*R*Cthe;
               n(2)= dz;
               n.normalize();
               Coordinates b;
               b(0)=( R +sgnx*(3.41619))*Cthe;
               b(1)=( R +sgnx*(3.41619))*Sthe;
               b(2)= double(iR0-mR0)*dz;
               R0[iR0].xca=( trans +rot*a);
               R0[iR0].nca=rot*n;
               R0[iR0].xsc=( trans +rot*b);
               double aa= ( R +sgnx*(1.16619))*( R +sgnx*(1.16619));
               CM(2,4)= aa;
               CM(4,2)= aa;
               for(int j=-1;j< 2;j+=2){
                  double f= double(j);
                  Coordinates dx;
                  {
                     double lam=( gam -f*sgnx*alp);
                     if( j==1 ){
                     }else{
                        lam-=physics_consts.PI;
                     }
                     dx(0)= (0.00);
                     dx(1)= ( 1.488)*std::cos( lam);
                     dx(2)= ( 1.488)*std::sin( lam);
                  }
                  Coordinates m,n;      //target plane, peptide plane
                  {
                     double pR=( R +sgnx*(1.16619)*SSgam);
                     double pthe= (-.50)*dthe*SSgam;
                     double Cpthe= std::cos( pthe);
                     double Spthe= std::sin( pthe);
                     double pz= ( .50)*dz*CCgam;
                     m(0)=-pR*pthe*Spthe;
                     m(1)= pR*pthe*Cpthe;
                     m(2)= pz;
                     m.normalize();
                     n(0)= f*sgnx*(1.16619)*SSgam;
                     n(1)= -sgnz*std::sqrt( cc -(1.16619)*(1.16619))*SSgam;
                     n(2)= pz;
                     n.normalize();
                  }
                  double Cphi= dot(m,n);
                  double Sphi=-f*sgnx*std::sqrt( (1.00) -Cphi*Cphi);
                  double phi= std::atan2(Sphi,Cphi);
                  Rotation_Matrix Q;
                  Q(0,0)= Cphi;
                  Q(1,0)= Sgam*Sphi;
                  Q(2,0)=-Cgam*Sphi;
                  Q(0,1)=-Sgam*Sphi;
                  Q(1,1)=( SSgam*Cphi +CCgam);
                  Q(2,1)=-CSgam*( Cphi -(1.));
                  Q(0,2)= Cgam*Sphi;
                  Q(1,2)=-CSgam*( Cphi -(1.));
                  Q(2,2)=( CCgam*Cphi +SSgam);
                  dx=Q*dx;
                  double xx=( dx(0)*dx(0) +dx(1)*dx(1));
                  double yy=( dx(0)*dx(0)
                             +std::pow( ( (1.90)*Cgam -f*dx(1)), 2));
                  CM(1,2)= xx;
                  CM(2,1)= xx;
                  CM(1,3)= yy;
                  CM(3,1)= yy;
                  double zz= IGO_CAYLEY_MENGER(out,( dx(0)<=(0.00) ));
                  double z= std::sqrt( zz);
                  double qR=( z -R);
                  double p;
                  double qthe( 0.00);
                  if( aa>zz ){
                     p=( aa -xx +zz)/((2.)*( R +sgnx*(1.16619)));
                     qthe= f*sgnz*std::acos( p/z);
                  }else{
                     p=( aa -xx +zz)/((2.)*z);
                     qthe= f*sgnz*std::acos( p/( R +sgnx*(1.16619)));
                  }
                  double qz= dx(2);
                  a(0)=( R +qR)*std::cos( the +qthe);
                  a(1)=( R +qR)*std::sin( the +qthe);
                  a(2)= double(iR0-mR0)*dz +qz;
                  if( j==1 ){
                     R0[iR0].xc=( trans +rot*a);
                  }else{
                     R0[iR0].xn=( trans +rot*a);
                  }
               }
               R0[iR0].del= (2.25)*sgnx;
               sgnx=-sgnx;
            }
         }
//
      }else{
         for(int iK4= 0;iK4<oK4;iK4++){
            int iG7=U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].G7;
            int mR0=G7[iG7].mR0;
            int nR0=G7[iG7].nR0;
//
            Coordinates trans=U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].u;
            Rotation_Matrix rot=U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].r;
//
            double dz= (3.00);
            double sgnz= double( U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].sgny);
            double sgny= double( U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].sgnx);
            double sgnx= sgny*sgnz;
            double Cbet= ( .78947);
            double Sbet= ( .61378);
            double Cdel= ( .94767);
            double Sdel= ( .31924);
//
            for(int iR0=mR0;iR0<=nR0;iR0++){
               Coordinates a;
               a(0)= ( 1.16619)*sgnx;
               a(1)=( 0.00);
               a(2)= double(iR0-mR0)*sgnz*dz;
               R0[iR0].xca=( trans +rot*a);
               for(int i=0;i<3;i++){
                  R0[iR0].nca(i)= sgnz*rot(i,2);
               }
               Coordinates b;
               b(0)=( ( 1.16619) +( 2.25))*sgnx;
               b(1)=( 0.00);
               b(2)= double(iR0-mR0)*sgnz*dz;
               R0[iR0].xsc=( trans +rot*b);
               a(0)=( ( 1.16619) -( 1.453)*Sbet*Cdel)*sgnx;
               a(1)= ( 1.453)*Sdel*sgny;
               a(2)=( double(iR0-mR0)*dz -( 1.453)*Cbet*Cdel)*sgnz;
               R0[iR0].xn=( trans +rot*a);
               b(0)=( ( 1.16619) -( 1.522)*Sbet*Cdel)*sgnx;
               b(1)= ( 1.522)*Sdel*sgny;
               b(2)=( double(iR0-mR0)*dz +( 1.522)*Cbet*Cdel)*sgnz;
               R0[iR0].xc=( trans +rot*b);
               R0[iR0].del= ( 2.25)*sgnx;
               sgny=-sgny;
               sgnx=-sgnx;
            }
         }
//
      }
   }
   MEM_igo_3traj_x vv(oG7);
//
//
// mean position of elements
//
   for(int iZ9= 0;iZ9<iU9;iZ9++){
      int oK4=U9[iU9].Y9[iY9].Z9[iZ9].oK4;
      for(int iK4= 0;iK4<oK4;iK4++){
         int iG7=U9[iU9].Y9[iY9].Z9[iZ9].K4[iK4].G7;
         vv.G7sub(iG7,true);
      }
   }
   Coordinates xcor;
   {
      xcor.zero();
      int n=0;
      for(int iG7= 0;iG7<oG7;iG7++){
         if( !vv.G7sub(iG7) )continue;
         int mR0=G7[iG7].mR0;
         int nR0=G7[iG7].nR0;
         for(int iR0=mR0;iR0<=nR0;iR0++){
            xcor+=R0[iR0].xca;
            n++;
         }
      }
      xcor/=double( n);
   }
//
//
// coil bb and sc coords
//
   int aR0=-1;
   for(int iG7= 0;iG7<oG7;iG7++){
      if( !vv.G7sub(iG7) )continue;
      int bR0=G7[iG7].mR0;
      if( aR0==-1 ){
         double R= (5.00);
         double dz= ( 2.70);
         double Sbet= dz/(3.);
         double Cbet= std::sqrt( (1.00) -Sbet*Sbet);
         double dthe= (3.)*Cbet/R;
//
//
// N-terminal segment bb and sc site coords
//
         Rotation_Matrix rot;
         Coordinates trans;
         {
            Coordinates u=( xcor -R0[bR0].xca);
            Coordinates z=-R0[bR0].nca;
            Coordinates x=cross(z,u);
            double rr= x.rr();
            if( rr<( 1.00e-10) ){
               out.FILE3<<"LOOP GEN FAILURE\n";
               return true;
            }
            double r= std::sqrt( rr);
            x/=r;
            Coordinates y=cross(z,x);
            for(int i=0;i<3;i++){
               rot(i,0)= x(i);
               rot(i,1)= y(i);
               rot(i,2)= z(i);
            }
            trans=( R0[bR0].xca -R*x);
         }
         double sgnx= (-1.00)*(R0[bR0].del
                    /std::abs( R0[bR0].del));
         double Sgam= dz/(3.80);
         double SSgam= Sgam*Sgam;
         double Cgam= std::sqrt( (1.00) -SSgam);
         double CCgam= Cgam*Cgam;
         double CSgam= Cgam*Sgam;
         double gam= std::atan2(Sgam,Cgam);
         double alp= physics_consts.RAD*(  17.771);
         double bb= R*R;
         double cc= (1.90)*Cgam*(1.90)*Cgam;
         CM(3,4)= bb;
         CM(4,3)= bb;
         CM(2,3)= cc;
         CM(3,2)= cc;
         CM(1,4)= (1.00);
         CM(4,1)= (1.00);
//
         for(int iR0=(bR0- 1);iR0>aR0;iR0--){
            double the=( double(bR0-iR0)*dthe);
            double Cthe= std::cos( the);
            double Sthe= std::sin( the);
            Coordinates a;
            a(0)=( R +sgnx*(1.16619))*Cthe;
            a(1)=( R +sgnx*(1.16619))*Sthe;
            a(2)= double(bR0-iR0)*dz;
            Coordinates b;
            b(0)=( R +sgnx*(3.41619))*Cthe;
            b(1)=( R +sgnx*(3.41619))*Sthe;
            b(2)= double(bR0-iR0)*dz;
            R0[iR0].xca=( trans +rot*a);
            R0[iR0].xsc=( trans +rot*b);
            double aa= ( R +sgnx*(1.16619))*( R +sgnx*(1.16619));
            CM(2,4)= aa;
            CM(4,2)= aa;
            for(int j=-1;j< 2;j+=2){
               double f= double(j);
               Coordinates dx;
               {
                  double lam=( gam +f*sgnx*alp);
                  if( j==1 ){
                  }else{
                     lam-=physics_consts.PI;
                  }
                  dx(0)= (0.00);
                  dx(1)= ( 1.488)*std::cos( lam);
                  dx(2)= ( 1.488)*std::sin( lam);
               }
               Coordinates m,n;      //target plane, peptide plane
               {
                  double pR=( R +sgnx*(1.16619)*SSgam);
                  double pthe= (-.50)*dthe*SSgam;
                  double Cpthe= std::cos( pthe);
                  double Spthe= std::sin( pthe);
                  double pz= ( .50)*dz*CCgam;
                  m(0)=-pR*pthe*Spthe;
                  m(1)= pR*pthe*Cpthe;
                  m(2)= pz;
                  m.normalize();
                  n(0)= f*sgnx*(1.16619)*SSgam;
                  n(1)= -std::sqrt( cc -(1.16619)*(1.16619))*SSgam;
                  n(2)= pz;
                  n.normalize();
               }
               double Cphi= dot(m,n);
               double Sphi=-f*sgnx*std::sqrt( (1.00) -Cphi*Cphi);
               double phi= std::atan2(Sphi,Cphi);
               Rotation_Matrix Q;
               Q(0,0)= Cphi;
               Q(1,0)= Sgam*Sphi;
               Q(2,0)=-Cgam*Sphi;
               Q(0,1)=-Sgam*Sphi;
               Q(1,1)=( SSgam*Cphi +CCgam);
               Q(2,1)=-CSgam*( Cphi -(1.));
               Q(0,2)= Cgam*Sphi;
               Q(1,2)=-CSgam*( Cphi -(1.));
               Q(2,2)=( CCgam*Cphi +SSgam);
               dx=Q*dx;
               double xx=( dx(0)*dx(0) +dx(1)*dx(1));
               double yy=( dx(0)*dx(0)
                          +std::pow( ( (1.90)*Cgam -f*dx(1)), 2));
               CM(1,2)= xx;
               CM(2,1)= xx;
               CM(1,3)= yy;
               CM(3,1)= yy;
               double zz= IGO_CAYLEY_MENGER(out,( dx(0)<=(0.00) ));
               double z= std::sqrt( zz);
               double qR=( z -R);
               double p;
               double qthe( 0.00);
               if( aa>zz ){
                  p=( aa -xx +zz)/((2.)*( R +sgnx*(1.16619)));
                  qthe= f*std::acos( p/z);
               }else{
                  p=( aa -xx +zz)/((2.)*z);
                  qthe= f*std::acos( p/( R +sgnx*(1.16619)));
               }
               double qz= dx(2);
               a(0)=( R +qR)*std::cos( the +qthe);
               a(1)=( R +qR)*std::sin( the +qthe);
               a(2)= double(bR0-iR0)*dz +qz;
               if( j==1 ){
                  R0[iR0].xn=( trans +rot*a);
               }else{
                  R0[iR0].xc=( trans +rot*a);
               }
            }
            sgnx=-sgnx;
         }
      }else if( bR0>(aR0+ 1) ){
//
//
// loop segments bb and sc site coords
//
         {
            double R= (5.00);
            double dz= ( 2.70);
            double Sbet= dz/(3.);
            double Cbet= std::sqrt( (1.00) -Sbet*Sbet);
            double dthe= (3.)*Cbet/R;
//
            Rotation_Matrix rot;
            Coordinates trans;
            {
               Coordinates u=( xcor -R0[bR0].xca);
               Coordinates z=-R0[bR0].nca;
               Coordinates x=cross(z,u);
               double rr= x.rr();
               if( rr<( 1.00e-10) ){
                  out.FILE3<<"LOOP GEN FAILURE\n";
                  return true;
               }
               double r= std::sqrt( rr);
               x/=r;
               Coordinates y=cross(z,x);
               for(int i=0;i<3;i++){
                  rot(i,0)= x(i);
                  rot(i,1)= y(i);
                  rot(i,2)= z(i);
               }
               trans=( R0[bR0].xca -R*x);
            }
            double sgnx= (-1.00)*(R0[bR0].del
                       /std::abs( R0[bR0].del));
            for(int iR0=(bR0- 1);iR0>aR0;iR0--){
               double fa= std::pow( double(iR0-aR0), 2);
               double fb= std::pow( double(bR0-iR0), 2);
               double f= fa/( fa +fb);
               double the=( double(bR0-iR0)*dthe);
               double Cthe= std::cos( the);
               double Sthe= std::sin( the);
               Coordinates a,b;
               a(0)=( R +sgnx*(1.16619))*Cthe;
               a(1)=( R +sgnx*(1.16619))*Sthe;
               a(2)= double(bR0-iR0)*dz;
               b(0)=( R +sgnx*(3.41619))*Cthe;
               b(1)=( R +sgnx*(3.41619))*Sthe;
               b(2)= a(2);
               R0[iR0].xca=f*( trans +rot*a);
               R0[iR0].xsc=f*( trans +rot*b);
               sgnx=-sgnx;
            }
            {
               Coordinates u=( xcor -R0[aR0].xca);
               Coordinates z=R0[aR0].nca;
               Coordinates x=cross(z,u);
               double rr= x.rr();
               if( rr<( 1.00e-10) ){
                  out.FILE3<<"LOOP GEN FAILURE\n";
                  return true;
               }
               double r= std::sqrt( rr);
               x/=r;
               Coordinates y=cross(z,x);
               for(int i=0;i<3;i++){
                  rot(i,0)= x(i);
                  rot(i,1)= y(i);
                  rot(i,2)= z(i);
               }
               trans=( R0[aR0].xca -R*x);
            }
            sgnx= (-1.00)*(R0[aR0].del
                /std::abs( R0[aR0].del));
            for(int iR0=(aR0+ 1);iR0<bR0;iR0++){
               double fa= std::pow( double(iR0-aR0), 2);
               double fb= std::pow( double(bR0-iR0), 2);
               double f= fb/( fa +fb);
               double the=( double(iR0-aR0)*dthe);
               double Cthe= std::cos( the);
               double Sthe= std::sin( the);
               Coordinates a,b;
               a(0)=( R +sgnx*(1.16619))*Cthe;
               a(1)=( R +sgnx*(1.16619))*Sthe;
               a(2)= double(iR0-aR0)*dz;
               b(0)=( R +sgnx*(3.41619))*Cthe;
               b(1)=( R +sgnx*(3.41619))*Sthe;
               b(2)= a(2);
               R0[iR0].xca+=f*( trans +rot*a);
               R0[iR0].xsc+=f*( trans +rot*b);
               sgnx=-sgnx;
            }
         }
         {
            Regularization_Target reg;
//
//
// add target function elements for heavy atom positions
//
            reg.nA1=0;
            for(int iR0=aR0;iR0<=bR0;iR0++){
               reg.A1.push_back( Regularization_Target::tA1());
               reg.A1[reg.nA1].y= R0[iR0].xca;
               reg.A1[reg.nA1].x= R0[iR0].xca;
               reg.A1[reg.nA1].U2=-1;
               reg.nA1++;
            }
//
//
// add target function elements from z-matrix
//
            reg.nA2= 0;
            reg.nA3= 0;
            reg.nA4= 0;
            for(int iA1= 1;iA1<reg.nA1;iA1++){
               reg.A2.push_back( Regularization_Target::tA2());
               reg.o_A2N2A1.push_back( iA1   );
               reg.o_A2N2A1.push_back( iA1- 1);
               reg.A2[reg.nA2++].dst= (3.80);
            }
            for(int iA1= 2;iA1<reg.nA1;iA1++){
               reg.A3.push_back( Regularization_Target::tA3());
               reg.o_A3N3A1.push_back( iA1   );
               reg.o_A3N3A1.push_back( iA1- 1);
               reg.o_A3N3A1.push_back( iA1- 2);
               reg.A3[reg.nA3++].lam= ( 110.00);
            }
            for(int iA1= 3;iA1<reg.nA1;iA1++){
               reg.A4.push_back( Regularization_Target::tA4());
               reg.o_A4N4A1.push_back( iA1   );
               reg.o_A4N4A1.push_back( iA1- 1);
               reg.o_A4N4A1.push_back( iA1- 2);
               reg.o_A4N4A1.push_back( iA1- 3);
               reg.A4[reg.nA4++].chi= (-165.00);
            }
//
//
// harmonic coeffs
//
            reg.coa= ( 1.25e-1);
            reg.cob= ( 1.00e+2);
            reg.coc= ( 2.00e-3)/std::pow(physics_consts.RAD,2);
            reg.cod= ( 1.25e-4)/std::pow(physics_consts.RAD,2);
            reg.iK1=0;
//
            for(int i=0;i<3;i++){
               for(int j=0;j<3;j++){
                  for(int k=0;k<3;k++){
                     reg.feps(i,j,k)= (0.00);
                  }
               }
            }
            reg.feps(0,1,2)=( 1.00);
            reg.feps(0,2,1)=(-1.00);
            reg.feps(1,2,0)=( 1.00);
            reg.feps(1,0,2)=(-1.00);
            reg.feps(2,0,1)=( 1.00);
            reg.feps(2,1,0)=(-1.00);
//
//
// minimize target function
//
            int oU2=3*(bR0-aR0- 1);
            Energy_Surface5 ene(oU2);
            {
               ene.nU2= 0;
               for(int iA1= 1;iA1<(reg.nA1- 1);iA1++){
                  for(int i=0;i<3;i++){
                     ene.U2chi(ene.nU2+i)= reg.A1[iA1].x(i);
                  }
                  reg.A1[iA1].U2=ene.nU2;
                  ene.nU2+=3;
               }
            }
            int oM2=128;
            int oK1=1;
            Local_Minimization5 loc(oM2,oK1);
            {
               double z= double( ene.nU2);
               loc.BETA= std::sqrt( z)*(1.00e-02);
               loc.BMIN= std::sqrt( z)*(1.00e-06);
               loc.BMAX= std::sqrt( z)*(1.00e-01);
               loc.BDEL= (2.00e-01);
               loc.EPS1= z*std::pow( (1.00e-06), 2);
               loc.EPS2= (1.00e-02);
               loc.K1BETA( 0)= loc.BETA;
               loc.nM2=(oM2- 1);
            }
//
            loc.MOV(physics_consts,out,ene,reg);
            loc.WRT(out,ene,reg);
//
            int iU2= 0;
            for(int iA1= 1;iA1<(reg.nA1- 1);iA1++){
               for(int i=0;i<3;i++){
                  reg.A1[iA1].x(i)= ene.U2chi(iU2+i);
               }
               iU2+=3;
            }
//
//
// update structure
//
            int iA1=0;
            for(int iR0=(aR0+ 1);iR0<bR0;iR0++){
               R0[iR0].xca=reg.A1[++iA1].x;
            }
         }
         {
            double R= ( 8.75);
            double gam= physics_consts.RAD*(  33.93);
            double Cgam= std::cos( gam);
            double Sgam= std::sin( gam);
            double CCgam= Cgam*Cgam;
            double SSgam= Sgam*Sgam;
            double CSgam= Cgam*Sgam;
            double alp= physics_consts.RAD*(  17.771);
            double bb= R*R;
            double cc= (1.90)*Cgam*(1.90)*Cgam;
            CM(3,4)= bb;
            CM(4,3)= bb;
            CM(2,3)= cc;
            CM(3,2)= cc;
            CM(1,4)= (1.00);
            CM(4,1)= (1.00);
            double sgnx= (-1.00)*(R0[aR0].del
                       /std::abs( R0[aR0].del));
            for(int iR0=(aR0+ 1);iR0<bR0;iR0++){
               Rotation_Matrix rot;
               Coordinates trans;
               double dz( 0.00),dthe( 0.00);
               {
                  Coordinates a1=R0[iR0   ].xca;
                  Coordinates n0=( R0[iR0- 1].xca -a1).normalize();
                  Coordinates a0=( a1 +(3.80)*n0);
                  Coordinates n2=( R0[iR0+ 1].xca -a1).normalize();
                  Coordinates a2=( a1 +(3.80)*n2);
                  Coordinates x=((-sgnx)*( n2 +n0)).normalize();
                  Coordinates w=(sgnx*cross(n2,n0)).normalize();
                  Coordinates v=cross(w,x);
                  Coordinates y=( Cgam*v -Sgam*w);
                  Coordinates z=( Sgam*v +Cgam*w);
                  for(int i=0;i<3;i++){
                     rot(i,0)= x(i);
                     rot(i,1)= y(i);
                     rot(i,2)= z(i);
                  }
                  trans=( a1 -( R +sgnx*(1.16619))*x);
                  dz= ( .50)*dot(( a2 -a0), z);
                  double C= dot(( a2 -trans),( a0 -trans))
                           /( a2 -trans).rr();
                  dthe= ( .50)*std::acos( C);
               }
               double aa= ( R +sgnx*(1.16619))*( R +sgnx*(1.16619));
               CM(2,4)= aa;
               CM(4,2)= aa;
               for(int j=-1;j< 2;j+=2){
                  double f= double(j);
                  Coordinates dx;
                  {
                     double lam=( gam -f*sgnx*alp);
                     if( j==1 ){
                     }else{
                        lam-=physics_consts.PI;
                     }
                     dx(0)= (0.00);
                     dx(1)= ( 1.488)*std::cos( lam);
                     dx(2)= ( 1.488)*std::sin( lam);
                  }
                  Coordinates m,n;      //target plane, peptide plane
                  {
                     double pR=( R +sgnx*(1.16619)*SSgam);
                     double pthe= (-.50)*dthe*SSgam;
                     double Cpthe= std::cos( pthe);
                     double Spthe= std::sin( pthe);
                     double pz= ( .50)*dz*CCgam;
                     m(0)=-pR*pthe*Spthe;
                     m(1)= pR*pthe*Cpthe;
                     m(2)= pz;
                     m.normalize();
                     n(0)= f*sgnx*(1.16619)*SSgam;
                     n(1)= -std::sqrt( cc -(1.16619)*(1.16619))*SSgam;
                     n(2)= pz;
                     n.normalize();
                  }
                  double Cphi= dot(m,n);
                  double Sphi=-f*sgnx*std::sqrt( (1.00) -Cphi*Cphi);
                  double phi= std::atan2(Sphi,Cphi);
////         Cphi= (1.00);
////         Sphi= (0.00);
////         phi= (0.00);
                  Rotation_Matrix Q;
                  Q(0,0)= Cphi;
                  Q(1,0)= Sgam*Sphi;
                  Q(2,0)=-Cgam*Sphi;
                  Q(0,1)=-Sgam*Sphi;
                  Q(1,1)=( SSgam*Cphi +CCgam);
                  Q(2,1)=-CSgam*( Cphi -(1.));
                  Q(0,2)= Cgam*Sphi;
                  Q(1,2)=-CSgam*( Cphi -(1.));
                  Q(2,2)=( CCgam*Cphi +SSgam);
                  dx=Q*dx;
                  double xx=( dx(0)*dx(0) +dx(1)*dx(1));
                  double yy=( dx(0)*dx(0)
                                +std::pow( ( (1.90)*Cgam -f*dx(1)), 2));
                  CM(1,2)= xx;
                  CM(2,1)= xx;
                  CM(1,3)= yy;
                  CM(3,1)= yy;
                  double zz= IGO_CAYLEY_MENGER(out,( dx(0)<=(0.00) ));
                  double z= std::sqrt( zz);
                  double qR=( z -R);
                  double p;
                  double qthe( 0.00);
                  if( aa>zz ){
                     p=( aa -xx +zz)/((2.)*( R +sgnx*(1.16619)));
                     qthe= f*std::acos( p/z);
                  }else{
                     p=( aa -xx +zz)/((2.)*z);
                     qthe= f*std::acos( p/( R +sgnx*(1.16619)));
                  }
                  double qz= dx(2);
                  Coordinates a;
                  a(0)=( R +qR)*std::cos( qthe);
                  a(1)=( R +qR)*std::sin( qthe);
                  a(2)= qz;
                  if( j==1 ){
                     R0[iR0].xc=( trans +rot*a);
                  }else{
                     R0[iR0].xn=( trans +rot*a);
                  }
               }
               sgnx=-sgnx;
            }
         }
      }
//
      aR0=G7[iG7].nR0;
   }
//
//
// C-terminal segment bb and sc site coords
//
   if( aR0<(oR0- 1) ){
      double R= (5.00);
      double dz= ( 2.70);
      double Sbet= dz/(3.);
      double Cbet= std::sqrt( (1.00) -Sbet*Sbet);
      double dthe= (3.)*Cbet/R;
      Rotation_Matrix rot;
      Coordinates trans;
      {
         Coordinates u=( xcor -R0[aR0].xca);
         Coordinates z= R0[aR0].nca;
         Coordinates x=cross(z,u);
         double rr= x.rr();
         if( rr<( 1.00e-10) ){
            out.FILE3<<"LOOP GEN FAILURE\n";
            return true;
         }
         double r= std::sqrt( rr);
         x/=r;
         Coordinates y=cross(z,x);
         for(int i=0;i<3;i++){
            rot(i,0)= x(i);
            rot(i,1)= y(i);
            rot(i,2)= z(i);
         }
         trans=( R0[aR0].xca -R*x);
      }
      double sgnx= (-1.00)*(R0[aR0].del
                 /std::abs( R0[aR0].del));
      double Sgam= dz/(3.80);
      double SSgam= Sgam*Sgam;
      double Cgam= std::sqrt( (1.00) -SSgam);
      double CCgam= Cgam*Cgam;
      double CSgam= Cgam*Sgam;
      double gam= std::atan2(Sgam,Cgam);
      double alp= physics_consts.RAD*(  17.771);
      double bb= R*R;
      double cc= (1.90)*Cgam*(1.90)*Cgam;
      CM(3,4)= bb;
      CM(4,3)= bb;
      CM(2,3)= cc;
      CM(3,2)= cc;
      CM(1,4)= (1.00);
      CM(4,1)= (1.00);
//
      for(int iR0=(aR0+ 1);iR0<oR0;iR0++){
         double the=( double(iR0-aR0)*dthe);
         double Cthe= std::cos( the);
         double Sthe= std::sin( the);
         Coordinates a;
         a(0)=( R +sgnx*(1.16619))*Cthe;
         a(1)=( R +sgnx*(1.16619))*Sthe;
         a(2)= double(iR0-aR0)*dz;
         Coordinates b;
         b(0)=( R +sgnx*(3.41619))*Cthe;
         b(1)=( R +sgnx*(3.41619))*Sthe;
         b(2)= double(iR0-aR0)*dz;
         R0[iR0].xca=( trans +rot*a);
         R0[iR0].xsc=( trans +rot*b);
         double aa= ( R +sgnx*(1.16619))*( R +sgnx*(1.16619));
         CM(2,4)= aa;
         CM(4,2)= aa;
         for(int j=-1;j< 2;j+=2){
            double f= double(j);
            Coordinates dx;
            {
               double lam=( gam -f*sgnx*alp);
               if( j==1 ){
               }else{
                  lam-=physics_consts.PI;
               }
               dx(0)= (0.00);
               dx(1)= ( 1.488)*std::cos( lam);
               dx(2)= ( 1.488)*std::sin( lam);
            }
            Coordinates m,n;      //target plane, peptide plane
            {
               double pR=( R +sgnx*(1.16619)*SSgam);
               double pthe= (-.50)*dthe*SSgam;
               double Cpthe= std::cos( pthe);
               double Spthe= std::sin( pthe);
               double pz= ( .50)*dz*CCgam;
               m(0)=-pR*pthe*Spthe;
               m(1)= pR*pthe*Cpthe;
               m(2)= pz;
               m.normalize();
               n(0)= f*sgnx*(1.16619)*SSgam;
               n(1)= -std::sqrt( cc -(1.16619)*(1.16619))*SSgam;
               n(2)= pz;
               n.normalize();
            }
            double Cphi= dot(m,n);
            double Sphi=-f*sgnx*std::sqrt( (1.00) -Cphi*Cphi);
            double phi= std::atan2(Sphi,Cphi);
            Rotation_Matrix Q;
            Q(0,0)= Cphi;
            Q(1,0)= Sgam*Sphi;
            Q(2,0)=-Cgam*Sphi;
            Q(0,1)=-Sgam*Sphi;
            Q(1,1)=( SSgam*Cphi +CCgam);
            Q(2,1)=-CSgam*( Cphi -(1.));
            Q(0,2)= Cgam*Sphi;
            Q(1,2)=-CSgam*( Cphi -(1.));
            Q(2,2)=( CCgam*Cphi +SSgam);
            dx=Q*dx;
            double xx=( dx(0)*dx(0) +dx(1)*dx(1));
            double yy=( dx(0)*dx(0)
                       +std::pow( ( (1.90)*Cgam -f*dx(1)), 2));
            CM(1,2)= xx;
            CM(2,1)= xx;
            CM(1,3)= yy;
            CM(3,1)= yy;
            double zz= IGO_CAYLEY_MENGER(out,( dx(0)<=(0.00) ));
            double z= std::sqrt( zz);
            double qR=( z -R);
            double p;
            double qthe( 0.00);
            if( aa>zz ){
               p=( aa -xx +zz)/((2.)*( R +sgnx*(1.16619)));
               qthe= f*std::acos( p/z);
            }else{
               p=( aa -xx +zz)/((2.)*z);
               qthe= f*std::acos( p/( R +sgnx*(1.16619)));
            }
            double qz= dx(2);
            a(0)=( R +qR)*std::cos( the +qthe);
            a(1)=( R +qR)*std::sin( the +qthe);
            a(2)= double(iR0-aR0)*dz +qz;
            if( j==1 ){
               R0[iR0].xc=( trans +rot*a);
            }else{
               R0[iR0].xn=( trans +rot*a);
            }
         }
         sgnx=-sgnx;
      }
   }
   return false;
}
