#include "../igo/Igor_Model.hh"
#include <cmath>

class MEM_igo_3traj_b {
public:
   std::vector<int> o_E8aR0;    //1st residue of strand
   std::vector<int> o_E8bR0;    //last
   std::vector<double> o_F8e;   //
   std::vector<int> o_E9aR0;    //1st residue of helix
   std::vector<int> o_E9bR0;    //last
   std::vector<double> o_F9e;   //
   MEM_igo_3traj_b(){
   }
   int& E8aR0(int i){
      return o_E8aR0.at( i);  }
   int& E8bR0(int i){
      return o_E8bR0.at( i);  }
   double& F8e(int i){
      return o_F8e.at( i);  }
   int& E9aR0(int i){
      return o_E9aR0.at( i);  }
   int& E9bR0(int i){
      return o_E9bR0.at( i);  }
   double& F9e(int i){
      return o_F9e.at( i);  }
};

void Igor_Model::IGO_3TRAJ_B(){
//
//
// initiate backup of sheet configs
//
   MEM_igo_3traj_b vv;
   oE8=0;
   bool INBETA=false;
   int aR0=-1;
   int bR0=-1;
   for(int iR0= 0;iR0<oR0;iR0++){
      if( INBETA ){
         if( R0[iR0].C70==2 ){
         }else{
            INBETA=false;
            bR0=(iR0- 1);
            if( bR0>aR0 ){
               oE8++;
               vv.o_E8aR0.push_back( aR0);
               vv.o_E8bR0.push_back( bR0);
            }
         }
      }else{
         if( R0[iR0].C70==2 ){
            INBETA=true;
            aR0=iR0;
         }else{
         }
      }
   }
   if( INBETA ){
      INBETA=false;
      bR0=(oR0- 1);
      if( bR0>aR0 ){
         oE8++;
         vv.o_E8aR0.push_back( aR0);
         vv.o_E8bR0.push_back( bR0);
      }
   }
   if( oE8> 0 ){
      nF8=(25/oE8);
      if( nF8> 8 )nF8= 8;
      oF8=int( std::pow( 2,nF8));
      vv.o_F8e.resize(oF8);
      o_E8F8rr.clear();
      o_E8F8rr.resize(oE8*oF8, -1);
      for(int iE8= 0;iE8<oE8;iE8++){
         int iR0min=(vv.E8aR0(iE8   )- 8);
         int iR0max=(vv.E8bR0(iE8   )   );
         if( iE8> 0 ){
            if( iR0min<(vv.E8bR0(iE8-1)+1) )iR0min=(vv.E8bR0(iE8-1)+1);
         }else{
            if( iR0min< 0 )iR0min= 0;
         }
         int jR0min=(vv.E8aR0(iE8   )   );
         int jR0max=(vv.E8bR0(iE8   )+ 8);
         if( iE8<(oE8-1) ){
            if( jR0max>(vv.E8aR0(iE8+1)-1) )jR0max=(vv.E8aR0(iE8+1)-1);
         }else{
            if( jR0max>(oR0-1) )jR0max=(oR0-1);
         }
         int jF8=0;
         for(int iR0=iR0min;iR0<=iR0max;iR0++){
            for(int jR0=jR0min;jR0<=jR0max;jR0++){
               if( jR0<=iR0 )continue;
               double e= (0.00);
               for(int pR0=iR0;pR0<=jR0;pR0++){
                  e+=std::log( R0[pR0].C7p0( 2) +(1.e-32));
               }
               e/=double(jR0-iR0+1);
               double p= std::exp( e);
               if( p<( .05) )continue;
               if( jF8<(oF8-1) ){
                  jF8++;
               }else{
                  if( e<=vv.F8e(jF8) )continue;
               }
               vv.F8e(jF8)= e;
               E8F8rr(iE8,jF8)=( iR0*oR0 +jR0);
//
//
// maintain order
//
               for(int iF8=jF8;iF8> 1;iF8--){
                  if( vv.F8e(iF8   )<=vv.F8e(iF8- 1) )continue;
                  double z= vv.F8e(iF8- 1);
                  vv.F8e(iF8- 1)= vv.F8e(iF8   );
                  vv.F8e(iF8   )= z;
                  int j=E8F8rr(iE8,iF8- 1);
                  E8F8rr(iE8,iF8- 1)=E8F8rr(iE8,iF8   );
                  E8F8rr(iE8,iF8   )=j;
               }
            }
         }
         for(int iF8= 1;iF8<=jF8;iF8++){
            int iR0=(E8F8rr(iE8,iF8)/oR0);
            int jR0=(E8F8rr(iE8,iF8)%oR0);
            R0R0ef(iR0,jR0)=( iE8*oF8 +iF8);
         }
      }
      oQ8=0;
      o_E8F8Q8.clear();
      o_E8F8Q8.resize(33554432, -1);
   }
   oE9=0;
   bool INALPHA=false;
   aR0=-1;
   bR0=-1;
   for(int iR0= 0;iR0<oR0;iR0++){
      if( INALPHA ){
         if( R0[iR0].C70==1 ){
         }else{
            INALPHA=false;
            bR0=(iR0- 1);
            if( bR0>(aR0+ 2) ){
               oE9++;
               vv.o_E9aR0.push_back( aR0);
               vv.o_E9bR0.push_back( bR0);
            }
         }
      }else{
         if( R0[iR0].C70==1 ){
            INALPHA=true;
            aR0=iR0;
         }else{
         }
      }
   }
   if( INALPHA ){
      INALPHA=false;
      bR0=(oR0- 1);
      if( bR0>(aR0+ 2) ){
         oE9++;
         vv.o_E9aR0.push_back( aR0);
         vv.o_E9bR0.push_back( bR0);
      }
   }
   if( oE9> 0 ){
      nF9=(25/oE9);
      if( nF9> 8 )nF9= 8;
      oF9=int( std::pow( 2,nF9));
      vv.o_F9e.resize(oF9);
      o_E9F9rr.clear();
      o_E9F9rr.resize(oE9*oF9, -1);
      for(int iE9= 0;iE9<oE9;iE9++){
         int iR0min=(vv.E9aR0(iE9   )- 8);
         int iR0max=(vv.E9bR0(iE9   )   );
         if( iE9> 0 ){
            if( iR0min<(vv.E9bR0(iE9-1)+1) )iR0min=(vv.E9bR0(iE9-1)+1);
         }else{
            if( iR0min< 0 )iR0min= 0;
         }
         int jR0min=(vv.E9aR0(iE9   )   );
         int jR0max=(vv.E9bR0(iE9   )+ 8);
         if( iE9<(oE9-1) ){
            if( jR0max>(vv.E9aR0(iE9+1)-1) )jR0max=(vv.E9aR0(iE9+1)-1);
         }else{
            if( jR0max>(oR0-1) )jR0max=(oR0-1);
         }
         int jF9=0;
         for(int iR0=iR0min;iR0<=iR0max;iR0++){
            for(int jR0=jR0min;jR0<=jR0max;jR0++){
               if( jR0<=(iR0+2) )continue;
               double e= (0.00);
               for(int pR0=iR0;pR0<=jR0;pR0++){
                  e+=std::log( R0[pR0].C7p0( 1) +(1.e-32));
               }
               e/=double(jR0-iR0+1);
               double p= std::exp( e);
               if( p<( .05) )continue;
               if( jF9<(oF9-1) ){
                  jF9++;
               }else{
                  if( e<=vv.F9e(jF9) )continue;
               }
               vv.F9e(jF9)= e;
               E9F9rr(iE9,jF9)=( iR0*oR0 +jR0);
//
//
// maintain order
//
               for(int iF9=jF9;iF9> 1;iF9--){
                  if( vv.F9e(iF9   )<=vv.F9e(iF9- 1) )continue;
                  double z= vv.F9e(iF9- 1);
                  vv.F9e(iF9- 1)= vv.F9e(iF9   );
                  vv.F9e(iF9   )= z;
                  int j=E9F9rr(iE9,iF9- 1);
                  E9F9rr(iE9,iF9- 1)=E9F9rr(iE9,iF9   );
                  E9F9rr(iE9,iF9   )=j;
               }
            }
         }
         for(int iF9= 1;iF9<=jF9;iF9++){
            int iR0=(E9F9rr(iE9,iF9)/oR0);
            int jR0=(E9F9rr(iE9,iF9)%oR0);
            R0R0hf(iR0,jR0)=( iE9*oF9 +iF9);
         }
      }
      oQ9=0;
      o_E9F9Q9.clear();
      o_E9F9Q9.resize(33554432, -1);
   }
   return;
}
