#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <set>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_igo_3traj {
private:
   std::vector<double> o_w;             //distribution measure
   std::vector<int> o_XZ9;              //inverse map of Z9X
   std::vector<int> o_R0C7;             //state stabilized by patch crosslinks
   std::vector<double> o_R0C7o;         //p of high pack score config
   std::vector<double> o_R0C7p;         //p smoothed
   std::vector<double> o_R0e;           //e of pack config resolved wrt res
   std::vector<double> o_R0C7e;         //e update
   std::vector<double> o_R0z;           //e of res ising model resolved wrt res
   std::vector<int> o_K7inv;            //inverse mapping
   std::vector<int> o_K7I3a;            //start index of confs within threshold
   std::vector<int> o_K7cI3;            //number of confs within threshold
   std::vector<int> o_K7I3b;            //start index of higher neighbor confs
   std::vector<int> o_K7dI3;            //number of lower neighbor confs
public:
   std::vector<int> o_I3K7;             //mapping to index of neighbor conf
   std::vector<Structure> o_K7pck;      //backbone structure of pack config
   MEM_igo_3traj(int r,int k):
      o_w( 7),
      o_XZ9(12),
      o_R0C7(r, 0),
      o_R0C7o(r*3),
      o_R0C7p(r*3),
      o_R0e(r),
      o_R0C7e(r*3),
      o_R0z(r),
      o_K7inv(k),
      o_K7I3a( k,-1),
      o_K7cI3( k, 0),
      o_K7I3b( k,-1),
      o_K7dI3( k, 0)
   {
      w(-3)= ( .04);
      w(-2)= ( .12);
      w(-1)= ( .20);
      w( 0)= ( .28);
      w( 1)= ( .20);
      w( 2)= ( .12);
      w( 3)= ( .04);
   }
   double& w(int i){
      return o_w.at( i+3);  }
   int& XZ9(int i){
      return o_XZ9.at( i);  }
   int& R0C7(int i){
      return o_R0C7.at( i);  }
   double& R0C7o(int i,int a){
      return o_R0C7o.at( i*3 +(a-1));  }
   double& R0C7p(int i,int a){
      return o_R0C7p.at( i*3 +(a-1));  }
   double& R0e(int i){
      return o_R0e.at( i);  }
   double& R0C7e(int i,int a){
      return o_R0C7e.at( i*3 +(a-1));  }
   double& R0z(int i){
      return o_R0z.at( i);  }
   int& K7inv(int i){
      return o_K7inv.at( i);  }
   int& K7I3a(int i){
      return o_K7I3a.at( i);  }
   int& K7cI3(int i){
      return o_K7cI3.at( i);  }
   int& K7I3b(int i){
      return o_K7I3b.at( i);  }
   int& K7dI3(int i){
      return o_K7dI3.at( i);  }
   int& I3K7(int i){
      return o_I3K7.at( i);  }
   Structure& K7pck(int i){
      return o_K7pck.at( i);  }
};

void Igor_Model::IGO_3TRAJ(const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_IGOR_DATA& igor_data,
                           Output_Streams& out,
                           const Structure& str){
   MEM_igo_3traj vv(oR0,oK7);
   int oC7=igor_data.oC7;
   std::set<Composition> B9;
   NATIVE=false;
//
//
// initiate backup of sheet configs and helix pack configs
//
   IGO_3TRAJ_B();
   if( out.VERBOSE ){
      out.FILE3<<"CALC PACKING SCORE"
                 " FOR HIGH SCORE CHAIN STATES\n";
   }
//
//
// initiate density for SCORE3b +SCORE3c (free energy of patch crosslinks)
//
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int iC7= 1;iC7<oC7;iC7++){
         R0[iR0].C7bo(iC7)= (0.00);
         R0[iR0].C7K7(iC7)=-1;
         R0[iR0].C7eo(iC7)= (0.00);
         R0[iR0].C7zo(iC7)= (0.00);
      }
   }
//
//
// calc SCORE3 over high SCORE chain states
//
// zSCORE= (-1.00e+6);
   for(int iK7= 0;iK7<oK7;iK7++){
//
//
// disallow consecutive elem states
//
      bool DISALLOW=false;
      for(int iG7= 1;iG7<K7[iK7].oG7&&(!DISALLOW);iG7++){
         int iC7=K7[iK7].G7[iG7   ].C7;
         int jC7=K7[iK7].G7[iG7- 1].C7;
         if      ( iC7==1 ){
            if      ( jC7==1 ){
               DISALLOW=true;
            }else if( jC7==2 ){
               DISALLOW=true;
            }else if( jC7==3 ){
            }
         }else if( iC7==2 ){
            if      ( jC7==1 ){
               DISALLOW=true;
            }else if( jC7==2 ){
               DISALLOW=true;
            }else if( jC7==3 ){
            }
         }else if( iC7==3 ){
            if      ( jC7==1 ){
            }else if( jC7==2 ){
            }else if( jC7==3 ){
               DISALLOW=true;
            }
         }
      }
      if( DISALLOW )continue;
//
      SCORE0= K7[iK7].e[ 1];
      SCORE1= K7[iK7].e[ 2];
      SCORE1b= K7[iK7].e[ 3];
      SCORE2= K7[iK7].e[ 4];
      SCORE2b= K7[iK7].e[ 5];
      oG7=K7[iK7].oG7;
      for(int iG7= 0;iG7<oG7;iG7++){
         int mR0=K7[iK7].G7[iG7].mR0;
         int nR0=K7[iK7].G7[iG7].nR0;
         int iC7=K7[iK7].G7[iG7].C7;
	 if( ((nR0-mR0+ 1)< 6)&&(iC7==1) ){
            iC7=2;
	 }
         G7[iG7].mR0=mR0;
         G7[iG7].nR0=nR0;
         G7[iG7].T7=K7[iK7].G7[iG7].T7;
         G7[iG7].C70=iC7;
      }
//
      IGO_SCO3(physics_consts,array_consts,igor_data,
               out);
      SCORE=( SCORE0  +SCORE1  +SCORE1b +SCORE2  +SCORE2b
             +SCORE3  +SCORE3b +SCORE3c);
      {
         Composition comp(oG7,G7);
         if( !B9.insert(comp).second )continue;
      }
//    std::cout<<std::setw( 4)<<iK7
//             <<std::fixed<<std::setprecision( 2)
//             <<" SCO3="<<std::setw( 8)<<SCORE3
//             <<" SCO3b="<<std::setw( 8)<<SCORE3b
//             <<" SCO3c="<<std::setw( 8)<<SCORE3c
//             <<' ';
//    for(int iG7= 0;iG7<oG7;iG7++){
//       std::cout<<std::setw( 3)<<G7[iG7].nR0;
//    }
//    std::cout<< std::endl;
//
//
// patch chain state with pack energy and config
//
      if( SCORE>K7[iK7].e[ 0] ){
         K7[iK7].e[ 0]= SCORE;
         K7[iK7].e[ 6]= SCORE3;
         K7[iK7].e[ 7]= SCORE3b;
         K7[iK7].e[ 8]= SCORE3c;
         for(int iG7= 0;iG7<oG7;iG7++){
            K7[iK7].G7[iG7].C7=G7[iG7].C70;
         }
         if( oT9> 0 ){
            K7[iK7].PACK=true;
            K7[iK7].e3= (0.00);
            IGO_3TRAJ_X(physics_consts,out);
            for(int iR0= 0;iR0<oR0;iR0++){
               K7[iK7].R0[iR0].xca=R0[iR0].xca;
               K7[iK7].R0[iR0].xn=R0[iR0].xn;
               K7[iK7].R0[iR0].xc=R0[iR0].xc;
               K7[iK7].R0[iR0].xsc=R0[iR0].xsc;
            }
         }
      }else{
         K7[iK7].e[ 6]= (0.00);
         K7[iK7].e[ 7]= (0.00);
         K7[iK7].e[ 8]= (0.00);
      }
//
//
// stabilization of ss elems by patch contacts
//
      if( K7[iK7].PACK ){
         for(int iT9= 0;iT9<oT9;iT9++){
            if( !T9[iT9].sub )continue;
            int iU9=T9[iT9].U9;
            int iY9=T9[iT9].Y9;
//
//
// core of high pack score config
//
            int oZ9=iU9;
            for(int iZ9= 0;iZ9<oZ9;iZ9++){
               vv.XZ9(U9[iU9].Y9[iY9].Z9[iZ9].X)=iZ9;
            }
            for(int iZ9= 0;iZ9<oZ9;iZ9++){
               int iS9=U9[iU9].Y9[iY9].Z9[iZ9].S9;
               int iX=U9[iU9].Y9[iY9].Z9[iZ9].X;
               if( iX> 0 ){
                  int jZ9=vv.XZ9(iX- 1);
                  int iB4=(U9[iU9].Y9[iY9].Z9[jZ9].B/256);
                  int iW4=M9[ 0].S9[iS9].B4[iB4].W4;
                  int iC7=( W4[iW4].O1< 4 )? 1: 2;
                  int oK4=W4[iW4].oK4;
                  for(int iK4= 0;iK4<oK4;iK4++){
                     int iG7=W4[iW4].K4[iK4].G7;
                     int mR0=G7[iG7].mR0;
                     int nR0=G7[iG7].nR0;
                     int bR0=(mR0- 1);
                     int aR0=(nR0+ 1);
                     int oJ4=W4[iW4].oJ4;
                     for(int iJ4= 0;iJ4<oJ4;iJ4++){
                        int iR0=W4[iW4].J4[iJ4].R0;
                        if( (iR0>=mR0)&&(iR0<=nR0) ){
                           if( iR0>bR0 )bR0=iR0;
                           if( iR0<aR0 )aR0=iR0;
                           vv.R0C7(iR0)|=4;
                        }
                     }
                     if( bR0>=aR0 ){
                        for(int iR0=aR0;iR0<=bR0;iR0++){
                           vv.R0C7(iR0)|=( iC7 +32*iZ9);
                        }
                     }
                  }
               }
               if( iX<(oZ9- 1) ){
                  int jZ9=vv.XZ9(iX+ 1);
                  int jB4=(U9[iU9].Y9[iY9].Z9[jZ9].A/256);
                  int iW4=M9[ 0].S9[iS9].B4[jB4].W4;
                  int iC7=( W4[iW4].O1< 4 )? 1: 2;
                  int oK4=W4[iW4].oK4;
                  for(int iK4= 0;iK4<oK4;iK4++){
                     int iG7=W4[iW4].K4[iK4].G7;
                     int mR0=G7[iG7].mR0;
                     int nR0=G7[iG7].nR0;
                     int bR0=(mR0- 1);
                     int aR0=(nR0+ 1);
                     int oJ4=W4[iW4].oJ4;
                     for(int iJ4= 0;iJ4<oJ4;iJ4++){
                        int iR0=W4[iW4].J4[iJ4].R0;
                        if( (iR0>=mR0)&&(iR0<=nR0) ){
                           if( iR0>bR0 )bR0=iR0;
                           if( iR0<aR0 )aR0=iR0;
                           vv.R0C7(iR0)|=4;
                        }
                     }
                     if( bR0>=aR0 ){
                        for(int iR0=aR0;iR0<=bR0;iR0++){
                           vv.R0C7(iR0)|=( iC7 +32*iZ9);
                        }
                     }
                  }
               }
            }
            for(int iR0= 0;iR0<oR0;iR0++){
               if( vv.R0C7(iR0)> 0 ){
                  K7[iK7].R0[iR0].b=true;
               }else{
                  K7[iK7].R0[iR0].b=false;
               }
            }
            for(int iR0= 0;iR0<oR0;iR0++){
               if( K7[iK7].R0[iR0].b )continue;
               int aR0=(iR0- 4);
               if( aR0< 0 )aR0= 0;
               int bR0=(iR0+ 5);
               if( bR0>oR0 )bR0=oR0;
               for(int jR0=aR0;jR0<bR0;jR0++){
                  if( jR0==iR0 )continue;
                  if( K7[iK7].R0[jR0].b ){
                     vv.R0C7(iR0)|=3;
                     if( jR0<iR0 ){
                        vv.R0C7(iR0)|=16;
                     }else{
                        vv.R0C7(iR0)|=8;
                     }
                  }
               }
            }
//
//
// prob profile for core of high pack score config
//
            for(int iR0= 0;iR0<oR0;iR0++){
               int iC7=(vv.R0C7(iR0)%4);
               if      ( iC7==0 ){
                  vv.R0C7o(iR0, 1)= ( .320);
                  vv.R0C7o(iR0, 2)= ( .320);
                  vv.R0C7o(iR0, 3)= ( .360);
               }else if( iC7==3 ){
                  vv.R0C7o(iR0, 1)= ( .125);
                  vv.R0C7o(iR0, 2)= ( .125);
                  vv.R0C7o(iR0, 3)= ( .750);
               }else{
                  for(int jC7= 1;jC7<oC7;jC7++){
                     vv.R0C7o(iR0,jC7)= ( .050);
                  }
                  vv.R0C7o(iR0,iC7)= ( .900);
               }
            }
            for(int iR0= 0;iR0<oR0;iR0++){
               int iC7=(vv.R0C7(iR0)%4);
               if( iC7==0 )continue;
               if( K7[iK7].R0[iR0].b ){
                  for(int jC7= 1;jC7<oC7;jC7++){
                     vv.R0C7p(iR0,jC7)= vv.R0C7o(iR0,jC7);
                  }
               }else{
                  for(int jC7= 1;jC7<oC7;jC7++){
                     vv.R0C7p(iR0,jC7)= (0.00);
                  }
                  int aR0=(iR0- 3);
                  if( aR0< 0 )aR0= 0;
                  int bR0=(iR0+ 4);
                  if( bR0>oR0 )bR0=oR0;
                  double z= (0.00);
                  for(int jR0=aR0;jR0<bR0;jR0++){
                     for(int jC7= 1;jC7<oC7;jC7++){
                        vv.R0C7p(iR0,jC7)+=(vv.w(jR0-iR0)
                                           *vv.R0C7o(jR0,jC7));
                     }
                     z+=vv.w(jR0-iR0);
                  }
                  for(int jC7= 1;jC7<oC7;jC7++){
                     vv.R0C7p(iR0,jC7)/=z;
                  }
               }
            }
//
//
// free energy (E-TS) of patch crosslinks
//
            double e3= (1.00)*( ( .35)*T9[iT9].e[ 1]
                               +( .65)*T9[iT9].e[ 2]
                               +( .25)*T9[iT9].e[ 3]
                               -( .04)*double( oR0));
            if( e3<( 0.00) ){
               for(int iR0= 0;iR0<oR0;iR0++){
                  vv.R0C7(iR0)=0;
               }
               continue;
            }else{
               if( iT9==0 ){
                  K7[iK7].e3= e3;
               }
            }
            for(int iR0= 0;iR0<oR0;iR0++){
               vv.R0e(iR0)= (0.00);
            }
            int nc=0;
            int nj=0;
            for(int iR0= 0;iR0<oR0;iR0++){
               int iC7=(vv.R0C7(iR0)%4);
               if( iC7==0 )continue;
               if( iC7==3 ){
                  nc++;
                  int j=(vv.R0C7(iR0)/8);
                  if( j==3 ){
                     nc++;
                  }
               }else{
                  nj++;
               }
            }
            double de= e3/( ( .35)*double( nc) +( .65)*double( nj));
            for(int iR0= 0;iR0<oR0;iR0++){
               int iC7=(vv.R0C7(iR0)%4);
               if( iC7==0 )continue;
               if( iC7==3 ){
                  vv.R0e(iR0)= ( .35)*de;
                  int j=(vv.R0C7(iR0)/8);
                  if( j==3 ){
                     vv.R0e(iR0)+=( .35)*de;
                  }
               }else{
                  vv.R0e(iR0)= ( .65)*de;
               }
            }
//
//
// update to 1-bod res impulses
//
            for(int iR0= 0;iR0<oR0;iR0++){
               int iC7=(vv.R0C7(iR0)%4);
               if( iC7==0 )continue;
               for(int jC7= 1;jC7<oC7;jC7++){
                  double x= R0[iR0].C7p0(jC7);
                  if( x<( .05) )x= ( .05);
                  if( x>( .90) )x= ( .90);
                  double y= vv.R0C7p(iR0,jC7);
                  double p= ((x*y)/( x*y +( (1.00) -x)*x));
                  vv.R0C7e(iR0,jC7)= std::log( p/x);
////                  vv.R0C7e(iR0,jC7)= std::log( y/x);
               }
            }
//
//
// energy of observed path in res ising model
//
            for(int iR0= 0;iR0<oR0;iR0++){
               int iC7=(vv.R0C7(iR0)%4);
               if( iC7==0 )continue;
               double gi= vv.R0C7e(iR0,iC7);
               double zj= (0.00);
               for(int jC7= 1;jC7<oC7;jC7++){
                  if( jC7==iC7 )continue;
                  zj+=std::exp( vv.R0C7e(iR0,jC7));
               }
               double gj= std::log( zj);
               vv.R0z(iR0)= ( .05)*std::abs( gi -gj);
            }
//
//
// maintain largest score R0[].C7bo and associated index R0[].C7K7
//
            for(int iR0= 0;iR0<oR0;iR0++){
               int iC7=(vv.R0C7(iR0)%4);
               if( iC7==0 )continue;
               double bo=( vv.R0e(iR0) +vv.R0z(iR0));
               if( bo>R0[iR0].C7bo(iC7) ){
                  R0[iR0].C7bo(iC7)= bo;
                  R0[iR0].C7K7(iC7)=iK7;
                  R0[iR0].C7eo(iC7)= vv.R0e(iR0);
                  R0[iR0].C7zo(iC7)= vv.R0z(iR0);
               }
               vv.R0C7(iR0)=0;
            }
//
         }
      }
//
//
// backup fold with highest score
//
      if( SCORE>zSCORE ){
         zSCORE= SCORE;
         zSCORE0= SCORE0;
         zSCORE1= SCORE1;
         zSCORE1b= SCORE1b;
         zSCORE2= SCORE2;
         zSCORE2b= SCORE2b;
         zSCORE3= SCORE3;
         zSCORE3b= SCORE3b;
         zSCORE3c= SCORE3c;
// chain state
         zoG7=oG7;
         if( int(zG7.size())!=oG7 ){
            zG7.clear();
            zG7.resize(oG7);
         }
         for(int iG7= 0;iG7<oG7;iG7++){
            zG7[iG7]=G7[iG7];
            int mR0=G7[iG7].mR0;
            int nR0=G7[iG7].nR0;
            for(int iR0=mR0;iR0<=nR0;iR0++){
               R0[iR0].C7z=( 10*iG7 +G7[iG7].C70);
            }
         }
// hydrophob patches
         zoW4=oW4;
         if( int(zW4.size())!=oW4 ){
            zW4.clear();
            zW4.resize(oW4);
         }
         for(int iW4= 0;iW4<oW4;iW4++){
            zW4[iW4]=W4[iW4];
         }
// sheet config
         zoM8=oM8;
         if( int(zM8.size())!=oM8 ){
            zM8.clear();
            zM8.resize(oM8);
         }
         for(int iM8= 0;iM8<oM8;iM8++){
            zM8[iM8]=M8[iM8];
         }
         zoU8=oU8;
         if( int(zU8.size())!=oU8 ){
            zU8.clear();
            zU8.resize(oU8);
         }
         for(int iU8= 0;iU8<oU8;iU8++){
            zU8[iU8]=U8[iU8];
         }
         zoT8=oT8;
         if( int(zT8.size())!=oT8 ){
            zT8.clear();
            zT8.resize(oT8);
         }
         for(int iT8= 0;iT8<oT8;iT8++){
            zT8[iT8]=T8[iT8];
         }
         zoV8=oV8;
         if( int(zV8.size())!=oV8 ){
            zV8.clear();
            zV8.resize(oV8);
         }
         for(int iV8= 0;iV8<oV8;iV8++){
            zV8[iV8]=V8[iV8];
         }
// fold
         zoM9=oM9;
         if( int(zM9.size())!=oM9 ){
            zM9.clear();
            zM9.resize(oM9);
         }
         for(int iM9= 0;iM9<oM9;iM9++){
            zM9[iM9]=M9[iM9];
         }
         zoU9=oU9;
         if( int(zU9.size())!=oU9 ){
            zU9.clear();
            zU9.resize(oU9);
         }
         for(int iU9= 0;iU9<oU9;iU9++){
            zU9[iU9]=U9[iU9];
         }
         zoT9=oT9;
         if( int(zT9.size())!=oT9 ){
            zT9.clear();
            zT9.resize(oT9);
         }
         for(int iT9= 0;iT9<oT9;iT9++){
            zT9[iT9]=T9[iT9];
         }
      }
   }
//
//
// subset of K7 st pack of path contributes max stabilty to some residues
//
   for(int iK7= 0;iK7<oK7;iK7++){
      K7[iK7].b=false;
      K7[iK7].K7ord=iK7;
   }
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int iC7= 1;iC7<oC7;iC7++){
         int iK7=R0[iR0].C7K7(iC7);
         if( iK7>-1 ){
            K7[iK7].b=true;
         }
      }
   }
//
//
// maintain ordered set of compositions
//
   tK7 t;
   t.oR0=oR0;
   t.R0.resize(oR0);
   for(int jK7max=(oK7-1);jK7max> 0;jK7max--){
      bool ORDERED=true;
      double e1= K7[ 0].e[ 0];
      for(int jK7= 1;jK7<=jK7max;jK7++){
         double e2= K7[jK7].e[ 0];
         if( e2>e1 ){
            t=K7[jK7-1];
            K7[jK7-1]=K7[jK7  ];
            K7[jK7  ]=t;
            ORDERED=false;
         }else{
            e1=e2;
         }
      }
      if( ORDERED )break;
   }
   for(int iK7= 0;iK7<oK7;iK7++){
      vv.K7inv(K7[iK7].K7ord)=iK7;
   }
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int iC7= 1;iC7<oC7;iC7++){
         int iK7=R0[iR0].C7K7(iC7);
         if( iK7>-1 ){
            R0[iR0].C7K7(iC7)=vv.K7inv(iK7);
         }
      }
   }
//
//
// diagnostic output
//
   if( out.VERBOSE ){
      out.FILE3<<"________\n";
      out.FILE3<<"HIGH SCORE (0123) CHAIN STATES[pass="
               <<std::setw( 1)<<iFOLD<<"]\n";
      for(int iK7= 0;iK7<oK7;iK7++){
         for(int iG7= 0;iG7<K7[iK7].oG7;iG7++){
            char a1=igor_data.C7[K7[iK7].G7[iG7].C7].a1;
            int mR0=K7[iK7].G7[iG7].mR0;
            int nR0=K7[iK7].G7[iG7].nR0;
            for(int iR0=mR0;iR0<=nR0;iR0++){
               out.FILE3<<a1;
               if( ((iR0+ 1)%100==0)||(iR0==(oR0-1)) ){
                  out.FILE3<<'\n';
               }
            }
         }
         if( K7[iK7].PACK ){
            for(int iG7= 0;iG7<K7[iK7].oG7;iG7++){
               int mR0=K7[iK7].G7[iG7].mR0;
               int nR0=K7[iK7].G7[iG7].nR0;
               for(int iR0=mR0;iR0<=nR0;iR0++){
                  int iL1=R0[iR0].L1;
                  char a1=igor_data.L1[iL1].a1;
                  out.FILE3<<(( K7[iK7].R0[iR0].b )? a1: '.');
                  if( ((iR0+ 1)%100==0)||(iR0==(oR0-1)) ){
                     out.FILE3<<'\n';
                  }
               }
            }
         }
      }
      out.FILE3<<"________\n";
      out.FILE3<<"  SCORE"
               <<"  SCO0 "
               <<"  SCO1 "
               <<"  SCO1b"
               <<"  SCO2 "
               <<"  SCO2b"
               <<"  SCO3 "
               <<"  SCO3b"
               <<"  SCO3c"
               <<"[pass="<<std::setw( 1)<<iFOLD<<"]\n";
      out.FILE3<< std::fixed<<std::setprecision( 2);
      for(int iK7= 0;iK7<oK7;iK7++){
         if( K7[iK7].PACK ){
            for(int i=0;i<9;i++){
               out.FILE3<<std::setw( 7)<<K7[iK7].e[ i];
            }
            out.FILE3<<'\n';
         }else{
            for(int i=0;i<6;i++){
               out.FILE3<<std::setw( 7)<<K7[iK7].e[ i];
            }
            out.FILE3<<'\n';
         }
      }
   }
//
//
//
//
   if( iFOLD==1 ){
//
//
// cluster K7
//
      Structure pck=str;
      for(int iK7= 0;iK7<oK7;iK7++){
         if( K7[iK7].PACK ){
            for(int iR0= 0;iR0<oR0;iR0++){
               int iP1=pck.iatom(iR0," CA ");
               pck.P1[iP1].x=K7[iK7].R0[iR0].xca;
               pck.P1[iP1].sub=1;
               iP1=pck.iatom(iR0," N  ");
               pck.P1[iP1].x=K7[iK7].R0[iR0].xn;
               pck.P1[iP1].sub=1;
               iP1=pck.iatom(iR0," C  ");
               pck.P1[iP1].x=K7[iK7].R0[iR0].xc;
               pck.P1[iP1].sub=1;
            }
            vv.o_K7pck.push_back(pck);
         }else{
            vv.o_K7pck.push_back(str);
         }
      }
//
      bool bac_VERBOSE=out.VERBOSE;
      out.VERBOSE=false;
      Trajectory tra;
      int mI3=0;
      for(int iK7= 0;iK7<oK7;iK7++){
         vv.K7I3a(iK7)=mI3;
         int n=vv.K7cI3(iK7);
         for(int i=0;i<n;i++){
            vv.o_I3K7.push_back(-1);
            mI3++;
         }
         vv.K7I3b(iK7)=mI3;
         if( !K7[iK7].PACK )continue;
         if( K7[iK7].b )continue;
         tra.STR2TRA( 0,vv.K7pck(iK7));
         for(int jK7=(iK7+ 1);jK7<oK7;jK7++){
            if( !K7[jK7].PACK )continue;
            if( K7[jK7].b )continue;
            pck=vv.K7pck(jK7);
            double rmsd= pck.SUP(physics_consts,out,tra);
            if( rmsd< ( 5.00) ){
               vv.o_I3K7.push_back(jK7);
               mI3++;
               vv.K7cI3(iK7)++;
               vv.K7cI3(jK7)++;
            }
         }
      }
      out.VERBOSE=bac_VERBOSE;
//
      for(int iK7= 0;iK7<(oK7- 1);iK7++){
         if( !K7[iK7].PACK )continue;
         if( K7[iK7].b )continue;
         int iI3min=vv.K7I3b(iK7);
         int iI3max=(vv.K7I3a(iK7)-1+vv.K7cI3(iK7));
         for(int iI3=iI3min;iI3<=iI3max;iI3++){
            int jK7=vv.I3K7(iI3);
            vv.I3K7(vv.K7I3a(jK7)+vv.K7dI3(jK7))=iK7;
            vv.K7dI3(jK7)++;
         }
      }
//
      int o=0;
      for(int iK7= 0;iK7<oK7;iK7++){
         if( !K7[iK7].PACK )continue;
         bool BEST=true;
         int iI3min=vv.K7I3a(iK7);
         int iI3max=(iI3min- 1+vv.K7cI3(iK7));
         for(int iI3=iI3min;iI3<=iI3max&&( BEST);iI3++){
            int jK7=vv.I3K7(iI3);
            if( jK7<iK7 )BEST=false;
         }
         if( BEST ){
            if( o!=iK7 ){
               K7[o  ]=K7[iK7];
            }
            o++;
         }
      }
      for(int jK7=o;jK7<oK7;jK7++){
         K7.pop_back();
      }
      oK7=o;
//
//
// search neighbor compositions
//
      if( out.VERBOSE ){
         out.FILE3<<"CALC PACKING SCORE"
                    " FOR NEIGHBOR CHAIN STATES\n";
      }
      NEWGRP=true;
      bool FLAG=false;
      I7.clear();
      I7.resize( 1);
      I7[ 0].oR0=oR0;
      I7[ 0].R0.resize(oR0);
      o=( oK7>32 )? 32: oK7;
      for(int iK7=0;iK7<o;iK7++){
         I7[ 0]=K7[iK7];
         oG7=I7[ 0].oG7;
//
//
// iterate over elements
//
         for(int pG7= 0;pG7<oG7;pG7++){
            if( K7[iK7].G7[pG7].C7==3 )continue;
//
//
// iterate over neighbors of element
//
            G7jR0(-1)=-1;
            if( ( 0==pG7     )||
                ( 0==(pG7- 1)) ){
               G7jR0( 0)=(I7[ 0].G7[ 0].nR0- 3);
               if( G7jR0( 0)<-1 )G7jR0( 0)=-1;
               while( K7[iK7].R0[G7jR0( 0)+ 1].b ){
                  G7jR0( 0)++;
               }
            }else{
               G7jR0( 0)=(I7[ 0].G7[ 0].nR0- 1);
            }
            for(int iG7= 0;iG7<oG7;iG7++){
               if( (iG7==pG7     )||
                   (iG7==(pG7- 1)) ){
                  G7kR0(iG7)=(I7[ 0].G7[iG7].nR0+ 2);
                  if( G7kR0(iG7)>(oR0-oG7+iG7) )G7kR0(iG7)=(oR0-oG7+iG7);
                  while( K7[iK7].R0[G7kR0(iG7)].b ){
                     G7kR0(iG7)--;
                  }
               }else{
                  G7kR0(iG7)=I7[ 0].G7[iG7].nR0;
               }
            }
            for(int jG7= 0;;){
               G7jR0(jG7)++;
               if( G7jR0(jG7)>G7kR0(jG7) ){
                  if( jG7== 0 ){
                     break;
                  }else{
                     jG7--;
                     continue;
                  }
               }else{
                  int iR0min=(G7jR0(jG7- 1)+ 1);
                  int iR0max=G7jR0(jG7);
                  short ib=R0R0v(iR0min,iR0max);
                  G7[jG7  ].mR0=iR0min;
                  G7[jG7  ].nR0=iR0max;
                  int iT7=(ib&(  31));
                  G7[jG7  ].T7=iT7;
                  G7[jG7  ].V7=igor_data.T7[iT7].V7;
                  G7[jG7  ].W7=igor_data.T7[iT7].W7;
                  if( jG7==(oG7- 1) ){
                     {
                        Composition comp(oG7,G7);
                        if( !B9.insert(comp).second )continue;
                        if( comp==targ )FLAG=true;
                     }
                     IGO_GLOADB(igor_data);
                     IGO_SCO2(igor_data,out);
                     IGO_GLOADE(igor_data);
                     IGO_SCO1(igor_data,out);
                     IGO_SCO0(igor_data);
                     IGO_SCO3(physics_consts,array_consts,igor_data,
                              out);
                     SCORE=( SCORE0  +SCORE1  +SCORE1b +SCORE2 +SCORE2b
                            +SCORE3  +SCORE3b +SCORE3c);
                     if( (SCORE>K7[iK7].e[ 0])&&(oT9> 0) ){
                        for(int iG7= 0;iG7<oG7;iG7++){
                           I7[ 0].G7[iG7]=G7[iG7];
                        }
//                      std::cout<<std::setw( 4)<<K7[iK7].K7ord
//                               <<std::fixed<<std::setprecision( 2)
//                               <<" SCO3="<<std::setw( 8)<<SCORE3
//                               <<" SCO3b="<<std::setw( 8)<<SCORE3b
//                               <<" SCO3c="<<std::setw( 8)<<SCORE3c
//                               <<(K7[iK7].b? '|': ' ');
//                      for(int iG7= 0;iG7<oG7;iG7++){
//                         std::cout<<std::setw( 3)<<G7[iG7].nR0;
//                      }
//                      std::cout<< std::endl;
                     }
                     if( FLAG ){
                        std::cerr<<"  SCORE"
                                 <<"  SCO0 "
                                 <<"  SCO1 "
                                 <<"  SCO1b"
                                 <<"  SCO2 "
                                 <<"  SCO2b"
                                 <<"  SCO3 "
                                 <<"  SCO3b"
                                 <<"  SCO3c"
                                 <<std::endl;
                        std::cerr<< std::fixed<<std::setprecision( 2);
                        std::cerr<< std::setw( 7)<<SCORE
                                 << std::setw( 7)<<SCORE0
                                 << std::setw( 7)<<SCORE1
                                 << std::setw( 7)<<SCORE1b
                                 << std::setw( 7)<<SCORE2
                                 << std::setw( 7)<<SCORE2b
                                 << std::setw( 7)<<SCORE3
                                 << std::setw( 7)<<SCORE3b
                                 << std::setw( 7)<<SCORE3c
                                 <<std::endl;
                        for(int iG7= 0;iG7<oG7;iG7++){
                           std::cerr<<std::setw( 4)<<G7[iG7].nR0;
                        }
                        std::cerr<<std::endl;
                        FLAG=false;
                     }
//
//
// maintain K7
//
                     if( (SCORE>K7[iK7].e[ 0])&&(oT9> 0) ){
                        K7[iK7].e[ 0]= SCORE;
                        K7[iK7].e[ 1]= SCORE0;
                        K7[iK7].e[ 2]= SCORE1;
                        K7[iK7].e[ 3]= SCORE1b;
                        K7[iK7].e[ 4]= SCORE2;
                        K7[iK7].e[ 5]= SCORE2b;
                        K7[iK7].e[ 6]= SCORE3;
                        K7[iK7].e[ 7]= SCORE3b;
                        K7[iK7].e[ 8]= SCORE3c;
                        for(int iG7= 0;iG7<oG7;iG7++){
                           K7[iK7].G7[iG7].mR0=G7[iG7].mR0;
                           K7[iK7].G7[iG7].nR0=G7[iG7].nR0;
                           K7[iK7].G7[iG7].T7=G7[iG7].T7;
                           K7[iK7].G7[iG7].C7=G7[iG7].C70;
                        }
                        IGO_3TRAJ_X(physics_consts,out);
                        for(int iR0= 0;iR0<oR0;iR0++){
                           K7[iK7].R0[iR0].xca=R0[iR0].xca;
                           K7[iK7].R0[iR0].xn=R0[iR0].xn;
                           K7[iK7].R0[iR0].xc=R0[iR0].xc;
                           K7[iK7].R0[iR0].xsc=R0[iR0].xsc;
                        }
                     }
//
//
// backup fold with highest score
//
                     if( SCORE>zSCORE ){
                        zSCORE= SCORE;
                        zSCORE0= SCORE0;
                        zSCORE1= SCORE1;
                        zSCORE1b= SCORE1b;
                        zSCORE2= SCORE2;
                        zSCORE2b= SCORE2b;
                        zSCORE3= SCORE3;
                        zSCORE3b= SCORE3b;
                        zSCORE3c= SCORE3c;
// chain state
                        zoG7=oG7;
                        if( int(zG7.size())!=oG7 ){
                           zG7.clear();
                           zG7.resize(oG7);
                        }
                        for(int iG7= 0;iG7<oG7;iG7++){
                           zG7[iG7]=G7[iG7];
                           int mR0=G7[iG7].mR0;
                           int nR0=G7[iG7].nR0;
                           for(int iR0=mR0;iR0<=nR0;iR0++){
                              R0[iR0].C7z=( 10*iG7 +G7[iG7].C70);
                           }
                        }
// hydrophob patches
                        zoW4=oW4;
                        if( int(zW4.size())!=oW4 ){
                           zW4.clear();
                           zW4.resize(oW4);
                        }
                        for(int iW4= 0;iW4<oW4;iW4++){
                           zW4[iW4]=W4[iW4];
                        }
// sheet config
                        zoM8=oM8;
                        if( int(zM8.size())!=oM8 ){
                           zM8.clear();
                           zM8.resize(oM8);
                        }
                        for(int iM8= 0;iM8<oM8;iM8++){
                           zM8[iM8]=M8[iM8];
                        }
                        zoU8=oU8;
                        if( int(zU8.size())!=oU8 ){
                           zU8.clear();
                           zU8.resize(oU8);
                        }
                        for(int iU8= 0;iU8<oU8;iU8++){
                           zU8[iU8]=U8[iU8];
                        }
                        zoT8=oT8;
                        if( int(zT8.size())!=oT8 ){
                           zT8.clear();
                           zT8.resize(oT8);
                        }
                        for(int iT8= 0;iT8<oT8;iT8++){
                           zT8[iT8]=T8[iT8];
                        }
                        zoV8=oV8;
                        if( int(zV8.size())!=oV8 ){
                           zV8.clear();
                           zV8.resize(oV8);
                        }
                        for(int iV8= 0;iV8<oV8;iV8++){
                           zV8[iV8]=V8[iV8];
                        }
// fold
                        zoM9=oM9;
                        if( int(zM9.size())!=oM9 ){
                           zM9.clear();
                           zM9.resize(oM9);
                        }
                        for(int iM9= 0;iM9<oM9;iM9++){
                           zM9[iM9]=M9[iM9];
                        }
                        zoU9=oU9;
                        if( int(zU9.size())!=oU9 ){
                           zU9.clear();
                           zU9.resize(oU9);
                        }
                        for(int iU9= 0;iU9<oU9;iU9++){
                           zU9[iU9]=U9[iU9];
                        }
                        zoT9=oT9;
                        if( int(zT9.size())!=oT9 ){
                           zT9.clear();
                           zT9.resize(oT9);
                        }
                        for(int iT9= 0;iT9<oT9;iT9++){
                           zT9[iT9]=T9[iT9];
                        }
                     }
                  }else{
                     jG7++;
                     if( jG7==(oG7- 1) ){
                        G7jR0(jG7)=(oR0- 2);
                     }else{
                        if( (jG7==pG7     )||
                            (jG7==(pG7- 1)) ){
                           G7jR0(jG7)=(I7[ 0].G7[jG7].nR0- 3);
                           if( G7jR0(jG7)<-1 )G7jR0(jG7)=-1;
                           while( K7[iK7].R0[G7jR0(jG7)+ 1].b ){
                              G7jR0(jG7)++;
                           }
                        }else{
                           G7jR0(jG7)=(I7[ 0].G7[jG7].nR0- 1);
                        }
                        if( G7jR0(jG7)<G7jR0(jG7- 1) )G7jR0(jG7)=G7jR0(jG7- 1);
                     }
                  }
               }
            }
         }
      }
      I7.clear();
//
//
// maintain ordered set of compositions
//
      for(int jK7max=(oK7-1);jK7max> 0;jK7max--){
         bool ORDERED=true;
         double e1= K7[ 0].e[ 0];
         for(int jK7= 1;jK7<=jK7max;jK7++){
            double e2= K7[jK7].e[ 0];
            if( e2>e1 ){
               t=K7[jK7-1];
               K7[jK7-1]=K7[jK7  ];
               K7[jK7  ]=t;
               ORDERED=false;
            }else{
               e1=e2;
            }
         }
         if( ORDERED )break;
      }
//
//
// diagnostic output
//
      if( out.VERBOSE ){
         out.FILE3<<"CHAIN STATE FROM RESIDUE ISING MODEL\n";
         for(int iR0= 0;iR0<oR0;iR0++){
            out.FILE3<<igor_data.C7[ R0[iR0].C70].a1;
            if( ((iR0+ 1)%100==0)||(iR0==(oR0- 1)) ){
               out.FILE3<<'\n';
            }
         }
         out.FILE3<<"________\n";
         out.FILE3<<"HIGH SCORE (0123) CHAIN FOLDS[pass="
                  <<std::setw( 1)<<iFOLD<<"]\n";
         for(int iK7= 0;iK7<oK7;iK7++){
            for(int iG7= 0;iG7<K7[iK7].oG7;iG7++){
               char a1=igor_data.C7[K7[iK7].G7[iG7].C7].a1;
               int mR0=K7[iK7].G7[iG7].mR0;
               int nR0=K7[iK7].G7[iG7].nR0;
               for(int iR0=mR0;iR0<=nR0;iR0++){
                  out.FILE3<<a1;
                  if( ((iR0+ 1)%100==0)||(iR0==(oR0-1)) ){
                     out.FILE3<<'\n';
                  }
               }
            }
            for(int iG7= 0;iG7<K7[iK7].oG7;iG7++){
               int mR0=K7[iK7].G7[iG7].mR0;
               int nR0=K7[iK7].G7[iG7].nR0;
               for(int iR0=mR0;iR0<=nR0;iR0++){
                  int iL1=R0[iR0].L1;
                  char a1=igor_data.L1[iL1].a1;
                  out.FILE3<<(( K7[iK7].R0[iR0].b )? a1: '.');
                  if( ((iR0+ 1)%100==0)||(iR0==(oR0-1)) ){
                     out.FILE3<<'\n';
                  }
               }
            }
         }
         out.FILE3<<"________\n";
         out.FILE3<<"  SCORE"
                  <<"  SCO0 "
                  <<"  SCO1 "
                  <<"  SCO1b"
                  <<"  SCO2 "
                  <<"  SCO2b"
                  <<"  SCO3 "
                  <<"  SCO3b"
                  <<"  SCO3c"
                  <<"[pass="<<std::setw( 1)<<iFOLD<<"]\n";
         out.FILE3<< std::fixed<<std::setprecision( 2);
         for(int iK7= 0;iK7<oK7;iK7++){
            if( K7[iK7].e[ 0]<=(-1.00e+5) )break;
            for(int i=0;i<9;i++){
               out.FILE3<<std::setw( 7)<<K7[iK7].e[ i];
            }
            out.FILE3<<'\n';
         }
      }
   }
//
//
//
//
   B9.clear();
   return;
}
