#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <set>
#include <iostream>
#include <cstdlib>
#include <iomanip>

class MEM_igo_2traj {
private:
   std::vector<int> o_G7jntb;           //map left to elem in coil
   std::vector<int> o_G7jntf;           //map right to elem in coil
public:
   MEM_igo_2traj(int g):
      o_G7jntb( g),
      o_G7jntf( g)
   {
   }
   int& G7jntb(int i){
      return o_G7jntb.at( i);  }
   int& G7jntf(int i){
      return o_G7jntf.at( i);  }
};

void Igor_Model::IGO_2TRAJ(const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_IGOR_DATA& igor_data,
                           Output_Streams& out){
   MEM_igo_2traj vv(oG7);
   std::set<Composition> B9;
//
//
// initiate high SCORE chain states
//
   oK7=8192;
   K7.clear();
   K7.resize(oK7);
   for(int iK7= 0;iK7<oK7;iK7++){
      K7[iK7].oR0=oR0;
      K7[iK7].R0.resize(oR0);
   }
   oI7= 4;
   I7.clear();
   I7.resize(oI7);
   for(int iI7= 0;iI7<oI7;iI7++){
      I7[iI7].oR0=oR0;
      I7[iI7].R0.resize(oR0);
   }
   tK7 t;
   t.oR0=oR0;
   t.R0.resize(oR0);
   for(int iK7= 0;iK7<oK7;iK7++){
      K7[iK7].e[ 0]= (-1.00e+5);
      K7[iK7].oG7=0;
      K7[iK7].PACK=false;
   }
//
//
// trajectory params
//
   int lR0[ 4];                 //lower bound for length of region
   int uR0[ 4];                 //upper bound for length of region
   lR0[ 0]=32;
   uR0[ 0]=56;
   lR0[ 1]=36;
   uR0[ 1]=60;
   lR0[ 2]=40;
   uR0[ 2]=64;
   lR0[ 3]=40;
   uR0[ 3]=64;
   int oCYCLE=4;                //number of cycles over regions
//
//
// search through space of compositions without SCORE3
//
   if( out.VERBOSE ){
      out.FILE3<<"TRAJECTORY SEARCH"
                 " THROUGH SPACE OF ELEMENT COMPOSITIONS\n";
   }
   bool FLAG=false;
   zSCORE= (-1.00e+6);
   int nPASS1=0;        //low prob of any state
   int nPASS2=0;        //high prob for extension of elem
   int nPASS3=0;        //excluded by (type,size,state,prob) filter
   int nEVAL1=0;        //sequence of elems evaluations
   int nEVAL2=0;        //composition equivalent to sequence of elems
   for(iCYCLE= 0;iCYCLE<oCYCLE;iCYCLE++){
      SWITCH=false;
      i7R0=-1;
      while( i7R0<(oR0-1) ){
         int jC7=0;
         oG7=-1;
         int pG7=-1;
         for(int iR0= 0;iR0<oR0;iR0++){
            int lC7=R0[iR0].C7z;
            if( lC7==jC7 ){
               G7[oG7].nR0=iR0;
            }else{
               jC7=lC7;
               oG7++;
               G7[oG7].mR0=iR0;
               G7[oG7].nR0=iR0;
            }
            if( iR0==i7R0 )pG7=oG7;
         }
         oG7++;
         vv.G7jntb( 0)=0;
         vv.G7jntf(oG7- 1)=(oG7- 1);
         for(int iG7= 1;iG7<oG7;iG7++){
            jC7=(R0[G7[iG7].mR0].C7z%10);
            if( jC7==3 ){
               vv.G7jntb(iG7)=iG7;
            }else{
               vv.G7jntb(iG7)=vv.G7jntb(iG7- 1);
            }
         }
         for(int iG7=(oG7- 2);iG7>-1;iG7--){
            jC7=(R0[G7[iG7].mR0].C7z%10);
            if( jC7==3 ){
               vv.G7jntf(iG7)=iG7;
            }else{
               vv.G7jntf(iG7)=vv.G7jntf(iG7+ 1);
            }
         }
         int iG7min(-1),iG7max(-1);
         if( pG7==-1 ){
            iG7min=0;
            iG7max=iG7min;
            int jG7=( (iG7min+ 7)>oG7 )? oG7: (iG7min+ 7);
            for(int iG7=iG7min;iG7<jG7;iG7++){
               if( vv.G7jntf(iG7)>iG7 )continue;
               if( (G7[iG7].nR0+ 1)>=lR0[iCYCLE] ){
                  if( (G7[iG7].nR0+ 1)<=uR0[iCYCLE] ){
                     iG7max=iG7;
                  }else{
                  }
                  break;
               }else{
                  iG7max=iG7;
               }
            }
         }else{
            iG7max=vv.G7jntf(pG7+ 1);
            iG7min=iG7max;
            int jG7=( (iG7max- 7)<-1 )? -1: (iG7max- 7);
            for(int iG7=iG7max;iG7>jG7;iG7--){
               if( vv.G7jntb(iG7)<iG7 )continue;
               if( (G7[iG7max].nR0-G7[iG7].mR0+ 1)>=lR0[iCYCLE] ){
                  if( (G7[iG7max].nR0-G7[iG7].mR0+ 1)<=uR0[iCYCLE] ){
                     iG7min=iG7;
                  }else{
                  }
                  break;
               }else{
                  iG7min=iG7;
               }
            }
         }
         i0R0=G7[iG7min].mR0;
         i7R0=G7[iG7max].nR0;
         for(int iR0= 0;iR0<oR0;iR0++){
            R0[iR0].C7def=R0[iR0].C7z;
         }
         o_T7T7T7T7T7T7T7b.resize(386201104, false);
         int G7iT7[ 7];
         G7iT7[ 1]= 0;
         G7iT7[ 2]= 0;
         G7iT7[ 3]= 0;
         G7iT7[ 4]= 0;
         G7iT7[ 5]= 0;
         G7iT7[ 6]= 0;
         mG7grp=iG7min;
         int iGRPmin=( (iG7max-iG7min- 2)>=0 )? (iG7max-iG7min- 2) :0;
         int iGRPmax=( (iG7max-iG7min+ 2)<=6 )? (iG7max-iG7min+ 2) :6;
         std::cerr<<" iCYCLE="<<std::setw( 1)<<iCYCLE
                  <<" region R0=["<<std::setw( 3)<<i0R0<<','
                                  <<std::setw( 3)<<i7R0<<']'
                  <<" region G7=["<<std::setw( 3)<<iG7min<<','
                                  <<std::setw( 3)<<iG7max<<']'
                  << std::endl;
         for(int iGRP=iGRPmin;iGRP<=iGRPmax;iGRP++){
            nG7grp=(mG7grp+iGRP);
            NEWGRP=true;
            int G7jR0max[ 7];
            for(int iG7=mG7grp;iG7<=nG7grp;iG7++){
               G7jR0max[iG7-mG7grp]=(i7R0-nG7grp+iG7);
               G7jR0(iG7)=-1;
            }
            G7jR0(mG7grp- 1)=(i0R0- 1);
            G7jR0(mG7grp   )=(i0R0- 1);
            if( mG7grp==nG7grp ){
               G7jR0(mG7grp)=(i7R0- 1);
            }
            if( mG7grp> 0 ){
               if( zG7[mG7grp- 1].nR0==zG7[mG7grp- 1].mR0 ){
                  G7jR0(mG7grp)++;
               }
            }
            G7kR0(mG7grp- 1)=(i0R0- 1);
//
//
// search of compositions within region
//
            for(int jG7=mG7grp;;){
               G7jR0(jG7)++;
               if( G7jR0(jG7)>G7jR0max[jG7-mG7grp] ){
                  if( jG7==mG7grp ){
                     break;
                  }else{
                     jG7--;
                     continue;
                  }
               }else{
                  int iR0min=(G7jR0(jG7- 1)+ 1);
                  int iR0max=G7jR0(jG7   );
                  short ib=R0R0v(iR0min,iR0max);
                  short jb= 160;
                  if( iR0min==i0R0 )jb-=  32;
                  if( iR0max==i7R0 )jb-= 128;
                  if      ( (ib&(  64))>0 ){
                     nPASS1++;
                     continue;
                  }else if( (ib&jb)>0 ){
                     nPASS2++;
                     continue;
                  }
                  jb= 1792;
                  if( iR0min==i0R0 )jb-= 256;
                  if( iR0max==i7R0 )jb-=1024;
                  if( (ib&jb)>0 ){
                     nPASS3++;
                     continue;
                  }
                  G7[jG7  ].mR0=iR0min;
                  G7[jG7  ].nR0=iR0max;
                  int iT7=(ib&(  31));
                  G7[jG7  ].T7=iT7;
                  G7[jG7  ].V7=igor_data.T7[iT7].V7;
                  G7[jG7  ].W7=igor_data.T7[iT7].W7;
                  G7iT7[jG7-mG7grp]=iT7;
                  for(int iR0=iR0min;iR0<=iR0max;iR0++){
                     R0[iR0].C7def=(4+(jG7-mG7grp));
                  }
                  if( jG7==nG7grp ){
                     if( T7T7T7T7T7T7T7b(G7iT7[ 0],G7iT7[ 1],G7iT7[ 2],
                                         G7iT7[ 3],G7iT7[ 4],G7iT7[ 5],
                                         G7iT7[ 6]) ){
                        continue;
                     }
//
//
// initiate high SCORE compositions
//
                     for(int jI7= 0;jI7<oI7;jI7++){
                        I7[jI7].e[ 0]= (-1.00e+5);
                        I7[jI7].oG7=0;
                        I7[jI7].PACK=false;
                     }
                     if( NEWGRP ){
                        IGO_GSEQ(igor_data);
                     }
                     {
                        Composition comp(oG7,G7);
                        if( !B9.insert(comp).second )continue;
                        if( comp==targ )FLAG=true;
                     }
                     IGO_GLOADB(igor_data);
                     IGO_SCO2(igor_data,out);
                     IGO_GLOADE(igor_data);
                     IGO_SCO1(igor_data,out);
                     IGO_SCO0(igor_data);
                     IGO_STEP(physics_consts,igor_data,out);
                     nEVAL1++;
                     if( FLAG ){
                        std::cerr<<"  SCORE"
                                 <<"  SCO0 "
                                 <<"  SCO1 "
                                 <<"  SCO1b"
                                 <<"  SCO2 "
                                 <<"  SCO2b"
                                 <<std::endl;
                        std::cerr<< std::fixed<<std::setprecision( 2);
                        std::cerr<< std::setw( 7)<<SCORE
                                 << std::setw( 7)<<SCORE0
                                 << std::setw( 7)<<SCORE1
                                 << std::setw( 7)<<SCORE1b
                                 << std::setw( 7)<<SCORE2
                                 << std::setw( 7)<<SCORE2b
                                 <<std::endl;
                        for(int iG7= 0;iG7<oG7;iG7++){
                           std::cerr<<std::setw( 3)<<G7[iG7].nR0;
                        }
                        std::cerr<<std::endl;
                        FLAG=false;
                     }
                     NEWGRP=false;
                     T7T7T7T7T7T7T7b(G7iT7[ 0],G7iT7[ 1],G7iT7[ 2],
                                     G7iT7[ 3],G7iT7[ 4],G7iT7[ 5],
                                     G7iT7[ 6],true);
//
//
// initiate ordered set of compositions for sequence of elem types
//
                     {
                        I7[ 0].e[ 0]= SCORE;
                        I7[ 0].e[ 1]= SCORE0;
                        I7[ 0].e[ 2]= SCORE1;
                        I7[ 0].e[ 3]= SCORE1b;
                        I7[ 0].e[ 4]= SCORE2;
                        I7[ 0].e[ 5]= SCORE2b;
                        I7[ 0].e[ 6]= (0.00);
                        I7[ 0].e[ 7]= (0.00);
                        I7[ 0].e[ 8]= (0.00);
                        if( I7[ 0].oG7!=oG7 ){
                           I7[ 0].oG7=oG7;
                           I7[ 0].G7.resize(oG7);
                        }
                        for(int iG7= 0;iG7<oG7;iG7++){
                           I7[ 0].G7[iG7].mR0=G7[iG7].mR0;
                           I7[ 0].G7[iG7].nR0=G7[iG7].nR0;
                           I7[ 0].G7[iG7].T7=G7[iG7].T7;
                           I7[ 0].G7[iG7].C7=G7[iG7].C70;
                        }
                        I7[ 0].PACK=false;
                     }
//
//
// search compositions consistent with sequence of elem types
//
                     for(int iG7=mG7grp;iG7<=nG7grp;iG7++){
                        G7kR0(iG7)=G7jR0(iG7);
                     }
                     for(int kG7=nG7grp;;){
                        G7kR0(kG7)++;
                        if( G7kR0(kG7)>G7jR0max[kG7-mG7grp] ){
                           if( kG7==mG7grp ){
                              break;
                           }else{
                              kG7--;
                              continue;
                           }
                        }else{
                           iR0min=(G7kR0(kG7- 1)+ 1);
                           iR0max=G7kR0(kG7   );
                           ib=R0R0v(iR0min,iR0max);
                           int jT7=G7iT7[kG7-mG7grp];
                           if( (iR0max-iR0min+ 1)>igor_data.T7[jT7].nR7 ){
                              if( kG7==mG7grp ){
                                 break;
                              }else{
                                 kG7--;
                                 continue;
                              }
                           }
                           if( (ib&31)!=jT7 )continue;
                           jb= 160;
                           if( iR0min==i0R0 )jb-=  32;
                           if( iR0max==i7R0 )jb-= 128;
                           if      ( (ib&(  64))>0 ){
                              continue;
                           }else if( (ib&jb)>0 ){
                              continue;
                           }
                           jb= 1792;
                           if( iR0min==i0R0 )jb-= 256;
                           if( iR0max==i7R0 )jb-=1024;
                           if( (ib&jb)>0 ){
                              continue;
                           }
                           G7[kG7  ].mR0=iR0min;
                           G7[kG7  ].nR0=iR0max;
                           if( kG7==nG7grp ){
                              {
                                 Composition comp(oG7,G7);
                                 if( !B9.insert(comp).second )continue;
                                 if( comp==targ )FLAG=true;
                              }
                              IGO_GLOADE(igor_data);
                              IGO_SCO1(igor_data,out);
                              IGO_SCO0(igor_data);
                              IGO_STEP(physics_consts,igor_data,out);
                              nEVAL2++;
                              if( FLAG ){
                                 std::cerr<<"  SCORE"
                                          <<"  SCO0 "
                                          <<"  SCO1 "
                                          <<"  SCO1b"
                                          <<"  SCO2 "
                                          <<"  SCO2b"
                                          <<std::endl;
                                 std::cerr<< std::fixed<<std::setprecision( 2);
                                 std::cerr<< std::setw( 7)<<SCORE
                                          << std::setw( 7)<<SCORE0
                                          << std::setw( 7)<<SCORE1
                                          << std::setw( 7)<<SCORE1b
                                          << std::setw( 7)<<SCORE2
                                          << std::setw( 7)<<SCORE2b
                                          <<std::endl;
                                 for(int iG7= 0;iG7<oG7;iG7++){
                                    std::cerr<<std::setw( 4)<<G7[iG7].nR0;
                                 }
                                 std::cerr<<std::endl;
                                 FLAG=false;
                              }
//
//
// maintain ordered set of compositions for sequence of elem types
//
                              int pI7=(oI7- 1);
                              if( SCORE>I7[pI7].e[ 0] ){
                                 I7[pI7].e[ 0]= SCORE;
                                 I7[pI7].e[ 1]= SCORE0;
                                 I7[pI7].e[ 2]= SCORE1;
                                 I7[pI7].e[ 3]= SCORE1b;
                                 I7[pI7].e[ 4]= SCORE2;
                                 I7[pI7].e[ 5]= SCORE2b;
                                 I7[pI7].e[ 6]= (0.00);
                                 I7[pI7].e[ 7]= (0.00);
                                 I7[pI7].e[ 8]= (0.00);
                                 if( I7[pI7].oG7!=oG7 ){
                                    I7[pI7].oG7=oG7;
                                    I7[pI7].G7.resize(oG7);
                                 }
                                 for(int iG7= 0;iG7<oG7;iG7++){
                                    I7[pI7].G7[iG7].mR0=G7[iG7].mR0;
                                    I7[pI7].G7[iG7].nR0=G7[iG7].nR0;
                                    I7[pI7].G7[iG7].T7=G7[iG7].T7;
                                    I7[pI7].G7[iG7].C7=G7[iG7].C70;
                                 }
                                 I7[pI7].PACK=false;
                                 for(int jI7=pI7;jI7> 0;jI7--){
                                    if( I7[jI7  ].e[ 0]<
                                        I7[jI7-1].e[ 0] )break;
                                    t=I7[jI7-1];
                                    I7[jI7-1]=I7[jI7  ];
                                    I7[jI7  ]=t;
                                 }
                              }else{
                              }
//
                           }else{
                              kG7++;
                              G7kR0(kG7)=G7kR0(kG7- 1);
                              if( kG7==nG7grp )G7kR0(kG7)=(i7R0- 1);
                              if( (G7kR0(kG7   )-G7kR0(kG7- 2))== 1 ){
                                 G7kR0(kG7)++;
                              }
                           }
                        }
                     }
                     for(int iG7=mG7grp;iG7<=nG7grp;iG7++){
                        G7[iG7].mR0=(G7jR0(iG7- 1)+ 1);
                        G7[iG7].nR0=G7jR0(iG7);
                     }
//
//
// maintain ordered set of compositions
//
                     for(int jI7= 0;jI7<oI7;jI7++){
                        double e= I7[jI7].e[ 0];
                        if( e<=K7[oK7-1].e[ 0] )break;
//
//
// filter diversity of chain states
//
                        bool PASS=false;
                        int n=0;
                        for(int iK7= 0;iK7<oK7&&(K7[iK7].e[ 0]>e);iK7++){
                           if( bcomp(K7[iK7],I7[jI7]) )n++;
                           if( n>63 ){
                              PASS=true;
                              break;
                           }
                        }
                        if( PASS )continue;
//
                        K7[oK7-1]=I7[jI7];
                        for(int jK7=(oK7-1);jK7> 0;jK7--){
                           if( K7[jK7  ].e[ 0]<
                               K7[jK7-1].e[ 0] )break;
                           t=K7[jK7-1];
                           K7[jK7-1]=K7[jK7  ];
                           K7[jK7  ]=t;
                        }
                     }
//
//
//
//
                  }else{
                     jG7++;
                     G7jR0(jG7)=G7jR0(jG7- 1);
                     if( jG7==nG7grp )G7jR0(jG7)=(i7R0- 1);
                     if( (G7jR0(jG7   )-G7jR0(jG7- 2))== 1 ){
                        G7jR0(jG7)++;
                     }
                  }
               }
            }
         }
         o_T7T7T7T7T7T7T7b.clear();
      }
      if( !SWITCH )break;
   }
//
//
// remove unused K7
//
   int o=oK7;
   for(int iK7=0;iK7<o;iK7++){
      if( K7[iK7].e[ 0]<=(-1.00e+5) ){
         for(int jK7=iK7;jK7<o;jK7++){
            K7.pop_back();
         }
         oK7=iK7;
         break;
      }
   }
//
//
// diagnostic output
//
   if( out.VERBOSE ){
      out.FILE3<<"SEARCH STATISTICS\n";
      out.FILE3<< std::setw(10)<<nPASS1
               <<" low prob of any state\n";
      out.FILE3<< std::setw(10)<<nPASS2
               <<" high prob for extension of elem\n";
      out.FILE3<< std::setw(10)<<nPASS3
               <<" excluded by (type,size,state,prob) filter\n";
      out.FILE3<< std::setw(10)<<nEVAL1
               <<" sequence of elems evaluations\n";
      out.FILE3<< std::setw(10)<<nEVAL2
               <<" equivalent sequence of elems evaluations\n";
   }
//
//
// for each high score chain state, extend search
//
   std::cout<<"SEARCH NEIGHBORS"<<std::endl;
   NEWGRP=true;
   I7.clear();
   I7.resize( 1);
   I7[ 0].oR0=oR0;
   I7[ 0].R0.resize(oR0);
   for(int iK7= 0;iK7<oK7;iK7++){
      I7[ 0]=K7[iK7];
      oG7=I7[ 0].oG7;
//
//
// iterate over neighbor compositions
//
      for(int aG7= 0;aG7<(oG7- 1);aG7++){
         if( I7[ 0].G7[aG7].C7==3 )continue;
         for(int bG7=(aG7+ 1);bG7<oG7;bG7++){
            if( I7[ 0].G7[bG7].C7==3 )continue;
            G7jR0(-1)=-1;
            if( ( 0==aG7     )||
                ( 0==(aG7- 1)) ){
               G7jR0( 0)=(I7[ 0].G7[ 0].nR0- 2);
               if( G7jR0( 0)<-1 )G7jR0( 0)=-1;
            }else{
               G7jR0( 0)=(I7[ 0].G7[ 0].nR0- 1);
            }
            for(int iG7= 0;iG7<oG7;iG7++){
               if( (iG7==aG7     )||
                   (iG7==(aG7- 1))||
                   (iG7==bG7     )||
                   (iG7==(bG7- 1)) ){
                  G7kR0(iG7)=(I7[ 0].G7[iG7].nR0+ 1);
                  if( G7kR0(iG7)>(oR0-oG7+iG7) )G7kR0(iG7)=(oR0-oG7+iG7);
               }else{
                  G7kR0(iG7)=I7[ 0].G7[iG7].nR0;
               }
            }
            for(int jG7= 0;;){
               G7jR0(jG7)++;
               if( G7jR0(jG7)>G7kR0(jG7) ){
                  if( jG7== 0 ){
                     break;
                  }else{
                     jG7--;
                     continue;
                  }
               }else{
                  int iR0min=(G7jR0(jG7- 1)+ 1);
                  int iR0max=G7jR0(jG7);
                  short ib=R0R0v(iR0min,iR0max);
                  G7[jG7  ].mR0=iR0min;
                  G7[jG7  ].nR0=iR0max;
                  int iT7=(ib&(  31));
                  G7[jG7  ].T7=iT7;
                  G7[jG7  ].V7=igor_data.T7[iT7].V7;
                  G7[jG7  ].W7=igor_data.T7[iT7].W7;
                  if( jG7==(oG7- 1) ){
                     {
                        Composition comp(oG7,G7);
                        if( !B9.insert(comp).second )continue;
                     }
                     IGO_GLOADB(igor_data);
                     IGO_SCO2(igor_data,out);
                     IGO_GLOADE(igor_data);
                     IGO_SCO1(igor_data,out);
                     IGO_SCO0(igor_data);
                     IGO_STEP(physics_consts,igor_data,out);
//
//
// maintain K7
//
                     if( SCORE>K7[iK7].e[ 0] ){
                        K7[iK7].e[ 0]= SCORE;
                        K7[iK7].e[ 1]= SCORE0;
                        K7[iK7].e[ 2]= SCORE1;
                        K7[iK7].e[ 3]= SCORE1b;
                        K7[iK7].e[ 4]= SCORE2;
                        K7[iK7].e[ 5]= SCORE2b;
                        for(int iG7= 0;iG7<oG7;iG7++){
                           K7[iK7].G7[iG7].mR0=G7[iG7].mR0;
                           K7[iK7].G7[iG7].nR0=G7[iG7].nR0;
                           K7[iK7].G7[iG7].T7=G7[iG7].T7;
                           K7[iK7].G7[iG7].C7=G7[iG7].C70;
                        }
                     }
                  }else{
                     jG7++;
                     if( jG7==(oG7- 1) ){
                        G7jR0(jG7)=(oR0- 2);
                     }else{
                        if( (jG7==aG7     )||
                            (jG7==(aG7- 1))||
                            (jG7==bG7     )||
                            (jG7==(bG7- 1)) ){
                           G7jR0(jG7)=(I7[ 0].G7[jG7].nR0- 2);
                        }else{
                           G7jR0(jG7)=(I7[ 0].G7[jG7].nR0- 1);
                        }
                        if( G7jR0(jG7)<G7jR0(jG7- 1) )G7jR0(jG7)=G7jR0(jG7- 1);
                     }
                  }
               }
            }
         }
      }
   }
   I7.clear();
   B9.clear();
//
//
// cluster
//
   for(int iK7= 0;iK7<oK7;iK7++){
      K7[iK7].b=true;
   }
   for(int iK7= 0;iK7<(oK7- 1);iK7++){
      if( !K7[iK7].b )continue;
      for(int jK7=(iK7+ 1);jK7<oK7;jK7++){
         if( !K7[jK7].b )continue;
         if( dcomp(K7[jK7],K7[iK7])< 3 ){
            K7[jK7].b=false;
         }
      }
   }
   {
      int jK7=0;
      for(int iK7= 0;iK7<oK7;iK7++){
         if( !K7[iK7].b )continue;
         K7[jK7++]=K7[iK7];
         if( jK7==2048 )break;
      }
      for(int iK7=jK7;iK7<oK7;iK7++){
         K7.pop_back();
      }
      oK7=jK7;
   }
   for(int iK7= 0;iK7<oK7;iK7++){
      K7[iK7].b=false;
   }
//
//
// diagnostic output
//
   if( out.VERBOSE ){
      out.FILE3<<"CHAIN STATE FROM RESIDUE ISING MODEL\n";
      for(int iR0= 0;iR0<oR0;iR0++){
         out.FILE3<<igor_data.C7[ R0[iR0].C70].a1;
         if( ((iR0+ 1)%100==0)||(iR0==(oR0- 1)) ){
            out.FILE3<<'\n';
         }
      }
      out.FILE3<<"________\n";
      out.FILE3<<"HIGH SCORE (012) CHAIN STATES[pass="
               <<std::setw( 1)<<iFOLD<<"]\n";
      for(int iK7= 0;iK7<oK7;iK7++){
         if( K7[iK7].e[ 0]<=(-1.00e+5) )break;;
         for(int iG7= 0;iG7<K7[iK7].oG7;iG7++){
            char a1=igor_data.C7[K7[iK7].G7[iG7].C7].a1;
            int mR0=K7[iK7].G7[iG7].mR0;
            int nR0=K7[iK7].G7[iG7].nR0;
            for(int iR0=mR0;iR0<=nR0;iR0++){
               out.FILE3<<a1;
               if( ((iR0+ 1)%100==0)||(iR0==(oR0-1)) ){
                  out.FILE3<<'\n';
               }
            }
         }
      }
      out.FILE3<<"________\n";
      out.FILE3<<"  SCORE"
               <<"  SCO0 "
               <<"  SCO1 "
               <<"  SCO1b"
               <<"  SCO2 "
               <<"  SCO2b"
               <<"[pass="<<std::setw( 1)<<iFOLD<<"]\n";
      out.FILE3<< std::fixed<<std::setprecision( 2);
      for(int iK7= 0;iK7<oK7;iK7++){
         if( K7[iK7].e[ 0]<=(-1.00e+5) )break;
         for(int i=0;i<6;i++){
            out.FILE3<<std::setw( 7)<<K7[iK7].e[ i];
         }
         out.FILE3<<'\n';
      }
   }
   return;
}
