#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <iostream>
#include <cstdlib>
#include <iomanip>

void Igor_Model::IGO(const DAT_PHYSICS_CONSTS& physics_consts,
                     const DAT_ARRAY_CONSTS& array_consts,
                     const DAT_RESIDUE_MAPPINGS& residue_mappings,
                     const DAT_IGOR_DATA& igor_data,
                     const Thread_Options& opt,
                     Output_Streams& out,
                     const Structure& str,
                     int pZ0,
                     int pR0min,
                     int pR0max){
   if( out.VERBOSE ){
      out.FILE3<<"IGOR FOLD\n";
      out.FILE3<<" pZ0"
               <<" pR0min"
               <<" pR0max\n";
      out.FILE3<< std::setw( 4)<<(pZ0+1)
               << std::setw( 7)<<(pR0min+1)
               << std::setw( 7)<<(pR0max+1)<<'\n';
   }
//
//
// scale factors for SCORE components
//
   alp0=( 1.00);
   alp1=( 1.00);
   alp1b=( 1.00);
   alp2=( 1.00);
   alp2b=( 1.00);
   alp3=( 1.00);
   alp3b=( 1.00);
   alp3c=( 1.00);
//
//
// total charge
//
   int ichg=0;
   for(int jR0=pR0min;jR0<=pR0max;jR0++){
      int jL0=str.R0[jR0].L0;
      char a1=residue_mappings.L0[jL0].a1;
      if      ( (a1=='D')||(a1=='E') ){
         ichg--;
      }else if( (a1=='K')||(a1=='R') ){
         ichg++;
      }
   }
   if( std::abs(ichg)> 7 ){
      alp3c*=( .50);
   }
//
//
// isolate chain
//
   oR0=(pR0max-pR0min+ 1);
   R0.resize(oR0);
   for(int jR0=pR0min;jR0<=pR0max;jR0++){
      int iR0=(jR0-pR0min);
      int jL0=str.R0[jR0].L0;
      char a1=residue_mappings.L0[jL0].a1;
      if( a1=='O' )a1='G';
      if( a1=='U' )a1='G';
      int iL1=igor_data.iresidue( a1);
      if( iL1==-1 ){
         std::cerr<<"ERROR: Unmatched 1-letter residue name."
                  <<" iZ0="<< std::setw( 4)<<(pZ0+ 1)
                  <<" iR0="<< std::setw( 4)<<(jR0+ 1)
                  <<" a1="<<a1
                  <<" mol="<<str.mol<<'\n';
         std::exit( 1);
      }
      R0[iR0].L1=iL1;
      R0[iR0].O7=igor_data.L1[iL1].O7;
      R0[iR0].P7=igor_data.L1[iL1].P7;
      R0[iR0].zet=igor_data.L1[iL1].zet;
      R0[iR0].kap=igor_data.L1[iL1].kap;
      if( igor_data.L1[iL1].zet!= 0 ){
         for(int i=0;i<4;i++){
            R0[iR0].ef[i]=igor_data.L1[iL1].ef[i];
         }
      }
      if( igor_data.L1[iL1].kap> 0 ){
         R0[iR0].vf=igor_data.L1[iL1].vf;
      }
      R0[iR0].lnk=-1;
      if( a1=='C' ){
         if( str.nS0>0 ){
            for(int iS0= 0;iS0<str.nS0;iS0++){
               for(int iN2=0;iN2<2;iN2++){
                  if( str.S0N2R0(iS0,iN2)==jR0 ){
                     int pR0=str.S0N2R0(iS0,( 1-iN2));
                     if( (pR0>=pR0min)&&(pR0<=pR0max) ){
                        R0[iR0].lnk=(pR0-pR0min);
                     }
                  }
               }
            }
         }
      }
      char x=str.R0[jR0].path;
      if      ( x=='-' ){
         R0[iR0].C7w( 1)= ( 0.00);
         R0[iR0].C7w( 2)= ( 0.00);
         R0[iR0].C7w( 3)= ( 0.00);
      }else if( x=='H' ){
         R0[iR0].C7w( 1)= ( 5.00);
         R0[iR0].C7w( 2)= (-2.50);
         R0[iR0].C7w( 3)= (-2.50);
      }else if( x=='E' ){
         R0[iR0].C7w( 1)= (-2.50);
         R0[iR0].C7w( 2)= ( 5.00);
         R0[iR0].C7w( 3)= (-2.50);
      }else if( x=='C' ){
         R0[iR0].C7w( 1)= (-2.50);
         R0[iR0].C7w( 2)= (-2.50);
         R0[iR0].C7w( 3)= ( 5.00);
      }
   }
//
//
// native composition
//
   int jC7=0;
   oG7=-1;
   for(int jR0=pR0min;jR0<=pR0max;jR0++){
      int iR0=(jR0-pR0min);
      int lC7=str.R0[jR0].C7;
      if( lC7==jC7 ){
         targ.G7jR0[oG7]=iR0;
      }else{
         jC7=lC7;
         oG7++;
         targ.G7jR0.push_back(iR0);
      }
   }
   targ.oG7=(oG7+ 1);
//
//
// iterate through path impulses
//
   int oC7=igor_data.oC7;
   xFOLD= (-.25);
   for(iFOLD=0;iFOLD<2;iFOLD++){
      xFOLD+=( .25);
//
//
// hash residue impulses
//
      IGO_EHASH(igor_data);
//
//
// load residue ising model
//
      o_R0C7e.resize(oR0*3, (0.00));
      o_R0C7C7e.resize(oR0*9, (0.00));
      o_R0C7C7C7e.resize(oR0*27, (0.00));
      o_R0C7C7C7C7e.resize(oR0*81, (0.00));
      o_R0C7C7C7C7C7e.resize(oR0*243, (0.00));
      o_R0C7C7C7C7C7C7e.resize(oR0*729, (0.00));
      IGO_RLOAD(igor_data);
      for(int iR0= 0;iR0<oR0;iR0++){
         for(int iC7= 1;iC7<oC7;iC7++){
            R0C7e(iR0,iC7)+=R0[iR0].C7w(iC7);
         }
      }
//
//
// evaluate residue probabilities
//
      o_R0C7p.resize(oR0*3, (0.00));
      o_R0C7C7p.resize(oR0*9, (0.00));
      o_R0C7C7C7p.resize(oR0*27, (0.00));
      o_R0C7C7C7C7p.resize(oR0*81, (0.00));
      o_R0C7C7C7C7C7p.resize(oR0*243, (0.00));
      o_R0C7C7C7C7C7C7p.resize(oR0*729, (0.00));
      o_R0C7C7C7C7C7C7a.resize((oR0+5)*4096, (1.00));
      o_R0mC7.resize(oR0+10);
      o_R0nC7.resize(oR0+10);
      o_R0C7C7C7C7C7z.resize((oR0+6)*1024);
      o_R0C7C7C7C7C7q.resize((oR0+6)*1024);
      o_C7p.resize(3);
      IGO_RPROB(igor_data,out);
      if( iFOLD==0 ){
      }else{
//
//
// update res impulses using K7 sample from previous traj
//
         IGO_ULOAD(igor_data,out);
         IGO_RPROB(igor_data,out);
      }
      o_R0C7p.clear();
      o_R0C7C7p.clear();
      o_R0C7C7C7p.clear();
      o_R0C7C7C7C7p.clear();
      o_R0C7C7C7C7C7p.clear();
      o_R0C7C7C7C7C7C7p.clear();
      o_R0C7C7C7C7C7C7a.clear();
      o_R0mC7.clear();
      o_R0nC7.clear();
      o_R0C7C7C7C7C7z.clear();
      o_R0C7C7C7C7C7q.clear();
      if( opt.MODE=="ssp" ){
         return;
      }
//
//
// set element filters
//
      o_R0R0v.resize(oR0*(oR0+1)/2, 0);
      for(int iR0= 0;iR0<oR0;iR0++){
         for(int jR0=iR0;jR0<oR0;jR0++){
            short i=7;
            R0R0v(iR0,jR0)+=(i<<5);
            R0R0v(iR0,jR0)+=(i<<8);
         }
      }
      o_C7e.resize(3);
      IGO_GFILT(physics_consts,igor_data,out);
//
//
// hash element impulses
//
      IGO_BHASH(igor_data);
      if( iFOLD<3 ){
//
//
// for development, start traj from native composition
//
//       for(int jR0=pR0min;jR0<=pR0max;jR0++){
//          int iR0=(jR0-pR0min);
//          R0[iR0].C7z=str.R0[jR0].C7;
//       }
//
//
// otherwise start from residue Ising model most probable
//
         for(int iR0= 0;iR0<oR0;iR0++){
            R0[iR0].C7z=R0[iR0].C70;
         }
//
//
// ensure breaks in long helicies can be sampled
//
         int zR0(-1),aR0(-1),bR0(-1);
         int mR0(-1),nR0(-1);
         bool jHELIX=false;
         for(int iR0= 0;iR0<oR0;iR0++){
            bool iHELIX=( R0[iR0].C7z==1 );
            if( jHELIX ){
               if( iHELIX ){
                  nR0++;
               }else{
                  if( (nR0-mR0+ 1)>zR0 ){
                     zR0=(nR0-mR0+ 1);
                     aR0=mR0;
                     bR0=nR0;
                  }
               }
            }else{
               if( iHELIX ){
                  mR0=iR0;
                  nR0=iR0;
               }else{
               }
            }
            jHELIX=iHELIX;
         }
         if( zR0> 36 ){
            int iR0=(aR0+bR0)/2;
            R0[iR0   ].C7z=3;
            R0[iR0+ 1].C7z=3;
         }
      }else{
      }
//
//
// search space of element compositions
//
      oG7=128;
      G7.resize(oG7);
      o_G7jR0.resize(oG7+1);
      o_G7kR0.resize(oG7+1);
      o_G7C7d.resize(oG7*3);
      o_G7C7C7d.resize(oG7*9);
      o_G7C7C7C7d.resize(oG7*27);
      o_G7C7C7C7C7d.resize(oG7*81);
      o_G7C7C7C7C7C7d.resize(oG7*243);
      o_G7C7C7C7C7C7C7d.resize(oG7*729);
      o_G7C7o.resize(oG7*3);
      o_G7C7C7o.resize(oG7*9);
      o_G7C7C7C7o.resize(oG7*27);
      o_G7C7C7C7C7o.resize(oG7*81);
      o_G7C7C7C7C7C7o.resize(oG7*243);
      o_G7C7C7C7C7C7C7o.resize(oG7*729);
      o_G7C7C7C7C7C7C7b.resize((oG7+5)*4096, (1.00));
      o_G7mC7.resize(oG7+10);
      o_G7nC7.resize(oG7+10);
      o_G7C7C7C7C7C7y.resize((oG7+6)*1024);
      o_G7C7C7C7C7C7r.resize((oG7+6)*1024);
      o_R0G7.resize(oR0);
      o_G7C7e.resize(oG7*3);
      o_G7C7C7e.resize(oG7*9);
      o_G7C7C7C7e.resize(oG7*27);
      o_G7C7C7C7C7e.resize(oG7*81);
      o_G7C7C7C7C7C7e.resize(oG7*243);
      o_G7C7C7C7C7C7C7e.resize(oG7*729);
      o_G7C7p.resize(oG7*3);
      o_G7C7C7p.resize(oG7*9);
      o_G7C7C7C7p.resize(oG7*27);
      o_G7C7C7C7C7p.resize(oG7*81);
      o_G7C7C7C7C7C7p.resize(oG7*243);
      o_G7C7C7C7C7C7C7p.resize(oG7*729);
      o_G7C7C7C7C7C7C7a.resize((oG7+5)*4096, (1.00));
      o_G7C7C7C7C7C7z.resize((oG7+6)*1024);
      o_G7C7C7C7C7C7q.resize((oG7+6)*1024);
      o_R0R0ef.resize(oR0*(oR0+1)/2, -1);
      o_R0R0hf.resize(oR0*(oR0+1)/2, -1);
//
//
// search through space of compositions without SCORE3
//
      IGO_2TRAJ(physics_consts,igor_data,out);
//
//
// search through space of compositions with SCORE3
// calc SCORE3 over high SCORE chain states
// calc density for SCORE3b +SCORE3c (free energy of patch crosslinks)
//
      IGO_3TRAJ(physics_consts,array_consts,igor_data,out,str);
      o_R0C7e.clear();
      o_R0C7C7e.clear();
      o_R0C7C7C7e.clear();
      o_R0C7C7C7C7e.clear();
      o_R0C7C7C7C7C7e.clear();
      o_R0C7C7C7C7C7C7e.clear();
      o_C7p.clear();
      o_R0R0v.clear();
      o_C7e.clear();
      G7.clear();
      o_G7jR0.clear();
      o_G7kR0.clear();
      o_G7C7d.clear();
      o_G7C7C7d.clear();
      o_G7C7C7C7d.clear();
      o_G7C7C7C7C7d.clear();
      o_G7C7C7C7C7C7d.clear();
      o_G7C7C7C7C7C7C7d.clear();
      o_G7C7o.clear();
      o_G7C7C7o.clear();
      o_G7C7C7C7o.clear();
      o_G7C7C7C7C7o.clear();
      o_G7C7C7C7C7C7o.clear();
      o_G7C7C7C7C7C7C7o.clear();
      o_G7C7C7C7C7C7C7b.clear();
      o_G7mC7.clear();
      o_G7nC7.clear();
      o_G7C7C7C7C7C7y.clear();
      o_G7C7C7C7C7C7r.clear();
      o_R0G7.clear();
      o_G7C7e.clear();
      o_G7C7C7e.clear();
      o_G7C7C7C7e.clear();
      o_G7C7C7C7C7e.clear();
      o_G7C7C7C7C7C7e.clear();
      o_G7C7C7C7C7C7C7e.clear();
      o_G7C7p.clear();
      o_G7C7C7p.clear();
      o_G7C7C7C7p.clear();
      o_G7C7C7C7C7p.clear();
      o_G7C7C7C7C7C7p.clear();
      o_G7C7C7C7C7C7C7p.clear();
      o_G7C7C7C7C7C7C7a.clear();
      o_G7C7C7C7C7C7z.clear();
      o_G7C7C7C7C7C7q.clear();
      o_R0R0ef.clear();
      o_R0R0hf.clear();
   }
//
//
// backbone structures
//
   if( out.VERBOSE ){
      int o=( 16<oK7 )? 16: oK7;
//    for(int iK7=0;iK7<o;iK7++){
//       if( !K7[iK7].PACK )continue;
//       char a1=char('0'+(iK7/10));
//       char a0=char('0'+(iK7%10));
//       std::string filename=
//         "../../"+str.fam+"/car/pck"+a1+a0+"_"+str.mol+".pdb";
//       out.FILE1.open(filename.c_str());
//       out.FILE1<< std::fixed;
//       int ia=0;
//       for(int iR0= 0;iR0<oR0;iR0++){
//          int iL1=R0[iR0].L1;
//          std::string aa=igor_data.L1[iL1].a3;
//          std::string atm=" N  ";
//          ia++;
//          out.FILE1<<"ATOM  "
//                   <<std::setw( 5)<<ia<<' '
//                   <<atm<<' '
//                   <<aa<<' '
//                   <<std::setw( 5)<<(iR0+ 1)<<"    "
//                   <<K7[iK7].R0[iR0].xn<<'\n';
//          atm=" CA ";
//          ia++;
//          out.FILE1<<"ATOM  "
//                   <<std::setw( 5)<<ia<<' '
//                   <<atm<<' '
//                   <<aa<<' '
//                   <<std::setw( 5)<<(iR0+ 1)<<"    "
//                   <<K7[iK7].R0[iR0].xca<<'\n';
//          atm=" C  ";
//          ia++;
//          out.FILE1<<"ATOM  "
//                   <<std::setw( 5)<<ia<<' '
//                   <<atm<<' '
//                   <<aa<<' '
//                   <<std::setw( 5)<<(iR0+ 1)<<"    "
//                   <<K7[iK7].R0[iR0].xc<<'\n';
//          atm=" CB ";
//          ia++;
//          out.FILE1<<"ATOM  "
//                   <<std::setw( 5)<<ia<<' '
//                   <<atm<<' '
//                   <<aa<<' '
//                   <<std::setw( 5)<<(iR0+ 1)<<"    "
//                   <<K7[iK7].R0[iR0].xsc<<'\n';
//       }
//       out.FILE1<<"TER\n";
//       out.FILE1.close();
//    }
//
//
// output high SCORE chain states
//
      out.FILE2<<K7;
   }
   if( out.VERBOSE ){
//
//
// optimal sheet config
//
      if( zM8[ 0].oS8> 1 ){
         out.FILE3<<zM8;
         out.FILE3<<zU8;
         if( zoT8> 0 ){
            out.FILE3<<zT8;
            out.FILE3<<zV8;
         }else{
            out.FILE3<<"NO STABLE SHEET\n";
         }
      }
//
//
// hydrophobic patches
//
      out.FILE3<<zW4;
//
//
// optimal pack config
//
      if( zM9[ 0].oS9> 1 ){
         out.FILE3<<zM9;
         out.FILE3<<zU9;
         if( zoT9> 0 ){
            out.FILE3<<zT9;
         }else{
            out.FILE3<<"NO STABLE FOLD\n";
         }
      }
   }
   return;
}
