#ifndef DEF_TARGET_SURF
#define DEF_TARGET_SURF

#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <vector>
//
//
// target func surface and pack config
//
class Target_Surf {
private:
   std::vector<double> o_U2g;             //1st derivative
   std::vector<double> o_U2U2a;           //2nd derivative
   std::vector<double> o_U2chi;           //generalized coordinates
   std::vector<double> o_U2uca;           //unit of circular arc
   std::vector<int> o_XU2;                //map of X to start index of U2
   std::vector<double> o_Xdgam;           //gam(right)-gam(left)
   std::vector<double> o_Xdy;             //local coord y(right)-y(left)
   std::vector<double> o_Xdz;             //            z(right)-z(left)
   std::vector<double> o_Xr;              //initial distance
   std::vector<double> o_Xthe;            //initial cos(the)=(zi*zj)
   std::vector<int> o_XZ9;                //map config order to chain order
   std::vector<Coordinates> o_XK4u;       //start pos of element
   std::vector<Coordinates> o_XK4v;       //end
   /*alt coords*/
   std::vector<Coordinates> o_XDx;        //local x-axis
   std::vector<Coordinates> o_XDy;        //      y-axis
   std::vector<Coordinates> o_XDz;        //      z-axis
   std::vector<Coordinates> o_XDt;        //pos of local axes
   std::vector<Coordinates> o_XDdx;       //x 1st derivs wrt (alp,bet,gam)
   std::vector<Coordinates> o_XDdy;       //y
   std::vector<Coordinates> o_XDdz;       //z
   std::vector<Coordinates> o_XDdt;       //t 
   std::vector<Coordinates> o_XDddx;      //x 2nd derivs wrt (alp,bet,gam)
   std::vector<Coordinates> o_XDddy;      //y
   std::vector<Coordinates> o_XDddz;      //z
   std::vector<Coordinates> o_XDddt;      //t
   std::vector<double> o_dr;              //1st derivs of r
   std::vector<double> o_ddr;             //2nd derivs
   std::vector<Coordinates> o_dn;         //1st derivs of n=(ti-tj)/r
   std::vector<Coordinates> o_ddn;        //2nd derivs
   std::vector<Coordinates> o_dt;         //1st derivs of t=(ti-tj)
   std::vector<Coordinates> o_dz;         //1st derivs of z=cross(zi,zj)/s
   std::vector<Coordinates> o_ddz;        //2nd derivs
   std::vector<Coordinates> o_dzj;        //1st derivs
   std::vector<Coordinates> o_ddzj;       //2nd derivs
   std::vector<Coordinates> o_dni;        //1st derivs of t=(ti-tj)/r
   std::vector<Coordinates> o_ddni;       //2nd derivs
   std::vector<Coordinates> o_dnk;        //1st derivs of t=(tk-tj)/r
   std::vector<Coordinates> o_ddnk;       //2nd derivs

public:
   int oU2;                               //number of generalized coords
   int oX;                                //number of bods
   double TOT;                            //function (Fa+Fb+Fc+Fd)
   double Fa;                             //[xi*xj=-1]
   double Fb;                             //[xi*(ti-tj)=-1][xj*(tj-ti)=-1]
   double Fc;                             //[(ti-tj).r()=(initial value)]
   double Fd;                             //[(zi*zj)=(initial value)]
   double Fe;                             //enforce separation for bod pair axes
   double Ff;                             //
   double Fg;                             //

   double& U2g(int i){
      return o_U2g.at( i);
   }
   double& U2U2a(int i,int j){
      return o_U2U2a.at( i*oU2 +j);
   }
   double& U2chi(int i){
      return o_U2chi.at( i);
   }
   double& U2uca(int i){
      return o_U2uca.at( i);
   }
   int& XU2(int i){
      return o_XU2.at( i);
   }
   double& Xdgam(int i){
      return o_Xdgam.at( i);
   }
   double& Xdy(int i){
      return o_Xdy.at( i);
   }
   double& Xdz(int i){
      return o_Xdz.at( i);
   }
   double& Xr(int i){
      return o_Xr.at( i);
   }
   double& Xthe(int i){
      return o_Xthe.at( i);
   }
   int& XZ9(int i){
      return o_XZ9.at( i);
   }
   Coordinates& XK4u(int i,int j){
      return o_XK4u.at( i*12 +j);
   }
   Coordinates& XK4v(int i,int j){
      return o_XK4v.at( i*12 +j);
   }
   Coordinates& XDx(int i,int j){
      return o_XDx.at( i*2 +j);
   }
   Coordinates& XDy(int i,int j){
      return o_XDy.at( i*2 +j);
   }
   Coordinates& XDz(int i,int j){
      return o_XDz.at( i*2 +j);
   }
   Coordinates& XDt(int i,int j){
      return o_XDt.at( i*2 +j);
   }
   Coordinates& XDdx(int i,int j,int k){
      return o_XDdx.at( i*6 +j*3 +k);
   }
   Coordinates& XDdy(int i,int j,int k){
      return o_XDdy.at( i*6 +j*3 +k);
   }
   Coordinates& XDdz(int i,int j,int k){
      return o_XDdz.at( i*6 +j*3 +k);
   }
   Coordinates& XDdt(int i,int j,int k){
      return o_XDdt.at( i*6 +j*3 +k);
   }
   Coordinates& XDddx(int i,int j,int k,int l){
      return o_XDddx.at( i*18 +j*9 +k*3 +l);
   }
   Coordinates& XDddy(int i,int j,int k,int l){
      return o_XDddy.at( i*18 +j*9 +k*3 +l);
   }
   Coordinates& XDddz(int i,int j,int k,int l){
      return o_XDddz.at( i*18 +j*9 +k*3 +l);
   }
   Coordinates& XDddt(int i,int j,int k,int l){
      return o_XDddt.at( i*18 +j*9 +k*3 +l);
   }
   double& dr(int i){
      return o_dr.at( i);
   }
   double& ddr(int i,int j){
      return o_ddr.at( i*6 +j);
   }
   Coordinates& dn(int i){
      return o_dn.at( i);
   }
   Coordinates& ddn(int i,int j){
      return o_ddn.at( i*6 +j);
   }
   Coordinates& dt(int i){
      return o_dt.at( i);
   }
   Coordinates& dz(int i){
      return o_dz.at( i);
   }
   Coordinates& ddz(int i,int j){
      return o_ddz.at( i*6 +j);
   }
   Coordinates& dzj(int i){
      return o_dzj.at( i);
   }
   Coordinates& ddzj(int i,int j){
      return o_ddzj.at( i*3 +j);
   }
   Coordinates& dni(int i){
      return o_dni.at( i);
   }
   Coordinates& ddni(int i,int j){
      return o_ddni.at( i*3 +j);
   }
   Coordinates& dnk(int i){
      return o_dnk.at( i);
   }
   Coordinates& ddnk(int i,int j){
      return o_ddnk.at( i*3 +j);
   }

   void IGO_ENQ(const DAT_PHYSICS_CONSTS& physics_consts,
                Output_Streams& out,
                std::vector<Igor_Model::tG7>& G7,
                std::vector<Igor_Model::tZ9>& Z9,
                int COMPONENT);

   Target_Surf(int o,int x):
      oU2(o),
      o_U2g(o),
      o_U2U2a(o*o),
      o_U2chi(o),
      o_U2uca(o),
      oX(x),
      o_XU2(x),
      o_Xdgam(x),
      o_Xdy(x),
      o_Xdz(x),
      o_Xr(x, (0.00)),
      o_Xthe(x, (0.00)),
      o_XZ9(x),
      o_XK4u(x*12),
      o_XK4v(x*12),
      o_XDx(x*2),
      o_XDy(x*2),
      o_XDz(x*2),
      o_XDt(x*2),
      o_XDdx(x*2*3),
      o_XDdy(x*2*3),
      o_XDdz(x*2*3),
      o_XDdt(x*2*3),
      o_XDddx(x*2*3*3),
      o_XDddy(x*2*3*3),
      o_XDddz(x*2*3*3),
      o_XDddt(x*2*3*3),
      o_dr(6),
      o_ddr(6*6),
      o_dn(6),
      o_ddn(6*6),
      o_dt(6),
      o_dz(6),
      o_ddz(6*6),
      o_dzj(3),
      o_ddzj(3*3),
      o_dni(3),
      o_ddni(3*3),
      o_dnk(3),
      o_ddnk(3*3)
   {
   }
};

#endif
