#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <string>
#include <vector>
#include <iostream>
#include <iomanip>
#include <cmath>
//
// G7=
//
void Igor_Model::tG7::operator=(const Igor_Model::tG7& a){
   mR0=a.mR0;
   nR0=a.nR0;
   T7=a.T7;
   V7=a.V7;
   W7=a.W7;
   C70=a.C70;
   for(int i=1;i<4;i++){
      C7p0(i)= a.C7p0(i);
      C7e0(i)= a.C7e0(i);
   }
   return;
}
//
// K7G7=G7
//
void Igor_Model::tK7::tK7G7::operator=(const Igor_Model::tG7& a){
   mR0=a.mR0;
   nR0=a.nR0;
   T7=a.T7;
   C7=a.C70;
   return;
}
//
// Composition
//
Igor_Model::Composition::Composition(int g,
                                     const std::vector<tG7>& a):
   oG7( g),
   G7jR0( g)
{
   for(int iG7=0;iG7<g;iG7++){
      G7jR0[iG7]=a[iG7].nR0;
   }
}
//
// Composition==
//
bool operator==(const Igor_Model::Composition& a,
                const Igor_Model::Composition& b){
   if( a.oG7!=b.oG7 ){
      return false;
   }
   for(int iG7= 0;iG7<b.oG7;iG7++){
      if( a.G7jR0[iG7]!=b.G7jR0[iG7] ){
         return false;
      }
   }
   return true;
}
//
// Composition<
//
bool operator<(const Igor_Model::Composition& a,
               const Igor_Model::Composition& b){
   if      ( a.oG7<b.oG7 ){
      return true;
   }else if( a.oG7>b.oG7 ){
      return false;
   }
   for(int iG7= 0;iG7<b.oG7;iG7++){
      if      ( a.G7jR0[iG7]<b.G7jR0[iG7] ){
         return true;
      }else if( a.G7jR0[iG7]>b.G7jR0[iG7] ){
         return false;
      }
   }
   return false;
}
//
// K7=
//
void Igor_Model::tK7::operator=(const Igor_Model::tK7& a){
   oG7=a.oG7;
   if( int(G7.size())!=oG7 ){
      G7.clear();
      G7.resize(oG7);
   }
   for(int iG7=0;iG7<oG7;iG7++){
      G7[iG7].mR0=a.G7[iG7].mR0;
      G7[iG7].nR0=a.G7[iG7].nR0;
      G7[iG7].T7=a.G7[iG7].T7;
      G7[iG7].C7=a.G7[iG7].C7;
   }
   for(int i=0;i<9;i++){
      e[i]= a.e[i];
   }
   oR0=a.oR0;
   if( int(R0.size())!=oR0 ){
      R0.clear();
      R0.resize(oR0);
   }
   PACK=a.PACK;
   if( PACK ){
      for(int iR0=0;iR0<oR0;iR0++){
         R0[iR0].xca=a.R0[iR0].xca;
         R0[iR0].xn=a.R0[iR0].xn;
         R0[iR0].xc=a.R0[iR0].xc;
         R0[iR0].xsc=a.R0[iR0].xsc;
         R0[iR0].b=a.R0[iR0].b;
      }
   }
   e3= a.e3;
   b=a.b;
   K7ord=a.K7ord;
   return;
}
//
// K7==
//
bool operator==(const Igor_Model::tK7& a,
                const Igor_Model::tK7& b){
   if( b.oG7!=a.oG7 ){
      return false;
   }
   for(int iG7= 0;iG7<b.oG7;iG7++){
      if( b.G7[iG7].nR0!=a.G7[iG7].nR0 )return false;
   }
   return true;
}
//
// Composition bcomp
//
bool bcomp(const Igor_Model::tK7& a,
           const Igor_Model::tK7& b){
   if( b.oG7!=a.oG7 ){
      return false;
   }else{
      int o=b.oG7;
      for(int iG7=0;iG7<o;iG7++){
         if( b.G7[iG7].C7!=a.G7[iG7].C7 ){
            return false;
         }
      }
      return true;
   }
}
//
// Composition dcomp
//
int dcomp(const Igor_Model::tK7& a,
          const Igor_Model::tK7& b){
   if( b.oG7!=a.oG7 ){
      return 99;
   }else{
      int n=0;
      int o=(b.oG7-1);
      for(int iG7=0;iG7<o;iG7++){
         int j=(b.G7[iG7].nR0-a.G7[iG7].nR0);
         if      ( j<-2 ){
            return 99;
         }else if( j> 2 ){
            return 99;
         }else if( j< 0 ){
            n-=j;
         }else{
            n+=j;
         }
      }
      return n;
   }
}
//
// Q8=Y8
//
void Igor_Model::tQ8::operator=(const Igor_Model::tY8& a){
   oZ8=a.oZ8;
   oD8=a.oD8;
   D8.resize(oD8);
   for(int iD8= 0;iD8<oD8;iD8++){
      D8[iD8].e[ 0]= a.D8[iD8].e[ 0];
      D8[iD8].e[ 1]= a.D8[iD8].e[ 1];
      D8[iD8].e[ 2]= a.D8[iD8].e[ 2];
      D8[iD8].Z8.resize(oZ8);
      for(int iZ8= 0;iZ8<oZ8;iZ8++){
         D8[iD8].Z8[iZ8].X=a.D8[iD8].Z8[iZ8].X;
         D8[iD8].Z8[iZ8].e= a.D8[iD8].Z8[iZ8].e;
         D8[iD8].Z8[iZ8].A=a.D8[iD8].Z8[iZ8].A;
         D8[iD8].Z8[iZ8].B=a.D8[iD8].Z8[iZ8].B;
      }
   }
   return;
}
//
// W4=
//
void Igor_Model::tW4::operator=(const Igor_Model::tW4& a){
   oJ4=a.oJ4;
   if( int(J4.size())!=oJ4 ){
      J4.clear();
      J4.resize(oJ4);
   }
   O1=a.O1;
   hp=a.hp;
   P3=a.P3;
   R0=a.R0;
   L=a.L;
   N=a.N;
   oK4=a.oK4;
   if( int(K4.size())!=oK4 ){
      K4.clear();
      K4.resize(oK4);
   }
   oX=a.oX;
   oY=a.oY;
   h= a.h;
   PAR=a.PAR;
   pen=a.pen;
   for(int iJ4= 0;iJ4<oJ4;iJ4++){
      J4[iJ4].R0=a.J4[iJ4].R0;
      J4[iJ4].a1=a.J4[iJ4].a1;
   }
   for(int iK4= 0;iK4<oK4;iK4++){
      K4[iK4].G7=a.K4[iK4].G7;
      K4[iK4].X=a.K4[iK4].X;
      K4[iK4].Y=a.K4[iK4].Y;
      K4[iK4].sgnx=a.K4[iK4].sgnx;
      K4[iK4].sgny=a.K4[iK4].sgny;
   }
   return;
}
//
// M8=
//
void Igor_Model::tM8::operator=(const Igor_Model::tM8& a){
   oS8=a.oS8;
   if( int(S8.size())!=oS8 ){
      S8.clear();
      S8.resize(oS8);
   }
   for(int iS8= 0;iS8<oS8;iS8++){
      S8[iS8].G7=a.S8[iS8].G7;
   }
   return;
}
//
// Y8=
//
void Igor_Model::tY8::operator=(const Igor_Model::tY8& a){
   oZ8=a.oZ8;
   oD8=a.oD8;
   if( int(D8.size())!=oD8 ){
      D8.clear();
      D8.resize(oD8);
   }
   for(int iD8= 0;iD8<oD8;iD8++){
      D8[iD8].e[ 0]= a.D8[iD8].e[ 0];
      D8[iD8].e[ 1]= a.D8[iD8].e[ 1];
      D8[iD8].e[ 2]= a.D8[iD8].e[ 2];
      D8[iD8].e[ 3]= (0.00);
      D8[iD8].e[ 4]= (0.00);
      D8[iD8].e[ 5]= (0.00);
      if( int(D8[iD8].Z8.size())!=oZ8 ){
         D8[iD8].Z8.clear();
         D8[iD8].Z8.resize(oZ8);
      }
      for(int iZ8= 0;iZ8<oZ8;iZ8++){
         D8[iD8].Z8[iZ8].X=a.D8[iD8].Z8[iZ8].X;
         D8[iD8].Z8[iZ8].e= a.D8[iD8].Z8[iZ8].e;
         D8[iD8].Z8[iZ8].A=a.D8[iD8].Z8[iZ8].A;
         D8[iD8].Z8[iZ8].B=a.D8[iD8].Z8[iZ8].B;
      }
   }
   return;
}
//
// Y8=Q8
//
void Igor_Model::tY8::operator=(const Igor_Model::tQ8& a){
   oZ8=a.oZ8;
   oD8=a.oD8;
   if( int(D8.size())!=oD8 ){
      D8.clear();
      D8.resize(oD8);
   }
   for(int iD8= 0;iD8<oD8;iD8++){
      D8[iD8].e[ 0]= a.D8[iD8].e[ 0];
      D8[iD8].e[ 1]= a.D8[iD8].e[ 1];
      D8[iD8].e[ 2]= a.D8[iD8].e[ 2];
      D8[iD8].e[ 3]= (0.00);
      D8[iD8].e[ 4]= (0.00);
      D8[iD8].e[ 5]= (0.00);
      if( int(D8[iD8].Z8.size())!=oZ8 ){
         D8[iD8].Z8.clear();
         D8[iD8].Z8.resize(oZ8);
      }
      for(int iZ8= 0;iZ8<oZ8;iZ8++){
         D8[iD8].Z8[iZ8].X=a.D8[iD8].Z8[iZ8].X;
         D8[iD8].Z8[iZ8].e= a.D8[iD8].Z8[iZ8].e;
         D8[iD8].Z8[iZ8].A=a.D8[iD8].Z8[iZ8].A;
         D8[iD8].Z8[iZ8].B=a.D8[iD8].Z8[iZ8].B;
      }
   }
   return;
}
//
// U8Y8=Y8D8
//
void Igor_Model::tU8::tU8Y8::operator=(const Igor_Model::tY8::tY8D8& a){
   for(int i=0;i<3;i++){
      e[ i]= a.e[ i];
   }
   int oZ8=a.Z8.size();
   for(int iZ8= 0;iZ8<oZ8;iZ8++){
      Z8[iZ8].X=a.Z8[iZ8].X;
      Z8[iZ8].e= a.Z8[iZ8].e;
      Z8[iZ8].A=a.Z8[iZ8].A;
      Z8[iZ8].B=a.Z8[iZ8].B;
   }
   STABLE=true;
   return;
}
//
// U8=
//
void Igor_Model::tU8::operator=(const Igor_Model::tU8& a){
   oY8=a.oY8;
   if( int(Y8.size())!=oY8 ){
      Y8.clear();
      Y8.resize(oY8);
   }
   for(int iY8= 0;iY8<oY8;iY8++){
      Y8[iY8].STABLE=a.Y8[iY8].STABLE;
      Y8[iY8].FACTOR=a.Y8[iY8].FACTOR;
      for(int i=0;i<3;i++){
         Y8[iY8].e[ i]= a.Y8[iY8].e[ i];
      }
      int oZ8=a.Y8[iY8].Z8.size();
      if( int(Y8[iY8].Z8.size())!=oZ8 ){
         Y8[iY8].Z8.clear();
         Y8[iY8].Z8.resize(oZ8);
      }
      for(int iZ8= 0;iZ8<oZ8;iZ8++){
         Y8[iY8].Z8[iZ8].S8=a.Y8[iY8].Z8[iZ8].S8;
         Y8[iY8].Z8[iZ8].Y8=a.Y8[iY8].Z8[iZ8].Y8;
         Y8[iY8].Z8[iZ8].X=a.Y8[iY8].Z8[iZ8].X;
         Y8[iY8].Z8[iZ8].e= a.Y8[iY8].Z8[iZ8].e;
         Y8[iY8].Z8[iZ8].A=a.Y8[iY8].Z8[iZ8].A;
         Y8[iY8].Z8[iZ8].B=a.Y8[iY8].Z8[iZ8].B;
      }
   }
   return;
}
//
// Y8D8 swap
//
void Igor_Model::tY8::tY8D8::swap(tY8::tY8D8& a){
   for(int i=0;i<6;i++){
      double z= a.e[ i];
      a.e[ i]= e[ i];
      e[ i]= z;
   }
   int oZ8=a.Z8.size();
   for(int iZ8= 0;iZ8<oZ8;iZ8++){
      char j=a.Z8[iZ8].X;
      a.Z8[iZ8].X=Z8[iZ8].X;
      Z8[iZ8].X=j;
      float e= a.Z8[iZ8].e;
      a.Z8[iZ8].e= Z8[iZ8].e;
      Z8[iZ8].e= e;
      j=a.Z8[iZ8].A;
      a.Z8[iZ8].A=Z8[iZ8].A;
      Z8[iZ8].A=j;
      j=a.Z8[iZ8].B;
      a.Z8[iZ8].B=Z8[iZ8].B;
      Z8[iZ8].B=j;
   }
   return;
}
//
// T8 swap
//
void Igor_Model::tT8::swap(tT8& a){
   int j=a.U8;
   a.U8=U8;
   U8=j;
   j=a.Y8;
   a.Y8=Y8;
   Y8=j;
   for(int i=0;i<3;i++){
      double z= a.e[ i];
      a.e[ i]= e[ i];
      e[ i]= z;
   }
   return;
}
//
// T8=
//
void Igor_Model::tT8::operator=(const Igor_Model::tT8& a){
   U8=a.U8;
   Y8=a.Y8;
   sub=a.sub;
   for(int i=0;i<3;i++){
      e[i]= a.e[i];
   }
   return;
}
//
// V8=
//
void Igor_Model::tV8::operator=(const Igor_Model::tV8& a){
   lX=a.lX;
   uX=a.uX;
   lY=a.lY;
   uY=a.uY;
   if( int(o_X.size())!=(uX-lX+ 1) ){
      o_X.clear();
      o_X.resize(uX-lX+ 1);
   }
   for(int iX=lX;iX<=uX;iX++){
      X(iX).head0=a.X(iX).head0;
      X(iX).head1=a.X(iX).head1;
      X(iX).head2=a.X(iX).head2;
   }
   if( int(o_XY.size())!=(uX-lX+ 1)*(uY-lY+ 1) ){
      o_XY.clear();
      o_XY.resize((uX-lX+ 1)*(uY-lY+ 1));
   }
   for(int iX=lX;iX<=uX;iX++){
      for(int iY=lY;iY<=uY;iY++){
         XY(iX,iY).alp=a.XY(iX,iY).alp;
      }
   }
   return;
}
//
// M9=
//
void Igor_Model::tM9::operator=(const Igor_Model::tM9& a){
   oS9=a.oS9;
   if( int(S9.size())!=oS9 ){
      S9.clear();
      S9.resize(oS9);
   }
   for(int iS9= 0;iS9<oS9;iS9++){
      int oB4=a.S9[iS9].oB4;
      S9[iS9].oB4=oB4;
      if( int(S9[iS9].B4.size())!=oB4 ){
         S9[iS9].B4.clear();
         S9[iS9].B4.resize(oB4);
      }
      for(int iB4= 0;iB4<oB4;iB4++){
         S9[iS9].B4[iB4].W4=a.S9[iS9].B4[iB4].W4;
      }
      int oK4=a.S9[iS9].oK4;
      S9[iS9].oK4=oK4;
      if( int(S9[iS9].K4.size())!=oK4 ){
         S9[iS9].K4.clear();
         S9[iS9].K4.resize(oK4);
      }
      for(int iK4= 0;iK4<oK4;iK4++){
         S9[iS9].K4[iK4].G7=a.S9[iS9].K4[iK4].G7;
         S9[iS9].K4[iK4].X=a.S9[iS9].K4[iK4].X;
         S9[iS9].K4[iK4].Y=a.S9[iS9].K4[iK4].Y;
         S9[iS9].K4[iK4].sgnx=a.S9[iS9].K4[iK4].sgnx;
         S9[iS9].K4[iK4].sgny=a.S9[iS9].K4[iK4].sgny;
      }
   }
   return;
}
//
// Y9D9 swap
//
void Igor_Model::tY9::tY9D9::swap(tY9::tY9D9& a){
   for(int i=0;i<4;i++){
      double z= a.e[ i];
      a.e[ i]= e[ i];
      e[ i]= z;
   }
   int oZ9=a.Z9.size();
   for(int iZ9= 0;iZ9<oZ9;iZ9++){
      char j=a.Z9[iZ9].X;
      a.Z9[iZ9].X=Z9[iZ9].X;
      Z9[iZ9].X=j;
      float e= a.Z9[iZ9].e;
      a.Z9[iZ9].e= Z9[iZ9].e;
      Z9[iZ9].e= e;
      short k=a.Z9[iZ9].A;
      a.Z9[iZ9].A=Z9[iZ9].A;
      Z9[iZ9].A=k;
      k=a.Z9[iZ9].B;
      a.Z9[iZ9].B=Z9[iZ9].B;
      Z9[iZ9].B=k;
      Rotation_Matrix r=a.Z9[iZ9].c;
      a.Z9[iZ9].c=Z9[iZ9].c;
      Z9[iZ9].c=r;
      Coordinates x=a.Z9[iZ9].t;
      a.Z9[iZ9].t=Z9[iZ9].t;
      Z9[iZ9].t=x;
      int oK4=a.Z9[iZ9].K4.size();
      for(int iK4=0;iK4<oK4;iK4++){
         k=a.Z9[iZ9].K4[iK4].G7;
         a.Z9[iZ9].K4[iK4].G7=Z9[iZ9].K4[iK4].G7;
         Z9[iZ9].K4[iK4].G7=k;
         j=a.Z9[iZ9].K4[iK4].X;
         a.Z9[iZ9].K4[iK4].X=Z9[iZ9].K4[iK4].X;
         Z9[iZ9].K4[iK4].X=j;
         j=a.Z9[iZ9].K4[iK4].Y;
         a.Z9[iZ9].K4[iK4].Y=Z9[iZ9].K4[iK4].Y;
         Z9[iZ9].K4[iK4].Y=j;
         j=a.Z9[iZ9].K4[iK4].sgnx;
         a.Z9[iZ9].K4[iK4].sgnx=Z9[iZ9].K4[iK4].sgnx;
         Z9[iZ9].K4[iK4].sgnx=j;
         j=a.Z9[iZ9].K4[iK4].sgny;
         a.Z9[iZ9].K4[iK4].sgny=Z9[iZ9].K4[iK4].sgny;
         Z9[iZ9].K4[iK4].sgny=j;
         x=a.Z9[iZ9].K4[iK4].u;
         a.Z9[iZ9].K4[iK4].u=Z9[iZ9].K4[iK4].u;
         Z9[iZ9].K4[iK4].u=x;
         x=a.Z9[iZ9].K4[iK4].v;
         a.Z9[iZ9].K4[iK4].v=Z9[iZ9].K4[iK4].v;
         Z9[iZ9].K4[iK4].v=x;
         r=a.Z9[iZ9].K4[iK4].r;
         a.Z9[iZ9].K4[iK4].r=Z9[iZ9].K4[iK4].r;
         Z9[iZ9].K4[iK4].r=r;
      }
   }
   for(int iQ=0;iQ<4;iQ++){
      Rotation_Matrix r=a.Q[iQ].r;
      a.Q[iQ].r=Q[iQ].r;
      Q[iQ].r=r;
      Coordinates x=a.Q[iQ].t;
      a.Q[iQ].t=Q[iQ].t;
      Q[iQ].t=x;
   }
   return;
}
//
// Q9=Y9
//
void Igor_Model::tQ9::operator=(const Igor_Model::tY9& a){
   oZ9=a.oZ9;
   oD9=a.oD9;
   if( int(D9.size())!=oD9 ){
      D9.clear();
      D9.resize(oD9);
   }
   for(int iD9= 0;iD9<oD9;iD9++){
      for(int i=0;i<4;i++){
         D9[iD9].e[i]= a.D9[iD9].e[i];
      }
      if( int(D9[iD9].Z9.size())!=oZ9 ){
         D9[iD9].Z9.clear();
         D9[iD9].Z9.resize(oZ9);
      }
      for(int iZ9= 0;iZ9<oZ9;iZ9++){
         D9[iD9].Z9[iZ9].X=a.D9[iD9].Z9[iZ9].X;
         D9[iD9].Z9[iZ9].e= a.D9[iD9].Z9[iZ9].e;
         D9[iD9].Z9[iZ9].A=a.D9[iD9].Z9[iZ9].A;
         D9[iD9].Z9[iZ9].B=a.D9[iD9].Z9[iZ9].B;
         D9[iD9].Z9[iZ9].c=a.D9[iD9].Z9[iZ9].c;
         D9[iD9].Z9[iZ9].t=a.D9[iD9].Z9[iZ9].t;
         int oK4=a.D9[iD9].Z9[iZ9].K4.size();
         if( int(D9[iD9].Z9[iZ9].K4.size())!=oK4 ){
            D9[iD9].Z9[iZ9].K4.clear();
            D9[iD9].Z9[iZ9].K4.resize(oK4);
         }
         for(int iK4=0;iK4<oK4;iK4++){
            D9[iD9].Z9[iZ9].K4[iK4].G7=a.D9[iD9].Z9[iZ9].K4[iK4].G7;
            D9[iD9].Z9[iZ9].K4[iK4].X=a.D9[iD9].Z9[iZ9].K4[iK4].X;
            D9[iD9].Z9[iZ9].K4[iK4].Y=a.D9[iD9].Z9[iZ9].K4[iK4].Y;
            D9[iD9].Z9[iZ9].K4[iK4].sgnx=a.D9[iD9].Z9[iZ9].K4[iK4].sgnx;
            D9[iD9].Z9[iZ9].K4[iK4].sgny=a.D9[iD9].Z9[iZ9].K4[iK4].sgny;
            D9[iD9].Z9[iZ9].K4[iK4].u=a.D9[iD9].Z9[iZ9].K4[iK4].u;
            D9[iD9].Z9[iZ9].K4[iK4].v=a.D9[iD9].Z9[iZ9].K4[iK4].v;
            D9[iD9].Z9[iZ9].K4[iK4].r=a.D9[iD9].Z9[iZ9].K4[iK4].r;
         }
      }
      for(int iQ=0;iQ<4;iQ++){
         D9[iD9].Q[iQ].r=a.D9[iD9].Q[iQ].r;
         D9[iD9].Q[iQ].t=a.D9[iD9].Q[iQ].t;
      }
   }
   return;
}
//
// Y9=
//
void Igor_Model::tY9::operator=(const Igor_Model::tY9& a){
   oZ9=a.oZ9;
   oD9=a.oD9;
   if( int(D9.size())!=oD9 ){
      D9.clear();
      D9.resize(oD9);
   }
   for(int iD9= 0;iD9<oD9;iD9++){
      for(int i=0;i<4;i++){
         D9[iD9].e[i]= a.D9[iD9].e[i];
      }
      if( int(D9[iD9].Z9.size())!=oZ9 ){
         D9[iD9].Z9.clear();
         D9[iD9].Z9.resize(oZ9);
      }
      for(int iZ9= 0;iZ9<oZ9;iZ9++){
         D9[iD9].Z9[iZ9].X=a.D9[iD9].Z9[iZ9].X;
         D9[iD9].Z9[iZ9].e= a.D9[iD9].Z9[iZ9].e;
         D9[iD9].Z9[iZ9].A=a.D9[iD9].Z9[iZ9].A;
         D9[iD9].Z9[iZ9].B=a.D9[iD9].Z9[iZ9].B;
         D9[iD9].Z9[iZ9].c=a.D9[iD9].Z9[iZ9].c;
         D9[iD9].Z9[iZ9].t=a.D9[iD9].Z9[iZ9].t;
         int oK4=a.D9[iD9].Z9[iZ9].K4.size();
         if( int(D9[iD9].Z9[iZ9].K4.size())!=oK4 ){
            D9[iD9].Z9[iZ9].K4.clear();
            D9[iD9].Z9[iZ9].K4.resize(oK4);
         }
         for(int iK4=0;iK4<oK4;iK4++){
            D9[iD9].Z9[iZ9].K4[iK4].G7=a.D9[iD9].Z9[iZ9].K4[iK4].G7;
            D9[iD9].Z9[iZ9].K4[iK4].X=a.D9[iD9].Z9[iZ9].K4[iK4].X;
            D9[iD9].Z9[iZ9].K4[iK4].Y=a.D9[iD9].Z9[iZ9].K4[iK4].Y;
            D9[iD9].Z9[iZ9].K4[iK4].sgnx=a.D9[iD9].Z9[iZ9].K4[iK4].sgnx;
            D9[iD9].Z9[iZ9].K4[iK4].sgny=a.D9[iD9].Z9[iZ9].K4[iK4].sgny;
            D9[iD9].Z9[iZ9].K4[iK4].u=a.D9[iD9].Z9[iZ9].K4[iK4].u;
            D9[iD9].Z9[iZ9].K4[iK4].v=a.D9[iD9].Z9[iZ9].K4[iK4].v;
            D9[iD9].Z9[iZ9].K4[iK4].r=a.D9[iD9].Z9[iZ9].K4[iK4].r;
         }
      }
      for(int iQ=0;iQ<4;iQ++){
         D9[iD9].Q[iQ].r=a.D9[iD9].Q[iQ].r;
         D9[iD9].Q[iQ].t=a.D9[iD9].Q[iQ].t;
      }
   }
   return;
}
//
// Y9=Q9
//
void Igor_Model::tY9::operator=(const Igor_Model::tQ9& a){
   oZ9=a.oZ9;
   oD9=a.oD9;
   if( int(D9.size())!=oD9 ){
      D9.clear();
      D9.resize(oD9);
   }
   for(int iD9= 0;iD9<oD9;iD9++){
      for(int i=0;i<4;i++){
         D9[iD9].e[i]= a.D9[iD9].e[i];
      }
      if( int(D9[iD9].Z9.size())!=oZ9 ){
         D9[iD9].Z9.clear();
         D9[iD9].Z9.resize(oZ9);
      }
      for(int iZ9= 0;iZ9<oZ9;iZ9++){
         D9[iD9].Z9[iZ9].X=a.D9[iD9].Z9[iZ9].X;
         D9[iD9].Z9[iZ9].e= a.D9[iD9].Z9[iZ9].e;
         D9[iD9].Z9[iZ9].A=a.D9[iD9].Z9[iZ9].A;
         D9[iD9].Z9[iZ9].B=a.D9[iD9].Z9[iZ9].B;
         D9[iD9].Z9[iZ9].c=a.D9[iD9].Z9[iZ9].c;
         D9[iD9].Z9[iZ9].t=a.D9[iD9].Z9[iZ9].t;
         int oK4=a.D9[iD9].Z9[iZ9].K4.size();
         if( int(D9[iD9].Z9[iZ9].K4.size())!=oK4 ){
            D9[iD9].Z9[iZ9].K4.clear();
            D9[iD9].Z9[iZ9].K4.resize(oK4);
         }
         for(int iK4=0;iK4<oK4;iK4++){
            D9[iD9].Z9[iZ9].K4[iK4].G7=a.D9[iD9].Z9[iZ9].K4[iK4].G7;
            D9[iD9].Z9[iZ9].K4[iK4].X=a.D9[iD9].Z9[iZ9].K4[iK4].X;
            D9[iD9].Z9[iZ9].K4[iK4].Y=a.D9[iD9].Z9[iZ9].K4[iK4].Y;
            D9[iD9].Z9[iZ9].K4[iK4].sgnx=a.D9[iD9].Z9[iZ9].K4[iK4].sgnx;
            D9[iD9].Z9[iZ9].K4[iK4].sgny=a.D9[iD9].Z9[iZ9].K4[iK4].sgny;
            D9[iD9].Z9[iZ9].K4[iK4].u=a.D9[iD9].Z9[iZ9].K4[iK4].u;
            D9[iD9].Z9[iZ9].K4[iK4].v=a.D9[iD9].Z9[iZ9].K4[iK4].v;
            D9[iD9].Z9[iZ9].K4[iK4].r=a.D9[iD9].Z9[iZ9].K4[iK4].r;
         }
      }
      for(int iQ=0;iQ<4;iQ++){
         D9[iD9].Q[iQ].r=a.D9[iD9].Q[iQ].r;
         D9[iD9].Q[iQ].t=a.D9[iD9].Q[iQ].t;
      }
   }
   return;
}
//
// U9Y9=Y9D9
//
void Igor_Model::tU9::tU9Y9::operator=(const Igor_Model::tY9::tY9D9& a){
   for(int i=0;i<4;i++){
      e[ i]= a.e[ i];
   }
   int oZ9=a.Z9.size();
   for(int iZ9= 0;iZ9<oZ9;iZ9++){
      Z9[iZ9].X=a.Z9[iZ9].X;
      Z9[iZ9].e= a.Z9[iZ9].e;
      Z9[iZ9].A=a.Z9[iZ9].A;
      Z9[iZ9].B=a.Z9[iZ9].B;
      Z9[iZ9].c=a.Z9[iZ9].c;
      Z9[iZ9].t=a.Z9[iZ9].t;
      int oK4=a.Z9[iZ9].K4.size();
      if( int(Z9[iZ9].K4.size())!=oK4 ){
         Z9[iZ9].K4.clear();
         Z9[iZ9].K4.resize(oK4);
         Z9[iZ9].oK4=oK4;
      }
      for(int iK4= 0;iK4<oK4;iK4++){
         Z9[iZ9].K4[iK4].G7=a.Z9[iZ9].K4[iK4].G7;
         Z9[iZ9].K4[iK4].X=a.Z9[iZ9].K4[iK4].X;
         Z9[iZ9].K4[iK4].Y=a.Z9[iZ9].K4[iK4].Y;
         Z9[iZ9].K4[iK4].sgnx=a.Z9[iZ9].K4[iK4].sgnx;
         Z9[iZ9].K4[iK4].sgny=a.Z9[iZ9].K4[iK4].sgny;
         Z9[iZ9].K4[iK4].u=a.Z9[iZ9].K4[iK4].u;
         Z9[iZ9].K4[iK4].v=a.Z9[iZ9].K4[iK4].v;
         Z9[iZ9].K4[iK4].r=a.Z9[iZ9].K4[iK4].r;
      }
   }
   for(int iQ=0;iQ<4;iQ++){
      Q[iQ].r=a.Q[iQ].r;
      Q[iQ].t=a.Q[iQ].t;
   }
   STABLE=true;
   return;
}
//
// U9=
//
void Igor_Model::tU9::operator=(const Igor_Model::tU9& a){
   oY9=a.Y9.size();
   if( int(Y9.size())!=oY9 ){
      Y9.clear();
      Y9.resize(oY9);
   }
   for(int iY9= 0;iY9<oY9;iY9++){
      Y9[iY9].STABLE=a.Y9[iY9].STABLE;
      Y9[iY9].FACTOR=a.Y9[iY9].FACTOR;
      for(int i=0;i<4;i++){
         Y9[iY9].e[ i]= a.Y9[iY9].e[ i];
      }
      int oZ9=a.Y9[iY9].Z9.size();
      if( int(Y9[iY9].Z9.size())!=oZ9 ){
         Y9[iY9].Z9.clear();
         Y9[iY9].Z9.resize(oZ9);
      }
      for(int iZ9= 0;iZ9<oZ9;iZ9++){
         Y9[iY9].Z9[iZ9].S9=a.Y9[iY9].Z9[iZ9].S9;
         Y9[iY9].Z9[iZ9].Y9=a.Y9[iY9].Z9[iZ9].Y9;
         Y9[iY9].Z9[iZ9].X=a.Y9[iY9].Z9[iZ9].X;
         Y9[iY9].Z9[iZ9].e= a.Y9[iY9].Z9[iZ9].e;
         Y9[iY9].Z9[iZ9].A=a.Y9[iY9].Z9[iZ9].A;
         Y9[iY9].Z9[iZ9].B=a.Y9[iY9].Z9[iZ9].B;
         Y9[iY9].Z9[iZ9].c=a.Y9[iY9].Z9[iZ9].c;
         Y9[iY9].Z9[iZ9].t=a.Y9[iY9].Z9[iZ9].t;
         int oK4=a.Y9[iY9].Z9[iZ9].K4.size();
         if( int(Y9[iY9].Z9[iZ9].K4.size())!=oK4 ){
            Y9[iY9].Z9[iZ9].K4.clear();
            Y9[iY9].Z9[iZ9].K4.resize(oK4);
            Y9[iY9].Z9[iZ9].oK4=oK4;
         }
         for(int iK4= 0;iK4<oK4;iK4++){
            Y9[iY9].Z9[iZ9].K4[iK4].G7=a.Y9[iY9].Z9[iZ9].K4[iK4].G7;
            Y9[iY9].Z9[iZ9].K4[iK4].X=a.Y9[iY9].Z9[iZ9].K4[iK4].X;
            Y9[iY9].Z9[iZ9].K4[iK4].Y=a.Y9[iY9].Z9[iZ9].K4[iK4].Y;
            Y9[iY9].Z9[iZ9].K4[iK4].sgnx=a.Y9[iY9].Z9[iZ9].K4[iK4].sgnx;
            Y9[iY9].Z9[iZ9].K4[iK4].sgny=a.Y9[iY9].Z9[iZ9].K4[iK4].sgny;
            Y9[iY9].Z9[iZ9].K4[iK4].u=a.Y9[iY9].Z9[iZ9].K4[iK4].u;
            Y9[iY9].Z9[iZ9].K4[iK4].v=a.Y9[iY9].Z9[iZ9].K4[iK4].v;
            Y9[iY9].Z9[iZ9].K4[iK4].r=a.Y9[iY9].Z9[iZ9].K4[iK4].r;
         }
      }
      for(int iQ=0;iQ<4;iQ++){
         Y9[iY9].Q[iQ].r=a.Y9[iY9].Q[iQ].r;
         Y9[iY9].Q[iQ].t=a.Y9[iY9].Q[iQ].t;
      }
   }
   return;
}
//
// T9 swap
//
void Igor_Model::tT9::swap(tT9& a){
   int j=a.U9;
   a.U9=U9;
   U9=j;
   j=a.Y9;
   a.Y9=Y9;
   Y9=j;
   for(int i=0;i<4;i++){
      double z= a.e[ i];
      a.e[ i]= e[ i];
      e[ i]= z;
   }
   return;
}
//
// T9=
//
void Igor_Model::tT9::operator=(const Igor_Model::tT9& a){
   U9=a.U9;
   Y9=a.Y9;
   sub=a.sub;
   for(int i=0;i<4;i++){
      e[i]= a.e[i];
   }
   return;
}
//
//
// write
//
std::ostream& operator<<(std::ostream& os,
                         const std::vector<Igor_Model::tK7>& a){
   os<< std::fixed<< std::setprecision( 3);
   std::string cnf=" HEC";
   std::string typ=" tuvwabcpqrdefghi";
   int oK7=a.size();
   os<<" iK7   SCORE    SCO0     SCO1  "
           "   SCO1b    SCO2     SCO2b "
           "   SCO3     SCO3b    SCO3c \n";
   for(int iK7= 0;iK7<oK7;iK7++){
      if( a[iK7].e[ 0]<=(-1.00e+5) )break;;
      int oG7=a[iK7].oG7;
      os<<std::setw( 4)<<iK7;
      for(int i=0;i<9;i++){
         os<<std::setw( 9)<<a[iK7].e[ i];
      }
      os<<'\n';
      os<<std::setw( 4)<<oG7<<'\n';
      for(int iG7= 0;iG7<oG7;iG7++){
         char a1=typ[a[iK7].G7[iG7].T7];
         os<<a1;
         if( ((iG7+ 1)%80==0)||(iG7==(oG7-1)) ){
            os<<'\n';
         }
      }
      int oR0=a[iK7].oR0;
      for(int iG7= 0;iG7<oG7;iG7++){
         char a1=cnf[a[iK7].G7[iG7].C7];
         int mR0=a[iK7].G7[iG7].mR0;
         int nR0=a[iK7].G7[iG7].nR0;
         for(int iR0=mR0;iR0<=nR0;iR0++){
            os<<a1;
            if( ((iR0+ 1)%80==0)||(iR0==(oR0-1)) ){
               os<<'\n';
            }
         }
      }
   }
   return os;
}
std::ostream& operator<<(std::ostream& os,
                         const std::vector<Igor_Model::tW4>& a){
   os<<"HYDROPHOBIC PATCHES\n";
   os<< std::fixed<< std::setprecision(3);
   int oW4=a.size();
   os<<"oW4\n";
   os<<std::setw( 3)<<oW4<<'\n';
   os<<" W4 C O N  P  R hp oJ   patch     h     pen  oK[    K4G7]\n";
   for(int iW4= 0;iW4<oW4;iW4++){
      int oJ4=a[iW4].oJ4;
      int oK4=a[iW4].oK4;
      std::string patch="        ";
      for(int iJ4= 0;iJ4<oJ4;iJ4++){
         patch[iJ4]=a[iW4].J4[iJ4].a1;
      }
      char c=( oK4== 1 )? 'H': 'E';
      os<<std::setw( 3)<<iW4
        <<std::setw( 2)<<' '<<c
        <<std::setw( 2)<<a[iW4].O1
        <<std::setw( 2)<<a[iW4].N
        <<std::setw( 3)<<a[iW4].P3
        <<std::setw( 3)<<a[iW4].R0
        <<std::setw( 3)<<a[iW4].hp
        <<std::setw( 3)<<a[iW4].oJ4<<' '
        <<patch
        <<std::setw( 7)<<a[iW4].h
        <<std::setw( 7)<<a[iW4].pen
        <<std::setw( 3)<<a[iW4].oK4<<'[';
      for(int iK4= 0;iK4<oK4;iK4++){
         os<<std::setw( 4)<<a[iW4].K4[iK4].G7;
      }
      os<<"]\n";
   }
   return os;
}
std::ostream& operator<<(std::ostream& os,
                         const std::vector<Igor_Model::tM8>& a){
   os<<"1ST PASS PARTITION OF STRANDS\n";
   int oM8=a.size();
   os<<"oM8\n";
   os<<std::setw( 3)<<oM8<<'\n';
   os<<" M8 oS8|  S8G7\n";
   for(int iM8= 0;iM8<oM8;iM8++){
      int oS8=a[iM8].oS8;
      os<<std::setw( 3)<<iM8
        <<std::setw( 4)<<oS8<<'|';
      for(int iS8=0;iS8<oS8;iS8++){
         os<<std::setw( 3)<<a[iM8].S8[iS8].G7;
      }
      os<<'\n';
   }
   return os;
}
std::ostream& operator<<(std::ostream& os,
                         const std::vector<Igor_Model::tU8>& a){
   os<<"SHEET FORMATION\n";
   os<< std::fixed<< std::setprecision(3);
   int oU8=a.size();
   int pU8=0;
   bool STABLE=false;
   for(int iU8=(oU8- 1);iU8>=2&&(!STABLE);iU8--){
      int oY8=a[iU8].oY8;
      for(int iY8= 0;iY8<oY8&&(!STABLE);iY8++){
         if( a[iU8].Y8[iY8].STABLE ){
            pU8=iU8;
            STABLE=true;
         }
      }
   }
   os<<" oU8 pU8\n";
   os<<std::setw( 4)<<oU8
     <<std::setw( 4)<<pU8<<'\n';
   for(int iU8= 2;iU8<=pU8;iU8++){
      int oZ8=iU8;
      int oY8=a[iU8].oY8;
      os<<" U8 oY8\n";
      os<<std::setw( 3)<<oZ8
        <<std::setw( 4)<<oY8<<'\n';
      os<<" U8  Y8   etot   e      epck STABLE FACTOR\n";
      for(int iY8= 0;iY8<oY8;iY8++){
         os<<std::setw( 3)<<iU8
           <<std::setw( 4)<<iY8;
         for(int i=0;i<3;i++){
            os<<std::setw( 7)<<a[iU8].Y8[iY8].e[ i];
         }
         os<<((a[iU8].Y8[iY8].STABLE)? " T": " F")
           <<((a[iU8].Y8[iY8].FACTOR)? " T": " F")<<'\n';
      }
   }
   return os;
}
std::ostream& operator<<(std::ostream& os,
                         const std::vector<Igor_Model::tT8>& a){
   os<<"SHEET OPTIMAL PARTITION\n";
   os<< std::fixed<< std::setprecision(3);
   int oT8=a.size();
   os<<"oT8\n";
   os<<std::setw( 3)<<oT8<<'\n';
   os<<" T8 U8  Y8   etot   e      epck sub\n";
   for(int iT8= 0;iT8<oT8;iT8++){
      os<<std::setw( 3)<<iT8
        <<std::setw( 3)<<a[iT8].U8
        <<std::setw( 4)<<a[iT8].Y8;
      for(int i=0;i<3;i++){
         os<<std::setw( 7)<<a[iT8].e[ i];
      }
      os<<((a[iT8].sub)? " T\n": " F\n");
   }
   return os;
}
std::ostream& operator<<(std::ostream& os,
                         const std::vector<Igor_Model::tV8>& a){
   int oV8=a.size();
   os<<"oV8\n";
   os<<std::setw( 3)<<oV8<<'\n';
   for(int iV8= 0;iV8<oV8;iV8++){
      int lX=a[iV8].lX;
      int uX=a[iV8].uX;
      int lY=a[iV8].lY;
      int uY=a[iV8].uY;
      os<<"SHEET CONFIG\n";
      for(int iX=lX;iX<=uX;iX++){
         os<<a[iV8].X(iX).head0;
      }
      os<<'\n';
      for(int iX=lX;iX<=uX;iX++){
         os<<a[iV8].X(iX).head1;
      }
      os<<'\n';
      for(int iY=uY;iY>=lY;iY--){
         for(int iX=lX;iX<=uX;iX++){
           os<<a[iV8].XY(iX,iY).alp;
         }
         os<<'\n';
      }
      for(int iX=lX;iX<=uX;iX++){
         os<<a[iV8].X(iX).head2;
      }
      os<<'\n';
   }
   return os;
}
std::ostream& operator<<(std::ostream& os,
                         const std::vector<Igor_Model::tM9>& a){
   os<<"1ST PASS PARTITION OF BODS\n";
   int oM9=a.size();
   for(int iM9= 0;iM9<oM9;iM9++){
      int oS9=a[iM9].oS9;
      os<<"oS9\n";
      os<<std::setw( 3)<<oS9<<'\n';
      os<<" M9 S9 oK4[    K4G7] oB4[    B4W4]\n";
      for(int iS9=0;iS9<oS9;iS9++){
         int oB4=a[iM9].S9[iS9].oB4;
         int oK4=a[iM9].S9[iS9].oK4;
         os<<std::setw( 3)<<iM9
           <<std::setw( 3)<<iS9
           <<std::setw( 4)<<oK4<<'[';
         for(int iK4= 0;iK4<oK4;iK4++){
            os<<std::setw( 4)<<a[iM9].S9[iS9].K4[iK4].G7;
         }
         os<<']'<<std::setw( 4)<<oB4<<'[';
         for(int iB4= 0;iB4<oB4;iB4++){
            os<<std::setw( 4)<<a[iM9].S9[iS9].B4[iB4].W4;
         }
         os<<"]\n";
      }
   }
   return os;
}
std::ostream& operator<<(std::ostream& os,
                         const std::vector<Igor_Model::tU9>& a){
   os<<"PACK FORMATION\n";
   os<< std::fixed;
   int oU9=a.size();
   int pU9=-1;
   bool STABLE=false;
   for(int iU9=(oU9- 1);iU9>=2&&(!STABLE);iU9--){
      int oY9=a[iU9].oY9;
      for(int iY9= 0;iY9<oY9&&(!STABLE);iY9++){
         if( a[iU9].Y9[iY9].STABLE ){
            pU9=iU9;
            STABLE=true;
         }
      }
   }
   os<<" oU9 pU9\n";
   os<<std::setw( 4)<<oU9
     <<std::setw( 4)<<pU9<<'\n';
   for(int iU9= 2;iU9<=pU9;iU9++){
      int oZ9=iU9;
      int oY9=a[iU9].oY9;
      os<<" U9 oY9\n";
      os<<std::setw( 3)<<iU9
        <<std::setw( 4)<<oY9<<'\n';
      os<<" U9  Y9   e      epck   Fh     Fm  STABLE FACTOR(  Z9S9)\n";
      os<< std::setprecision(3);
      for(int iY9= 0;iY9<oY9;iY9++){
         os<<std::setw( 3)<<iU9
           <<std::setw( 4)<<iY9;
         for(int i=0;i<4;i++){
            os<<std::setw( 7)<<a[iU9].Y9[iY9].e[ i];
         }
         os<<((a[iU9].Y9[iY9].STABLE)? "  T": "  F")
           <<((a[iU9].Y9[iY9].FACTOR)? "  T": "  F")<<'(';
         for(int iZ9= 0;iZ9<oZ9;iZ9++){
            os<<std::setw( 3)<<a[iU9].Y9[iY9].Z9[iZ9].S9;
         }
         os<<")\n";
      }
      std::vector<int> XZ9(oZ9);
      os<<" U9  Y9 Z9  X S9 iB4 jB4  C8 D   e   \n";
      for(int iY9= 0;iY9<oY9;iY9++){
         if( !a[iU9].Y9[iY9].STABLE )continue;
         for(int iZ9= 0;iZ9<oZ9;iZ9++){
            XZ9[a[iU9].Y9[iY9].Z9[iZ9].X]=iZ9;
         }
         for(int iZ9= 0;iZ9<oZ9;iZ9++){
            int iX=a[iU9].Y9[iY9].Z9[iZ9].X;
            int iB4(-1),jB4(-1),iC8(-1),iD(-1);
            if( iX<(oZ9- 1) ){
               int jZ9=XZ9[iX+ 1];
               jB4=(a[iU9].Y9[iY9].Z9[iZ9].B/256);
               iB4=(a[iU9].Y9[iY9].Z9[jZ9].A/256);
               iC8=(a[iU9].Y9[iY9].Z9[iZ9].B%256)/2;
               iD=(a[iU9].Y9[iY9].Z9[iZ9].B%2);
            }
            os<<std::setprecision(3);
            os<<std::setw( 3)<<iU9
              <<std::setw( 4)<<iY9
              <<std::setw( 3)<<iZ9
              <<std::setw( 3)<<iX
              <<std::setw( 3)<<a[iU9].Y9[iY9].Z9[iZ9].S9
              <<std::setw( 4)<<iB4
              <<std::setw( 4)<<jB4
              <<std::setw( 4)<<iC8
              <<std::setw( 2)<<iD
              <<std::setw( 7)<<a[iU9].Y9[iY9].Z9[iZ9].e<<'\n';
            os<<" Z9 K4          u                   v         \n";
            os<<std::setprecision(2);
            int oK4=a[iU9].Y9[iY9].Z9[iZ9].oK4;
            for(int iK4= 0;iK4<oK4;iK4++){
               os<<std::setw( 3)<<iZ9
                 <<std::setw( 3)<<iK4<<'[';
               for(int i=0;i<3;i++){
                  os<<std::setw( 6)<<a[iU9].Y9[iY9].Z9[iZ9].K4[iK4].u( i);
               }
               os<<"][";
               for(int i=0;i<3;i++){
                  os<<std::setw( 6)<<a[iU9].Y9[iY9].Z9[iZ9].K4[iK4].v( i);
               }
               os<<"]\n";
            }
         }
      }
   }
   return os;
}
std::ostream& operator<<(std::ostream& os,
                         const std::vector<Igor_Model::tT9>& a){
   os<<"PACK OPTIMAL PARTITION\n";
   os<< std::fixed<< std::setprecision(3);
   int oT9=a.size();
   os<<"oT9\n";
   os<<std::setw( 3)<<oT9<<'\n';
   os<<" T9 U9  Y9   e      epck   Fh     Fm  sub\n";
   for(int iT9= 0;iT9<oT9;iT9++){
      os<<std::setw( 3)<<iT9
        <<std::setw( 3)<<a[iT9].U9
        <<std::setw( 4)<<a[iT9].Y9;
      for(int i=0;i<4;i++){
         os<<std::setw( 7)<<a[iT9].e[ i];
      }
      os<<((a[iT9].sub)? " T\n": " F\n");
   }
   return os;
}
//
// calc distance from triangle vertex to interior point
// using Caley-Menger determinant equation
//
double Igor_Model::IGO_CAYLEY_MENGER(Output_Streams& out,
                                     bool LOWROOT){
//
//
// accumulate quadratic coeffs
//
   Coordinates x;
   x.zero();
   for(int aX=0;aX<5;aX++){
      if( aX==0 )continue;
      for(int bX=0;bX<5;bX++){
         if( bX==1 )continue;
         if( (bX==aX) )continue;
         for(int cX=0;cX<5;cX++){
            if( cX==2 )continue;
            if( (cX==aX)||(cX==bX) )continue;
            for(int dX=0;dX<5;dX++){
               if( dX==3 )continue;
               if( (dX==aX)||(dX==bX)||(dX==cX) )continue;
               for(int eX=0;eX<5;eX++){
                  if( eX==4 )continue;
                  if( (eX==aX)||(eX==bX)||(eX==cX)||(eX==dX) )continue;
                  int j=2;
                  if( bX==4 ){
                     if( eX==1 ){
                        j=0;
                     }else{
                        j=1;
                     }
                  }else{
                     if( eX==1 ){
                        j=1;
                     }else{
                     }
                  }
                  x(j)+=(XXXXXeps(aX,bX,cX,dX,eX)
                        *CM(aX, 0)
                        *CM(bX, 1)
                        *CM(cX, 2)
                        *CM(dX, 3)
                        *CM(eX, 4));
               }
            }
         }
      }
   }
//
//
// quadratic formula
//
   double d=( x(1)*x(1) -(4.)*x(0)*x(2));
   if( d<( 1.00e-16) ){
      d= ( 1.00e-16);
   }
   d= std::sqrt( d);
   double z= (2.)*x(0);                 //  z always <0
   double rr0= -x(1)/z;
   double rr1= d/z;                     //rr1 always <0
   double rr=( LOWROOT )? ( rr0 +rr1): ( rr0 -rr1);
//// out.FILE3<< std::fixed<<std::setprecision( 5);
//// out.FILE3<<" A="<<std::setw(15)<<x(0)
////          <<" B="<<std::setw(15)<<x(1)
////          <<" C="<<std::setw(15)<<x(2)
////          <<" rr0="<<std::setw(15)<<rr0
////          <<" rr1="<<std::setw(15)<<rr1
////          <<'\n';
//// out.FILE3<<std::setprecision( 2);
   return rr;
}
