#ifndef DEF_CONFIG_MERGE
#define DEF_CONFIG_MERGE

#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../igo/Target_Surf.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <cmath>

//
//
// minimization of target func
//
class Config_Merge {
public:
   class tM2 { /*minimization step*/
   public:
      double tot;               //function value
      double z;                 //square of gradient
      double bet;               //target step length
      double delF;              //predicted change in energy
      /*adjustment of Lagrange multiplier lamda*/
      double lam0;              //initial value
      double  s0;               //square of step length of lam0
      double ds0;               //derivative of s0 wrt lam
      double lam1[4];           //estimate of negative of lowest eigenvalue
      double  s1[4];            //square of step length of lam1
      double ds1[4];            //derivative of s1 wrt lam
      double lam2;              //value corresponding to target step length
      double  s2;               //square of step length of lam2
      double ds2;               //derivative of s2 wrt lam
      /*iterations in adjustment of lamda*/
      int k1;                   //lam0 st (A +lam0*I) is positive definite
      int k2;                   //decrease toward negative of lowest eigenvalue
      int k3;                   //increase to lam2
      int k4[4];                //selection of lowest eigenvalue
      int k5[4];                //lam1 st (A +lam1*I) is positive definite
      tM2(){}
   };

public:
   /*step length*/
   double BETA;                 //target
   double BMAX;                 //maximum target
   double BMIN;                 //minimum target
   double BDEL;                 //fraction controlling rate of adjustment
   /*convergence thresholds*/
   double EPS1;                 //for gradient
   double EPS2;                 //for square of step length
   /*minimization steps*/
   int nM2;                     //maximum number
   std::vector<tM2> M2;         //set
   int iM2;                     //index
   /*return state from minimization*/
   int ENDSTATE;                //error code for local minimization

   void IGO_LOQ_BACKUP(Lagrange_Multiplier& lag,
                       Target_Surf& enq);
   double IGO_LOQ_TARGETBETA();
   void IGO_LOQ_INITLAMDA(Lagrange_Multiplier& lag,
                          int ck1,
                          double beta1);
   void IGO_LOQ_UPDATE(Lagrange_Multiplier& lag,
                       Target_Surf& enq);

   Config_Merge(int oM2,int o):
      M2(oM2),
      BETA( 2.00e-02),
      BMAX( 1.00e-01),
      BMIN( 1.00e-07),
      BDEL( 2.00e-01),
      EPS1( 1.00e-05),
      EPS2( 1.00e-02),
      nM2(128)
   {
      BETA*=std::sqrt( o);
      BMAX*=std::sqrt( o);
      BMIN*=std::sqrt( o);
      EPS1= o*(EPS1*EPS1);
   }

   int IGO_LOQ(const DAT_PHYSICS_CONSTS& physics_consts,
               Output_Streams& out,
               Target_Surf& enq,
               std::vector<Igor_Model::tG7>& G7,
               std::vector<Igor_Model::tZ9>& Z9,
               int COMPONENT);
   void IGO_LOQ_WRT(const DAT_PHYSICS_CONSTS& physics_consts,
                    Output_Streams& out,
                    const Target_Surf& enq);

};

#endif
