#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../hom/Homolog_Model.hh"
#include "../hom/Sub_Automatic.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

void Homolog_Model::SUB_USC(Sub_Automatic& aut,
                            const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            Output_Streams& out,
                            int pR0min,int pR0max){
//
//
// determine incomplete side chains, starting chi, set of confs
//
   aut.nR6=-1;
   int iV6=-1;
   for(int iZ0= 0;iZ0<tar.nZ0;iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( (iR0<pR0min)||(iR0>pR0max) )continue;
         int mP1=tar.R0[iR0].P1a;
         int nP1=(mP1-1+tar.R0[iR0].cP1);
         if( tar.P1[mP1].sub==0 )continue;
         char c1=tar.R0[iR0].c1;
         std::string aa=tar.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         if( aa==("PRO ") )continue;
         int iL0=tar.R0[iR0].L0;
         for(int jL0= 0;jL0<residue_mappings.nL0;jL0++){
            if( residue_mappings.L0[jL0].aa==aa )iL0=jL0;
         }
         int mP2=residue_mappings.L0[iL0].P2a;
         int nP2=(mP2-1+residue_mappings.L0[iL0].cP2);
         bool INCLUDED=false;
         for(int iP1=mP1;iP1<=nP1&&(!INCLUDED);iP1++){
            if( tar.P1[iP1].sub==1 )continue;
            std::string atm=tar.P1[iP1].atm;
            int iT2=tar.P1[iP1].typ;
            if( iT2< 8 )continue;
            aut.R6.push_back( Sub_Automatic::tR6());
            aut.nR6++;
            aut.R6[aut.nR6].Z0=iZ0;
            aut.R6[aut.nR6].R0=iR0;
            aut.R6[aut.nR6].V6a=(iV6+1);
            aut.R6[aut.nR6].cV6=0;
            int Q6H4[ 5];
            int mQ6=0;
            bool SCATM=true;
            if      ( c1=='a' ){
               SCATM=false;
            }else if( c1=='e' ){
            }else if( c1=='r' ){
               SCATM=false;
            }else if( c1=='b' ){
            }else if( c1=='p' ){
            }else if( c1=='s' ){
            }
            for(int iP2=mP2;iP2<=nP2&&(!INCLUDED);iP2++){
               if( residue_mappings.P2[iP2].grp0!=0 )continue;
               if( residue_mappings.P2[iP2].atm0[1]=='H' )continue;
               if( (c1=='a')&&
                   (residue_mappings.P2[iP2].atm0==" CB ") )SCATM=true;
               if( (c1=='r')&&
                   (residue_mappings.P2[iP2].atm0==" O2'") )SCATM=true;
               if( !SCATM )continue;

               if( residue_mappings.P2[iP2].atm0==atm ){
//                int j0R0=iR0;
//                int j0P1=iP1;
                  int j1R0=(iR0+residue_mappings.P2[iP2].grp1);
                  int j2R0=(iR0+residue_mappings.P2[iP2].grp2);
                  int j3R0=(iR0+residue_mappings.P2[iP2].grp3);
                  std::string atm1=residue_mappings.P2[iP2].atm1;
                  std::string atm2=residue_mappings.P2[iP2].atm2;
                  std::string atm3=residue_mappings.P2[iP2].atm3;
                  int j1P1=-1;
                  int m1P1=tar.R0[j1R0].P1a;
                  int n1P1=(m1P1-1+tar.R0[j1R0].cP1);
                  for(int i1P1=m1P1;i1P1<=n1P1;i1P1++){
                     if( tar.P1[i1P1].atm==atm1 )j1P1=i1P1;
                  }
                  int j2P1=-1;
                  int m2P1=tar.R0[j2R0].P1a;
                  int n2P1=(m2P1-1+tar.R0[j2R0].cP1);
                  for(int i2P1=m2P1;i2P1<=n2P1;i2P1++){
                     if( tar.P1[i2P1].atm==atm2 )j2P1=i2P1;
                  }
                  int j3P1=-1;
                  int m3P1=tar.R0[j3R0].P1a;
                  int n3P1=(m3P1-1+tar.R0[j3R0].cP1);
                  for(int i3P1=m3P1;i3P1<=n3P1;i3P1++){
                     if( tar.P1[i3P1].atm==atm3 )j3P1=i3P1;
                  }
                  if( (tar.P1[j1P1].sub==0)||
                      (tar.P1[j2P1].sub==0)||
                      (tar.P1[j3P1].sub==0)||
                      (residue_mappings.P2[iP2].chi<(999.)) ){
                     std::cerr<<"ERROR: Inconsistent base."
                              <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                              <<" iR0="<< std::setw( 4)<<(iR0+1)
                              <<" iP1="<< std::setw( 2)<<(iP1-mP1+1)<<'\n';
                     std::exit( 2);
                  }
                  int nQ6=residue_mappings.L0[iL0].nQ6;
                  aut.R6[aut.nR6].Q6a=mQ6;
                  aut.R6[aut.nR6].cQ6=(nQ6-mQ6);
                  int mC2=residue_mappings.L0[iL0].C2a;
                  int nC2=(mC2-1+residue_mappings.L0[iL0].cC2);
                  for(int iC2=mC2;iC2<=nC2;iC2++){
                     bool CONSISTENT=true;
                     for(int iQ6= 0;iQ6<mQ6&&(CONSISTENT);iQ6++){
                        double chi= residue_mappings.C2Q6chi(iC2,iQ6);
                        int jH4=int( std::floor( (.50) +chi/(10.00)));
                        if( jH4!=Q6H4[iQ6] )CONSISTENT=false;
                     }
                     if( CONSISTENT ){
                        aut.V6.push_back( Sub_Automatic::tV6());
                        iV6++;
                        aut.R6[aut.nR6].cV6++;
                        aut.V6[iV6].C2=iC2;
                     }
                  }
                  INCLUDED=true;

               }else{
                  double chi= residue_mappings.P2[iP2].chi;
                  if( chi<(999.) )continue;
                  mQ6++;
                  int j0R0=iR0;
                  int j1R0=(iR0+residue_mappings.P2[iP2].grp1);
                  int j2R0=(iR0+residue_mappings.P2[iP2].grp2);
                  int j3R0=(iR0+residue_mappings.P2[iP2].grp3);
                  std::string atm0=residue_mappings.P2[iP2].atm0;
                  std::string atm1=residue_mappings.P2[iP2].atm1;
                  std::string atm2=residue_mappings.P2[iP2].atm2;
                  std::string atm3=residue_mappings.P2[iP2].atm3;
                  int j0P1=-1;
                  int m0P1=tar.R0[j0R0].P1a;
                  int n0P1=(m0P1-1+tar.R0[j0R0].cP1);
                  for(int i0P1=m0P1;i0P1<=n0P1;i0P1++){
                     if( tar.P1[i0P1].atm==atm0 )j0P1=i0P1;
                  }
                  int j1P1=-1;
                  int m1P1=tar.R0[j1R0].P1a;
                  int n1P1=(m1P1-1+tar.R0[j1R0].cP1);
                  for(int i1P1=m1P1;i1P1<=n1P1;i1P1++){
                     if( tar.P1[i1P1].atm==atm1 )j1P1=i1P1;
                  }
                  int j2P1=-1;
                  int m2P1=tar.R0[j2R0].P1a;
                  int n2P1=(m2P1-1+tar.R0[j2R0].cP1);
                  for(int i2P1=m2P1;i2P1<=n2P1;i2P1++){
                     if( tar.P1[i2P1].atm==atm2 )j2P1=i2P1;
                  }
                  int j3P1=-1;
                  int m3P1=tar.R0[j3R0].P1a;
                  int n3P1=(m3P1-1+tar.R0[j3R0].cP1);
                  for(int i3P1=m3P1;i3P1<=n3P1;i3P1++){
                     if( tar.P1[i3P1].atm==atm3 )j3P1=i3P1;
                  }
                  Coordinates zU=( tar.P1[j2P1].x -tar.P1[j1P1].x).normalize();
                  Coordinates zV=( tar.P1[j3P1].x -tar.P1[j2P1].x);
                  double zVU= dot(zV,zU);
                  zV-=zVU*zU;
                  zV.normalize();
                  Coordinates zW=cross(zU,zV);
                  Coordinates zD=( tar.P1[j0P1].x -tar.P1[j1P1].x);
                  double zDU= dot(zD,zU);
                  zD-=zDU*zU;
                  zD.normalize();
                  double CP= dot(zD,zV);
                  double SP= dot(zD,zW);
                  double phi=-std::atan2(SP,CP)/physics_consts.RAD;
                  bool H4sub[36];
                  for(int iH4=-18;iH4< 18;iH4++){
                     H4sub[iH4+18]=false;
                  }
                  int mC2=residue_mappings.L0[iL0].C2a;
                  int nC2=(mC2-1+residue_mappings.L0[iL0].cC2);
                  for(int iC2=mC2;iC2<=nC2;iC2++){
                     double chi= residue_mappings.C2Q6chi(iC2,mQ6-1);
                     int iH4=int( std::floor( (.50) +chi/(10.00)));
                     H4sub[iH4+18]=true;
                  }
                  int jH4=0;
                  double zRmin= (1.00e+6);
                  for(int iH4=-18;iH4< 18;iH4++){
                     if( !H4sub[iH4+18] )continue;
                     double zR=( phi -double( 10*iH4));
                     if      ( zR>( 180.) ){
                        zR-=(360.);
                     }else if( zR<(-180.) ){
                        zR+=(360.);
                     }
                     if( std::abs( zR)<zRmin ){
                        jH4=iH4;
                        zRmin= std::abs( zR);
                     }
                  }
                  Q6H4[mQ6-1]=jH4;

               }
            }
         }
      }
   }
   aut.nR6++;
   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<< std::fixed<< std::setprecision( 1);
      out.FILE3<<" nR6="<< std::setw( 4)<<aut.nR6<<'\n';
      for(int iR6= 0;iR6<aut.nR6;iR6++){
         int iZ0=aut.R6[iR6].Z0;
         int iR0=aut.R6[iR6].R0;
         std::string aa=tar.R0[iR0].aa;
         int mQ6=aut.R6[iR6].Q6a;
         int nQ6=(mQ6-1+aut.R6[iR6].cQ6);
         int mV6=aut.R6[iR6].V6a;
         int nV6=(mV6-1+aut.R6[iR6].cV6);
         out.FILE3<<" iR6="<< std::setw( 4)<<iR6
                  <<" R6Z0="<< std::setw( 2)<<(iZ0+1)
                  <<" R6R0="<< std::setw( 4)<<(iR0+1)
                  <<" aa="<<aa
                  <<" R6cQ6="<< std::setw( 1)<<(nQ6-mQ6+1)
                  <<" R6cV6="<< std::setw( 3)<<(nV6-mV6+1)<<'\n';
//       for(int iV6=mV6;iV6<=nV6;iV6++){
//          int iC2=aut.V6[iV6].C2;
//          for(int iQ6=mQ6;iQ6<=nQ6;iQ6++){
//             out.FILE3<< std::setw( 6)<<residue_mappings.C2Q6chi(iC2,iQ6);
//          }
//          out.FILE3<<'\n';
//       }
      }
   }
   return;
}
