#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../hom/Homolog_Model.hh"
#include "../hom/Sub_Automatic.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_sub_scpck {
private:
   int o_J6;                            //
   std::vector<double> o_J6V6e;         //
   std::vector<double> o_J6J6e;         //
   std::vector<double> o_J6V6J6e;       //
   std::vector<double> o_J6V6J6V6e;     //
   std::vector<int> o_J6V6pck;          //
   std::vector<double> o_X3e;           //
   std::vector<int> o_X3J6V6;           //
   std::vector<int> o_J6nV6;            //
   std::vector<int> o_J6iV6;            //
   std::vector<double> o_J6g;           //
   std::vector<double> o_J6f;           //
public:
   MEM_sub_scpck(int oJ6,int oX3):
      o_J6(oJ6),
      o_J6V6e(oJ6*256),
      o_J6J6e(oJ6*oJ6, (1.00e+8)),
      o_J6V6J6e(oJ6*256*oJ6, (1.00e+8)),
      o_J6V6J6V6e(oJ6*256*oJ6*256),
      o_J6V6pck(oJ6, -1),
      o_X3e(oX3, (1.00e+8)),
      o_X3J6V6(oX3*oJ6, -1),
      o_J6nV6(oJ6),
      o_J6iV6(oJ6, -1),
      o_J6g(oJ6),
      o_J6f(oJ6)
   {
   }
   double& J6V6e(int i,int j){
      return o_J6V6e.at( i*256 +j);  }
   double& J6J6e(int i,int j){
      return o_J6J6e.at( i*o_J6 +j);  }
   double& J6V6J6e(int i,int j,int k){
      return o_J6V6J6e.at( i*256*o_J6 +j*o_J6 +k);  }
   double& J6V6J6V6e(int i,int j,int k,int l){
      return o_J6V6J6V6e.at( i*256*o_J6*256 +j*o_J6*256 +k*256 +l);  }
   int& J6V6pck(int i){
      return o_J6V6pck.at( i);  }
   double& X3e(int i){
      return o_X3e.at( i);  }
   int& X3J6V6(int i,int j){
      return o_X3J6V6.at( i*o_J6 +j);  }
   int& J6nV6(int i){
      return o_J6nV6.at( i);  }
   int& J6iV6(int i){
      return o_J6iV6.at( i);  }
   double& J6g(int i){
      return o_J6g.at( i);  }
   double& J6f(int i){
      return o_J6f.at( i);  }
};

void Homolog_Model::SUB_SCPCK(Sub_Automatic& aut,
                              const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_ENERGY_PARAMS& energy_params,
                              const DAT_RESIDUE_MAPPINGS& residue_mappings,
                              Output_Streams& out,
                              int pR0min,int pR0max){
   int oX3=16;
   for(int iW6= 0;iW6<aut.nW6;iW6++){
      int oJ6=aut.W6[iW6].nJ6;
      MEM_sub_scpck vv(oJ6,oX3);
//
//
// for all single res sc rotamer confs energy of sc-base
//
      for(int jJ6= 0;jJ6<oJ6;jJ6++){
         int jR6=aut.W6J6R6(iW6,jJ6);
//       int jZ0=aut.R6[jR6].Z0;
         int jR0=aut.R6[jR6].R0;
         char c1=tar.R0[jR0].c1;
         std::string aa1=tar.R0[jR0].aa;
         if( c1=='a' ){
            if( (aa1[0]=='e')||
                (aa1[0]=='z') )aa1=aa1.substr(1,3)+' ';
            if( (aa1[3]=='e')||
                (aa1[3]=='z') )aa1=aa1.substr(0,3)+' ';
         }
         int mV6=aut.R6[jR6].V6a;
         int nV6=(mV6-1+aut.R6[jR6].cV6);
         if( (nV6-mV6+1)>256 )nV6=(mV6-1+256);
         for(int jV6=mV6;jV6<=nV6;jV6++){
            int bV6=(jV6-mV6);
            int mP6=aut.V6[jV6].P6a;
            int nP6=(mP6-1+aut.V6[jV6].cP6);
            vv.J6V6e(jJ6,bV6)= residue_mappings.C2[aut.V6[jV6].C2].e;
            for(int iZ0= 0;iZ0<tar.nZ0;iZ0++){
               int mR0=tar.Z0[iZ0].R0a;
               int nR0=(mR0-1+tar.Z0[iZ0].cR0);
               for(int iR0=mR0;iR0<=nR0;iR0++){
                  if( (iR0<pR0min)||(iR0>pR0max) )continue;
                  char c2=tar.R0[iR0].c1;
                  std::string aa2=tar.R0[iR0].aa;
                  if( c2=='a' ){
                     if( (aa2[0]=='e')||
                         (aa2[0]=='z') )aa2=aa2.substr(1,3)+' ';
                     if( (aa2[3]=='e')||
                         (aa2[3]=='z') )aa2=aa2.substr(0,3)+' ';
                  }
                  int mP1=tar.R0[iR0].P1a;
                  int nP1=(mP1-1+tar.R0[iR0].cP1);
                  bool isCYSCYS=false;
                  if( (aa1=="CYS ")&&(aa2=="CYS ") ){
                     for(int iS0= 0;iS0<tar.nS0;iS0++){
                        if      ( (tar.S0N2R0(iS0, 0)==jR0)&&
                                  (tar.S0N2R0(iS0, 1)==iR0) ){
                           isCYSCYS=true;
                        }else if( (tar.S0N2R0(iS0, 0)==iR0)&&
                                  (tar.S0N2R0(iS0, 1)==jR0) ){
                           isCYSCYS=true;
                        }
                     }
                  }

                  for(int jP6=mP6;jP6<=nP6;jP6++){
                     std::string atm1=aut.P6[jP6].atm;
                     int jT2=aut.P6[jP6].typ;
                     for(int iP1=mP1;iP1<=nP1;iP1++){
                        if( tar.P1[iP1].sub==0 )continue;
                        std::string atm2=tar.P1[iP1].atm;
                        int iT2=tar.P1[iP1].typ;
                        if( (iR0==jR0)&&((atm2!=" N  ")&&(atm2!=" C  ")&&
                                         (atm2!=" O  ")) )continue;
                        double r=( tar.P1[iP1].x -aut.P6[jP6].x).r();
                        if( r<(1.00e-12) )r= (1.00e-12);
                        if      ( isCYSCYS&&(atm1==" SG ")&&(atm2==" SG ") ){
                           double z=( r -(2.04));
                           vv.J6V6e(jJ6,bV6)+=(1.00e+2)*z*z;
                        }else if( isCYSCYS&&(atm1==" SG ")&&(atm2==" CB ") ){
                        }else if( isCYSCYS&&(atm1==" CB ")&&(atm2==" SG ") ){
                        }else{
                           double EPS= energy_params.T2T2e(iT2,jT2);
                           EPS*=physics_consts.CAL;
                           double RHO= energy_params.T2T2r(iT2,jT2);
                           RHO*=physics_consts.ANG;
                           RHO-=(.20);
                           double alp= energy_params.T2T2a(iT2,jT2);
                           alp+=(.02);
                           double z= (r/RHO);
                           double f=( (1.00) +alp)/( z +alp);
                           double g= (1.12)/( std::pow(z,7) +(.12));
                           vv.J6V6e(jJ6,bV6)+=EPS*( std::pow(f,7)*( g -(2.00)));
                           if( r<aut.T2T2r(iT2,jT2) ){
                              vv.J6V6e(jJ6,bV6)+=aut.T2T2e(iT2,jT2);
                           }
                        }
                     }
                  }

               }
            }
         }
      }
//
//
// for all pairs of sc rotamer confs energy of sc-sc
//
      double w=( oJ6> 1 )? (1.00)/double(oJ6-1): (1.00);
      for(int iJ6= 0;iJ6<(oJ6-1);iJ6++){
         int iR6=aut.W6J6R6(iW6,iJ6);
//       int iZ0=aut.R6[iR6].Z0;
         int iR0=aut.R6[iR6].R0;
         char c1=tar.R0[iR0].c1;
         std::string aa1=tar.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa1[0]=='e')||
                (aa1[0]=='z') )aa1=aa1.substr(1,3)+' ';
            if( (aa1[3]=='e')||
                (aa1[3]=='z') )aa1=aa1.substr(0,3)+' ';
         }
         int mV6=aut.R6[iR6].V6a;
         int nV6=(mV6-1+aut.R6[iR6].cV6);
         if( (nV6-mV6+1)>256 )nV6=(mV6-1+256);
         for(int jJ6=(iJ6+1);jJ6<oJ6;jJ6++){
            int jR6=aut.W6J6R6(iW6,jJ6);
//          int jZ0=aut.R6[jR6].Z0;
            int jR0=aut.R6[jR6].R0;
            char c2=tar.R0[jR0].c1;
            std::string aa2=tar.R0[jR0].aa;
            if( c2=='a' ){
               if( (aa2[0]=='e')||
                   (aa2[0]=='z') )aa2=aa2.substr(1,3)+' ';
               if( (aa2[3]=='e')||
                   (aa2[3]=='z') )aa2=aa2.substr(0,3)+' ';
            }
            int jV6min=aut.R6[jR6].V6a;
            int jV6max=(jV6min-1+aut.R6[jR6].cV6);
            if( (jV6max-jV6min+1)>256 )jV6max=(jV6min-1+256);
            bool isCYSCYS=false;
            if( (aa1=="CYS ")&&(aa2=="CYS ") ){
               for(int iS0= 0;iS0<tar.nS0;iS0++){
                  if      ( (tar.S0N2R0(iS0, 0)==jR0)&&
                            (tar.S0N2R0(iS0, 1)==iR0) ){
                     isCYSCYS=true;
                  }else if( (tar.S0N2R0(iS0, 0)==iR0)&&
                            (tar.S0N2R0(iS0, 1)==jR0) ){
                     isCYSCYS=true;
                  }
               }
            }
            for(int iV6=mV6;iV6<=nV6;iV6++){
               int aV6=(iV6-mV6);
               int mP6=aut.V6[iV6].P6a;
               int nP6=(mP6-1+aut.V6[iV6].cP6);
               for(int jV6=jV6min;jV6<=jV6max;jV6++){
                  int bV6=(jV6-jV6min);
                  int jP6min=aut.V6[jV6].P6a;
                  int jP6max=(jP6min-1+aut.V6[jV6].cP6);
                  vv.J6V6J6V6e(iJ6,aV6,jJ6,bV6)= w*( vv.J6V6e(jJ6,bV6)
                                                    +vv.J6V6e(iJ6,aV6));

                  for(int iP6=mP6;iP6<=nP6;iP6++){
                     std::string atm1=aut.P6[iP6].atm;
                     int iT2=aut.P6[iP6].typ;
                     for(int jP6=jP6min;jP6<=jP6max;jP6++){
                        std::string atm2=aut.P6[jP6].atm;
                        int jT2=aut.P6[jP6].typ;
                        double r=( aut.P6[jP6].x -aut.P6[iP6].x).r();
                        if( r<(1.00e-12) )r= (1.00e-12);
                        if      ( isCYSCYS&&(atm1==" SG ")&&(atm2==" SG ") ){
                           double z=( r -(2.04));
                           vv.J6V6J6V6e(iJ6,aV6,jJ6,bV6)+=(1.00e+2)*z*z;
                        }else if( isCYSCYS&&(atm1==" SG ")&&(atm2==" CB ") ){
                        }else if( isCYSCYS&&(atm1==" CB ")&&(atm2==" SG ") ){
                        }else{
                           double EPS= energy_params.T2T2e(iT2,jT2);
                           EPS*=physics_consts.CAL;
                           double RHO= energy_params.T2T2r(iT2,jT2);
                           RHO*=physics_consts.ANG;
                           RHO-=(.20);
                           double alp= energy_params.T2T2a(iT2,jT2);
                           alp+=(.02);
                           double z= (r/RHO);
                           double f=( (1.00) +alp)/( z +alp);
                           double g= (1.12)/( std::pow(z,7) +(.12));
                           vv.J6V6J6V6e(iJ6,aV6,jJ6,bV6)+=
                               EPS*( std::pow(f,7)*( g -(2.00)));
                           if( r<aut.T2T2r(iT2,jT2) ){
                              vv.J6V6J6V6e(iJ6,aV6,jJ6,bV6)+=aut.T2T2e(iT2,jT2);
                           }
                        }
                     }
                  }

                  if( vv.J6V6J6V6e(iJ6,aV6,jJ6,bV6)<vv.J6J6e(iJ6,jJ6) ){
                     vv.J6J6e(iJ6,jJ6)= vv.J6V6J6V6e(iJ6,aV6,jJ6,bV6);
                  }
                  if( vv.J6V6J6V6e(iJ6,aV6,jJ6,bV6)<vv.J6V6J6e(iJ6,aV6,jJ6) ){
                     vv.J6V6J6e(iJ6,aV6,jJ6)= vv.J6V6J6V6e(iJ6,aV6,jJ6,bV6);
                  }
               }
            }
         }
      }
//
//
// dead end elimination
//
      if      ( oJ6== 1 ){
         double emin= (1.00e+8);
         int nV6=aut.R6[aut.W6J6R6(iW6, 0)].cV6;
         if( nV6>256 )nV6=256;
         for(int aV6= 0;aV6<nV6;aV6++){
            if( vv.J6V6e(  0,aV6)<emin ){
               emin= vv.J6V6e(  0,aV6);
               vv.J6V6pck( 0)=aV6;
            }
         }

      }else if( oJ6<=12 ){
         for(int iJ6= 0;iJ6<oJ6;iJ6++){
            vv.J6nV6(iJ6)=aut.R6[aut.W6J6R6(iW6,iJ6)].cV6;
            if( vv.J6nV6(iJ6)>256 )vv.J6nV6(iJ6)=256;
         }
         double g= (0.00);
         for(int iJ6= 0;iJ6<(oJ6-1);iJ6++){
            for(int jJ6=(iJ6+1);jJ6<oJ6;jJ6++){
               g+=vv.J6J6e(iJ6,jJ6);
            }
         }
         double f= (0.00);

         int iJ6= 0;
         for(;;){
            vv.J6iV6(iJ6)++;
            if( vv.J6iV6(iJ6)>=vv.J6nV6(iJ6) ){
               if( iJ6== 0 ){
                  break;
               }else{
                  vv.J6iV6(iJ6)=-1;
                  iJ6--;
                  continue;
               }

            }else{
               vv.J6f(iJ6)=( iJ6> 0 )? vv.J6f(iJ6-1): f;
               vv.J6g(iJ6)=( iJ6> 0 )? vv.J6g(iJ6-1): g;
               for(int jJ6= 0;jJ6<iJ6;jJ6++){
                  vv.J6f(iJ6)+=vv.J6V6J6V6e(jJ6,vv.J6iV6(jJ6),
                                            iJ6,vv.J6iV6(iJ6));
                  vv.J6g(iJ6)-=vv.J6V6J6e(jJ6,vv.J6iV6(jJ6),iJ6);
               }
               for(int jJ6=(iJ6+1);jJ6<oJ6;jJ6++){
                  vv.J6g(iJ6)-=vv.J6J6e(iJ6,jJ6);
                  vv.J6g(iJ6)+=vv.J6V6J6e(iJ6,vv.J6iV6(iJ6),jJ6);
               }
               if( (vv.J6f(iJ6)+vv.J6g(iJ6))>=vv.X3e(oX3-1) )continue;
               if( iJ6==(oJ6-1) ){
                  vv.X3e(oX3-1)= vv.J6f(iJ6);
                  for(int jJ6= 0;jJ6<oJ6;jJ6++){
                     vv.X3J6V6(oX3-1,jJ6)=vv.J6iV6(jJ6);
                  }
                  for(int iX3=(oX3-1);iX3> 0;iX3--){
                     if( vv.X3e(iX3  )>=vv.X3e(iX3-1) )continue;
                     double f= vv.X3e(iX3-1);
                     vv.X3e(iX3-1)= vv.X3e(iX3  );
                     vv.X3e(iX3  )= f;
                     for(int jJ6= 0;jJ6<oJ6;jJ6++){
                        int j=vv.X3J6V6(iX3-1,jJ6);
                        vv.X3J6V6(iX3-1,jJ6)=vv.X3J6V6(iX3  ,jJ6);
                        vv.X3J6V6(iX3  ,jJ6)=j;
                     }
                  }
                  continue;
               }else{
                  iJ6++;
                  continue;
               }

            }
         }
         for(int jJ6= 0;jJ6<oJ6;jJ6++){
            vv.J6V6pck(jJ6)=vv.X3J6V6(  0  ,jJ6);
         }

      }

      if( out.VERBOSE&& out.SHELL ){
         out.FILE3<< std::fixed<< std::setprecision( 2);
         out.FILE3<<" iW6="<< std::setw( 4)<<iW6
                  <<" nJ6="<< std::setw( 2)<<oJ6<<'\n';
         for(int jJ6= 0;jJ6<oJ6;jJ6++){
            int iR6=aut.W6J6R6(iW6,jJ6);
            int iZ0=aut.R6[iR6].Z0;
            int iR0=aut.R6[iR6].R0;
            std::string aa=tar.R0[iR0].aa;
            int mV6=aut.R6[iR6].V6a;
            int nV6=(mV6-1+aut.R6[iR6].cV6);
            if( (nV6-mV6+1)>256 )nV6=(mV6-1+256);
            out.FILE3<<" iJ6="<< std::setw( 2)<<jJ6
                     <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                     <<" iR0="<< std::setw( 4)<<(iR0+1)
                     <<" aa="<<aa
                     <<" J6V6pck="<< std::setw( 3)<<vv.J6V6pck(jJ6)<<'\n';
//          for(int iV6=mV6;iV6<=nV6;iV6++){
//             int aV6=(iV6-mV6);
//             out.FILE3<<" iV6="<< std::setw( 3)<<aV6
//                      <<" J6V6e="<< std::setw( 9)<<vv.J6V6e(jJ6,aV6)<<'\n';
//          }
         }
//       for(int iJ6= 0;iJ6<(oJ6-1);iJ6++){
//          int iR6=aut.W6J6R6(iW6,iJ6);
//          int iZ0=aut.R6[iR6].Z0;
//          int iR0=aut.R6[iR6].R0;
//          std::string aa1=tar.R0[iR0].aa;
//          int mV6=aut.R6[iR6].V6a;
//          int nV6=(mV6-1+aut.R6[iR6].cV6);
//          if( (nV6-mV6+1)>256 )nV6=(mV6-1+256);
//          for(int jJ6=(iJ6+1);jJ6<oJ6;jJ6++){
//             int jR6=aut.W6J6R6(iW6,jJ6);
//             int jZ0=aut.R6[jR6].Z0;
//             int jR0=aut.R6[jR6].R0;
//             std::string aa2=tar.R0[jR0].aa;
//             int jV6min=aut.R6[jR6].V6a;
//             int jV6max=(jV6min-1+aut.R6[jR6].cV6);
//             if( (jV6max-jV6min+1)>256 )jV6max=(jV6min-1+256);
//             out.FILE3<<" iJ6="<< std::setw( 2)<<iJ6
//                      <<" aa="<<aa1
//                      <<" jJ6="<< std::setw( 2)<<jJ6
//                      <<" aa="<<aa2<<'\n';
//             for(int iV6=mV6;iV6<=nV6;iV6++){
//                int aV6=(iV6-mV6);
//                for(int jV6=jV6min;jV6<=jV6max;jV6++){
//                   int bV6=(jV6-jV6min);
//                   out.FILE3<<" iV6="<< std::setw( 3)<<aV6
//                            <<" jV6="<< std::setw( 3)<<bV6
//                            <<" J6V6J6V6e="<< std::setw( 9)
//                            <<vv.J6V6J6V6e(iJ6,aV6,jJ6,bV6)<<'\n';
//                }
//             }
//          }
//       }
      }
//
//
// set remaining sc target coords
//
      for(int iJ6= 0;iJ6<oJ6;iJ6++){
         int iR6=aut.W6J6R6(iW6,iJ6);
         int iZ0=aut.R6[iR6].Z0;
         int iR0=aut.R6[iR6].R0;
         std::string aa=tar.R0[iR0].aa;
         int mP1=tar.R0[iR0].P1a;
         int nP1=(mP1-1+tar.R0[iR0].cP1);
         int iV6=(aut.R6[iR6].V6a+vv.J6V6pck(iJ6));
         int mP6=aut.V6[iV6].P6a;
         int nP6=(mP6-1+aut.V6[iV6].cP6);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( tar.P1[iP1].sub==1 )continue;
            if( tar.P1[iP1].typ< 8 )continue;
            std::string atm=tar.P1[iP1].atm;
            bool MATCHED=false;
            for(int iP6=mP6;iP6<=nP6&&(!MATCHED);iP6++){
               if( aut.P6[iP6].atm!=atm )continue;
               tar.P1[iP1].sub=1;
               tar.P1[iP1].x=aut.P6[iP6].x;
               MATCHED=true;
            }
            if( !MATCHED ){
               std::cerr<<"ERROR: Unset target coords."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0+1)
                        <<" aa="<<aa
                        <<" iP1="<< std::setw( 2)<<(iP1-mP1+1)
                        <<" atm="<<atm<<'\n';
               std::exit( 2);
            }
         }
      }

   }
   return;
}
