#include "../hom/Homolog_Model.hh"
#include "../hom/Sub_Automatic.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_sub_grp {
private:
   std::vector<int> o_R6oV6;            //number of consistent rots
   std::vector<bool> o_V6sub;           //no overlap of rot with base
   std::vector<int> o_R6W6;             //mapping of site to unit
   std::vector<double> o_W6oV6;         //ln(number of rot combinations)
public:
   MEM_sub_grp(int oR6,int oV6):
      o_R6oV6(oR6),
      o_V6sub(oV6, true),
      o_R6W6(oR6),
      o_W6oV6(oR6)
   {
   }
   int& R6oV6(int i){
      return o_R6oV6.at( i);  }
   void V6sub(int i,bool a){
      o_V6sub[ i]=a;  }
   bool V6sub(int i){
      return o_V6sub[ i];  }
   int& R6W6(int i){
      return o_R6W6.at( i);  }
   double& W6oV6(int i){
      return o_W6oV6.at( i);  }
};

void Homolog_Model::SUB_GRP(Sub_Automatic& aut,
                            Output_Streams& out,
                            int pR0min,int pR0max){
//
//
// partition incomplete side chains into packing units
//
   int oR6=aut.nR6;
   if( oR6==0 ){
      aut.nW6=0;
      return;
   }
   int oV6=( aut.R6[oR6-1].V6a +aut.R6[oR6-1].cV6);
   MEM_sub_grp vv(oR6,oV6);
//
//
// check sc rotamers for overlap with base
//
   double zRRmin= std::pow(( 1.20),2);
   double zRRmax= std::pow((20.00),2);
   for(int jR6= 0;jR6<oR6;jR6++){
      int mV6=aut.R6[jR6].V6a;
      int nV6=(mV6-1+aut.R6[jR6].cV6);
      if( (nV6-mV6+1)>256 )nV6=(mV6-1+256);
      vv.R6oV6(jR6)=(nV6-mV6+1);
      for(int jV6=mV6;jV6<=nV6;jV6++){
         int mP6=aut.V6[jV6].P6a;
         int nP6=(mP6-1+aut.V6[jV6].cP6);
         bool OVERLAP=false;
         for(int iZ0= 0;iZ0<tar.nZ0&&(!OVERLAP);iZ0++){
            int mR0=tar.Z0[iZ0].R0a;
            int nR0=(mR0-1+tar.Z0[iZ0].cR0);
            for(int iR0=mR0;iR0<=nR0&&(!OVERLAP);iR0++){
               if( (iR0<pR0min)||(iR0>pR0max) )continue;
               int mP1=tar.R0[iR0].P1a;
               int nP1=(mP1-1+tar.R0[iR0].cP1);
               bool DISTANT=false;
               for(int jP6=mP6;jP6<=nP6&&(!OVERLAP)&&(!DISTANT);jP6++){
                  for(int iP1=mP1;iP1<=nP1&&(!OVERLAP)&&(!DISTANT);iP1++){
                     if( tar.P1[iP1].sub==0 )continue;
                     double zRR=( tar.P1[iP1].x -aut.P6[jP6].x).rr();
                     if      ( zRR<zRRmin ){
                        vv.V6sub(jV6,false);
                        vv.R6oV6(jR6)--;
                        OVERLAP=true;
                     }else if( zRR>zRRmax ){
                        DISTANT=true;
                     }
                  }
               }
            }
         }
      }
   }
//
//
// assemble packing units
//
   aut.W6.resize(oR6);
   aut.o_W6J6R6.resize(oR6*12);
   for(int iR6= 0;iR6<oR6;iR6++){
      vv.R6W6(iR6)=iR6;
      aut.W6[iR6].nJ6=1;
      aut.W6J6R6(iR6, 0)=iR6;
      vv.W6oV6(iR6)= std::log( vv.R6oV6(iR6));
   }
   int oW6=oR6;
   zRRmin= std::pow(( 3.20),2);
   zRRmax= std::pow((28.00),2);
   for(int iR6= 0;iR6<(oR6-1);iR6++){
      int iW6=vv.R6W6(iR6);
      int mV6=aut.R6[iR6].V6a;
      int nV6=(mV6-1+aut.R6[iR6].cV6);
      if( (nV6-mV6+1)>256 )nV6=(mV6-1+256);
      for(int jR6=(iR6+1);jR6<oR6;jR6++){
         int jW6=vv.R6W6(jR6);
         if( jW6==iW6 )continue;
         if( (aut.W6[iW6].nJ6+aut.W6[jW6].nJ6)>12 )continue;
         if( (vv.W6oV6(iW6)+vv.W6oV6(jW6))>(24.95) )continue;
         int jV6min=aut.R6[jR6].V6a;
         int jV6max=(jV6min-1+aut.R6[jR6].cV6);
         if( (jV6max-jV6min+1)>256 )jV6max=(jV6min-1+256);
         bool PASS=false;
         for(int iV6=mV6;iV6<=nV6&&(!PASS);iV6++){
            if( !vv.V6sub(iV6) )continue;
            int mP6=aut.V6[iV6].P6a;
            int nP6=(mP6-1+aut.V6[iV6].cP6);
            for(int jV6=jV6min;jV6<=jV6max&&(!PASS);jV6++){
               if( !vv.V6sub(jV6) )continue;
               int jP6min=aut.V6[jV6].P6a;
               int jP6max=(jP6min-1+aut.V6[jV6].cP6);
               for(int iP6=mP6;iP6<=nP6&&(!PASS);iP6++){
                  for(int jP6=jP6min;jP6<=jP6max&&(!PASS);jP6++){
                     double zRR=( aut.P6[jP6].x -aut.P6[iP6].x).rr();
                     if      ( zRR<zRRmin ){
                        int iJ6max=aut.W6[iW6].nJ6;
                        int jJ6max=aut.W6[jW6].nJ6;
                        if      ( jW6<iW6 ){
                           for(int iJ6= 0;iJ6<iJ6max;iJ6++){
                              int kR6=aut.W6J6R6(iW6,iJ6);
                              vv.R6W6(kR6)=jW6;
                              aut.W6J6R6(jW6,aut.W6[jW6].nJ6++)=kR6;
                           }
                           aut.W6[iW6].nJ6=0;
                           vv.W6oV6(jW6)+=vv.W6oV6(iW6);
                           vv.W6oV6(iW6)= (0.00);
                           iW6=jW6;
                        }else if( jW6>iW6 ){
                           for(int jJ6= 0;jJ6<jJ6max;jJ6++){
                              int kR6=aut.W6J6R6(jW6,jJ6);
                              vv.R6W6(kR6)=iW6;
                              aut.W6J6R6(iW6,aut.W6[iW6].nJ6++)=kR6;
                           }
                           aut.W6[jW6].nJ6=0;
                           vv.W6oV6(iW6)+=vv.W6oV6(jW6);
                           vv.W6oV6(jW6)= (0.00);
                        }
                        PASS=true;
                     }else if( zRR>zRRmax ){
                        PASS=true;
                     }
                  }
               }
            }
         }
      }
   }
   int jW6=0;
   for(int iW6= 0;iW6<oW6;iW6++){
      if( aut.W6[iW6].nJ6==0 )continue;
      if( iW6==jW6 ){
      }else{
         aut.W6[jW6].nJ6=aut.W6[iW6].nJ6;
         int nJ6=aut.W6[iW6].nJ6;
         for(int iJ6= 0;iJ6<nJ6;iJ6++){
            int kR6=aut.W6J6R6(iW6,iJ6);
            vv.R6W6(kR6)=jW6;
            aut.W6J6R6(jW6,iJ6)=kR6;
         }
      }
      jW6++;
   }
   aut.nW6=jW6;

   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<" nW6="<< std::setw( 3)<<aut.nW6<<'\n';
      for(int iW6= 0;iW6<aut.nW6;iW6++){
         int nJ6=aut.W6[iW6].nJ6;
         out.FILE3<<" iW6="<< std::setw( 3)<<iW6
                  <<" W6nJ6="<< std::setw( 2)<<nJ6<<'\n';
         for(int iJ6= 0;iJ6<nJ6;iJ6++){
            int iR6=aut.W6J6R6(iW6,iJ6);
            int iZ0=aut.R6[iR6].Z0;
            int iR0=aut.R6[iR6].R0;
            std::string aa=tar.R0[iR0].aa;
            out.FILE3<<" iW6="<< std::setw( 3)<<iW6
                     <<" iJ6="<< std::setw( 2)<<iJ6
                     <<" W6J6R6="<< std::setw( 4)<<iR6
                     <<" ["<< std::setw( 2)<<(iZ0+1)
                     <<':'<< std::setw( 4)<<(iR0+1)
                     <<"] "<<aa<<'\n';
         }
      }
   }
   return;
}
