#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../hom/Homolog_Model.hh"
#include "../hom/Sub_Automatic.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iomanip>
#include <cmath>

void Homolog_Model::SUB_GEN(Sub_Automatic& aut,
                            const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            Output_Streams& out){
//
//
// for each conf of each incomplete side chain generate atom coords
//
   int iP6=-1;
   for(int iR6= 0;iR6<aut.nR6;iR6++){
//    int iZ0=aut.R6[iR6].Z0;
      int iR0=aut.R6[iR6].R0;
      char c1=tar.R0[iR0].c1;
      std::string aa=tar.R0[iR0].aa;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      int iL0=tar.R0[iR0].L0;
      for(int jL0= 0;jL0<residue_mappings.nL0;jL0++){
         if( residue_mappings.L0[jL0].aa==aa )iL0=jL0;
      }
      int mP2=residue_mappings.L0[iL0].P2a;
      int nP2=(mP2-1+residue_mappings.L0[iL0].cP2);
      int mP1=tar.R0[iR0].P1a;
      int nP1=(mP1-1+tar.R0[iR0].cP1);
      int mQ6=aut.R6[iR6].Q6a;
//    int nQ6=(mQ6-1+aut.R6[iR6].cQ6);
      int mV6=aut.R6[iR6].V6a;
      int nV6=(mV6-1+aut.R6[iR6].cV6);
      for(int iV6=mV6;iV6<=nV6;iV6++){
         aut.V6[iV6].P6a=(iP6+1);
         aut.V6[iV6].cP6=0;
         int iC2=aut.V6[iV6].C2;
         int iQ6=mQ6;
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( tar.P1[iP1].sub==1 )continue;
            std::string atm=tar.P1[iP1].atm;
            int iT2=tar.P1[iP1].typ;
            if( iT2< 8 )continue;
            aut.P6.push_back( Sub_Automatic::tP6());
            iP6++;
            aut.V6[iV6].cP6++;
            aut.P6[iP6].atm=atm;
            aut.P6[iP6].typ=iT2;
            for(int iP2=mP2;iP2<=nP2;iP2++){
               if( residue_mappings.P2[iP2].grp0!=0 )continue;
               if( residue_mappings.P2[iP2].atm0!=atm )continue;
//             int j0R0=iR0;
               int j0P1=iP1;
               int j1R0=(iR0+residue_mappings.P2[iP2].grp1);
               int j2R0=(iR0+residue_mappings.P2[iP2].grp2);
               int j3R0=(iR0+residue_mappings.P2[iP2].grp3);
               std::string atm1=residue_mappings.P2[iP2].atm1;
               std::string atm2=residue_mappings.P2[iP2].atm2;
               std::string atm3=residue_mappings.P2[iP2].atm3;
               int j1P1=-1;
               int m1P1=tar.R0[j1R0].P1a;
               int n1P1=(m1P1-1+tar.R0[j1R0].cP1);
               for(int i1P1=m1P1;i1P1<=n1P1;i1P1++){
                  if( tar.P1[i1P1].atm==atm1 )j1P1=i1P1;
               }
               int j2P1=-1;
               int m2P1=tar.R0[j2R0].P1a;
               int n2P1=(m2P1-1+tar.R0[j2R0].cP1);
               for(int i2P1=m2P1;i2P1<=n2P1;i2P1++){
                  if( tar.P1[i2P1].atm==atm2 )j2P1=i2P1;
               }
               int j3P1=-1;
               int m3P1=tar.R0[j3R0].P1a;
               int n3P1=(m3P1-1+tar.R0[j3R0].cP1);
               for(int i3P1=m3P1;i3P1<=n3P1;i3P1++){
                  if( tar.P1[i3P1].atm==atm3 )j3P1=i3P1;
               }
               Coordinates zU=( tar.P1[j1P1].x -tar.P1[j2P1].x).normalize();
               Coordinates zV=( tar.P1[j3P1].x -tar.P1[j2P1].x);
               double zVU= dot(zV,zU);
               zV-=zVU*zU;
               zV.normalize();
               Coordinates zW=cross(zU,zV);
               Rotation_Matrix P;
               P(0,0)= zU(0);
               P(1,0)= zU(1);
               P(2,0)= zU(2);
               P(0,1)= zV(0);
               P(1,1)= zV(1);
               P(2,1)= zV(2);
               P(0,2)= zW(0);
               P(1,2)= zW(1);
               P(2,2)= zW(2);
               double D= residue_mappings.P2[iP2].dst;
               double thet=( (180.00) -residue_mappings.P2[iP2].lam)
                          *physics_consts.RAD;
               double CT= std::cos( thet);
               double ST= std::sin( thet);
               double phi= residue_mappings.P2[iP2].chi;
               if( phi>(999.) ){
                  phi= residue_mappings.C2Q6chi(iC2,iQ6++);
               }
               phi*=physics_consts.RAD;
               double CP= std::cos( phi);
               double SP= std::sin( phi);
               Coordinates x;
               x(0)= D*CT;
               x(1)= D*ST*CP;
               x(2)= D*ST*SP;
               tar.P1[j0P1].x=( tar.P1[j1P1].x +P*x);
               aut.P6[iP6].x=tar.P1[j0P1].x;
            }
         }
      }
   }
   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<< std::fixed<< std::setprecision( 3);
      for(int iR6= 0;iR6<aut.nR6;iR6++){
         int iZ0=aut.R6[iR6].Z0;
         int iR0=aut.R6[iR6].R0;
         std::string aa=tar.R0[iR0].aa;
         int mV6=aut.R6[iR6].V6a;
         int nV6=(mV6-1+aut.R6[iR6].cV6);
         out.FILE3<<" iR6="<< std::setw( 4)<<iR6
                  <<" R6Z0="<< std::setw( 2)<<(iZ0+1)
                  <<" R6R0="<< std::setw( 4)<<(iR0+1)
                  <<" aa="<<aa
                  <<" R6cV6="<< std::setw( 3)<<(nV6-mV6+1)
                  <<" V6cP6="<< std::setw( 2)<<aut.V6[mV6].cP6<<'\n';
//       for(int iV6=mV6;iV6<=nV6;iV6++){
//          out.FILE3<<" iV6="<< std::setw( 5)<<iV6<<'\n';
//          int mP6=aut.V6[iV6].P6a;
//          int nP6=(mP6-1+aut.V6[iV6].cP6);
//          for(int iP6=mP6;iP6<=nP6;iP6++){
//             out.FILE3<<" iP6="<< std::setw( 6)<<iP6
//                      <<" atm="<<aut.P6[iP6].atm;
//             for(int i=0;i<3;i++){
//                out.FILE3<< std::setw( 8)<<aut.P6[iP6].x(i);
//             }
//             out.FILE3<<'\n';
//          }
//       }
      }
   }
   return;
}
