#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../hom/Homolog_Model.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <string>
#include <cmath>

void Homolog_Model::SUB_BSE(const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            int pR0min,int pR0max){
//
//
// z-matrix addition of heavy atoms until chi dependence
//
   for(int iZ0= 0;iZ0<tar.nZ0;iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( (iR0<pR0min)||(iR0>pR0max) )continue;
         int mP1=tar.R0[iR0].P1a;
         int nP1=(mP1-1+tar.R0[iR0].cP1);
         char c1=tar.R0[iR0].c1;
         std::string aa=tar.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         if( tar.P1[mP1].sub==0 )continue;
         int iL0=tar.R0[iR0].L0;
         for(int jL0= 0;jL0<residue_mappings.nL0;jL0++){
            if( residue_mappings.L0[jL0].aa==aa )iL0=jL0;
         }
         int mP2=residue_mappings.L0[iL0].P2a;
         int nP2=(mP2-1+residue_mappings.L0[iL0].cP2);
         int n=( c1=='b' )? 3: 1;
         for(int i=0;i<n;i++){
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( tar.P1[iP1].sub==1 )continue;
            std::string atm=tar.P1[iP1].atm;
            int iT2=tar.P1[iP1].typ;
            if( iT2>= 8 ){
               for(int iP2=mP2;iP2<=nP2;iP2++){
                  if( residue_mappings.P2[iP2].grp0!=0 )continue;
                  if( residue_mappings.P2[iP2].atm0!=atm )continue;
//                int j0R0=iR0;
                  int j0P1=iP1;
                  int j1R0=iR0+residue_mappings.P2[iP2].grp1;
                  if( j1R0<mR0 )break;
                  if( j1R0>nR0 )break;
                  int j2R0=iR0+residue_mappings.P2[iP2].grp2;
                  if( j2R0<mR0 )break;
                  if( j2R0>nR0 )break;
                  int j3R0=iR0+residue_mappings.P2[iP2].grp3;
                  if( j3R0<mR0 )break;
                  if( j3R0>nR0 )break;
                  std::string atm1=residue_mappings.P2[iP2].atm1;
                  std::string atm2=residue_mappings.P2[iP2].atm2;
                  std::string atm3=residue_mappings.P2[iP2].atm3;
                  int j1P1=-1;
                  int m1P1=tar.R0[j1R0].P1a;
                  int n1P1=(m1P1-1+tar.R0[j1R0].cP1);
                  for(int i1P1=m1P1;i1P1<=n1P1;i1P1++){
                     if( tar.P1[i1P1].atm==atm1 )j1P1=i1P1;
                  }
                  if( j1P1==-1 )break;
                  int j2P1=-1;
                  int m2P1=tar.R0[j2R0].P1a;
                  int n2P1=(m2P1-1+tar.R0[j2R0].cP1);
                  for(int i2P1=m2P1;i2P1<=n2P1;i2P1++){
                     if( tar.P1[i2P1].atm==atm2 )j2P1=i2P1;
                  }
                  if( j2P1==-1 )break;
                  int j3P1=-1;
                  int m3P1=tar.R0[j3R0].P1a;
                  int n3P1=(m3P1-1+tar.R0[j3R0].cP1);
                  for(int i3P1=m3P1;i3P1<=n3P1;i3P1++){
                     if( tar.P1[i3P1].atm==atm3 )j3P1=i3P1;
                  }
                  if( j3P1==-1 )break;
                  if( tar.P1[j1P1].sub==0 )break;
                  if( tar.P1[j2P1].sub==0 )break;
                  if( tar.P1[j3P1].sub==0 )break;
                  double phi= residue_mappings.P2[iP2].chi;
                  if( phi>(999.) )break;
                  phi*=physics_consts.RAD;

                  Coordinates zU=( tar.P1[j1P1].x -tar.P1[j2P1].x).normalize();
                  Coordinates zV=( tar.P1[j3P1].x -tar.P1[j2P1].x);
                  double zVU= dot(zV,zU);
                  zV-=zVU*zU;
                  zV.normalize();
                  Coordinates zW=cross(zU,zV);
                  Rotation_Matrix P;
                  P(0,0)= zU(0);
                  P(1,0)= zU(1);
                  P(2,0)= zU(2);
                  P(0,1)= zV(0);
                  P(1,1)= zV(1);
                  P(2,1)= zV(2);
                  P(0,2)= zW(0);
                  P(1,2)= zW(1);
                  P(2,2)= zW(2);
                  double D= residue_mappings.P2[iP2].dst;
                  double thet=( (180.00) -residue_mappings.P2[iP2].lam);
                  thet*=physics_consts.RAD;
                  double CT= std::cos( thet);
                  double ST= std::sin( thet);
                  double CP= std::cos( phi);
                  double SP= std::sin( phi);
                  Coordinates x;
                  x(0)= D*CT;
                  x(1)= D*ST*CP;
                  x(2)= D*ST*SP;
                  tar.P1[j0P1].sub=1;
                  tar.P1[j0P1].x=( tar.P1[j1P1].x +P*x);
               }
            }
         }
         }

         if( iR0==nR0 ){
            if      ( c1=='a' ){
               int j0P1=nP1;
               if( tar.P1[j0P1].sub==1 )continue;
               int j1P1=-1;
               int j2P1=-1;
               int j3P1=-1;
               for(int iP1=mP1;iP1<nP1;iP1++){
                  if( tar.P1[iP1].atm==" C  " )j1P1=iP1;
                  if( tar.P1[iP1].atm==" CA " )j2P1=iP1;
                  if( tar.P1[iP1].atm==" O  " )j3P1=iP1;
               }
               if( tar.P1[j1P1].sub==0 )continue;
               if( tar.P1[j2P1].sub==0 )continue;
               if( tar.P1[j3P1].sub==0 )continue;

               Coordinates zU=( tar.P1[j1P1].x -tar.P1[j2P1].x).normalize();
               Coordinates zV=( tar.P1[j3P1].x -tar.P1[j2P1].x);
               double zVU= dot(zV,zU);
               zV-=zVU*zU;
               zV.normalize();
               Coordinates zW=cross(zU,zV);
               Rotation_Matrix P;
               P(0,0)= zU(0);
               P(1,0)= zU(1);
               P(2,0)= zU(2);
               P(0,1)= zV(0);
               P(1,1)= zV(1);
               P(2,1)= zV(2);
               P(0,2)= zW(0);
               P(1,2)= zW(1);
               P(2,2)= zW(2);
               double D= (1.229);
               double thet=( (180.00) -(120.40))*physics_consts.RAD;
               double CT= std::cos( thet);
               double ST= std::sin( thet);
               double phi= (180.00)*physics_consts.RAD;
               double CP= std::cos( phi);
               double SP= std::sin( phi);
               Coordinates x;
               x(0)= D*CT;
               x(1)= D*ST*CP;
               x(2)= D*ST*SP;
               tar.P1[j0P1].sub=1;
               tar.P1[j0P1].x=( tar.P1[j1P1].x +P*x);
            }else if( c1=='e' ){
               if( aa=="NME " )continue;
               if( aa=="NH2 " )continue;
            }else if( c1=='r' ){
            }else if( c1=='b' ){
            }else if( c1=='p' ){
            }else if( c1=='s' ){
            }
         }

      }
   }
   return;
}
