#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../hom/Homolog_Model.hh"
#include "../hom/Sub_Automatic.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <iomanip>
#include <cmath>

class MEM_sub_bbpck {
private:
   int o_R1;                                    //
   std::vector<Coordinates> o_D1R1N3x;          //backbone coordinates
   std::vector<double> o_D1f;                   //energy
   std::vector<Rotation_Matrix> o_R1Rphi;       //
   std::vector<Rotation_Matrix> o_R1Rpsi;       //
   std::vector<Rotation_Matrix> o_R1Romg;       //
public:
   MEM_sub_bbpck(int oD1,int oR1):
      o_R1(oR1),
      o_D1R1N3x(oD1*oR1*3),
      o_D1f(oD1),
      o_R1Rphi(oR1),
      o_R1Rpsi(oR1),
      o_R1Romg(oR1)
   {
   }
   Coordinates& D1R1N3x(int i,int j,int k){
      return o_D1R1N3x.at( i*o_R1*3 +j*3 +k);  }
   double& D1f(int i){
      return o_D1f.at( i);  }
   Rotation_Matrix& R1Rphi(int i){
      return o_R1Rphi.at( i);  }
   Rotation_Matrix& R1Rpsi(int i){
      return o_R1Rpsi.at( i);  }
   Rotation_Matrix& R1Romg(int i){
      return o_R1Romg.at( i);  }
};

void Homolog_Model::SUB_BBPCK(Sub_Automatic& aut,
                              const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_ENERGY_PARAMS& energy_params,
                              const DAT_RESIDUE_MAPPINGS& residue_mappings,
                              const DAT_DEFORM_PARAMS& deform_params,
                              Output_Streams& out,
                              int iZ2,int pR0min,int pR0max){
//
//
// generate bb target coords for insert-delete segments
//
   int oR1=sub.R1[def.Z2[iZ2].CYC].pt;
   int aR1=(def.Z2[iZ2].CYC);
   int bR1=(aR1-1+oR1);
   int aZ0=sub.R1[aR1].Z0;
   int aR0=sub.R1[aR1].R0;
   int bZ0=sub.R1[bR1].Z0;
   int bR0=sub.R1[bR1].R0;
   int aP1=tar.R0[aR0].P1a;
   int bP1=tar.R0[bR0].P1a;
   int lR1min=( tar.P1[aP1].sub==0 )? 0: 1;
   int lR1max=( tar.P1[bP1].sub==0 )? (oR1-1): (oR1-2);

   Rotation_Matrix ROT,ROT1,ROT2;
   Coordinates TRANS,TRANS1,TRANS2;
   if( lR1min== 1 ){
      int jP1=-1;
      int kP1=-1;
      int lP1=-1;
      int mP1=tar.R0[aR0].P1a;
      int nP1=(mP1-1+tar.R0[aR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( tar.P1[iP1].sub==0 )continue;
         std::string atm=tar.P1[iP1].atm;
         if( atm==" N  " )jP1=iP1;
         if( atm==" CA " )kP1=iP1;
         if( atm==" C  " )lP1=iP1;
      }
      Coordinates zU=( tar.P1[lP1].x -tar.P1[kP1].x);
      zU.normalize();
      Coordinates zV=( tar.P1[jP1].x -tar.P1[kP1].x);
      double zVU= dot(zV,zU);
      zV-=zVU*zU;
      zV.normalize();
      Coordinates zW=cross(zU,zV);
      ROT(0,0)= zU(0);
      ROT(1,0)= zU(1);
      ROT(2,0)= zU(2);
      ROT(0,1)= zV(0);
      ROT(1,1)= zV(1);
      ROT(2,1)= zV(2);
      ROT(0,2)= zW(0);
      ROT(1,2)= zW(1);
      ROT(2,2)= zW(2);
      TRANS= tar.P1[lP1].x;

   }else{
      int jP1=-1;
      int kP1=-1;
      int lP1=-1;
      int mP1=tar.R0[bR0].P1a;
      int nP1=(mP1-1+tar.R0[bR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( tar.P1[iP1].sub==0 )continue;
         std::string atm=tar.P1[iP1].atm;
         if( atm==" N  " )jP1=iP1;
         if( atm==" CA " )kP1=iP1;
         if( atm==" C  " )lP1=iP1;
      }
      if( (jP1==-1)||(kP1==-1)||(lP1==-1) ){
         std::cerr<<"ERROR: Missing bb segment too large."
                  <<" iR1min="<< std::setw( 2)<<aR1
                  <<" iR1max="<< std::setw( 2)<<bR1
                  <<" iZ0min="<< std::setw( 2)<<aZ0
                  <<" iR0min="<< std::setw( 4)<<aR0
                  <<" iZ0max="<< std::setw( 2)<<bZ0
                  <<" iR0max="<< std::setw( 4)<<bR0<<'\n';
         std::exit( 2);
      }
      Coordinates zU=( tar.P1[kP1].x -tar.P1[jP1].x);
      zU.normalize();
      Coordinates zV=( tar.P1[lP1].x -tar.P1[kP1].x);
      double zVU= dot(zV,zU);
      zV-=zVU*zU;
      zV.normalize();
      Coordinates zW=cross(zU,zV);
      ROT1(0,0)= zU(0);
      ROT1(1,0)= zU(1);
      ROT1(2,0)= zU(2);
      ROT1(0,1)= zV(0);
      ROT1(1,1)= zV(1);
      ROT1(2,1)= zV(2);
      ROT1(0,2)= zW(0);
      ROT1(1,2)= zW(1);
      ROT1(2,2)= zW(2);
      TRANS1= tar.P1[jP1].x;
   }

   int oD1=def.Z2[iZ2].nD1;
   MEM_sub_bbpck vv(oD1,oR1);
   double emin= (1.00e+16);
   int jD1=0;
   for(int iD1= 0;iD1<oD1;iD1++){

      for(int lR1=lR1min;lR1<=lR1max;lR1++){
         int iR1=(aR1+lR1);
//       int iZ0=sub.R1[iR1].Z0;
         int iR0=sub.R1[iR1].R0;
         int mP1=tar.R0[iR0].P1a;
         int nP1=(mP1-1+tar.R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            tar.P1[iP1].sub=0;
         }
      }
      if( lR1min==1 ){
         int mP1=tar.R0[aR0].P1a;
         int nP1=(mP1-1+tar.R0[aR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            std::string atm=tar.P1[iP1].atm;
            if( atm==" O  " )tar.P1[iP1].sub=0;
         }
      }

      for(int lR1= 0;lR1<oR1;lR1++){
//       int iR1=(aR1+lR1);
//       int mT5=sub.R1[iR1].T5a;
         double phi= physics_consts.RAD*def.Z2[iZ2].D1[iD1].R1[lR1].phi;
         double Cphi= std::cos( phi);
         double Sphi= std::sin( phi);
         vv.R1Rphi(lR1)(0,0)= (1.00);
         vv.R1Rphi(lR1)(1,0)= (0.00);
         vv.R1Rphi(lR1)(2,0)= (0.00);
         vv.R1Rphi(lR1)(0,1)= (0.00);
         vv.R1Rphi(lR1)(1,1)= Cphi;
         vv.R1Rphi(lR1)(2,1)= Sphi;
         vv.R1Rphi(lR1)(0,2)= (0.00);
         vv.R1Rphi(lR1)(1,2)=-Sphi;
         vv.R1Rphi(lR1)(2,2)= Cphi;
         double psi= physics_consts.RAD*def.Z2[iZ2].D1[iD1].R1[lR1].psi;
         double Cpsi= std::cos( psi);
         double Spsi= std::sin( psi);
         vv.R1Rpsi(lR1)(0,0)= (1.00);
         vv.R1Rpsi(lR1)(1,0)= (0.00);
         vv.R1Rpsi(lR1)(2,0)= (0.00);
         vv.R1Rpsi(lR1)(0,1)= (0.00);
         vv.R1Rpsi(lR1)(1,1)= Cpsi;
         vv.R1Rpsi(lR1)(2,1)= Spsi;
         vv.R1Rpsi(lR1)(0,2)= (0.00);
         vv.R1Rpsi(lR1)(1,2)=-Spsi;
         vv.R1Rpsi(lR1)(2,2)= Cpsi;
         double omg= physics_consts.RAD*def.Z2[iZ2].D1[iD1].R1[lR1].omg;
         double Comg= std::cos( omg);
         double Somg= std::sin( omg);
         vv.R1Romg(lR1)(0,0)= (1.00);
         vv.R1Romg(lR1)(1,0)= (0.00);
         vv.R1Romg(lR1)(2,0)= (0.00);
         vv.R1Romg(lR1)(0,1)= (0.00);
         vv.R1Romg(lR1)(1,1)= Comg;
         vv.R1Romg(lR1)(2,1)= Somg;
         vv.R1Romg(lR1)(0,2)= (0.00);
         vv.R1Romg(lR1)(1,2)=-Somg;
         vv.R1Romg(lR1)(2,2)= Comg;
      }
      Rotation_Matrix  zBphi,zB,zBpsi,zBomg;
//
// T1=(Rpsi*Upsi*Romg*Uomg*Rphi)
//
      zBpsi= vv.R1Rpsi( 0)*deform_params.Upsi;
      zB= zBpsi*vv.R1Romg( 0);
      zBomg= zB*deform_params.Uomg;
      zB= zBomg*vv.R1Rphi( 1);
      for(int i=0;i<3;i++){
         vv.D1R1N3x(iD1,  1, 0)(i)= zBpsi(i,0)*(1.335);
         vv.D1R1N3x(iD1,  1, 1)(i)=
         vv.D1R1N3x(iD1,  1, 0)(i) +zBomg(i,0)*(1.449);
      }
      for(int lR1= 2;lR1<oR1;lR1++){
//
//  T1=T1*Uphi*(Rpsi*Upsi*Romg*Uomg*Rphi)
//
         zBphi= zB*deform_params.Uphi;
         zB= zBphi*vv.R1Rpsi(lR1-1);
         zBpsi= zB*deform_params.Upsi;
         zB= zBpsi*vv.R1Romg(lR1-1);
         zBomg= zB*deform_params.Uomg;
         zB= zBomg*vv.R1Rphi(lR1  );
         for(int i=0;i<3;i++){
            vv.D1R1N3x(iD1,lR1-1, 2)(i)=
            vv.D1R1N3x(iD1,lR1-1, 1)(i) +zBphi(i,0)*(1.522);
            vv.D1R1N3x(iD1,lR1  , 0)(i)=
            vv.D1R1N3x(iD1,lR1-1, 2)(i) +zBpsi(i,0)*(1.335);
            vv.D1R1N3x(iD1,lR1  , 1)(i)=
            vv.D1R1N3x(iD1,lR1  , 0)(i) +zBomg(i,0)*(1.449);
         }
      }
      zBphi= zB*deform_params.Uphi;
      for(int i=0;i<3;i++){
         vv.D1R1N3x(iD1,oR1-1, 2)(i)=
         vv.D1R1N3x(iD1,oR1-1, 1)(i) +zBphi(i,0)*(1.522);
      }

      if( lR1min== 0 ){
         vv.D1R1N3x(iD1,  0, 0).zero();
         vv.D1R1N3x(iD1,  0, 0)(0)=( -(1.522)
                                          -(1.449)*deform_params.Uphi(0,0));
         vv.D1R1N3x(iD1,  0, 0)(1)= (1.449)*deform_params.Uphi(1,0);
         vv.D1R1N3x(iD1,  0, 1).zero();
         vv.D1R1N3x(iD1,  0, 1)(0)=-(1.522);
         vv.D1R1N3x(iD1,  0, 2).zero();
         ROT2= zB;
         TRANS2= vv.D1R1N3x(iD1,oR1-1, 0);
         ROT= ROT1*transpose(ROT2);
         TRANS=( TRANS1 -ROT*TRANS2);
      }
      for(int lR1=lR1min;lR1<=lR1max;lR1++){
         int iR1=(aR1+lR1);
//       int iZ0=sub.R1[iR1].Z0;
         int iR0=sub.R1[iR1].R0;
         int mP1=tar.R0[iR0].P1a;
         int nP1=(mP1-1+tar.R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            std::string atm=tar.P1[iP1].atm;
            int iN3;
            if      ( atm==(" N  ") ){
               iN3=0;
            }else if( atm==(" CA ") ){
               iN3=1;
            }else if( atm==(" C  ") ){
               iN3=2;
            }else{
               continue;
            }
            Coordinates x= vv.D1R1N3x(iD1,lR1,iN3);
            tar.P1[iP1].sub=1;
            tar.P1[iP1].x=( TRANS +ROT*x);
            vv.D1R1N3x(iD1,lR1,iN3)= tar.P1[iP1].x;
         }
      }
      if( lR1max==(oR1-1) ){
         int jP1=-1;
         int kP1=-1;
         int lP1=-1;
         int oP1=-1;
         int mP1=tar.R0[bR0].P1a;
         int nP1=(mP1-1+tar.R0[bR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            std::string atm=tar.P1[iP1].atm;
            if      ( atm==(" N  ") ){
               jP1=iP1;
            }else if( atm==(" CA ") ){
               kP1=iP1;
            }else if( atm==(" C  ") ){
               lP1=iP1;
            }else if( atm==(" O  ") ){
               oP1=iP1;
            }
         }
         Coordinates zU=( tar.P1[lP1].x -tar.P1[kP1].x);
         zU.normalize();
         Coordinates zV=( tar.P1[jP1].x -tar.P1[kP1].x);
         double zVU= dot(zV,zU);
         zV-=zVU*zU;
         zV.normalize();
         Coordinates zW=cross(zU,zV);
         Rotation_Matrix P;
         P(0,0)= zU(0);
         P(1,0)= zU(1);
         P(2,0)= zU(2);
         P(0,1)= zV(0);
         P(1,1)= zV(1);
         P(2,1)= zV(2);
         P(0,2)= zW(0);
         P(1,2)= zW(1);
         P(2,2)= zW(2);
         double D= (1.229);
         double thet=( (180.00) -(120.40))*physics_consts.RAD;
         double CT= std::cos( thet);
         double ST= std::sin( thet);
         double psi= (-90.00)*physics_consts.RAD;
         double CP= std::cos( psi);
         double SP= std::sin( psi);
         Coordinates x;
         x(0)= D*CT;
         x(1)= D*ST*CP;
         x(2)= D*ST*SP;
         tar.P1[oP1].sub=1;
         tar.P1[oP1].x=( tar.P1[lP1].x +P*x);
      }
      SUB_BSE(physics_consts,residue_mappings,
              pR0min,pR0max);

      vv.D1f(iD1)= def.Z2[iZ2].D1[iD1].p;
      for(int iZ0= 0;iZ0<tar.nZ0;iZ0++){
         int mR0=tar.Z0[iZ0].R0a;
         int nR0=(mR0-1+tar.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            if( (iR0<pR0min)||(iR0>pR0max) )continue;
            char ci=tar.R0[iR0].c1;
            std::string aa=tar.R0[iR0].aa;
            if( ci=='a' ){
               if( (aa[0]=='e')||
                   (aa[0]=='z') )aa=aa.substr(1,3)+' ';
               if( (aa[3]=='e')||
                   (aa[3]=='z') )aa=aa.substr(0,3)+' ';
            }
            int mP1=tar.R0[iR0].P1a;
            int nP1=(mP1-1+tar.R0[iR0].cP1);
            if( (iZ0==aZ0)&&
                (iR0>=aR0)&&(iR0<=bR0) )continue;
            for(int lR1=lR1min;lR1<=lR1max;lR1++){
               int jR1=(aR1+lR1);
//             int jZ0=sub.R1[jR1].Z0;
               int jR0=sub.R1[jR1].R0;
               char cj=tar.R0[jR0].c1;
               std::string ab=tar.R0[jR0].aa;
               if( cj=='a' ){
                  if( (ab[0]=='e')||
                      (ab[0]=='z') )ab=ab.substr(1,3)+' ';
                  if( (ab[3]=='e')||
                      (ab[3]=='z') )ab=ab.substr(0,3)+' ';
               }
               int jP1min=tar.R0[jR0].P1a;
               int jP1max=(jP1min-1+tar.R0[jR0].cP1);
               bool isCYSCYS=false;
               if( (aa=="CYS ")&&(ab=="CYS ") ){
                  for(int iS0= 0;iS0<tar.nS0;iS0++){
                     if      ( (tar.S0N2R0(iS0, 0)==jR0)&&
                               (tar.S0N2R0(iS0, 1)==iR0) ){
                        isCYSCYS=true;
                     }else if( (tar.S0N2R0(iS0, 0)==iR0)&&
                               (tar.S0N2R0(iS0, 1)==jR0) ){
                        isCYSCYS=true;
                     }
                  }
               }
               for(int iP1=mP1;iP1<=nP1;iP1++){
                  if( tar.P1[iP1].sub==0 )continue;
                  std::string atm1=tar.P1[iP1].atm;
                  int iT2=tar.P1[iP1].typ;
                  for(int jP1=jP1min;jP1<=jP1max;jP1++){
                     if( tar.P1[jP1].sub==0 )continue;
                     std::string atm2=tar.P1[jP1].atm;
                     int jT2=tar.P1[jP1].typ;
                     double zR= ( tar.P1[jP1].x -tar.P1[iP1].x).r();
                     if( zR<(1.00e-12) )zR= (1.00e-12);
                     if( isCYSCYS ){
                        if      ( (atm1==" CB ")&&(atm2==" CB ")&&
                                  (zR>(5.00)) ){
                           double zZ=( zR -(5.00));
                           vv.D1f(iD1)+=(2.00)*zZ*zZ;
                        }else if( (atm1==" CB ")&&(atm2==" SG ") ){
                           continue;
                        }else if( (atm1==" SG ")&&(atm2==" CB ") ){
                           continue;
                        }else if( (atm1==" SG ")&&(atm2==" SG ") ){
                           continue;
                        }
                     }
                     double zEPS= energy_params.T2T2e(iT2,jT2);
                     zEPS*=physics_consts.CAL;
                     double zRHO= energy_params.T2T2r(iT2,jT2);
                     zRHO*=physics_consts.ANG;
                     zRHO-=(.20);
                     double alp= energy_params.T2T2a(iT2,jT2);
                     alp+=(.02);
                     double zZ= (zR/zRHO);
                     double zF=( (1.00) +alp)/( zZ +alp);
                     double zG= (1.12)/( std::pow(zZ,7) +(.12));
                     vv.D1f(iD1)+=zEPS*( std::pow(zF,7)*( zG -(2.00)));
                     if( zR<aut.T2T2r(iT2,jT2) ){
                        vv.D1f(iD1)+=aut.T2T2e(iT2,jT2);
                     }
                  }
               }
            }
         }
      }

      if( vv.D1f(iD1)<emin ){
         emin= vv.D1f(iD1);
         jD1=iD1;
      }
   }

   for(int lR1=lR1min;lR1<=lR1max;lR1++){
      int iR1=(aR1+lR1);
//    int iZ0=sub.R1[iR1].Z0;
      int iR0=sub.R1[iR1].R0;
      int mP1=tar.R0[iR0].P1a;
      int nP1=(mP1-1+tar.R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         tar.P1[iP1].sub=0;
      }
   }
   if( lR1min==1 ){
      int mP1=tar.R0[aR0].P1a;
      int nP1=(mP1-1+tar.R0[aR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         std::string atm=tar.P1[iP1].atm;
         if( atm==" O  " )tar.P1[iP1].sub=0;
      }
   }
   for(int lR1=lR1min;lR1<=lR1max;lR1++){
      int iR1=(aR1+lR1);
//    int iZ0=sub.R1[iR1].Z0;
      int iR0=sub.R1[iR1].R0;
      int mP1=tar.R0[iR0].P1a;
      int nP1=(mP1-1+tar.R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         std::string atm=tar.P1[iP1].atm;
         int iN3;
         if      ( atm==(" N  ") ){
            iN3=0;
         }else if( atm==(" CA ") ){
            iN3=1;
         }else if( atm==(" C  ") ){
            iN3=2;
         }else{
            continue;
         }
         tar.P1[iP1].sub=1;
         tar.P1[iP1].x= vv.D1R1N3x(jD1,lR1,iN3);
      }
   }
   if( lR1max==(oR1-1) ){
      int jP1=-1;
      int kP1=-1;
      int lP1=-1;
      int oP1=-1;
      int mP1=tar.R0[bR0].P1a;
      int nP1=(mP1-1+tar.R0[bR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         std::string atm=tar.P1[iP1].atm;
         if      ( atm==(" N  ") ){
            jP1=iP1;
         }else if( atm==(" CA ") ){
            kP1=iP1;
         }else if( atm==(" C  ") ){
            lP1=iP1;
         }else if( atm==(" O  ") ){
            oP1=iP1;
         }
      }
      Coordinates zU=( tar.P1[lP1].x -tar.P1[kP1].x);
      zU.normalize();
      Coordinates zV=( tar.P1[jP1].x -tar.P1[kP1].x);
      double zVU= dot(zV,zU);
      zV-=zVU*zU;
      zV.normalize();
      Coordinates zW=cross(zU,zV);
      Rotation_Matrix P;
      P(0,0)= zU(0);
      P(1,0)= zU(1);
      P(2,0)= zU(2);
      P(0,1)= zV(0);
      P(1,1)= zV(1);
      P(2,1)= zV(2);
      P(0,2)= zW(0);
      P(1,2)= zW(1);
      P(2,2)= zW(2);
      double D= (1.229);
      double thet=( (180.00) -(120.40))*physics_consts.RAD;
      double CT= std::cos( thet);
      double ST= std::sin( thet);
      double psi= (-90.00)*physics_consts.RAD;
      double CP= std::cos( psi);
      double SP= std::sin( psi);
      Coordinates x;
      x(0)= D*CT;
      x(1)= D*ST*CP;
      x(2)= D*ST*SP;
      tar.P1[oP1].sub=1;
      tar.P1[oP1].x=( tar.P1[lP1].x +P*x);
   }
   SUB_BSE(physics_consts,residue_mappings,
           pR0min,pR0max);

   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<< std::fixed<< std::setprecision( 2);
      out.FILE3<<" iZ2="<< std::setw( 2)<<iZ2
               <<" nD1="<< std::setw( 4)<<def.Z2[iZ2].nD1<<'\n';
      int mR1=def.Z2[iZ2].CYC;
      int nR1=(mR1-1+sub.R1[mR1].pt);
      out.FILE3<<"  iD1"" -kT*ln(p)""   r ""       f    ""     cnf0\n";
      for(int iD1= 0;iD1<def.Z2[iZ2].nD1;iD1++){
         out.FILE3<< std::setw( 5)<<iD1
                  << std::setw( 9)<<def.Z2[iZ2].D1[iD1].p
                  << std::setw( 6)<<def.Z2[iZ2].D1[iD1].r
                  << std::setw(12)<<vv.D1f(iD1)<<"  ";
         for(int iR1=mR1;iR1<=nR1;iR1++){
            out.FILE3<<def.Z2[iZ2].D1[iD1].R1[iR1-mR1].cnfa;
         }
         out.FILE3<<'\n';
      }
   }
// std::string filename="../../"+tar.fam+"/dgn/subbse."+tar.mol+".pdb";
// std::ofstream ofile(filename.c_str());
// ofile<< std::fixed<< std::setprecision( 3);
// int i=0;
// for(int iZ0= 0;iZ0<tar.nZ0;iZ0++){
//    int mR0=tar.Z0[iZ0].R0a;
//    int nR0=(mR0-1+tar.Z0[iZ0].cR0);
//    for(int iR0=mR0;iR0<=nR0;iR0++){
//       char c1=tar.R0[iR0].c1;
//       std::string aa=tar.R0[iR0].aa;
//       if( c1=='a' ){
//          if( (aa[0]=='e')||
//              (aa[0]=='z') )aa=aa.substr(1,3)+' ';
//          if( (aa[3]=='e')||
//              (aa[3]=='z') )aa=aa.substr(0,3)+' ';
//       }
//       char cha=tar.R0[iR0].cha;
//       int res=tar.R0[iR0].res;
//       char ins=tar.R0[iR0].ins;
//       int mP1=tar.R0[iR0].P1a;
//       int nP1=(mP1-1+tar.R0[iR0].cP1);
//       for(int iP1=mP1;iP1<=nP1;iP1++){
//          if( tar.P1[iP1].sub==0 )continue;
//          std::string atm=tar.P1[iP1].atm;
//          int iT2=tar.P1[iP1].typ;
//          if( (aa=="CYH ")&&(atm==" HG ") )iT2=5;
//          if( iT2== 0 )continue;
//          if( iT2== 3 )continue;
//          i++;
//          ofile<<"ATOM  "
//               << std::setw( 5)<<i<<' '<<atm<<' '
//               <<aa.substr(0,3)<<' '<<cha<< std::setw( 4)<<res<<ins<<"   ";
//          for(int j=0;j<3;j++){
//             ofile<< std::setw( 8)<<tar.P1[iP1].x(j);
//          }
//          ofile<<'\n';
//       }
//    }
//    ofile<<"TER\n";
// }
// ofile.close();
   return;
}
