#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../hom/Homolog_Model.hh"
#include "../hom/Sub_Automatic.hh"
#include "../str/Output_Streams.hh"
#include <iostream>
#include <cstdlib>
#include <iomanip>

void Homolog_Model::SUB(const DAT_PHYSICS_CONSTS& physics_consts,
                        const DAT_ENERGY_PARAMS& energy_params,
                        const DAT_RESIDUE_MAPPINGS& residue_mappings,
                        const DAT_DEFORM_PARAMS& deform_params,
                        Output_Streams& out,
                        int pR0min,int pR0max){
   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"Homology Substitution"
               <<" pR0min="<< std::setw( 4)<<(pR0min+1)
               <<" pR0max="<< std::setw( 4)<<(pR0max+1)<<'\n';
   }
   Sub_Automatic aut;
//
//
// z-matrix addition of heavy atoms until chi dependence
//
   SUB_BSE(physics_consts,residue_mappings,
           pR0min,pR0max);
// std::cout<<" SUB_BSE"<< std::endl;
//
//
// generate bb target coords for insert-delete segments
//
   for(int iZ2= 0;iZ2<def.nZ2;iZ2++){
      SUB_BBPCK(aut,
                physics_consts,energy_params,residue_mappings,deform_params,
                out,
                iZ2,pR0min,pR0max);
   }
// std::cout<<" SUB_BBPCK"<< std::endl;
//
// base is all current atoms
// determine incomplete side chains, starting chi, set of confs
//
   SUB_USC(aut,
           physics_consts,residue_mappings,
           out,
           pR0min,pR0max);
// std::cout<<" SUB_USC"<< std::endl;
//
//
// for each conf of each incomplete side chain generate atom coords
//
   SUB_GEN(aut,
           physics_consts,residue_mappings,
           out);
// std::cout<<" SUB_GEN"<< std::endl;
//
//
// partition incomplete side chains into packing units
//
   SUB_GRP(aut,
           out,
           pR0min,pR0max);
// std::cout<<" SUB_GRP"<< std::endl;
//
// for all single res sc rotamer confs energy of sc-base
// for all pairs of sc rotamer confs energy of sc-sc
// dead end elimination
// set remaining sc target coords
//
   SUB_SCPCK(aut,
             physics_consts,energy_params,residue_mappings,
             out,
             pR0min,pR0max);
// std::cout<<" SUB_SCPCK"<< std::endl;
//
//
// target coords to regularized coords
//
   tar.REG(physics_consts,residue_mappings,out);
   tar.POLARH(physics_consts,residue_mappings);
   tar.TOR(physics_consts,residue_mappings);
   tar.CAR(physics_consts,residue_mappings);
   return;
}
