#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Family.hh"
#include "../fil/Structure.hh"
#include "../hom/Homolog_Model.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include "../sup/Kabsch_Rotation.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <iomanip>
#include <cmath>

class MEM_scr {
public:
   class tX8 { /*residues in template chain*/
   public:
      Rotation_Matrix cor;      //
      double sig;               //
      Rotation_Matrix u;        //
      int bX8;                  //
      Coordinates t;            //
      double d;                 //
      double zRR;               //
      bool sub;                 //
      int shf;                  //
      tX8(){}
   };
   class tP4 { /*sequence displacements in structure-structure alignment*/
   public:
      int X8;                   //
      Rotation_Matrix u;        //
      double sig;               //
      tP4(){}
   };
   class tQ4 { /*fragment alignments in structure-structure alignment*/
   public:
      int eX8;                  //
      int aX8;                  //
      int bX8;                  //
      int N4;                   //
      Rotation_Matrix u;        //
      Coordinates t;            //
      double d;                 //
      int F4;                   //
      bool sub;                 //
      tQ4(){}
   };
   class tZ4 { /*consistent fragment alignments*/
   public:
      int Q4;                   //
      tZ4(){}
   };
   class tF4 { /*collections of consistent fragment alignments*/
   public:
      std::vector<tZ4> Z4;      //
      int cX8;                  //
      tF4(){}
   };
public:
   std::vector<int> o_INCZ4;            //
   std::vector<int> o_R0gap;            //
   std::vector<tX8> X8;                 //
   std::vector<tP4> P4;                 //
   std::vector<tQ4> Q4;                 //
   std::vector<tF4> F4;                 //
   MEM_scr(){
   }
   int& INCZ4(int i){
      return o_INCZ4.at( i);  }
   int& R0gap(int i){
      return o_R0gap.at( i);  }
};

void Homolog_Model::SCR(const DAT_PHYSICS_CONSTS& physics_consts,
                        const DAT_RESIDUE_MAPPINGS& residue_mappings,
                        Output_Streams& out){
   MEM_scr vv;
//
//
// characterize longest template
//
   int oX8=tem.M1[ 0].nX8;              //number of virtual bonds
   int iM1= 0;                          //index
   for(int jM1= 1;jM1<tem.nM1;jM1++){
      if( tem.M1[jM1].nX8>oX8 ){
         oX8=tem.M1[jM1].nX8;
         iM1=jM1;
      }
   }
   for(int iZ0= 0;iZ0<tem.M1[iM1].nZ0;iZ0++){
      int mR0=tem.M1[iM1].Z0[iZ0].R0a;
      int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
//       if( tem.M1[iM1].R0[iR0].e>(9.00) )continue;
         tem.M1[iM1].R0[iR0].sub=1;
      }
   }
   {
      Structure str;
      str.FAM2STR(iM1,tem);
      str.cnf=TEMGRP;
      str.CAR2FIL();
   }
//
//
// align each template to longest
//
   for(int jM1= 0;jM1<tem.nM1;jM1++){
      if( jM1==iM1 )continue;
      int nX8=tem.M1[jM1].nX8;
      std::string dmp="../../"+tem.M1[jM1].fam+"/dgn/"+tem.M1[jM1].mol+".dmp";
//
//
// check sequence displacements of j with i for substructure matches
//
      vv.X8.resize(oX8);
      for(int jX8= 0;jX8<oX8;jX8++){
         vv.X8[jX8  ].sub=false;
         vv.X8[jX8  ].shf=-1;
      }
      vv.X8[ 0].cor.zero();
      {
         for(int eX8= 0;eX8<(oX8-1);eX8++){
            for(int jX8= 1;jX8<nX8;jX8++){
               int iX8=(jX8+eX8);
               if( iX8>(oX8-1) )iX8-=(oX8-1);
               vv.X8[jX8  ].cor=vv.X8[jX8-1].cor;
               for(int i=0;i<3;i++){
                  for(int j=0;j<3;j++){
                     vv.X8[jX8  ].cor(i,j)+=(tem.M1[iM1].X8[iX8  ].c(i)
                                            *tem.M1[jM1].X8[jX8  ].c(j));
                  }
               }
            }
            vv.X8[eX8  ].sig= (1.00e+8);
            int aX8min= 1;
            int aX8max=((nX8-1)-39+3);
            if( aX8max<aX8min )aX8max=aX8min;
            for(int aX8=aX8min;aX8<=aX8max;aX8+=4){
               int bX8=(aX8+39);
               if( bX8>(nX8-1) )bX8=(nX8-1);
               Rotation_Matrix R=( vv.X8[bX8  ].cor -vv.X8[aX8-1].cor);
               Kabsch_Rotation kab(physics_consts,R);
               double z1=( bX8-aX8+1);
               double z2=dot(kab.R,R);
               double sig= std::sqrt( (2.00)*( z1 -z2)/z1);
               if( sig<vv.X8[eX8  ].sig ){
                  vv.X8[eX8  ].sig= sig;
                  vv.X8[eX8  ].u=kab.R;
               }
            }
         }
//       std::ofstream ofile((dmp+"1").c_str());
//       ofile<< std::fixed;
//       ofile<<"X8u\n"<< std::setprecision( 2);
//       for(int eX8= 0;eX8<(oX8-1);eX8++){
//          ofile<< std::setw( 4)<<eX8<<' ';
//          for(int i=0;i<3;i++){
//             for(int j=0;j<3;j++){
//                ofile<< std::setw( 5)<<vv.X8[eX8  ].u(i,j);
//             }
//          }
//          ofile<<'\n';
//       }
//       ofile<<"X8sig\n"<< std::setprecision( 3);
//       for(int eX8= 0;eX8<(oX8-1);eX8++){
//          ofile<< std::setw( 4)<<eX8<<' '
//               << std::setw( 8)<<vv.X8[eX8  ].sig<<'\n';
//       }
//       ofile.close();
      }
//
//
// reduce set of sequence displacements
//
      int oP4=256;
      vv.P4.resize(oP4);
      for(int jP4= 0;jP4<oP4;jP4++){
         vv.P4[jP4  ].X8=-1;
         vv.P4[jP4  ].sig= (1.00e+8);
      }
      {
         for(int eX8= 0;eX8<(oX8-1);eX8++){
            if( vv.X8[eX8  ].sig>=vv.P4[oP4-1].sig )continue;
            vv.P4[oP4-1].sig= vv.X8[eX8  ].sig;
            vv.P4[oP4-1].X8=eX8;
            vv.P4[oP4-1].u=vv.X8[eX8  ].u;
            for(int iP4=(oP4-1);iP4> 0;iP4--){
               if( vv.P4[iP4  ].sig>=vv.P4[iP4-1].sig )break;
               double z= vv.P4[iP4-1].sig;
               vv.P4[iP4-1].sig= vv.P4[iP4  ].sig;
               vv.P4[iP4  ].sig= z;
               int j=vv.P4[iP4-1].X8;
               vv.P4[iP4-1].X8=vv.P4[iP4  ].X8;
               vv.P4[iP4  ].X8=j;
               Rotation_Matrix u=vv.P4[iP4-1].u;
               vv.P4[iP4-1].u=vv.P4[iP4  ].u;
               vv.P4[iP4  ].u=u;
            }
         }
         while( vv.P4[oP4-1].sig>=(1.00e+8) ){
            oP4--;
            if( oP4==0 )break;
         }
//       std::ofstream ofile((dmp+"2").c_str());
//       ofile<< std::fixed;
//       ofile<<"nP4\n";
//       ofile<< std::setw( 3)<<oP4<<'\n';
//       ofile<<"P4sig,P4X8,P4u\n";
//       for(int iP4= 0;iP4<oP4;iP4++){
//          ofile<< std::setw( 3)<<iP4<<' '
//               << std::setprecision( 3)<< std::setw( 8)<<vv.P4[iP4  ].sig<<' '
//               << std::setw( 4)<<vv.P4[iP4  ].X8<<' '<< std::setprecision( 2);
//          for(int i=0;i<3;i++){
//             for(int j=0;j<3;j++){
//                ofile<< std::setw( 5)<<vv.P4[iP4  ].u(i,j);
//             }
//          }
//          ofile<<'\n';
//       }
//       ofile.close();
      }
//
//
// gather fragment alignments for sequence displacements of j with i
//
      int nQ4=0;
      {
//       std::ofstream ofile((dmp+"3").c_str());
//       ofile<< std::fixed<< std::setprecision( 2);
         double CUT= (0.60);
         for(int iN4=0;iN4<2;iN4++){
            CUT+=(0.60);
            for(int iP4= 0;iP4<oP4;iP4++){
               int eX8=vv.P4[iP4  ].X8;

               vv.X8[ 0].sig= (0.00);
               for(int jX8= 1;jX8<nX8;jX8++){
                  int iX8=(jX8+eX8);
                  if( iX8>(oX8-1) )iX8-=(oX8-1);
                  tem.M1[iM1].X8[jX8  ].t=( tem.M1[iM1].X8[jX8-1].t
                                           +tem.M1[iM1].X8[iX8  ].x);
                  vv.X8[jX8  ].cor=vv.X8[jX8-1].cor;
                  for(int i=0;i<3;i++){
                     for(int j=0;j<3;j++){
                        vv.X8[jX8  ].cor(i,j)+=(tem.M1[iM1].X8[iX8  ].x(i)
                                               *tem.M1[jM1].X8[jX8  ].x(j));
                     }
                  }
                  vv.X8[jX8  ].sig= vv.X8[jX8-1].sig;
                  vv.X8[jX8  ].sig+=( tem.M1[iM1].X8[iX8  ].x.rr()
                                     +tem.M1[jM1].X8[jX8  ].x.rr());
                  vv.X8[jX8  ].bX8=0;
               }
               int bX8pt=0;
               int aX8min= 1;
               int aX8max=((nX8-1)-4);
               for(int aX8=aX8min;aX8<=aX8max;aX8++){
                  int bX8min=(aX8+4);
                  if( bX8min<bX8pt )bX8min=bX8pt;
                  int bX8max=(nX8-1);
                  for(int bX8=bX8min;bX8<=bX8max;bX8++){
                     double z=( bX8-aX8+1);
                     Coordinates t1= ((1.00)/z)*( tem.M1[iM1].X8[bX8  ].t
                                                 -tem.M1[iM1].X8[aX8-1].t);
                     Coordinates t2= ((1.00)/z)*( tem.M1[jM1].X8[bX8  ].t
                                                 -tem.M1[jM1].X8[aX8-1].t);
                     double zRR=( vv.X8[bX8  ].sig -vv.X8[aX8-1].sig);
                     zRR-=z*( t1.rr() +t2.rr());
                     Rotation_Matrix R=( vv.X8[bX8  ].cor -vv.X8[aX8-1].cor);
                     for(int i=0;i<3;i++){
                        for(int j=0;j<3;j++){
                           R(i,j)-=z*t1(i)*t2(j);
                        }
                     }
                     Kabsch_Rotation kab(physics_consts,R);
                     zRR-=(2.00)*dot(kab.R,R);
                     double zR= std::sqrt( (zRR/z));
                     if( bX8==bX8min )vv.X8[aX8  ].zRR= (( z -(1.00))/z)*zRR;
                     double zD= std::sqrt( zRR -vv.X8[aX8].zRR);
                     if( (zR<CUT)&&(zD<((1.25)*CUT)) ){
                        vv.X8[aX8  ].bX8=bX8;
                        bX8pt=bX8;
                        vv.X8[aX8  ].u=kab.R;
                        vv.X8[aX8  ].t=( t1 -kab.R*t2);
                        vv.X8[aX8  ].d= t2.r();
                        vv.X8[aX8  ].zRR= zRR;
                     }else{
                        break;
                     }
                  }
               }
//             ofile<<"X8bX8,X8u,X8t,X8d\n";
//             for(int aX8=aX8min;aX8<=aX8max;aX8++){
//                if( vv.X8[aX8  ].bX8>0 ){
//                  ofile<< std::setw( 4)<<aX8<<' '
//                       << std::setw( 4)<<vv.X8[aX8  ].bX8<<' ';
//                   for(int i=0;i<3;i++){
//                      for(int j=0;j<3;j++){
//                         ofile<< std::setw( 5)<<vv.X8[aX8  ].u(i,j);
//                      }
//                   }
//                   ofile<<' ';
//                   for(int i=0;i<3;i++){
//                      ofile<< std::setw( 8)<<vv.X8[aX8  ].t(i);
//                   }
//                   ofile<<' ';
//                   ofile<< std::setw( 8)<<vv.X8[aX8  ].d<<'\n';
//                }
//             }

               vv.X8[aX8max+1].bX8=0;
               bX8pt=0;
               for(int aX8=aX8min;aX8<=aX8max;aX8++){
                  if( vv.X8[aX8  ].bX8<=bX8pt )continue;
                  if( vv.X8[aX8  ].bX8==vv.X8[aX8+1].bX8 ){
                     double zD= std::sqrt( vv.X8[aX8  ].zRR -vv.X8[aX8+1].zRR);
                     if( zD>((1.25)*CUT) )continue;
                  }
                  bX8pt=vv.X8[aX8  ].bX8;
                  double zD= (1.00e+8);
                  for(int jP4=0;jP4<8;jP4++){
                     Rotation_Matrix du=( vv.X8[aX8  ].u -vv.P4[jP4  ].u);
                     double zR= std::sqrt( dot(du,du)/(3.00));
                     if( zR<zD )zD= zR;
                  }
                  if( zD>(.52) )continue;
                  vv.Q4.push_back( MEM_scr::tQ4());
                  vv.Q4[nQ4  ].eX8=eX8;
                  vv.Q4[nQ4  ].aX8=aX8;
                  vv.Q4[nQ4  ].bX8=vv.X8[aX8  ].bX8;
                  vv.Q4[nQ4  ].N4=iN4;
                  vv.Q4[nQ4  ].u=vv.X8[aX8  ].u;
                  vv.Q4[nQ4  ].t=vv.X8[aX8  ].t;
                  vv.Q4[nQ4  ].d=vv.X8[aX8  ].d;
                  vv.Q4[nQ4++].sub=false;
               }
            }
         }
//       ofile<<"nQ4\n";
//       ofile<< std::setw( 5)<<nQ4<<'\n';
//       ofile<<"Q4eX8,Q4aX8,Q4bX8,Q4N4,Q4u,Q4t,Q4d\n";
//       for(int iQ4= 0;iQ4<nQ4;iQ4++){
//          ofile<< std::setw( 5)<<iQ4<<' '
//               << std::setw( 4)<<vv.Q4[iQ4  ].eX8<<' '
//               << std::setw( 4)<<vv.Q4[iQ4  ].aX8<<' '
//               << std::setw( 4)<<vv.Q4[iQ4  ].bX8<<' '
//               << std::setw( 1)<<vv.Q4[iQ4  ].N4<<' ';
//          for(int i=0;i<3;i++){
//             for(int j=0;j<3;j++){
//                ofile<< std::setw( 5)<<vv.Q4[iQ4  ].u(i,j);
//             }
//          }
//          ofile<<' ';
//          for(int i=0;i<3;i++){
//             ofile<< std::setw( 8)<<vv.Q4[iQ4  ].t(i);
//          }
//          ofile<<' ';
//          ofile<< std::setw( 8)<<vv.Q4[iQ4  ].d<<'\n';
//       }
//       ofile.close();
      }

      vv.F4.resize(nQ4);
      for(int jF4= 0;jF4<nQ4;jF4++){
         vv.F4[jF4].Z4.clear();
         vv.F4[jF4  ].cX8=0;
      }
      int gF4=-1;
      {
//
//
// assemble first pass clusters of fragment alignments
//
//       std::ofstream ofile((dmp+"4").c_str());
//       ofile<< std::fixed<< std::setprecision( 2);
         int nF4=nQ4;
         for(int iQ4= 0;iQ4<nQ4;iQ4++){
            vv.Q4[iQ4  ].F4=iQ4;
            vv.F4[iQ4].Z4.push_back( MEM_scr::tZ4());
            vv.F4[iQ4].Z4[ 0].Q4=iQ4;
         }
         for(int iQ4= 0;iQ4<(nQ4-1);iQ4++){
            int iF4=vv.Q4[iQ4  ].F4;
            double z1=(( vv.Q4[iQ4  ].bX8-vv.Q4[iQ4  ].aX8)<6)? (0.5): (1.0);
            for(int jQ4=(iQ4+1);jQ4<nQ4;jQ4++){
               int jF4=vv.Q4[jQ4  ].F4;
               if( jF4==iF4 )continue;
               double z2=(( vv.Q4[jQ4  ].bX8-vv.Q4[jQ4  ].aX8)<6)? (0.5)*z1: z1;
               double tROT= z2*(.24);
               double tTRANS= z2*( (1.20) +(.24)*( vv.Q4[iQ4  ].d
                                                  +vv.Q4[jQ4  ].d));
               Rotation_Matrix du=( vv.Q4[jQ4].u -vv.Q4[iQ4].u);
               double zROT= std::sqrt( dot(du,du)/(3.00));
               if( zROT>tROT )continue;
               double zTRANS=( vv.Q4[jQ4  ].t -vv.Q4[iQ4  ].t).r();
               if( zTRANS>tTRANS )continue;
               if      ( jF4<iF4 ){
                  int oZ4=vv.F4[iF4].Z4.size();
                  int jZ4=vv.F4[jF4].Z4.size();
                  for(int iZ4= 0;iZ4<oZ4;iZ4++){
                     int kQ4=vv.F4[iF4].Z4[iZ4].Q4;
                     vv.Q4[kQ4].F4=jF4;
                     vv.F4[jF4].Z4.push_back( MEM_scr::tZ4());
                     vv.F4[jF4].Z4[jZ4++].Q4=kQ4;
                  }
                  vv.F4[iF4].Z4.clear();
                  iF4=jF4;
               }else if( jF4>iF4 ){
                  int oZ4=vv.F4[jF4].Z4.size();
                  int iZ4=vv.F4[iF4].Z4.size();
                  for(int jZ4= 0;jZ4<oZ4;jZ4++){
                     int kQ4=vv.F4[jF4].Z4[jZ4].Q4;
                     vv.Q4[kQ4].F4=iF4;
                     vv.F4[iF4].Z4.push_back( MEM_scr::tZ4());
                     vv.F4[iF4].Z4[iZ4++].Q4=kQ4;
                  }
                  vv.F4[jF4].Z4.clear();
               }
            }
         }
         {
            int jF4=0;
            for(int iF4= 0;iF4<nF4;iF4++){
               int oZ4=vv.F4[iF4].Z4.size();
               if( oZ4==0 )continue;
               if( iF4>jF4 ){
                  for(int iZ4= 0;iZ4<oZ4;iZ4++){
                     int kQ4=vv.F4[iF4].Z4[iZ4].Q4;
                     vv.Q4[kQ4].F4=jF4;
                     vv.F4[jF4].Z4.push_back( MEM_scr::tZ4());
                     vv.F4[jF4].Z4[iZ4].Q4=kQ4;
                  }
                  vv.F4[iF4].Z4.clear();
               }
               jF4++;
            }
            for(int iF4=jF4;iF4<nF4;iF4++){
               vv.F4.pop_back();
            }
            nF4=jF4;
         }
         int cX8max=0;
         for(int iF4= 0;iF4<nF4;iF4++){
            int oZ4=vv.F4[iF4].Z4.size();
            for(int iZ4= 0;iZ4<oZ4;iZ4++){
               int iQ4=vv.F4[iF4].Z4[iZ4].Q4;
               for(int jX8=vv.Q4[iQ4  ].aX8;jX8<=vv.Q4[iQ4  ].bX8;jX8++){
                  vv.X8[jX8].sub=true;
               }
            }
            for(int jX8= 1;jX8<nX8;jX8++){
               if( vv.X8[jX8].sub ){
                  vv.F4[iF4].cX8++;
                  vv.X8[jX8].sub=false;
               }
            }
            if( vv.F4[iF4].cX8>cX8max ){
               cX8max=vv.F4[iF4].cX8;
               gF4=iF4;
            }
         }
//       ofile<<"nF4,gF4\n";
//       ofile<< std::setw( 4)<<nF4<<' '
//            << std::setw( 4)<<gF4<<'\n';
//       ofile<<"F4nZ4,F4cX8\n";
//       for(int iF4= 0;iF4<nF4;iF4++){
//          int oZ4=vv.F4[iF4].Z4.size();
//          ofile<< std::setw( 4)<<iF4<<' '
//               << std::setw( 4)<<oZ4<<' '
//               << std::setw( 4)<<vv.F4[iF4].cX8<<'\n';
//       }
//       ofile<<"F4Z4Q4\n";
//       for(int iF4= 0;iF4<nF4;iF4++){
//          int oZ4=vv.F4[iF4].Z4.size();
//          for(int iZ4= 0;iZ4<oZ4;iZ4++){
//             ofile<< std::setw( 4)<<iF4<<' '
//                  << std::setw( 4)<<iZ4<<' '
//                  << std::setw( 5)<<vv.F4[iF4].Z4[iZ4].Q4<<'\n';
//          }
//       }
//
//
// reduce set of fragment alignments
//
         int n=(cX8max/2);
         for(int iF4= 0;iF4<nF4;iF4++){
            if( vv.F4[iF4].cX8<n )continue;
            int oZ4=vv.F4[iF4].Z4.size();
            for(int iZ4= 0;iZ4<oZ4;iZ4++){
                vv.Q4[vv.F4[iF4].Z4[iZ4].Q4].sub=true;
            }
         }
         int jQ4=0;
         for(int iQ4= 0;iQ4<nQ4;iQ4++){
            if( !vv.Q4[iQ4  ].sub )continue;
            vv.Q4[jQ4  ].eX8=vv.Q4[iQ4  ].eX8;
            vv.Q4[jQ4  ].aX8=vv.Q4[iQ4  ].aX8;
            vv.Q4[jQ4  ].bX8=vv.Q4[iQ4  ].bX8;
            vv.Q4[jQ4  ].N4=vv.Q4[iQ4  ].N4;
            vv.Q4[jQ4  ].u=vv.Q4[iQ4  ].u;
            vv.Q4[jQ4  ].t=vv.Q4[iQ4  ].t;
            vv.Q4[jQ4++].d= vv.Q4[iQ4  ].d;
         }
         for(int iQ4=jQ4;iQ4<nQ4;iQ4++){
            vv.Q4.pop_back();
         }
         nQ4=jQ4;
//       ofile<<"nQ4\n";
//       ofile<< std::setw( 5)<<nQ4<<'\n';
//       ofile<<"Q4eX8,Q4aX8,Q4bX8,Q4N4,Q4u,Q4t,Q4d\n";
//       for(int iQ4= 0;iQ4<nQ4;iQ4++){
//          ofile<< std::setw( 5)<<iQ4<<' '
//               << std::setw( 4)<<vv.Q4[iQ4  ].eX8<<' '
//               << std::setw( 4)<<vv.Q4[iQ4  ].aX8<<' '
//               << std::setw( 4)<<vv.Q4[iQ4  ].bX8<<' '
//               << std::setw( 1)<<vv.Q4[iQ4  ].N4<<' ';
//          for(int i=0;i<3;i++){
//             for(int j=0;j<3;j++){
//                ofile<< std::setw( 5)<<vv.Q4[iQ4  ].u(i,j);
//             }
//          }
//          ofile<<' ';
//          for(int i=0;i<3;i++){
//             ofile<< std::setw( 8)<<vv.Q4[iQ4  ].t(i);
//          }
//          ofile<<' ';
//          ofile<< std::setw( 8)<<vv.Q4[iQ4  ].d<<'\n';
//       }
//
//
// assemble second pass clusters of consistent fragment alignments
//
         nF4=nQ4;
         vv.F4.resize(nQ4);
         for(int jF4= 0;jF4<nQ4;jF4++){
            vv.F4[jF4].Z4.clear();
            vv.F4[jF4  ].cX8=0;
         }
         for(int iQ4= 0;iQ4<nQ4;iQ4++){
            vv.F4[iQ4].Z4.push_back( MEM_scr::tZ4());
            vv.F4[iQ4].Z4[ 0].Q4=iQ4;
            vv.F4[iQ4  ].cX8=( vv.Q4[iQ4  ].bX8-vv.Q4[iQ4  ].aX8+1);
            vv.Q4[iQ4  ].F4=iQ4;
         }
         double CUT= (0.60);
         for(int iN4=0;iN4<2;iN4++){
            CUT+=(0.60);
            for(double z0= (0.25);z0<(1.01);z0+=(.25)){

               for(int iQ4= 0;iQ4<(nQ4-1);iQ4++){
                  if( vv.Q4[iQ4  ].N4>iN4 )continue;
                  int iF4=vv.Q4[iQ4  ].F4;
                  if( iF4==-1 )continue;
                  double z1=(( vv.Q4[iQ4  ].bX8-vv.Q4[iQ4  ].aX8)<6)?
                            (0.5)*z0: z0;
                  for(int jQ4=(iQ4+1);jQ4<nQ4;jQ4++){
                     if( vv.Q4[jQ4  ].N4>iN4 )continue;
                     int jF4=vv.Q4[jQ4  ].F4;
                     if( jF4==-1 )continue;
                     if( jF4==iF4 )continue;
                     double z2=(( vv.Q4[jQ4  ].bX8-vv.Q4[jQ4  ].aX8)<6)?
                               (0.5)*z1: z1;
                     double tROT= z2*CUT*(.20);
                     double tTRANS= z2*CUT*( (1.00)
                                            +(.20)*( vv.Q4[iQ4  ].d
                                                    +vv.Q4[jQ4  ].d));
                     Rotation_Matrix du=( vv.Q4[jQ4].u -vv.Q4[iQ4].u);
                     double zROT= std::sqrt( dot(du,du)/(3.00));
                     if( zROT>tROT )continue;
                     double zTRANS=( vv.Q4[jQ4  ].t -vv.Q4[iQ4  ].t).r();
                     if( zTRANS>tTRANS )continue;
                     int pF4=( vv.F4[iF4  ].cX8>=vv.F4[jF4  ].cX8 )? iF4: jF4;
                     int qF4=( vv.F4[iF4  ].cX8>=vv.F4[jF4  ].cX8 )? jF4: iF4;
                     int pZ4max=vv.F4[pF4].Z4.size();
                     int qZ4max=vv.F4[qF4].Z4.size();
                     for(int qZ4= 0;qZ4<qZ4max;qZ4++){
                        int qQ4=vv.F4[qF4].Z4[qZ4].Q4;
                        if( qQ4==-1 )continue;

                        for(int pZ4= 0;pZ4<pZ4max;pZ4++){
                           int pQ4=vv.F4[pF4].Z4[pZ4].Q4;
                           if( pQ4==-1 )continue;
                           bool CONSISTENT=true;
                           for(int qX8=vv.Q4[qQ4].aX8;qX8<=vv.Q4[qQ4].bX8&&
                                CONSISTENT;qX8++){
                              int jX8=(qX8+vv.Q4[qQ4].eX8);
                              if( jX8>(oX8-1) )jX8-=(oX8-1);
                              for(int pX8=vv.Q4[pQ4].aX8;pX8<=vv.Q4[pQ4].bX8&&
                                   CONSISTENT;pX8++){
                                 int iX8=(pX8+vv.Q4[pQ4].eX8);
                                 if( iX8>(oX8-1) )iX8-=(oX8-1);
                                 if( ((pX8==qX8)&&(iX8!=jX8))||
                                     ((pX8!=qX8)&&(iX8==jX8)) ){
                                    vv.o_INCZ4.push_back(pZ4);
                                    CONSISTENT=false;
                                 }
                              }
                           }
                        }

                        int nINC=vv.o_INCZ4.size();
                        if( nINC==0 ){
                           vv.Q4[qQ4].F4=pF4;
                           int pZ4=vv.F4[pF4].Z4.size();
                           vv.F4[pF4].Z4.push_back( MEM_scr::tZ4());
                           vv.F4[pF4].Z4[pZ4].Q4=qQ4;
                           vv.F4[qF4].Z4[qZ4].Q4=-1;
                           pZ4max++;
                           for(int pZ4= 0;pZ4<pZ4max;pZ4++){
                              int pQ4=vv.F4[pF4].Z4[pZ4].Q4;
                              if( pQ4==-1 )continue;
                              for(int jX8=vv.Q4[pQ4].aX8;jX8<=vv.Q4[pQ4].bX8;
                                                         jX8++){
                                 vv.X8[jX8].sub=true;
                              }
                           }
                           vv.F4[pF4].cX8=0;
                           for(int jX8= 1;jX8<nX8;jX8++){
                              if( vv.X8[jX8].sub ){
                                 vv.F4[pF4].cX8++;
                                 vv.X8[jX8].sub=false;
                              }
                           }
                           for(int yZ4= 0;yZ4<qZ4max;yZ4++){
                              int yQ4=vv.F4[qF4].Z4[yZ4].Q4;
                              if( yQ4==-1 )continue;
                              for(int jX8=vv.Q4[yQ4].aX8;jX8<=vv.Q4[yQ4].bX8;
                                                         jX8++){
                                 vv.X8[jX8].sub=true;
                              }
                           }
                           vv.F4[qF4].cX8=0;
                           for(int jX8= 1;jX8<nX8;jX8++){
                              if( vv.X8[jX8].sub ){
                                 vv.F4[qF4].cX8++;
                                 vv.X8[jX8].sub=false;
                              }
                           }

                        }else{
                           int n0=vv.F4[pF4].cX8;
                           for(int pZ4= 0;pZ4<pZ4max;pZ4++){
                              int pQ4=vv.F4[pF4].Z4[pZ4].Q4;
                              if( pQ4==-1 )continue;
                              bool CONFLICT=false;
                              for(int k= 0;k<nINC&&(!CONFLICT);k++){
                                 if( vv.INCZ4(k)==pZ4 )CONFLICT=true;
                              }
                              if( CONFLICT )continue;
                              for(int jX8=vv.Q4[pQ4].aX8;jX8<=vv.Q4[pQ4].bX8;
                                                         jX8++){
                                 vv.X8[jX8].sub=true;
                              }
                           }
                           for(int jX8=vv.Q4[qQ4].aX8;jX8<=vv.Q4[qQ4].bX8;
                                                      jX8++){
                              vv.X8[jX8].sub=true;
                           }
                           int n1=0;
                           for(int jX8= 1;jX8<nX8;jX8++){
                              if( vv.X8[jX8].sub ){
                                 n1++;
                                 vv.X8[jX8].sub=false;
                              }
                           }
                           if( n1<=n0 ){
                              vv.o_INCZ4.clear();
                              continue;
                           }else{
                              for(int k= 0;k<nINC;k++){
                                 int pZ4=vv.INCZ4(k);
                                 int pQ4=vv.F4[pF4].Z4[pZ4].Q4;
                                 vv.F4[pF4].Z4[pZ4].Q4=-1;
                                 vv.Q4[pQ4].F4=-1;
                              }
                              vv.Q4[qQ4].F4=pF4;
                              int pZ4=vv.F4[pF4].Z4.size();
                              vv.F4[pF4].Z4.push_back( MEM_scr::tZ4());
                              vv.F4[pF4].Z4[pZ4].Q4=qQ4;
                              vv.F4[qF4].Z4[qZ4].Q4=-1;
                              vv.F4[pF4].cX8=n1;
                              for(int yZ4= 0;yZ4<qZ4max;yZ4++){
                                 int yQ4=vv.F4[qF4].Z4[yZ4].Q4;
                                 if( yQ4==-1 )continue;
                                 for(int jX8=vv.Q4[yQ4].aX8;jX8<=vv.Q4[yQ4].bX8;
                                                            jX8++){
                                    vv.X8[jX8].sub=true;
                                 }
                              }
                              vv.F4[qF4].cX8=0;
                              for(int jX8= 1;jX8<nX8;jX8++){
                                 if( vv.X8[jX8].sub ){
                                    vv.F4[qF4].cX8++;
                                    vv.X8[jX8].sub=false;
                                 }
                              }
                           }

                        }
                        vv.o_INCZ4.clear();
                     }
                     iF4=vv.Q4[iQ4  ].F4;
                     if( iF4==-1 )break;
                  }
               }

            }
         }
         {
            int jF4=0;
            for(int iF4= 0;iF4<nF4;iF4++){
               int jZ4=0;
               int oZ4=vv.F4[iF4  ].Z4.size();
               for(int iZ4= 0;iZ4<oZ4;iZ4++){
                  int iQ4=vv.F4[iF4  ].Z4[iZ4  ].Q4;
                  if( iQ4==-1 )continue;
                  vv.F4[iF4  ].Z4[jZ4++].Q4=iQ4;
               }
               for(int iZ4=jZ4;iZ4<oZ4;iZ4++){
                  vv.F4[iF4  ].Z4.pop_back();
               }
               if( jZ4==0 )continue;
               if( jF4<iF4 ){
                  vv.F4[jF4  ].Z4=vv.F4[iF4  ].Z4;
                  vv.F4[iF4  ].Z4.clear();
                  vv.F4[jF4  ].cX8=vv.F4[iF4  ].cX8;
                  vv.F4[iF4  ].cX8=0;
               }
               jF4++;
            }
            for(int iF4=jF4;iF4<nF4;iF4++){
               vv.F4.pop_back();
            }
            nF4=jF4;
         }
         cX8max=vv.F4[ 0].cX8;
         gF4=0;
         for(int iF4= 1;iF4<nF4;iF4++){
            if( vv.F4[iF4].cX8>cX8max ){
               cX8max=vv.F4[iF4].cX8;
               gF4=iF4;
            }
         }
//       ofile<<"nF4,gF4\n";
//       ofile<< std::setw( 4)<<nF4<<' '
//            << std::setw( 4)<<gF4<<'\n';
//       ofile<<"F4nZ4,F4cX8\n";
//       for(int iF4= 0;iF4<nF4;iF4++){
//          int oZ4=vv.F4[iF4].Z4.size();
//          ofile<< std::setw( 4)<<iF4<<' '
//               << std::setw( 4)<<oZ4<<' '
//               << std::setw( 4)<<vv.F4[iF4].cX8<<'\n';
//       }
//       ofile<<"F4Z4Q4\n";
//       for(int iF4= 0;iF4<nF4;iF4++){
//          int oZ4=vv.F4[iF4].Z4.size();
//          for(int iZ4= 0;iZ4<oZ4;iZ4++){
//             ofile<< std::setw( 4)<<iF4<<' '
//                  << std::setw( 4)<<iZ4<<' '
//                  << std::setw( 5)<<vv.F4[iF4].Z4[iZ4].Q4<<'\n';
//          }
//       }
//       ofile.close();
      }
//
//
// alignment of matched substructures
//
      {
         int iF4=gF4;
         Coordinates t1,t2;
         t1.zero();
         t2.zero();
         for(int jX8= 1;jX8<nX8;jX8++){
            vv.X8[jX8].sub=false;
         }
         int oZ4=vv.F4[iF4].Z4.size();
         for(int iZ4= 0;iZ4<oZ4;iZ4++){
            int iQ4=vv.F4[iF4].Z4[iZ4].Q4;
            int eX8=vv.Q4[iQ4].eX8;
            for(int jX8=vv.Q4[iQ4].aX8;jX8<=vv.Q4[iQ4].bX8;jX8++){
               if( vv.X8[jX8].sub )continue;
               vv.X8[jX8].sub=true;
               int iX8=(jX8+eX8);
               if( iX8>(oX8-1) )iX8-=(oX8-1);
               t1+=tem.M1[iM1].X8[iX8].x;
               t2+=tem.M1[jM1].X8[jX8].x;
            }
         }
         double z= vv.F4[iF4].cX8;
         t1/=z;
         t2/=z;
         double sig= (0.00);
         Rotation_Matrix R;
         R.zero();
         for(int jX8= 1;jX8<nX8;jX8++){
            vv.X8[jX8].sub=false;
         }
         for(int iZ4= 0;iZ4<oZ4;iZ4++){
            int iQ4=vv.F4[iF4].Z4[iZ4].Q4;
            int eX8=vv.Q4[iQ4].eX8;
            for(int jX8=vv.Q4[iQ4].aX8;jX8<=vv.Q4[iQ4].bX8;jX8++){
               if( vv.X8[jX8].sub )continue;
               vv.X8[jX8].sub=true;
               int iX8=(jX8+eX8);
               if( iX8>(oX8-1) )iX8-=(oX8-1);
               sig+=( ( tem.M1[iM1].X8[iX8].x -t1).rr()
                     +( tem.M1[jM1].X8[jX8].x -t2).rr());
               for(int i=0;i<3;i++){
                  for(int j=0;j<3;j++){
                     R(i,j)+=(( tem.M1[iM1].X8[iX8].x -t1)(i)
                             *( tem.M1[jM1].X8[jX8].x -t2)(j));
                  }
               }
            }
         }
         for(int jX8= 1;jX8<nX8;jX8++){
            vv.X8[jX8].sub=false;
         }
         Kabsch_Rotation kab(physics_consts,R);
         sig-=(2.00)*dot(kab.R,R);
         sig= std::sqrt( sig/z);

         Structure str;
         str.FAM2STR(jM1,tem);
         for(int iZ0= 0;iZ0<str.nZ0;iZ0++){
            int mR0=str.Z0[iZ0].R0a;
            int nR0=(mR0-1+str.Z0[iZ0].cR0);
            for(int iR0=mR0;iR0<=nR0;iR0++){
               int mP1=str.R0[iR0].P1a;
               int nP1=(mP1-1+str.R0[iR0].cP1);
               for(int iP1=mP1;iP1<=nP1;iP1++){
                  if( str.P1[iP1].sub==0 )continue;
                  Coordinates x=( str.P1[iP1].x -t2);
                  str.P1[iP1].x= kab.R*x +t1;
               }
            }
         }
         str.TOR(physics_consts,residue_mappings);
         str.cnf=TEMGRP;
         str.CAR2FIL();
         for(int iZ0= 0;iZ0<str.nZ0;iZ0++){
            tem.M1[jM1].Z0[iZ0].trans=str.Z0[iZ0].trans;
            tem.M1[jM1].Z0[iZ0].rot=str.Z0[iZ0].rot;
            int mR0=str.Z0[iZ0].R0a;
            int nR0=(mR0-1+str.Z0[iZ0].cR0);
            for(int iR0=mR0;iR0<=nR0;iR0++){
               int mP1=str.R0[iR0].P1a;
               int nP1=(mP1-1+str.R0[iR0].cP1);
               for(int iP1=mP1;iP1<=nP1;iP1++){
                  if( str.P1[iP1].sub==0 )continue;
                  tem.M1[jM1].P1[iP1].x=str.P1[iP1].x;
               }
               int mT1=str.R0[iR0].T1a;
               int nT1=(mT1-1+str.R0[iR0].cT1);
               for(int iT1=mT1;iT1<=nT1;iT1++){
                  tem.M1[jM1].T1[iT1].chi= str.T1[iT1].chi;
               }
            }
         }

         if( out.VERBOSE ){
            out.FILE3<< std::fixed<< std::setprecision( 2);
            out.FILE3<<"structure-structure alignment of "
                     <<tem.M1[jM1].mol<<" to "<<tem.M1[iM1].mol<<'\n';
            out.FILE3<<"C-alpha RMSD of aligned substructures="
                     << std::setw( 7)<<sig<<'\n';
//          out.FILE3<<"eigenvalues\n";
//          out.FILE3<< std::setw(12)<<kab.e1
//                   << std::setw(12)<<kab.e2
//                   << std::setw(12)<<kab.e3<<'\n';
//          out.FILE3<<"U\n";
//          for(int i=0;i<3;i++){
//             for(int j=0;j<3;j++){
//                out.FILE3<< std::setw( 8)<<kab.R(i,j);
//             }
//             out.FILE3<<'\n';
//          }
            out.FILE3<<"number of residues aligned="
                     << std::setw( 4)<<vv.F4[iF4].cX8<<'\n';
         }
         for(int iZ4= 0;iZ4<oZ4;iZ4++){
            int iQ4=vv.F4[iF4].Z4[iZ4].Q4;
            int eX8=vv.Q4[iQ4].eX8;
            for(int jX8=vv.Q4[iQ4].aX8;jX8<=vv.Q4[iQ4].bX8;jX8++){
               if( vv.X8[jX8].shf!=-1 )continue;
               vv.X8[jX8].shf=eX8;
            }
         }
         for(int jX8= 1;jX8<nX8;jX8++){
            if( vv.X8[jX8].shf==-1 )continue;
            int eX8=vv.X8[jX8].shf;
//          int jZ0=tem.M1[jM1].X8[jX8].Z0;
            int jR0=tem.M1[jM1].X8[jX8].R0;
            int iX8=(jX8+eX8);
            if( iX8>(oX8-1) )iX8-=(oX8-1);
//          int iZ0=tem.M1[iM1].X8[iX8].Z0;
            int iR0=tem.M1[iM1].X8[iX8].R0;
            if( out.VERBOSE ){
               out.FILE3<<tem.M1[jM1].R0[jR0].aa
                        <<tem.M1[jM1].R0[jR0].cha
                        << std::setw( 4)<<tem.M1[jM1].R0[jR0].res
                        <<tem.M1[jM1].R0[jR0].ins<<"   "
                        <<tem.M1[iM1].R0[iR0].aa
                        <<tem.M1[iM1].R0[iR0].cha
                        << std::setw( 4)<<tem.M1[iM1].R0[iR0].res
                        <<tem.M1[iM1].R0[iR0].ins<<'\n';
            }
//          if( (tem.M1[jM1].R0[jR0].e<(9.00))&&
//              (tem.M1[iM1].R0[iR0].e<(9.00)) ){
               tem.M1[jM1].R0[jR0].sub=iR0;
               tem.M1[iM1].R0[iR0].sub++;
//          }
         }
      }

      vv.Q4.clear();
   }
   {
      int oZ0=tem.M1[iM1].nZ0;
      int oR0=( tem.M1[iM1].Z0[oZ0-1].R0a +tem.M1[iM1].Z0[oZ0-1].cR0);
      vv.o_R0gap.resize(oR0);
      for(int jR0= 0;jR0<oR0;jR0++){
         vv.R0gap(jR0)=-1;
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int gap=1;
         int mR0=tem.M1[iM1].Z0[iZ0].R0a;
         int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            if( tem.M1[iM1].R0[iR0].sub==tem.nM1 ){
               vv.R0gap(iR0)=gap;
               gap=0;
            }else{
               gap=1;
            }
         }
      }
      for(int jM1= 0;jM1<tem.nM1;jM1++){
         if( jM1==iM1 )continue;
         for(int jZ0=0;jZ0<tem.M1[jM1].nZ0;jZ0++){
            int gap=1;
            int mR0=tem.M1[jM1].Z0[jZ0].R0a;
            int nR0=(mR0-1+tem.M1[jM1].Z0[jZ0].cR0);
            for(int jR0=mR0;jR0<=nR0;jR0++){
               if( tem.M1[jM1].R0[jR0].sub==-1 ){
                  gap=1;
               }else{
                  int iR0=tem.M1[jM1].R0[jR0].sub;
                  if( tem.M1[iM1].R0[iR0].sub==tem.nM1 ){
                     if( gap==1 )vv.R0gap(iR0)=gap;
                     gap=0;
                  }else{
                     gap=1;
                  }
               }
            }
         }
      }
      tem.M1[iM1].U5.clear();
      int iU5=-1;
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mR0=tem.M1[iM1].Z0[iZ0].R0a;
         int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int gap=vv.R0gap(iR0);
            if      ( gap== 1 ){
               tem.M1[iM1].U5.push_back( Family::tM1::tM1U5());
               iU5++;
               tem.M1[iM1].U5[iU5].Z0=iZ0;
               tem.M1[iM1].U5[iU5].R0a=iR0;
               tem.M1[iM1].U5[iU5].cR0=1;
            }else if( gap== 0 ){
               tem.M1[iM1].U5[iU5].cR0++;
            }else if( gap==-1 ){
            }
         }
      }
      tem.nU5=(iU5+1);
      for(int jM1= 0;jM1<tem.nM1;jM1++){
         if( jM1==iM1 )continue;
         tem.M1[jM1].U5.resize(tem.nU5);
         for(int jZ0=0;jZ0<tem.M1[jM1].nZ0;jZ0++){
            int mR0=tem.M1[jM1].Z0[jZ0].R0a;
            int nR0=(mR0-1+tem.M1[jM1].Z0[jZ0].cR0);
            for(int jR0=mR0;jR0<=nR0;jR0++){
               if( tem.M1[jM1].R0[jR0].sub==-1 ){
               }else{
                  int iR0=tem.M1[jM1].R0[jR0].sub;
                  int gap=vv.R0gap(iR0);
                  if      ( gap== 1 ){
                     int jU5=0;
                     for(int kU5= 0;kU5<tem.nU5;kU5++){
                        if( tem.M1[iM1].U5[kU5].R0a==iR0 )jU5=kU5;
                     }
                     tem.M1[jM1].U5[jU5].Z0=jZ0;
                     tem.M1[jM1].U5[jU5].R0a=jR0;
                     tem.M1[jM1].U5[jU5].cR0=tem.M1[iM1].U5[jU5].cR0;
                  }else if( gap== 0 ){
                  }else if( gap==-1 ){
                  }
               }
            }
         }
      }
      if( out.VERBOSE ){
         out.FILE3<<"Number of Aligned Structures="
                  << std::setw( 3)<<tem.nM1<<'\n';
         out.FILE3<<"Number of Alignment Elements="
                  << std::setw( 3)<<tem.nU5<<'\n';
         for(int iU5= 0;iU5<tem.nU5;iU5++){
            int lR0=tem.M1[iM1].U5[iU5].cR0;
            out.FILE3<<"Alignment Element="
                     << std::setw( 3)<<(iU5+1)
                     <<" Length="
                     << std::setw( 4)<<lR0<<'\n';
            int n=1+((lR0-1)/80);
            for(int i=0;i<n;i++){
               for(int jM1= 0;jM1<tem.nM1;jM1++){
                  int jZ0=tem.M1[jM1].U5[iU5].Z0;
                  int mR0=tem.M1[jM1].Z0[jZ0].R0a;
//                int nR0=(mR0-1+tem.M1[jM1].Z0[jZ0].cR0);
                  int jR0min=tem.M1[jM1].U5[iU5].R0a;
                  int jR0max=(jR0min-1+lR0);
                  int pR0min=( jR0min +i*80);
                  int pR0max=( (jR0min-1) +(i+1)*80);
                  if( pR0max>jR0max )pR0max=jR0max;
                  std::string buf=(tem.M1[jM1].mol
                                  +"            ").substr( 0,12);
                  out.FILE3<<buf
                           <<" ("<< std::setw( 2)<<(jZ0+1)<<':'
                           << std::setw( 4)<<(pR0min-mR0+1)<<'-'
                           << std::setw( 4)<<(pR0max-mR0+1)<<") ";
                  for(int pR0=pR0min;pR0<=pR0max;pR0++){
                     out.FILE3<<residue_mappings.L0[tem.M1[jM1].R0[pR0].L0].a1;
                  }
                  out.FILE3<<'\n';
               }
            }
         }
      }
   }

   return;
}
