#include "../hom/Homolog_Model.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iomanip>

void Homolog_Model::ALI_TEM(Output_Streams& out,
                            int iZ0){
   int mR0=tar.Z0[iZ0].R0a;
   int nR0=(mR0-1+tar.Z0[iZ0].cR0);
   for(int iU5= 0;iU5<tem.nU5;iU5++){

      int zR0alig=0;
      int j0M1=-1;
      for(int iM1= 0;iM1<tem.nM1;iM1++){
         int jM1=tem.M1ord(iM1);
         if( tem.M1[jM1].pid<( 10.) )continue;
         int jR0min=tem.M1[jM1].U5[iU5].R0a;
         int jR0max=(jR0min-1+tem.M1[jM1].U5[iU5].cR0);
         int yR0alig=0;
         bool INELEM=false;
         int nP8=tem.M1[jM1].nP8;
         for(int jP8= 0;jP8<nP8;jP8++){
            int aR0=tem.M1[jM1].P8[jP8].aR0;
            int bR0=tem.M1[jM1].P8[jP8].bR0;
            if( bR0==-1 ){
               if( INELEM )yR0alig--;
            }else{
               if( bR0==jR0min )INELEM=true;
               if( INELEM ){
                  if( aR0==-1 ){
                     yR0alig--;
                  }else{
                     yR0alig++;
                  }
               }
               if( bR0==jR0max )INELEM=false;
            }
         }
         if( yR0alig>zR0alig ){
            zR0alig=yR0alig;
            j0M1=jM1;
         }
      }
      int j0P8min=-1;
      int j0P8max=-1;
      if( j0M1>-1 ){
         bool PASS=false;
         for(int pZ0= 0;pZ0<iZ0&&(!PASS);pZ0++){
            int pR0min=tar.Z0[pZ0].R0a;
            int pR0max=(pR0min-1+tar.Z0[pZ0].cR0);
            for(int pR0=pR0min;pR0<=pR0max;pR0++){
               if( R0[pR0].U5==iU5 ){
                  if( R0[pR0].pid>=tem.M1[j0M1].pid ){
                     PASS=true;
                     break;
                  }
                  R0[pR0].temM1=-1;
                  R0[pR0].temZ0=-1;
                  R0[pR0].temR0=-1;
                  R0[pR0].U5=-1;
                  R0[pR0].pid= (0.00);
               }
            }
         }
         if( PASS )continue;
         int jR0min=tem.M1[j0M1].U5[iU5].R0a;
         int jR0max=(jR0min-1+tem.M1[j0M1].U5[iU5].cR0);
         bool INELEM=false;
         int nP8=tem.M1[j0M1].nP8;
         for(int jP8= 0;jP8<nP8;jP8++){
            int aR0=tem.M1[j0M1].P8[jP8].aR0;
            int bR0=tem.M1[j0M1].P8[jP8].bR0;
            if( bR0==-1 ){
            }else{
               if( bR0==jR0min ){
                  INELEM=true;
                  j0P8min=jP8;
               }
               if( INELEM ){
                  if( aR0==-1 ){
                  }else{
                     int kU5=R0[aR0].U5;
                     if( kU5>-1 ){
                        if( R0[aR0].pid>=tem.M1[j0M1].pid ){
                           PASS=true;
                           break;
                        }
                        for(int pR0=mR0;pR0<=nR0;pR0++){
                           if( R0[pR0].U5==kU5 ){
                              R0[pR0].temM1=-1;
                              R0[pR0].temZ0=-1;
                              R0[pR0].temR0=-1;
                              R0[pR0].U5=-1;
                              R0[pR0].pid= (0.00);
                           }
                        }
                     }
                  }
               }
               if( bR0==jR0max ){
                  INELEM=false;
                  j0P8max=jP8;
               }
            }
         }
         if( PASS )continue;
         for(int jP8=j0P8min;jP8<=j0P8max;jP8++){
            int aR0=tem.M1[j0M1].P8[jP8].aR0;
            int bR0=tem.M1[j0M1].P8[jP8].bR0;
            if( bR0==-1 ){
               R0[aR0].U5=iU5;
               R0[aR0].pid= tem.M1[j0M1].pid;
            }else{
               if( aR0==-1 ){
               }else{
                  R0[aR0].temM1=j0M1;
                  R0[aR0].temZ0=tem.M1[j0M1].R0[bR0].Z0;
                  R0[aR0].temR0=bR0;
                  R0[aR0].U5=iU5;
                  R0[aR0].pid= tem.M1[j0M1].pid;
               }
            }
         }
      }else{
         continue;
      }

      zR0alig=0;
      int zR0iden=0;
      int j1M1=-1;
      for(int iM1= 0;iM1<tem.nM1;iM1++){
         int jM1=tem.M1ord(iM1);
         if( tem.M1[jM1].pid<( 10.) )continue;
         int jZ0=tem.M1[jM1].U5[iU5].Z0;
         int jR0min=( (iU5> 0)&&(tem.M1[jM1].U5[iU5-1].Z0==jZ0) )?
                    ( tem.M1[jM1].U5[iU5-1].R0a +tem.M1[jM1].U5[iU5-1].cR0):
                    tem.M1[jM1].Z0[jZ0].R0a;
         int jR0max=(tem.M1[jM1].U5[iU5].R0a-1);
         if( jR0max<jR0min )continue;
         int yR0alig=0;
         int yR0iden=0;
         bool INELEM=false;
         bool INTARG=false;
         int nP8=tem.M1[jM1].nP8;
         for(int jP8= 0;jP8<nP8;jP8++){
            int aR0=tem.M1[jM1].P8[jP8].aR0;
            if( aR0>-1 )INTARG=true;
            int bR0=tem.M1[jM1].P8[jP8].bR0;
            if( bR0==-1 ){
               if( INELEM )yR0alig--;
            }else{
               if( bR0==jR0min )INELEM=true;
               if( INELEM ){
                  if( !INTARG ){
                  }else if( (aR0==-1)||(R0[aR0].U5>-1) ){
                     yR0alig--;
                  }else{
                     yR0alig++;
                     if( tem.M1[jM1].P8[jP8].alp==tem.M1[jM1].P8[jP8].bet )
                        yR0iden++;
                  }
               }
               if( bR0==jR0max )INELEM=false;
            }
         }
         if( (yR0alig>zR0alig)||((yR0alig==zR0alig)&&(yR0iden>zR0iden)) ){
            zR0alig=yR0alig;
            zR0iden=yR0iden;
            j1M1=jM1;
         }
      }
      int j1P8min=-1;
      int j1P8max=-1;
      if( j1M1>-1 ){
         int jZ0=tem.M1[j1M1].U5[iU5].Z0;
         int jR0min=( (iU5> 0)&&(tem.M1[j1M1].U5[iU5-1].Z0==jZ0) )?
                    ( tem.M1[j1M1].U5[iU5-1].R0a +tem.M1[j1M1].U5[iU5-1].cR0):
                    tem.M1[j1M1].Z0[jZ0].R0a;
         int jR0max=(tem.M1[j1M1].U5[iU5].R0a-1);
         bool INELEM=false;
         int nP8=tem.M1[j1M1].nP8;
         for(int jP8= 0;jP8<nP8;jP8++){
            int aR0=tem.M1[j1M1].P8[jP8].aR0;
            int bR0=tem.M1[j1M1].P8[jP8].bR0;
            if( bR0==-1 ){
               if( INELEM ){
                  R0[aR0].U5=iU5;
                  R0[aR0].pid= tem.M1[j0M1].pid;
               }
            }else{
               if( bR0==jR0min ){
                  INELEM=true;
                  j1P8min=jP8;
               }
               if( INELEM ){
                  if( aR0==-1 ){
                  }else{
                     R0[aR0].temM1=j1M1;
                     R0[aR0].temZ0=tem.M1[j1M1].R0[bR0].Z0;
                     R0[aR0].temR0=bR0;
                     R0[aR0].U5=iU5;
                     R0[aR0].pid= tem.M1[j0M1].pid;
                  }
               }
               if( bR0==jR0max ){
                  INELEM=false;
                  j1P8max=jP8;
               }
            }
         }
      }

      zR0alig=0;
      zR0iden=0;
      int j2M1=-1;
      for(int iM1= 0;iM1<tem.nM1;iM1++){
         int jM1=tem.M1ord(iM1);
         if( tem.M1[jM1].pid<( 10.) )continue;
         int jZ0=tem.M1[jM1].U5[iU5].Z0;
         int jR0min=( tem.M1[jM1].U5[iU5].R0a +tem.M1[jM1].U5[iU5].cR0);
         int jR0max;
         if( ((iU5+1)<tem.nU5)&&(tem.M1[jM1].U5[iU5+1].Z0==jZ0) ){
//          jR0max=(tem.M1[jM1].U5[iU5+1].R0a-1);
            continue;
         }else{
            jR0max=(tem.M1[jM1].Z0[jZ0].R0a-1+tem.M1[jM1].Z0[jZ0].cR0);
         }
         if( jR0max<jR0min )continue;
         int yR0alig=0;
         int yR0iden=0;
         bool INELEM=false;
         bool INTARG=true;
         int nP8=tem.M1[jM1].nP8;
         for(int jP8= 0;jP8<nP8;jP8++){
            int aR0=tem.M1[jM1].P8[jP8].aR0;
            int bR0=tem.M1[jM1].P8[jP8].bR0;
            if( bR0==-1 ){
               if( INELEM )yR0alig--;
            }else{
               if( bR0==jR0min )INELEM=true;
               if( INELEM ){
                  if( !INTARG ){
                  }else if( (aR0==-1)||(R0[aR0].U5>-1) ){
                     yR0alig--;
                  }else{
                     yR0alig++;
                     if( tem.M1[jM1].P8[jP8].alp==tem.M1[jM1].P8[jP8].bet )
                         yR0iden++;
                  }
               }
               if( bR0==jR0max )INELEM=false;
            }
            if( aR0==nR0 )INTARG=false;
         }
         if( (yR0alig>zR0alig)||((yR0alig==zR0alig)&&(yR0iden>zR0iden)) ){
            zR0alig=yR0alig;
            zR0iden=yR0iden;
            j2M1=jM1;
         }
      }
      int j2P8min=-1;
      int j2P8max=-1;
      if( j2M1>-1 ){
         int jZ0=tem.M1[j2M1].U5[iU5].Z0;
         int jR0min=( tem.M1[j2M1].U5[iU5].R0a +tem.M1[j2M1].U5[iU5].cR0);
         int jR0max=(tem.M1[j2M1].Z0[jZ0].R0a-1+tem.M1[j2M1].Z0[jZ0].cR0);
         bool INELEM=false;
         int nP8=tem.M1[j2M1].nP8;
         for(int jP8= 0;jP8<nP8;jP8++){
            int aR0=tem.M1[j2M1].P8[jP8].aR0;
            int bR0=tem.M1[j2M1].P8[jP8].bR0;
            if( bR0==-1 ){
               if( INELEM ){
                  R0[aR0].U5=iU5;
                  R0[aR0].pid= tem.M1[j0M1].pid;
               }
            }else{
               if( bR0==jR0min ){
                  INELEM=true;
                  j2P8min=jP8;
               }
               if( INELEM ){
                  if( aR0==-1 ){
                  }else{
                     R0[aR0].temM1=j2M1;
                     R0[aR0].temZ0=tem.M1[j2M1].R0[bR0].Z0;
                     R0[aR0].temR0=bR0;
                     R0[aR0].U5=iU5;
                     R0[aR0].pid= tem.M1[j0M1].pid;
                  }
               }
               if( bR0==jR0max ){
                  INELEM=false;
                  j2P8max=jP8;
               }
            }
         }
      }

      std::string buf="                                ";
      std::string moltar=(tar.mol+buf).substr( 0,32);
      if( j1M1>-1 ){
         if( out.VERBOSE ){
            out.FILE3<<"Preceding Structurally Conserved Element="
                     << std::setw( 3)<<iU5
                     <<", Length="
                     << std::setw( 4)<<(j1P8max-j1P8min+1)<<'\n';
         }
         std::string moltem=(tem.M1[j1M1].mol+buf).substr( 0,32);
         int n=1+((j1P8max-j1P8min)/80);
         for(int i=0;i<n;i++){
            int iP8min=( j1P8min +i*80);
            int iP8max=( (j1P8min-1) +(i+1)*80);
            if( iP8max>j1P8max )iP8max=j1P8max;
            int iR0min=-1;
            int iR0max=-1;
            int jZ0=-1;
            int jR0min=-1;
            int jR0max=-1;
            for(int iP8=iP8min;iP8<=iP8max;iP8++){
               int aR0=tem.M1[j1M1].P8[iP8].aR0;
               if( aR0==-1 ){
               }else{
                  if( iR0min==-1 ){
                     iR0min=aR0;
                  }
                  iR0max=aR0;
               }
               int bR0=tem.M1[j1M1].P8[iP8].bR0;
               if( bR0==-1 ){
               }else{
                  if( jR0min==-1 ){
                     jZ0=tem.M1[j1M1].R0[bR0].Z0;
                     jR0min=bR0;
                  }
                  jR0max=bR0;
               }
            }
            if( out.VERBOSE ){
               out.FILE3<<(moltar+"             ").substr( 0,13)
                        <<'('<< std::setw( 2)<<(iZ0+1)
                        <<':'<< std::setw( 4)<<(iR0min+1)
                        <<'-'<< std::setw( 4)<<(iR0max+1)<<") ";
               for(int iP8=iP8min;iP8<=iP8max;iP8++){
                  out.FILE3<<tem.M1[j1M1].P8[iP8].alp;
               }
               out.FILE3<<'\n';
               out.FILE3<<(moltem+"             ").substr( 0,13)
                        <<'('<< std::setw( 2)<<(jZ0+1)
                        <<':'<< std::setw( 4)<<(jR0min+1)
                        <<'-'<< std::setw( 4)<<(jR0max+1)<<") ";
               for(int iP8=iP8min;iP8<=iP8max;iP8++){
                  out.FILE3<<tem.M1[j1M1].P8[iP8].bet;
               }
               out.FILE3<<'\n';
            }
         }
      }
      if( j0M1>-1 ){
         if( out.VERBOSE ){
            out.FILE3<<"Structurally Conserved Element="
                     << std::setw( 3)<<iU5
                     <<", Length="
                     << std::setw( 4)<<(j0P8max-j0P8min+1)<<'\n';
         }
         std::string moltem=(tem.M1[j0M1].mol+buf).substr( 0,32);
         int n=1+((j0P8max-j0P8min)/80);
         for(int i=0;i<n;i++){
            int iP8min=( j0P8min +i*80);
            int iP8max=( (j0P8min-1) +(i+1)*80);
            if( iP8max>j0P8max )iP8max=j0P8max;
            int iR0min=-1;
            int iR0max=-1;
            int jZ0=-1;
            int jR0min=-1;
            int jR0max=-1;
            for(int iP8=iP8min;iP8<=iP8max;iP8++){
               int aR0=tem.M1[j0M1].P8[iP8].aR0;
               if( aR0==-1 ){
               }else{
                  if( iR0min==-1 ){
                     iR0min=aR0;
                  }
                  iR0max=aR0;
               }
               int bR0=tem.M1[j0M1].P8[iP8].bR0;
               if( bR0==-1 ){
               }else{
                  if( jR0min==-1 ){
                     jZ0=tem.M1[j0M1].R0[bR0].Z0;
                     jR0min=bR0;
                  }
                  jR0max=bR0;
               }
            }
            if( out.VERBOSE ){
               out.FILE3<<moltar
                        <<'('<< std::setw( 2)<<(iZ0+1)
                        <<':'<< std::setw( 4)<<(iR0min+1)
                        <<'-'<< std::setw( 4)<<(iR0max+1)<<") ";
               for(int iP8=iP8min;iP8<=iP8max;iP8++){
                  out.FILE3<<tem.M1[j0M1].P8[iP8].alp;
               }
               out.FILE3<<'\n';
               out.FILE3<<moltem
                        <<'('<< std::setw( 2)<<(jZ0+1)
                        <<':'<< std::setw( 4)<<(jR0min+1)
                        <<'-'<< std::setw( 4)<<(jR0max+1)<<") ";
               for(int iP8=iP8min;iP8<=iP8max;iP8++){
                  out.FILE3<<tem.M1[j0M1].P8[iP8].bet;
               }
               out.FILE3<<'\n';
            }
         }
      }
      if( j2M1>-1 ){
         if( out.VERBOSE ){
            out.FILE3<<"Following Structurally Conserved Element="
                     << std::setw( 3)<<iU5
                     <<", Length="
                     << std::setw( 4)<<(j2P8max-j2P8min+1)<<'\n';
         }
         std::string moltem=(tem.M1[j2M1].mol+buf).substr( 0,32);
         int n=1+((j2P8max-j2P8min)/80);
         for(int i=0;i<n;i++){
            int iP8min=( j2P8min +i*80);
            int iP8max=( (j2P8min-1) +(i+1)*80);
            if( iP8max>j2P8max )iP8max=j2P8max;
            int iR0min=-1;
            int iR0max=-1;
            int jZ0=-1;
            int jR0min=-1;
            int jR0max=-1;
            for(int iP8=iP8min;iP8<=iP8max;iP8++){
               int aR0=tem.M1[j2M1].P8[iP8].aR0;
               if( aR0==-1 ){
               }else{
                  if( iR0min==-1 ){
                     iR0min=aR0;
                  }
                  iR0max=aR0;
               }
               int bR0=tem.M1[j2M1].P8[iP8].bR0;
               if( bR0==-1 ){
               }else{
                  if( jR0min==-1 ){
                     jZ0=tem.M1[j2M1].R0[bR0].Z0;
                     jR0min=bR0;
                  }
                  jR0max=bR0;
               }
            }
            if( out.VERBOSE ){
               out.FILE3<<moltar
                        <<'('<< std::setw( 2)<<(iZ0+1)
                        <<':'<< std::setw( 4)<<(iR0min+1)
                        <<'-'<< std::setw( 4)<<(iR0max+1)<<") ";
               for(int iP8=iP8min;iP8<=iP8max;iP8++){
                  out.FILE3<<tem.M1[j2M1].P8[iP8].alp;
               }
               out.FILE3<<'\n';
               out.FILE3<<moltem
                        <<'('<< std::setw( 2)<<(jZ0+1)
                        <<':'<< std::setw( 4)<<(jR0min+1)
                        <<'-'<< std::setw( 4)<<(jR0max+1)<<") ";
               for(int iP8=iP8min;iP8<=iP8max;iP8++){
                  out.FILE3<<tem.M1[j2M1].P8[iP8].bet;
               }
               out.FILE3<<'\n';
            }
         }
      }

   }
   return;
}
