#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../hom/Homolog_Model.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>

class MEM_ali_sub {
private:
   std::vector<bool> o_R0sub;           //
public:
   MEM_ali_sub(int o):
      o_R0sub(o+1, false)
   {
   }
   void R0sub(int i,bool a){
      o_R0sub[ i]=a;
   }
   bool R0sub(int i){
      return o_R0sub[ i];
   }
};

void Homolog_Model::ALI_SUB(Output_Streams& out){
   int oZ0=tar.nZ0;
//
//
// initiate template and chain of template for alignment of target sequence
//  to family of template structures
//
   jM1init=-1;
   jZ0init=-1;
   bool MATCH=false;
   for(int iZ0= 0;iZ0<oZ0&&(!MATCH);iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0&&(!MATCH);iR0++){
         int jM1=R0[iR0].temM1;
         if( jM1>-1 ){
            jM1init=jM1;
            jZ0init=R0[iR0].temZ0;
            MATCH=true;
         }
      }
   }
   if( !MATCH ){
      std::cerr<<"ERROR: No homology found to templates.\n";
      std::exit( 2);
   }
//
//
// insertions and deletions
//
   nI4=-1;
   int qM1=jM1init;
   int qZ0=jZ0init;
   int qR0=(tem.M1[qM1].Z0[qZ0].R0a-1);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      int in=0;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         qR0++;
         int jM1=R0[iR0].temM1;
         int jZ0=R0[iR0].temZ0;
         int jR0=R0[iR0].temR0;
         if( jM1>-1 ){
            in=0;
            if( (jM1!=qM1)||(jZ0!=qZ0)||(jR0!=qR0) ){
               I4.push_back(tI4());
               nI4++;
               I4[nI4].Z0gap=iZ0;
               I4[nI4].R0gap=iR0;
               I4[nI4].dM1=(jM1-qM1);
               I4[nI4].dZ0=(jZ0-qZ0);
               I4[nI4].dR0=(jR0-qR0);
               qM1=jM1;
               qZ0=jZ0;
               qR0=jR0;
            }
         }else{
            in++;
         }
      }
      if( in>0 ){
         I4.push_back(tI4());
         nI4++;
         I4[nI4].Z0gap=iZ0;
         I4[nI4].R0gap=(nR0+1);
         I4[nI4].dM1=0;
         I4[nI4].dZ0=0;
         I4[nI4].dR0=-in;
      }
      if( (qZ0+1)<tem.M1[qM1].nZ0 ){
         qZ0++;
         qR0=(tem.M1[qM1].Z0[qZ0].R0a-1);
      }
   }
   nI4++;
//
//
// segments targeted for backbone structure generation
//
   int oR0=(tar.Z0[oZ0-1].R0a+tar.Z0[oZ0-1].cR0);
   MEM_ali_sub vv(oR0);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( R0[iR0].temM1==-1 ){
            int jR0min=(iR0-2);
            if( jR0min<mR0 )jR0min=mR0;
            int jR0max=(iR0+2);
            if( jR0max>nR0 )jR0max=nR0;
            for(int jR0=jR0min;jR0<=jR0max;jR0++){
               vv.R0sub(jR0, true);
            }
         }
      }
   }
   for(int iI4= 0;iI4<nI4;iI4++){
      int iZ0=I4[iI4].Z0gap;
      int iR0=I4[iI4].R0gap;
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      if( iR0==mR0 )continue;
      int dM1=I4[iI4].dM1;
      int dZ0=I4[iI4].dZ0;
      int dR0=I4[iI4].dR0;
      if      ( (dM1==0)&&(dZ0==0)&&(dR0<0) ){
      }else if( (dM1==0)&&(dZ0==0)&&(dR0>0) ){
         int jR0min=(iR0-2);
         if( jR0min<mR0 )jR0min=mR0;
         int jR0max=(iR0+1);
         if( jR0max>nR0 )jR0max=nR0;
         for(int jR0=jR0min;jR0<=jR0max;jR0++){
            vv.R0sub(jR0, true);
         }
      }else{
         int jM1=R0[iR0].temM1;
//       int jZ0=R0[iR0].temZ0;
         int jR0=R0[iR0].temR0;
         int qM1=R0[iR0-1].temM1;
//       int qZ0=R0[iR0-1].temZ0;
         int qR0=R0[iR0-1].temR0;
         if( qM1==-1 )continue;
         int qP1=-1;
         int yP1min=tem.M1[qM1].R0[qR0].P1a;
         int yP1max=(yP1min-1+tem.M1[qM1].R0[qR0].cP1);
         for(int yP1=yP1min;yP1<=yP1max;yP1++){
            if( tem.M1[qM1].P1[yP1].sub==0 )continue;
            if( tem.M1[qM1].P1[yP1].atm==" C  " )qP1=yP1;
         }
         int jP1=-1;
         yP1min=tem.M1[jM1].R0[jR0].P1a;
         yP1max=(yP1min-1+tem.M1[jM1].R0[jR0].cP1);
         for(int yP1=yP1min;yP1<=yP1max;yP1++){
            if( tem.M1[jM1].P1[yP1].sub==0 )continue;
            if( tem.M1[jM1].P1[yP1].atm==" N  " )jP1=yP1;
         }
         if( (qP1==-1)||(jP1==-1) ){
         }else{
            Coordinates zD=( tem.M1[jM1].P1[jP1].x -tem.M1[qM1].P1[qP1].x);
            double zR= zD.r();
            if( zR<(3.20) )continue;
         }
         int jR0min=(iR0-2);
         if( jR0min<mR0 )jR0min=mR0;
         int jR0max=(iR0+1);
         if( jR0max>nR0 )jR0max=nR0;
         for(int jR0=jR0min;jR0<=jR0max;jR0++){
            vv.R0sub(jR0, true);
         }
      }
   }
//
//
// search subspace
//
   int pR1=-1;
   int mT5=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      int iR0cap=(nR0+1);
      vv.R0sub(iR0cap,false);
      int jR0min=-1;
      int jR0max=-1;
      int jR0pt=-1;
      int zR0=0;
      for(int iR0=mR0;iR0<=iR0cap;iR0++){
         if( iR0<=jR0max )continue;
         if( vv.R0sub(iR0) ){
            if( jR0pt==-1 )jR0pt=iR0;
            zR0++;
         }else{
            if( jR0pt==-1 ){
            }else{
//
//
// evaluate span of segment
//
               if      ( zR0<=13 ){
                  zR0=(zR0/2);
                  zR0=( 2*zR0 +1);
               }else if( zR0<=26 ){
                  zR0=((zR0+1)/2);
                  zR0=( 2*zR0   );
               }else if( zR0<=39 ){
                  zR0=(zR0/2);
                  zR0=( 2*zR0 +1);
               }else if( zR0<=52 ){
                  zR0=((zR0+1)/2);
                  zR0=( 2*zR0   );
               }
               if( zR0< 5 )zR0= 5;
               jR0max=(jR0pt-1)+zR0;
               if( jR0max>nR0 ){
                  jR0pt=(nR0+1)-zR0;
                  jR0max=nR0;
                  if( jR0pt<mR0 ){
                     jR0pt=mR0;
                     zR0=(nR0-mR0+1);
                  }
               }
               if( jR0max==nR0 ){
                  char c1=tar.R0[nR0].c1;
                  std::string aa=tar.R0[nR0].aa;
                  if      ( c1=='a' ){
                  }else if( c1=='e' ){
                     if( (aa=="NH2 ")||(aa=="NME ") ){
                        jR0pt--;
                        jR0max--;
                        if( jR0pt<mR0 ){
                           jR0pt++;
                           jR0max--;
                           zR0-=2;
                        }
                     }
                  }else if( c1=='r' ){
                  }else if( c1=='b' ){
                  }else if( c1=='p' ){
                  }else if( c1=='s' ){
                  }
               }
               if( (jR0pt==mR0)||vv.R0sub(jR0pt-1) ){
                  jR0min=jR0pt;
               }else{
                  jR0min=(jR0pt-1);
               }
               int jR1pt=-1;
//
//
// add segment
//
               for(int jR0=jR0min;jR0<=jR0max;jR0++){
                  char c1=tar.R0[jR0].c1;
                  std::string aa=tar.R0[jR0].aa;
                  if( c1=='a' ){
                     if( (aa[0]=='e')||
                         (aa[0]=='z') )aa=aa.substr(1,3)+' ';
                     if( (aa[3]=='e')||
                         (aa[3]=='z') )aa=aa.substr(0,3)+' ';
                  }
                  sub.R1.push_back(Search_Subspace::tR1());
                  pR1++;
                  sub.R1[pR1].Z0=iZ0;
                  sub.R1[pR1].R0=jR0;
                  if( jR0<jR0pt ){
                     sub.R1[pR1].bb=0;
                     sub.R1[pR1].sc=0;
                  }else{
                     if( !vv.R0sub(jR0) )vv.R0sub(jR0, true);
                     sub.R1[pR1].bb=2;
                     sub.R1[pR1].sc=2;
                     if      ( c1=='a' ){
                        if( (aa=="GLY ")||
                            (aa=="UNK ") )sub.R1[pR1].sc=0;
                        if( (aa=="ALA ")||
                            (aa=="PRO ")||
                            (aa=="AIB ") )sub.R1[pR1].sc=1;
                     }else if( c1=='e' ){
                        if( (aa=="ACE ")||
                            (aa=="NME ")||
                            (aa=="NH2 ") )sub.R1[pR1].sc=0;
                     }else if( c1=='r' ){
                     }else if( c1=='b' ){
                     }else if( c1=='p' ){
                     }else if( c1=='s' ){
                        if( (aa=="H2O ") )sub.R1[pR1].sc=0;
                     }
                  }
                  sub.R1[pR1].pt=0;
                  if( jR0==jR0pt )jR1pt=pR1;
                  sub.R1[pR1].L0=tar.R0[jR0].L0;
                  sub.R1[pR1].aa=tar.R0[jR0].aa;
                  sub.R1[pR1].T5a=mT5;
                  sub.R1[pR1].cT5=tar.R0[jR0].cT1;
                  int mT1=tar.R0[jR0].T1a;
                  int nT1=(mT1-1+tar.R0[jR0].cT1);
                  for(int iT1=mT1;iT1<=nT1;iT1++){
                     sub.T5.push_back(Search_Subspace::tT5());
                     sub.T5[iT1-mT1+mT5].tor=tar.T1[iT1].tor;
                  }
                  mT5+=sub.R1[pR1].cT5;
               }
               if      ( zR0<=13 ){
                  sub.R1[jR1pt].pt=zR0;
               }else if( zR0<=26 ){
                  int l1R0=(zR0/2);
                  l1R0=(l1R0/2);
                  l1R0=( 2*l1R0 +1);
                  int l2R0=(zR0-l1R0);
                  sub.R1[jR1pt].pt=l1R0;
                  jR1pt+=l1R0;
                  sub.R1[jR1pt].pt=l2R0;
               }else if( zR0<=39 ){
                  int l1R0=(zR0/3);
                  l1R0=(l1R0/2);
                  l1R0=( 2*l1R0 +1);
                  zR0-=l1R0;
                  int l2R0=(zR0/2);
                  l2R0=(l2R0/2);
                  l2R0=( 2*l2R0 +1);
                  int l3R0=(zR0-l2R0);
                  sub.R1[jR1pt].pt=l1R0;
                  jR1pt+=l1R0;
                  sub.R1[jR1pt].pt=l2R0;
                  jR1pt+=l2R0;
                  sub.R1[jR1pt].pt=l3R0;
               }else if( zR0<=52 ){
                  int l1R0=(zR0/4);
                  l1R0=(l1R0/2);
                  l1R0=( 2*l1R0 +1);
                  zR0-=l1R0;
                  int l2R0=(zR0/3);
                  l2R0=(l2R0/2);
                  l2R0=( 2*l2R0 +1);
                  zR0-=l2R0;
                  int l3R0=(zR0/2);
                  l3R0=(l3R0/2);
                  l3R0=( 2*l3R0 +1);
                  int l4R0=(zR0-l3R0);
                  sub.R1[jR1pt].pt=l1R0;
                  jR1pt+=l1R0;
                  sub.R1[jR1pt].pt=l2R0;
                  jR1pt+=l2R0;
                  sub.R1[jR1pt].pt=l3R0;
                  jR1pt+=l3R0;
                  sub.R1[jR1pt].pt=l4R0;
               }

               jR0pt=-1;
               zR0=0;
            }
         }
      }
   }
   sub.nR1=(pR1+1);
   sub.mBOD=0;
   if( oZ0>1 ){
      for(int iR1= 0;iR1<sub.nR1;iR1++){
         if( sub.R1[iR1].bb==0 )continue;
         int iZ0=sub.R1[iR1].Z0;
         int iR0=sub.R1[iR1].R0;
         int mR0=tar.Z0[iZ0].R0a;
         if( iR0==mR0 )sub.mBOD=1;
      }
   }
//
//
// output search subspace
//
   if( out.VERBOSE ){
      out.FILE3<<"Segments Targeted for Backbone Structure Generation\n";
      for(int iR1= 0;iR1<sub.nR1;iR1++){
         if( sub.R1[iR1].pt==0 )continue;
         if( (iR1> 0)&&
             (sub.R1[iR1-1].Z0==sub.R1[iR1].Z0)&&
             (sub.R1[iR1-1].R0==(sub.R1[iR1].R0-1))&&
             (sub.R1[iR1-1].bb>0) )continue;
         int jR1min=iR1;
         int jR1max=iR1;
         for(int jR1=(iR1+1);jR1<sub.nR1;jR1++){
            if( (sub.R1[jR1].Z0==sub.R1[jR1-1].Z0)&&
                (sub.R1[jR1].R0==(sub.R1[jR1-1].R0+1))&&
                (sub.R1[jR1].bb>0) ){
               jR1max=jR1;
            }else{
               break;
            }
         }
         if( (iR1> 0)&&
             (sub.R1[iR1-1].Z0==sub.R1[iR1].Z0)&&
             (sub.R1[iR1-1].R0==(sub.R1[iR1].R0-1))&&
             (sub.R1[iR1-1].bb==0) ){
            jR1min--;
         }
         out.FILE3<< std::setw( 4)<<(jR1max-jR1min+1)<<'\n';
         for(int jR1=jR1min;jR1<=jR1max;jR1++){
            int jR0=sub.R1[jR1].R0;
            out.FILE3<<'['<< std::setw( 2)<<sub.R1[jR1].Z0
                     <<':'<< std::setw( 4)<<jR0<<']'
                     << std::setw( 3)<<sub.R1[jR1].bb
                     << std::setw( 2)<<sub.R1[jR1].sc
                     << std::setw( 2)<<sub.R1[jR1].pt
                     <<' '<<tar.R0[jR0].aa<<'\n';
         }
      }
   }
   return;
}
