#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../glo/Backbone_Defs.hh"
#include "../hom/Homolog_Model.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

bool Homolog_Model::ALI_DEF(const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_ARRAY_CONSTS& array_consts,
                            const DAT_DISULFIDE_LINKS& disulfide_links,
                            const DAT_ENERGY_PARAMS& energy_params,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            const DAT_REGION_MAPS& region_maps,
                            const DAT_DEFORM_PARAMS& deform_params,
                            Thread_Options& opt,
                            Output_Streams& out){
   int oZ0=tar.nZ0;
   int oR0=(tar.Z0[oZ0-1].R0a+tar.Z0[oZ0-1].cR0);
   int oQ1=oZ0;
   int oU1=0;
   int oF1=0;
   int oB1=0;
   int oG1=0;
   int oH1=0;
   int oJ1=0;
   int oY1=0;
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL0=tar.R0[iR0].L0;
      oQ1+=residue_mappings.L0[iL0].cQ0;
      oU1+=residue_mappings.L0[iL0].cU0;
      oF1+=residue_mappings.L0[iL0].cF0;
      oB1+=residue_mappings.L0[iL0].cB0;
      oG1+=residue_mappings.L0[iL0].cG0;
      oH1+=residue_mappings.L0[iL0].cH0;
      oJ1+=residue_mappings.L0[iL0].cJ0;
      oY1+=residue_mappings.L0[iL0].cY0;
   }
//
//
// assign temporary values to tar.Z0[].trans, tar.Z0[].rot, and tar.T1[].chi
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mT1=tar.R0[iR0].T1a;
         int nT1=(mT1-1+tar.R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            if      ( tar.T1[iT1].tor=="PHI" ){
               tar.T1[iT1].chi=( -75.00);
            }else if( tar.T1[iT1].tor=="PSI" ){
               tar.T1[iT1].chi=(  45.00);
            }else if( tar.T1[iT1].tor=="EPS" ){ //mean for A-form structure
               tar.T1[iT1].chi=(-148.00);
            }else if( tar.T1[iT1].tor=="ZET" ){
               tar.T1[iT1].chi=( -71.00);
            }else if( tar.T1[iT1].tor=="ALP" ){
               tar.T1[iT1].chi=( -65.00);
            }else if( tar.T1[iT1].tor=="BET" ){
               tar.T1[iT1].chi=( 174.00);
            }else if( tar.T1[iT1].tor=="GAM" ){
               tar.T1[iT1].chi=(  54.00);
            }else if( tar.T1[iT1].tor=="DEL" ){
               tar.T1[iT1].chi=(  81.00);
            }else{
               tar.T1[iT1].chi=( 180.00);
            }
         }
         char c1=tar.R0[iR0].c1;
         std::string aa=tar.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         if      ( c1=='a' ){
            if      ( aa=="ALA " ){
               tar.T1[mT1+ 3].chi=(  60.00);
            }else if( aa=="ILE " ){
               tar.T1[mT1+ 5].chi=(  60.00);
               tar.T1[mT1+ 6].chi=(  60.00);
            }else if( aa=="LEU " ){
               tar.T1[mT1+ 5].chi=(  60.00);
               tar.T1[mT1+ 6].chi=(  60.00);
            }else if( aa=="MET " ){
               tar.T1[mT1+ 6].chi=(  60.00);
            }else if( aa=="ARG " ){
               tar.T1[mT1+ 7].chi=(   0.00);
            }else if( aa=="THR " ){
               tar.T1[mT1+ 5].chi=(  60.00);
            }else if( aa=="VAL " ){
               tar.T1[mT1+ 4].chi=(  60.00);
               tar.T1[mT1+ 5].chi=(  60.00);
            }else if( aa=="TYR " ){
               tar.T1[mT1+ 5].chi=(   0.00);
            }
         }else if( c1=='e' ){
            if      ( aa=="ACE " ){
               tar.T1[mT1   ].chi=(   0.00);
            }
         }else if( c1=='r' ){
            if      ( aa=="RME " ){
               tar.T1[mT1+ 7].chi=(  60.00);
            }else if( aa=="MOE " ){
               tar.T1[mT1+10].chi=(  60.00);
            }else if( aa=="CET " ){
               tar.T1[mT1+ 8].chi=(  60.00);
            }
         }else if( c1=='b' ){
            if      ( aa=="T   " ){
               tar.T1[mT1+ 1].chi=(  60.00);
            }else if( aa=="TM  " ){
               tar.T1[mT1+ 1].chi=(  60.00);
            }
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }
   double z= (-1.00e+4);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      z+=( 1.00e+4);
      tar.Z0[iZ0].trans.zero();
      tar.Z0[iZ0].rot.zero();
      tar.Z0[iZ0].trans(0)+=z;
   }
//
// assign temporary values to tar.P1[].x for bb and any homologous sc atoms over
//  segments aligned to template
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=tar.R0[iR0].P1a;
         int nP1=(mP1-1+tar.R0[iR0].cP1);
         int iL0=tar.R0[iR0].L0;
         int jM1=R0[iR0].temM1;
//       int jZ0=R0[iR0].temZ0;
         int jR0=R0[iR0].temR0;
         if( jM1==-1 )continue;
         int jP1min=tem.M1[jM1].R0[jR0].P1a;
         int jP1max=(jP1min-1+tem.M1[jM1].R0[jR0].cP1);
         int jL0=tem.M1[jM1].R0[jR0].L0;
         std::string btm=residue_mappings.L0L0atm(iL0,jL0);
         if( btm=="____" ){
            if( (tar.R0[iR0].c1=='b')&&
                (tem.M1[jM1].R0[jR0].c1=='b') ){
               tar.P1[mP1  ].x=tem.M1[jM1].P1[jP1min  ].x;
               tar.P1[mP1  ].sub=1;
               tar.P1[mP1+1].x=tem.M1[jM1].P1[jP1min+1].x;
               tar.P1[mP1+1].sub=1;
            }
         }else{
            for(int iP1=mP1;iP1<=nP1;iP1++){
               int iT2=tar.P1[iP1].typ;
               if( iT2< 8 )continue;
               std::string atm=tar.P1[iP1].atm;
               for(int jP1=jP1min;jP1<=jP1max;jP1++){
                  if( tem.M1[jM1].P1[jP1].sub==0 )continue;
                  if( tem.M1[jM1].P1[jP1].atm!=atm )continue;
                  tar.P1[iP1].x=tem.M1[jM1].P1[jP1].x;
                  tar.P1[iP1].sub=1;
               }
               if( atm==btm )break;
            }
         }
      }
   }
   if( sub.nR1>0 ){
//
//
// construct Backbone_Defs object
//
      def=Backbone_Defs(physics_consts,residue_mappings,deform_params,
                        tar,sub);
      def.PATCH=true;
      for(int iZ2= 0;iZ2<def.nZ2;iZ2++){
         def.Z2[iZ2].J3.resize( 1);
         def.Z2[iZ2].J3[ 0].shf1=0;
         def.Z2[iZ2].J3[ 0].shf2=0;
         int aR1=(def.Z2[iZ2].CYC);
         int bR1=(def.Z2[iZ2].CYC-1+sub.R1[def.Z2[iZ2].CYC].pt);
//       int aZ0=sub.R1[aR1].Z0;
         int aR0=sub.R1[aR1].R0;
//       int bZ0=sub.R1[bR1].Z0;
         int bR0=sub.R1[bR1].R0;
         if( def.Z2[iZ2].Z0>= 0 ){
            def.Z2[iZ2].P.identity();
            def.Z2[iZ2].y00.zero();
            def.Z2[iZ2].R1[ 0].phi= (-130.00);
         }else{
            int jP1=-1;
            int kP1=-1;
            int lP1=-1;
            int mP1=tar.R0[aR0].P1a;
            int nP1=(mP1-1+tar.R0[aR0].cP1);
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( tar.P1[iP1].sub==0 )continue;
               std::string atm=tar.P1[iP1].atm;
               if( atm==" N  " )jP1=iP1;
               if( atm==" CA " )kP1=iP1;
               if( atm==" C  " )lP1=iP1;
            }
            if( (jP1==-1)||(kP1==-1)||(lP1==-1) ){
               std::cerr<<"ERROR: Gap segment too long.\n";
               return true;
            }
            Coordinates zU=( tar.P1[lP1].x -tar.P1[kP1].x);
            zU.normalize();
            Coordinates zV=( tar.P1[jP1].x -tar.P1[kP1].x);
            double zVU= dot(zV,zU);
            zV-=zVU*zU;
            zV.normalize();
            Coordinates zW=cross(zU,zV);
            def.Z2[iZ2].P(0,0)= zU(0);
            def.Z2[iZ2].P(1,0)= zU(1);
            def.Z2[iZ2].P(2,0)= zU(2);
            def.Z2[iZ2].P(0,1)= zV(0);
            def.Z2[iZ2].P(1,1)= zV(1);
            def.Z2[iZ2].P(2,1)= zV(2);
            def.Z2[iZ2].P(0,2)= zW(0);
            def.Z2[iZ2].P(1,2)= zW(1);
            def.Z2[iZ2].P(2,2)= zW(2);
            def.Z2[iZ2].y00= ((1.00)/physics_consts.ANG)*tar.P1[lP1].x;
            int pM1=R0[aR0].temM1;
//          int pZ0=R0[aR0].temZ0;
            int pR0=R0[aR0].temR0;
            int pT1=tem.M1[pM1].R0[pR0].T1a;
            def.Z2[iZ2].R1[ 0].phi= tem.M1[pM1].T1[pT1].chi;
         }
         if( def.Z2[iZ2].Z0==-1 ){
            def.Z2[iZ2].Q.identity();
            def.Z2[iZ2].y18.zero();
            def.Z2[iZ2].R1[bR1-aR1].psi= ( 140.00);
            def.Z2[iZ2].R1[bR1-aR1].omg= ( 180.00);
         }else{
            int jP1=-1;
            int kP1=-1;
            int lP1=-1;
            int mP1=tar.R0[bR0].P1a;
            int nP1=(mP1-1+tar.R0[bR0].cP1);
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( tar.P1[iP1].sub==0 )continue;
               std::string atm=tar.P1[iP1].atm;
               if( atm==" N  " )jP1=iP1;
               if( atm==" CA " )kP1=iP1;
               if( atm==" C  " )lP1=iP1;
            }
            if( (jP1==-1)||(kP1==-1)||(lP1==-1) ){
               std::cerr<<"ERROR: Gap segment too long.\n";
               return true;
            }
            Coordinates zU=( tar.P1[lP1].x -tar.P1[kP1].x);
            zU.normalize();
            Coordinates zV=( tar.P1[jP1].x -tar.P1[kP1].x);
            double zVU= dot(zV,zU);
            zV-=zVU*zU;
            zV.normalize();
            Coordinates zW=cross(zU,zV);
            def.Z2[iZ2].Q(0,0)= zU(0);
            def.Z2[iZ2].Q(1,0)= zU(1);
            def.Z2[iZ2].Q(2,0)= zU(2);
            def.Z2[iZ2].Q(0,1)= zV(0);
            def.Z2[iZ2].Q(1,1)= zV(1);
            def.Z2[iZ2].Q(2,1)= zV(2);
            def.Z2[iZ2].Q(0,2)= zW(0);
            def.Z2[iZ2].Q(1,2)= zW(1);
            def.Z2[iZ2].Q(2,2)= zW(2);
            def.Z2[iZ2].y18= ((1.00)/physics_consts.ANG)*tar.P1[lP1].x;
            int qM1=R0[bR0].temM1;
//          int qZ0=R0[bR0].temZ0;
            int qR0=R0[bR0].temR0;
            int qT1=tem.M1[qM1].R0[qR0].T1a;
            def.Z2[iZ2].R1[bR1-aR1].psi= tem.M1[qM1].T1[qT1+1].chi;
            def.Z2[iZ2].R1[bR1-aR1].omg= tem.M1[qM1].T1[qT1+2].chi;
         }
      }
      def.nJ3=1;
      def.CORE=false;
//
// construct Mechanical_System, Subset_Contracted_System, and
//  Conf_Dependent_System objects
//
      opt.QSUB="patch";
      opt.Rcut= (128.00);
      opt.MODE="bb ";
      Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
      Subset_Contracted_System col(disulfide_links,residue_mappings,
                                   opt,tar,sub);
      Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
      Distance_Constraints dst(physics_consts,residue_mappings,
                               opt,out,tar,sub);
      opt.iW0_active=-8;
      mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
              opt,tar,out,dst,col,dep);
      mol.CON(physics_consts,array_consts,energy_params,
              region_maps,
              opt,out,col,dep);
      sub.MECHSYS(residue_mappings,mol);
      const Subset_Contracted_System::tM3& con=col.M3[ 0];
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mR0=tar.Z0[iZ0].R0a;
         int nR0=(mR0-1+tar.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int mP1=tar.R0[iR0].P1a;
            int nP1=(mP1-1+tar.R0[iR0].cP1);
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( tar.P1[iP1].sub==0 )continue;
               std::string atm=tar.P1[iP1].atm;
               int iN6;
               if      ( atm==" N  " ){
                  iN6=0;
               }else if( atm==" CA " ){
                  iN6=1;
               }else if( atm==" C  " ){
                  iN6=2;
               }else if( atm==" H  " ){
                  iN6=3;
               }else if( atm==" CB " ){
                  iN6=4;
               }else if( atm==" O  " ){
                  iN6=5;
               }else{
                  continue;
               }
               int iF2=con.R0N6F2(iR0,iN6);
               dep.F2[iF2].x= ((1.00)/physics_consts.ANG)*tar.P1[iP1].x;
            }
         }
         Coordinates TRANS;
         TRANS=dep.Z0[iZ0].trans;
         double alp= dep.Z0[iZ0].rot(0);
         double bet= dep.Z0[iZ0].rot(1);
         double gam= dep.Z0[iZ0].rot(2);
         Rotation_Matrix ROT(alp,bet,gam);
         int mF2=con.Z0[iZ0].F2a;
         int nF2=(mF2-1+con.Z0[iZ0].cF2);
         for(int iF2=mF2;iF2<=nF2;iF2++){
            dep.F2[iF2].y=dep.F2[iF2].x;
            dep.F2[iF2].x.rotate(transpose(ROT),(dep.F2[iF2].x-TRANS));
         }
      }
//
//
// construct Energy_Surface and Local_Minimization objects
//
      int oQ2=con.oQ2;
      int oF2=con.oF2;
      int oE1=con.oE1;
      int oB6=con.oB6;
      int oG6=con.oG6;
      int oM3=col.nM3;
      int oU2=0;
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         if( con.Z0[iZ0].sub ){
            oU2+=6;
         }
         oU2+=(con.Z0[iZ0].cQ2-1);
      }
      oU2+=6;
      int oM2=2048;
      int oM4= 128;
      Energy_Surface4 ene(oZ0,oR0,oQ2,oF2,oE1,oB6,oG6,oU2);
      Local_Minimization4 loc(oM4,oM2,oM3);
// hydrogen bond constraints
      ene.HBC=0;
      ene.nU2=(oU2-6);
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         int iQ2min=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int iQ2=mQ2;iQ2<iQ2min;iQ2++){
            ene.Q2[iQ2].cut=false;
         }
         for(int iQ2=iQ2min;iQ2<=nQ2;iQ2++){
            ene.Q2[iQ2].cut=true;
         }
      }
      int iU2=0;
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         if( con.Z0[iZ0].sub ){
            ene.Z0[iZ0].U2a=iU2;
            ene.U2chi(iU2  )= dep.Z0[iZ0].trans(0);
            ene.U2chi(iU2+1)= dep.Z0[iZ0].trans(1);
            ene.U2chi(iU2+2)= dep.Z0[iZ0].trans(2);
            ene.U2chi(iU2+3)= dep.Z0[iZ0].rot(0);
            ene.U2chi(iU2+4)= dep.Z0[iZ0].rot(1);
            ene.U2chi(iU2+5)= dep.Z0[iZ0].rot(2);
            ene.U2uca(iU2  )= (2.00);
            ene.U2uca(iU2+1)= (2.00);
            ene.U2uca(iU2+2)= (2.00);
            ene.U2uca(iU2+3)= (.125);
            ene.U2uca(iU2+4)= (.125);
            ene.U2uca(iU2+5)= (.125);
            iU2+=6;
         }else{
            ene.Z0[iZ0].U2a=ene.nU2;
         }
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         if( nQ2>mQ2 ){
            for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
               ene.Q2[iQ2].U2=iU2;
               ene.U2chi(iU2)= dep.Q2[iQ2].chi;
               ene.U2uca(iU2)=( con.Q2[iQ2].br>0 )? (.500): (.125);
               if( ene.Q2[iQ2].cut )ene.U2uca(iU2)= (0.00);
               iU2++;
            }
         }
      }
      loc.BETA= (2.00e-2);
      loc.BMIN= (2.00e-9);
      loc.BMAX= (0.80e-1);
      loc.BDEL= (1.00e-1);
      loc.EPS1= (1.00e-3);
      loc.EPS2= (1.00e-2);
      loc.nM2=32;
      loc.BET1= (4.00e-2);
      loc.cM2_1=18;
      loc.cM4_1= 9;
      loc.EPS1= ene.nU2*(loc.EPS1*loc.EPS1);
      loc.BETA= std::sqrt( ene.nU2)*loc.BETA;
      loc.BMIN= std::sqrt( ene.nU2)*loc.BMIN;
      loc.BMAX= std::sqrt( ene.nU2)*loc.BMAX;
      loc.BET1= std::sqrt( ene.nU2)*loc.BET1;
//
//
// generate gap segment backbone confs
//
      int iJ3=0;
      for(int iZ2= 0;iZ2<def.nZ2;iZ2++){
         def.DEF(physics_consts,energy_params,residue_mappings,
                 deform_params,region_maps,
                 opt,out,tar,sub,mol,con,dep,ene,loc,
                 iZ2,iJ3);
         if( def.Z2[iZ2].nD1==0 ){
            std::cerr<<"ERROR: No backbone conf found for gap segment.\n";
            return true;
//          std::exit( 2);
         }
         if( out.VERBOSE ){
            out.FILE3<< std::fixed<< std::setprecision( 2);
            out.FILE3<<"BACKBONE DEFORMATIONS, segment="
                     << std::setw( 2)<<iZ2<<'\n';
            int mR1=def.Z2[iZ2].CYC;
            int nR1=(mR1-1+sub.R1[mR1].pt);
            out.FILE3<<"  iD1"" -kT*ln(p) ""   cnf0\n";
            for(int iD1= 0;iD1<def.Z2[iZ2].nD1;iD1++){
               out.FILE3<< std::setw( 5)<<iD1
                        << std::setw( 9)<<def.Z2[iZ2].D1[iD1].p<<"  ";
               for(int iR1=mR1;iR1<=nR1;iR1++){
                  out.FILE3<<def.Z2[iZ2].D1[iD1].R1[iR1-mR1].cnfa;
               }
               out.FILE3<<'\n';
            }
         }
      }
   }else{
      def.nZ2=0;
   }
   return false;
}
