#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Family.hh"
#include "../hom/Homolog_Model.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>

class MEM_ali {
public:
   std::vector<char> o_R0scr;           //
   std::vector<int> o_R0gap;            //
   int o_R0;                            //
   std::vector<int> o_R0R0e;            //
   MEM_ali(){
   }
   char& R0scr(int i){
      return o_R0scr.at( i);  }
   int& R0gap(int i){
      return o_R0gap.at( i);  }
   int& R0R0e(int i,int j){
      return o_R0R0e.at( i*o_R0 +j);  }
};

void Homolog_Model::ALI(const DAT_PHYSICS_CONSTS& physics_consts,
                        const DAT_ARRAY_CONSTS& array_consts,
                        const DAT_DISULFIDE_LINKS& disulfide_links,
                        const DAT_ENERGY_PARAMS& energy_params,
                        const DAT_RESIDUE_MAPPINGS& residue_mappings,
                        const DAT_REGION_MAPS& region_maps,
                        const DAT_DEFORM_PARAMS& deform_params,
                        const DAT_IGOR_DATA& igor_data,
                        Thread_Options& opt,
                        Output_Streams& out){
   int aligap1=-12;             //penalty for gap initiation
   int aligap2= -4;             //penalty for gap continuation
   MEM_ali vv;
//
//
// prepare sequence profiles for family of templates
//
   for(int iM1= 0;iM1<tem.nM1;iM1++){
      int oZ0=tem.M1[iM1].nZ0;
      int oR0=( tem.M1[iM1].Z0[oZ0-1].R0a +tem.M1[iM1].Z0[oZ0-1].cR0);
      vv.o_R0scr.resize(oR0);
      vv.o_R0gap.resize(oR0);
      for(int jR0= 0;jR0<oR0;jR0++){
         vv.R0scr(jR0)=' ';
         vv.R0gap(jR0)=1;
      }
      vv.o_R0=oR0;
      for(int iU5= 0;iU5<tem.nU5;iU5++){
//       int iZ0=tem.M1[iM1].U5[iU5].Z0;
         int iR0min=tem.M1[iM1].U5[iU5].R0a;
         int iR0max=(iR0min-1+tem.M1[iM1].U5[iU5].cR0);
         for(int iR0=iR0min;iR0<=iR0max;iR0++){
            vv.R0scr(iR0)='#';
         }
         for(int iR0=(iR0min+1);iR0<=iR0max;iR0++){
            vv.R0gap(iR0)=3;
         }
      }
      for(int iZ0= 0;iZ0<tem.M1[iM1].nZ0;iZ0++){
         int mR0=tem.M1[iM1].Z0[iZ0].R0a;
         int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            tem.M1[iM1].R0[iR0].sub=0;
            tem.M1[iM1].R0[iR0].x.zero();
            double z= (0.00);
            int mP1=tem.M1[iM1].R0[iR0].P1a;
            int nP1=(mP1-1+tem.M1[iM1].R0[iR0].cP1);
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( tem.M1[iM1].P1[iP1].sub==0 )continue;
               if( tem.M1[iM1].P1[iP1].sc==0 )continue;
               z++;
               tem.M1[iM1].R0[iR0].x+=tem.M1[iM1].P1[iP1].x;
            }
            if( z>(0.00) ){
               tem.M1[iM1].R0[iR0].sub=1;
               tem.M1[iM1].R0[iR0].x/=z;
            }
            tem.M1[iM1].R0[iR0].Z0=iZ0;
            int iL0=tem.M1[iM1].R0[iR0].L0;
            char a1=residue_mappings.L0[iL0].a1;
            tem.M1[iM1].R0[iR0].L1=0;
            for(int jL1= 1;jL1<igor_data.oL1;jL1++){
               if( igor_data.L1[jL1].a1==a1 )tem.M1[iM1].R0[iR0].L1=jL1;
            }
//          if( tem.M1[iM1].R0[iR0].L1==0 ){
//             std::cerr<<"ERROR: Unmatched residue name in template sequence."
//                      <<" iM1="<< std::setw( 4)<<iM1
//                      <<" M1mol="<<tem.M1[iM1].mol
//                      <<" iZ0="<< std::setw( 2)<<(iZ0+1)
//                      <<" iR0="<< std::setw( 4)<<(iR0+1)
//                      <<" aa="<<tem.M1[iM1].R0[iR0].aa<<".\n";
//             std::exit( 1);
//          }
            char c1=tem.M1[iM1].R0[iR0].c1;
            std::string aa=tem.M1[iM1].R0[iR0].aa;
            if( c1=='a' ){
               if( (aa[0]=='e')||
                   (aa[0]=='z') )aa=aa.substr(1,3)+' ';
               if( (aa[3]=='e')||
                   (aa[3]=='z') )aa=aa.substr(0,3)+' ';
            }
            tem.M1[iM1].R0[iR0].ss=( aa=="CYS " )? true: false;
            tem.M1[iM1].R0[iR0].scr=vv.R0scr(iR0);
            tem.M1[iM1].R0[iR0].gap=( iR0==mR0 )? 0: vv.R0gap(iR0);
         }
      }
      vv.o_R0scr.clear();
      vv.o_R0gap.clear();
   }
//
//
// prepare sequence profile for target
//
   for(int iZ0= 0;iZ0<tar.nZ0;iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         tar.R0[iR0].Z0=iZ0;
         int iL0=tar.R0[iR0].L0;
         char a1=residue_mappings.L0[iL0].a1;
         tar.R0[iR0].L1=0;
         for(int jL1= 1;jL1<igor_data.oL1;jL1++){
            if( igor_data.L1[jL1].a1==a1 )tar.R0[iR0].L1=jL1;
         }
//       if( tar.R0[iR0].L1==0 ){
//          std::cerr<<"ERROR: Unmatched residue name in target sequence."
//                   <<" M1mol="<<tar.mol
//                   <<" iZ0="<< std::setw( 2)<<(iZ0+1)
//                   <<" iR0="<< std::setw( 4)<<(iR0+1)
//                   <<" aa="<<tar.R0[iR0].aa<<".\n";
//          std::exit( 1);
//       }
         char c1=tar.R0[iR0].c1;
         std::string aa=tar.R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         tar.R0[iR0].ss=( aa=="CYS " )? true: false;
      }
   }
//
//
// align target sequence to family of template sequences
//
   if( out.VERBOSE ){
      out.FILE3<<"Alignment of Target Sequence to Family of Templates\n";
      out.FILE3<<"number of templates="
               << std::setw( 3)<<tem.nM1<<'\n';
   }
   int cZ0=tar.nZ0;
   int cR0=( tar.Z0[cZ0-1].R0a +tar.Z0[cZ0-1].cR0);
   R0.resize(cR0);
   for(int iZ0= 0;iZ0<tar.nZ0;iZ0++){
      int mR0=tar.Z0[iZ0].R0a;
      int nR0=(mR0-1+tar.Z0[iZ0].cR0);
      char cha=tar.R0[mR0].cha;

      bool PROTEINCHAIN=false;
      char c1=tar.R0[mR0].c1;
      if      ( (c1=='a')||
                (c1=='e') ){
         PROTEINCHAIN=true;
      }else if( (c1=='r')||
                (c1=='b')||
                (c1=='p') ){
         PROTEINCHAIN=false;
      }else if( (c1=='s') ){
         PROTEINCHAIN=false;
      }
      if( PROTEINCHAIN ){
         for(int iM1= 0;iM1<tem.nM1;iM1++){
            int oZ0=tem.M1[iM1].nZ0;
            int oR0=( tem.M1[iM1].Z0[oZ0-1].R0a +tem.M1[iM1].Z0[oZ0-1].cR0);

            vv.o_R0R0e.resize((nR0-mR0+1)*oR0);
            vv.o_R0=oR0;
            for(int iR0=mR0;iR0<=nR0;iR0++){
               int iL1=tar.R0[iR0].L1;
               bool ii=tar.R0[iR0].ss;
               for(int jR0= 0;jR0<oR0;jR0++){
                  int jL1=tem.M1[iM1].R0[jR0].L1;
                  bool jj=tem.M1[iM1].R0[jR0].ss;
                  vv.R0R0e(iR0-mR0,jR0)=igor_data.L1L1sco(iL1,jL1);
                  if      ( ( ii)&&( jj) ){
                     vv.R0R0e(iR0-mR0,jR0)+=80;
                  }else if( (!ii)&&(!jj) ){
                  }else{
                     vv.R0R0e(iR0-mR0,jR0)-= 4;
                  }
               }
            }

            for(int iR0=(nR0-1);iR0>=mR0;iR0--){
               int pR0min=(iR0+2);
               int pR0max=nR0;
               for(int jR0=(oR0-2);jR0>= 0;jR0--){
                  int qR0min=(jR0+2);
                  int qR0max=(oR0-1);
                  int M=vv.R0R0e((iR0+1)-mR0,(jR0+1));
                  for(int pR0=pR0min;pR0<=pR0max;pR0++){
                     int L=( vv.R0R0e(pR0-mR0,(jR0+1))
                            +tem.M1[iM1].R0[jR0+1].gap
                            *( aligap1 +(pR0-pR0min)*aligap2));
                     if( L>M )M=L;
                  }
                  for(int qR0=qR0min;qR0<=qR0max;qR0++){
                     int L=( vv.R0R0e((iR0+1)-mR0,qR0)
                            +tem.M1[iM1].R0[qR0].gap
                            *( aligap1 +(qR0-qR0min)*aligap2));
                     if( L>M )M=L;
                  }
                  vv.R0R0e(iR0-mR0,jR0)+=M;
               }
            }

            tem.M1[iM1].P8.clear();
            int nP8=0;
            int iR0=mR0;
            int jR0=0;
            int nTER=oR0;
            for(int iTER= 0;iTER<nTER;iTER++){
               int M=vv.R0R0e(iR0-mR0,jR0);
               int aR0=iR0;
               int bR0=jR0;
               int pR0min=(iR0+1);
               int pR0max=nR0;
               for(int pR0=pR0min;pR0<=pR0max;pR0++){
                  int L=( vv.R0R0e(pR0-mR0,jR0)
                         +tem.M1[iM1].R0[jR0].gap
                         *( aligap1 +(pR0-pR0min)*aligap2));
                  if( L>M ){
                     M=L;
                     aR0=pR0;
                     bR0=jR0;
                  }
               }
               int qR0min=(jR0+1);
               int qR0max=(oR0-1);
               for(int qR0=qR0min;qR0<=qR0max;qR0++){
                  int L=( vv.R0R0e(iR0-mR0,qR0)
                         +tem.M1[iM1].R0[qR0].gap
                         *( aligap1 +(qR0-qR0min)*aligap2));
                  if( L>M ){
                     M=L;
                     aR0=iR0;
                     bR0=qR0;
                  }
               }
               if( aR0>iR0 ){
                  for(int pR0=iR0;pR0<aR0;pR0++){
                     tem.M1[iM1].P8.push_back( Family::tM1::tM1P8());
                     tem.M1[iM1].P8[nP8  ].aR0=pR0;
                     tem.M1[iM1].P8[nP8++].bR0=-1;
                  }
               }
               if( bR0>jR0 ){
                  for(int qR0=jR0;qR0<bR0;qR0++){
                     tem.M1[iM1].P8.push_back( Family::tM1::tM1P8());
                     tem.M1[iM1].P8[nP8  ].aR0=-1;
                     tem.M1[iM1].P8[nP8++].bR0=qR0;
                  }
               }
               tem.M1[iM1].P8.push_back( Family::tM1::tM1P8());
               tem.M1[iM1].P8[nP8  ].aR0=aR0;
               tem.M1[iM1].P8[nP8++].bR0=bR0;
               if( aR0==nR0 ){
                  for(int qR0=(bR0+1);qR0<oR0;qR0++){
                     tem.M1[iM1].P8.push_back( Family::tM1::tM1P8());
                     tem.M1[iM1].P8[nP8  ].aR0=-1;
                     tem.M1[iM1].P8[nP8++].bR0=qR0;
                  }
                  break;
               }
               if( bR0==(oR0-1) ){
                  for(int pR0=(aR0+1);pR0<=nR0;pR0++){
                     tem.M1[iM1].P8.push_back( Family::tM1::tM1P8());
                     tem.M1[iM1].P8[nP8  ].aR0=pR0;
                     tem.M1[iM1].P8[nP8++].bR0=-1;
                  }
                  break;
               }
               iR0=(aR0+1);
               jR0=(bR0+1);
            }
            tem.M1[iM1].nP8=nP8;

            int nIDENT=0;
            for(int iP8= 0;iP8<nP8;iP8++){
               int aR0=tem.M1[iM1].P8[iP8].aR0;
               int bR0=tem.M1[iM1].P8[iP8].bR0;
               if( aR0==-1 ){
                  tem.M1[iM1].P8[iP8].alp='-';
               }else{
                  int aL1=tar.R0[aR0].L1;
                  tem.M1[iM1].P8[iP8].alp=igor_data.L1[aL1].a1;
               }
               if( bR0==-1 ){
                  tem.M1[iM1].P8[iP8].bet='-';
                  tem.M1[iM1].P8[iP8].scr=' ';
               }else{
                  int bL1=tem.M1[iM1].R0[bR0].L1;
                  tem.M1[iM1].P8[iP8].bet=igor_data.L1[bL1].a1;
                  tem.M1[iM1].P8[iP8].scr=tem.M1[iM1].R0[bR0].scr;
                  if( tem.M1[iM1].P8[iP8].bet==
                      tem.M1[iM1].P8[iP8].alp )nIDENT++;
               }
            }
            int nALIGN=( (nR0-mR0+1)<oR0 )? (nR0-mR0+1): oR0;
            tem.M1[iM1].pid= (1.00e+2)*double( nIDENT)/double( nALIGN);
            vv.o_R0R0e.clear();
         }

         for(int iM1= 0;iM1<tem.nM1;iM1++){
            tem.M1ord(iM1)=iM1;
         }
         if( tem.nM1> 1 ){
            for(int iM1max=(tem.nM1-1);iM1max>0;iM1max--){
               bool ORDERED=true;
               double z1= tem.M1[tem.M1ord( 0)].pid;
               for(int iM1= 1;iM1<=iM1max;iM1++){
                  double z2= tem.M1[tem.M1ord(iM1)].pid;
                  if( z1<z2 ){
                     int L=tem.M1ord(iM1);
                     tem.M1ord(iM1)=tem.M1ord(iM1-1);
                     tem.M1ord(iM1-1)=L;
                     ORDERED=false;
                  }else{
                     z1= z2;
                  }
               }
               if( ORDERED )break;
            }
         }
         if( out.VERBOSE ){
            std::string hrule="________________________________________"
                              "________________________________________"
                              "________\n";
            out.FILE3<< std::fixed<< std::setprecision( 2);
            for(int jM1= 0;jM1<tem.nM1;jM1++){
               int iM1=tem.M1ord(jM1);
//             out.FILE3<<hrule;
               out.FILE3<<"target sequence="
                        <<tar.mol<<' '<<cha<<'\n';
               out.FILE3<<"%identical="
                        << std::setw( 6)<<tem.M1[iM1].pid<<"  "
                        <<"template sequence="
                        <<tem.M1[iM1].mol<<'\n';
               int n=(1+((tem.M1[iM1].nP8-1)/80));
               for(int i=0;i<n;i++){
                  int iP8min=(80*i);
                  int iP8max=(-1+80*(i+1));
                  if( iP8max>(tem.M1[iM1].nP8-1) )iP8max=(tem.M1[iM1].nP8-1);
                  for(int iP8=iP8min;iP8<=iP8max;iP8++){
                     if( (iP8% 10)==0 )out.FILE3<<' ';
                     out.FILE3<<tem.M1[iM1].P8[iP8].alp;
                  }
                  out.FILE3<<'\n';
                  for(int iP8=iP8min;iP8<=iP8max;iP8++){
                     if( (iP8% 10)==0 )out.FILE3<<' ';
                     out.FILE3<<tem.M1[iM1].P8[iP8].bet;
                  }
                  out.FILE3<<'\n';
                  for(int iP8=iP8min;iP8<=iP8max;iP8++){
                     if( (iP8% 10)==0 )out.FILE3<<' ';
                     out.FILE3<<tem.M1[iM1].P8[iP8].scr;
                  }
                  out.FILE3<<'\n';
               }
            }
//          out.FILE3<<hrule;
         }

         ALI_TEM(out,iZ0);
      }else{
         if( (tem.nM1!=1)||
             (tem.M1[ 0].nZ0!=tar.nZ0) ){
            std::cerr<<"ERROR: Alignment of nucleotide chains of target "
                       "requires a single template "
                       "with matched set of chains.\n";
            std::exit( 1);
         }
         int aR0=tem.M1[ 0].Z0[iZ0].R0a;
         int bR0=(aR0-1+tem.M1[ 0].Z0[iZ0].cR0);
         if( (bR0-aR0+1)!=(nR0-mR0+1) ){
            std::cerr<<"ERROR: Alignment of nucleotide chain of target "
                       "requires a matched set of template residues.\n";
            std::exit( 1);
         }
         for(int iR0=mR0;iR0<=nR0;iR0++){
            R0[iR0].temM1=0;
            R0[iR0].temZ0=iZ0;
            R0[iR0].temR0=(iR0-mR0+aR0);
            R0[iR0].U5=-1;
            R0[iR0].pid= (0.00);
         }

      }
   }
//
//
// generate coordinates of target structure
//
   ALI_SUB(out);
   bool NOGAPDEF=
   ALI_DEF(physics_consts,array_consts,disulfide_links,energy_params,
           residue_mappings,region_maps,deform_params,
           opt,out);
   if( NOGAPDEF ){
      std::exit( 2);
   }

   return;
}
