#ifndef DEF_SUB_AUTOMATIC
#define DEF_SUB_AUTOMATIC

#include "../phi/Coordinates.hh"
#include <string>
#include <vector>

class Sub_Automatic {
public:
   class tR6 { /*residues with variable side chains in homology model building*/
   public:
      int Z0;                   //index of chain
      int R0;                   //index of residue
      int Q6a;                  //start index of Q6 [iupac order]
      int cQ6;                  //number of sc torsions variable in rotamers
      int V6a;                  //start index of V6
      int cV6;                  //number of V6
      tR6(){}
   };
   class tV6 { /*side chain rotamers consistent with substitution*/
   public:
      int C2;                   //index of side chain rotamer
      int P6a;                  //start index of P6
      int cP6;                  //number of P6
      tV6(){}
   };
   class tP6 { /*incomplete side chain heavy atoms variable in homology model
                 building*/
   public:
      int typ;                  //atom type
      std::string atm;          //4 char atom name
      Coordinates x;            //position
      tP6(){}
   };
   class tW6 { /*packing units for side chain placement in homology model
                 building*/
   public:
      int nJ6;                  //number
      tW6(){}
   };

private:
   std::vector<double> o_T2T2r;         //distance threshold for contact
   std::vector<double> o_T2T2e;         //energy associated with contact
   std::vector<double> o_T2r;           //hard sphere radius (angstrom)

   double& T2r(int i){
      return o_T2r[ i];
   }

public:
   int nR6;                             //number
   std::vector<tR6> R6;                 //sites
   std::vector<tV6> V6;                 //compatible rotamers
   std::vector<tP6> P6;                 //atoms of compatible rotamers
   int nW6;                             //number
   std::vector<tW6> W6;                 //packing units
   std::vector<int> o_W6J6R6;           //residues of a packing unit

   double& T2T2r(int i,int j){
      return o_T2T2r[ i*16 +j];
   }
   double& T2T2e(int i,int j){
      return o_T2T2e[ i*16 +j];
   }
   const double& T2T2r(int i,int j) const {
      return o_T2T2r[ i*16 +j];
   }
   const double& T2T2e(int i,int j) const {
      return o_T2T2e[ i*16 +j];
   }
   int& W6J6R6(int i,int j){
      return o_W6J6R6[ i*12 +j];
   }

   Sub_Automatic():
      o_T2T2r(324),
      o_T2T2e(324),
      o_T2r(18)
   {
      T2r( 8)= (1.90);
      T2r( 9)= (1.90);
      T2r(10)= (1.90);
      T2r(11)= (1.75);
      T2r(12)= (1.75);
      T2r(13)= (1.60);
      T2r(14)= (1.60);
      T2r(15)= (2.10);
      T2r(16)= (2.10);
      T2r(17)= (1.60);
      for(int iT2= 8;iT2<18;iT2++){
         for(int jT2= 8;jT2<18;jT2++){
            T2T2e(iT2,jT2)= (0.00);
            T2T2r(iT2,jT2)=( T2r(iT2) +T2r(jT2) +(.80));
         }
      }
      T2T2e( 8, 8)=-(0.25);
      T2T2e( 8, 9)=-(0.25);
      T2T2e( 8,10)=-(0.25);
      T2T2e( 9, 8)=-(0.25);
      T2T2e( 9, 9)=-(0.25);
      T2T2e( 9,10)=-(0.25);
      T2T2e(10, 8)=-(0.25);
      T2T2e(10, 9)=-(0.25);
      T2T2e(10,10)=-(0.25);
      T2T2e(11,11)= (8.00);
      T2T2e(12,12)= (8.00);
      T2T2e(12,13)= (8.00);
      T2T2e(12,17)= (8.00);
      T2T2e(13,12)= (8.00);
      T2T2e(13,13)= (8.00);
      T2T2e(13,17)= (8.00);
      T2T2e(17,12)= (8.00);
      T2T2e(17,13)= (8.00);
      T2T2e(17,17)= (8.00);
   }
};

#endif
