#ifndef DEF_HOMOLOG_MODEL
#define DEF_HOMOLOG_MODEL

#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Family.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../hom/Sub_Automatic.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>

class Homolog_Model {
public:
   class tI4 { /*insertions or deletions*/
   public:
      int Z0gap;                //aligned position in target with preceding
      int R0gap;                // insertion or deletion
      int dM1;                  //length of discontinuity in alignment of
      int dZ0;                  // target to template
      int dR0;                  //
      tI4(){}
   };
   class tR0 { /*residues of target*/
   public:
      int temM1;                //mapping to template of tem
      int temZ0;                //mapping to chain
      int temR0;                //mapping to residue
      int U5;                   //mapping to structurally conserved region
      double pid;               //percent identity of alignment
      tR0():
         temM1(-1),
         temZ0(-1),
         temR0(-1),
         U5(-1),
         pid( (0.00))
      {}
   };

public:
   std::string TEMGRP;          //name of template group
   Family tem;                  //set of templates
   Structure tar;               //target structure
   std::vector<tR0> R0;         //residues of target
   int jM1init;                 //template of initial match
   int jZ0init;                 //chain of initial match
   int nI4;                     //number
   std::vector<tI4> I4;         //set of insertions or deletions
   Search_Subspace sub;         //patch search subspace
   Backbone_Defs def;           //patch backbone conformations

   void SCR(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            Output_Streams& out);
   void ALI(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_ARRAY_CONSTS& array_consts,
            const DAT_DISULFIDE_LINKS& disulfide_links,
            const DAT_ENERGY_PARAMS& energy_params,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            const DAT_REGION_MAPS& region_maps,
            const DAT_DEFORM_PARAMS& deform_params,
            const DAT_IGOR_DATA& igor_data,
            Thread_Options& opt,
            Output_Streams& out);
   void ALI_TEM(Output_Streams& out,
                int iZ0);
   void ALI_SUB(Output_Streams& out);
   bool ALI_DEF(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                const DAT_DISULFIDE_LINKS& disulfide_links,
                const DAT_ENERGY_PARAMS& energy_params,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                const DAT_REGION_MAPS& region_maps,
                const DAT_DEFORM_PARAMS& deform_params,
                Thread_Options& opt,
                Output_Streams& out);
   void SUB(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_ENERGY_PARAMS& energy_params,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            const DAT_DEFORM_PARAMS& deform_params,
            Output_Streams& out,
            int pR0min,int pR0max);
   void SUB_BSE(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                int pR0min,int pR0max);
   void SUB_BBPCK(Sub_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_ENERGY_PARAMS& energy_params,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  const DAT_DEFORM_PARAMS& deform_params,
                  Output_Streams& out,
                  int iZ2,int pR0min,int pR0max);
   void SUB_USC(Sub_Automatic& aut,
                const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                Output_Streams& out,
                int pR0min,int pR0max);
   void SUB_GEN(Sub_Automatic& aut,
                const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_RESIDUE_MAPPINGS& residue_mappings,
                Output_Streams& out);
   void SUB_GRP(Sub_Automatic& aut,
                Output_Streams& out,
                int pR0min,int pR0max);
   void SUB_SCPCK(Sub_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_ENERGY_PARAMS& energy_params,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  Output_Streams& out,
                  int pR0min,int pR0max);

   Homolog_Model(const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_ARRAY_CONSTS& array_consts,
                 const DAT_ENERGY_PARAMS& energy_params,
                 const DAT_RESIDUE_MAPPINGS& residue_mappings,
                 const DAT_REGION_MAPS& region_maps,
                 const DAT_IGOR_DATA& igor_data,
                 Thread_Options& opt,
                 Output_Streams& out,
                 std::string FAMILY,
                 std::string TEMPLATE);
   Homolog_Model(){}
};

#endif
