#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Family.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../hom/Homolog_Model.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iomanip>

Homolog_Model::Homolog_Model(
                         const DAT_PHYSICS_CONSTS& physics_consts,
                         const DAT_ARRAY_CONSTS& array_consts,
                         const DAT_ENERGY_PARAMS& energy_params,
                         const DAT_RESIDUE_MAPPINGS& residue_mappings,
                         const DAT_REGION_MAPS& region_maps,
                         const DAT_IGOR_DATA& igor_data,
                         Thread_Options& opt,
                         Output_Streams& out,
                         std::string FAMILY,
                         std::string TEMPLATE):
      TEMGRP(TEMPLATE)
{
   std::string filename="../../"+FAMILY+"/arg/exptstructs."+TEMGRP;
   std::ifstream gfile(filename.c_str());
   if( !gfile ){
      std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
      std::exit( 1);
   }
//
//
// input structures of template group
//
   std::string mol;
   int iM1= 0;
   while( !std::getline(gfile,mol).eof() ){
      Structure str;
      str.fam=FAMILY;
      str.mol=mol;
      str.cnf="00";

      filename="../../"+str.fam+"/car/"+str.mol+"."+str.cnf+".pdb";
      std::ifstream ifile(filename.c_str());
      if( !ifile ){
         Trajectory tra;
         str.REFORM(physics_consts,residue_mappings);
         str.SEQ2FIL();
         str.TOR(physics_consts,residue_mappings);
         tra.STR2TRA( 0,str);
         str.REG(physics_consts,residue_mappings,out);
         str.POLARH(physics_consts,residue_mappings);
         str.TOR(physics_consts,residue_mappings);
         str.TOR2FIL(physics_consts);
         str.CAR(physics_consts,residue_mappings);
         str.SUP(physics_consts,out,tra);
         str.CAR2FIL();
      }else{
         ifile.close();
         str.FIL2SEQ(residue_mappings);
         str.FIL2TOR(physics_consts);
         str.FIL2CAR();
      }
      tem.STR2FAM(iM1,str);

      for(int iZ0=0;iZ0<tem.M1[iM1].nZ0;iZ0++){
         int mR0=tem.M1[iM1].Z0[iZ0].R0a;
         int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            char c1=tem.M1[iM1].R0[iR0].c1;
            tem.M1[iM1].R0[iR0].sub=0;
            int mP1=tem.M1[iM1].R0[iR0].P1a;
            int nP1=(mP1-1+tem.M1[iM1].R0[iR0].cP1);
            for(int iP1=mP1;iP1<=nP1;iP1++){
               if( tem.M1[iM1].P1[iP1].sub==0 )continue;
               std::string atm=tem.M1[iM1].P1[iP1].atm;
               if      ( c1=='a' ){
                  if( atm==" CA " ){
                     tem.M1[iM1].R0[iR0].x=tem.M1[iM1].P1[iP1].x;
                     tem.M1[iM1].R0[iR0].sub=1;
                  }
               }else if( c1=='e' ){
               }else if( c1=='r' ){
                  if( atm==" C4'" ){
                     tem.M1[iM1].R0[iR0].x=tem.M1[iM1].P1[iP1].x;
                     tem.M1[iM1].R0[iR0].sub=1;
                  }
               }else if( c1=='b' ){
                  if( atm==" C2 " ){
                     tem.M1[iM1].R0[iR0].x=tem.M1[iM1].P1[iP1].x;
                     tem.M1[iM1].R0[iR0].sub=1;
                  }
               }else if( c1=='p' ){
                  if( atm==" P  " ){
                     tem.M1[iM1].R0[iR0].x=tem.M1[iM1].P1[iP1].x;
                     tem.M1[iM1].R0[iR0].sub=1;
                  }
               }else if( c1=='s' ){
               }
            }
         }
      }

      tem.M1[iM1].X8.push_back( Family::tM1::tM1X8());
      int nX8=1;
      for(int iZ0=0;iZ0<tem.M1[iM1].nZ0;iZ0++){
         int mR0=tem.M1[iM1].Z0[iZ0].R0a;
         int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<nR0;iR0++){
            int jR0=(iR0+1);
            if( (tem.M1[iM1].R0[iR0].sub==1)&&
                (tem.M1[iM1].R0[jR0].sub==1) ){
               tem.M1[iM1].X8.push_back( Family::tM1::tM1X8());
               tem.M1[iM1].X8[nX8].x=tem.M1[iM1].R0[iR0].x;
               tem.M1[iM1].X8[nX8].c=( tem.M1[iM1].R0[jR0].x
                                      -tem.M1[iM1].R0[iR0].x).normalize();
               tem.M1[iM1].X8[nX8].Z0=iZ0;
               tem.M1[iM1].X8[nX8].R0=iR0;
               nX8++;
            }
         }
      }
      tem.M1[iM1].nX8=nX8;

      tem.M1[iM1].X8[ 0].t.zero();
      for(int iX8= 1;iX8<nX8;iX8++){
         int jX8=(iX8-1);
         tem.M1[iM1].X8[iX8].t=( tem.M1[iM1].X8[jX8].t +tem.M1[iM1].X8[iX8].x);
      }

      filename="../../"+str.fam+"/car/dprof."+str.mol+"."+str.cnf;
      std::ifstream jfile(filename.c_str());
      if( !jfile ){
         str.DEFECT(physics_consts,array_consts,energy_params,residue_mappings,
                    region_maps,igor_data,
                    opt,out);
         jfile.open(filename.c_str());
      }
      std::string rec;
      for(int i=0;i<8;i++){
         std::getline(jfile,rec);
      }
      for(int iZ0=0;iZ0<tem.M1[iM1].nZ0;iZ0++){
         std::getline(jfile,rec);
         int mR0=tem.M1[iM1].Z0[iZ0].R0a;
         int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            std::getline(jfile,rec);
            std::string aa=rec.substr( 0, 4);
            if( aa!=tem.M1[iM1].R0[iR0].aa ){
               std::cerr<<"ERROR:"
                        <<" Residue name mismatch in dprof.MOL.CNF file."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                        <<" aa="<<aa<<".\n";
               std::exit( 1);
            }
            double e;
            int loop;
            std::istringstream(rec.substr(14, 6))>>e;
            std::istringstream(rec.substr(23, 1))>>loop;
            tem.M1[iM1].R0[iR0].e=( loop==0 )? (0.00): e;
         }
      }
      jfile.close();
      iM1++;
   }
   gfile.close();
//
//
// dump template group
//
// filename="../../"+FAMILY+"/dgn/dmp0";
// std::ofstream ofile(filename.c_str());
// ofile<< std::fixed<< std::setprecision( 1);
// ofile<<"M1mol\n";
// for(int iM1= 0;iM1<tem.nM1;iM1++){
//    ofile<< std::setw( 3)<<iM1<<' '
//         <<tem.M1[iM1].mol<<'\n';
// }
// ofile<<"M1nZ0\n";
// for(int iM1= 0;iM1<tem.nM1;iM1++){
//    ofile<< std::setw( 3)<<iM1<<' '
//         << std::setw( 2)<<tem.M1[iM1].nZ0<<'\n';
// }
// ofile<<"M1Z0R0a,M1Z0cR0\n";
// for(int iM1= 0;iM1<tem.nM1;iM1++){
//    for(int iZ0=0;iZ0<tem.M1[iM1].nZ0;iZ0++){
//       ofile<< std::setw( 3)<<iM1<<' '
//            << std::setw( 2)<<iZ0<<' '
//            << std::setw( 4)<<tem.M1[iM1].Z0[iZ0].R0a
//            << std::setw( 4)<<tem.M1[iM1].Z0[iZ0].cR0<<'\n';
//    }
// }
// ofile<<"M1R0aa,M1R0L0,M1R0cha,M1R0res,M1R0ins,M1R0sub,M1R0x\n";
// for(int iM1= 0;iM1<tem.nM1;iM1++){
//    for(int iZ0=0;iZ0<tem.M1[iM1].nZ0;iZ0++){
//       int mR0=tem.M1[iM1].Z0[iZ0].R0a;
//       int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
//       for(int iR0=mR0;iR0<=nR0;iR0++){
//          ofile<< std::setw( 3)<<iM1<<' '
//               << std::setw( 2)<<iZ0<<' '
//               << std::setw( 4)<<iR0<<' '
//               <<tem.M1[iM1].R0[iR0].aa<<' '
//               << std::setw( 3)<<tem.M1[iM1].R0[iR0].L0<<' '
//               <<tem.M1[iM1].R0[iR0].cha
//               << std::setw( 4)<<tem.M1[iM1].R0[iR0].res
//               <<tem.M1[iM1].R0[iR0].ins<<' '
//               << std::setw( 1)<<tem.M1[iM1].R0[iR0].sub<<' ';
//          for(int i=0;i<3;i++){
//             ofile<< std::setw( 6)<<tem.M1[iM1].R0[iR0].x(i);
//          }
//          ofile<<'\n';
//       }
//    }
// }
// ofile<<"M1P1x\n";
// for(int iM1= 0;iM1<tem.nM1;iM1++){
//    for(int iZ0=0;iZ0<tem.M1[iM1].nZ0;iZ0++){
//       int mR0=tem.M1[iM1].Z0[iZ0].R0a;
//       int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
//       for(int iR0=mR0;iR0<=nR0;iR0++){
//          int mP1=tem.M1[iM1].R0[iR0].P1a;
//          int nP1=(mP1-1+tem.M1[iM1].R0[iR0].cP1);
//          for(int iP1=mP1;iP1<=nP1;iP1++){
//             if( tem.M1[iM1].P1[iP1].sub==0 )continue;
//             std::string atm=tem.M1[iM1].P1[iP1].atm;
//             ofile<< std::setw( 3)<<iM1<<' '
//                  << std::setw( 2)<<iZ0<<' '
//                  << std::setw( 4)<<iR0<<' '
//                  << std::setw( 5)<<iP1<<' '
//                  <<atm<<' ';
//             for(int i=0;i<3;i++){
//                ofile<< std::setw( 6)<<tem.M1[iM1].P1[iP1].x(i);
//             }
//             ofile<<'\n';
//          }
//       }
//    }
// }
// ofile<<"M1nX8\n";
// for(int iM1= 0;iM1<tem.nM1;iM1++){
//    ofile<< std::setw( 3)<<iM1<<' '
//         << std::setw( 4)<<tem.M1[iM1].nX8<<'\n';
// }
// ofile<<"M1X8Z0,M1X8R0,M1X8x,M1X8c,M1X8t\n";
// for(int iM1= 0;iM1<tem.nM1;iM1++){
//    int nX8=tem.M1[iM1].nX8;
//    for(int iX8= 1;iX8<nX8;iX8++){
//       int iZ0=tem.M1[iM1].X8[iX8].Z0;
//       int iR0=tem.M1[iM1].X8[iX8].R0;
//       ofile<< std::setw( 3)<<iM1<<' '
//            << std::setw( 4)<<iX8<<' '
//            << std::setw( 2)<<iZ0<<' '
//            << std::setw( 4)<<iR0<<' ';
//       for(int i=0;i<3;i++){
//          ofile<< std::setw( 6)<<tem.M1[iM1].X8[iX8].x(i);
//       }
//       ofile<<' '<< std::setprecision( 3);
//       for(int i=0;i<3;i++){
//          ofile<< std::setw( 6)<<tem.M1[iM1].X8[iX8].c(i);
//       }
//       ofile<<' '<< std::setprecision( 1);
//       for(int i=0;i<3;i++){
//          ofile<< std::setw( 8)<<tem.M1[iM1].X8[iX8].t(i);
//       }
//       ofile<<'\n';
//    }
// }
// ofile.close();

   for(int iM1= 0;iM1<tem.nM1;iM1++){
      for(int iZ0=0;iZ0<tem.M1[iM1].nZ0;iZ0++){
         int mR0=tem.M1[iM1].Z0[iZ0].R0a;
         int nR0=(mR0-1+tem.M1[iM1].Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            tem.M1[iM1].R0[iR0].sub=-1;
         }
      }
   }

}
