#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <cmath>

void Glo::GLO_WRT(Glo_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  const DAT_REGION_MAPS& region_maps,
                  const Thread_Options& opt,
                  const Search_Subspace& sub,
                  const Mechanical_System& mol,
                  const Subset_Contracted_System::tM3& con,
                  Conf_Dependent_System& dep,
                  Energy_Surface4& ene,
                  Backbone_Defs& def){

   if      ( opt.MODE=="bb " ){
      int iU2=0;
      for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
         if( con.Z0[iZ0].sub ){
            for(int i=0;i<3;i++){
               aut.D2[aut.iD2].U2chi(iU2  +i)= ene.U2chi(iU2  +i)
                                              *physics_consts.ANG;
               aut.D2[aut.iD2].U2chi(iU2+3+i)= ene.U2chi(iU2+3+i)
                                              /physics_consts.RAD;
            }
            iU2+=6;
         }
      }
      for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            aut.D2[aut.iD2].U2chi(iU2)= ene.U2chi(iU2)
                                       /physics_consts.RAD;
            iU2++;
         }
      }
      for(int iR1= 0;iR1<sub.nR1;iR1++){
         if( (sub.R1[iR1].bb==0)&&(sub.R1[iR1].sc==0) )continue;
         int iL0=sub.R1[iR1].L0;
         char c1=residue_mappings.L0[iL0].c1;
         int jQ1bb=sub.R1[iR1].Q1bb;
         int jQ1sc=sub.R1[iR1].Q1sc;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
            bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
            int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
            if( !con.Q1[jQ1].sub )continue;
            std::string tor=mol.Q1[jQ1].tor;
            double the= dep.Q1[jQ1].chi/physics_consts.RAD;
            if      ( c1=='a'||
                      c1=='e' ){
               if( BRANCH )continue;
               if      ( tor=="OMG" ){
                  aut.D2[aut.iD2].R1[iR1-1].omg= the;
               }else if( tor=="PHI" ){
                  aut.D2[aut.iD2].R1[iR1  ].phi= the;
               }else if( tor=="PSI" ){
                  aut.D2[aut.iD2].R1[iR1  ].psi= the;
               }
            }else if( c1=='r' ){
               if      ( tor=="BET" ){
                  aut.D2[aut.iD2].R1[iR1  ].bet= the;
               }else if( tor=="GAM" ){
                  aut.D2[aut.iD2].R1[iR1  ].gam= the;
               }else if( tor=="DEL" ){
                  aut.D2[aut.iD2].R1[iR1  ].del= the;
               }
            }else if( c1=='b' ){
            }else if( c1=='p' ){
               if      ( tor=="EPS" ){
                  aut.D2[aut.iD2].R1[iR1  ].eps= the;
               }else if( tor=="ZET" ){
                  aut.D2[aut.iD2].R1[iR1  ].zet= the;
               }else if( tor=="ALP" ){
                  aut.D2[aut.iD2].R1[iR1  ].alp= the;
               }
            }else if( c1=='s' ){
            }
         }
         std::string aa=sub.R1[iR1].aa;
         if( aa=="HPR " ){
            aut.D2[aut.iD2].R1[iR1  ].phi= (-74.39);
         }
      }
      aut.D2[aut.iD2].star=0;
      aut.D2[aut.iD2].bord=0;
      for(int iR1= 0;iR1<sub.nR1;iR1++){
         aut.D2[aut.iD2].R1[iR1].cnfa="  ";
         aut.D2[aut.iD2].R1[iR1].cnfb="  ";
         std::string aa=sub.R1[iR1].aa;
         int iL0=sub.R1[iR1].L0;
         char c1=residue_mappings.L0[iL0].c1;
         if      ( c1=='a' ){
            if( (aa[0]=='e')||(aa[0]=='z')||
                (aa[3]=='e')||(aa[3]=='z') )continue;
            if( sub.R1[iR1].bb==0 )continue;
            double phi= aut.D2[aut.iD2].R1[iR1].phi;
            double psi= aut.D2[aut.iD2].R1[iR1].psi;
            if( phi>(0.00) ){
               phi=-phi;
               psi=-psi;
               aut.D2[aut.iD2].R1[iR1].cnfa[1]='*';
               aut.D2[aut.iD2].R1[iR1].cnfb[1]='*';
               if( aa!="GLY " )aut.D2[aut.iD2].star++;
            }
            int iH4=1 +int( phi +(180.00))/10;
            int jH4=1 +int( psi +(180.00))/10;
            int iI0=( aa=="GLY " )? region_maps.H4H4gly(iH4,jH4):
                                    region_maps.H4H4ala(iH4,jH4);
            aut.D2[aut.iD2].R1[iR1].cnfa[0]=region_maps.I0alp(iI0);
            aut.D2[aut.iD2].R1[iR1].cnfb[0]=region_maps.I0bet(iI0);
            if( aut.D2[aut.iD2].R1[iR1].cnfa[0]=='X' )aut.D2[aut.iD2].bord++;
         }else if( c1=='e' ){
            if( (aa=="ACE ")||(aa=="NME ")||(aa=="NH2 ") )continue;
         }else if( c1=='r' ){
            double eps= aut.D2[aut.iD2].R1[iR1-1].eps;
            double zet= aut.D2[aut.iD2].R1[iR1-1].zet;
            double alp= aut.D2[aut.iD2].R1[iR1-1].alp;
            double bet= aut.D2[aut.iD2].R1[iR1  ].bet;
            double gam= aut.D2[aut.iD2].R1[iR1  ].gam;
            double del= aut.D2[aut.iD2].R1[iR1  ].del;
            double de0=( 146.00);
            if( iR1> 2 ){
               int iR0=sub.R1[iR1  ].R0;
               int jR0=sub.R1[iR1-3].R0;
               if( jR0==(iR0-3) ){
                  de0= aut.D2[aut.iD2].R1[iR1-3].del;
               }
            }
            double rmin= (1.00e+8);
            int jC6=-1;
            for(int iC6= 0;iC6<46;iC6++){
               double d0=( de0 -region_maps.C6[iC6].de0);
               if      ( d0>=( 180.) ){ d0-=(360.);
               }else if( d0< (-180.) ){ d0+=(360.);
               }
               double d1=( eps -region_maps.C6[iC6].eps);
               if      ( d1>=( 180.) ){ d1-=(360.);
               }else if( d1< (-180.) ){ d1+=(360.);
               }
               double d2=( zet -region_maps.C6[iC6].zet);
               if      ( d2>=( 180.) ){ d2-=(360.);
               }else if( d2< (-180.) ){ d2+=(360.);
               }
               double d3=( alp -region_maps.C6[iC6].alp);
               if      ( d3>=( 180.) ){ d3-=(360.);
               }else if( d3< (-180.) ){ d3+=(360.);
               }
               double d4=( bet -region_maps.C6[iC6].bet);
               if      ( d4>=( 180.) ){ d4-=(360.);
               }else if( d4< (-180.) ){ d4+=(360.);
               }
               double d5=( gam -region_maps.C6[iC6].gam);
               if      ( d5>=( 180.) ){ d5-=(360.);
               }else if( d5< (-180.) ){ d5+=(360.);
               }
               double d6=( del -region_maps.C6[iC6].del);
               if      ( d6>=( 180.) ){ d6-=(360.);
               }else if( d6< (-180.) ){ d6+=(360.);
               }
               double rr=( d0*d0 +d1*d1 +d2*d2 +d3*d3 +d4*d4
                          +d5*d5 +d6*d6);
               double r= std::sqrt( rr/(7.00));
               if( r<rmin ){
                  rmin= r;
                  jC6=iC6;
               }
            }
            aut.D2[aut.iD2].R1[iR1].cnfa=region_maps.C6[jC6].cnf;
            if( rmin>(10.00) )aut.D2[aut.iD2].bord++;
         }else if( c1=='b' ){
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
      ene.Fs2= (0.00);
      for(int iZ2= 0;iZ2<def.nZ2;iZ2++){
         int iR1=def.Z2[iZ2].CYC;
         int iL0=sub.R1[iR1].L0;
         char c1=residue_mappings.L0[iL0].c1;
         int iD1=aut.D2[aut.iD2].Z2iD1(iZ2);
         if      ( c1=='a'||
                   c1=='e' ){
            ene.Fs2+=def.Z2[iZ2].D1[iD1].p;
         }else if( c1=='r' ){
         }else if( c1=='b' ){
         }else if( c1=='p' ){
            double p= def.Z2[iZ2].D1[iD1].p;
            ene.Fs2-=physics_consts.ekT*std::log( p);
         }else if( c1=='s' ){
         }
      }

   }else if( opt.MODE=="sc " ){
      for(int iU2= 0;iU2<ene.nU2;iU2++){
         aut.D3[aut.iD3].U2chi(iU2)= ene.U2chi(iU2)/physics_consts.RAD;
      }

   }else if( opt.MODE=="lp " ){
      for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
         def.D0[def.iD0].Z0[iZ0].trans=dep.Z0[iZ0].trans;
         def.D0[def.iD0].Z0[iZ0].rot=dep.Z0[iZ0].rot;
      }
      for(int iR1= 0;iR1<sub.nR1;iR1++){
         if( (sub.R1[iR1].bb==0)&&(sub.R1[iR1].sc==0) )continue;
         int jQ1bb=sub.R1[iR1].Q1bb;
         int jQ1sc=sub.R1[iR1].Q1sc;
         int iL0=sub.R1[iR1].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
            bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
            int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
            if( !con.Q1[jQ1].sub )continue;
            std::string tor=mol.Q1[jQ1].tor;
            int jR1=( tor=="OMG" )? iR1-1: iR1;
            int mT5=sub.R1[jR1].T5a;
            int nT5=(mT5-1+sub.R1[jR1].cT5);
            for(int iT5=mT5;iT5<=nT5;iT5++){
               if( sub.T5[iT5].tor==tor ){
                  def.D0T5chi(def.iD0,iT5)=
                          dep.Q1[jQ1].chi/physics_consts.RAD;
               }
            }
         }
      }

   }

   return;
}
