#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <cmath>

class MEM_glo_u2 {
private:
   std::vector<int> o_Q0Q1;        //
public:
   MEM_glo_u2():
      o_Q0Q1(12)
   {
   }
   int& Q0Q1(int i){
      return o_Q0Q1.at( i);
   }
};

void Glo::GLO_U2(Glo_Automatic& aut,
                 const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_RESIDUE_MAPPINGS& residue_mappings,
                 const Thread_Options& opt,
                 const Backbone_Defs& def,
                 const Search_Subspace& sub,
                 const Mechanical_System& mol,
                 const Subset_Contracted_System::tM3& con,
                 const Conf_Dependent_System& dep,
                 Energy_Surface4& ene,
                 Local_Minimization4& loc){

   MEM_glo_u2 vv;
   ene.nU2=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      ene.nU2+=(con.Z0[iZ0].cQ2-1);
      if( con.Z0[iZ0].sub )ene.nU2+=6;
   }

   if( opt.MODE=="sc " ){
      loc.BETA= (4.00e-2);
      loc.BET1= (8.00e-2);
      loc.BET2= (4.00e-2);
      loc.BMIN= (2.00e-9);
      loc.BMAX= (0.80e-1);
      loc.BDEL= (1.00e-1);
      loc.EPS1= (1.00e-3);
      loc.EPS2= (1.00e-2);
      loc.nM2=32;
      loc.cM2_1= 9;
      loc.cM4_1= 6;
      ene.Ecut= (2.40)/physics_consts.CAL;

      int oY3=con.nY3;
      aut.oY3=oY3;
      aut.Y3.resize(oY3);
      aut.o_Y3Y3.resize((oY3*(oY3-1))/2);
      aut.o_Y3Q6Q1.resize(oY3*5);
      int oD3=aut.D3.size();

      for(int iY3= 0;iY3<oY3;iY3++){
         int iR1=con.Y3R1(iY3);
         aut.Y3[iY3].R0=sub.R1[iR1].R0;
         aut.Y3[iY3].aa=sub.R1[iR1].aa;
         int iL0=sub.R1[iR1].L0;
         aut.Y3[iY3].C2a=residue_mappings.L0[iL0].C2a;
         aut.Y3[iY3].cC2=residue_mappings.L0[iL0].cC2;
         int jQ1sc=sub.R1[iR1].Q1sc;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
            if( residue_mappings.Q0[iQ0].br>0 ){
               vv.Q0Q1(iQ0-mQ0)=++jQ1sc;
            }else{
               vv.Q0Q1(iQ0-mQ0)=0;
            }
         }
         int nQ6=residue_mappings.L0[iL0].nQ6;
         aut.Y3[iY3].nQ6=nQ6;
         for(int iQ6= 0;iQ6<nQ6;iQ6++){
            aut.Y3Q6Q1(iY3,iQ6)=
                vv.Q0Q1(residue_mappings.L0Q6Q0(iL0,iQ6)-mQ0);
         }
         aut.Y3[iY3].o_C2e.resize(aut.Y3[iY3].cC2);
      }

      for(int iY3= 0;iY3<(oY3-1);iY3++){
         int oi=aut.Y3[iY3].cC2;
         for(int jY3=(iY3+1);jY3<oY3;jY3++){
            int oj=aut.Y3[jY3].cC2;
            aut.Y3Y3(iY3,jY3).oC2=oj;
            aut.Y3Y3(iY3,jY3).o_C2C2e.clear();
            aut.Y3Y3(iY3,jY3).o_C2C2e.resize(oi*oj,(1.00e+8));
            aut.Y3Y3(iY3,jY3).o_C2z.resize(oi);
         }
      }

      for(int iD3= 0;iD3<oD3;iD3++){
         aut.D3[iD3].o_Y3iC2.resize(oY3);
         aut.D3[iD3].o_U2chi.resize(ene.nU2);
      }

   }else{
      loc.BETA= (2.00e-2);
      loc.BMIN= (2.00e-9);
      loc.BMAX= (0.80e-1);
      loc.BDEL= (1.00e-1);
      loc.EPS1= (1.00e-3);
      loc.EPS2= (1.00e-2);
      loc.nM2=32;

      int zR1=0;
      for(int iR1= 0;iR1<sub.nR1;iR1++){
         if( sub.R1[iR1].bb==2 )zR1++;
      }
      loc.BET1=( zR1>15 )? (3.20e-2): (4.00e-2);
      loc.BET2=( zR1>15 )? (1.60e-2): (2.00e-2);
      loc.cM2_1=18;
      loc.cM4_1= 9;
      ene.Ecut= (4.00)/physics_consts.CAL;
      aut.LARGE_SUBSPACE=( zR1>15 )? true: false;

//    int zCYS=0;
//    for(int iR1= 0;iR1<sub.nR1;iR1++){
//       if( (sub.R1[iR1].bb>0)||(sub.R1[iR1].sc>0) ){
//          std::string aa=sub.R1[iR1].aa;
//          if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
//          if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
//          if( aa=="CYS " )zCYS++;
//       }
//    }

   }

   int iU2=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      if( con.Z0[iZ0].sub ){
         ene.Z0[iZ0].U2a=iU2;
         ene.U2chi(iU2  )= dep.Z0[iZ0].trans(0);
         ene.U2chi(iU2+1)= dep.Z0[iZ0].trans(1);
         ene.U2chi(iU2+2)= dep.Z0[iZ0].trans(2);
         ene.U2chi(iU2+3)= dep.Z0[iZ0].rot(0);
         ene.U2chi(iU2+4)= dep.Z0[iZ0].rot(1);
         ene.U2chi(iU2+5)= dep.Z0[iZ0].rot(2);
         ene.U2uca(iU2  )= (2.00);
         ene.U2uca(iU2+1)= (2.00);
         ene.U2uca(iU2+2)= (2.00);
         ene.U2uca(iU2+3)= (.125);
         ene.U2uca(iU2+4)= (.125);
         ene.U2uca(iU2+5)= (.125);
         iU2+=6;
      }else{
         ene.Z0[iZ0].U2a=ene.nU2;
      }
   }
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            ene.Q2[iQ2].U2=iU2;
            ene.U2chi(iU2)= dep.Q2[iQ2].chi;
            ene.U2uca(iU2)=( con.Q2[iQ2].br>0 )? (.500): (.125);
            if( ene.Q2[iQ2].cut )ene.U2uca(iU2)= (0.00);
            iU2++;
         }
      }
   }

   loc.EPS1= ene.nU2*(loc.EPS1*loc.EPS1);
   loc.BETA= std::sqrt( ene.nU2)*loc.BETA;
   loc.BMIN= std::sqrt( ene.nU2)*loc.BMIN;
   loc.BMAX= std::sqrt( ene.nU2)*loc.BMAX;
   loc.BET1= std::sqrt( ene.nU2)*loc.BET1;
   loc.BET2= std::sqrt( ene.nU2)*loc.BET2;

   return;
}
