#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <cstdlib>
#include <iomanip>
#include <cmath>

void Glo::GLO_STEP(Glo_Automatic& aut,
                   const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_RESIDUE_MAPPINGS& residue_mappings,
                   const DAT_REGION_MAPS& region_maps,
                   const Thread_Options& opt,
                   Output_Streams& out,
                   Structure& str,
                   const Search_Subspace& sub,
                   const Mechanical_System& mol,
                   const Subset_Contracted_System::tM3& con,
                   Conf_Dependent_System& dep,
                   Backbone_Defs& def){
   int oZ0=mol.nZ0;
   int oR1=sub.nR1;
   int oT5=(sub.R1[oR1-1].T5a+sub.R1[oR1-1].cT5);
   if      ( opt.MODE=="bb " ){
      int iD0=0;
      for(int iD2= 0;iD2<aut.nD2;iD2++){
         iD0++;

         int iU2=0;
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            if( con.Z0[iZ0].sub ){
               dep.Z0[iZ0].trans(0)= aut.D2[iD2].U2chi(iU2  )
                                    /physics_consts.ANG;
               dep.Z0[iZ0].trans(1)= aut.D2[iD2].U2chi(iU2+1)
                                    /physics_consts.ANG;
               dep.Z0[iZ0].trans(2)= aut.D2[iD2].U2chi(iU2+2)
                                    /physics_consts.ANG;
               dep.Z0[iZ0].rot(0)= physics_consts.RAD
                                  *aut.D2[iD2].U2chi(iU2+3);
               dep.Z0[iZ0].rot(1)= physics_consts.RAD
                                  *aut.D2[iD2].U2chi(iU2+4);
               dep.Z0[iZ0].rot(2)= physics_consts.RAD
                                  *aut.D2[iD2].U2chi(iU2+5);
               iU2+=6;
            }
         }
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            int mQ2=con.Z0[iZ0].Q2a;
            int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
            for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
               if( (con.Q2[iQ2].br==0)||
                   (con.Q2[iQ2].tor.substr(0,2)=="NU") ){
                  dep.Q2[iQ2].chi= physics_consts.RAD
                                  *aut.D2[iD2].U2chi(iU2);
               }else{
               }
               iU2++;
            }
         }

         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            int mQ2=con.Z0[iZ0].Q2a;
//          int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
            int mQ1=mol.Z0[iZ0].Q1a;
            int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
            int iQ2=mQ2;
            for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
               if( con.Q1[iQ1].sub ){
                  dep.Q1[iQ1].chi= dep.Q2[++iQ2].chi;
               }
            }
         }

         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            def.D0[iD0].Z0[iZ0].trans=dep.Z0[iZ0].trans;
            def.D0[iD0].Z0[iZ0].rot=dep.Z0[iZ0].rot;
         }
         for(int iT5= 0;iT5<oT5;iT5++){
            def.D0T5chi(iD0,iT5)= def.D0T5chi( 0,iT5);
         }
         for(int iR1= 0;iR1<oR1;iR1++){
            if( (sub.R1[iR1].bb==0)&&(sub.R1[iR1].sc==0) )continue;
            int jQ1bb=sub.R1[iR1].Q1bb;
            int jQ1sc=sub.R1[iR1].Q1sc;
            int iL0=sub.R1[iR1].L0;
            int mQ0=residue_mappings.L0[iL0].Q0a;
            int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
               int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
               if( !con.Q1[jQ1].sub )continue;
               std::string tor=mol.Q1[jQ1].tor;
               int jR1=( tor=="OMG" )? iR1-1: iR1;
               int mT5=sub.R1[jR1].T5a;
               int nT5=(mT5-1+sub.R1[jR1].cT5);
               for(int iT5=mT5;iT5<=nT5;iT5++){
                  if( sub.T5[iT5].tor==tor ){
                     def.D0T5chi(iD0,iT5)=
                             dep.Q1[jQ1].chi/physics_consts.RAD;
                  }
               }
            }
         }
         for(int i=0;i<6;i++){
            def.D0[iD0].e[i]= aut.D2[iD2].f[i];
         }

      }
      def.nD0=(aut.nD2+1);
      def.PRINT(physics_consts,residue_mappings,region_maps,
                out,sub,opt.MODE);

   }else if( opt.MODE=="sc " ){
      int oD3=aut.nD3;

      double Eglo= aut.D3[ 0].f[0];
      double Z= (0.00);
      for(int iD3= 0;iD3<oD3;iD3++){
         aut.D3[iD3].f[0]-=Eglo;
         if( aut.D3[iD3].f[0]<((7.00e+2)*def.TEMP) ){
            Z+= std::exp(-aut.D3[iD3].f[0]/def.TEMP);
         }
      }

      double G= aut.random_gen();
      aut.iD3=0;
      double F= (0.00);
      for(int jD3= 0;jD3<oD3;jD3++){
         if( aut.D3[jD3].f[0]<((7.00e+2)*def.TEMP) ){
            F+= std::exp(-aut.D3[jD3].f[0]/def.TEMP)/Z;
            if( F>G ){
               aut.iD3=jD3;
               break;
            }
         }
      }

      if( out.VERBOSE&&false ){
         out.FILE3<<"selected conf=\n";
         out.FILE3<< std::fixed<< std::setprecision(1);
         out.FILE3<< std::setw( 5)<<aut.iD3<<' '
                  <<" F ="<< std::setw( 7)<<aut.D3[aut.iD3].f[0]
                  <<" Fr="<< std::setw( 7)<<aut.D3[aut.iD3].f[1]
                  <<" Fe="<< std::setw( 7)<<aut.D3[aut.iD3].f[2]
                  <<" Fs="<< std::setw( 7)<<aut.D3[aut.iD3].f[3]
                  <<" Ft="<< std::setw( 7)<<aut.D3[aut.iD3].f[4]
                  <<" Fh="<< std::setw( 7)<<aut.D3[aut.iD3].f[5]
                  <<" Fm="<< std::setw( 7)<<aut.D3[aut.iD3].f[6]
                  <<" rotamers=";
         for(int iY3= 0;iY3<aut.oY3;iY3++){
            out.FILE3<< std::setw( 4)<<aut.D3[aut.iD3].Y3iC2(iY3);
         }
         out.FILE3<<'\n';
      }

      int iU2=0;
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         if( nQ2>mQ2 ){
            for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
               dep.Q2[iQ2].chi= physics_consts.RAD
                               *aut.D3[aut.iD3].U2chi(iU2++);
            }
         }
      }

      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
//       int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         int mQ1=mol.Z0[iZ0].Q1a;
         int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
         if( nQ1>mQ1 ){
            int iQ2=mQ2;
            for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
               if( con.Q1[iQ1].sub ){
                  dep.Q1[iQ1].chi= dep.Q2[++iQ2].chi;
               }
            }
         }
      }

      for(int iY3= 0;iY3<aut.oY3;iY3++){
         int iR1=con.Y3R1(iY3);
         int mT5=sub.R1[iR1].T5a;
         int nT5=(mT5-1+sub.R1[iR1].cT5);
         int jQ1bb=sub.R1[iR1].Q1bb;
         int jQ1sc=sub.R1[iR1].Q1sc;
         int iL0=sub.R1[iR1].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         if( nQ0>=mQ0 ){
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
               int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
               if( !BRANCH )continue;
               std::string tor=mol.Q1[jQ1].tor;
               for(int iT5=mT5;iT5<=nT5;iT5++){
                  if( sub.T5[iT5].tor==tor ){
                     def.D0T5chi(def.iD0,iT5)= dep.Q1[jQ1].chi
                                              /physics_consts.RAD;
                  }
               }
            }
         }
         std::string aa=sub.R1[iR1].aa;
         if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
         if      ( aa=="ASN " ){
            if( std::abs( def.D0T5chi(def.iD0,mT5+ 5))<( 90.) ){
               def.D0T5chi(def.iD0,mT5+ 5)+=(180.);
            }
            if( def.D0T5chi(def.iD0,mT5+ 5)>(180.) ){
               def.D0T5chi(def.iD0,mT5+ 5)-=(360.);
            }
         }else if( aa=="ARG " ){
            if( std::abs( def.D0T5chi(def.iD0,mT5+ 7))>( 90.) ){
               def.D0T5chi(def.iD0,mT5+ 7)+=(180.);
            }
            if( def.D0T5chi(def.iD0,mT5+ 7)>(180.) ){
               def.D0T5chi(def.iD0,mT5+ 7)-=(360.);
            }
         }else if( aa=="GLN " ){
            if( std::abs( def.D0T5chi(def.iD0,mT5+ 6))<( 90.) ){
               def.D0T5chi(def.iD0,mT5+ 6)+=(180.);
            }
            if( def.D0T5chi(def.iD0,mT5+ 6)>(180.) ){
               def.D0T5chi(def.iD0,mT5+ 6)-=(360.);
            }
         }else if( aa=="TYR " ){
            if( std::abs( def.D0T5chi(def.iD0,mT5+ 5))>( 90.) ){
               def.D0T5chi(def.iD0,mT5+ 4)+=(180.);
               def.D0T5chi(def.iD0,mT5+ 5)+=(180.);
            }
            if( def.D0T5chi(def.iD0,mT5+ 4)>(180.) ){
               def.D0T5chi(def.iD0,mT5+ 4)-=(360.);
            }
            if( def.D0T5chi(def.iD0,mT5+ 5)>(180.) ){
               def.D0T5chi(def.iD0,mT5+ 5)-=(360.);
            }
         }
      }

   }else if( opt.MODE=="lp " ){
//
//
// write structures
//
      if( opt.FUNC=="rcyc" ){
      }else if( out.SHELL ){
         std::string cnf0=str.cnf;
         int iD0=0;
         for(int i1=0;i1<=9&&(iD0<def.nD0);i1++){
            char a1=char('0'+i1);
            for(int i2=0;i2<=9&&(iD0<def.nD0);i2++){
               char a2=char('0'+i2);
               for(int i3=0;i3<=9&&(iD0<def.nD0);i3++){
                  char a3=char('0'+i3);

                  for(int iZ0= 0;iZ0<oZ0;iZ0++){
                     str.Z0[iZ0].trans=def.D0[iD0].Z0[iZ0].trans;
                     str.Z0[iZ0].rot=def.D0[iD0].Z0[iZ0].rot;
                  }
                  int mT5=0;
                  for(int iR1= 0;iR1<oR1;iR1++){
                     int iR0=sub.R1[iR1].R0;
                     int mT1=str.R0[iR0].T1a;
                     int nT1=(mT1-1+str.R0[iR0].cT1);
                     for(int iT1=mT1;iT1<=nT1;iT1++){
                        str.T1[iT1].chi= def.D0T5chi(iD0,iT1-mT1+mT5);
                     }
                     mT5+=sub.R1[iR1].cT5;
                  }
                  str.CAR(physics_consts,residue_mappings);
                  str.cnf=cnf0+'_'+opt.QSUB+'_'+a1+a2+a3;
                  str.CAR2FIL();
                  str.TOR2FIL(physics_consts);
                  iD0++;
               }
            }
         }
         str.cnf=cnf0;
      }

   }

   return;
}
