#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi1_Automatic.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <vector>
#include <iostream>
#include <iomanip>
#include <cmath>

class MEM_glo_scpck {
private:
   std::vector<double> o_X3f;      //
   int o_Y3;                       //
   std::vector<int> o_X3Y3C2;      //
   std::vector<double> o_Y3f;      //
   std::vector<double> o_Y3g;      //
   std::vector<int> o_Q2Y3;        //
public:
   MEM_glo_scpck(int oX3,int oY3,int oQ2):
      o_X3f(oX3, (1.00e+8)),
      o_Y3(oY3),
      o_X3Y3C2(oX3*oY3,-1),
      o_Y3f(oY3),
      o_Y3g(oY3),
      o_Q2Y3(oQ2,-1)
   {
   }
   double& X3f(int i){
      return o_X3f.at( i);  }
   int& X3Y3C2(int i,int j){
      return o_X3Y3C2.at( i*o_Y3 +j);  }
   double& Y3f(int i){
      return o_Y3f.at( i);  }
   double& Y3g(int i){
      return o_Y3g.at( i);  }
   int& Q2Y3(int i){
      return o_Q2Y3.at( i);  }
};

void Glo::GLO_SCPCK(Glo_Automatic& aut,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_ARRAY_CONSTS& array_consts,
                    const DAT_ENERGY_PARAMS& energy_params,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    const DAT_REGION_MAPS& region_maps,
                    const Thread_Options& opt,
                    Output_Streams& out,
                    const Structure& str,
                    const Search_Subspace& sub,
                    Backbone_Defs& def,
                    const Mechanical_System& mol,
                    const Subset_Contracted_System::tM3& con,
                    Conf_Dependent_System& dep,
                    Energy_Surface4& ene,
                    Local_Minimization4& loc){
   int oZ0=mol.nZ0;
   int oY3=aut.oY3;
   int oX3;
   if      ( def.iD0< 8 ){
      oX3=2048;
   }else if( def.iD0<24 ){
      oX3=1024;
   }else if( def.iD0<56 ){
      oX3= 512;
   }else{
      oX3= 256;
   }
   if( opt.FUNC=="ptra" ){
      oX3/=2;
   }
   int oQ2=con.oQ2;
   MEM_glo_scpck vv(oX3,oY3,oQ2);
   bool LATTICE=true;
   Phi_Automatic ph2(con);
   ene.ethresh= (1.00e-5);
   ene.RECYCLE=false;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mE1=con.Z0[iZ0].E1a;
      int nE1=(mE1-1+con.Z0[iZ0].cE1);
      for(int iE1=mE1;iE1<=nE1;iE1++){
         ene.E1part(iE1, true);
      }
   }

   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"1- and 2-body energies for pairs of side chain rotamers\n";
   }
   for(int iY3= 0;iY3<oY3;iY3++){
      int nQ6=aut.Y3[iY3].nQ6;
      for(int iQ6= 0;iQ6<nQ6;iQ6++){
         int iQ2=aut.Q1[aut.Y3Q6Q1(iY3,iQ6)].Q2;
         vv.Q2Y3(iQ2)=iY3;
      }
   }
   int pY3=-1;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            if( con.Q2[iQ2].cbr==0 ){
               pY3=vv.Q2Y3(iQ2);
            }else if( (vv.Q2Y3(iQ2)==-1)&&(pY3>-1) ){
               vv.Q2Y3(iQ2)=pY3;
            }
         }
      }
   }

   for(int iY3= 0;iY3<oY3;iY3++){
      aut.Y3[iY3].iC2=aut.Y3[iY3].C2a;
   }
//
//
// lattice 1-body energies
//
   for(int iY3= 0;iY3<oY3;iY3++){
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         int mE1=con.Z0[iZ0].E1a;
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
            int nE1=(mE1-1+con.Q2[iQ2].cE1);
            if( nE1>=mE1 ){
               for(int iE1=mE1;iE1<=nE1;iE1++){
                  int jQ2=con.E1[iE1].k;
                  ene.E1pass(iE1,
                             ( (vv.Q2Y3(iQ2)==iY3)&&
                               (vv.Q2Y3(jQ2)==iY3) )? false: true
                              );
               }
               mE1+=con.Q2[iQ2].cE1;
            }
            ene.Q2[iQ2].pass=( vv.Q2Y3(iQ2)==iY3 )? false: true;
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
         }
      }
      if( out.VERBOSE&& out.SHELL ){
         out.FILE3<< std::setw( 4)<<aut.Y3[iY3].R0<<' '
                  <<aut.Y3[iY3].aa<<'\n';
         out.FILE3<<"  iC2  ""   tot      ""    Fr  ""    Fe  "
                    "    Fs  ""    Ft  ""    Fb  ""    Fh  "
                    "    Fw  \n";
      }
      int iC2min=aut.Y3[iY3].C2a;
      int iC2max=(iC2min-1+aut.Y3[iY3].cC2);
      for(int iC2=iC2min;iC2<=iC2max;iC2++){
         int aC2=(iC2-iC2min);
         aut.Y3[iY3].iC2=iC2;
         GLO_CHI(aut,
                 physics_consts,residue_mappings,
                 opt,sub,mol,con,dep,ene,def,
                 LATTICE);
         ene.QMEDIUM=true;
         ene.QFAC(ph2,
                  physics_consts,
                  out,mol,con,dep);
         ene.PHIG(ph2,
                  physics_consts,array_consts,energy_params,
                  region_maps,
                  opt,out,mol,con,dep);
         ene.Fr*=physics_consts.CAL;
         ene.Fe*=physics_consts.CAL;
         ene.Fs*=physics_consts.CAL;
         ene.Ft*=physics_consts.CAL;
         ene.Fb*=physics_consts.CAL;
         ene.Fh*=physics_consts.CAL;
         ene.Fw*=physics_consts.CAL;
         ene.Fp*=physics_consts.CAL;
         ene.Fp_a*=physics_consts.CAL;
         ene.Fp_b*=physics_consts.CAL;
         ene.Fp_c*=physics_consts.CAL;
         ene.Fp_d*=physics_consts.CAL;
         ene.Fp_e*=physics_consts.CAL;
         aut.Y3[iY3].C2e(aC2)=( ene.Fr +ene.Fe +ene.Ft +ene.Fb +(2.00)*ene.Fh
                               +ene.Fw)
                               +std::sqrt( (ene.Fs/(1.00e+2)) +(1.00e-12));
         if( out.VERBOSE&& out.SHELL ){
            out.FILE3<< std::setw( 5)<<aC2<<"  "
                     << std::scientific<< std::setprecision(3)
                     << std::setw(10)<<aut.Y3[iY3].C2e(aC2)<<"  "
                     << std::fixed<< std::setprecision(1)
                     << std::setw(10)<<ene.Fr
                     << std::setw( 8)<<ene.Fe
                     << std::setw( 8)<<ene.Fs
                     << std::setw( 8)<<ene.Ft
                     << std::setw( 8)<<ene.Fb
                     << std::setw( 8)<<ene.Fh
                     << std::setw( 8)<<ene.Fw<<'\n';
         }
         ene.RECYCLE=true;
      }
      aut.Y3[iY3].iC2=iC2min;
      aut.Y3[iY3].normalize();
   }
   if( out.SHELL&& false ){
      std::cout<<"ROTAMER-EXTERNAL FIELD ENERGIES COMPLETED\n";
   }
//
//
// lattice 2-body energies
//
   double w=( oY3> 1 )? (1.00)/(oY3-1): (1.00);
   for(int iY3= 0;iY3<(oY3-1);iY3++){
      int iC2min=aut.Y3[iY3].C2a;
      int iC2max=(iC2min-1+aut.Y3[iY3].cC2);
      for(int jY3=(iY3+1);jY3<oY3;jY3++){
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            int mQ2=con.Z0[iZ0].Q2a;
            int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
            int mE1=con.Z0[iZ0].E1a;
            int iQ2=mQ2;
            int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
               int nE1=(mE1-1+con.Q2[iQ2].cE1);
               if( nE1>=mE1 ){
                  for(int iE1=mE1;iE1<=nE1;iE1++){
                     int jQ2=con.E1[iE1].k;
                     ene.E1pass(iE1,
                                ( (vv.Q2Y3(iQ2)==jY3)&&
                                  (vv.Q2Y3(jQ2)==iY3) )? false: true
                                 );
                  }
                  mE1+=con.Q2[iQ2].cE1;
               }
               ene.Q2[iQ2].pass=true;
               if( con.Q2[iQ2].omg==1 ){
                  int L=iQ2hold;
                  iQ2hold=(iQ2+1);
                  iQ2=L;
               }else{
                  iQ2++;
               }
            }
         }
         int jC2min=aut.Y3[jY3].C2a;
         int jC2max=(jC2min-1+aut.Y3[jY3].cC2);
         if( out.VERBOSE&& out.SHELL ){
            out.FILE3<< std::setw( 4)<<aut.Y3[iY3].R0<<' '
                     <<aut.Y3[iY3].aa<<' '
                     << std::setw( 4)<<aut.Y3[jY3].R0<<' '
                     <<aut.Y3[jY3].aa<<'\n';
            out.FILE3<<"  iC2  jC2  ""   tot      ""    Fr  ""    Fe  "
                       "    Fs  ""    Ft  ""    Fb  ""    Fh  "
                       "    Fw  \n";
         }
         aut.Y3Y3(iY3,jY3).z= (1.00e+8);
         for(int iC2=iC2min;iC2<=iC2max;iC2++){
            int aC2=(iC2-iC2min);
            aut.Y3Y3(iY3,jY3).C2z(aC2)= (1.00e+8);
            if( aut.Y3[iY3].C2e(aC2)>(10.00) )continue;
            aut.Y3[iY3].iC2=iC2;
            for(int jC2=jC2min;jC2<=jC2max;jC2++){
               int bC2=(jC2-jC2min);
               if( aut.Y3[jY3].C2e(bC2)>(10.00) )continue;
               aut.Y3[jY3].iC2=jC2;
               GLO_CHI(aut,
                       physics_consts,residue_mappings,
                       opt,sub,mol,con,dep,ene,def,
                       LATTICE);
               ene.QMEDIUM=true;
               ene.QFAC(ph2,
                        physics_consts,
                        out,mol,con,dep);
               ene.PHIG(ph2,
                        physics_consts,array_consts,energy_params,
                        region_maps,
                        opt,out,mol,con,dep);
               ene.Fr*=physics_consts.CAL;
               ene.Fe*=physics_consts.CAL;
               ene.Fs*=physics_consts.CAL;
               ene.Ft*=physics_consts.CAL;
               ene.Fb*=physics_consts.CAL;
               ene.Fh*=physics_consts.CAL;
               ene.Fw*=physics_consts.CAL;
               ene.Fp*=physics_consts.CAL;
               ene.Fp_a*=physics_consts.CAL;
               ene.Fp_b*=physics_consts.CAL;
               ene.Fp_c*=physics_consts.CAL;
               ene.Fp_d*=physics_consts.CAL;
               ene.Fp_e*=physics_consts.CAL;
               aut.Y3Y3(iY3,jY3).C2C2e(aC2,bC2)=
                            w*( aut.Y3[iY3].C2e(aC2)
                               +aut.Y3[jY3].C2e(bC2))
                           +( ene.Fr +ene.Fe +ene.Ft +ene.Fb +(2.00)*ene.Fh
                             +ene.Fw)
                             +std::sqrt( (ene.Fs/(1.00e+2)) +(1.00e-12));
               if( out.VERBOSE&& out.SHELL ){
                  out.FILE3<< std::setw( 5)<<aC2
                           << std::setw( 5)<<bC2<<"  "
                           << std::scientific<< std::setprecision(3)
                           << std::setw(10)<<aut.Y3Y3(iY3,jY3).C2C2e(aC2,bC2)
                           <<"  "
                           << std::fixed<< std::setprecision(1)
                           << std::setw(10)<<ene.Fr
                           << std::setw( 8)<<ene.Fe
                           << std::setw( 8)<<ene.Fs
                           << std::setw( 8)<<ene.Ft
                           << std::setw( 8)<<ene.Fb
                           << std::setw( 8)<<ene.Fh
                           << std::setw( 8)<<ene.Fw<<'\n';
               }
               if( aut.Y3Y3(iY3,jY3).C2C2e(aC2,bC2)<
                   aut.Y3Y3(iY3,jY3).z ){
                  aut.Y3Y3(iY3,jY3).z= aut.Y3Y3(iY3,jY3).C2C2e(aC2,bC2);
               }
               if( aut.Y3Y3(iY3,jY3).C2C2e(aC2,bC2)<
                   aut.Y3Y3(iY3,jY3).C2z(aC2) ){
                  aut.Y3Y3(iY3,jY3).C2z(aC2)=
                      aut.Y3Y3(iY3,jY3).C2C2e(aC2,bC2);
               }
            }
         }
         aut.Y3[iY3].iC2=iC2min;
         aut.Y3[jY3].iC2=jC2min;
         aut.Y3Y3(iY3,jY3).normalize();
      }
   }
   if( out.SHELL&& false ){
      std::cout<<"ROTAMER-ROTAMER ENERGIES COMPLETED\n";
   }
   ene.RECYCLE=false;
//
//
// combinatorial search
//
   if      ( oY3== 1 ){
      int cC2=aut.Y3[ 0].cC2;
      int jX3=0;
      for(int aC2= 0;aC2<cC2;aC2++){
         if( aut.Y3[ 0].C2e(aC2)>(20.00) )continue;
         jX3++;
      }
      for(int aC2= 0;aC2<cC2;aC2++){
         if( aut.Y3[ 0].C2e(aC2)>(20.00) )continue;
         vv.X3f(jX3-1)= aut.Y3[ 0].C2e(aC2);
         vv.X3Y3C2(jX3-1, 0)=aC2;
         for(int iX3=(jX3-1);iX3>0;iX3--){
            if( vv.X3f(iX3)>=vv.X3f(iX3-1) )break;
            double f= vv.X3f(iX3-1);
            vv.X3f(iX3-1)= vv.X3f(iX3);
            vv.X3f(iX3)= f;
            int j=vv.X3Y3C2(iX3-1, 0);
            vv.X3Y3C2(iX3-1, 0)=vv.X3Y3C2(iX3  , 0);
            vv.X3Y3C2(iX3  , 0)=j;
         }
      }

   }else if( oY3<=12 ){
      for(int iY3= 0;iY3<oY3;iY3++){
         aut.Y3[iY3].iC2=-1;
      }

      double g= (0.00);
      for(int iY3= 0;iY3<(oY3-1);iY3++){
         for(int jY3=(iY3+1);jY3<oY3;jY3++){
            g+=aut.Y3Y3(iY3,jY3).z;
         }
      }
      double f= (0.00);

      int iY3= 0;
      for(;;){
         aut.Y3[iY3].iC2++;
         if( aut.Y3[iY3].iC2>=aut.Y3[iY3].cC2 ){
            if( iY3== 0 ){
               break;
            }else{
               aut.Y3[iY3].iC2=-1;
               iY3--;
               continue;
            }

         }else{
            if( iY3== 0 ){
               vv.Y3f(iY3)= f;
               vv.Y3g(iY3)= g;
            }else{
               vv.Y3f(iY3)= vv.Y3f(iY3-1);
               vv.Y3g(iY3)= vv.Y3g(iY3-1);
            }
            for(int jY3= 0;jY3<iY3;jY3++){
               vv.Y3f(iY3)+=aut.Y3Y3(jY3,iY3).C2C2e(aut.Y3[jY3].iC2,
                                                    aut.Y3[iY3].iC2);
               vv.Y3g(iY3)-=aut.Y3Y3(jY3,iY3).C2z(aut.Y3[jY3].iC2);
            }
            for(int jY3=(iY3+1);jY3<oY3;jY3++){
               vv.Y3g(iY3)-=aut.Y3Y3(iY3,jY3).z;
               vv.Y3g(iY3)+=aut.Y3Y3(iY3,jY3).C2z(aut.Y3[iY3].iC2);
            }
            if( (vv.Y3f(iY3)+vv.Y3g(iY3))>=vv.X3f(oX3-1) )continue;
            if( iY3==(oY3-1) ){
               vv.X3f(oX3-1)= vv.Y3f(iY3);
               for(int jY3= 0;jY3<oY3;jY3++){
                  vv.X3Y3C2(oX3-1,jY3)=aut.Y3[jY3].iC2;
               }
               for(int iX3=(oX3-1);iX3>0;iX3--){
                  if( vv.X3f(iX3)>=vv.X3f(iX3-1) )break;
                  double z= vv.X3f(iX3-1);
                  vv.X3f(iX3-1)= vv.X3f(iX3);
                  vv.X3f(iX3)= z;
                  for(int jY3= 0;jY3<oY3;jY3++){
                     int j=vv.X3Y3C2(iX3-1,jY3);
                     vv.X3Y3C2(iX3-1,jY3)=vv.X3Y3C2(iX3  ,jY3);
                     vv.X3Y3C2(iX3  ,jY3)=j;
                  }
               }
            }else{
               iY3++;
            }

         }
      }
   }

   int nX3=oX3;
   while( vv.X3f(nX3-1)>=(1.00e+8) ){
      nX3--;
      if( nX3==0 )break;
   }

   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"lattice search\n";
      out.FILE3<<"  iX3  ""   X3f    ""  X3Y3C2\n";
      out.FILE3<< std::fixed<< std::setprecision(1);
      for(int iX3= 0;iX3<nX3;iX3++){
         out.FILE3<< std::setw( 5)<<iX3<<"  "
                  << std::setw( 8)<<vv.X3f(iX3)<<"  ";
         for(int iY3= 0;iY3<oY3;iY3++){
            out.FILE3<< std::setw( 4)<<vv.X3Y3C2(iX3  ,iY3);
         }
         out.FILE3<<'\n';
      }
   }
   if( out.SHELL&& false ){
      std::cout<<"LATTICE SEARCH COMPLETED\n";
   }
//
//
// off lattice overlap removal
//
   Phi1_Automatic ph1(con);
   ene.RECYCLE=false;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mE1=con.Z0[iZ0].E1a;
      int nE1=(mE1-1+con.Z0[iZ0].cE1);
      for(int iE1=mE1;iE1<=nE1;iE1++){
         ene.E1pass(iE1,false);
      }
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
         ene.Q2[iQ2].pass=false;
      }
   }

   aut.CLASH=true;
   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"overlap removal\n";
      out.FILE3<<"  iD3  ""   tot   ""nE3  "
                 "   Fr  ""   Fe  ""   Fs  ""   Ft  ""    Fb  "
                 "   Fh    ""   Fw    ""   Y3iC2\n";
   }
   int nE3min=256;
   aut.iD3=-1;
   for(int iX3= 0;iX3<nX3;iX3++){
      aut.iD3++;
      for(int iY3= 0;iY3<oY3;iY3++){
         aut.Y3[iY3].iC2=vv.X3Y3C2(iX3  ,iY3);
         aut.D3[aut.iD3].Y3iC2(iY3)=aut.Y3[iY3].iC2;
         aut.Y3[iY3].iC2+=aut.Y3[iY3].C2a;
      }
      GLO_CHI(aut,
              physics_consts,residue_mappings,
              opt,sub,mol,con,dep,ene,def,
              LATTICE);
      loc.MOV1(ph1,ph2,
               physics_consts,array_consts,energy_params,
               opt,out,sub,mol,con,dep,ene);
//    loc.WRT1(opt,out,mol,con,dep,ene);
//    out.FILE3<<"MOV1 COMPLETED\n";
      GLO_WRT(aut,
              physics_consts,residue_mappings,region_maps,
              opt,sub,mol,con,dep,ene,def);

      if( loc.M4[loc.iM4].nE3<8 )aut.CLASH=false;
      if( loc.M4[loc.iM4].nE3<nE3min )nE3min=loc.M4[loc.iM4].nE3;
      if( loc.M4[loc.iM4].nE3>(nE3min+3) ){
         aut.iD3--;
         continue;
      }
      ene.QMEDIUM=true;
      ene.QFAC(ph2,
               physics_consts,
               out,mol,con,dep);
      ene.PHIG(ph2,
               physics_consts,array_consts,energy_params,
               region_maps,
               opt,out,mol,con,dep);
      ene.Fr*=physics_consts.CAL;
      ene.Fe*=physics_consts.CAL;
      ene.Fs*=physics_consts.CAL;
      ene.Ft*=physics_consts.CAL;
      ene.Fb*=physics_consts.CAL;
      ene.Fh*=physics_consts.CAL;
      ene.Fw*=physics_consts.CAL;
      ene.Fp*=physics_consts.CAL;
      ene.Fp_a*=physics_consts.CAL;
      ene.Fp_b*=physics_consts.CAL;
      ene.Fp_c*=physics_consts.CAL;
      ene.Fp_d*=physics_consts.CAL;
      ene.Fp_e*=physics_consts.CAL;
//    out.FILE3<<"PHIE COMPLETED\n";
      aut.D3[aut.iD3].f[0]=( ene.Fr +ene.Fe +ene.Ft +ene.Fb +(2.00)*ene.Fh
                            +ene.Fw)
                            +std::sqrt( (ene.Fs/(1.00e+2)) +(1.00e-12));
      aut.D3[aut.iD3].f[1]= ene.Fr;
      aut.D3[aut.iD3].f[2]= ene.Fe;
      aut.D3[aut.iD3].f[3]= ene.Fs;
      aut.D3[aut.iD3].f[4]= ene.Ft;
      aut.D3[aut.iD3].f[5]= ene.Fb;
      aut.D3[aut.iD3].f[6]= ene.Fh;
      aut.D3[aut.iD3].f[7]= ene.Fw;
      if( out.VERBOSE&& out.SHELL ){
         out.FILE3<< std::setw( 5)<<aut.iD3<<"  "
                  << std::fixed<< std::setprecision(1)
                  << std::setw( 8)<<aut.D3[aut.iD3].f[0]<<' '
                  << std::setw( 3)<<loc.M4[loc.iM4].nE3<<"  "
                  << std::fixed<< std::setprecision(1)
                  << std::setw( 7)<<ene.Fr
                  << std::setw( 7)<<ene.Fe
                  << std::setw( 7)<<ene.Fs
                  << std::setw( 7)<<ene.Ft
                  << std::setw( 7)<<ene.Fb
                  << std::setw( 7)<<ene.Fh
                  << std::setw( 7)<<ene.Fw<<'\n';
         for(int iY3= 0;iY3<oY3;iY3++){
            out.FILE3<< std::setw( 4)<<aut.D3[aut.iD3].Y3iC2(iY3);
         }
         out.FILE3<<'\n';
      }
   }
   aut.nD3=(aut.iD3+1);
   if( out.SHELL&& false ){
      std::cout<<"OVERLAP REMOVAL COMPLETED\n";
   }

   aut.CLUSTER(opt.MODE,ene.nU2);
   aut.ORDER(opt.MODE);

   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"cluster\n";
      out.FILE3<<"  iD3  ""   tot "
                 "   Fr  ""   Fe  ""   Fs  ""   Ft  ""    Fb  "
                 "   Fh    ""   Fw    ""   Y3iC2\n";
      out.FILE3<< std::fixed<< std::setprecision(1);
      for(int iD3= 0;iD3<aut.nD3;iD3++){
         out.FILE3<< std::setw( 5)<<iD3<<"  "
                  << std::setw( 7)<<aut.D3[iD3].f[0]
                  << std::setw( 7)<<aut.D3[iD3].f[1]
                  << std::setw( 7)<<aut.D3[iD3].f[2]
                  << std::setw( 7)<<aut.D3[iD3].f[3]
                  << std::setw( 7)<<aut.D3[iD3].f[4]
                  << std::setw( 7)<<aut.D3[iD3].f[5]
                  << std::setw( 7)<<aut.D3[iD3].f[6]
                  << std::setw( 7)<<aut.D3[iD3].f[7]<<'\n';
         for(int iY3= 0;iY3<oY3;iY3++){
            out.FILE3<< std::setw( 4)<<aut.D3[iD3].Y3iC2(iY3);
         }
         out.FILE3<<'\n';
      }
   }

   return;
}
