#include "../con/Subset_Contracted_System.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"

void Glo::GLO_F2(const Glo_Automatic& aut,
                 const Mechanical_System& mol,
                 const Subset_Contracted_System::tM3& con,
                 Conf_Dependent_System& dep){
   int iF2=0;
   int iG3=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mF1=mol.Z0[iZ0].F1a;
      int nF1=(mF1-1+mol.Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         if( con.F1[iF1].imp==0 )continue;
         dep.F2[iF2].x= aut.F1[iF1].x;
         dep.F2[iF2].q= aut.F1[iF1].q;
         if( con.F2[iF2].ion ){
            dep.F2[iF2].q.r(0,0)+=con.F2[iF2].off;
         }
         iF2++;
      }
      int mG2=con.Z0[iZ0].G2a;
      int nG2=(mG2-1+con.Z0[iZ0].cG2);
      if( nG2>=mG2 ){
         for(int iG2=mG2;iG2<=nG2;iG2++){
            if( con.F1[con.G2[iG2].F1].imp==0 )continue;
            dep.G3[iG3++].b= dep.G2[iG2].b;
         }
      }
      Coordinates TRANS;
      TRANS=dep.Z0[iZ0].trans;
      double alp= dep.Z0[iZ0].rot(0);
      double bet= dep.Z0[iZ0].rot(1);
      double gam= dep.Z0[iZ0].rot(2);
      Rotation_Matrix ROT(alp,bet,gam);
      int mF2=con.Z0[iZ0].F2a;
      int nF2=(mF2-1+con.Z0[iZ0].cF2);
      for(int iF2=mF2;iF2<=nF2;iF2++){
         dep.F2[iF2].y.generate(TRANS,
                                ROT,
                                dep.F2[iF2].x);
      }
   }
   return;
}
