#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iomanip>

void Glo::GLO_DEF2STR(const DAT_PHYSICS_CONSTS& physics_consts,
                      const DAT_RESIDUE_MAPPINGS& residue_mappings,
                      Output_Streams& out,
                      Structure& str,
                      Search_Subspace& sub,
                      const Backbone_Defs& def){
   int oZ0=str.nZ0;
   int oR1=sub.nR1;
//
//
// output current conf
//
// out.FILE3<< std::fixed;
// std::string rule="________________________________________"
//                  "________________________________________"
//                  "____________________\n";
// out.FILE3<<rule;
// out.FILE3<< std::setprecision(7);
// if( sub.mBOD==1 ){
//    for(int iZ0= 0;iZ0<oZ0;iZ0++){
//       out.FILE3<< std::setw( 2)<<(iZ0+1)<<' ';
//       for(int i=0;i<3;i++){
//          out.FILE3<< std::setw(12)<<(physics_consts.ANG
//                                     *def.D0[def.iD0].Z0[iZ0].trans(i));
//       }
//       for(int i=0;i<3;i++){
//          out.FILE3<< std::setw(12)<<(def.D0[def.iD0].Z0[iZ0].rot(i)
//                                     /physics_consts.RAD);
//       }
//       out.FILE3<<'\n';
//    }
// }
// out.FILE3<< std::setprecision(4);
// for(int iR1= 0;iR1<oR1;iR1++){
//    int iR0=sub.R1[iR1].R0;
//    char c1=str.R0[iR0].c1;
//    std::string aa=sub.R1[iR1].aa;
//    out.FILE3<<aa<<' ';
//    if( aa=="ACE " ){
//       out.FILE3<<"         ";
//    }
//    int mT5=sub.R1[iR1].T5a;
//    int nT5=(mT5-1+sub.R1[iR1].cT5);
//    for(int iT5=mT5;iT5<=nT5;iT5++){
//       if( (c1=='a')&&
//           ((aa[3]=='e')||(aa[3]=='z'))&&
//           (iT5==(mT5+2)) ){
//          out.FILE3<<"         ";
//       }else{
//          out.FILE3<< std::setw( 9)<<def.D0T5chi(def.iD0,iT5);
//       }
//    }
//    out.FILE3<<'\n';
// }
// out.FILE3<<rule;
//
//
// update Structure, Search_Subspace
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      str.Z0[iZ0].trans=def.D0[def.iD0].Z0[iZ0].trans;
      str.Z0[iZ0].rot=def.D0[def.iD0].Z0[iZ0].rot;
   }
   int mT5=0;
   for(int iR1= 0;iR1<oR1;iR1++){
      int iR0=sub.R1[iR1].R0;
      int mT1=str.R0[iR0].T1a;
      int nT1=(mT1-1+str.R0[iR0].cT1);
      for(int iT1=mT1;iT1<=nT1;iT1++){
         str.T1[iT1].chi= def.D0T5chi(def.iD0,iT1-mT1+mT5);
      }
      mT5+=sub.R1[iR1].cT5;
   }
   str.CAR(physics_consts,residue_mappings);

   for(int iR1= 0;iR1<oR1;iR1++){
      int iR0=sub.R1[iR1].R0;
      char c1=str.R0[iR0].c1;
      std::string aa=str.R0[iR0].aa;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      int mP1=str.R0[iR0].P1a;
      int nP1=(mP1-1+str.R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( str.P1[iP1].sub==0 )continue;
         std::string atm=str.P1[iP1].atm;
         if      ( c1=='a' ){
            if( atm==" CA " )sub.R1[iR1].ca=str.P1[iP1].x;
            if( atm==" CB " )sub.R1[iR1].cb=str.P1[iP1].x;
         }else if( c1=='e' ){
         }else if( c1=='r' ){
            if      ( aa=="RME " ){
               if( atm==" O2'" )sub.R1[iR1].ca=str.P1[iP1].x;
               if( atm==" CM'" )sub.R1[iR1].cb=str.P1[iP1].x;
            }else if( aa=="MOE " ){
               if( atm==" O2'" )sub.R1[iR1].ca=str.P1[iP1].x;
               if( atm==" CA'" )sub.R1[iR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='b' ){
            if      ( (aa=="A   ")||(aa=="AP  ")||(aa=="G   ")||
                      (aa=="GP  ")||(aa=="GM  ") ){
               if( atm==" N9 " )sub.R1[iR1].ca=str.P1[iP1].x;
               if( atm==" N1 " )sub.R1[iR1].cb=str.P1[iP1].x;
            }else if( (aa=="T   ")||(aa=="TM  ")||(aa=="C   ")||
                      (aa=="CP  ")||(aa=="U   ")||(aa=="UM  ") ){
               if( atm==" N1 " )sub.R1[iR1].ca=str.P1[iP1].x;
               if( atm==" C4 " )sub.R1[iR1].cb=str.P1[iP1].x;
            }
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }

   return;
}
