#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_glo_def {
private:
   std::vector<double> o_U2chi;         //
   std::vector<double> o_U2uca;         //
   std::vector<double> o_Q1chi;         //
   std::vector<double> o_Q1uca;         //
   std::vector<double> o_Q2chi;         //
   std::vector<double> o_Q2uca;         //
public:
   double EPS1;
   double BETA;
   double BMIN;
   double BMAX;
   double BET1;
   MEM_glo_def(int oQ1,int oQ2,int oU2):
      o_U2chi(oU2),
      o_U2uca(oU2),
      o_Q1chi(oQ1),
      o_Q1uca(oQ1),
      o_Q2chi(oQ2),
      o_Q2uca(oQ2)
   {
   }
   double& U2chi(int i){
      return o_U2chi.at( i);  }
   double& U2uca(int i){
      return o_U2uca.at( i);  }
   double& Q1chi(int i){
      return o_Q1chi.at( i);  }
   double& Q1uca(int i){
      return o_Q1uca.at( i);  }
   double& Q2chi(int i){
      return o_Q2chi.at( i);  }
   double& Q2uca(int i){
      return o_Q2uca.at( i);  }
};

void Glo::GLO_DEF(Glo_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_ARRAY_CONSTS& array_consts,
                  const DAT_ENERGY_PARAMS& energy_params,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  const DAT_REGION_MAPS& region_maps,
                  const DAT_DEFORM_PARAMS& deform_params,
                  const Thread_Options& opt,
                  Output_Streams& out,
                  Backbone_Defs& def,
                  const Structure& str,
                  const Search_Subspace& sub,
                  const Mechanical_System& mol,
                  const Subset_Contracted_System::tM3& con,
                  Conf_Dependent_System& dep,
                  Energy_Surface4& ene,
                  Local_Minimization4& loc){
   int oZ0=con.oZ0;
   int oQ1=con.oQ1;
   int oQ2=con.oQ2;
   int oU2=ene.nU2;
   int oZ2=def.nZ2;
   MEM_glo_def vv(oQ1,oQ2,oU2);
//
//
// initiate energies for combined backbone defs
//
   int oD2=aut.D2.size()/2;
   for(int iD2= 0;iD2<( 2*oD2);iD2++){
      aut.D2[iD2].f[0]= (1.00e+8);
   }
//
//
// construct mappings Q2-->Z2 and G6-->Z2
//
   for(int iZ2= 0;iZ2<oZ2;iZ2++){
      int mR1=def.Z2[iZ2].CYC;
      int nR1=(mR1-1+sub.R1[mR1].pt);
      for(int iR1=mR1;iR1<=nR1;iR1++){
         int iQ1bb=sub.R1[iR1].Q1bb;
         int iQ1sc=sub.R1[iR1].Q1sc;
         int iL0=sub.R1[iR1].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
            bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
            int iQ1=( BRANCH )? ++iQ1sc: ++iQ1bb;
            std::string tor=mol.Q1[iQ1].tor;
            if( con.Q1[iQ1].sub ){
               int iQ2=aut.Q1[iQ1].Q2;
               if      ( (iR1==(nR1  ))&&(tor=="PSI") ){
               }else if( (iR1==(nR1-1))&&(tor=="DEL") ){
               }else{
                  aut.Q2[iQ2].fZ2=iZ2;
               }
               if      ( (iR1==(mR1  ))&&(tor=="OMG") ){
               }else if( (iR1==(mR1  ))&&(tor=="EPS") ){
               }else{
                  aut.Q2[iQ2].bZ2=iZ2;
               }
            }
         }
      }
   }
   for(int iZ2= 0;iZ2<oZ2;iZ2++){
      int mR1=def.Z2[iZ2].CYC;
      int nR1=(mR1-1+sub.R1[mR1].pt);
      int mR0=sub.R1[mR1].R0;
      int nR0=sub.R1[nR1].R0;
      for(int iG6= 0;iG6<con.oG6;iG6++){
         int iR0=con.G6[iG6].R0;
         if( (iR0>=mR0)&&(iR0<=nR0) )aut.G6[iG6].Z2=iZ2;
      }
   }
//
//
// generate collection of combined backbone deformations
//
   int iJ3=0;
   for(int cJ3=def.nJ3;cJ3>0;cJ3--){
      if( out.VERBOSE&& out.SHELL ){
         out.FILE3<<" iJ3="<< std::setw( 5)<<iJ3<<"  [ 0]";
         for(int iZ2= 1;iZ2<oZ2;iZ2++){
            out.FILE3<< std::setw( 2)<<def.Z2[iZ2].J3[iJ3].shf1
                     <<'['<< std::setw( 2)<<iZ2<<']';
         }
         out.FILE3<<'\n';
      }

      bool SOLUTION=true;
      for(int iZ2= 0;iZ2<oZ2&&(SOLUTION);iZ2++){

         int mR1=def.Z2[iZ2].CYC;
         int nR1=(mR1-1+sub.R1[mR1].pt);
         int oR1=(nR1-mR1+1);
         int iL0=sub.R1[mR1].L0;
         char c1=residue_mappings.L0[iL0].c1;
         double the1=( 0.00),the2=( 0.00);
         int aQ1=-1,bQ1=-1;
         if      ( c1=='a' ){
            int aR1=(mR1+def.Z2[iZ2].J3[iJ3].shf1);
            int bR1=(nR1+def.Z2[iZ2].J3[iJ3].shf2);
            int aL0=sub.R1[aR1].L0;
            int bL0=sub.R1[bR1].L0;
            int aT5=sub.R1[aR1].T5a;
            int bT5=sub.R1[bR1].T5a;
            int aSC=residue_mappings.L0[aL0].cU0;
            int aBB=(residue_mappings.L0[aL0].cQ0-aSC);
            aQ1=(sub.R1[aR1].Q1bb+aBB);
            int bSC=residue_mappings.L0[bL0].cU0;
            int bBB=(residue_mappings.L0[bL0].cQ0-bSC);
            bQ1=(sub.R1[bR1].Q1bb+bBB);
            the1= physics_consts.RAD*def.D0T5chi( 0,aT5+1);
            the2= physics_consts.RAD*def.D0T5chi( 0,bT5+1);
         }else if( c1=='e' ){
         }else if( c1=='r' ){
         }else if( c1=='b' ){
         }else if( c1=='p' ){
            int bL0=sub.R1[nR1-1].L0;
            int aT5=sub.R1[mR1  ].T5a;
//          int bT5=sub.R1[nR1-1].T5a;
            aQ1=(sub.R1[mR1  ].Q1bb+1);
            int bSC=residue_mappings.L0[bL0].cU0;
            int bBB=(residue_mappings.L0[bL0].cQ0-bSC);
            bQ1=(sub.R1[nR1-1].Q1bb+bBB);
            the1= physics_consts.RAD*def.D0T5chi( 0,aT5  );
            the2=(   0.00);
         }else if( c1=='s' ){
         }
         double CT= std::cos( the1);
         double ST=-std::sin( the1);
         Rotation_Matrix B;
         B(0,0)= (1.00);
         B(1,0)= (0.00);
         B(2,0)= (0.00);
         B(0,1)= (0.00);
         B(1,1)= CT;
         B(2,1)= ST;
         B(0,2)= (0.00);
         B(1,2)=-ST;
         B(2,2)= CT;
         def.Z2[iZ2].P= aut.Q1[aQ1].tu*B;
         def.Z2[iZ2].y00= aut.F1[mol.Q1[aQ1].bse].x;
         CT= std::cos( the2);
         ST=-std::sin( the2);
         B(0,0)= (1.00);
         B(1,0)= (0.00);
         B(2,0)= (0.00);
         B(0,1)= (0.00);
         B(1,1)= CT;
         B(2,1)= ST;
         B(0,2)= (0.00);
         B(1,2)=-ST;
         B(2,2)= CT;
         def.Z2[iZ2].Q= aut.Q1[bQ1].tu*B;
         def.Z2[iZ2].y18= aut.F1[mol.Q1[bQ1].bse].x;

         if      ( c1=='a' ){
            def.DEF(physics_consts,energy_params,residue_mappings,
                    deform_params,region_maps,
                    opt,out,str,sub,mol,con,dep,ene,loc,
                    iZ2,iJ3);
         }else if( c1=='e' ){
         }else if( c1=='r' ){
         }else if( c1=='b' ){
         }else if( c1=='p' ){
//
//
// backup control and starting conf of minimization
//
            vv.EPS1= loc.EPS1;
            vv.BETA= loc.BETA;
            vv.BMIN= loc.BMIN;
            vv.BMAX= loc.BMAX;
            vv.BET1= loc.BET1;
            for(int iU2= 0;iU2<oU2;iU2++){
               vv.U2chi(iU2)= ene.U2chi(iU2);
               vv.U2uca(iU2)= ene.U2uca(iU2);
            }
            int oX=(nR1-mR1+1)/3;
            {
               double frac= double( 6*oX)/double( oU2);
               loc.EPS1*=frac;
               double z= std::sqrt( frac);
               loc.BET1*=z;
               loc.BMIN*=z;
               loc.BMAX*=z;
            }
            int jZ0=sub.R1[mR1].Z0;
            int mR0=str.Z0[jZ0].R0a;
            int iD1=0;
            def.Z2[iZ2].D1.push_back( Backbone_Defs::tZ2::tZ2D1(oR1));
            int XC6[ 5];
            for(int iX= 0;iX<oX;iX++){
               XC6[iX]=-1;
            }
            int iX= 0;
            for(;;){
               XC6[iX]++;
               if( XC6[iX]>45 ){
                  if( iX== 0 ){
                     break;
                  }else{
                     XC6[iX]=-1;
                     iX--;
                     continue;
                  }

               }else{
                  if( iX==(oX-1) ){
                     bool PASS=false;
                     for(int jX= 0;jX<oX&&(!PASS);jX++){
                        int jC6=XC6[jX];
                        double de0= deform_params.C6[jC6].de0;
                        double eps= deform_params.C6[jC6].eps;
                        double zet= deform_params.C6[jC6].zet;
                        double alp= deform_params.C6[jC6].alp;
                        double bet= deform_params.C6[jC6].bet;
                        double gam= deform_params.C6[jC6].gam;
                        double del= deform_params.C6[jC6].del;
                        std::string cnf=deform_params.C6[jC6].cnf;
                        int jR1=( mR1 +3*jX);
                        int jR0=sub.R1[jR1].R0;
                        if( (mol.R0[jR0  ].c1!='p')||
                            (mol.R0[jR0+1].c1!='r')||
                            (mol.R0[jR0+2].c1!='b') ){
                           std::cerr<<"ERROR: Residue class inconsistency "
                                      "in Search_Subspace.\n";
                           std::exit(2);
                        }
                        double de1= de0;
                        if( jX> 0 ){
                           de1= def.Z2[iZ2].D1[iD1].R1[jR1-2-mR1].del;
                        }else if( (jR0-2)>=mR0 ){
                           int mT1=str.R0[jR0-2].T1a;
                           de1= str.T1[mT1+2].chi;
                        }
                        double z=( de1 -de0);
                        if      ( z>=( 180.) ){ z-=(360.);
                        }else if( z< (-180.) ){ z+=(360.);
                        }
                        if( std::abs( z)>(  30.00) ){
                           PASS=true;
                           continue;
                        }
                        def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].eps= eps;
                        def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].zet= zet;
                        def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].alp= alp;
                        def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].bet= bet;
                        def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].gam= gam;
                        def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].del= del;
                        def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].C6=jC6;
                        def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].cnfa=cnf;
                     }
                     if( PASS )continue;
//
// restrict space of confs to deformable torsions of segment
// replace starting conf with approximate deformation iD1
//
                     for(int iZ0= 0;iZ0<oZ0;iZ0++){
                        int mQ1=mol.Z0[iZ0].Q1a;
                        int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
                        for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
                           vv.Q1uca(iQ1)= (0.00);
                           vv.Q1chi(iQ1)= dep.Q1[iQ1].chi;
                        }
                     }
                     for(int jX= 0;jX<oX;jX++){
                        int jR1=( mR1 +3*jX);
                        double eps= def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].eps;
                        double zet= def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].zet;
                        double alp= def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].alp;
                        double bet= def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].bet;
                        double gam= def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].gam;
                        double del= def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].del;
                        int jQ1bb=sub.R1[jR1  ].Q1bb;
                        int jQ1sc=sub.R1[jR1  ].Q1sc;
                        int jL0=sub.R1[jR1  ].L0;
                        int mQ0=residue_mappings.L0[jL0].Q0a;
                        int nQ0=(mQ0-1+residue_mappings.L0[jL0].cQ0);
                        for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                           bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
                           int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
                           if( BRANCH )continue;
                           std::string tor=mol.Q1[jQ1].tor;
                           if      ( tor=="EPS" ){
                              vv.Q1chi(jQ1)= physics_consts.RAD*eps;
                              vv.Q1uca(jQ1)= (.50);
                           }else if( tor=="ZET" ){
                              vv.Q1chi(jQ1)= physics_consts.RAD*zet;
                              vv.Q1uca(jQ1)= (.50);
                           }else if( tor=="ALP" ){
                              vv.Q1chi(jQ1)= physics_consts.RAD*alp;
                              vv.Q1uca(jQ1)= (.50);
                           }
                        }
                        jQ1bb=sub.R1[jR1+1].Q1bb;
                        jQ1sc=sub.R1[jR1+1].Q1sc;
                        jL0=sub.R1[jR1+1].L0;
                        mQ0=residue_mappings.L0[jL0].Q0a;
                        nQ0=(mQ0-1+residue_mappings.L0[jL0].cQ0);
                        for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                           bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
                           int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
                           if( BRANCH )continue;
                           std::string tor=mol.Q1[jQ1].tor;
                           if      ( tor=="BET" ){
                              vv.Q1chi(jQ1)= physics_consts.RAD*bet;
                              vv.Q1uca(jQ1)= (.50);
                           }else if( tor=="GAM" ){
                              vv.Q1chi(jQ1)= physics_consts.RAD*gam;
                              vv.Q1uca(jQ1)= (.50);
                           }else if( tor=="DEL" ){
                              vv.Q1chi(jQ1)= physics_consts.RAD*del;
                              vv.Q1uca(jQ1)= (.10);
                           }
                        }
                     }
                     for(int iZ0= 0;iZ0<oZ0;iZ0++){
                        int mQ1=mol.Z0[iZ0].Q1a;
                        int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
                        int mQ2=con.Z0[iZ0].Q2a;
//                      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
                        int iQ2=mQ2;
                        for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
                           if( con.Q1[iQ1].sub ){
                              iQ2++;
                              vv.Q2chi(iQ2)= vv.Q1chi(iQ1);
                              vv.Q2uca(iQ2)= vv.Q1uca(iQ1);
                           }
                        }
                     }
                     int iU2=0;
                     for(int iZ0= 0;iZ0<oZ0;iZ0++){
                        if( con.Z0[iZ0].sub ){
                           ene.U2uca(iU2++)= (0.00);
                           ene.U2uca(iU2++)= (0.00);
                           ene.U2uca(iU2++)= (0.00);
                           ene.U2uca(iU2++)= (0.00);
                           ene.U2uca(iU2++)= (0.00);
                           ene.U2uca(iU2++)= (0.00);
                        }
                     }
                     for(int iZ0= 0;iZ0<oZ0;iZ0++){
                        int mQ2=con.Z0[iZ0].Q2a;
                        int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
                        for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
                           ene.U2chi(iU2)= vv.Q2chi(iQ2);
                           ene.U2uca(iU2)= vv.Q2uca(iQ2);
                           iU2++;
                        }
                     }
//
//
// adjust torsions to exact deformation
//
                     loc.MOV0(physics_consts,
                              out,sub,mol,con,dep,ene,
                              mR1, 0, 0);
                     loc.WRT0(out,ene);
                     def.Z2[iZ2].D1[iD1].r= std::sqrt( loc.M4[loc.iM4].Ftot
                                                      /double(12));
                     if( def.Z2[iZ2].D1[iD1].r>(1.00e-2) )continue;
//
//
// replace approximate deformation iD1 with exact deformation
//
                     iU2=0;
                     for(int iZ0= 0;iZ0<oZ0;iZ0++){
                        if( con.Z0[iZ0].sub )iU2+=6;
                     }
                     for(int iZ0= 0;iZ0<oZ0;iZ0++){
                        int mQ2=con.Z0[iZ0].Q2a;
                        int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
                        for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
                           if( con.Q2[iQ2].br==0 ){
                              vv.Q2chi(iQ2)= ene.U2chi(iU2);
                           }
                           iU2++;
                        }
                     }
                     for(int iZ0= 0;iZ0<oZ0;iZ0++){
                        int mQ1=mol.Z0[iZ0].Q1a;
                        int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
                        int mQ2=con.Z0[iZ0].Q2a;
//                      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
                        int iQ2=mQ2;
                        for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
                           if( con.Q1[iQ1].sub ){
                              vv.Q1chi(iQ1)= vv.Q2chi(++iQ2);
                           }
                        }
                     }
                     for(int jX= 0;jX<oX;jX++){
                        int jR1=( mR1 +3*jX);
                        int jQ1bb=sub.R1[jR1  ].Q1bb;
                        int jQ1sc=sub.R1[jR1  ].Q1sc;
                        int jL0=sub.R1[jR1  ].L0;
                        int mQ0=residue_mappings.L0[jL0].Q0a;
                        int nQ0=(mQ0-1+residue_mappings.L0[jL0].cQ0);
                        for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                           bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
                           int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
                           if( BRANCH )continue;
                           std::string tor=mol.Q1[jQ1].tor;
                           if      ( tor=="EPS" ){
                              def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].eps=
                                       vv.Q1chi(jQ1)/physics_consts.RAD;
                           }else if( tor=="ZET" ){
                              def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].zet=
                                       vv.Q1chi(jQ1)/physics_consts.RAD;
                           }else if( tor=="ALP" ){
                              def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].alp=
                                       vv.Q1chi(jQ1)/physics_consts.RAD;
                           }
                        }
                        jQ1bb=sub.R1[jR1+1].Q1bb;
                        jQ1sc=sub.R1[jR1+1].Q1sc;
                        jL0=sub.R1[jR1+1].L0;
                        mQ0=residue_mappings.L0[jL0].Q0a;
                        nQ0=(mQ0-1+residue_mappings.L0[jL0].cQ0);
                        for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                           bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
                           int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
                           if( BRANCH )continue;
                           std::string tor=mol.Q1[jQ1].tor;
                           if      ( tor=="BET" ){
                              def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].bet=
                                       vv.Q1chi(jQ1)/physics_consts.RAD;
                           }else if( tor=="GAM" ){
                              def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].gam=
                                       vv.Q1chi(jQ1)/physics_consts.RAD;
                           }else if( tor=="DEL" ){
                              def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].del=
                                       vv.Q1chi(jQ1)/physics_consts.RAD;
                           }
                        }
                     }
//
//
// calculate suite conformation
//
                     double e= (0.00);
                     int bord=0;
                     for(int jX= 0;jX<oX;jX++){
                        int jR1=( mR1 +3*jX);
                        int jR0=sub.R1[jR1].R0;
                        double eps= def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].eps;
                        double zet= def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].zet;
                        double alp= def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].alp;
                        double bet= def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].bet;
                        double gam= def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].gam;
                        double del= def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].del;
                        double de0=( 146.00);
                        if( jX> 0 ){
                           de0= def.Z2[iZ2].D1[iD1].R1[jR1-2-mR1].del;
                        }else if( (jR0-2)>=mR0 ){
                           int mT1=str.R0[jR0-2].T1a;
                           de0= str.T1[mT1+2].chi;
                        }
                        double rmin= (1.00e+8);
                        int jC6=-1;
                        for(int iC6= 0;iC6<46;iC6++){
                           double d0=( de0 -region_maps.C6[iC6].de0);
                           if      ( d0>=( 180.) ){ d0-=(360.);
                           }else if( d0< (-180.) ){ d0+=(360.);
                           }
                           double d1=( eps -region_maps.C6[iC6].eps);
                           if      ( d1>=( 180.) ){ d1-=(360.);
                           }else if( d1< (-180.) ){ d1+=(360.);
                           }
                           double d2=( zet -region_maps.C6[iC6].zet);
                           if      ( d2>=( 180.) ){ d2-=(360.);
                           }else if( d2< (-180.) ){ d2+=(360.);
                           }
                           double d3=( alp -region_maps.C6[iC6].alp);
                           if      ( d3>=( 180.) ){ d3-=(360.);
                           }else if( d3< (-180.) ){ d3+=(360.);
                           }
                           double d4=( bet -region_maps.C6[iC6].bet);
                           if      ( d4>=( 180.) ){ d4-=(360.);
                           }else if( d4< (-180.) ){ d4+=(360.);
                           }
                           double d5=( gam -region_maps.C6[iC6].gam);
                           if      ( d5>=( 180.) ){ d5-=(360.);
                           }else if( d5< (-180.) ){ d5+=(360.);
                           }
                           double d6=( del -region_maps.C6[iC6].del);
                           if      ( d6>=( 180.) ){ d6-=(360.);
                           }else if( d6< (-180.) ){ d6+=(360.);
                           }
                           double rr=( d0*d0 +d1*d1 +d2*d2 +d3*d3 +d4*d4
                                      +d5*d5 +d6*d6);
                           double r= std::sqrt( rr/(7.00));
                           if( r<rmin ){
                              rmin= r;
                              jC6=iC6;
                           }
                        }
                        def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].cnfb=
                            region_maps.C6[jC6].cnf;
                        e+=(0.50)*rmin*rmin/(256.00);
                        if( rmin>(32.00) )bord++;
                     }
                     def.Z2[iZ2].D1[iD1].p= std::exp( -e/physics_consts.ekT);
                     def.Z2[iZ2].D1[iD1].bord=bord;
                     if( def.Z2[iZ2].D1[iD1].bord>1 )continue;
//
//
//
//
                     iD1++;
                     def.Z2[iZ2].D1.push_back( Backbone_Defs::tZ2::tZ2D1(oR1));

                  }else{
                     iX++;
                  }

               }
            }
            def.Z2[iZ2].nD1=iD1;
            def.Z2[iZ2].D1.pop_back();
//
//
// normalize p
//
            double z= (0.00);
            for(iD1=0;iD1<def.Z2[iZ2].nD1;iD1++){
               z+=def.Z2[iZ2].D1[iD1].p;
            }
            for(iD1=0;iD1<def.Z2[iZ2].nD1;iD1++){
               def.Z2[iZ2].D1[iD1].p/=z;
            }
//
//
// distance d from initial conf
//
            for(iD1=0;iD1<def.Z2[iZ2].nD1;iD1++){
               double rr= (0.00);
               for(int jX= 0;jX<oX;jX++){
                  int jR1=( mR1 +3*jX);
                  double eps= def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].eps;
                  double zet= def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].zet;
                  double alp= def.Z2[iZ2].D1[iD1].R1[jR1  -mR1].alp;
                  double bet= def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].bet;
                  double gam= def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].gam;
                  double del= def.Z2[iZ2].D1[iD1].R1[jR1+1-mR1].del;
                  double d1=( eps -def.Z2[iZ2].R1[jR1  -mR1].eps);
                  if      ( d1>=( 180.) ){ d1-=(360.);
                  }else if( d1< (-180.) ){ d1+=(360.);
                  }
                  double d2=( zet -def.Z2[iZ2].R1[jR1  -mR1].zet);
                  if      ( d2>=( 180.) ){ d2-=(360.);
                  }else if( d2< (-180.) ){ d2+=(360.);
                  }
                  double d3=( alp -def.Z2[iZ2].R1[jR1  -mR1].alp);
                  if      ( d3>=( 180.) ){ d3-=(360.);
                  }else if( d3< (-180.) ){ d3+=(360.);
                  }
                  double d4=( bet -def.Z2[iZ2].R1[jR1+1-mR1].bet);
                  if      ( d4>=( 180.) ){ d4-=(360.);
                  }else if( d4< (-180.) ){ d4+=(360.);
                  }
                  double d5=( gam -def.Z2[iZ2].R1[jR1+1-mR1].gam);
                  if      ( d5>=( 180.) ){ d5-=(360.);
                  }else if( d5< (-180.) ){ d5+=(360.);
                  }
                  double d6=( del -def.Z2[iZ2].R1[jR1+1-mR1].del);
                  if      ( d6>=( 180.) ){ d6-=(360.);
                  }else if( d6< (-180.) ){ d6+=(360.);
                  }
                  rr+=( d1*d1 +d2*d2 +d3*d3 +d4*d4
                       +d5*d5 +d6*d6);
               }
//             def.Z2[iZ2].D1[iD1].d= std::sqrt( rr/double(6*oX));
               def.Z2[iZ2].D1[iD1].d= rr;
            }
//
//
// restore control and starting conf of minimization
//
            loc.EPS1= vv.EPS1;
            loc.BETA= vv.BETA;
            loc.BMIN= vv.BMIN;
            loc.BMAX= vv.BMAX;
            loc.BET1= vv.BET1;
            for(int iU2= 0;iU2<oU2;iU2++){
               ene.U2chi(iU2)= vv.U2chi(iU2);
               ene.U2uca(iU2)= vv.U2uca(iU2);
            }
         }else if( c1=='s' ){
         }

         if( out.SHELL ){
            out.FILE3<< std::fixed;
            out.FILE3<<"BACKBONE DEFORMATIONS, segment="
                     << std::setw( 2)<<iZ2<<'\n';
         }
         int pR1=( nR1-mR1);
         if      ( c1=='a' ){
         }else if( c1=='e' ){
         }else if( c1=='r' ){
         }else if( c1=='b' ){
         }else if( c1=='p' ){
            pR1+=1;
         }else if( c1=='s' ){
         }
         double RRc= ( 2*pR1)*( pR1 +4)*( pR1 +4);
         if( def.Z2[iZ2].CORE )RRc/=(4.00);
         if( out.SHELL ){
            out.FILE3<<"  def"" -kT*ln(p)""  dchi""  ""   cnf0\n";
         }
         for(int iD1= 0;iD1<def.Z2[iZ2].nD1;iD1++){
            double d= def.Z2[iZ2].D1[iD1].d;
            if( def.Z2[iZ2].CORE ){
               d= RRc*std::exp( (2.50)*std::log( (1.00e-8) +(d/RRc)));
            }else{
               d= RRc*std::exp( (1.25)*std::log( (1.00e-8) +(d/RRc)));
            }
            d= std::sqrt( d/double(2*pR1));
            double e= def.Z2[iZ2].D1[iD1].p;
            if      ( c1=='a' ){
            }else if( c1=='e' ){
            }else if( c1=='r' ){
            }else if( c1=='b' ){
            }else if( c1=='p' ){
               e=-physics_consts.ekT*std::log( e);
            }else if( c1=='s' ){
            }
            if( out.SHELL ){
               out.FILE3<< std::setw( 5)<<iD1
                        << std::setprecision( 2)
                        << std::setw( 9)<<e
                        << std::setprecision( 1)
                        << std::setw( 7)<<d<<"  ";
               for(int jR1=mR1;jR1<=nR1;jR1++){
                  int jL0=sub.R1[jR1].L0;
                  char cj=residue_mappings.L0[jL0].c1;
                  if      ( cj=='a' ){
                     out.FILE3<<def.Z2[iZ2].D1[iD1].R1[jR1-mR1].cnfa;
                  }else if( cj=='e' ){
                  }else if( cj=='r' ){
                     out.FILE3<<'|'<<def.Z2[iZ2].D1[iD1].R1[jR1-mR1].cnfb;
                  }else if( cj=='b' ){
                  }else if( cj=='p' ){
                  }else if( cj=='s' ){
                  }
               }
               out.FILE3<<'\n';
            }
         }

         if( def.Z2[iZ2].nD1==0 ){
            SOLUTION=false;
            int jJ3min=(iJ3+1);
            int jJ3max=(def.nJ3-1);
            def.nJ3=iJ3;
            for(int jJ3=jJ3min;jJ3<=jJ3max;jJ3++){
               if( (def.Z2[iZ2].J3[jJ3].shf1==def.Z2[iZ2].J3[iJ3].shf1)&&
                   (def.Z2[iZ2].J3[jJ3].shf2==def.Z2[iZ2].J3[iJ3].shf2) ){
                  cJ3--;
               }else{
                  for(int jZ2= 0;jZ2<oZ2;jZ2++){
                     def.Z2[jZ2].J3[def.nJ3]=def.Z2[jZ2].J3[jJ3];
                  }
                  def.nJ3++;
               }
            }
            jJ3min=def.nJ3;
            for(int jJ3=jJ3min;jJ3<=jJ3max;jJ3++){
               def.Z2[iZ2].J3.pop_back();
            }
         }
      }

      if( SOLUTION ){
         bool ALIGNSHF=false;
         for(int iZ2= 0;iZ2<oZ2;iZ2++){
            if( (def.Z2[iZ2].J3[iJ3].shf1!=0)||
                (def.Z2[iZ2].J3[iJ3].shf2!=0) ){
               ALIGNSHF=true;
               if( def.Z2[iZ2].nD1>4 ){
                  int jD1min= 4;
                  int jD1max=(def.Z2[iZ2].nD1-1);
                  def.Z2[iZ2].nD1= 4;
                  for(int jD1=jD1min;jD1<=jD1max;jD1++){
                     def.Z2[iZ2].D1.pop_back();
                  }
               }
            }
         }
         if( ALIGNSHF ){
            for(int iZ2= 0;iZ2<oZ2;iZ2++){
               if( def.Z2[iZ2].nD1>16 ){
                  int jD1min=16;
                  int jD1max=(def.Z2[iZ2].nD1-1);
                  def.Z2[iZ2].nD1=16;
                  for(int jD1=jD1min;jD1<=jD1max;jD1++){
                     def.Z2[iZ2].D1.pop_back();
                  }
               }
            }
         }
         GLO_BBPCK(aut,
                   physics_consts,array_consts,energy_params,residue_mappings,
                   region_maps,
                   opt,out,str,sub,def,mol,con,dep,ene,loc);
      }

      iJ3++;
   }
//
//
// write collection
//
   if( out.SHELL ){
      out.FILE3<< std::fixed;
      out.FILE3<<"SORTED ORDER\n";
      out.FILE3<<"  iD2  ""   tot   "
                 "    S1 ""    S2 ""    S3 ""    S4 ""    S5 ""  "
                 "   Z2iD1\n";
      for(int iD2= 0;iD2<aut.nD2;iD2++){
         out.FILE3<< std::setw( 5)<<iD2<<"  "
                  << std::fixed<< std::setprecision(2)
                  << std::setw( 8)<<aut.D2[iD2].f[0]<<' '
                  << std::fixed<< std::setprecision(1)
                  << std::setw( 7)<<aut.D2[iD2].f[1]
                  << std::setw( 7)<<aut.D2[iD2].f[2]
                  << std::setw( 7)<<aut.D2[iD2].f[3]
                  << std::setw( 7)<<aut.D2[iD2].f[4]
                  << std::setw( 7)<<aut.D2[iD2].f[5]<<"  ";
         for(int iZ2= 0;iZ2<oZ2;iZ2++){
            out.FILE3<< std::setw( 4)<<aut.D2[iD2].Z2iD1(iZ2);
         }
/**/     out.FILE3<<'\n';
         out.FILE3<<"  cnf1=";
         for(int iZ2= 0;iZ2<oZ2;iZ2++){
            out.FILE3<<'[';
            int mR1=def.Z2[iZ2].CYC;
            int nR1=(mR1-1+sub.R1[mR1].pt);
            for(int iR1=mR1;iR1<=nR1;iR1++){
               int iL0=sub.R1[iR1].L0;
               char c1=residue_mappings.L0[iL0].c1;
               if      ( c1=='a' ){
                  out.FILE3<<aut.D2[iD2].R1[iR1].cnfa;
               }else if( c1=='e' ){
               }else if( c1=='r' ){
                  if( iR1>(mR1+2) ){
                     out.FILE3<<'|';
                  }
                  out.FILE3<<aut.D2[iD2].R1[iR1].cnfa;
               }else if( c1=='b' ){
               }else if( c1=='p' ){
               }else if( c1=='s' ){
               }
            }
            out.FILE3<<']';
         }
         out.FILE3<<'\n';
      }
   }
   return;
}
