#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Thread_Options.hh"
#include <string>

void Glo::GLO_CHI(const Glo_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_RESIDUE_MAPPINGS& residue_mappings,
                  const Thread_Options& opt,
                  const Search_Subspace& sub,
                  const Mechanical_System& mol,
                  const Subset_Contracted_System::tM3& con,
                  Conf_Dependent_System& dep,
                  Energy_Surface4& ene,
                  const Backbone_Defs& def,
                  bool LATTICE){

   if      ( opt.MODE=="bb " ){
      if( LATTICE ){
         for(int iR1= 0;iR1<sub.nR1;iR1++){
            if( (sub.R1[iR1].bb==0)&&(sub.R1[iR1].sc==0) )continue;
            int jQ1bb=sub.R1[iR1].Q1bb;
            int jQ1sc=sub.R1[iR1].Q1sc;
            int iL0=sub.R1[iR1].L0;
            int mQ0=residue_mappings.L0[iL0].Q0a;
            int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
               int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
               if( !con.Q1[jQ1].sub )continue;
               std::string tor=mol.Q1[jQ1].tor;
               int jR1=( tor=="OMG" )? (iR1-1): iR1;
               int mT5=sub.R1[jR1].T5a;
               int nT5=(mT5-1+sub.R1[jR1].cT5);
               for(int iT5=mT5;iT5<=nT5;iT5++){
                  if( sub.T5[iT5].tor==tor ){
                     dep.Q1[jQ1].chi= physics_consts.RAD
                                     *def.D0T5chi( 0,iT5);
                  }
               }
            }
         }
         for(int iZ2= 0;iZ2<def.nZ2;iZ2++){
            int mR1=def.Z2[iZ2].CYC;
            int nR1=(mR1-1+sub.R1[mR1].pt);
            for(int iR1=mR1;iR1<=nR1;iR1++){
               int iL0=sub.R1[iR1].L0;
               char c1=residue_mappings.L0[iL0].c1;
               int jQ1bb=sub.R1[iR1].Q1bb;
               int jQ1sc=sub.R1[iR1].Q1sc;
               int mQ0=residue_mappings.L0[iL0].Q0a;
               int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
               for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                  bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
                  int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
                  if( BRANCH )continue;
                  std::string tor=mol.Q1[jQ1].tor;
                  int pR1=(iR1-mR1);
                  if      ( c1=='a'||
                            c1=='e' ){
                     if( tor=="OMG" )pR1--;
                     if( pR1<0 )continue;
                     if      ( tor=="PHI" ){
                        dep.Q1[jQ1].chi= physics_consts.RAD
                               *def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].R1[pR1].phi;
                     }else if( tor=="PSI" ){
                        dep.Q1[jQ1].chi= physics_consts.RAD
                               *def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].R1[pR1].psi;
                     }else if( tor=="OMG" ){
                        dep.Q1[jQ1].chi= physics_consts.RAD
                               *def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].R1[pR1].omg;
                     }
                  }else if( c1=='r' ){
                     if      ( tor=="BET" ){
                        dep.Q1[jQ1].chi= physics_consts.RAD
                               *def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].R1[pR1].bet;
                     }else if( tor=="GAM" ){
                        dep.Q1[jQ1].chi= physics_consts.RAD
                               *def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].R1[pR1].gam;
                     }else if( tor=="DEL" ){
                        dep.Q1[jQ1].chi= physics_consts.RAD
                               *def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].R1[pR1].del;
                     }
                  }else if( c1=='b' ){
                  }else if( c1=='p' ){
                     if      ( tor=="EPS" ){
                        dep.Q1[jQ1].chi= physics_consts.RAD
                               *def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].R1[pR1].eps;
                     }else if( tor=="ZET" ){
                        dep.Q1[jQ1].chi= physics_consts.RAD
                               *def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].R1[pR1].zet;
                     }else if( tor=="ALP" ){
                        dep.Q1[jQ1].chi= physics_consts.RAD
                               *def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].R1[pR1].alp;
                     }
                  }else if( c1=='s' ){
                  }
               }
            }
            if( def.Z2[iZ2].Z0>=0 ){
               dep.Z0[def.Z2[iZ2].Z0].trans=
                  def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].tr.trans;
               dep.Z0[def.Z2[iZ2].Z0].rot=
                  def.Z2[iZ2].D1[aut.Z2[iZ2].iD1].tr.rot;
            }
         }
      }else{
         int iU2=0;
         for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
            if( con.Z0[iZ0].sub ){
               for(int i=0;i<3;i++){
                  ene.U2chi(iU2)= aut.D2[aut.iD2].U2chi(iU2  +i)
                                 /physics_consts.ANG;
                  ene.U2chi(iU2)= aut.D2[aut.iD2].U2chi(iU2+3+i)
                                 *physics_consts.RAD;
               }
               iU2+=6;
            }
         }
         for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
            int mQ2=con.Z0[iZ0].Q2a;
            int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
            for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
               ene.U2chi(iU2)= aut.D2[aut.iD2].U2chi(iU2)
                              *physics_consts.RAD;
               iU2++;
            }
         }
         return;
      }

   }else if( opt.MODE=="sc " ){
      if( LATTICE ){
         for(int iR1= 0;iR1<sub.nR1;iR1++){
            if( (sub.R1[iR1].bb==0)&&(sub.R1[iR1].sc==0) )continue;
            int jQ1bb=sub.R1[iR1].Q1bb;
            int jQ1sc=sub.R1[iR1].Q1sc;
            int iL0=sub.R1[iR1].L0;
            int mQ0=residue_mappings.L0[iL0].Q0a;
            int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
               int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
               if( !con.Q1[jQ1].sub )continue;
               std::string tor=mol.Q1[jQ1].tor;
               int mT5=sub.R1[iR1].T5a;
               int nT5=(mT5-1+sub.R1[iR1].cT5);
               for(int iT5=mT5;iT5<=nT5;iT5++){
                  if( sub.T5[iT5].tor==tor ){
                     dep.Q1[jQ1].chi= physics_consts.RAD
                                     *def.D0T5chi(def.iD0,iT5);
                  }
               }
            }
         }
         for(int iY3= 0;iY3<aut.oY3;iY3++){
            for(int iQ6= 0;iQ6<aut.Y3[iY3].nQ6;iQ6++){
               dep.Q1[aut.Y3Q6Q1(iY3,iQ6)].chi=
                   physics_consts.RAD
                  *residue_mappings.C2Q6chi(aut.Y3[iY3].iC2,iQ6);
            }
         }
      }else{
         for(int iU2= 0;iU2<ene.nU2;iU2++){
            ene.U2chi(iU2)= physics_consts.RAD
                           *aut.D3[aut.iD3].U2chi(iU2);
         }
         return;
      }

   }else if( opt.MODE=="lp " ){
      for(int iR1= 0;iR1<sub.nR1;iR1++){
         if( (sub.R1[iR1].bb==0)&&(sub.R1[iR1].sc==0) )continue;
         int jQ1bb=sub.R1[iR1].Q1bb;
         int jQ1sc=sub.R1[iR1].Q1sc;
         int iL0=sub.R1[iR1].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
            bool BRANCH=(residue_mappings.Q0[iQ0].br>0);
            int jQ1=( BRANCH )? ++jQ1sc: ++jQ1bb;
            if( !con.Q1[jQ1].sub )continue;
            std::string tor=mol.Q1[jQ1].tor;
            int jR1=( tor=="OMG" )? (iR1-1): iR1;
            int mT5=sub.R1[jR1].T5a;
            int nT5=(mT5-1+sub.R1[jR1].cT5);
            for(int iT5=mT5;iT5<=nT5;iT5++){
               if( sub.T5[iT5].tor==tor ){
                  dep.Q1[jQ1].chi= physics_consts.RAD
                                  *def.D0T5chi(def.iD0,iT5);
               }
            }
         }
      }
      for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
         if( !con.Z0[iZ0].sub )continue;
         dep.Z0[iZ0].trans=def.D0[def.iD0].Z0[iZ0].trans;
         dep.Z0[iZ0].rot=def.D0[def.iD0].Z0[iZ0].rot;
      }

   }

   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ1>mQ1 ){
         int iQ2=mQ2;
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            if( con.Q1[iQ1].sub ){
               dep.Q2[++iQ2].chi= dep.Q1[iQ1].chi;
            }
         }
      }
   }

   int iU2=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      if( con.Z0[iZ0].sub ){
         ene.U2chi(iU2  )= dep.Z0[iZ0].trans(0);
         ene.U2chi(iU2+1)= dep.Z0[iZ0].trans(1);
         ene.U2chi(iU2+2)= dep.Z0[iZ0].trans(2);
         ene.U2chi(iU2+3)= dep.Z0[iZ0].rot(0);
         ene.U2chi(iU2+4)= dep.Z0[iZ0].rot(1);
         ene.U2chi(iU2+5)= dep.Z0[iZ0].rot(2);
         iU2+=6;
      }
   }
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            ene.U2chi(iU2++)= dep.Q2[iQ2].chi;
         }
      }
   }

   return;
}
