#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi1_Automatic.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_glo_bbpck {
private:
   std::vector<double> o_X4f;      //
   int oZ2;                        //
   std::vector<int> o_X4Z2D1;      //
   std::vector<double> o_Z2f;      //
   std::vector<double> o_Z2g;      //
public:
   MEM_glo_bbpck(int oX4,int o):
      o_X4f(oX4, (1.00e+8)),
      oZ2(o),
      o_X4Z2D1(oX4*oZ2,-1),
      o_Z2f(oZ2),
      o_Z2g(oZ2)
   {
   }
   double& X4f(int i){
      return o_X4f.at( i);  }
   int& X4Z2D1(int i,int j){
      return o_X4Z2D1.at( i*oZ2 +j);  }
   double& Z2f(int i){
      return o_Z2f.at( i);  }
   double& Z2g(int i){
      return o_Z2g.at( i);  }
};

void Glo::GLO_BBPCK(Glo_Automatic& aut,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_ARRAY_CONSTS& array_consts,
                    const DAT_ENERGY_PARAMS& energy_params,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    const DAT_REGION_MAPS& region_maps,
                    const Thread_Options& opt,
                    Output_Streams& out,
                    const Structure& str,
                    const Search_Subspace& sub,
                    Backbone_Defs& def,
                    const Mechanical_System& mol,
                    const Subset_Contracted_System::tM3& con,
                    Conf_Dependent_System& dep,
                    Energy_Surface4& ene,
                    Local_Minimization4& loc){
   int oZ0=con.oZ0;
   int oZ2=def.nZ2;
   aut.Z2.resize(oZ2);
   int oE1=con.oE1;
   int oQ2=con.oQ2;
   int oB6=con.oB6;
   int oG6=con.oG6;
   int oX4=4096;
   if( opt.FUNC=="ptra" ){
      oX4=1024;
   }
   MEM_glo_bbpck vv(oX4,oZ2);
   int nX4;
   bool LATTICE=true;
   Phi_Automatic ph2(con);
   ene.RECYCLE=false;
   ene.ethresh= (1.00e-5);
   for(int iE1= 0;iE1<oE1;iE1++){
      ene.E1part(iE1, true);
   }
   if( oZ2> 1 ){
//
//
// resize array infrastructure of lattice search
//
      aut.o_Z2Z2.resize((oZ2*(oZ2-1))/2);
      int o=int( std::sqrt( 65536/((oZ2*(oZ2-1))/2)));
      if( opt.FUNC=="ptra" ){
         o=int( std::sqrt( 8192/((oZ2*(oZ2-1))/2)));
      }
      for(int iZ2= 0;iZ2<oZ2;iZ2++){
         aut.Z2[iZ2].nD1=( def.Z2[iZ2].nD1<o )? def.Z2[iZ2].nD1: o;
         aut.Z2[iZ2].o_D1e.resize(aut.Z2[iZ2].nD1);
      }
      for(int iZ2= 0;iZ2<(oZ2-1);iZ2++){
         for(int jZ2=(iZ2+1);jZ2<oZ2;jZ2++){
            aut.Z2Z2(iZ2,jZ2).oD1=aut.Z2[jZ2].nD1;
            aut.Z2Z2(iZ2,jZ2).o_D1D1e.resize(aut.Z2[iZ2].nD1*aut.Z2[jZ2].nD1);
            aut.Z2Z2(iZ2,jZ2).o_D1z.resize(aut.Z2[iZ2].nD1);
         }
      }
//
//
// lattice 1-body energies
//
      if( out.SHELL ){
         out.FILE3<< std::fixed;
         out.FILE3<<"SEGMENT DEFORMATION LATTICE 1-BODY ENERGY, SCORE= "
                  << std::setprecision( 3)<< std::setw( 5)<<((.50)*aut.w)
                  <<"[restbhw] +SCREEN"<<'\n';
      }

      for(int iZ2= 0;iZ2<oZ2;iZ2++){
         aut.Z2[iZ2].iD1=0;
      }
      for(int iZ2= 0;iZ2<oZ2;iZ2++){
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            int mQ2=con.Z0[iZ0].Q2a;
            int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
            int mE1=con.Z0[iZ0].E1a;
            int iQ2=mQ2;
            int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
               int nE1=(mE1-1+con.Q2[iQ2].cE1);
               if( nE1>=mE1 ){
                  for(int iE1=mE1;iE1<=nE1;iE1++){
                     int jQ2=con.E1[iE1].k;
                     if( ((aut.Q2[iQ2].fZ2==iZ2)&&(aut.Q2[jQ2].bZ2==iZ2))||
                         ((aut.Q2[iQ2].fZ2==iZ2)&&(aut.Q2[jQ2].bZ2== -1))||
                         ((aut.Q2[iQ2].fZ2== -1)&&(aut.Q2[jQ2].bZ2==iZ2)) ){
                        ene.E1pass(iE1,false);
                     }else{
                        ene.E1pass(iE1, true);
                     }
                  }
                  mE1+=con.Q2[iQ2].cE1;
               }
               if( (aut.Q2[iQ2].fZ2==iZ2)||(aut.Q2[iQ2].bZ2==iZ2) ){
                  ene.Q2[iQ2].pass=false;
               }else{
                  ene.Q2[iQ2].pass=true;
               }
               if( con.Q2[iQ2].omg==1 ){
                  int L=iQ2hold;
                  iQ2hold=(iQ2+1);
                  iQ2=L;
               }else{
                  iQ2++;
               }
            }
         }
         for(int iB6= 0;iB6<oB6;iB6++){
            for(int jB6=iB6;jB6<oB6;jB6++){
               ene.setB6B6pass(iB6,jB6,( iZ2==0 )? false: true);
            }
         }
         for(int iB6= 0;iB6<oB6;iB6++){
            for(int iG6= 0;iG6<oG6;iG6++){
               if      ( aut.G6[iG6].Z2== -1 ){
                  ene.setB6G6pass(iB6,iG6,( iZ2==0 )? false: true);
               }else if( aut.G6[iG6].Z2==iZ2 ){
                  ene.setB6G6pass(iB6,iG6,false);
               }else{
                  ene.setB6G6pass(iB6,iG6,true);
               }
            }
         }
         for(int iG6= 0;iG6<oG6;iG6++){
            for(int jG6=iG6;jG6<oG6;jG6++){
               ene.setG6G6pass(iG6,jG6,true);
               if      ( (aut.G6[iG6].Z2== -1)&&(aut.G6[jG6].Z2== -1) ){
                  ene.setG6G6pass(iG6,jG6,( iZ2==0 )? false: true);
               }else if( (aut.G6[iG6].Z2== -1)&&(aut.G6[jG6].Z2==iZ2) ){
                  ene.setG6G6pass(iG6,jG6,false);
               }else if( (aut.G6[iG6].Z2== -1)                        ){
               }else if( (aut.G6[iG6].Z2==iZ2)&&(aut.G6[jG6].Z2== -1) ){
                  ene.setG6G6pass(iG6,jG6,false);
               }else if( (aut.G6[iG6].Z2==iZ2)&&(aut.G6[jG6].Z2==iZ2) ){
                  ene.setG6G6pass(iG6,jG6,false);
               }else if( (aut.G6[iG6].Z2==iZ2)                       ){
               }else if(                        (aut.G6[jG6].Z2== -1) ){
               }else if(                        (aut.G6[jG6].Z2==iZ2) ){
               }else{
               }
            }
         }
         if( out.SHELL ){
            out.FILE3<<" iZ2="<< std::setw( 2)<<iZ2<<'\n';
            out.FILE3<<" iD1 ""  ""    tot   ""  "
                       "     S1 ""     S2 ""     S3 ""     S4 "
                       "     S5 "<<'\n';
         }
         int iL0=sub.R1[def.Z2[iZ2].CYC].L0;
         char c1=residue_mappings.L0[iL0].c1;
         for(int iD1= 0;iD1<aut.Z2[iZ2].nD1;iD1++){
            aut.Z2[iZ2].iD1=iD1;
            GLO_CHI(aut,
                    physics_consts,residue_mappings,
                    opt,sub,mol,con,dep,ene,def,
                    LATTICE);
            ene.QMEDIUM=true;
            ene.QFAC(ph2,
                     physics_consts,
                     out,mol,con,dep);
            ene.PHIG(ph2,
                     physics_consts,array_consts,energy_params,
                     region_maps,
                     opt,out,mol,con,dep);
            ene.Fr*=physics_consts.CAL;
            ene.Fe*=physics_consts.CAL;
            ene.Fs*=physics_consts.CAL;
            ene.Ft*=physics_consts.CAL;
            ene.Fb*=physics_consts.CAL;
            ene.Fh*=physics_consts.CAL;
            ene.Fw*=physics_consts.CAL;
            ene.Fp*=physics_consts.CAL;
            ene.Fp_a*=physics_consts.CAL;
            ene.Fp_b*=physics_consts.CAL;
            ene.Fp_c*=physics_consts.CAL;
            ene.Fp_d*=physics_consts.CAL;
            ene.Fp_e*=physics_consts.CAL;
            ene.Fs1=( ene.Fr +ene.Fe +ene.Ft +ene.Fb +(2.00)*ene.Fh +ene.Fw)
                     +std::sqrt( (ene.Fs/(1.00e+2)) +(1.00e-12))
                     +def.Z2[iZ2].D1[iD1].fg;
            ene.Fs1*=((.50)*aut.w);
            ene.Fs2= (0.00);
            if      ( c1=='a'||
                      c1=='e' ){
               ene.Fs2+=def.Z2[iZ2].D1[iD1].p;
            }else if( c1=='r' ){
            }else if( c1=='b' ){
            }else if( c1=='p' ){
               double p= def.Z2[iZ2].D1[iD1].p;
               ene.Fs2-=physics_consts.ekT*std::log( p);
            }else if( c1=='s' ){
            }
            ene.PHIS(physics_consts,residue_mappings,
                     out,mol,con,dep);
            aut.Z2[iZ2].D1e(iD1)=( ene.Fs1 +ene.Fs2 +ene.Fs3 +ene.Fs4 +ene.Fs5);
            if( out.SHELL ){
               out.FILE3<< std::setw( 5)<<iD1<<"  "
                        << std::scientific<< std::setprecision(3)
                        << std::setw(10)<<aut.Z2[iZ2].D1e(iD1)<<"  "
                        << std::fixed<< std::setprecision(1)
                        << std::setw( 8)<<ene.Fs1
                        << std::setw( 8)<<ene.Fs2
                        << std::setw( 8)<<ene.Fs3
                        << std::setw( 8)<<ene.Fs4
                        << std::setw( 8)<<ene.Fs5<<'\n';
               ene.RECYCLE=true;
            }
         }
         aut.Z2[iZ2].iD1=0;
      }
//
//
// lattice 2-body energies
//
      double z= (1.00)/(oZ2-1);
      if( out.SHELL ){
         out.FILE3<<"SEGMENT DEFORMATION LATTICE 2-BODY ENERGY, SCORE= "
                  << std::setprecision( 3)<< std::setw( 5)<<((.50)*aut.w)
                  <<"[restbhw] +SCREEN"<<'\n';
      }
      for(int iZ2= 0;iZ2<(oZ2-1);iZ2++){
         for(int jZ2=(iZ2+1);jZ2<oZ2;jZ2++){
            for(int iZ0= 0;iZ0<oZ0;iZ0++){
               int mQ2=con.Z0[iZ0].Q2a;
               int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
               int mE1=con.Z0[iZ0].E1a;
               int iQ2=mQ2;
               int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
               for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
                  int nE1=(mE1-1+con.Q2[iQ2].cE1);
                  if( nE1>=mE1 ){
                     for(int iE1=mE1;iE1<=nE1;iE1++){
                        int jQ2=con.E1[iE1].k;
                        if( (aut.Q2[iQ2].fZ2==jZ2)&&(aut.Q2[jQ2].bZ2==iZ2) ){
                           ene.E1pass(iE1,false);
                        }else{
                           ene.E1pass(iE1, true);
                        }
                     }
                     mE1+=con.Q2[iQ2].cE1;
                  }
                  ene.Q2[iQ2].pass=true;
                  if( con.Q2[iQ2].omg==1 ){
                     int L=iQ2hold;
                     iQ2hold=(iQ2+1);
                     iQ2=L;
                  }else{
                     iQ2++;
                  }
               }
            }
            for(int iB6= 0;iB6<oB6;iB6++){
               for(int jB6=iB6;jB6<oB6;jB6++){
                  ene.setB6B6pass(iB6,jB6,true);
               }
            }
            for(int iB6= 0;iB6<oB6;iB6++){
               for(int iG6= 0;iG6<oG6;iG6++){
                  ene.setB6G6pass(iB6,iG6,true);
               }
            }
            for(int iG6= 0;iG6<oG6;iG6++){
               for(int jG6=iG6;jG6<oG6;jG6++){
                  if( (aut.G6[iG6].Z2==iZ2)&&(aut.G6[jG6].Z2==jZ2) ){
                     ene.setG6G6pass(iG6,jG6,false);
                  }else{
                     ene.setG6G6pass(iG6,jG6,true);
                  }
               }
            }
            if( out.SHELL ){
               out.FILE3<<" iZ2="<< std::setw( 2)<<iZ2
                        <<" jZ2="<< std::setw( 2)<<jZ2<<'\n';
               out.FILE3<<" iD1 "" jD1 ""  ""    tot   ""  "
                          "     S1 ""     S2 ""     S3 ""     S4 "
                          "     S5 "<<'\n';
            }
            aut.Z2Z2(iZ2,jZ2).z= (1.00e+8);
            for(int iD1= 0;iD1<aut.Z2[iZ2].nD1;iD1++){
               aut.Z2[iZ2].iD1=iD1;
               aut.Z2Z2(iZ2,jZ2).D1z(iD1)= (1.00e+8);
               for(int jD1= 0;jD1<aut.Z2[jZ2].nD1;jD1++){
                  aut.Z2[jZ2].iD1=jD1;
                  GLO_CHI(aut,
                          physics_consts,residue_mappings,
                          opt,sub,mol,con,dep,ene,def,
                          LATTICE);
                  ene.QMEDIUM=true;
                  ene.QFAC(ph2,
                           physics_consts,
                           out,mol,con,dep);
                  ene.PHIG(ph2,
                           physics_consts,array_consts,energy_params,
                           region_maps,
                           opt,out,mol,con,dep);
                  ene.Fr*=physics_consts.CAL;
                  ene.Fe*=physics_consts.CAL;
                  ene.Fs*=physics_consts.CAL;
                  ene.Ft*=physics_consts.CAL;
                  ene.Fb*=physics_consts.CAL;
                  ene.Fh*=physics_consts.CAL;
                  ene.Fw*=physics_consts.CAL;
                  ene.Fp*=physics_consts.CAL;
                  ene.Fp_a*=physics_consts.CAL;
                  ene.Fp_b*=physics_consts.CAL;
                  ene.Fp_c*=physics_consts.CAL;
                  ene.Fp_d*=physics_consts.CAL;
                  ene.Fp_e*=physics_consts.CAL;
                  ene.Fs1=( ene.Fr +ene.Fe +ene.Ft +ene.Fb +(2.00)*ene.Fh
                           +ene.Fw)
                           +std::sqrt( (ene.Fs/(1.00e+2)) +(1.00e-12));
                  ene.Fs1*=((.50)*aut.w);
//                ene.Fs2= (0.00);
                  ene.PHIS(physics_consts,residue_mappings,
                           out,mol,con,dep);
                  aut.Z2Z2(iZ2,jZ2).D1D1e(iD1,jD1)= z*( aut.Z2[iZ2].D1e(iD1)
                                                       +aut.Z2[jZ2].D1e(jD1))
                          +( ene.Fs1 +ene.Fs3 +ene.Fs4 +ene.Fs5);
                  if( out.SHELL ){
                     out.FILE3<< std::setw( 5)<<iD1
                              << std::setw( 5)<<jD1<<"  "
                              << std::scientific<< std::setprecision(3)
                              << std::setw(10)<<aut.Z2Z2(iZ2,jZ2).D1D1e(iD1,jD1)
                              <<"  "
                              << std::fixed<< std::setprecision(1)
                              << std::setw( 8)<<ene.Fs1
                              << std::setw( 8)<<ene.Fs2
                              << std::setw( 8)<<ene.Fs3
                              << std::setw( 8)<<ene.Fs4
                              << std::setw( 8)<<ene.Fs5<<'\n';
                  }
                  if( aut.Z2Z2(iZ2,jZ2).D1D1e(iD1,jD1)<
                      aut.Z2Z2(iZ2,jZ2).z ){
                     aut.Z2Z2(iZ2,jZ2).z= aut.Z2Z2(iZ2,jZ2).D1D1e(iD1,jD1);
                  }
                  if( aut.Z2Z2(iZ2,jZ2).D1D1e(iD1,jD1)<
                      aut.Z2Z2(iZ2,jZ2).D1z(iD1) ){
                     aut.Z2Z2(iZ2,jZ2).D1z(iD1)=
                         aut.Z2Z2(iZ2,jZ2).D1D1e(iD1,jD1);
                  }
               }
            }
            aut.Z2[iZ2].iD1=0;
            aut.Z2[jZ2].iD1=0;
         }
      }
      ene.RECYCLE=false;
//
//
// combinatorial search
//
      for(int iZ2= 0;iZ2<oZ2;iZ2++){
         aut.Z2[iZ2].iD1=-1;
      }

      double g= (0.00);
      for(int iZ2= 0;iZ2<(oZ2-1);iZ2++){
         for(int jZ2=(iZ2+1);jZ2<oZ2;jZ2++){
            g+=aut.Z2Z2(iZ2,jZ2).z;
         }
      }
      double f= (0.00);

      int iZ2= 0;
      for(;;){
         aut.Z2[iZ2].iD1++;
         if( aut.Z2[iZ2].iD1>=aut.Z2[iZ2].nD1 ){
            if( iZ2== 0 ){
               break;
            }else{
               aut.Z2[iZ2].iD1=-1;
               iZ2--;
               continue;
            }

         }else{
            if( iZ2== 0 ){
               vv.Z2f(iZ2)= f;
               vv.Z2g(iZ2)= g;
            }else{
               vv.Z2f(iZ2)= vv.Z2f(iZ2-1);
               vv.Z2g(iZ2)= vv.Z2g(iZ2-1);
            }
            for(int jZ2= 0;jZ2<iZ2;jZ2++){
               vv.Z2f(iZ2)+=aut.Z2Z2(jZ2,iZ2).D1D1e(aut.Z2[jZ2].iD1,
                                                     aut.Z2[iZ2].iD1);
               vv.Z2g(iZ2)-=aut.Z2Z2(jZ2,iZ2).D1z(aut.Z2[jZ2].iD1);
            }
            for(int jZ2=(iZ2+1);jZ2<oZ2;jZ2++){
               vv.Z2g(iZ2)-=aut.Z2Z2(iZ2,jZ2).z;
               vv.Z2g(iZ2)+=aut.Z2Z2(iZ2,jZ2).D1z(aut.Z2[iZ2].iD1);
            }
            if( (vv.Z2f(iZ2)+vv.Z2g(iZ2))>=vv.X4f(oX4-1) )continue;
            if( iZ2==(oZ2-1) ){
               vv.X4f(oX4-1)= vv.Z2f(iZ2);
               for(int jZ2= 0;jZ2<oZ2;jZ2++){
                  vv.X4Z2D1(oX4-1,jZ2)=aut.Z2[jZ2].iD1;
               }
               for(int iX4=(oX4-1);iX4>0;iX4--){
                  if( vv.X4f(iX4)>=vv.X4f(iX4-1) )break;
                  double f= vv.X4f(iX4-1);
                  vv.X4f(iX4-1)= vv.X4f(iX4);
                  vv.X4f(iX4)= f;
                  for(int jZ2= 0;jZ2<oZ2;jZ2++){
                     int j=vv.X4Z2D1(iX4-1,jZ2);
                     vv.X4Z2D1(iX4-1,jZ2)=vv.X4Z2D1(iX4  ,jZ2);
                     vv.X4Z2D1(iX4  ,jZ2)=j;
                  }
               }
            }else{
               iZ2++;
            }

         }
      }

      nX4=oX4;
      while( vv.X4f(nX4-1)>=(1.00e+8) ){
         nX4--;
         if( nX4==0 )break;
      }

      if( out.SHELL ){
         out.FILE3<<"LATTICE SEARCH OF COMBINED DEFORMATIONS\n";
         out.FILE3<<"  iX4""  ""   X4f  ""  ""  X4Z2D1\n";
         out.FILE3<< std::fixed<< std::setprecision(1);
         for(int iX4= 0;iX4<nX4;iX4++){
            out.FILE3<< std::setw( 5)<<iX4<<"  "
                     << std::setw( 8)<<vv.X4f(iX4)<<"  ";
            for(int iZ2= 0;iZ2<oZ2;iZ2++){
               out.FILE3<< std::setw( 4)<<vv.X4Z2D1(iX4  ,iZ2);
            }
            out.FILE3<<'\n';
         }
      }

   }else{
      nX4= 0;
      for(int iD1= 0;iD1<def.Z2[ 0].nD1&&(nX4<oX4);iD1++){
         vv.X4Z2D1(nX4++, 0)=iD1;
      }

   }
//
//
// off lattice backbone overlap removal
//
   if( out.SHELL ){
      out.FILE3<< std::fixed<< std::setprecision( 3);
      out.FILE3<<"BACKBONE OVERLAP REMOVAL, SCORE= "
               << std::setw( 5)<<aut.w
               <<"[restbhw] +SCREEN"<<'\n';
   }
   Phi1_Automatic ph1(con);
   ene.RECYCLE=false;
   ene.ethresh= (1.00e-5);
   for(int iE1= 0;iE1<oE1;iE1++){
      ene.E1pass(iE1,false);
   }
   for(int iQ2= 0;iQ2<oQ2;iQ2++){
      ene.Q2[iQ2].pass=false;
   }
   for(int iB6= 0;iB6<oB6;iB6++){
      for(int jB6=iB6;jB6<oB6;jB6++){
         ene.setB6B6pass(iB6,jB6,false);
      }
   }
   for(int iB6= 0;iB6<oB6;iB6++){
      for(int iG6= 0;iG6<oG6;iG6++){
         ene.setB6G6pass(iB6,iG6,false);
      }
   }
   for(int iG6= 0;iG6<oG6;iG6++){
      for(int jG6=iG6;jG6<oG6;jG6++){
         ene.setG6G6pass(iG6,jG6,false);
      }
   }

   int oD2=(aut.D2.size()/2);
   if( out.SHELL ){
      out.FILE3<<"  iD2  ""   tot   ""nE3  "
                 "    S1 ""    S2 ""    S3 ""    S4 ""    S5 ""  "
                 "   Z2iD1\n";
   }
   int nE3min=32;
   int nTER=((nX4+(oD2-1))/oD2);
   for(int iTER= 0;iTER<nTER;iTER++){
      aut.iD2=(oD2-1);
      int iX4min=(oD2*iTER);
      int iX4max=(oD2*(iTER+1)-1);
      if( iX4max>(nX4-1) )iX4max=(nX4-1);
      for(int iX4=iX4min;iX4<=iX4max;iX4++){
         aut.iD2++;
         for(int iZ2= 0;iZ2<oZ2;iZ2++){
            aut.Z2[iZ2].iD1=vv.X4Z2D1(iX4  ,iZ2);
            aut.D2[aut.iD2].Z2iD1(iZ2)=aut.Z2[iZ2].iD1;
         }
         GLO_CHI(aut,
                 physics_consts,residue_mappings,
                 opt,sub,mol,con,dep,ene,def,
                 LATTICE);
         loc.MOV1(ph1,ph2,
                  physics_consts,array_consts,energy_params,
                  opt,out,sub,mol,con,dep,ene);
         loc.WRT1(opt,out,mol,con,dep,ene);
//       out.FILE3<<"MOV1 COMPLETED\n";
         GLO_WRT(aut,
                 physics_consts,residue_mappings,region_maps,
                 opt,sub,mol,con,dep,ene,def);
         if( loc.M4[loc.iM4].nE3<nE3min )nE3min=loc.M4[loc.iM4].nE3;
//       if( (aut.D2[aut.iD2].star>2)||(aut.D2[aut.iD2].bord>3) ){
//          aut.iD2--;
//          continue;
//       }
         if( loc.M4[loc.iM4].nE3>(nE3min+3) ){
            aut.iD2--;
            continue;
         }
         ene.RECYCLE=false;
         ene.QMEDIUM=true;
         ene.QFAC(ph2,
                  physics_consts,
                  out,mol,con,dep);
         ene.PHIG(ph2,
                  physics_consts,array_consts,energy_params,
                  region_maps,
                  opt,out,mol,con,dep);
         ene.Fr*=physics_consts.CAL;
         ene.Fe*=physics_consts.CAL;
         ene.Fs*=physics_consts.CAL;
         ene.Ft*=physics_consts.CAL;
         ene.Fb*=physics_consts.CAL;
         ene.Fh*=physics_consts.CAL;
         ene.Fw*=physics_consts.CAL;
         ene.Fp*=physics_consts.CAL;
         ene.Fp_a*=physics_consts.CAL;
         ene.Fp_b*=physics_consts.CAL;
         ene.Fp_c*=physics_consts.CAL;
         ene.Fp_d*=physics_consts.CAL;
         ene.Fp_e*=physics_consts.CAL;
//       out.FILE3<<"PHIE COMPLETED\n";
         ene.Fs1=( ene.Fr +ene.Fe +ene.Ft +ene.Fb +(2.00)*ene.Fh +ene.Fw)
                  +std::sqrt( (ene.Fs/(1.00e+2)) +(1.00e-12))
                  +ene.Fg +ene.Fp;
         ene.Fs1*=aut.w;
         ene.PHIS(physics_consts,residue_mappings,
                  out,mol,con,dep);
         aut.D2[aut.iD2].f[0]=( ene.Fs1 +ene.Fs2 +ene.Fs3 +ene.Fs4 +ene.Fs5);
         aut.D2[aut.iD2].f[1]= ene.Fs1;
         aut.D2[aut.iD2].f[2]= ene.Fs2;
         aut.D2[aut.iD2].f[3]= ene.Fs3;
         aut.D2[aut.iD2].f[4]= ene.Fs4;
         aut.D2[aut.iD2].f[5]= ene.Fs5;
         if( out.SHELL ){
            out.FILE3<< std::setw( 5)<<aut.iD2<<"  "
                     << std::fixed<< std::setprecision(1)
                     << std::setw( 8)<<aut.D2[aut.iD2].f[0]<<' '
                     << std::setw( 3)<<loc.M4[loc.iM4].nE3<<"  "
                     << std::fixed<< std::setprecision(1)
                     << std::setw( 7)<<ene.Fs1
                     << std::setw( 7)<<ene.Fs2
                     << std::setw( 7)<<ene.Fs3
                     << std::setw( 7)<<ene.Fs4
                     << std::setw( 7)<<ene.Fs5<<"  ";
            for(int iZ2= 0;iZ2<oZ2;iZ2++){
               out.FILE3<< std::setw( 4)<<aut.D2[aut.iD2].Z2iD1(iZ2);
            }
            out.FILE3<<'\n';
            out.FILE3<<"  cnf1=";
            for(int iZ2= 0;iZ2<oZ2;iZ2++){
               out.FILE3<<'[';
               int mR1=def.Z2[iZ2].CYC;
               int nR1=(mR1-1+sub.R1[mR1].pt);
               for(int iR1=mR1;iR1<=nR1;iR1++){
                  int iL0=sub.R1[iR1].L0;
                  char c1=residue_mappings.L0[iL0].c1;
                  if      ( c1=='a' ){
                     out.FILE3<<aut.D2[aut.iD2].R1[iR1].cnfa;
                  }else if( c1=='e' ){
                  }else if( c1=='r' ){
                     if( iR1>(mR1+2) ){
                        out.FILE3<<'|';
                     }
                     out.FILE3<<aut.D2[aut.iD2].R1[iR1].cnfa;
                  }else if( c1=='b' ){
                  }else if( c1=='p' ){
                  }else if( c1=='s' ){
                  }
               }
               out.FILE3<<']';
            }
            out.FILE3<<'\n';
            out.FILE3<<"  cnf0=";
            for(int iZ2= 0;iZ2<oZ2;iZ2++){
               out.FILE3<<'[';
               int iD1=aut.D2[aut.iD2].Z2iD1(iZ2);
               int mR1=def.Z2[iZ2].CYC;
               int nR1=(mR1-1+sub.R1[mR1].pt);
               for(int iR1=mR1;iR1<=nR1;iR1++){
                  int iL0=sub.R1[iR1].L0;
                  char c1=residue_mappings.L0[iL0].c1;
                  if      ( c1=='a' ){
                     out.FILE3<<def.Z2[iZ2].D1[iD1].R1[iR1-mR1].cnfa;
                  }else if( c1=='e' ){
                  }else if( c1=='r' ){
                     if( iR1>(mR1+2) ){
                        out.FILE3<<'|';
                     }
                     out.FILE3<<def.Z2[iZ2].D1[iD1].R1[iR1-mR1].cnfb;
                  }else if( c1=='b' ){
                  }else if( c1=='p' ){
                  }else if( c1=='s' ){
                  }
               }
               out.FILE3<<']';
            }
            out.FILE3<<'\n';
         }
      }
      aut.nD2=(aut.iD2+1);
      aut.CLUSTER(opt.MODE,ene.nU2);
      aut.ORDER(opt.MODE);
      aut.INSERT(opt.MODE);
   }
   aut.CLUSTER(opt.MODE,ene.nU2);

   return;
}
