#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include <string>

void Glo::GLO_A5(Glo_Automatic& aut,
                 Dielec_Continu& med,
                 const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_ARRAY_CONSTS& array_consts,
                 const DAT_ENERGY_PARAMS& energy_params,
                 const Mechanical_System& mol,
                 const Subset_Contracted_System::tM3& con,
                 Conf_Dependent_System& dep){
   med.probe= energy_params.Rprobe;

   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mF2=con.Z0[iZ0].F2a;
      int nF2=(mF2-1+con.Z0[iZ0].cF2);
      for(int iF2=mF2;iF2<=nF2;iF2++){
         dep.F2[iF2].bur=false;
      }
   }

   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

      med.nA5=0;
      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int iT2=con.F2[iF2].typ;
         if( (iT2== 7)||(iT2>17) )continue;
         med.A5[med.nA5].x= dep.F2[iF2].x;
         med.A5[med.nA5].r= energy_params.T2[iT2].Rsph;
         int iR0=con.F2[iF2].R0;
         char c1=mol.R0[iR0].c1;
         std::string aa=mol.R0[iR0].aa;
         std::string atm=con.F2[iF2].atm;
         med.A5[med.nA5].MED_MOL_CHG(physics_consts,c1,aa,atm);
         med.nA5++;
      }
      med.MED_BURIED();
      int iA5=0;
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int iT2=con.F2[iF2].typ;
         if( (iT2== 7)||(iT2>17) )continue;
         dep.F2[iF2].bur=med.A5[iA5++].bur;
      }

      if( nQ2>mQ2 ){
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            med.nA5=0;
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               int iT2=con.F2[iF2].typ;
               if( (iT2== 7)||(iT2>17) )continue;
               med.A5[med.nA5].x= dep.F2[iF2].x;
               med.A5[med.nA5].r= energy_params.T2[iT2].Rsph;
               int iR0=con.F2[iF2].R0;
               char c1=mol.R0[iR0].c1;
               std::string aa=mol.R0[iR0].aa;
               std::string atm=con.F2[iF2].atm;
               med.A5[med.nA5].MED_MOL_CHG(physics_consts,c1,aa,atm);
               med.nA5++;
            }
            if( med.nA5> 0 ){
               med.MED_BURIED();
               int iA5=0;
               for(int iG3=mG3;iG3<=nG3;iG3++){
                  int iF2=con.G3[iG3].F2;
                  int iT2=con.F2[iF2].typ;
                  if( (iT2== 7)||(iT2>17) )continue;
                  dep.F2[iF2].bur=med.A5[iA5++].bur;
               }
            }
         }
      }

   }
   return;
}
