#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Family.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../glo/Glo.hh"
#include "../glo/Glo_Automatic.hh"
#include "../glo/Ising_Model.hh"
#include "../med/Dielec_Continu.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <iostream>
#include <iomanip>
#include <cmath>

void Glo::GLO(const DAT_PHYSICS_CONSTS& physics_consts,
              const DAT_ARRAY_CONSTS& array_consts,
              const DAT_DISULFIDE_LINKS& disulfide_links,
              const DAT_ENERGY_PARAMS& energy_params,
              const DAT_RESIDUE_MAPPINGS& residue_mappings,
              const DAT_REGION_MAPS& region_maps,
              const DAT_DEFORM_PARAMS& deform_params,
              Thread_Options& opt,
              Output_Streams& out,
              Structure& str,
              Search_Subspace& sub,
              Family& fam,
              const Distance_Constraints& dst){

   opt.Rcut= (256.00);
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   int oQ1=oZ0;
   int oU1=0;
   int oF1=0;
   int oB1=0;
   int oG1=0;
   int oH1=0;
   int oJ1=0;
   int oY1=0;
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL0=str.R0[iR0].L0;
      oQ1+=residue_mappings.L0[iL0].cQ0;
      oU1+=residue_mappings.L0[iL0].cU0;
      oF1+=residue_mappings.L0[iL0].cF0;
      oB1+=residue_mappings.L0[iL0].cB0;
      oG1+=residue_mappings.L0[iL0].cG0;
      oH1+=residue_mappings.L0[iL0].cH0;
      oJ1+=residue_mappings.L0[iL0].cJ0;
      oY1+=residue_mappings.L0[iL0].cY0;
   }
   int oR1=sub.nR1;
   bool LATTICE=false;
   Backbone_Defs def(physics_consts,residue_mappings,deform_params,
                     str,sub);
   int oZ2=def.nZ2;

//______________________________________________________________________________
   if( oZ2>0 ){
      if( out.SHELL ){
         std::cout<<"BACKBONE MINIMIZATIONS"
                  << std::endl;
      }
//
//
// backbone search
//
      opt.MODE="bb ";
      if( out.SHELL ){
         out.FILE3<<"CONSTRUCT MECHANICAL SYSTEM"<< std::endl;
      }
      Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
      Subset_Contracted_System col(disulfide_links,residue_mappings,
                                   opt,str,sub);
      Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
      mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
              opt,str,out,dst,col,dep);
      mol.CON(physics_consts,array_consts,energy_params,
              region_maps,
              opt,out,col,dep);
      sub.MECHSYS(residue_mappings,mol);

      const Subset_Contracted_System::tM3& con=col.M3[ 0];
      int oQ2=con.oQ2;
      int oD2=2048;
      if( opt.FUNC=="ptra" ){
         oD2=512;
      }
      int oU2=(con.oU2+6);
      int oB6=con.oB6;
      int oG6=con.oG6;
      int oD3=0;
      Glo_Automatic aut(oZ0,oQ1,oF1,oQ2,oD2,oR1,oZ2,oU2-6,oG6,oD3);
      int oF2=con.oF2;
      int oA5=con.oA5;
      Dielec_Continu med(oQ2,oF2,oA5,oR0);
      {
         med.bse_nA5=0;
      }
      int oE1=con.oE1;
      Energy_Surface4 ene(oZ0,oR0,oQ2,oF2,oE1,oB6,oG6,oU2);
      {
// hydrogen bond constraints
         ene.HBC=0;
      }
      int oM3=col.nM3;
      int oM2=2048;
      int oM4= 128;
      Local_Minimization4 loc(oM4,oM2,oM3);

      GLO_Q2(aut,
             array_consts,energy_params,
             opt,mol,con,dep,ene);
      GLO_U2(aut,
             physics_consts,residue_mappings,
             opt,def,sub,mol,con,dep,ene,loc);
      GLO_F2(aut,mol,con,dep);
      GLO_A5(aut,med,
             physics_consts,array_consts,energy_params,
             mol,con,dep);

      double wbb=( aut.LARGE_SUBSPACE )? (0.50): (0.50);
      int nD0_bb=( aut.LARGE_SUBSPACE )? 32*opt.nD0_final: 8*opt.nD0_final;

      aut.w= wbb;
      def.SHF(physics_consts,residue_mappings,
              out,sub,mol,con,dep,ene);
      GLO_DEF(aut,
              physics_consts,array_consts,energy_params,residue_mappings,
              region_maps,deform_params,
              opt,out,def,str,sub,mol,con,dep,ene,loc);

      Phi_Automatic ph2(con);
      for(int iTER=0;iTER<2;iTER++){
         int cD2,cM2;
         if( iTER==0 ){
            cD2=( def.CORE )?  8: nD0_bb;
            cM2=400;
         }else{
            cD2=( def.CORE )?  4: nD0_bb/4;
            cM2=800;
         }
         aut.nD2=( aut.nD2<=cD2 )? aut.nD2: cD2;
         aut.w+=(.25);
         if( out.SHELL ){
            out.FILE3<< std::fixed<< std::setprecision( 3);
            out.FILE3<<"BACKBONE LOCAL ENERGY MINIMIZATION,"
                     << std::setw( 3)<<cM2
                     <<" STEPS, SCORE= "
                     << std::setw( 4)<<aut.w
                     <<"[restbchm] +SCREEN"<<'\n';
         }

         out.VERBOSE=false;
         for(aut.iD2= 0;aut.iD2<aut.nD2;aut.iD2++){
            if( out.SHELL ){
               out.FILE3<<" iD2="<< std::setw( 5)<<aut.iD2<<" Z2iD1=";
               for(int iZ2= 0;iZ2<oZ2;iZ2++){
                  out.FILE3<< std::setw( 4)<<aut.D2[aut.iD2].Z2iD1(iZ2);
               }
               out.FILE3<<'\n';
            }
            GLO_CHI(aut,
                    physics_consts,residue_mappings,
                    opt,sub,mol,con,dep,ene,def,
                    LATTICE);
            loc.nM2=cM2;
            loc.BETA= loc.BET2;
            ene.RECYCLE=false;
            ene.QMEDIUM=true;
            ene.QFAC(ph2,
                     physics_consts,
                     out,mol,con,dep);
            loc.MOV(ph2,
                    physics_consts,array_consts,energy_params,
                    region_maps,
                    opt,out,mol,con,dep,ene);
            loc.WRT(physics_consts,residue_mappings,
                    opt,out,str,mol,con,dep,ene);
//          std::cout<<"MOV2 COMPLETED"<< std::endl;
            GLO_WRT(aut,
                    physics_consts,residue_mappings,region_maps,
                    opt,sub,mol,con,dep,ene,def);

            ene.RECYCLE=false;
            ene.ethresh= (1.00e-5);
            ene.QMEDIUM=false;
            ene.QFAC(ph2,
                     physics_consts,
                     out,mol,con,dep);
            ene.PHIG(ph2,
                     physics_consts,array_consts,energy_params,
                     region_maps,
                     opt,out,mol,con,dep);
//          std::cout<<"PHIE COMPLETED"<< std::endl;
            ene.Fr*=physics_consts.CAL;
            ene.Fe*=physics_consts.CAL;
            ene.Fs*=physics_consts.CAL;
            ene.Ft*=physics_consts.CAL;
            ene.Fc*=physics_consts.CAL;
            ene.Fb*=physics_consts.CAL;
            ene.Fh*=physics_consts.CAL;
            ene.Fw*=physics_consts.CAL;         //here Fw is zero
            ene.Fp*=physics_consts.CAL;
            ene.Fp_a*=physics_consts.CAL;
            ene.Fp_b*=physics_consts.CAL;
            ene.Fp_c*=physics_consts.CAL;
            ene.Fp_d*=physics_consts.CAL;
            ene.Fp_e*=physics_consts.CAL;
            ene.MED(ph2,med,
                    physics_consts,array_consts,energy_params,
                    opt,out,str,mol,con,dep);
//          std::cout<<"MED COMPLETED"<< std::endl;
            ene.Fm=( energy_params.fac_ps*med.Fps
                    +energy_params.fac_ss*med.Fss
                    +energy_params.fac_qd*med.Fqd
                    +energy_params.fac_uh*med.Fuh
                    +energy_params.fac_cc*med.Fcc);
            med.Fps*=physics_consts.CAL;
            med.Fss*=physics_consts.CAL;
            ene.Fm*=physics_consts.CAL;
            ene.Fs1=( ene.Fr +ene.Fe +ene.Ft +ene.Fc +ene.Fb +ene.Fh
                     +ene.Fm +ene.Fg +ene.Fp);
            if( iTER==0 ){
               ene.Fs1+=std::sqrt( (ene.Fs/(1.00e+2)) +(1.00e-12));
            }else{
               ene.Fs1+=ene.Fs;
            }
            ene.Fs1*=aut.w;
            ene.PHIS(physics_consts,residue_mappings,
                     out,mol,con,dep);
//          std::cout<<"PHIS COMPLETED"<< std::endl;
            ene.Fs2*=(.50);
            ene.Fs3*=(.50);
            ene.Fs4*=(.50);
            ene.Fs5*=(.50);
            aut.D2[aut.iD2].f[0]=( ene.Fs1 +ene.Fs2 +ene.Fs3 +ene.Fs4
                                  +ene.Fs5);
            aut.D2[aut.iD2].f[1]= ene.Fs1;
            aut.D2[aut.iD2].f[2]= ene.Fs2;
            aut.D2[aut.iD2].f[3]= ene.Fs3;
            aut.D2[aut.iD2].f[4]= ene.Fs4;
            aut.D2[aut.iD2].f[5]= ene.Fs5;
            if( out.SHELL ){
               out.FILE3<< std::scientific<< std::setprecision(4);
               int n=loc.iM2;
               double z= std::sqrt( loc.M2[n].z/ene.nU2);
               out.FILE3<<" steps taken="
                        << std::setw( 3)<<n
                        <<" rms of gradient="
                        << std::setw(11)<<z<<'\n';
               out.FILE3<< std::fixed<< std::setprecision(1);
               out.FILE3<<"   S   ""   S1  ""   S2  ""   S3  ""   S4  "
                          "   S5  "<<'\n';
               out.FILE3<< std::setw( 7)<<aut.D2[aut.iD2].f[0]
                        << std::setw( 7)<<aut.D2[aut.iD2].f[1]
                        << std::setw( 7)<<aut.D2[aut.iD2].f[2]
                        << std::setw( 7)<<aut.D2[aut.iD2].f[3]
                        << std::setw( 7)<<aut.D2[aut.iD2].f[4]
                        << std::setw( 7)<<aut.D2[aut.iD2].f[5]<<'\n';
               out.FILE3<<"   Fr  ""   Fe  ""   Fs  ""   Ft  ""   Fc  "
                          "   Fb  ""   Fh  ""   Fm  ""   Fg  ""   Fp  "<<'\n';
               out.FILE3<< std::setw( 7)<<ene.Fr
                        << std::setw( 7)<<ene.Fe
                        << std::setw( 7)<<ene.Fs
                        << std::setw( 7)<<ene.Ft
                        << std::setw( 7)<<ene.Fc
                        << std::setw( 7)<<ene.Fb
                        << std::setw( 7)<<ene.Fh
                        << std::setw( 7)<<ene.Fm
                        << std::setw( 7)<<ene.Fg
                        << std::setw( 7)<<ene.Fp<<'\n';
               out.FILE3<<"  cnf2=";
               for(int iZ2= 0;iZ2<oZ2;iZ2++){
                  out.FILE3<<'[';
                  int mR1=def.Z2[iZ2].CYC;
                  int nR1=(mR1-1+sub.R1[mR1].pt);
                  for(int iR1=mR1;iR1<=nR1;iR1++){
                     int iL0=sub.R1[iR1].L0;
                     char c1=residue_mappings.L0[iL0].c1;
                     if      ( c1=='a' ){
                        out.FILE3<<aut.D2[aut.iD2].R1[iR1].cnfa;
                     }else if( c1=='e' ){
                     }else if( c1=='r' ){
                        if( iR1>(mR1+2) ){
                           out.FILE3<<'|';
                        }
                        out.FILE3<<aut.D2[aut.iD2].R1[iR1].cnfa;
                     }else if( c1=='b' ){
                     }else if( c1=='p' ){
                     }else if( c1=='s' ){
                     }
                  }
                  out.FILE3<<']';
               }
               out.FILE3<<'\n';
               out.FILE3<<"  cnf0=";
               for(int iZ2= 0;iZ2<oZ2;iZ2++){
                  out.FILE3<<'[';
                  int iD1=aut.D2[aut.iD2].Z2iD1(iZ2);
                  int mR1=def.Z2[iZ2].CYC;
                  int nR1=(mR1-1+sub.R1[mR1].pt);
                  for(int iR1=mR1;iR1<=nR1;iR1++){
                     int iL0=sub.R1[iR1].L0;
                     char c1=residue_mappings.L0[iL0].c1;
                     if      ( c1=='a' ){
                        out.FILE3<<def.Z2[iZ2].D1[iD1].R1[iR1-mR1].cnfa;
                     }else if( c1=='e' ){
                     }else if( c1=='r' ){
                        if( iR1>(mR1+2) ){
                           out.FILE3<<'|';
                        }
                        out.FILE3<<def.Z2[iZ2].D1[iD1].R1[iR1-mR1].cnfb;
                     }else if( c1=='b' ){
                     }else if( c1=='p' ){
                     }else if( c1=='s' ){
                     }
                  }
                  out.FILE3<<']';
               }
               out.FILE3<<'\n';
            }
         }
         out.VERBOSE=true;
         aut.CLUSTER(opt.MODE,ene.nU2);
         aut.ORDER(opt.MODE);
      }
      if( aut.nD2>(opt.nD0_final-1) )aut.nD2=(opt.nD0_final-1);

      GLO_STEP(aut,
               physics_consts,residue_mappings,region_maps,
               opt,out,str,sub,mol,con,dep,def);
   }
//______________________________________________________________________________
   {
      if( out.SHELL ){
         std::cout<<"SIDE CHAIN MINIMIZATIONS"
                  << std::endl;
      }
//
//
// side chain global energy minimization
//
      opt.MODE="sc ";
      if( out.SHELL ){
         out.FILE3<<"SIDE CHAIN GLOBAL ENERGY MINIMIZATION,"
                    " SCORE= [resthm]"<< std::endl;
      }
      for(def.iD0=( oZ2>0 )? 1: 0;def.iD0<def.nD0;def.iD0++){
         if( out.VERBOSE&& out.SHELL ){
            out.FILE3<<" iD0="<< std::setw( 4)<<def.iD0<<'\n';
         }
         GLO_DEF2STR(physics_consts,residue_mappings,
                     out,str,sub,def);

         if( out.SHELL ){
            out.FILE3<<"CONSTRUCT MECHANICAL SYSTEM"<< std::endl;
         }
         Subset_Contracted_System col(disulfide_links,residue_mappings,
                                      opt,str,sub);
         if( col.nM3>0 ){
            Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
            Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
            mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
                    opt,str,out,dst,col,dep);
            mol.CON(physics_consts,array_consts,energy_params,
                    region_maps,
                    opt,out,col,dep);
            sub.MECHSYS(residue_mappings,mol);

            int oM3=col.nM3;
            int oM2=2048;
            int oM4= 128;
            Local_Minimization4 loc(oM4,oM2,oM3);

            int oD2=0;
            int oD3=8192;
            if( opt.FUNC=="ptra" ){
               oD3=1024;
            }
            def.TEMP= physics_consts.ekT;

            for(loc.iM3= 0;loc.iM3<oM3;loc.iM3++){
               if( out.VERBOSE&& out.SHELL ){
                  out.FILE3<<" side chain packing unit="
                           << std::setw( 2)<<loc.iM3<<'\n';
               }
               const Subset_Contracted_System::tM3& con=col.M3[loc.iM3];
               int oQ2=con.oQ2;
               int oF2=con.oF2;
               int oE1=con.oE1;
               int oU2=con.oU2;
               int oB6=con.oB6;
               int oG6=con.oG6;
               int oA5=con.oA5;
               Energy_Surface4 ene(oZ0,oR0,oQ2,oF2,oE1,oB6,oG6,oU2+ 6);
//hydrogen bond constraints
               ene.HBC=0;
               Glo_Automatic aut(oZ0,oQ1,oF1,oQ2,oD2,oR1,oZ2,oU2,oG6,oD3);
               Dielec_Continu med(oQ2,oF2,oA5,oR0);
               med.bse_nA5=0;

               if( out.VERBOSE&& out.SHELL ){
                  for(int iY3= 0;iY3<con.nY3;iY3++){
                     int iR1=con.Y3R1(iY3);
                     int iZ0=sub.R1[iR1].Z0;
                     int iR0=(sub.R1[iR1].R0-mol.Z0[iZ0].R0a);
                     out.FILE3<<'['<< std::setw( 2)<<(iZ0+1)
                              <<':'<< std::setw( 4)<<(iR0+1)<<"] "
                              <<sub.R1[iR1].aa<<'\n';
                  }
               }

               GLO_Q2(aut,
                      array_consts,energy_params,
                      opt,mol,con,dep,ene);
               GLO_U2(aut,
                      physics_consts,residue_mappings,
                      opt,def,sub,mol,con,dep,ene,loc);
               GLO_F2(aut,mol,con,dep);
               GLO_A5(aut,med,
                      physics_consts,array_consts,energy_params,
                      mol,con,dep);
               out.VERBOSE=false;
               GLO_SCPCK(aut,
                         physics_consts,array_consts,energy_params,
                         residue_mappings,region_maps,
                         opt,out,str,sub,def,mol,con,dep,ene,loc);
               out.VERBOSE=true;
               if( aut.CLASH ){
                  if( out.SHELL ){
                     out.FILE3<<"Multiple clashes"
                                " following side chain global search."
                                " packing unit iM3="
                              << std::setw( 2)<<loc.iM3<<'\n';
                  }
                  break;
               }

               Phi_Automatic ph2(con);
               out.VERBOSE=false;
               if( opt.FUNC=="ptra" ){
                  if( aut.nD3> 8 )aut.nD3= 8;
               }
               for(aut.iD3= 0;aut.iD3<aut.nD3;aut.iD3++){
                  GLO_CHI(aut,
                          physics_consts,residue_mappings,
                          opt,sub,mol,con,dep,ene,def,
                          LATTICE);
                  loc.nM2=256;
                  loc.BETA= loc.BET2;
                  ene.RECYCLE=false;
                  ene.QMEDIUM=true;
                  ene.QFAC(ph2,
                           physics_consts,
                           out,mol,con,dep);
                  loc.MOV(ph2,
                          physics_consts,array_consts,energy_params,
                          region_maps,
                          opt,out,mol,con,dep,ene);
                  loc.WRT(physics_consts,residue_mappings,
                          opt,out,str,mol,con,dep,ene);
//                std::cout<<"MOV2 COMPLETED"<< std::endl;
                  GLO_WRT(aut,
                          physics_consts,residue_mappings,region_maps,
                          opt,sub,mol,con,dep,ene,def);

                  ene.RECYCLE=false;
                  ene.ethresh= (1.00e-5);
                  ene.QMEDIUM=false;
                  ene.QFAC(ph2,
                           physics_consts,
                           out,mol,con,dep);
                  ene.PHIG(ph2,
                           physics_consts,array_consts,energy_params,
                           region_maps,
                           opt,out,mol,con,dep);
//                std::cout<<"PHIE COMPLETED"<< std::endl;
                  ene.MED(ph2,med,
                          physics_consts,array_consts,energy_params,
                          opt,out,str,mol,con,dep);
//                ene.Fm= (0.00);
//                std::cout<<"MED COMPLETED"<< std::endl;
                  ene.Fm=( energy_params.fac_ps*med.Fps
                          +energy_params.fac_ss*med.Fss
                          +energy_params.fac_qd*med.Fqd
                          +energy_params.fac_uh*med.Fuh
                          +energy_params.fac_cc*med.Fcc);
                  med.Fps*=physics_consts.CAL;
                  med.Fss*=physics_consts.CAL;

                  ene.Fr*=physics_consts.CAL;
                  ene.Fe*=physics_consts.CAL;
                  ene.Fs*=physics_consts.CAL;
                  ene.Ft*=physics_consts.CAL;
                  ene.Fb*=physics_consts.CAL;
                  ene.Fh*=physics_consts.CAL;
                  ene.Fm*=physics_consts.CAL;
                  ene.Fw*=physics_consts.CAL;         //here Fw is zero
                  ene.Fp*=physics_consts.CAL;
                  ene.Fp_a*=physics_consts.CAL;
                  ene.Fp_b*=physics_consts.CAL;
                  ene.Fp_c*=physics_consts.CAL;
                  ene.Fp_d*=physics_consts.CAL;
                  ene.Fp_e*=physics_consts.CAL;

                  aut.D3[aut.iD3].f[0]=( ene.Fr +ene.Fe +ene.Fs +ene.Ft +ene.Fb
                                        +ene.Fh +ene.Fm +ene.Fg +ene.Fp);
                  aut.D3[aut.iD3].f[1]= ene.Fr;
                  aut.D3[aut.iD3].f[2]= ene.Fe;
                  aut.D3[aut.iD3].f[3]= ene.Fs;
                  aut.D3[aut.iD3].f[4]= ene.Ft;
                  aut.D3[aut.iD3].f[5]= ene.Fb;
                  aut.D3[aut.iD3].f[6]= ene.Fh;
                  aut.D3[aut.iD3].f[7]= ene.Fm;
                  aut.D3[aut.iD3].f[8]= ene.Fg;
                  aut.D3[aut.iD3].f[9]= ene.Fp;

                  if( out.SHELL ){
                     out.FILE3<< std::scientific<< std::setprecision(4);
                     int n=loc.iM2;
                     double z= std::sqrt( loc.M2[n].z/ene.nU2);
                     out.FILE3<<" steps taken="
                              << std::setw( 3)<<n
                              <<" rms of gradient="
                              << std::setw(11)<<z<<'\n';
                     out.FILE3<<"  iD3 ""   tot "
                                "   Fr  ""   Fe  ""   Fs  ""   Ft  ""   Fb  "
                                "   Fh  ""   Fm  ""   Fg  ""   Fp  "<<'\n';
                     out.FILE3<< std::fixed<< std::setprecision(1);
                     out.FILE3<< std::setw( 5)<<aut.iD3<<' '
                              << std::setw( 7)<<aut.D3[aut.iD3].f[0]
                              << std::setw( 7)<<aut.D3[aut.iD3].f[1]
                              << std::setw( 7)<<aut.D3[aut.iD3].f[2]
                              << std::setw( 7)<<aut.D3[aut.iD3].f[3]
                              << std::setw( 7)<<aut.D3[aut.iD3].f[4]
                              << std::setw( 7)<<aut.D3[aut.iD3].f[5]
                              << std::setw( 7)<<aut.D3[aut.iD3].f[6]
                              << std::setw( 7)<<aut.D3[aut.iD3].f[7]
                              << std::setw( 7)<<aut.D3[aut.iD3].f[8]
                              << std::setw( 7)<<aut.D3[aut.iD3].f[9]
                              <<'\n';
                     out.FILE3<<"   Y3iC2\n";
                     for(int iY3= 0;iY3<aut.oY3;iY3++){
                        out.FILE3<< std::setw( 4)<<aut.D3[aut.iD3].Y3iC2(iY3);
                     }
                     out.FILE3<<'\n';
                  }
               }
               out.VERBOSE=true;
               aut.CLUSTER(opt.MODE,ene.nU2);
               aut.ORDER(opt.MODE);
               GLO_STEP(aut,
                        physics_consts,residue_mappings,region_maps,
                        opt,out,str,sub,mol,con,dep,def);

               if( out.SHELL ){
                  out.FILE3<<" selected combination of rotamers=";
                  for(int iY3= 0;iY3<aut.oY3;iY3++){
                     out.FILE3<< std::setw( 4)<<aut.D3[aut.iD3].Y3iC2(iY3);
                  }
                  out.FILE3<<'\n';
               }
            }
         }
      }
   }
//______________________________________________________________________________
   {
      if( out.SHELL ){
         std::cout<<"BACKBONE +SIDE CHAIN MINIMIZATIONS"
                  << std::endl;
      }
//
//
// backbone +side chain local energy minimization
//
      opt.MODE="lp ";

      def.iD0= 0;
      GLO_DEF2STR(physics_consts,residue_mappings,
                  out,str,sub,def);
      if( out.SHELL ){
         out.FILE3<<"CONSTRUCT MECHANICAL SYSTEM"<< std::endl;
      }
      Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
      Subset_Contracted_System col(disulfide_links,residue_mappings,
                                   opt,str,sub);
      Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
      mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
              opt,str,out,dst,col,dep);
      mol.CON(physics_consts,array_consts,energy_params,
              region_maps,
              opt,out,col,dep);
      sub.MECHSYS(residue_mappings,mol);

      const Subset_Contracted_System::tM3& con=col.M3[ 0];
      int oQ2=con.oQ2;
      int oD2=0;
      int oU2=(con.oU2+6);
      int oB6=0;
      int oG6=0;
      int oD3=0;
      Glo_Automatic aut(oZ0,oQ1,oF1,oQ2,oD2,oR1,oZ2,oU2-6,oG6,oD3);
      int oF2=con.oF2;
      int oA5=con.oA5;
      Dielec_Continu med(oQ2,oF2,oA5,oR0);
      {
         med.bse_nA5=0;
      }
      int oE1=con.oE1;
      Energy_Surface4 ene(oZ0,oR0,oQ2,oF2,oE1,oB6,oG6,oU2);
      {
         ene.HBC=0;
      }
      int oM3=col.nM3;
      int oM2=2048;
      int oM4= 128;
      Local_Minimization4 loc(oM4,oM2,oM3);

      GLO_Q2(aut,
             array_consts,energy_params,
             opt,mol,con,dep,ene);
      GLO_U2(aut,
             physics_consts,residue_mappings,
             opt,def,sub,mol,con,dep,ene,loc);
      GLO_F2(aut,mol,con,dep);
      GLO_A5(aut,med,
             physics_consts,array_consts,energy_params,
             mol,con,dep);

      Phi_Automatic ph2(con);
      int cM2=800;
      if( out.SHELL ){
         out.FILE3<<"BACKBONE +SIDE CHAIN LOCAL ENERGY MINIMIZATION,"
                  << std::setw( 3)<<cM2
                  <<" STEPS, SCORE= [restbchm]\n";
      }
      out.VERBOSE=false;
      for(def.iD0= 0;def.iD0<def.nD0;def.iD0++){
         if( out.SHELL ){
            out.FILE3<<" iD0="<< std::setw( 4)<<def.iD0<<'\n';
         }
         GLO_CHI(aut,
                 physics_consts,residue_mappings,
                 opt,sub,mol,con,dep,ene,def,
                 LATTICE);
         loc.nM2=cM2;
         loc.BETA= loc.BET2;
         ene.RECYCLE=false;
         ene.QMEDIUM=true;
         ene.QFAC(ph2,
                  physics_consts,
                  out,mol,con,dep);
         loc.MOV(ph2,
                 physics_consts,array_consts,energy_params,
                 region_maps,
                 opt,out,mol,con,dep,ene);
         loc.WRT(physics_consts,residue_mappings,
                 opt,out,str,mol,con,dep,ene);
//       std::cout<<"MOV2 COMPLETED"<< std::endl;
         GLO_WRT(aut,
                 physics_consts,residue_mappings,region_maps,
                 opt,sub,mol,con,dep,ene,def);

         ene.RECYCLE=false;
         ene.ethresh= (1.00e-5);
         ene.QMEDIUM=false;
         ene.QFAC(ph2,
                  physics_consts,
                  out,mol,con,dep);
         ene.PHIG(ph2,
                  physics_consts,array_consts,energy_params,
                  region_maps,
                  opt,out,mol,con,dep);
//       std::cout<<"PHIE COMPLETED"<< std::endl;
         ene.Fr*=physics_consts.CAL;
         ene.Fe*=physics_consts.CAL;
         ene.Fs*=physics_consts.CAL;
         ene.Ft*=physics_consts.CAL;
         ene.Fc*=physics_consts.CAL;
         ene.Fb*=physics_consts.CAL;
         ene.Fh*=physics_consts.CAL;
         ene.Fw*=physics_consts.CAL;         //here Fw is zero
         ene.Fp*=physics_consts.CAL;
         ene.Fp_a*=physics_consts.CAL;
         ene.Fp_b*=physics_consts.CAL;
         ene.Fp_c*=physics_consts.CAL;
         ene.Fp_d*=physics_consts.CAL;
         ene.Fp_e*=physics_consts.CAL;
         ene.MED(ph2,med,
                 physics_consts,array_consts,energy_params,
                 opt,out,str,mol,con,dep);
//       std::cout<<"MED COMPLETED"<< std::endl;
         ene.Fm=( energy_params.fac_ps*med.Fps
                 +energy_params.fac_ss*med.Fss
                 +energy_params.fac_qd*med.Fqd
                 +energy_params.fac_uh*med.Fuh
                 +energy_params.fac_cc*med.Fcc);
         med.Fps*=physics_consts.CAL;
         med.Fss*=physics_consts.CAL;
         ene.Fm*=physics_consts.CAL;
         ene.TOT=( ene.Fr +ene.Fe +ene.Fs +ene.Ft +ene.Fc +ene.Fb +ene.Fh
                  +ene.Fm +ene.Fg +ene.Fp);
         def.D0[def.iD0].e[ 0]= ene.TOT;
         def.D0[def.iD0].e[ 1]= ene.Fr;
         def.D0[def.iD0].e[ 2]= ene.Fe;
         def.D0[def.iD0].e[ 3]= ene.Fs;
         def.D0[def.iD0].e[ 4]= ene.Ft;
         def.D0[def.iD0].e[ 5]= ene.Fc;
         def.D0[def.iD0].e[ 6]= ene.Fb;
         def.D0[def.iD0].e[ 7]= ene.Fh;
         def.D0[def.iD0].e[ 8]= ene.Fm;
         def.D0[def.iD0].e[ 9]= med.Fps;
         def.D0[def.iD0].e[10]= med.Fss;
         def.D0[def.iD0].e[11]= ene.Fg;
         def.D0[def.iD0].e[12]= ene.Fp;
         def.D0[def.iD0].e[13]= med.Qsol;
         def.D0[def.iD0].e[14]= med.Qha;
         def.D0[def.iD0].e[15]= med.Qpa;
         def.D0[def.iD0].e[16]= med.Qps;
         def.D0[def.iD0].e[17]= med.Qss;
         def.D0[def.iD0].e[18]= med.Qtq;
         def.D0[def.iD0].e[19]= med.Qfq;
         if( out.SHELL ){
            out.FILE3<< std::scientific<< std::setprecision(4);
            int n=loc.iM2;
            double z= std::sqrt( loc.M2[n].z/ene.nU2);
            out.FILE3<<" steps taken="
                     << std::setw( 3)<<n
                     <<" rms of gradient="
                     << std::setw(11)<<z<<'\n';
            out.FILE3<< std::fixed<< std::setprecision(1);
            out.FILE3<<"   tot "
                       "   Fr  ""   Fe  ""   Fs  ""   Ft  ""   Fc  "
                       "   Fb  ""   Fh  ""   Fm  ""   Fg  ""   Fp  "
                     <<'\n';
            out.FILE3<< std::setw( 7)<<ene.TOT
                     << std::setw( 7)<<ene.Fr
                     << std::setw( 7)<<ene.Fe
                     << std::setw( 7)<<ene.Fs
                     << std::setw( 7)<<ene.Ft
                     << std::setw( 7)<<ene.Fc
                     << std::setw( 7)<<ene.Fb
                     << std::setw( 7)<<ene.Fh
                     << std::setw( 7)<<ene.Fm
                     << std::setw( 7)<<ene.Fg
                     << std::setw( 7)<<ene.Fp<<'\n';
         }
      }
      out.VERBOSE=true;
      def.CLUSTER(ene.nU2);
      def.ORDER();
      def.PRINT(physics_consts,residue_mappings,region_maps,
                out,sub,opt.MODE);
      GLO_STEP(aut,
               physics_consts,residue_mappings,region_maps,
               opt,out,str,sub,mol,con,dep,def);
   }
   {
//
//
// update structure
//
      def.iD0= 0;
      GLO_DEF2STR(physics_consts,residue_mappings,
                  out,str,sub,def);
//
//
// evaluate stability of sequence
//
      Ising_Model unf(physics_consts,energy_params,str);
      double pp=( def.D0[ 0].e[ 1] +def.D0[ 0].e[ 2] +def.D0[ 0].e[ 3]
                 +def.D0[ 0].e[ 4] +def.D0[ 0].e[ 5] +def.D0[ 0].e[ 6]
                 +def.D0[ 0].e[11] +def.D0[ 0].e[12]);
      double h=  def.D0[ 0].e[ 7];
      double ps= def.D0[ 0].e[ 9];
      double ss= def.D0[ 0].e[10];
      DAT_ENERGY_PARAMS ep(physics_consts);
      double z= (energy_params.fac_ps/
                 ep.fac_ps);
      double a,b,c,d;                   //coeffs of Fpp, Fh, Fps, Fss
      a= energy_params.sta( 0)/
         energy_params.fac_pp;
      b= energy_params.sta( 1)/
         ep.fac_h;
      c= energy_params.sta( 2)/
         energy_params.fac_pp;
      d= energy_params.sta( 3)/
         energy_params.fac_pp;
      double dG=( a*pp +b*h +c*z*ps +d*z*ss -unf.G);
//
//
// output characterization of low energy structure
//
      if( out.SHELL ){
         out.FILE3<< std::fixed<< std::setprecision(2);
         out.FILE3<<"    dG  "<<'\n';
         out.FILE3<< std::setw( 8)<<dG<<'\n';
         out.FILE3<<"    Fr  "
                  <<"    Fe  "
                  <<"    Fs  "
                  <<"    Ft  "
                  <<"    Fc  "
                  <<"    Fb  "
                  <<"    Fh  "
                  <<"    Fm  "
                  <<"    Fg  "
                  <<"    Fp  "<<'\n';
         out.FILE3<< std::setw( 8)<<def.D0[ 0].e[ 1]
                  << std::setw( 8)<<def.D0[ 0].e[ 2]
                  << std::setw( 8)<<def.D0[ 0].e[ 3]
                  << std::setw( 8)<<def.D0[ 0].e[ 4]
                  << std::setw( 8)<<def.D0[ 0].e[ 5]
                  << std::setw( 8)<<def.D0[ 0].e[ 6]
                  << std::setw( 8)<<def.D0[ 0].e[ 7]
                  << std::setw( 8)<<def.D0[ 0].e[ 8]
                  << std::setw( 8)<<def.D0[ 0].e[11]
                  << std::setw( 8)<<def.D0[ 0].e[12]<<'\n';
         out.FILE3<<"  Gunf  "
                  <<"  Sunf  "
//                <<"  Qsol  "
                  <<'\n';
         out.FILE3<< std::setw( 8)<<unf.G
                  << std::setw( 8)<<unf.S
//                << std::setw( 8)<<def.D0[ 0].e[13]
                  <<'\n';
      }
//
//
// update collection of most stable sequences
//
      bool ACCEPT;
      int iM1;
      if( fam.nM1<512 ){
         ACCEPT=true;
         iM1=fam.nM1;
      }else{
         iM1=fam.M1ord(fam.nM1-1);
         if( dG<fam.M1[iM1].e[ 0] ){
            ACCEPT=true;
         }else{
            ACCEPT=false;
         }
      }
      if( ACCEPT ){
         fam.STR2FAM(iM1,str);
         fam.M1[iM1].e[ 0]= dG;
         fam.M1[iM1].e[ 1]= def.D0[ 0].e[ 1];
         fam.M1[iM1].e[ 2]= def.D0[ 0].e[ 2];
         fam.M1[iM1].e[ 3]= def.D0[ 0].e[ 3];
         fam.M1[iM1].e[ 4]= def.D0[ 0].e[ 4];
         fam.M1[iM1].e[ 5]= def.D0[ 0].e[ 5];
         fam.M1[iM1].e[ 6]= def.D0[ 0].e[ 6];
         fam.M1[iM1].e[ 7]= def.D0[ 0].e[ 7];
         fam.M1[iM1].e[ 8]= def.D0[ 0].e[ 8];
         fam.M1[iM1].e[ 9]= def.D0[ 0].e[11];
         fam.M1[iM1].e[10]= def.D0[ 0].e[12];
         fam.M1[iM1].e[11]= unf.G;
         fam.M1[iM1].e[12]= def.D0[ 0].e[13];
         fam.sort();
      }
   }

   return;
}
